; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs -global-isel < %s \
; RUN:   | FileCheck %s -check-prefix=RV32I
; RUN: llc -mtriple=riscv64 -verify-machineinstrs -enable-legalize-types-checking -global-isel < %s \
; RUN:   | FileCheck %s -check-prefix=RV64I
; RUN: llc -mtriple=riscv32 -mattr=+zbb -verify-machineinstrs -global-isel < %s \
; RUN:   | FileCheck %s -check-prefix=RV32ZBB
; RUN: llc -mtriple=riscv64 -mattr=+zbb -verify-machineinstrs -global-isel < %s \
; RUN:   | FileCheck %s -check-prefix=RV64ZBB
; RUN: llc -mtriple=riscv32 -mattr=+xtheadbb -verify-machineinstrs -global-isel < %s \
; RUN:   | FileCheck %s -check-prefix=RV32XTHEADBB
; RUN: llc -mtriple=riscv64 -mattr=+xtheadbb -verify-machineinstrs -global-isel < %s \
; RUN:   | FileCheck %s -check-prefix=RV64XTHEADBB

; NOTE: -enable-legalize-types-checking is on one command line due to a previous
; assertion failure on an expensive checks build for @rotr_32_mask_multiple.

; These IR sequences are idioms for rotates. If rotate instructions are
; supported, they will be turned into ISD::ROTL or ISD::ROTR.

define i32 @rotl_32(i32 %x, i32 %y) nounwind {
; RV32I-LABEL: rotl_32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    neg a2, a1
; RV32I-NEXT:    sll a1, a0, a1
; RV32I-NEXT:    srl a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rotl_32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    negw a2, a1
; RV64I-NEXT:    sllw a1, a0, a1
; RV64I-NEXT:    srlw a0, a0, a2
; RV64I-NEXT:    or a0, a1, a0
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: rotl_32:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    rol a0, a0, a1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: rotl_32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    rolw a0, a0, a1
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: rotl_32:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    neg a2, a1
; RV32XTHEADBB-NEXT:    sll a1, a0, a1
; RV32XTHEADBB-NEXT:    srl a0, a0, a2
; RV32XTHEADBB-NEXT:    or a0, a1, a0
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: rotl_32:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    negw a2, a1
; RV64XTHEADBB-NEXT:    sllw a1, a0, a1
; RV64XTHEADBB-NEXT:    srlw a0, a0, a2
; RV64XTHEADBB-NEXT:    or a0, a1, a0
; RV64XTHEADBB-NEXT:    ret
  %z = sub i32 32, %y
  %b = shl i32 %x, %y
  %c = lshr i32 %x, %z
  %d = or i32 %b, %c
  ret i32 %d
}

define i32 @rotr_32(i32 %x, i32 %y) nounwind {
; RV32I-LABEL: rotr_32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    neg a2, a1
; RV32I-NEXT:    srl a1, a0, a1
; RV32I-NEXT:    sll a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rotr_32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    negw a2, a1
; RV64I-NEXT:    srlw a1, a0, a1
; RV64I-NEXT:    sllw a0, a0, a2
; RV64I-NEXT:    or a0, a1, a0
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: rotr_32:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    ror a0, a0, a1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: rotr_32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    rorw a0, a0, a1
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: rotr_32:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    neg a2, a1
; RV32XTHEADBB-NEXT:    srl a1, a0, a1
; RV32XTHEADBB-NEXT:    sll a0, a0, a2
; RV32XTHEADBB-NEXT:    or a0, a1, a0
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: rotr_32:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    negw a2, a1
; RV64XTHEADBB-NEXT:    srlw a1, a0, a1
; RV64XTHEADBB-NEXT:    sllw a0, a0, a2
; RV64XTHEADBB-NEXT:    or a0, a1, a0
; RV64XTHEADBB-NEXT:    ret
  %z = sub i32 32, %y
  %b = lshr i32 %x, %y
  %c = shl i32 %x, %z
  %d = or i32 %b, %c
  ret i32 %d
}

define i64 @rotl_64(i64 %x, i64 %y) nounwind {
; RV32I-LABEL: rotl_64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    andi a6, a2, 63
; RV32I-NEXT:    li a4, 32
; RV32I-NEXT:    bltu a6, a4, .LBB2_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    sll a7, a0, a6
; RV32I-NEXT:    j .LBB2_3
; RV32I-NEXT:  .LBB2_2:
; RV32I-NEXT:    sll a3, a0, a2
; RV32I-NEXT:    neg a5, a6
; RV32I-NEXT:    srl a5, a0, a5
; RV32I-NEXT:    sll a7, a1, a2
; RV32I-NEXT:    or a7, a5, a7
; RV32I-NEXT:  .LBB2_3:
; RV32I-NEXT:    neg a5, a2
; RV32I-NEXT:    mv a2, a1
; RV32I-NEXT:    beqz a6, .LBB2_5
; RV32I-NEXT:  # %bb.4:
; RV32I-NEXT:    mv a2, a7
; RV32I-NEXT:  .LBB2_5:
; RV32I-NEXT:    andi a6, a5, 63
; RV32I-NEXT:    bltu a6, a4, .LBB2_7
; RV32I-NEXT:  # %bb.6:
; RV32I-NEXT:    srl a7, a1, a6
; RV32I-NEXT:    bnez a6, .LBB2_8
; RV32I-NEXT:    j .LBB2_9
; RV32I-NEXT:  .LBB2_7:
; RV32I-NEXT:    srl a7, a0, a5
; RV32I-NEXT:    neg t0, a6
; RV32I-NEXT:    sll t0, a1, t0
; RV32I-NEXT:    or a7, a7, t0
; RV32I-NEXT:    beqz a6, .LBB2_9
; RV32I-NEXT:  .LBB2_8:
; RV32I-NEXT:    mv a0, a7
; RV32I-NEXT:  .LBB2_9:
; RV32I-NEXT:    bltu a6, a4, .LBB2_11
; RV32I-NEXT:  # %bb.10:
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    j .LBB2_12
; RV32I-NEXT:  .LBB2_11:
; RV32I-NEXT:    srl a1, a1, a5
; RV32I-NEXT:  .LBB2_12:
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rotl_64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    negw a2, a1
; RV64I-NEXT:    sll a1, a0, a1
; RV64I-NEXT:    srl a0, a0, a2
; RV64I-NEXT:    or a0, a1, a0
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: rotl_64:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    andi a6, a2, 63
; RV32ZBB-NEXT:    li a4, 32
; RV32ZBB-NEXT:    bltu a6, a4, .LBB2_2
; RV32ZBB-NEXT:  # %bb.1:
; RV32ZBB-NEXT:    li a3, 0
; RV32ZBB-NEXT:    sll a7, a0, a6
; RV32ZBB-NEXT:    j .LBB2_3
; RV32ZBB-NEXT:  .LBB2_2:
; RV32ZBB-NEXT:    sll a3, a0, a2
; RV32ZBB-NEXT:    neg a5, a6
; RV32ZBB-NEXT:    srl a5, a0, a5
; RV32ZBB-NEXT:    sll a7, a1, a2
; RV32ZBB-NEXT:    or a7, a5, a7
; RV32ZBB-NEXT:  .LBB2_3:
; RV32ZBB-NEXT:    neg a5, a2
; RV32ZBB-NEXT:    mv a2, a1
; RV32ZBB-NEXT:    beqz a6, .LBB2_5
; RV32ZBB-NEXT:  # %bb.4:
; RV32ZBB-NEXT:    mv a2, a7
; RV32ZBB-NEXT:  .LBB2_5:
; RV32ZBB-NEXT:    andi a6, a5, 63
; RV32ZBB-NEXT:    bltu a6, a4, .LBB2_7
; RV32ZBB-NEXT:  # %bb.6:
; RV32ZBB-NEXT:    srl a7, a1, a6
; RV32ZBB-NEXT:    bnez a6, .LBB2_8
; RV32ZBB-NEXT:    j .LBB2_9
; RV32ZBB-NEXT:  .LBB2_7:
; RV32ZBB-NEXT:    srl a7, a0, a5
; RV32ZBB-NEXT:    neg t0, a6
; RV32ZBB-NEXT:    sll t0, a1, t0
; RV32ZBB-NEXT:    or a7, a7, t0
; RV32ZBB-NEXT:    beqz a6, .LBB2_9
; RV32ZBB-NEXT:  .LBB2_8:
; RV32ZBB-NEXT:    mv a0, a7
; RV32ZBB-NEXT:  .LBB2_9:
; RV32ZBB-NEXT:    bltu a6, a4, .LBB2_11
; RV32ZBB-NEXT:  # %bb.10:
; RV32ZBB-NEXT:    li a1, 0
; RV32ZBB-NEXT:    j .LBB2_12
; RV32ZBB-NEXT:  .LBB2_11:
; RV32ZBB-NEXT:    srl a1, a1, a5
; RV32ZBB-NEXT:  .LBB2_12:
; RV32ZBB-NEXT:    or a0, a3, a0
; RV32ZBB-NEXT:    or a1, a2, a1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: rotl_64:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    rol a0, a0, a1
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: rotl_64:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    andi a6, a2, 63
; RV32XTHEADBB-NEXT:    li a4, 32
; RV32XTHEADBB-NEXT:    bltu a6, a4, .LBB2_2
; RV32XTHEADBB-NEXT:  # %bb.1:
; RV32XTHEADBB-NEXT:    li a3, 0
; RV32XTHEADBB-NEXT:    sll a7, a0, a6
; RV32XTHEADBB-NEXT:    j .LBB2_3
; RV32XTHEADBB-NEXT:  .LBB2_2:
; RV32XTHEADBB-NEXT:    sll a3, a0, a2
; RV32XTHEADBB-NEXT:    neg a5, a6
; RV32XTHEADBB-NEXT:    srl a5, a0, a5
; RV32XTHEADBB-NEXT:    sll a7, a1, a2
; RV32XTHEADBB-NEXT:    or a7, a5, a7
; RV32XTHEADBB-NEXT:  .LBB2_3:
; RV32XTHEADBB-NEXT:    neg a5, a2
; RV32XTHEADBB-NEXT:    mv a2, a1
; RV32XTHEADBB-NEXT:    beqz a6, .LBB2_5
; RV32XTHEADBB-NEXT:  # %bb.4:
; RV32XTHEADBB-NEXT:    mv a2, a7
; RV32XTHEADBB-NEXT:  .LBB2_5:
; RV32XTHEADBB-NEXT:    andi a6, a5, 63
; RV32XTHEADBB-NEXT:    bltu a6, a4, .LBB2_7
; RV32XTHEADBB-NEXT:  # %bb.6:
; RV32XTHEADBB-NEXT:    srl a7, a1, a6
; RV32XTHEADBB-NEXT:    bnez a6, .LBB2_8
; RV32XTHEADBB-NEXT:    j .LBB2_9
; RV32XTHEADBB-NEXT:  .LBB2_7:
; RV32XTHEADBB-NEXT:    srl a7, a0, a5
; RV32XTHEADBB-NEXT:    neg t0, a6
; RV32XTHEADBB-NEXT:    sll t0, a1, t0
; RV32XTHEADBB-NEXT:    or a7, a7, t0
; RV32XTHEADBB-NEXT:    beqz a6, .LBB2_9
; RV32XTHEADBB-NEXT:  .LBB2_8:
; RV32XTHEADBB-NEXT:    mv a0, a7
; RV32XTHEADBB-NEXT:  .LBB2_9:
; RV32XTHEADBB-NEXT:    bltu a6, a4, .LBB2_11
; RV32XTHEADBB-NEXT:  # %bb.10:
; RV32XTHEADBB-NEXT:    li a1, 0
; RV32XTHEADBB-NEXT:    j .LBB2_12
; RV32XTHEADBB-NEXT:  .LBB2_11:
; RV32XTHEADBB-NEXT:    srl a1, a1, a5
; RV32XTHEADBB-NEXT:  .LBB2_12:
; RV32XTHEADBB-NEXT:    or a0, a3, a0
; RV32XTHEADBB-NEXT:    or a1, a2, a1
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: rotl_64:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    negw a2, a1
; RV64XTHEADBB-NEXT:    sll a1, a0, a1
; RV64XTHEADBB-NEXT:    srl a0, a0, a2
; RV64XTHEADBB-NEXT:    or a0, a1, a0
; RV64XTHEADBB-NEXT:    ret
  %z = sub i64 64, %y
  %b = shl i64 %x, %y
  %c = lshr i64 %x, %z
  %d = or i64 %b, %c
  ret i64 %d
}

define i64 @rotr_64(i64 %x, i64 %y) nounwind {
; RV32I-LABEL: rotr_64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    andi a5, a2, 63
; RV32I-NEXT:    li a4, 32
; RV32I-NEXT:    bltu a5, a4, .LBB3_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    srl a6, a1, a5
; RV32I-NEXT:    mv a3, a0
; RV32I-NEXT:    bnez a5, .LBB3_3
; RV32I-NEXT:    j .LBB3_4
; RV32I-NEXT:  .LBB3_2:
; RV32I-NEXT:    srl a3, a0, a2
; RV32I-NEXT:    neg a6, a5
; RV32I-NEXT:    sll a6, a1, a6
; RV32I-NEXT:    or a6, a3, a6
; RV32I-NEXT:    mv a3, a0
; RV32I-NEXT:    beqz a5, .LBB3_4
; RV32I-NEXT:  .LBB3_3:
; RV32I-NEXT:    mv a3, a6
; RV32I-NEXT:  .LBB3_4:
; RV32I-NEXT:    neg a6, a2
; RV32I-NEXT:    bltu a5, a4, .LBB3_7
; RV32I-NEXT:  # %bb.5:
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    andi a5, a6, 63
; RV32I-NEXT:    bgeu a5, a4, .LBB3_8
; RV32I-NEXT:  .LBB3_6:
; RV32I-NEXT:    sll a4, a0, a6
; RV32I-NEXT:    neg a7, a5
; RV32I-NEXT:    srl a0, a0, a7
; RV32I-NEXT:    sll a6, a1, a6
; RV32I-NEXT:    or a0, a0, a6
; RV32I-NEXT:    bnez a5, .LBB3_9
; RV32I-NEXT:    j .LBB3_10
; RV32I-NEXT:  .LBB3_7:
; RV32I-NEXT:    srl a2, a1, a2
; RV32I-NEXT:    andi a5, a6, 63
; RV32I-NEXT:    bltu a5, a4, .LBB3_6
; RV32I-NEXT:  .LBB3_8:
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    sll a0, a0, a5
; RV32I-NEXT:    beqz a5, .LBB3_10
; RV32I-NEXT:  .LBB3_9:
; RV32I-NEXT:    mv a1, a0
; RV32I-NEXT:  .LBB3_10:
; RV32I-NEXT:    or a0, a3, a4
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rotr_64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    negw a2, a1
; RV64I-NEXT:    srl a1, a0, a1
; RV64I-NEXT:    sll a0, a0, a2
; RV64I-NEXT:    or a0, a1, a0
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: rotr_64:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    andi a5, a2, 63
; RV32ZBB-NEXT:    li a4, 32
; RV32ZBB-NEXT:    bltu a5, a4, .LBB3_2
; RV32ZBB-NEXT:  # %bb.1:
; RV32ZBB-NEXT:    srl a6, a1, a5
; RV32ZBB-NEXT:    mv a3, a0
; RV32ZBB-NEXT:    bnez a5, .LBB3_3
; RV32ZBB-NEXT:    j .LBB3_4
; RV32ZBB-NEXT:  .LBB3_2:
; RV32ZBB-NEXT:    srl a3, a0, a2
; RV32ZBB-NEXT:    neg a6, a5
; RV32ZBB-NEXT:    sll a6, a1, a6
; RV32ZBB-NEXT:    or a6, a3, a6
; RV32ZBB-NEXT:    mv a3, a0
; RV32ZBB-NEXT:    beqz a5, .LBB3_4
; RV32ZBB-NEXT:  .LBB3_3:
; RV32ZBB-NEXT:    mv a3, a6
; RV32ZBB-NEXT:  .LBB3_4:
; RV32ZBB-NEXT:    neg a6, a2
; RV32ZBB-NEXT:    bltu a5, a4, .LBB3_7
; RV32ZBB-NEXT:  # %bb.5:
; RV32ZBB-NEXT:    li a2, 0
; RV32ZBB-NEXT:    andi a5, a6, 63
; RV32ZBB-NEXT:    bgeu a5, a4, .LBB3_8
; RV32ZBB-NEXT:  .LBB3_6:
; RV32ZBB-NEXT:    sll a4, a0, a6
; RV32ZBB-NEXT:    neg a7, a5
; RV32ZBB-NEXT:    srl a0, a0, a7
; RV32ZBB-NEXT:    sll a6, a1, a6
; RV32ZBB-NEXT:    or a0, a0, a6
; RV32ZBB-NEXT:    bnez a5, .LBB3_9
; RV32ZBB-NEXT:    j .LBB3_10
; RV32ZBB-NEXT:  .LBB3_7:
; RV32ZBB-NEXT:    srl a2, a1, a2
; RV32ZBB-NEXT:    andi a5, a6, 63
; RV32ZBB-NEXT:    bltu a5, a4, .LBB3_6
; RV32ZBB-NEXT:  .LBB3_8:
; RV32ZBB-NEXT:    li a4, 0
; RV32ZBB-NEXT:    sll a0, a0, a5
; RV32ZBB-NEXT:    beqz a5, .LBB3_10
; RV32ZBB-NEXT:  .LBB3_9:
; RV32ZBB-NEXT:    mv a1, a0
; RV32ZBB-NEXT:  .LBB3_10:
; RV32ZBB-NEXT:    or a0, a3, a4
; RV32ZBB-NEXT:    or a1, a2, a1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: rotr_64:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    ror a0, a0, a1
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: rotr_64:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    andi a5, a2, 63
; RV32XTHEADBB-NEXT:    li a4, 32
; RV32XTHEADBB-NEXT:    bltu a5, a4, .LBB3_2
; RV32XTHEADBB-NEXT:  # %bb.1:
; RV32XTHEADBB-NEXT:    srl a6, a1, a5
; RV32XTHEADBB-NEXT:    mv a3, a0
; RV32XTHEADBB-NEXT:    bnez a5, .LBB3_3
; RV32XTHEADBB-NEXT:    j .LBB3_4
; RV32XTHEADBB-NEXT:  .LBB3_2:
; RV32XTHEADBB-NEXT:    srl a3, a0, a2
; RV32XTHEADBB-NEXT:    neg a6, a5
; RV32XTHEADBB-NEXT:    sll a6, a1, a6
; RV32XTHEADBB-NEXT:    or a6, a3, a6
; RV32XTHEADBB-NEXT:    mv a3, a0
; RV32XTHEADBB-NEXT:    beqz a5, .LBB3_4
; RV32XTHEADBB-NEXT:  .LBB3_3:
; RV32XTHEADBB-NEXT:    mv a3, a6
; RV32XTHEADBB-NEXT:  .LBB3_4:
; RV32XTHEADBB-NEXT:    neg a6, a2
; RV32XTHEADBB-NEXT:    bltu a5, a4, .LBB3_7
; RV32XTHEADBB-NEXT:  # %bb.5:
; RV32XTHEADBB-NEXT:    li a2, 0
; RV32XTHEADBB-NEXT:    andi a5, a6, 63
; RV32XTHEADBB-NEXT:    bgeu a5, a4, .LBB3_8
; RV32XTHEADBB-NEXT:  .LBB3_6:
; RV32XTHEADBB-NEXT:    sll a4, a0, a6
; RV32XTHEADBB-NEXT:    neg a7, a5
; RV32XTHEADBB-NEXT:    srl a0, a0, a7
; RV32XTHEADBB-NEXT:    sll a6, a1, a6
; RV32XTHEADBB-NEXT:    or a0, a0, a6
; RV32XTHEADBB-NEXT:    bnez a5, .LBB3_9
; RV32XTHEADBB-NEXT:    j .LBB3_10
; RV32XTHEADBB-NEXT:  .LBB3_7:
; RV32XTHEADBB-NEXT:    srl a2, a1, a2
; RV32XTHEADBB-NEXT:    andi a5, a6, 63
; RV32XTHEADBB-NEXT:    bltu a5, a4, .LBB3_6
; RV32XTHEADBB-NEXT:  .LBB3_8:
; RV32XTHEADBB-NEXT:    li a4, 0
; RV32XTHEADBB-NEXT:    sll a0, a0, a5
; RV32XTHEADBB-NEXT:    beqz a5, .LBB3_10
; RV32XTHEADBB-NEXT:  .LBB3_9:
; RV32XTHEADBB-NEXT:    mv a1, a0
; RV32XTHEADBB-NEXT:  .LBB3_10:
; RV32XTHEADBB-NEXT:    or a0, a3, a4
; RV32XTHEADBB-NEXT:    or a1, a2, a1
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: rotr_64:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    negw a2, a1
; RV64XTHEADBB-NEXT:    srl a1, a0, a1
; RV64XTHEADBB-NEXT:    sll a0, a0, a2
; RV64XTHEADBB-NEXT:    or a0, a1, a0
; RV64XTHEADBB-NEXT:    ret
  %z = sub i64 64, %y
  %b = lshr i64 %x, %y
  %c = shl i64 %x, %z
  %d = or i64 %b, %c
  ret i64 %d
}

define i32 @rotl_32_mask(i32 %x, i32 %y) nounwind {
; RV32I-LABEL: rotl_32_mask:
; RV32I:       # %bb.0:
; RV32I-NEXT:    neg a2, a1
; RV32I-NEXT:    sll a1, a0, a1
; RV32I-NEXT:    srl a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rotl_32_mask:
; RV64I:       # %bb.0:
; RV64I-NEXT:    negw a2, a1
; RV64I-NEXT:    sllw a1, a0, a1
; RV64I-NEXT:    srlw a0, a0, a2
; RV64I-NEXT:    or a0, a1, a0
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: rotl_32_mask:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    neg a2, a1
; RV32ZBB-NEXT:    sll a1, a0, a1
; RV32ZBB-NEXT:    srl a0, a0, a2
; RV32ZBB-NEXT:    or a0, a1, a0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: rotl_32_mask:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    negw a2, a1
; RV64ZBB-NEXT:    sllw a1, a0, a1
; RV64ZBB-NEXT:    srlw a0, a0, a2
; RV64ZBB-NEXT:    or a0, a1, a0
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: rotl_32_mask:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    neg a2, a1
; RV32XTHEADBB-NEXT:    sll a1, a0, a1
; RV32XTHEADBB-NEXT:    srl a0, a0, a2
; RV32XTHEADBB-NEXT:    or a0, a1, a0
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: rotl_32_mask:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    negw a2, a1
; RV64XTHEADBB-NEXT:    sllw a1, a0, a1
; RV64XTHEADBB-NEXT:    srlw a0, a0, a2
; RV64XTHEADBB-NEXT:    or a0, a1, a0
; RV64XTHEADBB-NEXT:    ret
  %z = sub i32 0, %y
  %and = and i32 %z, 31
  %b = shl i32 %x, %y
  %c = lshr i32 %x, %and
  %d = or i32 %b, %c
  ret i32 %d
}

define i32 @rotl_32_mask_and_63_and_31(i32 %x, i32 %y) nounwind {
; RV32I-LABEL: rotl_32_mask_and_63_and_31:
; RV32I:       # %bb.0:
; RV32I-NEXT:    sll a2, a0, a1
; RV32I-NEXT:    neg a1, a1
; RV32I-NEXT:    srl a0, a0, a1
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rotl_32_mask_and_63_and_31:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sllw a2, a0, a1
; RV64I-NEXT:    negw a1, a1
; RV64I-NEXT:    srlw a0, a0, a1
; RV64I-NEXT:    or a0, a2, a0
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: rotl_32_mask_and_63_and_31:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    sll a2, a0, a1
; RV32ZBB-NEXT:    neg a1, a1
; RV32ZBB-NEXT:    srl a0, a0, a1
; RV32ZBB-NEXT:    or a0, a2, a0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: rotl_32_mask_and_63_and_31:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    sllw a2, a0, a1
; RV64ZBB-NEXT:    negw a1, a1
; RV64ZBB-NEXT:    srlw a0, a0, a1
; RV64ZBB-NEXT:    or a0, a2, a0
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: rotl_32_mask_and_63_and_31:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    sll a2, a0, a1
; RV32XTHEADBB-NEXT:    neg a1, a1
; RV32XTHEADBB-NEXT:    srl a0, a0, a1
; RV32XTHEADBB-NEXT:    or a0, a2, a0
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: rotl_32_mask_and_63_and_31:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    sllw a2, a0, a1
; RV64XTHEADBB-NEXT:    negw a1, a1
; RV64XTHEADBB-NEXT:    srlw a0, a0, a1
; RV64XTHEADBB-NEXT:    or a0, a2, a0
; RV64XTHEADBB-NEXT:    ret
  %a = and i32 %y, 63
  %b = shl i32 %x, %a
  %c = sub i32 0, %y
  %d = and i32 %c, 31
  %e = lshr i32 %x, %d
  %f = or i32 %b, %e
  ret i32 %f
}

define i32 @rotl_32_mask_or_64_or_32(i32 %x, i32 %y) nounwind {
; RV32I-LABEL: rotl_32_mask_or_64_or_32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ori a1, a1, 64
; RV32I-NEXT:    sll a0, a0, a1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rotl_32_mask_or_64_or_32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ori a1, a1, 64
; RV64I-NEXT:    sllw a0, a0, a1
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: rotl_32_mask_or_64_or_32:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    ori a1, a1, 64
; RV32ZBB-NEXT:    sll a0, a0, a1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: rotl_32_mask_or_64_or_32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    ori a1, a1, 64
; RV64ZBB-NEXT:    sllw a0, a0, a1
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: rotl_32_mask_or_64_or_32:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    ori a1, a1, 64
; RV32XTHEADBB-NEXT:    sll a0, a0, a1
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: rotl_32_mask_or_64_or_32:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    ori a1, a1, 64
; RV64XTHEADBB-NEXT:    sllw a0, a0, a1
; RV64XTHEADBB-NEXT:    ret
  %a = or i32 %y, 64
  %b = shl i32 %x, %a
  %c = sub i32 0, %y
  %d = or i32 %c, 32
  %e = lshr i32 %x, %d
  %f = or i32 %b, %e
  ret i32 %f
}

define i32 @rotr_32_mask(i32 %x, i32 %y) nounwind {
; RV32I-LABEL: rotr_32_mask:
; RV32I:       # %bb.0:
; RV32I-NEXT:    neg a2, a1
; RV32I-NEXT:    srl a1, a0, a1
; RV32I-NEXT:    sll a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rotr_32_mask:
; RV64I:       # %bb.0:
; RV64I-NEXT:    negw a2, a1
; RV64I-NEXT:    srlw a1, a0, a1
; RV64I-NEXT:    sllw a0, a0, a2
; RV64I-NEXT:    or a0, a1, a0
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: rotr_32_mask:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    neg a2, a1
; RV32ZBB-NEXT:    srl a1, a0, a1
; RV32ZBB-NEXT:    sll a0, a0, a2
; RV32ZBB-NEXT:    or a0, a1, a0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: rotr_32_mask:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    negw a2, a1
; RV64ZBB-NEXT:    srlw a1, a0, a1
; RV64ZBB-NEXT:    sllw a0, a0, a2
; RV64ZBB-NEXT:    or a0, a1, a0
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: rotr_32_mask:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    neg a2, a1
; RV32XTHEADBB-NEXT:    srl a1, a0, a1
; RV32XTHEADBB-NEXT:    sll a0, a0, a2
; RV32XTHEADBB-NEXT:    or a0, a1, a0
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: rotr_32_mask:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    negw a2, a1
; RV64XTHEADBB-NEXT:    srlw a1, a0, a1
; RV64XTHEADBB-NEXT:    sllw a0, a0, a2
; RV64XTHEADBB-NEXT:    or a0, a1, a0
; RV64XTHEADBB-NEXT:    ret
  %z = sub i32 0, %y
  %and = and i32 %z, 31
  %b = lshr i32 %x, %y
  %c = shl i32 %x, %and
  %d = or i32 %b, %c
  ret i32 %d
}

define i32 @rotr_32_mask_and_63_and_31(i32 %x, i32 %y) nounwind {
; RV32I-LABEL: rotr_32_mask_and_63_and_31:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srl a2, a0, a1
; RV32I-NEXT:    neg a1, a1
; RV32I-NEXT:    sll a0, a0, a1
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rotr_32_mask_and_63_and_31:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srlw a2, a0, a1
; RV64I-NEXT:    negw a1, a1
; RV64I-NEXT:    sllw a0, a0, a1
; RV64I-NEXT:    or a0, a2, a0
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: rotr_32_mask_and_63_and_31:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    srl a2, a0, a1
; RV32ZBB-NEXT:    neg a1, a1
; RV32ZBB-NEXT:    sll a0, a0, a1
; RV32ZBB-NEXT:    or a0, a2, a0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: rotr_32_mask_and_63_and_31:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    srlw a2, a0, a1
; RV64ZBB-NEXT:    negw a1, a1
; RV64ZBB-NEXT:    sllw a0, a0, a1
; RV64ZBB-NEXT:    or a0, a2, a0
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: rotr_32_mask_and_63_and_31:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    srl a2, a0, a1
; RV32XTHEADBB-NEXT:    neg a1, a1
; RV32XTHEADBB-NEXT:    sll a0, a0, a1
; RV32XTHEADBB-NEXT:    or a0, a2, a0
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: rotr_32_mask_and_63_and_31:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    srlw a2, a0, a1
; RV64XTHEADBB-NEXT:    negw a1, a1
; RV64XTHEADBB-NEXT:    sllw a0, a0, a1
; RV64XTHEADBB-NEXT:    or a0, a2, a0
; RV64XTHEADBB-NEXT:    ret
  %a = and i32 %y, 63
  %b = lshr i32 %x, %a
  %c = sub i32 0, %y
  %d = and i32 %c, 31
  %e = shl i32 %x, %d
  %f = or i32 %b, %e
  ret i32 %f
}

define i32 @rotr_32_mask_or_64_or_32(i32 %x, i32 %y) nounwind {
; RV32I-LABEL: rotr_32_mask_or_64_or_32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ori a1, a1, 64
; RV32I-NEXT:    srl a0, a0, a1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rotr_32_mask_or_64_or_32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ori a1, a1, 64
; RV64I-NEXT:    srlw a0, a0, a1
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: rotr_32_mask_or_64_or_32:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    ori a1, a1, 64
; RV32ZBB-NEXT:    srl a0, a0, a1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: rotr_32_mask_or_64_or_32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    ori a1, a1, 64
; RV64ZBB-NEXT:    srlw a0, a0, a1
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: rotr_32_mask_or_64_or_32:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    ori a1, a1, 64
; RV32XTHEADBB-NEXT:    srl a0, a0, a1
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: rotr_32_mask_or_64_or_32:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    ori a1, a1, 64
; RV64XTHEADBB-NEXT:    srlw a0, a0, a1
; RV64XTHEADBB-NEXT:    ret
  %a = or i32 %y, 64
  %b = lshr i32 %x, %a
  %c = sub i32 0, %y
  %d = or i32 %c, 32
  %e = shl i32 %x, %d
  %f = or i32 %b, %e
  ret i32 %f
}

define i64 @rotl_64_mask(i64 %x, i64 %y) nounwind {
; RV32I-LABEL: rotl_64_mask:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a5, 32
; RV32I-NEXT:    neg a4, a2
; RV32I-NEXT:    bltu a2, a5, .LBB10_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    sll t0, a0, a2
; RV32I-NEXT:    j .LBB10_3
; RV32I-NEXT:  .LBB10_2:
; RV32I-NEXT:    sll a3, a0, a2
; RV32I-NEXT:    neg a6, a2
; RV32I-NEXT:    srl a6, a0, a6
; RV32I-NEXT:    sll a7, a1, a2
; RV32I-NEXT:    or t0, a6, a7
; RV32I-NEXT:  .LBB10_3:
; RV32I-NEXT:    andi a7, a4, 63
; RV32I-NEXT:    mv a6, a1
; RV32I-NEXT:    beqz a2, .LBB10_5
; RV32I-NEXT:  # %bb.4:
; RV32I-NEXT:    mv a6, t0
; RV32I-NEXT:  .LBB10_5:
; RV32I-NEXT:    bltu a7, a5, .LBB10_7
; RV32I-NEXT:  # %bb.6:
; RV32I-NEXT:    srl a2, a1, a7
; RV32I-NEXT:    bnez a7, .LBB10_8
; RV32I-NEXT:    j .LBB10_9
; RV32I-NEXT:  .LBB10_7:
; RV32I-NEXT:    srl a2, a0, a4
; RV32I-NEXT:    neg t0, a7
; RV32I-NEXT:    sll t0, a1, t0
; RV32I-NEXT:    or a2, a2, t0
; RV32I-NEXT:    beqz a7, .LBB10_9
; RV32I-NEXT:  .LBB10_8:
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:  .LBB10_9:
; RV32I-NEXT:    bltu a7, a5, .LBB10_11
; RV32I-NEXT:  # %bb.10:
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    j .LBB10_12
; RV32I-NEXT:  .LBB10_11:
; RV32I-NEXT:    srl a1, a1, a4
; RV32I-NEXT:  .LBB10_12:
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    or a1, a6, a1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rotl_64_mask:
; RV64I:       # %bb.0:
; RV64I-NEXT:    negw a2, a1
; RV64I-NEXT:    sll a1, a0, a1
; RV64I-NEXT:    srl a0, a0, a2
; RV64I-NEXT:    or a0, a1, a0
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: rotl_64_mask:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    li a5, 32
; RV32ZBB-NEXT:    neg a4, a2
; RV32ZBB-NEXT:    bltu a2, a5, .LBB10_2
; RV32ZBB-NEXT:  # %bb.1:
; RV32ZBB-NEXT:    li a3, 0
; RV32ZBB-NEXT:    sll t0, a0, a2
; RV32ZBB-NEXT:    j .LBB10_3
; RV32ZBB-NEXT:  .LBB10_2:
; RV32ZBB-NEXT:    sll a3, a0, a2
; RV32ZBB-NEXT:    neg a6, a2
; RV32ZBB-NEXT:    srl a6, a0, a6
; RV32ZBB-NEXT:    sll a7, a1, a2
; RV32ZBB-NEXT:    or t0, a6, a7
; RV32ZBB-NEXT:  .LBB10_3:
; RV32ZBB-NEXT:    andi a7, a4, 63
; RV32ZBB-NEXT:    mv a6, a1
; RV32ZBB-NEXT:    beqz a2, .LBB10_5
; RV32ZBB-NEXT:  # %bb.4:
; RV32ZBB-NEXT:    mv a6, t0
; RV32ZBB-NEXT:  .LBB10_5:
; RV32ZBB-NEXT:    bltu a7, a5, .LBB10_7
; RV32ZBB-NEXT:  # %bb.6:
; RV32ZBB-NEXT:    srl a2, a1, a7
; RV32ZBB-NEXT:    bnez a7, .LBB10_8
; RV32ZBB-NEXT:    j .LBB10_9
; RV32ZBB-NEXT:  .LBB10_7:
; RV32ZBB-NEXT:    srl a2, a0, a4
; RV32ZBB-NEXT:    neg t0, a7
; RV32ZBB-NEXT:    sll t0, a1, t0
; RV32ZBB-NEXT:    or a2, a2, t0
; RV32ZBB-NEXT:    beqz a7, .LBB10_9
; RV32ZBB-NEXT:  .LBB10_8:
; RV32ZBB-NEXT:    mv a0, a2
; RV32ZBB-NEXT:  .LBB10_9:
; RV32ZBB-NEXT:    bltu a7, a5, .LBB10_11
; RV32ZBB-NEXT:  # %bb.10:
; RV32ZBB-NEXT:    li a1, 0
; RV32ZBB-NEXT:    j .LBB10_12
; RV32ZBB-NEXT:  .LBB10_11:
; RV32ZBB-NEXT:    srl a1, a1, a4
; RV32ZBB-NEXT:  .LBB10_12:
; RV32ZBB-NEXT:    or a0, a3, a0
; RV32ZBB-NEXT:    or a1, a6, a1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: rotl_64_mask:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    negw a2, a1
; RV64ZBB-NEXT:    sll a1, a0, a1
; RV64ZBB-NEXT:    srl a0, a0, a2
; RV64ZBB-NEXT:    or a0, a1, a0
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: rotl_64_mask:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    li a5, 32
; RV32XTHEADBB-NEXT:    neg a4, a2
; RV32XTHEADBB-NEXT:    bltu a2, a5, .LBB10_2
; RV32XTHEADBB-NEXT:  # %bb.1:
; RV32XTHEADBB-NEXT:    li a3, 0
; RV32XTHEADBB-NEXT:    sll t0, a0, a2
; RV32XTHEADBB-NEXT:    j .LBB10_3
; RV32XTHEADBB-NEXT:  .LBB10_2:
; RV32XTHEADBB-NEXT:    sll a3, a0, a2
; RV32XTHEADBB-NEXT:    neg a6, a2
; RV32XTHEADBB-NEXT:    srl a6, a0, a6
; RV32XTHEADBB-NEXT:    sll a7, a1, a2
; RV32XTHEADBB-NEXT:    or t0, a6, a7
; RV32XTHEADBB-NEXT:  .LBB10_3:
; RV32XTHEADBB-NEXT:    andi a7, a4, 63
; RV32XTHEADBB-NEXT:    mv a6, a1
; RV32XTHEADBB-NEXT:    beqz a2, .LBB10_5
; RV32XTHEADBB-NEXT:  # %bb.4:
; RV32XTHEADBB-NEXT:    mv a6, t0
; RV32XTHEADBB-NEXT:  .LBB10_5:
; RV32XTHEADBB-NEXT:    bltu a7, a5, .LBB10_7
; RV32XTHEADBB-NEXT:  # %bb.6:
; RV32XTHEADBB-NEXT:    srl a2, a1, a7
; RV32XTHEADBB-NEXT:    bnez a7, .LBB10_8
; RV32XTHEADBB-NEXT:    j .LBB10_9
; RV32XTHEADBB-NEXT:  .LBB10_7:
; RV32XTHEADBB-NEXT:    srl a2, a0, a4
; RV32XTHEADBB-NEXT:    neg t0, a7
; RV32XTHEADBB-NEXT:    sll t0, a1, t0
; RV32XTHEADBB-NEXT:    or a2, a2, t0
; RV32XTHEADBB-NEXT:    beqz a7, .LBB10_9
; RV32XTHEADBB-NEXT:  .LBB10_8:
; RV32XTHEADBB-NEXT:    mv a0, a2
; RV32XTHEADBB-NEXT:  .LBB10_9:
; RV32XTHEADBB-NEXT:    bltu a7, a5, .LBB10_11
; RV32XTHEADBB-NEXT:  # %bb.10:
; RV32XTHEADBB-NEXT:    li a1, 0
; RV32XTHEADBB-NEXT:    j .LBB10_12
; RV32XTHEADBB-NEXT:  .LBB10_11:
; RV32XTHEADBB-NEXT:    srl a1, a1, a4
; RV32XTHEADBB-NEXT:  .LBB10_12:
; RV32XTHEADBB-NEXT:    or a0, a3, a0
; RV32XTHEADBB-NEXT:    or a1, a6, a1
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: rotl_64_mask:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    negw a2, a1
; RV64XTHEADBB-NEXT:    sll a1, a0, a1
; RV64XTHEADBB-NEXT:    srl a0, a0, a2
; RV64XTHEADBB-NEXT:    or a0, a1, a0
; RV64XTHEADBB-NEXT:    ret
  %z = sub i64 0, %y
  %and = and i64 %z, 63
  %b = shl i64 %x, %y
  %c = lshr i64 %x, %and
  %d = or i64 %b, %c
  ret i64 %d
}

define i64 @rotl_64_mask_and_127_and_63(i64 %x, i64 %y) nounwind {
; RV32I-LABEL: rotl_64_mask_and_127_and_63:
; RV32I:       # %bb.0:
; RV32I-NEXT:    andi a6, a2, 127
; RV32I-NEXT:    li a4, 32
; RV32I-NEXT:    bltu a6, a4, .LBB11_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    sll a7, a0, a6
; RV32I-NEXT:    mv a5, a1
; RV32I-NEXT:    bnez a6, .LBB11_3
; RV32I-NEXT:    j .LBB11_4
; RV32I-NEXT:  .LBB11_2:
; RV32I-NEXT:    sll a3, a0, a2
; RV32I-NEXT:    neg a5, a6
; RV32I-NEXT:    srl a5, a0, a5
; RV32I-NEXT:    sll a7, a1, a2
; RV32I-NEXT:    or a7, a5, a7
; RV32I-NEXT:    mv a5, a1
; RV32I-NEXT:    beqz a6, .LBB11_4
; RV32I-NEXT:  .LBB11_3:
; RV32I-NEXT:    mv a5, a7
; RV32I-NEXT:  .LBB11_4:
; RV32I-NEXT:    neg a2, a2
; RV32I-NEXT:    andi a6, a2, 63
; RV32I-NEXT:    bltu a6, a4, .LBB11_6
; RV32I-NEXT:  # %bb.5:
; RV32I-NEXT:    srl a7, a1, a6
; RV32I-NEXT:    bnez a6, .LBB11_7
; RV32I-NEXT:    j .LBB11_8
; RV32I-NEXT:  .LBB11_6:
; RV32I-NEXT:    srl a7, a0, a2
; RV32I-NEXT:    neg t0, a6
; RV32I-NEXT:    sll t0, a1, t0
; RV32I-NEXT:    or a7, a7, t0
; RV32I-NEXT:    beqz a6, .LBB11_8
; RV32I-NEXT:  .LBB11_7:
; RV32I-NEXT:    mv a0, a7
; RV32I-NEXT:  .LBB11_8:
; RV32I-NEXT:    bltu a6, a4, .LBB11_10
; RV32I-NEXT:  # %bb.9:
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    j .LBB11_11
; RV32I-NEXT:  .LBB11_10:
; RV32I-NEXT:    srl a1, a1, a2
; RV32I-NEXT:  .LBB11_11:
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    or a1, a5, a1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rotl_64_mask_and_127_and_63:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sll a2, a0, a1
; RV64I-NEXT:    negw a1, a1
; RV64I-NEXT:    srl a0, a0, a1
; RV64I-NEXT:    or a0, a2, a0
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: rotl_64_mask_and_127_and_63:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    andi a6, a2, 127
; RV32ZBB-NEXT:    li a4, 32
; RV32ZBB-NEXT:    bltu a6, a4, .LBB11_2
; RV32ZBB-NEXT:  # %bb.1:
; RV32ZBB-NEXT:    li a3, 0
; RV32ZBB-NEXT:    sll a7, a0, a6
; RV32ZBB-NEXT:    mv a5, a1
; RV32ZBB-NEXT:    bnez a6, .LBB11_3
; RV32ZBB-NEXT:    j .LBB11_4
; RV32ZBB-NEXT:  .LBB11_2:
; RV32ZBB-NEXT:    sll a3, a0, a2
; RV32ZBB-NEXT:    neg a5, a6
; RV32ZBB-NEXT:    srl a5, a0, a5
; RV32ZBB-NEXT:    sll a7, a1, a2
; RV32ZBB-NEXT:    or a7, a5, a7
; RV32ZBB-NEXT:    mv a5, a1
; RV32ZBB-NEXT:    beqz a6, .LBB11_4
; RV32ZBB-NEXT:  .LBB11_3:
; RV32ZBB-NEXT:    mv a5, a7
; RV32ZBB-NEXT:  .LBB11_4:
; RV32ZBB-NEXT:    neg a2, a2
; RV32ZBB-NEXT:    andi a6, a2, 63
; RV32ZBB-NEXT:    bltu a6, a4, .LBB11_6
; RV32ZBB-NEXT:  # %bb.5:
; RV32ZBB-NEXT:    srl a7, a1, a6
; RV32ZBB-NEXT:    bnez a6, .LBB11_7
; RV32ZBB-NEXT:    j .LBB11_8
; RV32ZBB-NEXT:  .LBB11_6:
; RV32ZBB-NEXT:    srl a7, a0, a2
; RV32ZBB-NEXT:    neg t0, a6
; RV32ZBB-NEXT:    sll t0, a1, t0
; RV32ZBB-NEXT:    or a7, a7, t0
; RV32ZBB-NEXT:    beqz a6, .LBB11_8
; RV32ZBB-NEXT:  .LBB11_7:
; RV32ZBB-NEXT:    mv a0, a7
; RV32ZBB-NEXT:  .LBB11_8:
; RV32ZBB-NEXT:    bltu a6, a4, .LBB11_10
; RV32ZBB-NEXT:  # %bb.9:
; RV32ZBB-NEXT:    li a1, 0
; RV32ZBB-NEXT:    j .LBB11_11
; RV32ZBB-NEXT:  .LBB11_10:
; RV32ZBB-NEXT:    srl a1, a1, a2
; RV32ZBB-NEXT:  .LBB11_11:
; RV32ZBB-NEXT:    or a0, a3, a0
; RV32ZBB-NEXT:    or a1, a5, a1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: rotl_64_mask_and_127_and_63:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    sll a2, a0, a1
; RV64ZBB-NEXT:    negw a1, a1
; RV64ZBB-NEXT:    srl a0, a0, a1
; RV64ZBB-NEXT:    or a0, a2, a0
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: rotl_64_mask_and_127_and_63:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    andi a6, a2, 127
; RV32XTHEADBB-NEXT:    li a4, 32
; RV32XTHEADBB-NEXT:    bltu a6, a4, .LBB11_2
; RV32XTHEADBB-NEXT:  # %bb.1:
; RV32XTHEADBB-NEXT:    li a3, 0
; RV32XTHEADBB-NEXT:    sll a7, a0, a6
; RV32XTHEADBB-NEXT:    mv a5, a1
; RV32XTHEADBB-NEXT:    bnez a6, .LBB11_3
; RV32XTHEADBB-NEXT:    j .LBB11_4
; RV32XTHEADBB-NEXT:  .LBB11_2:
; RV32XTHEADBB-NEXT:    sll a3, a0, a2
; RV32XTHEADBB-NEXT:    neg a5, a6
; RV32XTHEADBB-NEXT:    srl a5, a0, a5
; RV32XTHEADBB-NEXT:    sll a7, a1, a2
; RV32XTHEADBB-NEXT:    or a7, a5, a7
; RV32XTHEADBB-NEXT:    mv a5, a1
; RV32XTHEADBB-NEXT:    beqz a6, .LBB11_4
; RV32XTHEADBB-NEXT:  .LBB11_3:
; RV32XTHEADBB-NEXT:    mv a5, a7
; RV32XTHEADBB-NEXT:  .LBB11_4:
; RV32XTHEADBB-NEXT:    neg a2, a2
; RV32XTHEADBB-NEXT:    andi a6, a2, 63
; RV32XTHEADBB-NEXT:    bltu a6, a4, .LBB11_6
; RV32XTHEADBB-NEXT:  # %bb.5:
; RV32XTHEADBB-NEXT:    srl a7, a1, a6
; RV32XTHEADBB-NEXT:    bnez a6, .LBB11_7
; RV32XTHEADBB-NEXT:    j .LBB11_8
; RV32XTHEADBB-NEXT:  .LBB11_6:
; RV32XTHEADBB-NEXT:    srl a7, a0, a2
; RV32XTHEADBB-NEXT:    neg t0, a6
; RV32XTHEADBB-NEXT:    sll t0, a1, t0
; RV32XTHEADBB-NEXT:    or a7, a7, t0
; RV32XTHEADBB-NEXT:    beqz a6, .LBB11_8
; RV32XTHEADBB-NEXT:  .LBB11_7:
; RV32XTHEADBB-NEXT:    mv a0, a7
; RV32XTHEADBB-NEXT:  .LBB11_8:
; RV32XTHEADBB-NEXT:    bltu a6, a4, .LBB11_10
; RV32XTHEADBB-NEXT:  # %bb.9:
; RV32XTHEADBB-NEXT:    li a1, 0
; RV32XTHEADBB-NEXT:    j .LBB11_11
; RV32XTHEADBB-NEXT:  .LBB11_10:
; RV32XTHEADBB-NEXT:    srl a1, a1, a2
; RV32XTHEADBB-NEXT:  .LBB11_11:
; RV32XTHEADBB-NEXT:    or a0, a3, a0
; RV32XTHEADBB-NEXT:    or a1, a5, a1
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: rotl_64_mask_and_127_and_63:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    sll a2, a0, a1
; RV64XTHEADBB-NEXT:    negw a1, a1
; RV64XTHEADBB-NEXT:    srl a0, a0, a1
; RV64XTHEADBB-NEXT:    or a0, a2, a0
; RV64XTHEADBB-NEXT:    ret
  %a = and i64 %y, 127
  %b = shl i64 %x, %a
  %c = sub i64 0, %y
  %d = and i64 %c, 63
  %e = lshr i64 %x, %d
  %f = or i64 %b, %e
  ret i64 %f
}

define i64 @rotl_64_mask_or_128_or_64(i64 %x, i64 %y) nounwind {
; RV32I-LABEL: rotl_64_mask_or_128_or_64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    mv a3, a0
; RV32I-NEXT:    ori a2, a2, 128
; RV32I-NEXT:    li a0, 32
; RV32I-NEXT:    bltu a2, a0, .LBB12_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    li a0, 0
; RV32I-NEXT:    sll a3, a3, a2
; RV32I-NEXT:    bnez a2, .LBB12_3
; RV32I-NEXT:    j .LBB12_4
; RV32I-NEXT:  .LBB12_2:
; RV32I-NEXT:    sll a0, a3, a2
; RV32I-NEXT:    neg a4, a2
; RV32I-NEXT:    srl a3, a3, a4
; RV32I-NEXT:    sll a4, a1, a2
; RV32I-NEXT:    or a3, a3, a4
; RV32I-NEXT:    beqz a2, .LBB12_4
; RV32I-NEXT:  .LBB12_3:
; RV32I-NEXT:    mv a1, a3
; RV32I-NEXT:  .LBB12_4:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rotl_64_mask_or_128_or_64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ori a1, a1, 128
; RV64I-NEXT:    sll a0, a0, a1
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: rotl_64_mask_or_128_or_64:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    mv a3, a0
; RV32ZBB-NEXT:    ori a2, a2, 128
; RV32ZBB-NEXT:    li a0, 32
; RV32ZBB-NEXT:    bltu a2, a0, .LBB12_2
; RV32ZBB-NEXT:  # %bb.1:
; RV32ZBB-NEXT:    li a0, 0
; RV32ZBB-NEXT:    sll a3, a3, a2
; RV32ZBB-NEXT:    bnez a2, .LBB12_3
; RV32ZBB-NEXT:    j .LBB12_4
; RV32ZBB-NEXT:  .LBB12_2:
; RV32ZBB-NEXT:    sll a0, a3, a2
; RV32ZBB-NEXT:    neg a4, a2
; RV32ZBB-NEXT:    srl a3, a3, a4
; RV32ZBB-NEXT:    sll a4, a1, a2
; RV32ZBB-NEXT:    or a3, a3, a4
; RV32ZBB-NEXT:    beqz a2, .LBB12_4
; RV32ZBB-NEXT:  .LBB12_3:
; RV32ZBB-NEXT:    mv a1, a3
; RV32ZBB-NEXT:  .LBB12_4:
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: rotl_64_mask_or_128_or_64:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    ori a1, a1, 128
; RV64ZBB-NEXT:    sll a0, a0, a1
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: rotl_64_mask_or_128_or_64:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    mv a3, a0
; RV32XTHEADBB-NEXT:    ori a2, a2, 128
; RV32XTHEADBB-NEXT:    li a0, 32
; RV32XTHEADBB-NEXT:    bltu a2, a0, .LBB12_2
; RV32XTHEADBB-NEXT:  # %bb.1:
; RV32XTHEADBB-NEXT:    li a0, 0
; RV32XTHEADBB-NEXT:    sll a3, a3, a2
; RV32XTHEADBB-NEXT:    bnez a2, .LBB12_3
; RV32XTHEADBB-NEXT:    j .LBB12_4
; RV32XTHEADBB-NEXT:  .LBB12_2:
; RV32XTHEADBB-NEXT:    sll a0, a3, a2
; RV32XTHEADBB-NEXT:    neg a4, a2
; RV32XTHEADBB-NEXT:    srl a3, a3, a4
; RV32XTHEADBB-NEXT:    sll a4, a1, a2
; RV32XTHEADBB-NEXT:    or a3, a3, a4
; RV32XTHEADBB-NEXT:    beqz a2, .LBB12_4
; RV32XTHEADBB-NEXT:  .LBB12_3:
; RV32XTHEADBB-NEXT:    mv a1, a3
; RV32XTHEADBB-NEXT:  .LBB12_4:
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: rotl_64_mask_or_128_or_64:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    ori a1, a1, 128
; RV64XTHEADBB-NEXT:    sll a0, a0, a1
; RV64XTHEADBB-NEXT:    ret
  %a = or i64 %y, 128
  %b = shl i64 %x, %a
  %c = sub i64 0, %y
  %d = or i64 %c, 64
  %e = lshr i64 %x, %d
  %f = or i64 %b, %e
  ret i64 %f
}

define i64 @rotr_64_mask(i64 %x, i64 %y) nounwind {
; RV32I-LABEL: rotr_64_mask:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a4, 32
; RV32I-NEXT:    bltu a2, a4, .LBB13_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    srl a5, a1, a2
; RV32I-NEXT:    j .LBB13_3
; RV32I-NEXT:  .LBB13_2:
; RV32I-NEXT:    srl a3, a0, a2
; RV32I-NEXT:    neg a5, a2
; RV32I-NEXT:    sll a5, a1, a5
; RV32I-NEXT:    or a5, a3, a5
; RV32I-NEXT:  .LBB13_3:
; RV32I-NEXT:    neg a6, a2
; RV32I-NEXT:    mv a3, a0
; RV32I-NEXT:    beqz a2, .LBB13_5
; RV32I-NEXT:  # %bb.4:
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:  .LBB13_5:
; RV32I-NEXT:    andi a5, a6, 63
; RV32I-NEXT:    bltu a2, a4, .LBB13_8
; RV32I-NEXT:  # %bb.6:
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    bgeu a5, a4, .LBB13_9
; RV32I-NEXT:  .LBB13_7:
; RV32I-NEXT:    sll a4, a0, a6
; RV32I-NEXT:    neg a7, a5
; RV32I-NEXT:    srl a0, a0, a7
; RV32I-NEXT:    sll a6, a1, a6
; RV32I-NEXT:    or a0, a0, a6
; RV32I-NEXT:    bnez a5, .LBB13_10
; RV32I-NEXT:    j .LBB13_11
; RV32I-NEXT:  .LBB13_8:
; RV32I-NEXT:    srl a2, a1, a2
; RV32I-NEXT:    bltu a5, a4, .LBB13_7
; RV32I-NEXT:  .LBB13_9:
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    sll a0, a0, a5
; RV32I-NEXT:    beqz a5, .LBB13_11
; RV32I-NEXT:  .LBB13_10:
; RV32I-NEXT:    mv a1, a0
; RV32I-NEXT:  .LBB13_11:
; RV32I-NEXT:    or a0, a3, a4
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rotr_64_mask:
; RV64I:       # %bb.0:
; RV64I-NEXT:    negw a2, a1
; RV64I-NEXT:    srl a1, a0, a1
; RV64I-NEXT:    sll a0, a0, a2
; RV64I-NEXT:    or a0, a1, a0
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: rotr_64_mask:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    li a4, 32
; RV32ZBB-NEXT:    bltu a2, a4, .LBB13_2
; RV32ZBB-NEXT:  # %bb.1:
; RV32ZBB-NEXT:    srl a5, a1, a2
; RV32ZBB-NEXT:    j .LBB13_3
; RV32ZBB-NEXT:  .LBB13_2:
; RV32ZBB-NEXT:    srl a3, a0, a2
; RV32ZBB-NEXT:    neg a5, a2
; RV32ZBB-NEXT:    sll a5, a1, a5
; RV32ZBB-NEXT:    or a5, a3, a5
; RV32ZBB-NEXT:  .LBB13_3:
; RV32ZBB-NEXT:    neg a6, a2
; RV32ZBB-NEXT:    mv a3, a0
; RV32ZBB-NEXT:    beqz a2, .LBB13_5
; RV32ZBB-NEXT:  # %bb.4:
; RV32ZBB-NEXT:    mv a3, a5
; RV32ZBB-NEXT:  .LBB13_5:
; RV32ZBB-NEXT:    andi a5, a6, 63
; RV32ZBB-NEXT:    bltu a2, a4, .LBB13_8
; RV32ZBB-NEXT:  # %bb.6:
; RV32ZBB-NEXT:    li a2, 0
; RV32ZBB-NEXT:    bgeu a5, a4, .LBB13_9
; RV32ZBB-NEXT:  .LBB13_7:
; RV32ZBB-NEXT:    sll a4, a0, a6
; RV32ZBB-NEXT:    neg a7, a5
; RV32ZBB-NEXT:    srl a0, a0, a7
; RV32ZBB-NEXT:    sll a6, a1, a6
; RV32ZBB-NEXT:    or a0, a0, a6
; RV32ZBB-NEXT:    bnez a5, .LBB13_10
; RV32ZBB-NEXT:    j .LBB13_11
; RV32ZBB-NEXT:  .LBB13_8:
; RV32ZBB-NEXT:    srl a2, a1, a2
; RV32ZBB-NEXT:    bltu a5, a4, .LBB13_7
; RV32ZBB-NEXT:  .LBB13_9:
; RV32ZBB-NEXT:    li a4, 0
; RV32ZBB-NEXT:    sll a0, a0, a5
; RV32ZBB-NEXT:    beqz a5, .LBB13_11
; RV32ZBB-NEXT:  .LBB13_10:
; RV32ZBB-NEXT:    mv a1, a0
; RV32ZBB-NEXT:  .LBB13_11:
; RV32ZBB-NEXT:    or a0, a3, a4
; RV32ZBB-NEXT:    or a1, a2, a1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: rotr_64_mask:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    negw a2, a1
; RV64ZBB-NEXT:    srl a1, a0, a1
; RV64ZBB-NEXT:    sll a0, a0, a2
; RV64ZBB-NEXT:    or a0, a1, a0
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: rotr_64_mask:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    li a4, 32
; RV32XTHEADBB-NEXT:    bltu a2, a4, .LBB13_2
; RV32XTHEADBB-NEXT:  # %bb.1:
; RV32XTHEADBB-NEXT:    srl a5, a1, a2
; RV32XTHEADBB-NEXT:    j .LBB13_3
; RV32XTHEADBB-NEXT:  .LBB13_2:
; RV32XTHEADBB-NEXT:    srl a3, a0, a2
; RV32XTHEADBB-NEXT:    neg a5, a2
; RV32XTHEADBB-NEXT:    sll a5, a1, a5
; RV32XTHEADBB-NEXT:    or a5, a3, a5
; RV32XTHEADBB-NEXT:  .LBB13_3:
; RV32XTHEADBB-NEXT:    neg a6, a2
; RV32XTHEADBB-NEXT:    mv a3, a0
; RV32XTHEADBB-NEXT:    beqz a2, .LBB13_5
; RV32XTHEADBB-NEXT:  # %bb.4:
; RV32XTHEADBB-NEXT:    mv a3, a5
; RV32XTHEADBB-NEXT:  .LBB13_5:
; RV32XTHEADBB-NEXT:    andi a5, a6, 63
; RV32XTHEADBB-NEXT:    bltu a2, a4, .LBB13_8
; RV32XTHEADBB-NEXT:  # %bb.6:
; RV32XTHEADBB-NEXT:    li a2, 0
; RV32XTHEADBB-NEXT:    bgeu a5, a4, .LBB13_9
; RV32XTHEADBB-NEXT:  .LBB13_7:
; RV32XTHEADBB-NEXT:    sll a4, a0, a6
; RV32XTHEADBB-NEXT:    neg a7, a5
; RV32XTHEADBB-NEXT:    srl a0, a0, a7
; RV32XTHEADBB-NEXT:    sll a6, a1, a6
; RV32XTHEADBB-NEXT:    or a0, a0, a6
; RV32XTHEADBB-NEXT:    bnez a5, .LBB13_10
; RV32XTHEADBB-NEXT:    j .LBB13_11
; RV32XTHEADBB-NEXT:  .LBB13_8:
; RV32XTHEADBB-NEXT:    srl a2, a1, a2
; RV32XTHEADBB-NEXT:    bltu a5, a4, .LBB13_7
; RV32XTHEADBB-NEXT:  .LBB13_9:
; RV32XTHEADBB-NEXT:    li a4, 0
; RV32XTHEADBB-NEXT:    sll a0, a0, a5
; RV32XTHEADBB-NEXT:    beqz a5, .LBB13_11
; RV32XTHEADBB-NEXT:  .LBB13_10:
; RV32XTHEADBB-NEXT:    mv a1, a0
; RV32XTHEADBB-NEXT:  .LBB13_11:
; RV32XTHEADBB-NEXT:    or a0, a3, a4
; RV32XTHEADBB-NEXT:    or a1, a2, a1
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: rotr_64_mask:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    negw a2, a1
; RV64XTHEADBB-NEXT:    srl a1, a0, a1
; RV64XTHEADBB-NEXT:    sll a0, a0, a2
; RV64XTHEADBB-NEXT:    or a0, a1, a0
; RV64XTHEADBB-NEXT:    ret
  %z = sub i64 0, %y
  %and = and i64 %z, 63
  %b = lshr i64 %x, %y
  %c = shl i64 %x, %and
  %d = or i64 %b, %c
  ret i64 %d
}

define i64 @rotr_64_mask_and_127_and_63(i64 %x, i64 %y) nounwind {
; RV32I-LABEL: rotr_64_mask_and_127_and_63:
; RV32I:       # %bb.0:
; RV32I-NEXT:    andi a4, a2, 127
; RV32I-NEXT:    li a5, 32
; RV32I-NEXT:    bltu a4, a5, .LBB14_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    srl a6, a1, a4
; RV32I-NEXT:    mv a3, a0
; RV32I-NEXT:    bnez a4, .LBB14_3
; RV32I-NEXT:    j .LBB14_4
; RV32I-NEXT:  .LBB14_2:
; RV32I-NEXT:    srl a3, a0, a2
; RV32I-NEXT:    neg a6, a4
; RV32I-NEXT:    sll a6, a1, a6
; RV32I-NEXT:    or a6, a3, a6
; RV32I-NEXT:    mv a3, a0
; RV32I-NEXT:    beqz a4, .LBB14_4
; RV32I-NEXT:  .LBB14_3:
; RV32I-NEXT:    mv a3, a6
; RV32I-NEXT:  .LBB14_4:
; RV32I-NEXT:    bltu a4, a5, .LBB14_6
; RV32I-NEXT:  # %bb.5:
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    j .LBB14_7
; RV32I-NEXT:  .LBB14_6:
; RV32I-NEXT:    srl a4, a1, a2
; RV32I-NEXT:  .LBB14_7:
; RV32I-NEXT:    neg a7, a2
; RV32I-NEXT:    andi a6, a7, 63
; RV32I-NEXT:    bltu a6, a5, .LBB14_9
; RV32I-NEXT:  # %bb.8:
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    sll a0, a0, a6
; RV32I-NEXT:    bnez a6, .LBB14_10
; RV32I-NEXT:    j .LBB14_11
; RV32I-NEXT:  .LBB14_9:
; RV32I-NEXT:    sll a2, a0, a7
; RV32I-NEXT:    neg a5, a6
; RV32I-NEXT:    srl a0, a0, a5
; RV32I-NEXT:    sll a5, a1, a7
; RV32I-NEXT:    or a0, a0, a5
; RV32I-NEXT:    beqz a6, .LBB14_11
; RV32I-NEXT:  .LBB14_10:
; RV32I-NEXT:    mv a1, a0
; RV32I-NEXT:  .LBB14_11:
; RV32I-NEXT:    or a0, a3, a2
; RV32I-NEXT:    or a1, a4, a1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rotr_64_mask_and_127_and_63:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srl a2, a0, a1
; RV64I-NEXT:    negw a1, a1
; RV64I-NEXT:    sll a0, a0, a1
; RV64I-NEXT:    or a0, a2, a0
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: rotr_64_mask_and_127_and_63:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    andi a4, a2, 127
; RV32ZBB-NEXT:    li a5, 32
; RV32ZBB-NEXT:    bltu a4, a5, .LBB14_2
; RV32ZBB-NEXT:  # %bb.1:
; RV32ZBB-NEXT:    srl a6, a1, a4
; RV32ZBB-NEXT:    mv a3, a0
; RV32ZBB-NEXT:    bnez a4, .LBB14_3
; RV32ZBB-NEXT:    j .LBB14_4
; RV32ZBB-NEXT:  .LBB14_2:
; RV32ZBB-NEXT:    srl a3, a0, a2
; RV32ZBB-NEXT:    neg a6, a4
; RV32ZBB-NEXT:    sll a6, a1, a6
; RV32ZBB-NEXT:    or a6, a3, a6
; RV32ZBB-NEXT:    mv a3, a0
; RV32ZBB-NEXT:    beqz a4, .LBB14_4
; RV32ZBB-NEXT:  .LBB14_3:
; RV32ZBB-NEXT:    mv a3, a6
; RV32ZBB-NEXT:  .LBB14_4:
; RV32ZBB-NEXT:    bltu a4, a5, .LBB14_6
; RV32ZBB-NEXT:  # %bb.5:
; RV32ZBB-NEXT:    li a4, 0
; RV32ZBB-NEXT:    j .LBB14_7
; RV32ZBB-NEXT:  .LBB14_6:
; RV32ZBB-NEXT:    srl a4, a1, a2
; RV32ZBB-NEXT:  .LBB14_7:
; RV32ZBB-NEXT:    neg a7, a2
; RV32ZBB-NEXT:    andi a6, a7, 63
; RV32ZBB-NEXT:    bltu a6, a5, .LBB14_9
; RV32ZBB-NEXT:  # %bb.8:
; RV32ZBB-NEXT:    li a2, 0
; RV32ZBB-NEXT:    sll a0, a0, a6
; RV32ZBB-NEXT:    bnez a6, .LBB14_10
; RV32ZBB-NEXT:    j .LBB14_11
; RV32ZBB-NEXT:  .LBB14_9:
; RV32ZBB-NEXT:    sll a2, a0, a7
; RV32ZBB-NEXT:    neg a5, a6
; RV32ZBB-NEXT:    srl a0, a0, a5
; RV32ZBB-NEXT:    sll a5, a1, a7
; RV32ZBB-NEXT:    or a0, a0, a5
; RV32ZBB-NEXT:    beqz a6, .LBB14_11
; RV32ZBB-NEXT:  .LBB14_10:
; RV32ZBB-NEXT:    mv a1, a0
; RV32ZBB-NEXT:  .LBB14_11:
; RV32ZBB-NEXT:    or a0, a3, a2
; RV32ZBB-NEXT:    or a1, a4, a1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: rotr_64_mask_and_127_and_63:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    srl a2, a0, a1
; RV64ZBB-NEXT:    negw a1, a1
; RV64ZBB-NEXT:    sll a0, a0, a1
; RV64ZBB-NEXT:    or a0, a2, a0
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: rotr_64_mask_and_127_and_63:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    andi a4, a2, 127
; RV32XTHEADBB-NEXT:    li a5, 32
; RV32XTHEADBB-NEXT:    bltu a4, a5, .LBB14_2
; RV32XTHEADBB-NEXT:  # %bb.1:
; RV32XTHEADBB-NEXT:    srl a6, a1, a4
; RV32XTHEADBB-NEXT:    mv a3, a0
; RV32XTHEADBB-NEXT:    bnez a4, .LBB14_3
; RV32XTHEADBB-NEXT:    j .LBB14_4
; RV32XTHEADBB-NEXT:  .LBB14_2:
; RV32XTHEADBB-NEXT:    srl a3, a0, a2
; RV32XTHEADBB-NEXT:    neg a6, a4
; RV32XTHEADBB-NEXT:    sll a6, a1, a6
; RV32XTHEADBB-NEXT:    or a6, a3, a6
; RV32XTHEADBB-NEXT:    mv a3, a0
; RV32XTHEADBB-NEXT:    beqz a4, .LBB14_4
; RV32XTHEADBB-NEXT:  .LBB14_3:
; RV32XTHEADBB-NEXT:    mv a3, a6
; RV32XTHEADBB-NEXT:  .LBB14_4:
; RV32XTHEADBB-NEXT:    bltu a4, a5, .LBB14_6
; RV32XTHEADBB-NEXT:  # %bb.5:
; RV32XTHEADBB-NEXT:    li a4, 0
; RV32XTHEADBB-NEXT:    j .LBB14_7
; RV32XTHEADBB-NEXT:  .LBB14_6:
; RV32XTHEADBB-NEXT:    srl a4, a1, a2
; RV32XTHEADBB-NEXT:  .LBB14_7:
; RV32XTHEADBB-NEXT:    neg a7, a2
; RV32XTHEADBB-NEXT:    andi a6, a7, 63
; RV32XTHEADBB-NEXT:    bltu a6, a5, .LBB14_9
; RV32XTHEADBB-NEXT:  # %bb.8:
; RV32XTHEADBB-NEXT:    li a2, 0
; RV32XTHEADBB-NEXT:    sll a0, a0, a6
; RV32XTHEADBB-NEXT:    bnez a6, .LBB14_10
; RV32XTHEADBB-NEXT:    j .LBB14_11
; RV32XTHEADBB-NEXT:  .LBB14_9:
; RV32XTHEADBB-NEXT:    sll a2, a0, a7
; RV32XTHEADBB-NEXT:    neg a5, a6
; RV32XTHEADBB-NEXT:    srl a0, a0, a5
; RV32XTHEADBB-NEXT:    sll a5, a1, a7
; RV32XTHEADBB-NEXT:    or a0, a0, a5
; RV32XTHEADBB-NEXT:    beqz a6, .LBB14_11
; RV32XTHEADBB-NEXT:  .LBB14_10:
; RV32XTHEADBB-NEXT:    mv a1, a0
; RV32XTHEADBB-NEXT:  .LBB14_11:
; RV32XTHEADBB-NEXT:    or a0, a3, a2
; RV32XTHEADBB-NEXT:    or a1, a4, a1
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: rotr_64_mask_and_127_and_63:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    srl a2, a0, a1
; RV64XTHEADBB-NEXT:    negw a1, a1
; RV64XTHEADBB-NEXT:    sll a0, a0, a1
; RV64XTHEADBB-NEXT:    or a0, a2, a0
; RV64XTHEADBB-NEXT:    ret
  %a = and i64 %y, 127
  %b = lshr i64 %x, %a
  %c = sub i64 0, %y
  %d = and i64 %c, 63
  %e = shl i64 %x, %d
  %f = or i64 %b, %e
  ret i64 %f
}

define i64 @rotr_64_mask_or_128_or_64(i64 %x, i64 %y) nounwind {
; RV32I-LABEL: rotr_64_mask_or_128_or_64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ori a2, a2, 128
; RV32I-NEXT:    li a3, 32
; RV32I-NEXT:    bltu a2, a3, .LBB15_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    srl a4, a1, a2
; RV32I-NEXT:    bnez a2, .LBB15_3
; RV32I-NEXT:    j .LBB15_4
; RV32I-NEXT:  .LBB15_2:
; RV32I-NEXT:    srl a4, a0, a2
; RV32I-NEXT:    neg a5, a2
; RV32I-NEXT:    sll a5, a1, a5
; RV32I-NEXT:    or a4, a4, a5
; RV32I-NEXT:    beqz a2, .LBB15_4
; RV32I-NEXT:  .LBB15_3:
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:  .LBB15_4:
; RV32I-NEXT:    bltu a2, a3, .LBB15_6
; RV32I-NEXT:  # %bb.5:
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB15_6:
; RV32I-NEXT:    srl a1, a1, a2
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rotr_64_mask_or_128_or_64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ori a1, a1, 128
; RV64I-NEXT:    srl a0, a0, a1
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: rotr_64_mask_or_128_or_64:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    ori a2, a2, 128
; RV32ZBB-NEXT:    li a3, 32
; RV32ZBB-NEXT:    bltu a2, a3, .LBB15_2
; RV32ZBB-NEXT:  # %bb.1:
; RV32ZBB-NEXT:    srl a4, a1, a2
; RV32ZBB-NEXT:    bnez a2, .LBB15_3
; RV32ZBB-NEXT:    j .LBB15_4
; RV32ZBB-NEXT:  .LBB15_2:
; RV32ZBB-NEXT:    srl a4, a0, a2
; RV32ZBB-NEXT:    neg a5, a2
; RV32ZBB-NEXT:    sll a5, a1, a5
; RV32ZBB-NEXT:    or a4, a4, a5
; RV32ZBB-NEXT:    beqz a2, .LBB15_4
; RV32ZBB-NEXT:  .LBB15_3:
; RV32ZBB-NEXT:    mv a0, a4
; RV32ZBB-NEXT:  .LBB15_4:
; RV32ZBB-NEXT:    bltu a2, a3, .LBB15_6
; RV32ZBB-NEXT:  # %bb.5:
; RV32ZBB-NEXT:    li a1, 0
; RV32ZBB-NEXT:    ret
; RV32ZBB-NEXT:  .LBB15_6:
; RV32ZBB-NEXT:    srl a1, a1, a2
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: rotr_64_mask_or_128_or_64:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    ori a1, a1, 128
; RV64ZBB-NEXT:    srl a0, a0, a1
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: rotr_64_mask_or_128_or_64:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    ori a2, a2, 128
; RV32XTHEADBB-NEXT:    li a3, 32
; RV32XTHEADBB-NEXT:    bltu a2, a3, .LBB15_2
; RV32XTHEADBB-NEXT:  # %bb.1:
; RV32XTHEADBB-NEXT:    srl a4, a1, a2
; RV32XTHEADBB-NEXT:    bnez a2, .LBB15_3
; RV32XTHEADBB-NEXT:    j .LBB15_4
; RV32XTHEADBB-NEXT:  .LBB15_2:
; RV32XTHEADBB-NEXT:    srl a4, a0, a2
; RV32XTHEADBB-NEXT:    neg a5, a2
; RV32XTHEADBB-NEXT:    sll a5, a1, a5
; RV32XTHEADBB-NEXT:    or a4, a4, a5
; RV32XTHEADBB-NEXT:    beqz a2, .LBB15_4
; RV32XTHEADBB-NEXT:  .LBB15_3:
; RV32XTHEADBB-NEXT:    mv a0, a4
; RV32XTHEADBB-NEXT:  .LBB15_4:
; RV32XTHEADBB-NEXT:    bltu a2, a3, .LBB15_6
; RV32XTHEADBB-NEXT:  # %bb.5:
; RV32XTHEADBB-NEXT:    li a1, 0
; RV32XTHEADBB-NEXT:    ret
; RV32XTHEADBB-NEXT:  .LBB15_6:
; RV32XTHEADBB-NEXT:    srl a1, a1, a2
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: rotr_64_mask_or_128_or_64:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    ori a1, a1, 128
; RV64XTHEADBB-NEXT:    srl a0, a0, a1
; RV64XTHEADBB-NEXT:    ret
  %a = or i64 %y, 128
  %b = lshr i64 %x, %a
  %c = sub i64 0, %y
  %d = or i64 %c, 64
  %e = shl i64 %x, %d
  %f = or i64 %b, %e
  ret i64 %f
}

; Test that we're able to remove a mask on the rotate amount that has more than
; one use.
define signext i32 @rotl_32_mask_shared(i32 signext %a, i32 signext %b, i32 signext %amt) nounwind {
; RV32I-LABEL: rotl_32_mask_shared:
; RV32I:       # %bb.0:
; RV32I-NEXT:    andi a3, a2, 31
; RV32I-NEXT:    sll a4, a0, a2
; RV32I-NEXT:    neg a3, a3
; RV32I-NEXT:    srl a0, a0, a3
; RV32I-NEXT:    or a0, a4, a0
; RV32I-NEXT:    sll a1, a1, a2
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rotl_32_mask_shared:
; RV64I:       # %bb.0:
; RV64I-NEXT:    andi a3, a2, 31
; RV64I-NEXT:    sllw a4, a0, a2
; RV64I-NEXT:    negw a3, a3
; RV64I-NEXT:    srlw a0, a0, a3
; RV64I-NEXT:    or a0, a4, a0
; RV64I-NEXT:    sllw a1, a1, a2
; RV64I-NEXT:    addw a0, a0, a1
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: rotl_32_mask_shared:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    rol a0, a0, a2
; RV32ZBB-NEXT:    sll a1, a1, a2
; RV32ZBB-NEXT:    add a0, a0, a1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: rotl_32_mask_shared:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    rolw a0, a0, a2
; RV64ZBB-NEXT:    sllw a1, a1, a2
; RV64ZBB-NEXT:    addw a0, a0, a1
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: rotl_32_mask_shared:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    andi a3, a2, 31
; RV32XTHEADBB-NEXT:    sll a4, a0, a2
; RV32XTHEADBB-NEXT:    neg a3, a3
; RV32XTHEADBB-NEXT:    srl a0, a0, a3
; RV32XTHEADBB-NEXT:    or a0, a4, a0
; RV32XTHEADBB-NEXT:    sll a1, a1, a2
; RV32XTHEADBB-NEXT:    add a0, a0, a1
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: rotl_32_mask_shared:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    andi a3, a2, 31
; RV64XTHEADBB-NEXT:    sllw a4, a0, a2
; RV64XTHEADBB-NEXT:    negw a3, a3
; RV64XTHEADBB-NEXT:    srlw a0, a0, a3
; RV64XTHEADBB-NEXT:    or a0, a4, a0
; RV64XTHEADBB-NEXT:    sllw a1, a1, a2
; RV64XTHEADBB-NEXT:    addw a0, a0, a1
; RV64XTHEADBB-NEXT:    ret
  %maskedamt = and i32 %amt, 31
  %1 = tail call i32 @llvm.fshl.i32(i32 %a, i32 %a, i32 %maskedamt)
  %2 = shl i32 %b, %maskedamt
  %3 = add i32 %1, %2
  ret i32 %3
}
declare i32 @llvm.fshl.i32(i32, i32, i32)

define signext i64 @rotl_64_mask_shared(i64 signext %a, i64 signext %b, i64 signext %amt) nounwind {
; RV32I-LABEL: rotl_64_mask_shared:
; RV32I:       # %bb.0:
; RV32I-NEXT:    andi a5, a4, 63
; RV32I-NEXT:    li t0, 32
; RV32I-NEXT:    neg a7, a5
; RV32I-NEXT:    bltu a5, t0, .LBB17_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    li a6, 0
; RV32I-NEXT:    sll t3, a0, a5
; RV32I-NEXT:    j .LBB17_3
; RV32I-NEXT:  .LBB17_2:
; RV32I-NEXT:    sll a6, a0, a4
; RV32I-NEXT:    srl t1, a0, a7
; RV32I-NEXT:    sll t2, a1, a4
; RV32I-NEXT:    or t3, t1, t2
; RV32I-NEXT:  .LBB17_3:
; RV32I-NEXT:    neg t2, a5
; RV32I-NEXT:    mv t1, a1
; RV32I-NEXT:    beqz a5, .LBB17_5
; RV32I-NEXT:  # %bb.4:
; RV32I-NEXT:    mv t1, t3
; RV32I-NEXT:  .LBB17_5:
; RV32I-NEXT:    andi t3, t2, 63
; RV32I-NEXT:    bltu t3, t0, .LBB17_7
; RV32I-NEXT:  # %bb.6:
; RV32I-NEXT:    srl t4, a1, t3
; RV32I-NEXT:    bnez t3, .LBB17_8
; RV32I-NEXT:    j .LBB17_9
; RV32I-NEXT:  .LBB17_7:
; RV32I-NEXT:    srl t4, a0, t2
; RV32I-NEXT:    neg t5, t3
; RV32I-NEXT:    sll t5, a1, t5
; RV32I-NEXT:    or t4, t4, t5
; RV32I-NEXT:    beqz t3, .LBB17_9
; RV32I-NEXT:  .LBB17_8:
; RV32I-NEXT:    mv a0, t4
; RV32I-NEXT:  .LBB17_9:
; RV32I-NEXT:    bltu t3, t0, .LBB17_12
; RV32I-NEXT:  # %bb.10:
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    bgeu a5, t0, .LBB17_13
; RV32I-NEXT:  .LBB17_11:
; RV32I-NEXT:    sll t0, a2, a4
; RV32I-NEXT:    srl a2, a2, a7
; RV32I-NEXT:    sll a4, a3, a4
; RV32I-NEXT:    or a2, a2, a4
; RV32I-NEXT:    j .LBB17_14
; RV32I-NEXT:  .LBB17_12:
; RV32I-NEXT:    srl a1, a1, t2
; RV32I-NEXT:    bltu a5, t0, .LBB17_11
; RV32I-NEXT:  .LBB17_13:
; RV32I-NEXT:    li t0, 0
; RV32I-NEXT:    sll a2, a2, a5
; RV32I-NEXT:  .LBB17_14:
; RV32I-NEXT:    or a0, a6, a0
; RV32I-NEXT:    or a1, t1, a1
; RV32I-NEXT:    beqz a5, .LBB17_16
; RV32I-NEXT:  # %bb.15:
; RV32I-NEXT:    mv a3, a2
; RV32I-NEXT:  .LBB17_16:
; RV32I-NEXT:    add a0, a0, t0
; RV32I-NEXT:    sltu a2, a0, t0
; RV32I-NEXT:    add a1, a1, a3
; RV32I-NEXT:    add a1, a1, a2
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rotl_64_mask_shared:
; RV64I:       # %bb.0:
; RV64I-NEXT:    andi a3, a2, 63
; RV64I-NEXT:    sll a4, a0, a2
; RV64I-NEXT:    negw a3, a3
; RV64I-NEXT:    srl a0, a0, a3
; RV64I-NEXT:    or a0, a4, a0
; RV64I-NEXT:    sll a1, a1, a2
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: rotl_64_mask_shared:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    andi a5, a4, 63
; RV32ZBB-NEXT:    li t0, 32
; RV32ZBB-NEXT:    neg a7, a5
; RV32ZBB-NEXT:    bltu a5, t0, .LBB17_2
; RV32ZBB-NEXT:  # %bb.1:
; RV32ZBB-NEXT:    li a6, 0
; RV32ZBB-NEXT:    sll t3, a0, a5
; RV32ZBB-NEXT:    j .LBB17_3
; RV32ZBB-NEXT:  .LBB17_2:
; RV32ZBB-NEXT:    sll a6, a0, a4
; RV32ZBB-NEXT:    srl t1, a0, a7
; RV32ZBB-NEXT:    sll t2, a1, a4
; RV32ZBB-NEXT:    or t3, t1, t2
; RV32ZBB-NEXT:  .LBB17_3:
; RV32ZBB-NEXT:    neg t2, a5
; RV32ZBB-NEXT:    mv t1, a1
; RV32ZBB-NEXT:    beqz a5, .LBB17_5
; RV32ZBB-NEXT:  # %bb.4:
; RV32ZBB-NEXT:    mv t1, t3
; RV32ZBB-NEXT:  .LBB17_5:
; RV32ZBB-NEXT:    andi t3, t2, 63
; RV32ZBB-NEXT:    bltu t3, t0, .LBB17_7
; RV32ZBB-NEXT:  # %bb.6:
; RV32ZBB-NEXT:    srl t4, a1, t3
; RV32ZBB-NEXT:    bnez t3, .LBB17_8
; RV32ZBB-NEXT:    j .LBB17_9
; RV32ZBB-NEXT:  .LBB17_7:
; RV32ZBB-NEXT:    srl t4, a0, t2
; RV32ZBB-NEXT:    neg t5, t3
; RV32ZBB-NEXT:    sll t5, a1, t5
; RV32ZBB-NEXT:    or t4, t4, t5
; RV32ZBB-NEXT:    beqz t3, .LBB17_9
; RV32ZBB-NEXT:  .LBB17_8:
; RV32ZBB-NEXT:    mv a0, t4
; RV32ZBB-NEXT:  .LBB17_9:
; RV32ZBB-NEXT:    bltu t3, t0, .LBB17_12
; RV32ZBB-NEXT:  # %bb.10:
; RV32ZBB-NEXT:    li a1, 0
; RV32ZBB-NEXT:    bgeu a5, t0, .LBB17_13
; RV32ZBB-NEXT:  .LBB17_11:
; RV32ZBB-NEXT:    sll t0, a2, a4
; RV32ZBB-NEXT:    srl a2, a2, a7
; RV32ZBB-NEXT:    sll a4, a3, a4
; RV32ZBB-NEXT:    or a2, a2, a4
; RV32ZBB-NEXT:    j .LBB17_14
; RV32ZBB-NEXT:  .LBB17_12:
; RV32ZBB-NEXT:    srl a1, a1, t2
; RV32ZBB-NEXT:    bltu a5, t0, .LBB17_11
; RV32ZBB-NEXT:  .LBB17_13:
; RV32ZBB-NEXT:    li t0, 0
; RV32ZBB-NEXT:    sll a2, a2, a5
; RV32ZBB-NEXT:  .LBB17_14:
; RV32ZBB-NEXT:    or a0, a6, a0
; RV32ZBB-NEXT:    or a1, t1, a1
; RV32ZBB-NEXT:    beqz a5, .LBB17_16
; RV32ZBB-NEXT:  # %bb.15:
; RV32ZBB-NEXT:    mv a3, a2
; RV32ZBB-NEXT:  .LBB17_16:
; RV32ZBB-NEXT:    add a0, a0, t0
; RV32ZBB-NEXT:    sltu a2, a0, t0
; RV32ZBB-NEXT:    add a1, a1, a3
; RV32ZBB-NEXT:    add a1, a1, a2
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: rotl_64_mask_shared:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    rol a0, a0, a2
; RV64ZBB-NEXT:    sll a1, a1, a2
; RV64ZBB-NEXT:    add a0, a0, a1
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: rotl_64_mask_shared:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    andi a5, a4, 63
; RV32XTHEADBB-NEXT:    li t0, 32
; RV32XTHEADBB-NEXT:    neg a7, a5
; RV32XTHEADBB-NEXT:    bltu a5, t0, .LBB17_2
; RV32XTHEADBB-NEXT:  # %bb.1:
; RV32XTHEADBB-NEXT:    li a6, 0
; RV32XTHEADBB-NEXT:    sll t3, a0, a5
; RV32XTHEADBB-NEXT:    j .LBB17_3
; RV32XTHEADBB-NEXT:  .LBB17_2:
; RV32XTHEADBB-NEXT:    sll a6, a0, a4
; RV32XTHEADBB-NEXT:    srl t1, a0, a7
; RV32XTHEADBB-NEXT:    sll t2, a1, a4
; RV32XTHEADBB-NEXT:    or t3, t1, t2
; RV32XTHEADBB-NEXT:  .LBB17_3:
; RV32XTHEADBB-NEXT:    neg t2, a5
; RV32XTHEADBB-NEXT:    mv t1, a1
; RV32XTHEADBB-NEXT:    beqz a5, .LBB17_5
; RV32XTHEADBB-NEXT:  # %bb.4:
; RV32XTHEADBB-NEXT:    mv t1, t3
; RV32XTHEADBB-NEXT:  .LBB17_5:
; RV32XTHEADBB-NEXT:    andi t3, t2, 63
; RV32XTHEADBB-NEXT:    bltu t3, t0, .LBB17_7
; RV32XTHEADBB-NEXT:  # %bb.6:
; RV32XTHEADBB-NEXT:    srl t4, a1, t3
; RV32XTHEADBB-NEXT:    bnez t3, .LBB17_8
; RV32XTHEADBB-NEXT:    j .LBB17_9
; RV32XTHEADBB-NEXT:  .LBB17_7:
; RV32XTHEADBB-NEXT:    srl t4, a0, t2
; RV32XTHEADBB-NEXT:    neg t5, t3
; RV32XTHEADBB-NEXT:    sll t5, a1, t5
; RV32XTHEADBB-NEXT:    or t4, t4, t5
; RV32XTHEADBB-NEXT:    beqz t3, .LBB17_9
; RV32XTHEADBB-NEXT:  .LBB17_8:
; RV32XTHEADBB-NEXT:    mv a0, t4
; RV32XTHEADBB-NEXT:  .LBB17_9:
; RV32XTHEADBB-NEXT:    bltu t3, t0, .LBB17_12
; RV32XTHEADBB-NEXT:  # %bb.10:
; RV32XTHEADBB-NEXT:    li a1, 0
; RV32XTHEADBB-NEXT:    bgeu a5, t0, .LBB17_13
; RV32XTHEADBB-NEXT:  .LBB17_11:
; RV32XTHEADBB-NEXT:    sll t0, a2, a4
; RV32XTHEADBB-NEXT:    srl a2, a2, a7
; RV32XTHEADBB-NEXT:    sll a4, a3, a4
; RV32XTHEADBB-NEXT:    or a2, a2, a4
; RV32XTHEADBB-NEXT:    j .LBB17_14
; RV32XTHEADBB-NEXT:  .LBB17_12:
; RV32XTHEADBB-NEXT:    srl a1, a1, t2
; RV32XTHEADBB-NEXT:    bltu a5, t0, .LBB17_11
; RV32XTHEADBB-NEXT:  .LBB17_13:
; RV32XTHEADBB-NEXT:    li t0, 0
; RV32XTHEADBB-NEXT:    sll a2, a2, a5
; RV32XTHEADBB-NEXT:  .LBB17_14:
; RV32XTHEADBB-NEXT:    or a0, a6, a0
; RV32XTHEADBB-NEXT:    or a1, t1, a1
; RV32XTHEADBB-NEXT:    beqz a5, .LBB17_16
; RV32XTHEADBB-NEXT:  # %bb.15:
; RV32XTHEADBB-NEXT:    mv a3, a2
; RV32XTHEADBB-NEXT:  .LBB17_16:
; RV32XTHEADBB-NEXT:    add a0, a0, t0
; RV32XTHEADBB-NEXT:    sltu a2, a0, t0
; RV32XTHEADBB-NEXT:    add a1, a1, a3
; RV32XTHEADBB-NEXT:    add a1, a1, a2
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: rotl_64_mask_shared:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    andi a3, a2, 63
; RV64XTHEADBB-NEXT:    sll a4, a0, a2
; RV64XTHEADBB-NEXT:    negw a3, a3
; RV64XTHEADBB-NEXT:    srl a0, a0, a3
; RV64XTHEADBB-NEXT:    or a0, a4, a0
; RV64XTHEADBB-NEXT:    sll a1, a1, a2
; RV64XTHEADBB-NEXT:    add a0, a0, a1
; RV64XTHEADBB-NEXT:    ret
  %maskedamt = and i64 %amt, 63
  %1 = tail call i64 @llvm.fshl.i64(i64 %a, i64 %a, i64 %maskedamt)
  %2 = shl i64 %b, %maskedamt
  %3 = add i64 %1, %2
  ret i64 %3
}
declare i64 @llvm.fshl.i64(i64, i64, i64)

define signext i32 @rotr_32_mask_shared(i32 signext %a, i32 signext %b, i32 signext %amt) nounwind {
; RV32I-LABEL: rotr_32_mask_shared:
; RV32I:       # %bb.0:
; RV32I-NEXT:    andi a3, a2, 31
; RV32I-NEXT:    srl a4, a0, a2
; RV32I-NEXT:    neg a3, a3
; RV32I-NEXT:    sll a0, a0, a3
; RV32I-NEXT:    or a0, a4, a0
; RV32I-NEXT:    sll a1, a1, a2
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rotr_32_mask_shared:
; RV64I:       # %bb.0:
; RV64I-NEXT:    andi a3, a2, 31
; RV64I-NEXT:    srlw a4, a0, a2
; RV64I-NEXT:    negw a3, a3
; RV64I-NEXT:    sllw a0, a0, a3
; RV64I-NEXT:    or a0, a4, a0
; RV64I-NEXT:    sllw a1, a1, a2
; RV64I-NEXT:    addw a0, a0, a1
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: rotr_32_mask_shared:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    ror a0, a0, a2
; RV32ZBB-NEXT:    sll a1, a1, a2
; RV32ZBB-NEXT:    add a0, a0, a1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: rotr_32_mask_shared:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    rorw a0, a0, a2
; RV64ZBB-NEXT:    sllw a1, a1, a2
; RV64ZBB-NEXT:    addw a0, a0, a1
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: rotr_32_mask_shared:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    andi a3, a2, 31
; RV32XTHEADBB-NEXT:    srl a4, a0, a2
; RV32XTHEADBB-NEXT:    neg a3, a3
; RV32XTHEADBB-NEXT:    sll a0, a0, a3
; RV32XTHEADBB-NEXT:    or a0, a4, a0
; RV32XTHEADBB-NEXT:    sll a1, a1, a2
; RV32XTHEADBB-NEXT:    add a0, a0, a1
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: rotr_32_mask_shared:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    andi a3, a2, 31
; RV64XTHEADBB-NEXT:    srlw a4, a0, a2
; RV64XTHEADBB-NEXT:    negw a3, a3
; RV64XTHEADBB-NEXT:    sllw a0, a0, a3
; RV64XTHEADBB-NEXT:    or a0, a4, a0
; RV64XTHEADBB-NEXT:    sllw a1, a1, a2
; RV64XTHEADBB-NEXT:    addw a0, a0, a1
; RV64XTHEADBB-NEXT:    ret
  %maskedamt = and i32 %amt, 31
  %1 = tail call i32 @llvm.fshr.i32(i32 %a, i32 %a, i32 %maskedamt)
  %2 = shl i32 %b, %maskedamt
  %3 = add i32 %1, %2
  ret i32 %3
}
declare i32 @llvm.fshr.i32(i32, i32, i32)

define signext i64 @rotr_64_mask_shared(i64 signext %a, i64 signext %b, i64 signext %amt) nounwind {
; RV32I-LABEL: rotr_64_mask_shared:
; RV32I:       # %bb.0:
; RV32I-NEXT:    andi a5, a4, 63
; RV32I-NEXT:    li t0, 32
; RV32I-NEXT:    neg a6, a5
; RV32I-NEXT:    bltu a5, t0, .LBB19_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    srl t1, a1, a5
; RV32I-NEXT:    mv a7, a0
; RV32I-NEXT:    bnez a5, .LBB19_3
; RV32I-NEXT:    j .LBB19_4
; RV32I-NEXT:  .LBB19_2:
; RV32I-NEXT:    srl a7, a0, a4
; RV32I-NEXT:    sll t1, a1, a6
; RV32I-NEXT:    or t1, a7, t1
; RV32I-NEXT:    mv a7, a0
; RV32I-NEXT:    beqz a5, .LBB19_4
; RV32I-NEXT:  .LBB19_3:
; RV32I-NEXT:    mv a7, t1
; RV32I-NEXT:  .LBB19_4:
; RV32I-NEXT:    neg t4, a5
; RV32I-NEXT:    bltu a5, t0, .LBB19_7
; RV32I-NEXT:  # %bb.5:
; RV32I-NEXT:    li t1, 0
; RV32I-NEXT:    andi t3, t4, 63
; RV32I-NEXT:    bgeu t3, t0, .LBB19_8
; RV32I-NEXT:  .LBB19_6:
; RV32I-NEXT:    sll t2, a0, t4
; RV32I-NEXT:    neg t5, t3
; RV32I-NEXT:    srl a0, a0, t5
; RV32I-NEXT:    sll t4, a1, t4
; RV32I-NEXT:    or a0, a0, t4
; RV32I-NEXT:    bnez t3, .LBB19_9
; RV32I-NEXT:    j .LBB19_10
; RV32I-NEXT:  .LBB19_7:
; RV32I-NEXT:    srl t1, a1, a4
; RV32I-NEXT:    andi t3, t4, 63
; RV32I-NEXT:    bltu t3, t0, .LBB19_6
; RV32I-NEXT:  .LBB19_8:
; RV32I-NEXT:    li t2, 0
; RV32I-NEXT:    sll a0, a0, t3
; RV32I-NEXT:    beqz t3, .LBB19_10
; RV32I-NEXT:  .LBB19_9:
; RV32I-NEXT:    mv a1, a0
; RV32I-NEXT:  .LBB19_10:
; RV32I-NEXT:    bltu a5, t0, .LBB19_12
; RV32I-NEXT:  # %bb.11:
; RV32I-NEXT:    li t0, 0
; RV32I-NEXT:    sll a0, a2, a5
; RV32I-NEXT:    j .LBB19_13
; RV32I-NEXT:  .LBB19_12:
; RV32I-NEXT:    sll t0, a2, a4
; RV32I-NEXT:    srl a0, a2, a6
; RV32I-NEXT:    sll a2, a3, a4
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:  .LBB19_13:
; RV32I-NEXT:    or a2, a7, t2
; RV32I-NEXT:    or a1, t1, a1
; RV32I-NEXT:    beqz a5, .LBB19_15
; RV32I-NEXT:  # %bb.14:
; RV32I-NEXT:    mv a3, a0
; RV32I-NEXT:  .LBB19_15:
; RV32I-NEXT:    add a0, a2, t0
; RV32I-NEXT:    sltu a2, a0, t0
; RV32I-NEXT:    add a1, a1, a3
; RV32I-NEXT:    add a1, a1, a2
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rotr_64_mask_shared:
; RV64I:       # %bb.0:
; RV64I-NEXT:    andi a3, a2, 63
; RV64I-NEXT:    srl a4, a0, a2
; RV64I-NEXT:    negw a3, a3
; RV64I-NEXT:    sll a0, a0, a3
; RV64I-NEXT:    or a0, a4, a0
; RV64I-NEXT:    sll a1, a1, a2
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: rotr_64_mask_shared:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    andi a5, a4, 63
; RV32ZBB-NEXT:    li t0, 32
; RV32ZBB-NEXT:    neg a6, a5
; RV32ZBB-NEXT:    bltu a5, t0, .LBB19_2
; RV32ZBB-NEXT:  # %bb.1:
; RV32ZBB-NEXT:    srl t1, a1, a5
; RV32ZBB-NEXT:    mv a7, a0
; RV32ZBB-NEXT:    bnez a5, .LBB19_3
; RV32ZBB-NEXT:    j .LBB19_4
; RV32ZBB-NEXT:  .LBB19_2:
; RV32ZBB-NEXT:    srl a7, a0, a4
; RV32ZBB-NEXT:    sll t1, a1, a6
; RV32ZBB-NEXT:    or t1, a7, t1
; RV32ZBB-NEXT:    mv a7, a0
; RV32ZBB-NEXT:    beqz a5, .LBB19_4
; RV32ZBB-NEXT:  .LBB19_3:
; RV32ZBB-NEXT:    mv a7, t1
; RV32ZBB-NEXT:  .LBB19_4:
; RV32ZBB-NEXT:    neg t4, a5
; RV32ZBB-NEXT:    bltu a5, t0, .LBB19_7
; RV32ZBB-NEXT:  # %bb.5:
; RV32ZBB-NEXT:    li t1, 0
; RV32ZBB-NEXT:    andi t3, t4, 63
; RV32ZBB-NEXT:    bgeu t3, t0, .LBB19_8
; RV32ZBB-NEXT:  .LBB19_6:
; RV32ZBB-NEXT:    sll t2, a0, t4
; RV32ZBB-NEXT:    neg t5, t3
; RV32ZBB-NEXT:    srl a0, a0, t5
; RV32ZBB-NEXT:    sll t4, a1, t4
; RV32ZBB-NEXT:    or a0, a0, t4
; RV32ZBB-NEXT:    bnez t3, .LBB19_9
; RV32ZBB-NEXT:    j .LBB19_10
; RV32ZBB-NEXT:  .LBB19_7:
; RV32ZBB-NEXT:    srl t1, a1, a4
; RV32ZBB-NEXT:    andi t3, t4, 63
; RV32ZBB-NEXT:    bltu t3, t0, .LBB19_6
; RV32ZBB-NEXT:  .LBB19_8:
; RV32ZBB-NEXT:    li t2, 0
; RV32ZBB-NEXT:    sll a0, a0, t3
; RV32ZBB-NEXT:    beqz t3, .LBB19_10
; RV32ZBB-NEXT:  .LBB19_9:
; RV32ZBB-NEXT:    mv a1, a0
; RV32ZBB-NEXT:  .LBB19_10:
; RV32ZBB-NEXT:    bltu a5, t0, .LBB19_12
; RV32ZBB-NEXT:  # %bb.11:
; RV32ZBB-NEXT:    li t0, 0
; RV32ZBB-NEXT:    sll a0, a2, a5
; RV32ZBB-NEXT:    j .LBB19_13
; RV32ZBB-NEXT:  .LBB19_12:
; RV32ZBB-NEXT:    sll t0, a2, a4
; RV32ZBB-NEXT:    srl a0, a2, a6
; RV32ZBB-NEXT:    sll a2, a3, a4
; RV32ZBB-NEXT:    or a0, a0, a2
; RV32ZBB-NEXT:  .LBB19_13:
; RV32ZBB-NEXT:    or a2, a7, t2
; RV32ZBB-NEXT:    or a1, t1, a1
; RV32ZBB-NEXT:    beqz a5, .LBB19_15
; RV32ZBB-NEXT:  # %bb.14:
; RV32ZBB-NEXT:    mv a3, a0
; RV32ZBB-NEXT:  .LBB19_15:
; RV32ZBB-NEXT:    add a0, a2, t0
; RV32ZBB-NEXT:    sltu a2, a0, t0
; RV32ZBB-NEXT:    add a1, a1, a3
; RV32ZBB-NEXT:    add a1, a1, a2
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: rotr_64_mask_shared:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    ror a0, a0, a2
; RV64ZBB-NEXT:    sll a1, a1, a2
; RV64ZBB-NEXT:    add a0, a0, a1
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: rotr_64_mask_shared:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    andi a5, a4, 63
; RV32XTHEADBB-NEXT:    li t0, 32
; RV32XTHEADBB-NEXT:    neg a6, a5
; RV32XTHEADBB-NEXT:    bltu a5, t0, .LBB19_2
; RV32XTHEADBB-NEXT:  # %bb.1:
; RV32XTHEADBB-NEXT:    srl t1, a1, a5
; RV32XTHEADBB-NEXT:    mv a7, a0
; RV32XTHEADBB-NEXT:    bnez a5, .LBB19_3
; RV32XTHEADBB-NEXT:    j .LBB19_4
; RV32XTHEADBB-NEXT:  .LBB19_2:
; RV32XTHEADBB-NEXT:    srl a7, a0, a4
; RV32XTHEADBB-NEXT:    sll t1, a1, a6
; RV32XTHEADBB-NEXT:    or t1, a7, t1
; RV32XTHEADBB-NEXT:    mv a7, a0
; RV32XTHEADBB-NEXT:    beqz a5, .LBB19_4
; RV32XTHEADBB-NEXT:  .LBB19_3:
; RV32XTHEADBB-NEXT:    mv a7, t1
; RV32XTHEADBB-NEXT:  .LBB19_4:
; RV32XTHEADBB-NEXT:    neg t4, a5
; RV32XTHEADBB-NEXT:    bltu a5, t0, .LBB19_7
; RV32XTHEADBB-NEXT:  # %bb.5:
; RV32XTHEADBB-NEXT:    li t1, 0
; RV32XTHEADBB-NEXT:    andi t3, t4, 63
; RV32XTHEADBB-NEXT:    bgeu t3, t0, .LBB19_8
; RV32XTHEADBB-NEXT:  .LBB19_6:
; RV32XTHEADBB-NEXT:    sll t2, a0, t4
; RV32XTHEADBB-NEXT:    neg t5, t3
; RV32XTHEADBB-NEXT:    srl a0, a0, t5
; RV32XTHEADBB-NEXT:    sll t4, a1, t4
; RV32XTHEADBB-NEXT:    or a0, a0, t4
; RV32XTHEADBB-NEXT:    bnez t3, .LBB19_9
; RV32XTHEADBB-NEXT:    j .LBB19_10
; RV32XTHEADBB-NEXT:  .LBB19_7:
; RV32XTHEADBB-NEXT:    srl t1, a1, a4
; RV32XTHEADBB-NEXT:    andi t3, t4, 63
; RV32XTHEADBB-NEXT:    bltu t3, t0, .LBB19_6
; RV32XTHEADBB-NEXT:  .LBB19_8:
; RV32XTHEADBB-NEXT:    li t2, 0
; RV32XTHEADBB-NEXT:    sll a0, a0, t3
; RV32XTHEADBB-NEXT:    beqz t3, .LBB19_10
; RV32XTHEADBB-NEXT:  .LBB19_9:
; RV32XTHEADBB-NEXT:    mv a1, a0
; RV32XTHEADBB-NEXT:  .LBB19_10:
; RV32XTHEADBB-NEXT:    bltu a5, t0, .LBB19_12
; RV32XTHEADBB-NEXT:  # %bb.11:
; RV32XTHEADBB-NEXT:    li t0, 0
; RV32XTHEADBB-NEXT:    sll a0, a2, a5
; RV32XTHEADBB-NEXT:    j .LBB19_13
; RV32XTHEADBB-NEXT:  .LBB19_12:
; RV32XTHEADBB-NEXT:    sll t0, a2, a4
; RV32XTHEADBB-NEXT:    srl a0, a2, a6
; RV32XTHEADBB-NEXT:    sll a2, a3, a4
; RV32XTHEADBB-NEXT:    or a0, a0, a2
; RV32XTHEADBB-NEXT:  .LBB19_13:
; RV32XTHEADBB-NEXT:    or a2, a7, t2
; RV32XTHEADBB-NEXT:    or a1, t1, a1
; RV32XTHEADBB-NEXT:    beqz a5, .LBB19_15
; RV32XTHEADBB-NEXT:  # %bb.14:
; RV32XTHEADBB-NEXT:    mv a3, a0
; RV32XTHEADBB-NEXT:  .LBB19_15:
; RV32XTHEADBB-NEXT:    add a0, a2, t0
; RV32XTHEADBB-NEXT:    sltu a2, a0, t0
; RV32XTHEADBB-NEXT:    add a1, a1, a3
; RV32XTHEADBB-NEXT:    add a1, a1, a2
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: rotr_64_mask_shared:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    andi a3, a2, 63
; RV64XTHEADBB-NEXT:    srl a4, a0, a2
; RV64XTHEADBB-NEXT:    negw a3, a3
; RV64XTHEADBB-NEXT:    sll a0, a0, a3
; RV64XTHEADBB-NEXT:    or a0, a4, a0
; RV64XTHEADBB-NEXT:    sll a1, a1, a2
; RV64XTHEADBB-NEXT:    add a0, a0, a1
; RV64XTHEADBB-NEXT:    ret
  %maskedamt = and i64 %amt, 63
  %1 = tail call i64 @llvm.fshr.i64(i64 %a, i64 %a, i64 %maskedamt)
  %2 = shl i64 %b, %maskedamt
  %3 = add i64 %1, %2
  ret i64 %3
}
declare i64 @llvm.fshr.i64(i64, i64, i64)

define signext i32 @rotl_32_mask_multiple(i32 signext %a, i32 signext %b, i32 signext %amt) nounwind {
; RV32I-LABEL: rotl_32_mask_multiple:
; RV32I:       # %bb.0:
; RV32I-NEXT:    andi a3, a2, 31
; RV32I-NEXT:    sll a4, a0, a2
; RV32I-NEXT:    sll a2, a1, a2
; RV32I-NEXT:    neg a3, a3
; RV32I-NEXT:    srl a0, a0, a3
; RV32I-NEXT:    srl a1, a1, a3
; RV32I-NEXT:    or a0, a4, a0
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rotl_32_mask_multiple:
; RV64I:       # %bb.0:
; RV64I-NEXT:    andi a3, a2, 31
; RV64I-NEXT:    sllw a4, a0, a2
; RV64I-NEXT:    sllw a2, a1, a2
; RV64I-NEXT:    negw a5, a3
; RV64I-NEXT:    negw a3, a3
; RV64I-NEXT:    srlw a0, a0, a5
; RV64I-NEXT:    srlw a1, a1, a3
; RV64I-NEXT:    or a0, a4, a0
; RV64I-NEXT:    or a1, a2, a1
; RV64I-NEXT:    addw a0, a0, a1
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: rotl_32_mask_multiple:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    rol a0, a0, a2
; RV32ZBB-NEXT:    rol a1, a1, a2
; RV32ZBB-NEXT:    add a0, a0, a1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: rotl_32_mask_multiple:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    rolw a0, a0, a2
; RV64ZBB-NEXT:    rolw a1, a1, a2
; RV64ZBB-NEXT:    addw a0, a0, a1
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: rotl_32_mask_multiple:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    andi a3, a2, 31
; RV32XTHEADBB-NEXT:    sll a4, a0, a2
; RV32XTHEADBB-NEXT:    sll a2, a1, a2
; RV32XTHEADBB-NEXT:    neg a3, a3
; RV32XTHEADBB-NEXT:    srl a0, a0, a3
; RV32XTHEADBB-NEXT:    srl a1, a1, a3
; RV32XTHEADBB-NEXT:    or a0, a4, a0
; RV32XTHEADBB-NEXT:    or a1, a2, a1
; RV32XTHEADBB-NEXT:    add a0, a0, a1
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: rotl_32_mask_multiple:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    andi a3, a2, 31
; RV64XTHEADBB-NEXT:    sllw a4, a0, a2
; RV64XTHEADBB-NEXT:    sllw a2, a1, a2
; RV64XTHEADBB-NEXT:    negw a5, a3
; RV64XTHEADBB-NEXT:    negw a3, a3
; RV64XTHEADBB-NEXT:    srlw a0, a0, a5
; RV64XTHEADBB-NEXT:    srlw a1, a1, a3
; RV64XTHEADBB-NEXT:    or a0, a4, a0
; RV64XTHEADBB-NEXT:    or a1, a2, a1
; RV64XTHEADBB-NEXT:    addw a0, a0, a1
; RV64XTHEADBB-NEXT:    ret
  %maskedamt = and i32 %amt, 31
  %1 = tail call i32 @llvm.fshl.i32(i32 %a, i32 %a, i32 %maskedamt)
  %2 = tail call i32 @llvm.fshl.i32(i32 %b, i32 %b, i32 %maskedamt)
  %3 = add i32 %1, %2
  ret i32 %3
}

define i64 @rotl_64_mask_multiple(i64 %a, i64 %b, i64 %amt) nounwind {
; RV32I-LABEL: rotl_64_mask_multiple:
; RV32I:       # %bb.0:
; RV32I-NEXT:    andi t1, a4, 63
; RV32I-NEXT:    li a5, 32
; RV32I-NEXT:    neg t3, t1
; RV32I-NEXT:    bltu t1, a5, .LBB21_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    li a6, 0
; RV32I-NEXT:    sll t2, a0, t1
; RV32I-NEXT:    j .LBB21_3
; RV32I-NEXT:  .LBB21_2:
; RV32I-NEXT:    sll a6, a0, a4
; RV32I-NEXT:    srl a7, a0, t3
; RV32I-NEXT:    sll t0, a1, a4
; RV32I-NEXT:    or t2, a7, t0
; RV32I-NEXT:  .LBB21_3:
; RV32I-NEXT:    neg a7, t1
; RV32I-NEXT:    mv t0, a1
; RV32I-NEXT:    beqz t1, .LBB21_5
; RV32I-NEXT:  # %bb.4:
; RV32I-NEXT:    mv t0, t2
; RV32I-NEXT:  .LBB21_5:
; RV32I-NEXT:    andi t2, a7, 63
; RV32I-NEXT:    neg t4, t2
; RV32I-NEXT:    bltu t2, a5, .LBB21_7
; RV32I-NEXT:  # %bb.6:
; RV32I-NEXT:    srl t5, a1, t2
; RV32I-NEXT:    bnez t2, .LBB21_8
; RV32I-NEXT:    j .LBB21_9
; RV32I-NEXT:  .LBB21_7:
; RV32I-NEXT:    srl t5, a0, a7
; RV32I-NEXT:    sll t6, a1, t4
; RV32I-NEXT:    or t5, t5, t6
; RV32I-NEXT:    beqz t2, .LBB21_9
; RV32I-NEXT:  .LBB21_8:
; RV32I-NEXT:    mv a0, t5
; RV32I-NEXT:  .LBB21_9:
; RV32I-NEXT:    bltu t2, a5, .LBB21_12
; RV32I-NEXT:  # %bb.10:
; RV32I-NEXT:    li t5, 0
; RV32I-NEXT:    bgeu t1, a5, .LBB21_13
; RV32I-NEXT:  .LBB21_11:
; RV32I-NEXT:    sll a1, a2, a4
; RV32I-NEXT:    srl t3, a2, t3
; RV32I-NEXT:    sll a4, a3, a4
; RV32I-NEXT:    or t3, t3, a4
; RV32I-NEXT:    mv a4, a3
; RV32I-NEXT:    bnez t1, .LBB21_14
; RV32I-NEXT:    j .LBB21_15
; RV32I-NEXT:  .LBB21_12:
; RV32I-NEXT:    srl t5, a1, a7
; RV32I-NEXT:    bltu t1, a5, .LBB21_11
; RV32I-NEXT:  .LBB21_13:
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    sll t3, a2, t1
; RV32I-NEXT:    mv a4, a3
; RV32I-NEXT:    beqz t1, .LBB21_15
; RV32I-NEXT:  .LBB21_14:
; RV32I-NEXT:    mv a4, t3
; RV32I-NEXT:  .LBB21_15:
; RV32I-NEXT:    bltu t2, a5, .LBB21_17
; RV32I-NEXT:  # %bb.16:
; RV32I-NEXT:    srl t1, a3, t2
; RV32I-NEXT:    bnez t2, .LBB21_18
; RV32I-NEXT:    j .LBB21_19
; RV32I-NEXT:  .LBB21_17:
; RV32I-NEXT:    srl t1, a2, a7
; RV32I-NEXT:    sll t3, a3, t4
; RV32I-NEXT:    or t1, t1, t3
; RV32I-NEXT:    beqz t2, .LBB21_19
; RV32I-NEXT:  .LBB21_18:
; RV32I-NEXT:    mv a2, t1
; RV32I-NEXT:  .LBB21_19:
; RV32I-NEXT:    or a0, a6, a0
; RV32I-NEXT:    or a6, t0, t5
; RV32I-NEXT:    bltu t2, a5, .LBB21_21
; RV32I-NEXT:  # %bb.20:
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    j .LBB21_22
; RV32I-NEXT:  .LBB21_21:
; RV32I-NEXT:    srl a3, a3, a7
; RV32I-NEXT:  .LBB21_22:
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    or a3, a4, a3
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    sltu a1, a0, a1
; RV32I-NEXT:    add a3, a6, a3
; RV32I-NEXT:    add a1, a3, a1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rotl_64_mask_multiple:
; RV64I:       # %bb.0:
; RV64I-NEXT:    andi a3, a2, 63
; RV64I-NEXT:    sll a4, a0, a2
; RV64I-NEXT:    sll a2, a1, a2
; RV64I-NEXT:    negw a3, a3
; RV64I-NEXT:    srl a0, a0, a3
; RV64I-NEXT:    srl a1, a1, a3
; RV64I-NEXT:    or a0, a4, a0
; RV64I-NEXT:    or a1, a2, a1
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: rotl_64_mask_multiple:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    andi t1, a4, 63
; RV32ZBB-NEXT:    li a5, 32
; RV32ZBB-NEXT:    neg t3, t1
; RV32ZBB-NEXT:    bltu t1, a5, .LBB21_2
; RV32ZBB-NEXT:  # %bb.1:
; RV32ZBB-NEXT:    li a6, 0
; RV32ZBB-NEXT:    sll t2, a0, t1
; RV32ZBB-NEXT:    j .LBB21_3
; RV32ZBB-NEXT:  .LBB21_2:
; RV32ZBB-NEXT:    sll a6, a0, a4
; RV32ZBB-NEXT:    srl a7, a0, t3
; RV32ZBB-NEXT:    sll t0, a1, a4
; RV32ZBB-NEXT:    or t2, a7, t0
; RV32ZBB-NEXT:  .LBB21_3:
; RV32ZBB-NEXT:    neg a7, t1
; RV32ZBB-NEXT:    mv t0, a1
; RV32ZBB-NEXT:    beqz t1, .LBB21_5
; RV32ZBB-NEXT:  # %bb.4:
; RV32ZBB-NEXT:    mv t0, t2
; RV32ZBB-NEXT:  .LBB21_5:
; RV32ZBB-NEXT:    andi t2, a7, 63
; RV32ZBB-NEXT:    neg t4, t2
; RV32ZBB-NEXT:    bltu t2, a5, .LBB21_7
; RV32ZBB-NEXT:  # %bb.6:
; RV32ZBB-NEXT:    srl t5, a1, t2
; RV32ZBB-NEXT:    bnez t2, .LBB21_8
; RV32ZBB-NEXT:    j .LBB21_9
; RV32ZBB-NEXT:  .LBB21_7:
; RV32ZBB-NEXT:    srl t5, a0, a7
; RV32ZBB-NEXT:    sll t6, a1, t4
; RV32ZBB-NEXT:    or t5, t5, t6
; RV32ZBB-NEXT:    beqz t2, .LBB21_9
; RV32ZBB-NEXT:  .LBB21_8:
; RV32ZBB-NEXT:    mv a0, t5
; RV32ZBB-NEXT:  .LBB21_9:
; RV32ZBB-NEXT:    bltu t2, a5, .LBB21_12
; RV32ZBB-NEXT:  # %bb.10:
; RV32ZBB-NEXT:    li t5, 0
; RV32ZBB-NEXT:    bgeu t1, a5, .LBB21_13
; RV32ZBB-NEXT:  .LBB21_11:
; RV32ZBB-NEXT:    sll a1, a2, a4
; RV32ZBB-NEXT:    srl t3, a2, t3
; RV32ZBB-NEXT:    sll a4, a3, a4
; RV32ZBB-NEXT:    or t3, t3, a4
; RV32ZBB-NEXT:    mv a4, a3
; RV32ZBB-NEXT:    bnez t1, .LBB21_14
; RV32ZBB-NEXT:    j .LBB21_15
; RV32ZBB-NEXT:  .LBB21_12:
; RV32ZBB-NEXT:    srl t5, a1, a7
; RV32ZBB-NEXT:    bltu t1, a5, .LBB21_11
; RV32ZBB-NEXT:  .LBB21_13:
; RV32ZBB-NEXT:    li a1, 0
; RV32ZBB-NEXT:    sll t3, a2, t1
; RV32ZBB-NEXT:    mv a4, a3
; RV32ZBB-NEXT:    beqz t1, .LBB21_15
; RV32ZBB-NEXT:  .LBB21_14:
; RV32ZBB-NEXT:    mv a4, t3
; RV32ZBB-NEXT:  .LBB21_15:
; RV32ZBB-NEXT:    bltu t2, a5, .LBB21_17
; RV32ZBB-NEXT:  # %bb.16:
; RV32ZBB-NEXT:    srl t1, a3, t2
; RV32ZBB-NEXT:    bnez t2, .LBB21_18
; RV32ZBB-NEXT:    j .LBB21_19
; RV32ZBB-NEXT:  .LBB21_17:
; RV32ZBB-NEXT:    srl t1, a2, a7
; RV32ZBB-NEXT:    sll t3, a3, t4
; RV32ZBB-NEXT:    or t1, t1, t3
; RV32ZBB-NEXT:    beqz t2, .LBB21_19
; RV32ZBB-NEXT:  .LBB21_18:
; RV32ZBB-NEXT:    mv a2, t1
; RV32ZBB-NEXT:  .LBB21_19:
; RV32ZBB-NEXT:    or a0, a6, a0
; RV32ZBB-NEXT:    or a6, t0, t5
; RV32ZBB-NEXT:    bltu t2, a5, .LBB21_21
; RV32ZBB-NEXT:  # %bb.20:
; RV32ZBB-NEXT:    li a3, 0
; RV32ZBB-NEXT:    j .LBB21_22
; RV32ZBB-NEXT:  .LBB21_21:
; RV32ZBB-NEXT:    srl a3, a3, a7
; RV32ZBB-NEXT:  .LBB21_22:
; RV32ZBB-NEXT:    or a1, a1, a2
; RV32ZBB-NEXT:    or a3, a4, a3
; RV32ZBB-NEXT:    add a0, a0, a1
; RV32ZBB-NEXT:    sltu a1, a0, a1
; RV32ZBB-NEXT:    add a3, a6, a3
; RV32ZBB-NEXT:    add a1, a3, a1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: rotl_64_mask_multiple:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    rol a0, a0, a2
; RV64ZBB-NEXT:    rol a1, a1, a2
; RV64ZBB-NEXT:    add a0, a0, a1
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: rotl_64_mask_multiple:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    andi t1, a4, 63
; RV32XTHEADBB-NEXT:    li a5, 32
; RV32XTHEADBB-NEXT:    neg t3, t1
; RV32XTHEADBB-NEXT:    bltu t1, a5, .LBB21_2
; RV32XTHEADBB-NEXT:  # %bb.1:
; RV32XTHEADBB-NEXT:    li a6, 0
; RV32XTHEADBB-NEXT:    sll t2, a0, t1
; RV32XTHEADBB-NEXT:    j .LBB21_3
; RV32XTHEADBB-NEXT:  .LBB21_2:
; RV32XTHEADBB-NEXT:    sll a6, a0, a4
; RV32XTHEADBB-NEXT:    srl a7, a0, t3
; RV32XTHEADBB-NEXT:    sll t0, a1, a4
; RV32XTHEADBB-NEXT:    or t2, a7, t0
; RV32XTHEADBB-NEXT:  .LBB21_3:
; RV32XTHEADBB-NEXT:    neg a7, t1
; RV32XTHEADBB-NEXT:    mv t0, a1
; RV32XTHEADBB-NEXT:    beqz t1, .LBB21_5
; RV32XTHEADBB-NEXT:  # %bb.4:
; RV32XTHEADBB-NEXT:    mv t0, t2
; RV32XTHEADBB-NEXT:  .LBB21_5:
; RV32XTHEADBB-NEXT:    andi t2, a7, 63
; RV32XTHEADBB-NEXT:    neg t4, t2
; RV32XTHEADBB-NEXT:    bltu t2, a5, .LBB21_7
; RV32XTHEADBB-NEXT:  # %bb.6:
; RV32XTHEADBB-NEXT:    srl t5, a1, t2
; RV32XTHEADBB-NEXT:    bnez t2, .LBB21_8
; RV32XTHEADBB-NEXT:    j .LBB21_9
; RV32XTHEADBB-NEXT:  .LBB21_7:
; RV32XTHEADBB-NEXT:    srl t5, a0, a7
; RV32XTHEADBB-NEXT:    sll t6, a1, t4
; RV32XTHEADBB-NEXT:    or t5, t5, t6
; RV32XTHEADBB-NEXT:    beqz t2, .LBB21_9
; RV32XTHEADBB-NEXT:  .LBB21_8:
; RV32XTHEADBB-NEXT:    mv a0, t5
; RV32XTHEADBB-NEXT:  .LBB21_9:
; RV32XTHEADBB-NEXT:    bltu t2, a5, .LBB21_12
; RV32XTHEADBB-NEXT:  # %bb.10:
; RV32XTHEADBB-NEXT:    li t5, 0
; RV32XTHEADBB-NEXT:    bgeu t1, a5, .LBB21_13
; RV32XTHEADBB-NEXT:  .LBB21_11:
; RV32XTHEADBB-NEXT:    sll a1, a2, a4
; RV32XTHEADBB-NEXT:    srl t3, a2, t3
; RV32XTHEADBB-NEXT:    sll a4, a3, a4
; RV32XTHEADBB-NEXT:    or t3, t3, a4
; RV32XTHEADBB-NEXT:    mv a4, a3
; RV32XTHEADBB-NEXT:    bnez t1, .LBB21_14
; RV32XTHEADBB-NEXT:    j .LBB21_15
; RV32XTHEADBB-NEXT:  .LBB21_12:
; RV32XTHEADBB-NEXT:    srl t5, a1, a7
; RV32XTHEADBB-NEXT:    bltu t1, a5, .LBB21_11
; RV32XTHEADBB-NEXT:  .LBB21_13:
; RV32XTHEADBB-NEXT:    li a1, 0
; RV32XTHEADBB-NEXT:    sll t3, a2, t1
; RV32XTHEADBB-NEXT:    mv a4, a3
; RV32XTHEADBB-NEXT:    beqz t1, .LBB21_15
; RV32XTHEADBB-NEXT:  .LBB21_14:
; RV32XTHEADBB-NEXT:    mv a4, t3
; RV32XTHEADBB-NEXT:  .LBB21_15:
; RV32XTHEADBB-NEXT:    bltu t2, a5, .LBB21_17
; RV32XTHEADBB-NEXT:  # %bb.16:
; RV32XTHEADBB-NEXT:    srl t1, a3, t2
; RV32XTHEADBB-NEXT:    bnez t2, .LBB21_18
; RV32XTHEADBB-NEXT:    j .LBB21_19
; RV32XTHEADBB-NEXT:  .LBB21_17:
; RV32XTHEADBB-NEXT:    srl t1, a2, a7
; RV32XTHEADBB-NEXT:    sll t3, a3, t4
; RV32XTHEADBB-NEXT:    or t1, t1, t3
; RV32XTHEADBB-NEXT:    beqz t2, .LBB21_19
; RV32XTHEADBB-NEXT:  .LBB21_18:
; RV32XTHEADBB-NEXT:    mv a2, t1
; RV32XTHEADBB-NEXT:  .LBB21_19:
; RV32XTHEADBB-NEXT:    or a0, a6, a0
; RV32XTHEADBB-NEXT:    or a6, t0, t5
; RV32XTHEADBB-NEXT:    bltu t2, a5, .LBB21_21
; RV32XTHEADBB-NEXT:  # %bb.20:
; RV32XTHEADBB-NEXT:    li a3, 0
; RV32XTHEADBB-NEXT:    j .LBB21_22
; RV32XTHEADBB-NEXT:  .LBB21_21:
; RV32XTHEADBB-NEXT:    srl a3, a3, a7
; RV32XTHEADBB-NEXT:  .LBB21_22:
; RV32XTHEADBB-NEXT:    or a1, a1, a2
; RV32XTHEADBB-NEXT:    or a3, a4, a3
; RV32XTHEADBB-NEXT:    add a0, a0, a1
; RV32XTHEADBB-NEXT:    sltu a1, a0, a1
; RV32XTHEADBB-NEXT:    add a3, a6, a3
; RV32XTHEADBB-NEXT:    add a1, a3, a1
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: rotl_64_mask_multiple:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    andi a3, a2, 63
; RV64XTHEADBB-NEXT:    sll a4, a0, a2
; RV64XTHEADBB-NEXT:    sll a2, a1, a2
; RV64XTHEADBB-NEXT:    negw a3, a3
; RV64XTHEADBB-NEXT:    srl a0, a0, a3
; RV64XTHEADBB-NEXT:    srl a1, a1, a3
; RV64XTHEADBB-NEXT:    or a0, a4, a0
; RV64XTHEADBB-NEXT:    or a1, a2, a1
; RV64XTHEADBB-NEXT:    add a0, a0, a1
; RV64XTHEADBB-NEXT:    ret
  %maskedamt = and i64 %amt, 63
  %1 = tail call i64 @llvm.fshl.i64(i64 %a, i64 %a, i64 %maskedamt)
  %2 = tail call i64 @llvm.fshl.i64(i64 %b, i64 %b, i64 %maskedamt)
  %3 = add i64 %1, %2
  ret i64 %3
}

define signext i32 @rotr_32_mask_multiple(i32 signext %a, i32 signext %b, i32 signext %amt) nounwind {
; RV32I-LABEL: rotr_32_mask_multiple:
; RV32I:       # %bb.0:
; RV32I-NEXT:    andi a3, a2, 31
; RV32I-NEXT:    srl a4, a0, a2
; RV32I-NEXT:    srl a2, a1, a2
; RV32I-NEXT:    neg a3, a3
; RV32I-NEXT:    sll a0, a0, a3
; RV32I-NEXT:    sll a1, a1, a3
; RV32I-NEXT:    or a0, a4, a0
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rotr_32_mask_multiple:
; RV64I:       # %bb.0:
; RV64I-NEXT:    andi a3, a2, 31
; RV64I-NEXT:    srlw a4, a0, a2
; RV64I-NEXT:    srlw a2, a1, a2
; RV64I-NEXT:    negw a5, a3
; RV64I-NEXT:    negw a3, a3
; RV64I-NEXT:    sllw a0, a0, a5
; RV64I-NEXT:    sllw a1, a1, a3
; RV64I-NEXT:    or a0, a4, a0
; RV64I-NEXT:    or a1, a2, a1
; RV64I-NEXT:    addw a0, a0, a1
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: rotr_32_mask_multiple:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    ror a0, a0, a2
; RV32ZBB-NEXT:    ror a1, a1, a2
; RV32ZBB-NEXT:    add a0, a0, a1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: rotr_32_mask_multiple:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    rorw a0, a0, a2
; RV64ZBB-NEXT:    rorw a1, a1, a2
; RV64ZBB-NEXT:    addw a0, a0, a1
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: rotr_32_mask_multiple:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    andi a3, a2, 31
; RV32XTHEADBB-NEXT:    srl a4, a0, a2
; RV32XTHEADBB-NEXT:    srl a2, a1, a2
; RV32XTHEADBB-NEXT:    neg a3, a3
; RV32XTHEADBB-NEXT:    sll a0, a0, a3
; RV32XTHEADBB-NEXT:    sll a1, a1, a3
; RV32XTHEADBB-NEXT:    or a0, a4, a0
; RV32XTHEADBB-NEXT:    or a1, a2, a1
; RV32XTHEADBB-NEXT:    add a0, a0, a1
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: rotr_32_mask_multiple:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    andi a3, a2, 31
; RV64XTHEADBB-NEXT:    srlw a4, a0, a2
; RV64XTHEADBB-NEXT:    srlw a2, a1, a2
; RV64XTHEADBB-NEXT:    negw a5, a3
; RV64XTHEADBB-NEXT:    negw a3, a3
; RV64XTHEADBB-NEXT:    sllw a0, a0, a5
; RV64XTHEADBB-NEXT:    sllw a1, a1, a3
; RV64XTHEADBB-NEXT:    or a0, a4, a0
; RV64XTHEADBB-NEXT:    or a1, a2, a1
; RV64XTHEADBB-NEXT:    addw a0, a0, a1
; RV64XTHEADBB-NEXT:    ret
  %maskedamt = and i32 %amt, 31
  %1 = tail call i32 @llvm.fshr.i32(i32 %a, i32 %a, i32 %maskedamt)
  %2 = tail call i32 @llvm.fshr.i32(i32 %b, i32 %b, i32 %maskedamt)
  %3 = add i32 %1, %2
  ret i32 %3
}

define i64 @rotr_64_mask_multiple(i64 %a, i64 %b, i64 %amt) nounwind {
; RV32I-LABEL: rotr_64_mask_multiple:
; RV32I:       # %bb.0:
; RV32I-NEXT:    andi t0, a4, 63
; RV32I-NEXT:    li a6, 32
; RV32I-NEXT:    neg t4, t0
; RV32I-NEXT:    bltu t0, a6, .LBB23_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    srl a7, a1, t0
; RV32I-NEXT:    mv a5, a0
; RV32I-NEXT:    bnez t0, .LBB23_3
; RV32I-NEXT:    j .LBB23_4
; RV32I-NEXT:  .LBB23_2:
; RV32I-NEXT:    srl a5, a0, a4
; RV32I-NEXT:    sll a7, a1, t4
; RV32I-NEXT:    or a7, a5, a7
; RV32I-NEXT:    mv a5, a0
; RV32I-NEXT:    beqz t0, .LBB23_4
; RV32I-NEXT:  .LBB23_3:
; RV32I-NEXT:    mv a5, a7
; RV32I-NEXT:  .LBB23_4:
; RV32I-NEXT:    neg t2, t0
; RV32I-NEXT:    bltu t0, a6, .LBB23_6
; RV32I-NEXT:  # %bb.5:
; RV32I-NEXT:    li a7, 0
; RV32I-NEXT:    j .LBB23_7
; RV32I-NEXT:  .LBB23_6:
; RV32I-NEXT:    srl a7, a1, a4
; RV32I-NEXT:  .LBB23_7:
; RV32I-NEXT:    andi t1, t2, 63
; RV32I-NEXT:    neg t5, t1
; RV32I-NEXT:    bltu t1, a6, .LBB23_9
; RV32I-NEXT:  # %bb.8:
; RV32I-NEXT:    li t3, 0
; RV32I-NEXT:    sll a0, a0, t1
; RV32I-NEXT:    bnez t1, .LBB23_10
; RV32I-NEXT:    j .LBB23_11
; RV32I-NEXT:  .LBB23_9:
; RV32I-NEXT:    sll t3, a0, t2
; RV32I-NEXT:    srl a0, a0, t5
; RV32I-NEXT:    sll t6, a1, t2
; RV32I-NEXT:    or a0, a0, t6
; RV32I-NEXT:    beqz t1, .LBB23_11
; RV32I-NEXT:  .LBB23_10:
; RV32I-NEXT:    mv a1, a0
; RV32I-NEXT:  .LBB23_11:
; RV32I-NEXT:    bltu t0, a6, .LBB23_13
; RV32I-NEXT:  # %bb.12:
; RV32I-NEXT:    srl t4, a3, t0
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    bnez t0, .LBB23_14
; RV32I-NEXT:    j .LBB23_15
; RV32I-NEXT:  .LBB23_13:
; RV32I-NEXT:    srl a0, a2, a4
; RV32I-NEXT:    sll t4, a3, t4
; RV32I-NEXT:    or t4, a0, t4
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    beqz t0, .LBB23_15
; RV32I-NEXT:  .LBB23_14:
; RV32I-NEXT:    mv a0, t4
; RV32I-NEXT:  .LBB23_15:
; RV32I-NEXT:    bltu t0, a6, .LBB23_18
; RV32I-NEXT:  # %bb.16:
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    bgeu t1, a6, .LBB23_19
; RV32I-NEXT:  .LBB23_17:
; RV32I-NEXT:    sll a6, a2, t2
; RV32I-NEXT:    srl a2, a2, t5
; RV32I-NEXT:    sll t0, a3, t2
; RV32I-NEXT:    or a2, a2, t0
; RV32I-NEXT:    j .LBB23_20
; RV32I-NEXT:  .LBB23_18:
; RV32I-NEXT:    srl a4, a3, a4
; RV32I-NEXT:    bltu t1, a6, .LBB23_17
; RV32I-NEXT:  .LBB23_19:
; RV32I-NEXT:    li a6, 0
; RV32I-NEXT:    sll a2, a2, t1
; RV32I-NEXT:  .LBB23_20:
; RV32I-NEXT:    or a5, a5, t3
; RV32I-NEXT:    or a1, a7, a1
; RV32I-NEXT:    beqz t1, .LBB23_22
; RV32I-NEXT:  # %bb.21:
; RV32I-NEXT:    mv a3, a2
; RV32I-NEXT:  .LBB23_22:
; RV32I-NEXT:    or a2, a0, a6
; RV32I-NEXT:    or a3, a4, a3
; RV32I-NEXT:    add a0, a5, a2
; RV32I-NEXT:    sltu a2, a0, a2
; RV32I-NEXT:    add a1, a1, a3
; RV32I-NEXT:    add a1, a1, a2
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rotr_64_mask_multiple:
; RV64I:       # %bb.0:
; RV64I-NEXT:    andi a3, a2, 63
; RV64I-NEXT:    srl a4, a0, a2
; RV64I-NEXT:    srl a2, a1, a2
; RV64I-NEXT:    negw a3, a3
; RV64I-NEXT:    sll a0, a0, a3
; RV64I-NEXT:    sll a1, a1, a3
; RV64I-NEXT:    or a0, a4, a0
; RV64I-NEXT:    or a1, a2, a1
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: rotr_64_mask_multiple:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    andi t0, a4, 63
; RV32ZBB-NEXT:    li a6, 32
; RV32ZBB-NEXT:    neg t4, t0
; RV32ZBB-NEXT:    bltu t0, a6, .LBB23_2
; RV32ZBB-NEXT:  # %bb.1:
; RV32ZBB-NEXT:    srl a7, a1, t0
; RV32ZBB-NEXT:    mv a5, a0
; RV32ZBB-NEXT:    bnez t0, .LBB23_3
; RV32ZBB-NEXT:    j .LBB23_4
; RV32ZBB-NEXT:  .LBB23_2:
; RV32ZBB-NEXT:    srl a5, a0, a4
; RV32ZBB-NEXT:    sll a7, a1, t4
; RV32ZBB-NEXT:    or a7, a5, a7
; RV32ZBB-NEXT:    mv a5, a0
; RV32ZBB-NEXT:    beqz t0, .LBB23_4
; RV32ZBB-NEXT:  .LBB23_3:
; RV32ZBB-NEXT:    mv a5, a7
; RV32ZBB-NEXT:  .LBB23_4:
; RV32ZBB-NEXT:    neg t2, t0
; RV32ZBB-NEXT:    bltu t0, a6, .LBB23_6
; RV32ZBB-NEXT:  # %bb.5:
; RV32ZBB-NEXT:    li a7, 0
; RV32ZBB-NEXT:    j .LBB23_7
; RV32ZBB-NEXT:  .LBB23_6:
; RV32ZBB-NEXT:    srl a7, a1, a4
; RV32ZBB-NEXT:  .LBB23_7:
; RV32ZBB-NEXT:    andi t1, t2, 63
; RV32ZBB-NEXT:    neg t5, t1
; RV32ZBB-NEXT:    bltu t1, a6, .LBB23_9
; RV32ZBB-NEXT:  # %bb.8:
; RV32ZBB-NEXT:    li t3, 0
; RV32ZBB-NEXT:    sll a0, a0, t1
; RV32ZBB-NEXT:    bnez t1, .LBB23_10
; RV32ZBB-NEXT:    j .LBB23_11
; RV32ZBB-NEXT:  .LBB23_9:
; RV32ZBB-NEXT:    sll t3, a0, t2
; RV32ZBB-NEXT:    srl a0, a0, t5
; RV32ZBB-NEXT:    sll t6, a1, t2
; RV32ZBB-NEXT:    or a0, a0, t6
; RV32ZBB-NEXT:    beqz t1, .LBB23_11
; RV32ZBB-NEXT:  .LBB23_10:
; RV32ZBB-NEXT:    mv a1, a0
; RV32ZBB-NEXT:  .LBB23_11:
; RV32ZBB-NEXT:    bltu t0, a6, .LBB23_13
; RV32ZBB-NEXT:  # %bb.12:
; RV32ZBB-NEXT:    srl t4, a3, t0
; RV32ZBB-NEXT:    mv a0, a2
; RV32ZBB-NEXT:    bnez t0, .LBB23_14
; RV32ZBB-NEXT:    j .LBB23_15
; RV32ZBB-NEXT:  .LBB23_13:
; RV32ZBB-NEXT:    srl a0, a2, a4
; RV32ZBB-NEXT:    sll t4, a3, t4
; RV32ZBB-NEXT:    or t4, a0, t4
; RV32ZBB-NEXT:    mv a0, a2
; RV32ZBB-NEXT:    beqz t0, .LBB23_15
; RV32ZBB-NEXT:  .LBB23_14:
; RV32ZBB-NEXT:    mv a0, t4
; RV32ZBB-NEXT:  .LBB23_15:
; RV32ZBB-NEXT:    bltu t0, a6, .LBB23_18
; RV32ZBB-NEXT:  # %bb.16:
; RV32ZBB-NEXT:    li a4, 0
; RV32ZBB-NEXT:    bgeu t1, a6, .LBB23_19
; RV32ZBB-NEXT:  .LBB23_17:
; RV32ZBB-NEXT:    sll a6, a2, t2
; RV32ZBB-NEXT:    srl a2, a2, t5
; RV32ZBB-NEXT:    sll t0, a3, t2
; RV32ZBB-NEXT:    or a2, a2, t0
; RV32ZBB-NEXT:    j .LBB23_20
; RV32ZBB-NEXT:  .LBB23_18:
; RV32ZBB-NEXT:    srl a4, a3, a4
; RV32ZBB-NEXT:    bltu t1, a6, .LBB23_17
; RV32ZBB-NEXT:  .LBB23_19:
; RV32ZBB-NEXT:    li a6, 0
; RV32ZBB-NEXT:    sll a2, a2, t1
; RV32ZBB-NEXT:  .LBB23_20:
; RV32ZBB-NEXT:    or a5, a5, t3
; RV32ZBB-NEXT:    or a1, a7, a1
; RV32ZBB-NEXT:    beqz t1, .LBB23_22
; RV32ZBB-NEXT:  # %bb.21:
; RV32ZBB-NEXT:    mv a3, a2
; RV32ZBB-NEXT:  .LBB23_22:
; RV32ZBB-NEXT:    or a2, a0, a6
; RV32ZBB-NEXT:    or a3, a4, a3
; RV32ZBB-NEXT:    add a0, a5, a2
; RV32ZBB-NEXT:    sltu a2, a0, a2
; RV32ZBB-NEXT:    add a1, a1, a3
; RV32ZBB-NEXT:    add a1, a1, a2
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: rotr_64_mask_multiple:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    ror a0, a0, a2
; RV64ZBB-NEXT:    ror a1, a1, a2
; RV64ZBB-NEXT:    add a0, a0, a1
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: rotr_64_mask_multiple:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    andi t0, a4, 63
; RV32XTHEADBB-NEXT:    li a6, 32
; RV32XTHEADBB-NEXT:    neg t4, t0
; RV32XTHEADBB-NEXT:    bltu t0, a6, .LBB23_2
; RV32XTHEADBB-NEXT:  # %bb.1:
; RV32XTHEADBB-NEXT:    srl a7, a1, t0
; RV32XTHEADBB-NEXT:    mv a5, a0
; RV32XTHEADBB-NEXT:    bnez t0, .LBB23_3
; RV32XTHEADBB-NEXT:    j .LBB23_4
; RV32XTHEADBB-NEXT:  .LBB23_2:
; RV32XTHEADBB-NEXT:    srl a5, a0, a4
; RV32XTHEADBB-NEXT:    sll a7, a1, t4
; RV32XTHEADBB-NEXT:    or a7, a5, a7
; RV32XTHEADBB-NEXT:    mv a5, a0
; RV32XTHEADBB-NEXT:    beqz t0, .LBB23_4
; RV32XTHEADBB-NEXT:  .LBB23_3:
; RV32XTHEADBB-NEXT:    mv a5, a7
; RV32XTHEADBB-NEXT:  .LBB23_4:
; RV32XTHEADBB-NEXT:    neg t2, t0
; RV32XTHEADBB-NEXT:    bltu t0, a6, .LBB23_6
; RV32XTHEADBB-NEXT:  # %bb.5:
; RV32XTHEADBB-NEXT:    li a7, 0
; RV32XTHEADBB-NEXT:    j .LBB23_7
; RV32XTHEADBB-NEXT:  .LBB23_6:
; RV32XTHEADBB-NEXT:    srl a7, a1, a4
; RV32XTHEADBB-NEXT:  .LBB23_7:
; RV32XTHEADBB-NEXT:    andi t1, t2, 63
; RV32XTHEADBB-NEXT:    neg t5, t1
; RV32XTHEADBB-NEXT:    bltu t1, a6, .LBB23_9
; RV32XTHEADBB-NEXT:  # %bb.8:
; RV32XTHEADBB-NEXT:    li t3, 0
; RV32XTHEADBB-NEXT:    sll a0, a0, t1
; RV32XTHEADBB-NEXT:    bnez t1, .LBB23_10
; RV32XTHEADBB-NEXT:    j .LBB23_11
; RV32XTHEADBB-NEXT:  .LBB23_9:
; RV32XTHEADBB-NEXT:    sll t3, a0, t2
; RV32XTHEADBB-NEXT:    srl a0, a0, t5
; RV32XTHEADBB-NEXT:    sll t6, a1, t2
; RV32XTHEADBB-NEXT:    or a0, a0, t6
; RV32XTHEADBB-NEXT:    beqz t1, .LBB23_11
; RV32XTHEADBB-NEXT:  .LBB23_10:
; RV32XTHEADBB-NEXT:    mv a1, a0
; RV32XTHEADBB-NEXT:  .LBB23_11:
; RV32XTHEADBB-NEXT:    bltu t0, a6, .LBB23_13
; RV32XTHEADBB-NEXT:  # %bb.12:
; RV32XTHEADBB-NEXT:    srl t4, a3, t0
; RV32XTHEADBB-NEXT:    mv a0, a2
; RV32XTHEADBB-NEXT:    bnez t0, .LBB23_14
; RV32XTHEADBB-NEXT:    j .LBB23_15
; RV32XTHEADBB-NEXT:  .LBB23_13:
; RV32XTHEADBB-NEXT:    srl a0, a2, a4
; RV32XTHEADBB-NEXT:    sll t4, a3, t4
; RV32XTHEADBB-NEXT:    or t4, a0, t4
; RV32XTHEADBB-NEXT:    mv a0, a2
; RV32XTHEADBB-NEXT:    beqz t0, .LBB23_15
; RV32XTHEADBB-NEXT:  .LBB23_14:
; RV32XTHEADBB-NEXT:    mv a0, t4
; RV32XTHEADBB-NEXT:  .LBB23_15:
; RV32XTHEADBB-NEXT:    bltu t0, a6, .LBB23_18
; RV32XTHEADBB-NEXT:  # %bb.16:
; RV32XTHEADBB-NEXT:    li a4, 0
; RV32XTHEADBB-NEXT:    bgeu t1, a6, .LBB23_19
; RV32XTHEADBB-NEXT:  .LBB23_17:
; RV32XTHEADBB-NEXT:    sll a6, a2, t2
; RV32XTHEADBB-NEXT:    srl a2, a2, t5
; RV32XTHEADBB-NEXT:    sll t0, a3, t2
; RV32XTHEADBB-NEXT:    or a2, a2, t0
; RV32XTHEADBB-NEXT:    j .LBB23_20
; RV32XTHEADBB-NEXT:  .LBB23_18:
; RV32XTHEADBB-NEXT:    srl a4, a3, a4
; RV32XTHEADBB-NEXT:    bltu t1, a6, .LBB23_17
; RV32XTHEADBB-NEXT:  .LBB23_19:
; RV32XTHEADBB-NEXT:    li a6, 0
; RV32XTHEADBB-NEXT:    sll a2, a2, t1
; RV32XTHEADBB-NEXT:  .LBB23_20:
; RV32XTHEADBB-NEXT:    or a5, a5, t3
; RV32XTHEADBB-NEXT:    or a1, a7, a1
; RV32XTHEADBB-NEXT:    beqz t1, .LBB23_22
; RV32XTHEADBB-NEXT:  # %bb.21:
; RV32XTHEADBB-NEXT:    mv a3, a2
; RV32XTHEADBB-NEXT:  .LBB23_22:
; RV32XTHEADBB-NEXT:    or a2, a0, a6
; RV32XTHEADBB-NEXT:    or a3, a4, a3
; RV32XTHEADBB-NEXT:    add a0, a5, a2
; RV32XTHEADBB-NEXT:    sltu a2, a0, a2
; RV32XTHEADBB-NEXT:    add a1, a1, a3
; RV32XTHEADBB-NEXT:    add a1, a1, a2
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: rotr_64_mask_multiple:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    andi a3, a2, 63
; RV64XTHEADBB-NEXT:    srl a4, a0, a2
; RV64XTHEADBB-NEXT:    srl a2, a1, a2
; RV64XTHEADBB-NEXT:    negw a3, a3
; RV64XTHEADBB-NEXT:    sll a0, a0, a3
; RV64XTHEADBB-NEXT:    sll a1, a1, a3
; RV64XTHEADBB-NEXT:    or a0, a4, a0
; RV64XTHEADBB-NEXT:    or a1, a2, a1
; RV64XTHEADBB-NEXT:    add a0, a0, a1
; RV64XTHEADBB-NEXT:    ret
  %maskedamt = and i64 %amt, 63
  %1 = tail call i64 @llvm.fshr.i64(i64 %a, i64 %a, i64 %maskedamt)
  %2 = tail call i64 @llvm.fshr.i64(i64 %b, i64 %b, i64 %maskedamt)
  %3 = add i64 %1, %2
  ret i64 %3
}

define i64 @rotl_64_zext(i64 %x, i32 %y) nounwind {
; RV32I-LABEL: rotl_64_zext:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a6, 64
; RV32I-NEXT:    li a4, 32
; RV32I-NEXT:    neg a5, a2
; RV32I-NEXT:    srl a7, a0, a5
; RV32I-NEXT:    bltu a2, a4, .LBB24_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    sll t1, a0, a2
; RV32I-NEXT:    j .LBB24_3
; RV32I-NEXT:  .LBB24_2:
; RV32I-NEXT:    sll a3, a0, a2
; RV32I-NEXT:    sll t0, a1, a2
; RV32I-NEXT:    or t1, a7, t0
; RV32I-NEXT:  .LBB24_3:
; RV32I-NEXT:    sub t0, a6, a2
; RV32I-NEXT:    mv a6, a1
; RV32I-NEXT:    beqz a2, .LBB24_5
; RV32I-NEXT:  # %bb.4:
; RV32I-NEXT:    mv a6, t1
; RV32I-NEXT:  .LBB24_5:
; RV32I-NEXT:    bltu t0, a4, .LBB24_7
; RV32I-NEXT:  # %bb.6:
; RV32I-NEXT:    srl a2, a1, t0
; RV32I-NEXT:    bnez t0, .LBB24_8
; RV32I-NEXT:    j .LBB24_9
; RV32I-NEXT:  .LBB24_7:
; RV32I-NEXT:    neg a2, t0
; RV32I-NEXT:    sll a2, a1, a2
; RV32I-NEXT:    or a2, a7, a2
; RV32I-NEXT:    beqz t0, .LBB24_9
; RV32I-NEXT:  .LBB24_8:
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:  .LBB24_9:
; RV32I-NEXT:    bltu t0, a4, .LBB24_11
; RV32I-NEXT:  # %bb.10:
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    j .LBB24_12
; RV32I-NEXT:  .LBB24_11:
; RV32I-NEXT:    srl a1, a1, a5
; RV32I-NEXT:  .LBB24_12:
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    or a1, a6, a1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rotl_64_zext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a2, 64
; RV64I-NEXT:    subw a2, a2, a1
; RV64I-NEXT:    sll a1, a0, a1
; RV64I-NEXT:    srl a0, a0, a2
; RV64I-NEXT:    or a0, a1, a0
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: rotl_64_zext:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    li a6, 64
; RV32ZBB-NEXT:    li a4, 32
; RV32ZBB-NEXT:    neg a5, a2
; RV32ZBB-NEXT:    srl a7, a0, a5
; RV32ZBB-NEXT:    bltu a2, a4, .LBB24_2
; RV32ZBB-NEXT:  # %bb.1:
; RV32ZBB-NEXT:    li a3, 0
; RV32ZBB-NEXT:    sll t1, a0, a2
; RV32ZBB-NEXT:    j .LBB24_3
; RV32ZBB-NEXT:  .LBB24_2:
; RV32ZBB-NEXT:    sll a3, a0, a2
; RV32ZBB-NEXT:    sll t0, a1, a2
; RV32ZBB-NEXT:    or t1, a7, t0
; RV32ZBB-NEXT:  .LBB24_3:
; RV32ZBB-NEXT:    sub t0, a6, a2
; RV32ZBB-NEXT:    mv a6, a1
; RV32ZBB-NEXT:    beqz a2, .LBB24_5
; RV32ZBB-NEXT:  # %bb.4:
; RV32ZBB-NEXT:    mv a6, t1
; RV32ZBB-NEXT:  .LBB24_5:
; RV32ZBB-NEXT:    bltu t0, a4, .LBB24_7
; RV32ZBB-NEXT:  # %bb.6:
; RV32ZBB-NEXT:    srl a2, a1, t0
; RV32ZBB-NEXT:    bnez t0, .LBB24_8
; RV32ZBB-NEXT:    j .LBB24_9
; RV32ZBB-NEXT:  .LBB24_7:
; RV32ZBB-NEXT:    neg a2, t0
; RV32ZBB-NEXT:    sll a2, a1, a2
; RV32ZBB-NEXT:    or a2, a7, a2
; RV32ZBB-NEXT:    beqz t0, .LBB24_9
; RV32ZBB-NEXT:  .LBB24_8:
; RV32ZBB-NEXT:    mv a0, a2
; RV32ZBB-NEXT:  .LBB24_9:
; RV32ZBB-NEXT:    bltu t0, a4, .LBB24_11
; RV32ZBB-NEXT:  # %bb.10:
; RV32ZBB-NEXT:    li a1, 0
; RV32ZBB-NEXT:    j .LBB24_12
; RV32ZBB-NEXT:  .LBB24_11:
; RV32ZBB-NEXT:    srl a1, a1, a5
; RV32ZBB-NEXT:  .LBB24_12:
; RV32ZBB-NEXT:    or a0, a3, a0
; RV32ZBB-NEXT:    or a1, a6, a1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: rotl_64_zext:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    li a2, 64
; RV64ZBB-NEXT:    subw a2, a2, a1
; RV64ZBB-NEXT:    sll a1, a0, a1
; RV64ZBB-NEXT:    srl a0, a0, a2
; RV64ZBB-NEXT:    or a0, a1, a0
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: rotl_64_zext:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    li a6, 64
; RV32XTHEADBB-NEXT:    li a4, 32
; RV32XTHEADBB-NEXT:    neg a5, a2
; RV32XTHEADBB-NEXT:    srl a7, a0, a5
; RV32XTHEADBB-NEXT:    bltu a2, a4, .LBB24_2
; RV32XTHEADBB-NEXT:  # %bb.1:
; RV32XTHEADBB-NEXT:    li a3, 0
; RV32XTHEADBB-NEXT:    sll t1, a0, a2
; RV32XTHEADBB-NEXT:    j .LBB24_3
; RV32XTHEADBB-NEXT:  .LBB24_2:
; RV32XTHEADBB-NEXT:    sll a3, a0, a2
; RV32XTHEADBB-NEXT:    sll t0, a1, a2
; RV32XTHEADBB-NEXT:    or t1, a7, t0
; RV32XTHEADBB-NEXT:  .LBB24_3:
; RV32XTHEADBB-NEXT:    sub t0, a6, a2
; RV32XTHEADBB-NEXT:    mv a6, a1
; RV32XTHEADBB-NEXT:    beqz a2, .LBB24_5
; RV32XTHEADBB-NEXT:  # %bb.4:
; RV32XTHEADBB-NEXT:    mv a6, t1
; RV32XTHEADBB-NEXT:  .LBB24_5:
; RV32XTHEADBB-NEXT:    bltu t0, a4, .LBB24_7
; RV32XTHEADBB-NEXT:  # %bb.6:
; RV32XTHEADBB-NEXT:    srl a2, a1, t0
; RV32XTHEADBB-NEXT:    bnez t0, .LBB24_8
; RV32XTHEADBB-NEXT:    j .LBB24_9
; RV32XTHEADBB-NEXT:  .LBB24_7:
; RV32XTHEADBB-NEXT:    neg a2, t0
; RV32XTHEADBB-NEXT:    sll a2, a1, a2
; RV32XTHEADBB-NEXT:    or a2, a7, a2
; RV32XTHEADBB-NEXT:    beqz t0, .LBB24_9
; RV32XTHEADBB-NEXT:  .LBB24_8:
; RV32XTHEADBB-NEXT:    mv a0, a2
; RV32XTHEADBB-NEXT:  .LBB24_9:
; RV32XTHEADBB-NEXT:    bltu t0, a4, .LBB24_11
; RV32XTHEADBB-NEXT:  # %bb.10:
; RV32XTHEADBB-NEXT:    li a1, 0
; RV32XTHEADBB-NEXT:    j .LBB24_12
; RV32XTHEADBB-NEXT:  .LBB24_11:
; RV32XTHEADBB-NEXT:    srl a1, a1, a5
; RV32XTHEADBB-NEXT:  .LBB24_12:
; RV32XTHEADBB-NEXT:    or a0, a3, a0
; RV32XTHEADBB-NEXT:    or a1, a6, a1
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: rotl_64_zext:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    li a2, 64
; RV64XTHEADBB-NEXT:    subw a2, a2, a1
; RV64XTHEADBB-NEXT:    sll a1, a0, a1
; RV64XTHEADBB-NEXT:    srl a0, a0, a2
; RV64XTHEADBB-NEXT:    or a0, a1, a0
; RV64XTHEADBB-NEXT:    ret
  %z = sub i32 64, %y
  %zext = zext i32 %z to i64
  %zexty = zext i32 %y to i64
  %b = shl i64 %x, %zexty
  %c = lshr i64 %x, %zext
  %d = or i64 %b, %c
  ret i64 %d
}

define i64 @rotr_64_zext(i64 %x, i32 %y) nounwind {
; RV32I-LABEL: rotr_64_zext:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a5, 32
; RV32I-NEXT:    neg a6, a2
; RV32I-NEXT:    sll a4, a1, a6
; RV32I-NEXT:    bltu a2, a5, .LBB25_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    srl a7, a1, a2
; RV32I-NEXT:    j .LBB25_3
; RV32I-NEXT:  .LBB25_2:
; RV32I-NEXT:    srl a3, a0, a2
; RV32I-NEXT:    or a7, a3, a4
; RV32I-NEXT:  .LBB25_3:
; RV32I-NEXT:    li t0, 64
; RV32I-NEXT:    mv a3, a0
; RV32I-NEXT:    beqz a2, .LBB25_5
; RV32I-NEXT:  # %bb.4:
; RV32I-NEXT:    mv a3, a7
; RV32I-NEXT:  .LBB25_5:
; RV32I-NEXT:    sub a7, t0, a2
; RV32I-NEXT:    bltu a2, a5, .LBB25_8
; RV32I-NEXT:  # %bb.6:
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    bgeu a7, a5, .LBB25_9
; RV32I-NEXT:  .LBB25_7:
; RV32I-NEXT:    sll a5, a0, a6
; RV32I-NEXT:    neg a6, a7
; RV32I-NEXT:    srl a0, a0, a6
; RV32I-NEXT:    or a0, a0, a4
; RV32I-NEXT:    bnez a7, .LBB25_10
; RV32I-NEXT:    j .LBB25_11
; RV32I-NEXT:  .LBB25_8:
; RV32I-NEXT:    srl a2, a1, a2
; RV32I-NEXT:    bltu a7, a5, .LBB25_7
; RV32I-NEXT:  .LBB25_9:
; RV32I-NEXT:    li a5, 0
; RV32I-NEXT:    sll a0, a0, a7
; RV32I-NEXT:    beqz a7, .LBB25_11
; RV32I-NEXT:  .LBB25_10:
; RV32I-NEXT:    mv a1, a0
; RV32I-NEXT:  .LBB25_11:
; RV32I-NEXT:    or a0, a3, a5
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rotr_64_zext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a2, 64
; RV64I-NEXT:    subw a2, a2, a1
; RV64I-NEXT:    srl a1, a0, a1
; RV64I-NEXT:    sll a0, a0, a2
; RV64I-NEXT:    or a0, a1, a0
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: rotr_64_zext:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    li a5, 32
; RV32ZBB-NEXT:    neg a6, a2
; RV32ZBB-NEXT:    sll a4, a1, a6
; RV32ZBB-NEXT:    bltu a2, a5, .LBB25_2
; RV32ZBB-NEXT:  # %bb.1:
; RV32ZBB-NEXT:    srl a7, a1, a2
; RV32ZBB-NEXT:    j .LBB25_3
; RV32ZBB-NEXT:  .LBB25_2:
; RV32ZBB-NEXT:    srl a3, a0, a2
; RV32ZBB-NEXT:    or a7, a3, a4
; RV32ZBB-NEXT:  .LBB25_3:
; RV32ZBB-NEXT:    li t0, 64
; RV32ZBB-NEXT:    mv a3, a0
; RV32ZBB-NEXT:    beqz a2, .LBB25_5
; RV32ZBB-NEXT:  # %bb.4:
; RV32ZBB-NEXT:    mv a3, a7
; RV32ZBB-NEXT:  .LBB25_5:
; RV32ZBB-NEXT:    sub a7, t0, a2
; RV32ZBB-NEXT:    bltu a2, a5, .LBB25_8
; RV32ZBB-NEXT:  # %bb.6:
; RV32ZBB-NEXT:    li a2, 0
; RV32ZBB-NEXT:    bgeu a7, a5, .LBB25_9
; RV32ZBB-NEXT:  .LBB25_7:
; RV32ZBB-NEXT:    sll a5, a0, a6
; RV32ZBB-NEXT:    neg a6, a7
; RV32ZBB-NEXT:    srl a0, a0, a6
; RV32ZBB-NEXT:    or a0, a0, a4
; RV32ZBB-NEXT:    bnez a7, .LBB25_10
; RV32ZBB-NEXT:    j .LBB25_11
; RV32ZBB-NEXT:  .LBB25_8:
; RV32ZBB-NEXT:    srl a2, a1, a2
; RV32ZBB-NEXT:    bltu a7, a5, .LBB25_7
; RV32ZBB-NEXT:  .LBB25_9:
; RV32ZBB-NEXT:    li a5, 0
; RV32ZBB-NEXT:    sll a0, a0, a7
; RV32ZBB-NEXT:    beqz a7, .LBB25_11
; RV32ZBB-NEXT:  .LBB25_10:
; RV32ZBB-NEXT:    mv a1, a0
; RV32ZBB-NEXT:  .LBB25_11:
; RV32ZBB-NEXT:    or a0, a3, a5
; RV32ZBB-NEXT:    or a1, a2, a1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: rotr_64_zext:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    li a2, 64
; RV64ZBB-NEXT:    subw a2, a2, a1
; RV64ZBB-NEXT:    srl a1, a0, a1
; RV64ZBB-NEXT:    sll a0, a0, a2
; RV64ZBB-NEXT:    or a0, a1, a0
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: rotr_64_zext:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    li a5, 32
; RV32XTHEADBB-NEXT:    neg a6, a2
; RV32XTHEADBB-NEXT:    sll a4, a1, a6
; RV32XTHEADBB-NEXT:    bltu a2, a5, .LBB25_2
; RV32XTHEADBB-NEXT:  # %bb.1:
; RV32XTHEADBB-NEXT:    srl a7, a1, a2
; RV32XTHEADBB-NEXT:    j .LBB25_3
; RV32XTHEADBB-NEXT:  .LBB25_2:
; RV32XTHEADBB-NEXT:    srl a3, a0, a2
; RV32XTHEADBB-NEXT:    or a7, a3, a4
; RV32XTHEADBB-NEXT:  .LBB25_3:
; RV32XTHEADBB-NEXT:    li t0, 64
; RV32XTHEADBB-NEXT:    mv a3, a0
; RV32XTHEADBB-NEXT:    beqz a2, .LBB25_5
; RV32XTHEADBB-NEXT:  # %bb.4:
; RV32XTHEADBB-NEXT:    mv a3, a7
; RV32XTHEADBB-NEXT:  .LBB25_5:
; RV32XTHEADBB-NEXT:    sub a7, t0, a2
; RV32XTHEADBB-NEXT:    bltu a2, a5, .LBB25_8
; RV32XTHEADBB-NEXT:  # %bb.6:
; RV32XTHEADBB-NEXT:    li a2, 0
; RV32XTHEADBB-NEXT:    bgeu a7, a5, .LBB25_9
; RV32XTHEADBB-NEXT:  .LBB25_7:
; RV32XTHEADBB-NEXT:    sll a5, a0, a6
; RV32XTHEADBB-NEXT:    neg a6, a7
; RV32XTHEADBB-NEXT:    srl a0, a0, a6
; RV32XTHEADBB-NEXT:    or a0, a0, a4
; RV32XTHEADBB-NEXT:    bnez a7, .LBB25_10
; RV32XTHEADBB-NEXT:    j .LBB25_11
; RV32XTHEADBB-NEXT:  .LBB25_8:
; RV32XTHEADBB-NEXT:    srl a2, a1, a2
; RV32XTHEADBB-NEXT:    bltu a7, a5, .LBB25_7
; RV32XTHEADBB-NEXT:  .LBB25_9:
; RV32XTHEADBB-NEXT:    li a5, 0
; RV32XTHEADBB-NEXT:    sll a0, a0, a7
; RV32XTHEADBB-NEXT:    beqz a7, .LBB25_11
; RV32XTHEADBB-NEXT:  .LBB25_10:
; RV32XTHEADBB-NEXT:    mv a1, a0
; RV32XTHEADBB-NEXT:  .LBB25_11:
; RV32XTHEADBB-NEXT:    or a0, a3, a5
; RV32XTHEADBB-NEXT:    or a1, a2, a1
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: rotr_64_zext:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    li a2, 64
; RV64XTHEADBB-NEXT:    subw a2, a2, a1
; RV64XTHEADBB-NEXT:    srl a1, a0, a1
; RV64XTHEADBB-NEXT:    sll a0, a0, a2
; RV64XTHEADBB-NEXT:    or a0, a1, a0
; RV64XTHEADBB-NEXT:    ret
  %z = sub i32 64, %y
  %zext = zext i32 %z to i64
  %zexty = zext i32 %y to i64
  %b = lshr i64 %x, %zexty
  %c = shl i64 %x, %zext
  %d = or i64 %b, %c
  ret i64 %d
}
