; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 4
; RUN: opt -passes='print<access-info>' -disable-output %s 2>&1 | FileCheck --check-prefixes=COMMON,MAXLEN %s
; RUN: opt -passes='print<access-info>' -disable-output -mtriple=arm64-apple-macosx %s 2>&1 | FileCheck --check-prefixes=COMMON,VW128 %s
; RUN: opt -passes='print<access-info>' -disable-output -mtriple=arm64-apple-macosx -mattr=+sve %s 2>&1 | FileCheck --check-prefixes=COMMON,MAXLEN %s

; REQUIRES: aarch64-registered-target

target datalayout = "e-m:o-i64:64-i128:128-n32:64-S128"

; If the dependence distance is not a constant, whether it gets identified as backwards or unknown depends on the minimum distance and the target's vector length.

define void @backward_min_distance_8(ptr %A, i64 %N) {
; COMMON-LABEL: 'backward_min_distance_8'
; COMMON-NEXT:    loop:
; COMMON-NEXT:      Memory dependences are safe with run-time checks
; COMMON-NEXT:      Dependences:
; COMMON-NEXT:      Run-time memory checks:
; COMMON-NEXT:      Check 0:
; COMMON-NEXT:        Comparing group ([[GRP1:0x[0-9a-f]+]]):
; COMMON-NEXT:          %gep.off.iv = getelementptr inbounds i8, ptr %gep.off, i64 %iv
; COMMON-NEXT:        Against group ([[GRP2:0x[0-9a-f]+]]):
; COMMON-NEXT:          %gep = getelementptr inbounds i8, ptr %A, i64 %iv
; COMMON-NEXT:      Grouped accesses:
; COMMON-NEXT:        Group [[GRP1]]:
; COMMON-NEXT:          (Low: {(1 + %A)<nuw>,+,1}<nuw><%outer.header> High: {(257 + %A),+,1}<nw><%outer.header>)
; COMMON-NEXT:            Member: {{\{\{}}(1 + %A)<nuw>,+,1}<nuw><%outer.header>,+,1}<nuw><%loop>
; COMMON-NEXT:        Group [[GRP2]]:
; COMMON-NEXT:          (Low: %A High: (256 + %A))
; COMMON-NEXT:            Member: {%A,+,1}<nuw><%loop>
; COMMON-EMPTY:
; COMMON-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; COMMON-NEXT:      SCEV assumptions:
; COMMON-EMPTY:
; COMMON-NEXT:      Expressions re-written:
; COMMON-NEXT:    outer.header:
; COMMON-NEXT:      Report: loop is not the innermost loop
; COMMON-NEXT:      Dependences:
; COMMON-NEXT:      Run-time memory checks:
; COMMON-NEXT:      Grouped accesses:
; COMMON-EMPTY:
; COMMON-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; COMMON-NEXT:      SCEV assumptions:
; COMMON-EMPTY:
; COMMON-NEXT:      Expressions re-written:
;
entry:
  br label %outer.header

outer.header:
  %outer.iv = phi i64 [ 1, %entry ], [ %outer.iv.next, %outer.latch ]
  %gep.off = getelementptr inbounds i8, ptr %A, i64 %outer.iv
  br label %loop

loop:
  %iv = phi i64 [ 0, %outer.header ], [ %iv.next, %loop ]
  %gep = getelementptr inbounds i8, ptr %A, i64 %iv
  %l = load i8 , ptr %gep, align 4
  %add = add nsw i8 %l, 5
  %gep.off.iv = getelementptr inbounds i8, ptr %gep.off, i64 %iv
  store i8 %add, ptr %gep.off.iv, align 4
  %iv.next = add nuw nsw i64 %iv, 1
  %exitcond.not = icmp eq i64 %iv.next, 256
  br i1 %exitcond.not, label %outer.latch, label %loop

outer.latch:
  %outer.iv.next = add nuw nsw i64 %outer.iv, 1
  %ec.2 = icmp eq i64 %outer.iv.next, %N
  br i1 %ec.2, label %exit, label %outer.header

exit:
  ret void
}

define void @backward_min_distance_120(ptr %A, i64 %N) {
; COMMON-LABEL: 'backward_min_distance_120'
; COMMON-NEXT:    loop:
; COMMON-NEXT:      Memory dependences are safe with run-time checks
; COMMON-NEXT:      Dependences:
; COMMON-NEXT:      Run-time memory checks:
; COMMON-NEXT:      Check 0:
; COMMON-NEXT:        Comparing group ([[GRP3:0x[0-9a-f]+]]):
; COMMON-NEXT:          %gep.off.iv = getelementptr inbounds i8, ptr %gep.off, i64 %iv
; COMMON-NEXT:        Against group ([[GRP4:0x[0-9a-f]+]]):
; COMMON-NEXT:          %gep = getelementptr inbounds i8, ptr %A, i64 %iv
; COMMON-NEXT:      Grouped accesses:
; COMMON-NEXT:        Group [[GRP3]]:
; COMMON-NEXT:          (Low: {(15 + %A)<nuw>,+,1}<nuw><%outer.header> High: {(271 + %A),+,1}<nw><%outer.header>)
; COMMON-NEXT:            Member: {{\{\{}}(15 + %A)<nuw>,+,1}<nuw><%outer.header>,+,1}<nuw><%loop>
; COMMON-NEXT:        Group [[GRP4]]:
; COMMON-NEXT:          (Low: %A High: (256 + %A))
; COMMON-NEXT:            Member: {%A,+,1}<nuw><%loop>
; COMMON-EMPTY:
; COMMON-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; COMMON-NEXT:      SCEV assumptions:
; COMMON-EMPTY:
; COMMON-NEXT:      Expressions re-written:
; COMMON-NEXT:    outer.header:
; COMMON-NEXT:      Report: loop is not the innermost loop
; COMMON-NEXT:      Dependences:
; COMMON-NEXT:      Run-time memory checks:
; COMMON-NEXT:      Grouped accesses:
; COMMON-EMPTY:
; COMMON-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; COMMON-NEXT:      SCEV assumptions:
; COMMON-EMPTY:
; COMMON-NEXT:      Expressions re-written:
;
entry:
  br label %outer.header

outer.header:
  %outer.iv = phi i64 [ 15, %entry ], [ %outer.iv.next, %outer.latch ]
  %gep.off = getelementptr inbounds i8, ptr %A, i64 %outer.iv
  br label %loop

loop:
  %iv = phi i64 [ 0, %outer.header ], [ %iv.next, %loop ]
  %gep = getelementptr inbounds i8, ptr %A, i64 %iv
  %l = load i8 , ptr %gep, align 4
  %add = add nsw i8 %l, 5
  %gep.off.iv = getelementptr inbounds i8, ptr %gep.off, i64 %iv
  store i8 %add, ptr %gep.off.iv, align 4
  %iv.next = add nuw nsw i64 %iv, 1
  %exitcond.not = icmp eq i64 %iv.next, 256
  br i1 %exitcond.not, label %outer.latch, label %loop

outer.latch:
  %outer.iv.next = add nuw nsw i64 %outer.iv, 1
  %ec.2 = icmp eq i64 %outer.iv.next, %N
  br i1 %ec.2, label %exit, label %outer.header

exit:
  ret void
}

define void @backward_min_distance_128(ptr %A, i64 %N) {
; COMMON-LABEL: 'backward_min_distance_128'
; COMMON-NEXT:    loop:
; COMMON-NEXT:      Memory dependences are safe with run-time checks
; COMMON-NEXT:      Dependences:
; COMMON-NEXT:      Run-time memory checks:
; COMMON-NEXT:      Check 0:
; COMMON-NEXT:        Comparing group ([[GRP13:0x[0-9a-f]+]]):
; COMMON-NEXT:          %gep.off.iv = getelementptr inbounds i8, ptr %gep.off, i64 %iv
; COMMON-NEXT:        Against group ([[GRP14:0x[0-9a-f]+]]):
; COMMON-NEXT:          %gep = getelementptr inbounds i8, ptr %A, i64 %iv
; COMMON-NEXT:      Grouped accesses:
; COMMON-NEXT:        Group [[GRP13]]:
; COMMON-NEXT:          (Low: {(16 + %A)<nuw>,+,1}<nuw><%outer.header> High: {(272 + %A),+,1}<nw><%outer.header>)
; COMMON-NEXT:            Member: {{\{\{}}(16 + %A)<nuw>,+,1}<nuw><%outer.header>,+,1}<nuw><%loop>
; COMMON-NEXT:        Group [[GRP14]]:
; COMMON-NEXT:          (Low: %A High: (256 + %A))
; COMMON-NEXT:            Member: {%A,+,1}<nuw><%loop>
; COMMON-EMPTY:
; COMMON-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; COMMON-NEXT:      SCEV assumptions:
; COMMON-EMPTY:
; COMMON-NEXT:      Expressions re-written:
; COMMON-NEXT:    outer.header:
; COMMON-NEXT:      Report: loop is not the innermost loop
; COMMON-NEXT:      Dependences:
; COMMON-NEXT:      Run-time memory checks:
; COMMON-NEXT:      Grouped accesses:
; COMMON-EMPTY:
; COMMON-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; COMMON-NEXT:      SCEV assumptions:
; COMMON-EMPTY:
; COMMON-NEXT:      Expressions re-written:
;
entry:
  br label %outer.header

outer.header:
  %outer.iv = phi i64 [ 16, %entry ], [ %outer.iv.next, %outer.latch ]
  %gep.off = getelementptr inbounds i8, ptr %A, i64 %outer.iv
  br label %loop

loop:
  %iv = phi i64 [ 0, %outer.header ], [ %iv.next, %loop ]
  %gep = getelementptr inbounds i8, ptr %A, i64 %iv
  %l = load i8 , ptr %gep, align 4
  %add = add nsw i8 %l, 5
  %gep.off.iv = getelementptr inbounds i8, ptr %gep.off, i64 %iv
  store i8 %add, ptr %gep.off.iv, align 4
  %iv.next = add nuw nsw i64 %iv, 1
  %exitcond.not = icmp eq i64 %iv.next, 256
  br i1 %exitcond.not, label %outer.latch, label %loop

outer.latch:
  %outer.iv.next = add nuw nsw i64 %outer.iv, 1
  %ec.2 = icmp eq i64 %outer.iv.next, %N
  br i1 %ec.2, label %exit, label %outer.header

exit:
  ret void
}

define void @backward_min_distance_256(ptr %A, i64 %N) {
; MAXLEN-LABEL: 'backward_min_distance_256'
; MAXLEN-NEXT:    loop:
; MAXLEN-NEXT:      Memory dependences are safe with run-time checks
; MAXLEN-NEXT:      Dependences:
; MAXLEN-NEXT:      Run-time memory checks:
; MAXLEN-NEXT:      Check 0:
; MAXLEN-NEXT:        Comparing group ([[GRP17:0x[0-9a-f]+]]):
; MAXLEN-NEXT:          %gep.off.iv = getelementptr inbounds i8, ptr %gep.off, i64 %iv
; MAXLEN-NEXT:        Against group ([[GRP18:0x[0-9a-f]+]]):
; MAXLEN-NEXT:          %gep = getelementptr inbounds i8, ptr %A, i64 %iv
; MAXLEN-NEXT:      Grouped accesses:
; MAXLEN-NEXT:        Group [[GRP17]]:
; MAXLEN-NEXT:          (Low: {(32 + %A)<nuw>,+,1}<nuw><%outer.header> High: {(288 + %A),+,1}<nw><%outer.header>)
; MAXLEN-NEXT:            Member: {{\{\{}}(32 + %A)<nuw>,+,1}<nuw><%outer.header>,+,1}<nuw><%loop>
; MAXLEN-NEXT:        Group [[GRP18]]:
; MAXLEN-NEXT:          (Low: %A High: (256 + %A))
; MAXLEN-NEXT:            Member: {%A,+,1}<nuw><%loop>
; MAXLEN-EMPTY:
; MAXLEN-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; MAXLEN-NEXT:      SCEV assumptions:
; MAXLEN-EMPTY:
; MAXLEN-NEXT:      Expressions re-written:
; MAXLEN-NEXT:    outer.header:
; MAXLEN-NEXT:      Report: loop is not the innermost loop
; MAXLEN-NEXT:      Dependences:
; MAXLEN-NEXT:      Run-time memory checks:
; MAXLEN-NEXT:      Grouped accesses:
; MAXLEN-EMPTY:
; MAXLEN-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; MAXLEN-NEXT:      SCEV assumptions:
; MAXLEN-EMPTY:
; MAXLEN-NEXT:      Expressions re-written:
;
; VW128-LABEL: 'backward_min_distance_256'
; VW128-NEXT:    loop:
; VW128-NEXT:      Memory dependences are safe with a maximum safe vector width of 256 bits
; VW128-NEXT:      Dependences:
; VW128-NEXT:        BackwardVectorizable:
; VW128-NEXT:            %l = load i8, ptr %gep, align 4 ->
; VW128-NEXT:            store i8 %add, ptr %gep.off.iv, align 4
; VW128-EMPTY:
; VW128-NEXT:      Run-time memory checks:
; VW128-NEXT:      Grouped accesses:
; VW128-EMPTY:
; VW128-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; VW128-NEXT:      SCEV assumptions:
; VW128-EMPTY:
; VW128-NEXT:      Expressions re-written:
; VW128-NEXT:    outer.header:
; VW128-NEXT:      Report: loop is not the innermost loop
; VW128-NEXT:      Dependences:
; VW128-NEXT:      Run-time memory checks:
; VW128-NEXT:      Grouped accesses:
; VW128-EMPTY:
; VW128-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; VW128-NEXT:      SCEV assumptions:
; VW128-EMPTY:
; VW128-NEXT:      Expressions re-written:
;
entry:
  br label %outer.header

outer.header:
  %outer.iv = phi i64 [ 32, %entry ], [ %outer.iv.next, %outer.latch ]
  %gep.off = getelementptr inbounds i8, ptr %A, i64 %outer.iv
  br label %loop

loop:
  %iv = phi i64 [ 0, %outer.header ], [ %iv.next, %loop ]
  %gep = getelementptr inbounds i8, ptr %A, i64 %iv
  %l = load i8 , ptr %gep, align 4
  %add = add nsw i8 %l, 5
  %gep.off.iv = getelementptr inbounds i8, ptr %gep.off, i64 %iv
  store i8 %add, ptr %gep.off.iv, align 4
  %iv.next = add nuw nsw i64 %iv, 1
  %exitcond.not = icmp eq i64 %iv.next, 256
  br i1 %exitcond.not, label %outer.latch, label %loop

outer.latch:
  %outer.iv.next = add nuw nsw i64 %outer.iv, 1
  %ec.2 = icmp eq i64 %outer.iv.next, %N
  br i1 %ec.2, label %exit, label %outer.header

exit:
  ret void
}
