; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc  -O0 -mtriple=mipsel-linux-gnu -global-isel  -verify-machineinstrs %s -o -| FileCheck %s -check-prefixes=MIPS32

define zeroext i8 @_16_bit_positive_offset(ptr %a) {
; MIPS32-LABEL: _16_bit_positive_offset:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lbu $2, 32767($4)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %arrayidx = getelementptr inbounds i8, ptr %a, i32 32767
  %0 = load i8, ptr %arrayidx
  ret i8 %0
}

define void @_16_bit_negative_offset(i8 %val, ptr %a) {
; MIPS32-LABEL: _16_bit_negative_offset:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sb $4, -32768($5)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %arrayidx = getelementptr inbounds i8, ptr %a, i32 -32768
  store i8 %val, ptr %arrayidx
  ret void
}

define void @_large_positive_offset(i8 %val, ptr %a) {
; MIPS32-LABEL: _large_positive_offset:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    ori $1, $zero, 32768
; MIPS32-NEXT:    addu $1, $5, $1
; MIPS32-NEXT:    sb $4, 0($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %arrayidx = getelementptr inbounds i8, ptr %a, i32 32768
  store i8 %val, ptr %arrayidx
  ret void
}

define signext i8 @_large_negative_offset(ptr %a) {
; MIPS32-LABEL: _large_negative_offset:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, 65535
; MIPS32-NEXT:    ori $1, $1, 32767
; MIPS32-NEXT:    addu $1, $4, $1
; MIPS32-NEXT:    lb $2, 0($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %arrayidx = getelementptr inbounds i8, ptr %a, i32 -32769
  %0 = load i8, ptr %arrayidx
  ret i8 %0
}

define float @fold_f32_load(ptr %a) {
; MIPS32-LABEL: fold_f32_load:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lwc1 $f0, 40($4)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %arrayidx = getelementptr inbounds float, ptr %a, i32 10
  %0 = load float, ptr %arrayidx
  ret float %0
}

define void @fold_f64_store(double %val, ptr %a) {
; MIPS32-LABEL: fold_f64_store:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sdc1 $f12, -80($6)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %arrayidx = getelementptr inbounds double, ptr %a, i32 -10
  store double %val, ptr %arrayidx
  ret void
}

define i16 @fold_i16_load(ptr %a) {
; MIPS32-LABEL: fold_i16_load:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lhu $2, -20($4)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %arrayidx = getelementptr inbounds i16, ptr %a, i32 -10
  %0 = load i16, ptr %arrayidx
  ret i16 %0
}

define void @fold_i32_store(i32 %val, ptr %a) {
; MIPS32-LABEL: fold_i32_store:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sw $4, 40($5)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %arrayidx = getelementptr inbounds i32, ptr %a, i32 10
  store i32 %val, ptr %arrayidx
  ret void
}


