; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5

; FIXME: Currently block machineinstr verifier due to SI BUNDLE pass break physical register liveness. Should remove when the issue is fixed up

; RUN: llc -mtriple=amdgcn -mcpu=tahiti -verify-machineinstrs=0 < %s | FileCheck -check-prefix=SI %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga -verify-machineinstrs=0 < %s | FileCheck -check-prefix=VI %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -verify-machineinstrs=0 < %s | FileCheck -check-prefix=GFX9 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 -verify-machineinstrs=0 < %s | FileCheck -check-prefixes=GFX11,GFX11-TRUE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 -verify-machineinstrs=0 < %s | FileCheck -check-prefixes=GFX11,GFX11-FAKE16 %s

define <32 x float> @bitcast_v32i32_to_v32f32(<32 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v32i32_to_v32f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:4
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v31
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB0_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v31, vcc, 3, v31
; SI-NEXT:    v_add_i32_e32 v30, vcc, 3, v30
; SI-NEXT:    v_add_i32_e32 v29, vcc, 3, v29
; SI-NEXT:    v_add_i32_e32 v28, vcc, 3, v28
; SI-NEXT:    v_add_i32_e32 v27, vcc, 3, v27
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v26
; SI-NEXT:    v_add_i32_e32 v25, vcc, 3, v25
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    v_add_i32_e32 v23, vcc, 3, v23
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v22
; SI-NEXT:    v_add_i32_e32 v21, vcc, 3, v21
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  .LBB0_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v32i32_to_v32f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:4
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v31
; VI-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB0_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u32_e32 v31, vcc, 3, v31
; VI-NEXT:    v_add_u32_e32 v30, vcc, 3, v30
; VI-NEXT:    v_add_u32_e32 v29, vcc, 3, v29
; VI-NEXT:    v_add_u32_e32 v28, vcc, 3, v28
; VI-NEXT:    v_add_u32_e32 v27, vcc, 3, v27
; VI-NEXT:    v_add_u32_e32 v26, vcc, 3, v26
; VI-NEXT:    v_add_u32_e32 v25, vcc, 3, v25
; VI-NEXT:    v_add_u32_e32 v24, vcc, 3, v24
; VI-NEXT:    v_add_u32_e32 v23, vcc, 3, v23
; VI-NEXT:    v_add_u32_e32 v22, vcc, 3, v22
; VI-NEXT:    v_add_u32_e32 v21, vcc, 3, v21
; VI-NEXT:    v_add_u32_e32 v20, vcc, 3, v20
; VI-NEXT:    v_add_u32_e32 v19, vcc, 3, v19
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_add_u32_e32 v17, vcc, 3, v17
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB0_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v32i32_to_v32f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v31
; GFX9-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB0_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v31, 3, v31
; GFX9-NEXT:    v_add_u32_e32 v30, 3, v30
; GFX9-NEXT:    v_add_u32_e32 v29, 3, v29
; GFX9-NEXT:    v_add_u32_e32 v28, 3, v28
; GFX9-NEXT:    v_add_u32_e32 v27, 3, v27
; GFX9-NEXT:    v_add_u32_e32 v26, 3, v26
; GFX9-NEXT:    v_add_u32_e32 v25, 3, v25
; GFX9-NEXT:    v_add_u32_e32 v24, 3, v24
; GFX9-NEXT:    v_add_u32_e32 v23, 3, v23
; GFX9-NEXT:    v_add_u32_e32 v22, 3, v22
; GFX9-NEXT:    v_add_u32_e32 v21, 3, v21
; GFX9-NEXT:    v_add_u32_e32 v20, 3, v20
; GFX9-NEXT:    v_add_u32_e32 v19, 3, v19
; GFX9-NEXT:    v_add_u32_e32 v18, 3, v18
; GFX9-NEXT:    v_add_u32_e32 v17, 3, v17
; GFX9-NEXT:    v_add_u32_e32 v16, 3, v16
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB0_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v32i32_to_v32f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    scratch_load_b32 v32, off, s32 offset:4
; GFX11-NEXT:    scratch_load_b32 v31, off, s32
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    s_waitcnt vmcnt(1)
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v32
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB0_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_nc_u32_e32 v31, 3, v31
; GFX11-NEXT:    v_add_nc_u32_e32 v30, 3, v30
; GFX11-NEXT:    v_add_nc_u32_e32 v29, 3, v29
; GFX11-NEXT:    v_add_nc_u32_e32 v28, 3, v28
; GFX11-NEXT:    v_add_nc_u32_e32 v27, 3, v27
; GFX11-NEXT:    v_add_nc_u32_e32 v26, 3, v26
; GFX11-NEXT:    v_add_nc_u32_e32 v25, 3, v25
; GFX11-NEXT:    v_add_nc_u32_e32 v24, 3, v24
; GFX11-NEXT:    v_add_nc_u32_e32 v23, 3, v23
; GFX11-NEXT:    v_add_nc_u32_e32 v22, 3, v22
; GFX11-NEXT:    v_add_nc_u32_e32 v21, 3, v21
; GFX11-NEXT:    v_add_nc_u32_e32 v20, 3, v20
; GFX11-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  .LBB0_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <32 x i32> %a, splat (i32 3)
  %a2 = bitcast <32 x i32> %a1 to <32 x float>
  br label %end

cmp.false:
  %a3 = bitcast <32 x i32> %a to <32 x float>
  br label %end

end:
  %phi = phi <32 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <32 x float> %phi
}

define inreg <32 x float> @bitcast_v32i32_to_v32f32_scalar(<32 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v32i32_to_v32f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; SI-NEXT:    v_mov_b32_e32 v31, v17
; SI-NEXT:    v_mov_b32_e32 v30, v16
; SI-NEXT:    v_mov_b32_e32 v29, v15
; SI-NEXT:    v_mov_b32_e32 v28, v14
; SI-NEXT:    v_mov_b32_e32 v27, v13
; SI-NEXT:    v_mov_b32_e32 v26, v12
; SI-NEXT:    v_mov_b32_e32 v25, v11
; SI-NEXT:    v_mov_b32_e32 v24, v10
; SI-NEXT:    v_mov_b32_e32 v23, v9
; SI-NEXT:    v_mov_b32_e32 v22, v8
; SI-NEXT:    v_mov_b32_e32 v21, v7
; SI-NEXT:    v_mov_b32_e32 v20, v6
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v32, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB1_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB1_3
; SI-NEXT:  .LBB1_2: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v31, vcc, 3, v31
; SI-NEXT:    v_add_i32_e32 v30, vcc, 3, v30
; SI-NEXT:    v_add_i32_e32 v29, vcc, 3, v29
; SI-NEXT:    v_add_i32_e32 v28, vcc, 3, v28
; SI-NEXT:    v_add_i32_e32 v27, vcc, 3, v27
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v26
; SI-NEXT:    v_add_i32_e32 v25, vcc, 3, v25
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    v_add_i32_e32 v23, vcc, 3, v23
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v22
; SI-NEXT:    v_add_i32_e32 v21, vcc, 3, v21
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v32, vcc, 3, v32
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  .LBB1_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v18, v32
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB1_4:
; SI-NEXT:    s_branch .LBB1_2
;
; VI-LABEL: bitcast_v32i32_to_v32f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; VI-NEXT:    v_mov_b32_e32 v31, v17
; VI-NEXT:    v_mov_b32_e32 v30, v16
; VI-NEXT:    v_mov_b32_e32 v29, v15
; VI-NEXT:    v_mov_b32_e32 v28, v14
; VI-NEXT:    v_mov_b32_e32 v27, v13
; VI-NEXT:    v_mov_b32_e32 v26, v12
; VI-NEXT:    v_mov_b32_e32 v25, v11
; VI-NEXT:    v_mov_b32_e32 v24, v10
; VI-NEXT:    v_mov_b32_e32 v23, v9
; VI-NEXT:    v_mov_b32_e32 v22, v8
; VI-NEXT:    v_mov_b32_e32 v21, v7
; VI-NEXT:    v_mov_b32_e32 v20, v6
; VI-NEXT:    v_mov_b32_e32 v19, v5
; VI-NEXT:    v_mov_b32_e32 v32, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB1_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB1_3
; VI-NEXT:  .LBB1_2: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v31, vcc, 3, v31
; VI-NEXT:    v_add_u32_e32 v30, vcc, 3, v30
; VI-NEXT:    v_add_u32_e32 v29, vcc, 3, v29
; VI-NEXT:    v_add_u32_e32 v28, vcc, 3, v28
; VI-NEXT:    v_add_u32_e32 v27, vcc, 3, v27
; VI-NEXT:    v_add_u32_e32 v26, vcc, 3, v26
; VI-NEXT:    v_add_u32_e32 v25, vcc, 3, v25
; VI-NEXT:    v_add_u32_e32 v24, vcc, 3, v24
; VI-NEXT:    v_add_u32_e32 v23, vcc, 3, v23
; VI-NEXT:    v_add_u32_e32 v22, vcc, 3, v22
; VI-NEXT:    v_add_u32_e32 v21, vcc, 3, v21
; VI-NEXT:    v_add_u32_e32 v20, vcc, 3, v20
; VI-NEXT:    v_add_u32_e32 v19, vcc, 3, v19
; VI-NEXT:    v_add_u32_e32 v32, vcc, 3, v32
; VI-NEXT:    v_add_u32_e32 v17, vcc, 3, v17
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB1_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v18, v32
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB1_4:
; VI-NEXT:    s_branch .LBB1_2
;
; GFX9-LABEL: bitcast_v32i32_to_v32f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; GFX9-NEXT:    v_mov_b32_e32 v31, v17
; GFX9-NEXT:    v_mov_b32_e32 v30, v16
; GFX9-NEXT:    v_mov_b32_e32 v29, v15
; GFX9-NEXT:    v_mov_b32_e32 v28, v14
; GFX9-NEXT:    v_mov_b32_e32 v27, v13
; GFX9-NEXT:    v_mov_b32_e32 v26, v12
; GFX9-NEXT:    v_mov_b32_e32 v25, v11
; GFX9-NEXT:    v_mov_b32_e32 v24, v10
; GFX9-NEXT:    v_mov_b32_e32 v23, v9
; GFX9-NEXT:    v_mov_b32_e32 v22, v8
; GFX9-NEXT:    v_mov_b32_e32 v21, v7
; GFX9-NEXT:    v_mov_b32_e32 v20, v6
; GFX9-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-NEXT:    v_mov_b32_e32 v32, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB1_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB1_3
; GFX9-NEXT:  .LBB1_2: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v31, 3, v31
; GFX9-NEXT:    v_add_u32_e32 v30, 3, v30
; GFX9-NEXT:    v_add_u32_e32 v29, 3, v29
; GFX9-NEXT:    v_add_u32_e32 v28, 3, v28
; GFX9-NEXT:    v_add_u32_e32 v27, 3, v27
; GFX9-NEXT:    v_add_u32_e32 v26, 3, v26
; GFX9-NEXT:    v_add_u32_e32 v25, 3, v25
; GFX9-NEXT:    v_add_u32_e32 v24, 3, v24
; GFX9-NEXT:    v_add_u32_e32 v23, 3, v23
; GFX9-NEXT:    v_add_u32_e32 v22, 3, v22
; GFX9-NEXT:    v_add_u32_e32 v21, 3, v21
; GFX9-NEXT:    v_add_u32_e32 v20, 3, v20
; GFX9-NEXT:    v_add_u32_e32 v19, 3, v19
; GFX9-NEXT:    v_add_u32_e32 v32, 3, v32
; GFX9-NEXT:    v_add_u32_e32 v17, 3, v17
; GFX9-NEXT:    v_add_u32_e32 v16, 3, v16
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB1_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v18, v32
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB1_4:
; GFX9-NEXT:    s_branch .LBB1_2
;
; GFX11-LABEL: bitcast_v32i32_to_v32f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v14 :: v_dual_mov_b32 v31, v13
; GFX11-NEXT:    v_dual_mov_b32 v30, v12 :: v_dual_mov_b32 v29, v11
; GFX11-NEXT:    v_dual_mov_b32 v28, v10 :: v_dual_mov_b32 v27, v9
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v26, v8 :: v_dual_mov_b32 v25, v7
; GFX11-NEXT:    v_dual_mov_b32 v24, v6 :: v_dual_mov_b32 v23, v5
; GFX11-NEXT:    v_dual_mov_b32 v22, v4 :: v_dual_mov_b32 v21, v3
; GFX11-NEXT:    v_dual_mov_b32 v20, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB1_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB1_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB1_3:
; GFX11-NEXT:  .LBB1_4: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v31, 3, v31
; GFX11-NEXT:    v_add_nc_u32_e32 v30, 3, v30
; GFX11-NEXT:    v_add_nc_u32_e32 v29, 3, v29
; GFX11-NEXT:    v_add_nc_u32_e32 v28, 3, v28
; GFX11-NEXT:    v_add_nc_u32_e32 v27, 3, v27
; GFX11-NEXT:    v_add_nc_u32_e32 v26, 3, v26
; GFX11-NEXT:    v_add_nc_u32_e32 v25, 3, v25
; GFX11-NEXT:    v_add_nc_u32_e32 v24, 3, v24
; GFX11-NEXT:    v_add_nc_u32_e32 v23, 3, v23
; GFX11-NEXT:    v_add_nc_u32_e32 v22, 3, v22
; GFX11-NEXT:    v_add_nc_u32_e32 v21, 3, v21
; GFX11-NEXT:    v_add_nc_u32_e32 v20, 3, v20
; GFX11-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <32 x i32> %a, splat (i32 3)
  %a2 = bitcast <32 x i32> %a1 to <32 x float>
  br label %end

cmp.false:
  %a3 = bitcast <32 x i32> %a to <32 x float>
  br label %end

end:
  %phi = phi <32 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <32 x float> %phi
}

define <32 x i32> @bitcast_v32f32_to_v32i32(<32 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v32f32_to_v32i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:4
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v31
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB2_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_f32_e32 v31, 1.0, v31
; SI-NEXT:    v_add_f32_e32 v30, 1.0, v30
; SI-NEXT:    v_add_f32_e32 v29, 1.0, v29
; SI-NEXT:    v_add_f32_e32 v28, 1.0, v28
; SI-NEXT:    v_add_f32_e32 v27, 1.0, v27
; SI-NEXT:    v_add_f32_e32 v26, 1.0, v26
; SI-NEXT:    v_add_f32_e32 v25, 1.0, v25
; SI-NEXT:    v_add_f32_e32 v24, 1.0, v24
; SI-NEXT:    v_add_f32_e32 v23, 1.0, v23
; SI-NEXT:    v_add_f32_e32 v22, 1.0, v22
; SI-NEXT:    v_add_f32_e32 v21, 1.0, v21
; SI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; SI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; SI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; SI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; SI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; SI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  .LBB2_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v32f32_to_v32i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:4
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v31
; VI-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB2_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_f32_e32 v31, 1.0, v31
; VI-NEXT:    v_add_f32_e32 v30, 1.0, v30
; VI-NEXT:    v_add_f32_e32 v29, 1.0, v29
; VI-NEXT:    v_add_f32_e32 v28, 1.0, v28
; VI-NEXT:    v_add_f32_e32 v27, 1.0, v27
; VI-NEXT:    v_add_f32_e32 v26, 1.0, v26
; VI-NEXT:    v_add_f32_e32 v25, 1.0, v25
; VI-NEXT:    v_add_f32_e32 v24, 1.0, v24
; VI-NEXT:    v_add_f32_e32 v23, 1.0, v23
; VI-NEXT:    v_add_f32_e32 v22, 1.0, v22
; VI-NEXT:    v_add_f32_e32 v21, 1.0, v21
; VI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; VI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; VI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; VI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; VI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  .LBB2_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v32f32_to_v32i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v31
; GFX9-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB2_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_f32_e32 v31, 1.0, v31
; GFX9-NEXT:    v_add_f32_e32 v30, 1.0, v30
; GFX9-NEXT:    v_add_f32_e32 v29, 1.0, v29
; GFX9-NEXT:    v_add_f32_e32 v28, 1.0, v28
; GFX9-NEXT:    v_add_f32_e32 v27, 1.0, v27
; GFX9-NEXT:    v_add_f32_e32 v26, 1.0, v26
; GFX9-NEXT:    v_add_f32_e32 v25, 1.0, v25
; GFX9-NEXT:    v_add_f32_e32 v24, 1.0, v24
; GFX9-NEXT:    v_add_f32_e32 v23, 1.0, v23
; GFX9-NEXT:    v_add_f32_e32 v22, 1.0, v22
; GFX9-NEXT:    v_add_f32_e32 v21, 1.0, v21
; GFX9-NEXT:    v_add_f32_e32 v20, 1.0, v20
; GFX9-NEXT:    v_add_f32_e32 v19, 1.0, v19
; GFX9-NEXT:    v_add_f32_e32 v18, 1.0, v18
; GFX9-NEXT:    v_add_f32_e32 v17, 1.0, v17
; GFX9-NEXT:    v_add_f32_e32 v16, 1.0, v16
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  .LBB2_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v32f32_to_v32i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    scratch_load_b32 v32, off, s32 offset:4
; GFX11-NEXT:    scratch_load_b32 v31, off, s32
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    s_waitcnt vmcnt(1)
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v32
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB2_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_dual_add_f32 v31, 1.0, v31 :: v_dual_add_f32 v30, 1.0, v30
; GFX11-NEXT:    v_dual_add_f32 v29, 1.0, v29 :: v_dual_add_f32 v28, 1.0, v28
; GFX11-NEXT:    v_dual_add_f32 v27, 1.0, v27 :: v_dual_add_f32 v26, 1.0, v26
; GFX11-NEXT:    v_dual_add_f32 v25, 1.0, v25 :: v_dual_add_f32 v24, 1.0, v24
; GFX11-NEXT:    v_dual_add_f32 v23, 1.0, v23 :: v_dual_add_f32 v22, 1.0, v22
; GFX11-NEXT:    v_dual_add_f32 v21, 1.0, v21 :: v_dual_add_f32 v20, 1.0, v20
; GFX11-NEXT:    v_dual_add_f32 v19, 1.0, v19 :: v_dual_add_f32 v18, 1.0, v18
; GFX11-NEXT:    v_dual_add_f32 v17, 1.0, v17 :: v_dual_add_f32 v16, 1.0, v16
; GFX11-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  .LBB2_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <32 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <32 x float> %a1 to <32 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <32 x float> %a to <32 x i32>
  br label %end

end:
  %phi = phi <32 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <32 x i32> %phi
}

define inreg <32 x i32> @bitcast_v32f32_to_v32i32_scalar(<32 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v32f32_to_v32i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; SI-NEXT:    v_mov_b32_e32 v31, v17
; SI-NEXT:    v_mov_b32_e32 v30, v16
; SI-NEXT:    v_mov_b32_e32 v29, v15
; SI-NEXT:    v_mov_b32_e32 v28, v14
; SI-NEXT:    v_mov_b32_e32 v27, v13
; SI-NEXT:    v_mov_b32_e32 v26, v12
; SI-NEXT:    v_mov_b32_e32 v25, v11
; SI-NEXT:    v_mov_b32_e32 v24, v10
; SI-NEXT:    v_mov_b32_e32 v23, v9
; SI-NEXT:    v_mov_b32_e32 v22, v8
; SI-NEXT:    v_mov_b32_e32 v21, v7
; SI-NEXT:    v_mov_b32_e32 v20, v6
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v32, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB3_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB3_3
; SI-NEXT:  .LBB3_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v31, 1.0, v31
; SI-NEXT:    v_add_f32_e32 v30, 1.0, v30
; SI-NEXT:    v_add_f32_e32 v29, 1.0, v29
; SI-NEXT:    v_add_f32_e32 v28, 1.0, v28
; SI-NEXT:    v_add_f32_e32 v27, 1.0, v27
; SI-NEXT:    v_add_f32_e32 v26, 1.0, v26
; SI-NEXT:    v_add_f32_e32 v25, 1.0, v25
; SI-NEXT:    v_add_f32_e32 v24, 1.0, v24
; SI-NEXT:    v_add_f32_e32 v23, 1.0, v23
; SI-NEXT:    v_add_f32_e32 v22, 1.0, v22
; SI-NEXT:    v_add_f32_e32 v21, 1.0, v21
; SI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; SI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; SI-NEXT:    v_add_f32_e32 v32, 1.0, v32
; SI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; SI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; SI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  .LBB3_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v18, v32
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB3_4:
; SI-NEXT:    s_branch .LBB3_2
;
; VI-LABEL: bitcast_v32f32_to_v32i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; VI-NEXT:    v_mov_b32_e32 v31, v17
; VI-NEXT:    v_mov_b32_e32 v30, v16
; VI-NEXT:    v_mov_b32_e32 v29, v15
; VI-NEXT:    v_mov_b32_e32 v28, v14
; VI-NEXT:    v_mov_b32_e32 v27, v13
; VI-NEXT:    v_mov_b32_e32 v26, v12
; VI-NEXT:    v_mov_b32_e32 v25, v11
; VI-NEXT:    v_mov_b32_e32 v24, v10
; VI-NEXT:    v_mov_b32_e32 v23, v9
; VI-NEXT:    v_mov_b32_e32 v22, v8
; VI-NEXT:    v_mov_b32_e32 v21, v7
; VI-NEXT:    v_mov_b32_e32 v20, v6
; VI-NEXT:    v_mov_b32_e32 v19, v5
; VI-NEXT:    v_mov_b32_e32 v32, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB3_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB3_3
; VI-NEXT:  .LBB3_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v31, 1.0, v31
; VI-NEXT:    v_add_f32_e32 v30, 1.0, v30
; VI-NEXT:    v_add_f32_e32 v29, 1.0, v29
; VI-NEXT:    v_add_f32_e32 v28, 1.0, v28
; VI-NEXT:    v_add_f32_e32 v27, 1.0, v27
; VI-NEXT:    v_add_f32_e32 v26, 1.0, v26
; VI-NEXT:    v_add_f32_e32 v25, 1.0, v25
; VI-NEXT:    v_add_f32_e32 v24, 1.0, v24
; VI-NEXT:    v_add_f32_e32 v23, 1.0, v23
; VI-NEXT:    v_add_f32_e32 v22, 1.0, v22
; VI-NEXT:    v_add_f32_e32 v21, 1.0, v21
; VI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; VI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; VI-NEXT:    v_add_f32_e32 v32, 1.0, v32
; VI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; VI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  .LBB3_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v18, v32
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB3_4:
; VI-NEXT:    s_branch .LBB3_2
;
; GFX9-LABEL: bitcast_v32f32_to_v32i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; GFX9-NEXT:    v_mov_b32_e32 v31, v17
; GFX9-NEXT:    v_mov_b32_e32 v30, v16
; GFX9-NEXT:    v_mov_b32_e32 v29, v15
; GFX9-NEXT:    v_mov_b32_e32 v28, v14
; GFX9-NEXT:    v_mov_b32_e32 v27, v13
; GFX9-NEXT:    v_mov_b32_e32 v26, v12
; GFX9-NEXT:    v_mov_b32_e32 v25, v11
; GFX9-NEXT:    v_mov_b32_e32 v24, v10
; GFX9-NEXT:    v_mov_b32_e32 v23, v9
; GFX9-NEXT:    v_mov_b32_e32 v22, v8
; GFX9-NEXT:    v_mov_b32_e32 v21, v7
; GFX9-NEXT:    v_mov_b32_e32 v20, v6
; GFX9-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-NEXT:    v_mov_b32_e32 v32, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB3_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB3_3
; GFX9-NEXT:  .LBB3_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v31, 1.0, v31
; GFX9-NEXT:    v_add_f32_e32 v30, 1.0, v30
; GFX9-NEXT:    v_add_f32_e32 v29, 1.0, v29
; GFX9-NEXT:    v_add_f32_e32 v28, 1.0, v28
; GFX9-NEXT:    v_add_f32_e32 v27, 1.0, v27
; GFX9-NEXT:    v_add_f32_e32 v26, 1.0, v26
; GFX9-NEXT:    v_add_f32_e32 v25, 1.0, v25
; GFX9-NEXT:    v_add_f32_e32 v24, 1.0, v24
; GFX9-NEXT:    v_add_f32_e32 v23, 1.0, v23
; GFX9-NEXT:    v_add_f32_e32 v22, 1.0, v22
; GFX9-NEXT:    v_add_f32_e32 v21, 1.0, v21
; GFX9-NEXT:    v_add_f32_e32 v20, 1.0, v20
; GFX9-NEXT:    v_add_f32_e32 v19, 1.0, v19
; GFX9-NEXT:    v_add_f32_e32 v32, 1.0, v32
; GFX9-NEXT:    v_add_f32_e32 v17, 1.0, v17
; GFX9-NEXT:    v_add_f32_e32 v16, 1.0, v16
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  .LBB3_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v18, v32
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB3_4:
; GFX9-NEXT:    s_branch .LBB3_2
;
; GFX11-LABEL: bitcast_v32f32_to_v32i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v14 :: v_dual_mov_b32 v31, v13
; GFX11-NEXT:    v_dual_mov_b32 v30, v12 :: v_dual_mov_b32 v29, v11
; GFX11-NEXT:    v_dual_mov_b32 v28, v10 :: v_dual_mov_b32 v27, v9
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v26, v8 :: v_dual_mov_b32 v25, v7
; GFX11-NEXT:    v_dual_mov_b32 v24, v6 :: v_dual_mov_b32 v23, v5
; GFX11-NEXT:    v_dual_mov_b32 v22, v4 :: v_dual_mov_b32 v21, v3
; GFX11-NEXT:    v_dual_mov_b32 v20, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB3_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB3_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB3_3:
; GFX11-NEXT:  .LBB3_4: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v31, 1.0, v31 :: v_dual_add_f32 v30, 1.0, v30
; GFX11-NEXT:    v_dual_add_f32 v29, 1.0, v29 :: v_dual_add_f32 v28, 1.0, v28
; GFX11-NEXT:    v_dual_add_f32 v27, 1.0, v27 :: v_dual_add_f32 v26, 1.0, v26
; GFX11-NEXT:    v_dual_add_f32 v25, 1.0, v25 :: v_dual_add_f32 v24, 1.0, v24
; GFX11-NEXT:    v_dual_add_f32 v23, 1.0, v23 :: v_dual_add_f32 v22, 1.0, v22
; GFX11-NEXT:    v_dual_add_f32 v21, 1.0, v21 :: v_dual_add_f32 v20, 1.0, v20
; GFX11-NEXT:    v_dual_add_f32 v19, 1.0, v19 :: v_dual_add_f32 v18, 1.0, v18
; GFX11-NEXT:    v_dual_add_f32 v17, 1.0, v17 :: v_dual_add_f32 v16, 1.0, v16
; GFX11-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <32 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <32 x float> %a1 to <32 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <32 x float> %a to <32 x i32>
  br label %end

end:
  %phi = phi <32 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <32 x i32> %phi
}

define <16 x i64> @bitcast_v32i32_to_v16i64(<32 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v32i32_to_v16i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:4
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v31
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB4_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v31, vcc, 3, v31
; SI-NEXT:    v_add_i32_e32 v30, vcc, 3, v30
; SI-NEXT:    v_add_i32_e32 v29, vcc, 3, v29
; SI-NEXT:    v_add_i32_e32 v28, vcc, 3, v28
; SI-NEXT:    v_add_i32_e32 v27, vcc, 3, v27
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v26
; SI-NEXT:    v_add_i32_e32 v25, vcc, 3, v25
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    v_add_i32_e32 v23, vcc, 3, v23
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v22
; SI-NEXT:    v_add_i32_e32 v21, vcc, 3, v21
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  .LBB4_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v32i32_to_v16i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:4
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v31
; VI-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB4_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u32_e32 v31, vcc, 3, v31
; VI-NEXT:    v_add_u32_e32 v30, vcc, 3, v30
; VI-NEXT:    v_add_u32_e32 v29, vcc, 3, v29
; VI-NEXT:    v_add_u32_e32 v28, vcc, 3, v28
; VI-NEXT:    v_add_u32_e32 v27, vcc, 3, v27
; VI-NEXT:    v_add_u32_e32 v26, vcc, 3, v26
; VI-NEXT:    v_add_u32_e32 v25, vcc, 3, v25
; VI-NEXT:    v_add_u32_e32 v24, vcc, 3, v24
; VI-NEXT:    v_add_u32_e32 v23, vcc, 3, v23
; VI-NEXT:    v_add_u32_e32 v22, vcc, 3, v22
; VI-NEXT:    v_add_u32_e32 v21, vcc, 3, v21
; VI-NEXT:    v_add_u32_e32 v20, vcc, 3, v20
; VI-NEXT:    v_add_u32_e32 v19, vcc, 3, v19
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_add_u32_e32 v17, vcc, 3, v17
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB4_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v32i32_to_v16i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v31
; GFX9-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB4_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v31, 3, v31
; GFX9-NEXT:    v_add_u32_e32 v30, 3, v30
; GFX9-NEXT:    v_add_u32_e32 v29, 3, v29
; GFX9-NEXT:    v_add_u32_e32 v28, 3, v28
; GFX9-NEXT:    v_add_u32_e32 v27, 3, v27
; GFX9-NEXT:    v_add_u32_e32 v26, 3, v26
; GFX9-NEXT:    v_add_u32_e32 v25, 3, v25
; GFX9-NEXT:    v_add_u32_e32 v24, 3, v24
; GFX9-NEXT:    v_add_u32_e32 v23, 3, v23
; GFX9-NEXT:    v_add_u32_e32 v22, 3, v22
; GFX9-NEXT:    v_add_u32_e32 v21, 3, v21
; GFX9-NEXT:    v_add_u32_e32 v20, 3, v20
; GFX9-NEXT:    v_add_u32_e32 v19, 3, v19
; GFX9-NEXT:    v_add_u32_e32 v18, 3, v18
; GFX9-NEXT:    v_add_u32_e32 v17, 3, v17
; GFX9-NEXT:    v_add_u32_e32 v16, 3, v16
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB4_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v32i32_to_v16i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    scratch_load_b32 v32, off, s32 offset:4
; GFX11-NEXT:    scratch_load_b32 v31, off, s32
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    s_waitcnt vmcnt(1)
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v32
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB4_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_nc_u32_e32 v31, 3, v31
; GFX11-NEXT:    v_add_nc_u32_e32 v30, 3, v30
; GFX11-NEXT:    v_add_nc_u32_e32 v29, 3, v29
; GFX11-NEXT:    v_add_nc_u32_e32 v28, 3, v28
; GFX11-NEXT:    v_add_nc_u32_e32 v27, 3, v27
; GFX11-NEXT:    v_add_nc_u32_e32 v26, 3, v26
; GFX11-NEXT:    v_add_nc_u32_e32 v25, 3, v25
; GFX11-NEXT:    v_add_nc_u32_e32 v24, 3, v24
; GFX11-NEXT:    v_add_nc_u32_e32 v23, 3, v23
; GFX11-NEXT:    v_add_nc_u32_e32 v22, 3, v22
; GFX11-NEXT:    v_add_nc_u32_e32 v21, 3, v21
; GFX11-NEXT:    v_add_nc_u32_e32 v20, 3, v20
; GFX11-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  .LBB4_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <32 x i32> %a, splat (i32 3)
  %a2 = bitcast <32 x i32> %a1 to <16 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <32 x i32> %a to <16 x i64>
  br label %end

end:
  %phi = phi <16 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x i64> %phi
}

define inreg <16 x i64> @bitcast_v32i32_to_v16i64_scalar(<32 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v32i32_to_v16i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; SI-NEXT:    v_mov_b32_e32 v31, v17
; SI-NEXT:    v_mov_b32_e32 v30, v16
; SI-NEXT:    v_mov_b32_e32 v29, v15
; SI-NEXT:    v_mov_b32_e32 v28, v14
; SI-NEXT:    v_mov_b32_e32 v27, v13
; SI-NEXT:    v_mov_b32_e32 v26, v12
; SI-NEXT:    v_mov_b32_e32 v25, v11
; SI-NEXT:    v_mov_b32_e32 v24, v10
; SI-NEXT:    v_mov_b32_e32 v23, v9
; SI-NEXT:    v_mov_b32_e32 v22, v8
; SI-NEXT:    v_mov_b32_e32 v21, v7
; SI-NEXT:    v_mov_b32_e32 v20, v6
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v32, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB5_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB5_3
; SI-NEXT:  .LBB5_2: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v31, vcc, 3, v31
; SI-NEXT:    v_add_i32_e32 v30, vcc, 3, v30
; SI-NEXT:    v_add_i32_e32 v29, vcc, 3, v29
; SI-NEXT:    v_add_i32_e32 v28, vcc, 3, v28
; SI-NEXT:    v_add_i32_e32 v27, vcc, 3, v27
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v26
; SI-NEXT:    v_add_i32_e32 v25, vcc, 3, v25
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    v_add_i32_e32 v23, vcc, 3, v23
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v22
; SI-NEXT:    v_add_i32_e32 v21, vcc, 3, v21
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v32, vcc, 3, v32
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  .LBB5_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v18, v32
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB5_4:
; SI-NEXT:    s_branch .LBB5_2
;
; VI-LABEL: bitcast_v32i32_to_v16i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; VI-NEXT:    v_mov_b32_e32 v31, v17
; VI-NEXT:    v_mov_b32_e32 v30, v16
; VI-NEXT:    v_mov_b32_e32 v29, v15
; VI-NEXT:    v_mov_b32_e32 v28, v14
; VI-NEXT:    v_mov_b32_e32 v27, v13
; VI-NEXT:    v_mov_b32_e32 v26, v12
; VI-NEXT:    v_mov_b32_e32 v25, v11
; VI-NEXT:    v_mov_b32_e32 v24, v10
; VI-NEXT:    v_mov_b32_e32 v23, v9
; VI-NEXT:    v_mov_b32_e32 v22, v8
; VI-NEXT:    v_mov_b32_e32 v21, v7
; VI-NEXT:    v_mov_b32_e32 v20, v6
; VI-NEXT:    v_mov_b32_e32 v19, v5
; VI-NEXT:    v_mov_b32_e32 v32, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB5_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB5_3
; VI-NEXT:  .LBB5_2: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v31, vcc, 3, v31
; VI-NEXT:    v_add_u32_e32 v30, vcc, 3, v30
; VI-NEXT:    v_add_u32_e32 v29, vcc, 3, v29
; VI-NEXT:    v_add_u32_e32 v28, vcc, 3, v28
; VI-NEXT:    v_add_u32_e32 v27, vcc, 3, v27
; VI-NEXT:    v_add_u32_e32 v26, vcc, 3, v26
; VI-NEXT:    v_add_u32_e32 v25, vcc, 3, v25
; VI-NEXT:    v_add_u32_e32 v24, vcc, 3, v24
; VI-NEXT:    v_add_u32_e32 v23, vcc, 3, v23
; VI-NEXT:    v_add_u32_e32 v22, vcc, 3, v22
; VI-NEXT:    v_add_u32_e32 v21, vcc, 3, v21
; VI-NEXT:    v_add_u32_e32 v20, vcc, 3, v20
; VI-NEXT:    v_add_u32_e32 v19, vcc, 3, v19
; VI-NEXT:    v_add_u32_e32 v32, vcc, 3, v32
; VI-NEXT:    v_add_u32_e32 v17, vcc, 3, v17
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB5_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v18, v32
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB5_4:
; VI-NEXT:    s_branch .LBB5_2
;
; GFX9-LABEL: bitcast_v32i32_to_v16i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; GFX9-NEXT:    v_mov_b32_e32 v31, v17
; GFX9-NEXT:    v_mov_b32_e32 v30, v16
; GFX9-NEXT:    v_mov_b32_e32 v29, v15
; GFX9-NEXT:    v_mov_b32_e32 v28, v14
; GFX9-NEXT:    v_mov_b32_e32 v27, v13
; GFX9-NEXT:    v_mov_b32_e32 v26, v12
; GFX9-NEXT:    v_mov_b32_e32 v25, v11
; GFX9-NEXT:    v_mov_b32_e32 v24, v10
; GFX9-NEXT:    v_mov_b32_e32 v23, v9
; GFX9-NEXT:    v_mov_b32_e32 v22, v8
; GFX9-NEXT:    v_mov_b32_e32 v21, v7
; GFX9-NEXT:    v_mov_b32_e32 v20, v6
; GFX9-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-NEXT:    v_mov_b32_e32 v32, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB5_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB5_3
; GFX9-NEXT:  .LBB5_2: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v31, 3, v31
; GFX9-NEXT:    v_add_u32_e32 v30, 3, v30
; GFX9-NEXT:    v_add_u32_e32 v29, 3, v29
; GFX9-NEXT:    v_add_u32_e32 v28, 3, v28
; GFX9-NEXT:    v_add_u32_e32 v27, 3, v27
; GFX9-NEXT:    v_add_u32_e32 v26, 3, v26
; GFX9-NEXT:    v_add_u32_e32 v25, 3, v25
; GFX9-NEXT:    v_add_u32_e32 v24, 3, v24
; GFX9-NEXT:    v_add_u32_e32 v23, 3, v23
; GFX9-NEXT:    v_add_u32_e32 v22, 3, v22
; GFX9-NEXT:    v_add_u32_e32 v21, 3, v21
; GFX9-NEXT:    v_add_u32_e32 v20, 3, v20
; GFX9-NEXT:    v_add_u32_e32 v19, 3, v19
; GFX9-NEXT:    v_add_u32_e32 v32, 3, v32
; GFX9-NEXT:    v_add_u32_e32 v17, 3, v17
; GFX9-NEXT:    v_add_u32_e32 v16, 3, v16
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB5_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v18, v32
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB5_4:
; GFX9-NEXT:    s_branch .LBB5_2
;
; GFX11-LABEL: bitcast_v32i32_to_v16i64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v14 :: v_dual_mov_b32 v31, v13
; GFX11-NEXT:    v_dual_mov_b32 v30, v12 :: v_dual_mov_b32 v29, v11
; GFX11-NEXT:    v_dual_mov_b32 v28, v10 :: v_dual_mov_b32 v27, v9
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v26, v8 :: v_dual_mov_b32 v25, v7
; GFX11-NEXT:    v_dual_mov_b32 v24, v6 :: v_dual_mov_b32 v23, v5
; GFX11-NEXT:    v_dual_mov_b32 v22, v4 :: v_dual_mov_b32 v21, v3
; GFX11-NEXT:    v_dual_mov_b32 v20, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB5_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB5_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB5_3:
; GFX11-NEXT:  .LBB5_4: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v31, 3, v31
; GFX11-NEXT:    v_add_nc_u32_e32 v30, 3, v30
; GFX11-NEXT:    v_add_nc_u32_e32 v29, 3, v29
; GFX11-NEXT:    v_add_nc_u32_e32 v28, 3, v28
; GFX11-NEXT:    v_add_nc_u32_e32 v27, 3, v27
; GFX11-NEXT:    v_add_nc_u32_e32 v26, 3, v26
; GFX11-NEXT:    v_add_nc_u32_e32 v25, 3, v25
; GFX11-NEXT:    v_add_nc_u32_e32 v24, 3, v24
; GFX11-NEXT:    v_add_nc_u32_e32 v23, 3, v23
; GFX11-NEXT:    v_add_nc_u32_e32 v22, 3, v22
; GFX11-NEXT:    v_add_nc_u32_e32 v21, 3, v21
; GFX11-NEXT:    v_add_nc_u32_e32 v20, 3, v20
; GFX11-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <32 x i32> %a, splat (i32 3)
  %a2 = bitcast <32 x i32> %a1 to <16 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <32 x i32> %a to <16 x i64>
  br label %end

end:
  %phi = phi <16 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x i64> %phi
}

define <32 x i32> @bitcast_v16i64_to_v32i32(<16 x i64> %a, i32 %b) {
; SI-LABEL: bitcast_v16i64_to_v32i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:4
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v31
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB6_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v30, vcc, 3, v30
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_addc_u32_e32 v31, vcc, 0, v31, vcc
; SI-NEXT:    v_add_i32_e32 v28, vcc, 3, v28
; SI-NEXT:    v_addc_u32_e32 v29, vcc, 0, v29, vcc
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v26
; SI-NEXT:    v_addc_u32_e32 v27, vcc, 0, v27, vcc
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    v_addc_u32_e32 v25, vcc, 0, v25, vcc
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v22
; SI-NEXT:    v_addc_u32_e32 v23, vcc, 0, v23, vcc
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_addc_u32_e32 v21, vcc, 0, v21, vcc
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; SI-NEXT:  .LBB6_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v16i64_to_v32i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:4
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v31
; VI-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB6_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v30, vcc, 3, v30
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_addc_u32_e32 v31, vcc, 0, v31, vcc
; VI-NEXT:    v_add_u32_e32 v28, vcc, 3, v28
; VI-NEXT:    v_addc_u32_e32 v29, vcc, 0, v29, vcc
; VI-NEXT:    v_add_u32_e32 v26, vcc, 3, v26
; VI-NEXT:    v_addc_u32_e32 v27, vcc, 0, v27, vcc
; VI-NEXT:    v_add_u32_e32 v24, vcc, 3, v24
; VI-NEXT:    v_addc_u32_e32 v25, vcc, 0, v25, vcc
; VI-NEXT:    v_add_u32_e32 v22, vcc, 3, v22
; VI-NEXT:    v_addc_u32_e32 v23, vcc, 0, v23, vcc
; VI-NEXT:    v_add_u32_e32 v20, vcc, 3, v20
; VI-NEXT:    v_addc_u32_e32 v21, vcc, 0, v21, vcc
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  .LBB6_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16i64_to_v32i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v31
; GFX9-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB6_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v30, vcc, 3, v30
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_addc_co_u32_e32 v31, vcc, 0, v31, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v28, vcc, 3, v28
; GFX9-NEXT:    v_addc_co_u32_e32 v29, vcc, 0, v29, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v26, vcc, 3, v26
; GFX9-NEXT:    v_addc_co_u32_e32 v27, vcc, 0, v27, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v24, vcc, 3, v24
; GFX9-NEXT:    v_addc_co_u32_e32 v25, vcc, 0, v25, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v22, vcc, 3, v22
; GFX9-NEXT:    v_addc_co_u32_e32 v23, vcc, 0, v23, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v20, vcc, 3, v20
; GFX9-NEXT:    v_addc_co_u32_e32 v21, vcc, 0, v21, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v18, vcc, 3, v18
; GFX9-NEXT:    v_addc_co_u32_e32 v19, vcc, 0, v19, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v16, vcc, 3, v16
; GFX9-NEXT:    v_addc_co_u32_e32 v17, vcc, 0, v17, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v14, vcc, 3, v14
; GFX9-NEXT:    v_addc_co_u32_e32 v15, vcc, 0, v15, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v12, vcc, 3, v12
; GFX9-NEXT:    v_addc_co_u32_e32 v13, vcc, 0, v13, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v10, vcc, 3, v10
; GFX9-NEXT:    v_addc_co_u32_e32 v11, vcc, 0, v11, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v8, vcc, 3, v8
; GFX9-NEXT:    v_addc_co_u32_e32 v9, vcc, 0, v9, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v6, vcc, 3, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v7, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  .LBB6_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16i64_to_v32i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    scratch_load_b32 v32, off, s32 offset:4
; GFX11-NEXT:    scratch_load_b32 v31, off, s32
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    s_waitcnt vmcnt(1)
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v32
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB6_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v30, vcc_lo, v30, 3
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v31, null, 0, v31, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v28, vcc_lo, v28, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v29, null, 0, v29, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v26, vcc_lo, v26, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v27, null, 0, v27, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v24, vcc_lo, v24, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v25, null, 0, v25, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v22, vcc_lo, v22, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v23, null, 0, v23, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v20, vcc_lo, v20, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v21, null, 0, v21, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v18, vcc_lo, v18, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v19, null, 0, v19, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v16, vcc_lo, v16, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v17, null, 0, v17, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v14, vcc_lo, v14, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v15, null, 0, v15, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v12, vcc_lo, v12, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v13, null, 0, v13, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v10, vcc_lo, v10, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v11, null, 0, v11, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v8, vcc_lo, v8, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v9, null, 0, v9, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v6, vcc_lo, v6, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v7, null, 0, v7, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:  .LBB6_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <16 x i64> %a, splat (i64 3)
  %a2 = bitcast <16 x i64> %a1 to <32 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <16 x i64> %a to <32 x i32>
  br label %end

end:
  %phi = phi <32 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <32 x i32> %phi
}

define inreg <32 x i32> @bitcast_v16i64_to_v32i32_scalar(<16 x i64> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v16i64_to_v32i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; SI-NEXT:    v_mov_b32_e32 v31, v17
; SI-NEXT:    v_mov_b32_e32 v30, v16
; SI-NEXT:    v_mov_b32_e32 v29, v15
; SI-NEXT:    v_mov_b32_e32 v28, v14
; SI-NEXT:    v_mov_b32_e32 v27, v13
; SI-NEXT:    v_mov_b32_e32 v26, v12
; SI-NEXT:    v_mov_b32_e32 v25, v11
; SI-NEXT:    v_mov_b32_e32 v24, v10
; SI-NEXT:    v_mov_b32_e32 v23, v9
; SI-NEXT:    v_mov_b32_e32 v22, v8
; SI-NEXT:    v_mov_b32_e32 v21, v7
; SI-NEXT:    v_mov_b32_e32 v20, v6
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v32, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB7_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB7_3
; SI-NEXT:  .LBB7_2: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v30, vcc, 3, v30
; SI-NEXT:    v_addc_u32_e32 v31, vcc, 0, v31, vcc
; SI-NEXT:    v_add_i32_e32 v28, vcc, 3, v28
; SI-NEXT:    v_addc_u32_e32 v29, vcc, 0, v29, vcc
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v26
; SI-NEXT:    v_addc_u32_e32 v27, vcc, 0, v27, vcc
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    v_addc_u32_e32 v25, vcc, 0, v25, vcc
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v22
; SI-NEXT:    v_addc_u32_e32 v23, vcc, 0, v23, vcc
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_addc_u32_e32 v21, vcc, 0, v21, vcc
; SI-NEXT:    v_add_i32_e32 v32, vcc, 3, v32
; SI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; SI-NEXT:  .LBB7_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v18, v32
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB7_4:
; SI-NEXT:    s_branch .LBB7_2
;
; VI-LABEL: bitcast_v16i64_to_v32i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; VI-NEXT:    v_mov_b32_e32 v31, v17
; VI-NEXT:    v_mov_b32_e32 v30, v16
; VI-NEXT:    v_mov_b32_e32 v29, v15
; VI-NEXT:    v_mov_b32_e32 v28, v14
; VI-NEXT:    v_mov_b32_e32 v27, v13
; VI-NEXT:    v_mov_b32_e32 v26, v12
; VI-NEXT:    v_mov_b32_e32 v25, v11
; VI-NEXT:    v_mov_b32_e32 v24, v10
; VI-NEXT:    v_mov_b32_e32 v23, v9
; VI-NEXT:    v_mov_b32_e32 v22, v8
; VI-NEXT:    v_mov_b32_e32 v21, v7
; VI-NEXT:    v_mov_b32_e32 v20, v6
; VI-NEXT:    v_mov_b32_e32 v19, v5
; VI-NEXT:    v_mov_b32_e32 v32, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB7_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB7_3
; VI-NEXT:  .LBB7_2: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v30, vcc, 3, v30
; VI-NEXT:    v_addc_u32_e32 v31, vcc, 0, v31, vcc
; VI-NEXT:    v_add_u32_e32 v28, vcc, 3, v28
; VI-NEXT:    v_addc_u32_e32 v29, vcc, 0, v29, vcc
; VI-NEXT:    v_add_u32_e32 v26, vcc, 3, v26
; VI-NEXT:    v_addc_u32_e32 v27, vcc, 0, v27, vcc
; VI-NEXT:    v_add_u32_e32 v24, vcc, 3, v24
; VI-NEXT:    v_addc_u32_e32 v25, vcc, 0, v25, vcc
; VI-NEXT:    v_add_u32_e32 v22, vcc, 3, v22
; VI-NEXT:    v_addc_u32_e32 v23, vcc, 0, v23, vcc
; VI-NEXT:    v_add_u32_e32 v20, vcc, 3, v20
; VI-NEXT:    v_addc_u32_e32 v21, vcc, 0, v21, vcc
; VI-NEXT:    v_add_u32_e32 v32, vcc, 3, v32
; VI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  .LBB7_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v18, v32
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB7_4:
; VI-NEXT:    s_branch .LBB7_2
;
; GFX9-LABEL: bitcast_v16i64_to_v32i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; GFX9-NEXT:    v_mov_b32_e32 v31, v17
; GFX9-NEXT:    v_mov_b32_e32 v30, v16
; GFX9-NEXT:    v_mov_b32_e32 v29, v15
; GFX9-NEXT:    v_mov_b32_e32 v28, v14
; GFX9-NEXT:    v_mov_b32_e32 v27, v13
; GFX9-NEXT:    v_mov_b32_e32 v26, v12
; GFX9-NEXT:    v_mov_b32_e32 v25, v11
; GFX9-NEXT:    v_mov_b32_e32 v24, v10
; GFX9-NEXT:    v_mov_b32_e32 v23, v9
; GFX9-NEXT:    v_mov_b32_e32 v22, v8
; GFX9-NEXT:    v_mov_b32_e32 v21, v7
; GFX9-NEXT:    v_mov_b32_e32 v20, v6
; GFX9-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-NEXT:    v_mov_b32_e32 v32, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB7_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB7_3
; GFX9-NEXT:  .LBB7_2: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v30, vcc, 3, v30
; GFX9-NEXT:    v_addc_co_u32_e32 v31, vcc, 0, v31, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v28, vcc, 3, v28
; GFX9-NEXT:    v_addc_co_u32_e32 v29, vcc, 0, v29, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v26, vcc, 3, v26
; GFX9-NEXT:    v_addc_co_u32_e32 v27, vcc, 0, v27, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v24, vcc, 3, v24
; GFX9-NEXT:    v_addc_co_u32_e32 v25, vcc, 0, v25, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v22, vcc, 3, v22
; GFX9-NEXT:    v_addc_co_u32_e32 v23, vcc, 0, v23, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v20, vcc, 3, v20
; GFX9-NEXT:    v_addc_co_u32_e32 v21, vcc, 0, v21, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v32, vcc, 3, v32
; GFX9-NEXT:    v_addc_co_u32_e32 v19, vcc, 0, v19, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v16, vcc, 3, v16
; GFX9-NEXT:    v_addc_co_u32_e32 v17, vcc, 0, v17, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v14, vcc, 3, v14
; GFX9-NEXT:    v_addc_co_u32_e32 v15, vcc, 0, v15, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v12, vcc, 3, v12
; GFX9-NEXT:    v_addc_co_u32_e32 v13, vcc, 0, v13, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v10, vcc, 3, v10
; GFX9-NEXT:    v_addc_co_u32_e32 v11, vcc, 0, v11, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v8, vcc, 3, v8
; GFX9-NEXT:    v_addc_co_u32_e32 v9, vcc, 0, v9, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v6, vcc, 3, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v7, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  .LBB7_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v18, v32
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB7_4:
; GFX9-NEXT:    s_branch .LBB7_2
;
; GFX11-LABEL: bitcast_v16i64_to_v32i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v14 :: v_dual_mov_b32 v31, v13
; GFX11-NEXT:    v_dual_mov_b32 v30, v12 :: v_dual_mov_b32 v29, v11
; GFX11-NEXT:    v_dual_mov_b32 v28, v10 :: v_dual_mov_b32 v27, v9
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v26, v8 :: v_dual_mov_b32 v25, v7
; GFX11-NEXT:    v_dual_mov_b32 v24, v6 :: v_dual_mov_b32 v23, v5
; GFX11-NEXT:    v_dual_mov_b32 v22, v4 :: v_dual_mov_b32 v21, v3
; GFX11-NEXT:    v_dual_mov_b32 v20, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB7_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB7_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB7_3:
; GFX11-NEXT:  .LBB7_4: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v30, vcc_lo, v30, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v31, null, 0, v31, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v28, vcc_lo, v28, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v29, null, 0, v29, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v26, vcc_lo, v26, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v27, null, 0, v27, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v24, vcc_lo, v24, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v25, null, 0, v25, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v22, vcc_lo, v22, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v23, null, 0, v23, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v20, vcc_lo, v20, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v21, null, 0, v21, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v18, vcc_lo, v18, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v19, null, 0, v19, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v16, vcc_lo, v16, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v17, null, 0, v17, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v14, vcc_lo, v14, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v15, null, 0, v15, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v12, vcc_lo, v12, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v13, null, 0, v13, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v10, vcc_lo, v10, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v11, null, 0, v11, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v8, vcc_lo, v8, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v9, null, 0, v9, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v6, vcc_lo, v6, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v7, null, 0, v7, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <16 x i64> %a, splat (i64 3)
  %a2 = bitcast <16 x i64> %a1 to <32 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <16 x i64> %a to <32 x i32>
  br label %end

end:
  %phi = phi <32 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <32 x i32> %phi
}

define <16 x double> @bitcast_v32i32_to_v16f64(<32 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v32i32_to_v16f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:4
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v31
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB8_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v31, vcc, 3, v31
; SI-NEXT:    v_add_i32_e32 v30, vcc, 3, v30
; SI-NEXT:    v_add_i32_e32 v29, vcc, 3, v29
; SI-NEXT:    v_add_i32_e32 v28, vcc, 3, v28
; SI-NEXT:    v_add_i32_e32 v27, vcc, 3, v27
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v26
; SI-NEXT:    v_add_i32_e32 v25, vcc, 3, v25
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    v_add_i32_e32 v23, vcc, 3, v23
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v22
; SI-NEXT:    v_add_i32_e32 v21, vcc, 3, v21
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  .LBB8_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v32i32_to_v16f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:4
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v31
; VI-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB8_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u32_e32 v31, vcc, 3, v31
; VI-NEXT:    v_add_u32_e32 v30, vcc, 3, v30
; VI-NEXT:    v_add_u32_e32 v29, vcc, 3, v29
; VI-NEXT:    v_add_u32_e32 v28, vcc, 3, v28
; VI-NEXT:    v_add_u32_e32 v27, vcc, 3, v27
; VI-NEXT:    v_add_u32_e32 v26, vcc, 3, v26
; VI-NEXT:    v_add_u32_e32 v25, vcc, 3, v25
; VI-NEXT:    v_add_u32_e32 v24, vcc, 3, v24
; VI-NEXT:    v_add_u32_e32 v23, vcc, 3, v23
; VI-NEXT:    v_add_u32_e32 v22, vcc, 3, v22
; VI-NEXT:    v_add_u32_e32 v21, vcc, 3, v21
; VI-NEXT:    v_add_u32_e32 v20, vcc, 3, v20
; VI-NEXT:    v_add_u32_e32 v19, vcc, 3, v19
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_add_u32_e32 v17, vcc, 3, v17
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB8_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v32i32_to_v16f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v31
; GFX9-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB8_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v31, 3, v31
; GFX9-NEXT:    v_add_u32_e32 v30, 3, v30
; GFX9-NEXT:    v_add_u32_e32 v29, 3, v29
; GFX9-NEXT:    v_add_u32_e32 v28, 3, v28
; GFX9-NEXT:    v_add_u32_e32 v27, 3, v27
; GFX9-NEXT:    v_add_u32_e32 v26, 3, v26
; GFX9-NEXT:    v_add_u32_e32 v25, 3, v25
; GFX9-NEXT:    v_add_u32_e32 v24, 3, v24
; GFX9-NEXT:    v_add_u32_e32 v23, 3, v23
; GFX9-NEXT:    v_add_u32_e32 v22, 3, v22
; GFX9-NEXT:    v_add_u32_e32 v21, 3, v21
; GFX9-NEXT:    v_add_u32_e32 v20, 3, v20
; GFX9-NEXT:    v_add_u32_e32 v19, 3, v19
; GFX9-NEXT:    v_add_u32_e32 v18, 3, v18
; GFX9-NEXT:    v_add_u32_e32 v17, 3, v17
; GFX9-NEXT:    v_add_u32_e32 v16, 3, v16
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB8_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v32i32_to_v16f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    scratch_load_b32 v32, off, s32 offset:4
; GFX11-NEXT:    scratch_load_b32 v31, off, s32
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    s_waitcnt vmcnt(1)
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v32
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB8_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_nc_u32_e32 v31, 3, v31
; GFX11-NEXT:    v_add_nc_u32_e32 v30, 3, v30
; GFX11-NEXT:    v_add_nc_u32_e32 v29, 3, v29
; GFX11-NEXT:    v_add_nc_u32_e32 v28, 3, v28
; GFX11-NEXT:    v_add_nc_u32_e32 v27, 3, v27
; GFX11-NEXT:    v_add_nc_u32_e32 v26, 3, v26
; GFX11-NEXT:    v_add_nc_u32_e32 v25, 3, v25
; GFX11-NEXT:    v_add_nc_u32_e32 v24, 3, v24
; GFX11-NEXT:    v_add_nc_u32_e32 v23, 3, v23
; GFX11-NEXT:    v_add_nc_u32_e32 v22, 3, v22
; GFX11-NEXT:    v_add_nc_u32_e32 v21, 3, v21
; GFX11-NEXT:    v_add_nc_u32_e32 v20, 3, v20
; GFX11-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  .LBB8_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <32 x i32> %a, splat (i32 3)
  %a2 = bitcast <32 x i32> %a1 to <16 x double>
  br label %end

cmp.false:
  %a3 = bitcast <32 x i32> %a to <16 x double>
  br label %end

end:
  %phi = phi <16 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x double> %phi
}

define inreg <16 x double> @bitcast_v32i32_to_v16f64_scalar(<32 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v32i32_to_v16f64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; SI-NEXT:    v_mov_b32_e32 v31, v17
; SI-NEXT:    v_mov_b32_e32 v30, v16
; SI-NEXT:    v_mov_b32_e32 v29, v15
; SI-NEXT:    v_mov_b32_e32 v28, v14
; SI-NEXT:    v_mov_b32_e32 v27, v13
; SI-NEXT:    v_mov_b32_e32 v26, v12
; SI-NEXT:    v_mov_b32_e32 v25, v11
; SI-NEXT:    v_mov_b32_e32 v24, v10
; SI-NEXT:    v_mov_b32_e32 v23, v9
; SI-NEXT:    v_mov_b32_e32 v22, v8
; SI-NEXT:    v_mov_b32_e32 v21, v7
; SI-NEXT:    v_mov_b32_e32 v20, v6
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v32, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB9_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB9_3
; SI-NEXT:  .LBB9_2: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v31, vcc, 3, v31
; SI-NEXT:    v_add_i32_e32 v30, vcc, 3, v30
; SI-NEXT:    v_add_i32_e32 v29, vcc, 3, v29
; SI-NEXT:    v_add_i32_e32 v28, vcc, 3, v28
; SI-NEXT:    v_add_i32_e32 v27, vcc, 3, v27
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v26
; SI-NEXT:    v_add_i32_e32 v25, vcc, 3, v25
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    v_add_i32_e32 v23, vcc, 3, v23
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v22
; SI-NEXT:    v_add_i32_e32 v21, vcc, 3, v21
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v32, vcc, 3, v32
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  .LBB9_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v18, v32
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB9_4:
; SI-NEXT:    s_branch .LBB9_2
;
; VI-LABEL: bitcast_v32i32_to_v16f64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; VI-NEXT:    v_mov_b32_e32 v31, v17
; VI-NEXT:    v_mov_b32_e32 v30, v16
; VI-NEXT:    v_mov_b32_e32 v29, v15
; VI-NEXT:    v_mov_b32_e32 v28, v14
; VI-NEXT:    v_mov_b32_e32 v27, v13
; VI-NEXT:    v_mov_b32_e32 v26, v12
; VI-NEXT:    v_mov_b32_e32 v25, v11
; VI-NEXT:    v_mov_b32_e32 v24, v10
; VI-NEXT:    v_mov_b32_e32 v23, v9
; VI-NEXT:    v_mov_b32_e32 v22, v8
; VI-NEXT:    v_mov_b32_e32 v21, v7
; VI-NEXT:    v_mov_b32_e32 v20, v6
; VI-NEXT:    v_mov_b32_e32 v19, v5
; VI-NEXT:    v_mov_b32_e32 v32, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB9_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB9_3
; VI-NEXT:  .LBB9_2: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v31, vcc, 3, v31
; VI-NEXT:    v_add_u32_e32 v30, vcc, 3, v30
; VI-NEXT:    v_add_u32_e32 v29, vcc, 3, v29
; VI-NEXT:    v_add_u32_e32 v28, vcc, 3, v28
; VI-NEXT:    v_add_u32_e32 v27, vcc, 3, v27
; VI-NEXT:    v_add_u32_e32 v26, vcc, 3, v26
; VI-NEXT:    v_add_u32_e32 v25, vcc, 3, v25
; VI-NEXT:    v_add_u32_e32 v24, vcc, 3, v24
; VI-NEXT:    v_add_u32_e32 v23, vcc, 3, v23
; VI-NEXT:    v_add_u32_e32 v22, vcc, 3, v22
; VI-NEXT:    v_add_u32_e32 v21, vcc, 3, v21
; VI-NEXT:    v_add_u32_e32 v20, vcc, 3, v20
; VI-NEXT:    v_add_u32_e32 v19, vcc, 3, v19
; VI-NEXT:    v_add_u32_e32 v32, vcc, 3, v32
; VI-NEXT:    v_add_u32_e32 v17, vcc, 3, v17
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB9_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v18, v32
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB9_4:
; VI-NEXT:    s_branch .LBB9_2
;
; GFX9-LABEL: bitcast_v32i32_to_v16f64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; GFX9-NEXT:    v_mov_b32_e32 v31, v17
; GFX9-NEXT:    v_mov_b32_e32 v30, v16
; GFX9-NEXT:    v_mov_b32_e32 v29, v15
; GFX9-NEXT:    v_mov_b32_e32 v28, v14
; GFX9-NEXT:    v_mov_b32_e32 v27, v13
; GFX9-NEXT:    v_mov_b32_e32 v26, v12
; GFX9-NEXT:    v_mov_b32_e32 v25, v11
; GFX9-NEXT:    v_mov_b32_e32 v24, v10
; GFX9-NEXT:    v_mov_b32_e32 v23, v9
; GFX9-NEXT:    v_mov_b32_e32 v22, v8
; GFX9-NEXT:    v_mov_b32_e32 v21, v7
; GFX9-NEXT:    v_mov_b32_e32 v20, v6
; GFX9-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-NEXT:    v_mov_b32_e32 v32, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB9_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB9_3
; GFX9-NEXT:  .LBB9_2: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v31, 3, v31
; GFX9-NEXT:    v_add_u32_e32 v30, 3, v30
; GFX9-NEXT:    v_add_u32_e32 v29, 3, v29
; GFX9-NEXT:    v_add_u32_e32 v28, 3, v28
; GFX9-NEXT:    v_add_u32_e32 v27, 3, v27
; GFX9-NEXT:    v_add_u32_e32 v26, 3, v26
; GFX9-NEXT:    v_add_u32_e32 v25, 3, v25
; GFX9-NEXT:    v_add_u32_e32 v24, 3, v24
; GFX9-NEXT:    v_add_u32_e32 v23, 3, v23
; GFX9-NEXT:    v_add_u32_e32 v22, 3, v22
; GFX9-NEXT:    v_add_u32_e32 v21, 3, v21
; GFX9-NEXT:    v_add_u32_e32 v20, 3, v20
; GFX9-NEXT:    v_add_u32_e32 v19, 3, v19
; GFX9-NEXT:    v_add_u32_e32 v32, 3, v32
; GFX9-NEXT:    v_add_u32_e32 v17, 3, v17
; GFX9-NEXT:    v_add_u32_e32 v16, 3, v16
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB9_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v18, v32
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB9_4:
; GFX9-NEXT:    s_branch .LBB9_2
;
; GFX11-LABEL: bitcast_v32i32_to_v16f64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v14 :: v_dual_mov_b32 v31, v13
; GFX11-NEXT:    v_dual_mov_b32 v30, v12 :: v_dual_mov_b32 v29, v11
; GFX11-NEXT:    v_dual_mov_b32 v28, v10 :: v_dual_mov_b32 v27, v9
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v26, v8 :: v_dual_mov_b32 v25, v7
; GFX11-NEXT:    v_dual_mov_b32 v24, v6 :: v_dual_mov_b32 v23, v5
; GFX11-NEXT:    v_dual_mov_b32 v22, v4 :: v_dual_mov_b32 v21, v3
; GFX11-NEXT:    v_dual_mov_b32 v20, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB9_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB9_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB9_3:
; GFX11-NEXT:  .LBB9_4: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v31, 3, v31
; GFX11-NEXT:    v_add_nc_u32_e32 v30, 3, v30
; GFX11-NEXT:    v_add_nc_u32_e32 v29, 3, v29
; GFX11-NEXT:    v_add_nc_u32_e32 v28, 3, v28
; GFX11-NEXT:    v_add_nc_u32_e32 v27, 3, v27
; GFX11-NEXT:    v_add_nc_u32_e32 v26, 3, v26
; GFX11-NEXT:    v_add_nc_u32_e32 v25, 3, v25
; GFX11-NEXT:    v_add_nc_u32_e32 v24, 3, v24
; GFX11-NEXT:    v_add_nc_u32_e32 v23, 3, v23
; GFX11-NEXT:    v_add_nc_u32_e32 v22, 3, v22
; GFX11-NEXT:    v_add_nc_u32_e32 v21, 3, v21
; GFX11-NEXT:    v_add_nc_u32_e32 v20, 3, v20
; GFX11-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <32 x i32> %a, splat (i32 3)
  %a2 = bitcast <32 x i32> %a1 to <16 x double>
  br label %end

cmp.false:
  %a3 = bitcast <32 x i32> %a to <16 x double>
  br label %end

end:
  %phi = phi <16 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x double> %phi
}

define <32 x i32> @bitcast_v16f64_to_v32i32(<16 x double> %a, i32 %b) {
; SI-LABEL: bitcast_v16f64_to_v32i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:4
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v31
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB10_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_f64 v[30:31], v[30:31], 1.0
; SI-NEXT:    v_add_f64 v[28:29], v[28:29], 1.0
; SI-NEXT:    v_add_f64 v[26:27], v[26:27], 1.0
; SI-NEXT:    v_add_f64 v[24:25], v[24:25], 1.0
; SI-NEXT:    v_add_f64 v[22:23], v[22:23], 1.0
; SI-NEXT:    v_add_f64 v[20:21], v[20:21], 1.0
; SI-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; SI-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; SI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; SI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; SI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; SI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; SI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; SI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; SI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:  .LBB10_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v16f64_to_v32i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:4
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v31
; VI-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB10_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_f64 v[30:31], v[30:31], 1.0
; VI-NEXT:    v_add_f64 v[28:29], v[28:29], 1.0
; VI-NEXT:    v_add_f64 v[26:27], v[26:27], 1.0
; VI-NEXT:    v_add_f64 v[24:25], v[24:25], 1.0
; VI-NEXT:    v_add_f64 v[22:23], v[22:23], 1.0
; VI-NEXT:    v_add_f64 v[20:21], v[20:21], 1.0
; VI-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; VI-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; VI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; VI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; VI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; VI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; VI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; VI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; VI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  .LBB10_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16f64_to_v32i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v31
; GFX9-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB10_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_f64 v[30:31], v[30:31], 1.0
; GFX9-NEXT:    v_add_f64 v[28:29], v[28:29], 1.0
; GFX9-NEXT:    v_add_f64 v[26:27], v[26:27], 1.0
; GFX9-NEXT:    v_add_f64 v[24:25], v[24:25], 1.0
; GFX9-NEXT:    v_add_f64 v[22:23], v[22:23], 1.0
; GFX9-NEXT:    v_add_f64 v[20:21], v[20:21], 1.0
; GFX9-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; GFX9-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; GFX9-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX9-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX9-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX9-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX9-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  .LBB10_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16f64_to_v32i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    scratch_load_b32 v32, off, s32 offset:4
; GFX11-NEXT:    scratch_load_b32 v31, off, s32
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    s_waitcnt vmcnt(1)
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v32
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB10_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_f64 v[30:31], v[30:31], 1.0
; GFX11-NEXT:    v_add_f64 v[28:29], v[28:29], 1.0
; GFX11-NEXT:    v_add_f64 v[26:27], v[26:27], 1.0
; GFX11-NEXT:    v_add_f64 v[24:25], v[24:25], 1.0
; GFX11-NEXT:    v_add_f64 v[22:23], v[22:23], 1.0
; GFX11-NEXT:    v_add_f64 v[20:21], v[20:21], 1.0
; GFX11-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; GFX11-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; GFX11-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX11-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX11-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX11-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX11-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:  .LBB10_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <16 x double> %a1 to <32 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <16 x double> %a to <32 x i32>
  br label %end

end:
  %phi = phi <32 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <32 x i32> %phi
}

define inreg <32 x i32> @bitcast_v16f64_to_v32i32_scalar(<16 x double> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v16f64_to_v32i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; SI-NEXT:    v_mov_b32_e32 v31, v17
; SI-NEXT:    v_mov_b32_e32 v30, v16
; SI-NEXT:    v_mov_b32_e32 v29, v15
; SI-NEXT:    v_mov_b32_e32 v28, v14
; SI-NEXT:    v_mov_b32_e32 v27, v13
; SI-NEXT:    v_mov_b32_e32 v26, v12
; SI-NEXT:    v_mov_b32_e32 v25, v11
; SI-NEXT:    v_mov_b32_e32 v24, v10
; SI-NEXT:    v_mov_b32_e32 v23, v9
; SI-NEXT:    v_mov_b32_e32 v22, v8
; SI-NEXT:    v_mov_b32_e32 v21, v7
; SI-NEXT:    v_mov_b32_e32 v20, v6
; SI-NEXT:    v_mov_b32_e32 v33, v5
; SI-NEXT:    v_mov_b32_e32 v32, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB11_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB11_3
; SI-NEXT:  .LBB11_2: ; %cmp.true
; SI-NEXT:    v_add_f64 v[30:31], v[30:31], 1.0
; SI-NEXT:    v_add_f64 v[28:29], v[28:29], 1.0
; SI-NEXT:    v_add_f64 v[26:27], v[26:27], 1.0
; SI-NEXT:    v_add_f64 v[24:25], v[24:25], 1.0
; SI-NEXT:    v_add_f64 v[22:23], v[22:23], 1.0
; SI-NEXT:    v_add_f64 v[20:21], v[20:21], 1.0
; SI-NEXT:    v_add_f64 v[32:33], v[32:33], 1.0
; SI-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; SI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; SI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; SI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; SI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; SI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; SI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; SI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:  .LBB11_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v18, v32
; SI-NEXT:    v_mov_b32_e32 v19, v33
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB11_4:
; SI-NEXT:    s_branch .LBB11_2
;
; VI-LABEL: bitcast_v16f64_to_v32i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; VI-NEXT:    v_mov_b32_e32 v31, v17
; VI-NEXT:    v_mov_b32_e32 v30, v16
; VI-NEXT:    v_mov_b32_e32 v29, v15
; VI-NEXT:    v_mov_b32_e32 v28, v14
; VI-NEXT:    v_mov_b32_e32 v27, v13
; VI-NEXT:    v_mov_b32_e32 v26, v12
; VI-NEXT:    v_mov_b32_e32 v25, v11
; VI-NEXT:    v_mov_b32_e32 v24, v10
; VI-NEXT:    v_mov_b32_e32 v23, v9
; VI-NEXT:    v_mov_b32_e32 v22, v8
; VI-NEXT:    v_mov_b32_e32 v21, v7
; VI-NEXT:    v_mov_b32_e32 v20, v6
; VI-NEXT:    v_mov_b32_e32 v33, v5
; VI-NEXT:    v_mov_b32_e32 v32, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB11_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB11_3
; VI-NEXT:  .LBB11_2: ; %cmp.true
; VI-NEXT:    v_add_f64 v[30:31], v[30:31], 1.0
; VI-NEXT:    v_add_f64 v[28:29], v[28:29], 1.0
; VI-NEXT:    v_add_f64 v[26:27], v[26:27], 1.0
; VI-NEXT:    v_add_f64 v[24:25], v[24:25], 1.0
; VI-NEXT:    v_add_f64 v[22:23], v[22:23], 1.0
; VI-NEXT:    v_add_f64 v[20:21], v[20:21], 1.0
; VI-NEXT:    v_add_f64 v[32:33], v[32:33], 1.0
; VI-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; VI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; VI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; VI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; VI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; VI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; VI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; VI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  .LBB11_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v18, v32
; VI-NEXT:    v_mov_b32_e32 v19, v33
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB11_4:
; VI-NEXT:    s_branch .LBB11_2
;
; GFX9-LABEL: bitcast_v16f64_to_v32i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; GFX9-NEXT:    v_mov_b32_e32 v31, v17
; GFX9-NEXT:    v_mov_b32_e32 v30, v16
; GFX9-NEXT:    v_mov_b32_e32 v29, v15
; GFX9-NEXT:    v_mov_b32_e32 v28, v14
; GFX9-NEXT:    v_mov_b32_e32 v27, v13
; GFX9-NEXT:    v_mov_b32_e32 v26, v12
; GFX9-NEXT:    v_mov_b32_e32 v25, v11
; GFX9-NEXT:    v_mov_b32_e32 v24, v10
; GFX9-NEXT:    v_mov_b32_e32 v23, v9
; GFX9-NEXT:    v_mov_b32_e32 v22, v8
; GFX9-NEXT:    v_mov_b32_e32 v21, v7
; GFX9-NEXT:    v_mov_b32_e32 v20, v6
; GFX9-NEXT:    v_mov_b32_e32 v33, v5
; GFX9-NEXT:    v_mov_b32_e32 v32, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB11_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB11_3
; GFX9-NEXT:  .LBB11_2: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[30:31], v[30:31], 1.0
; GFX9-NEXT:    v_add_f64 v[28:29], v[28:29], 1.0
; GFX9-NEXT:    v_add_f64 v[26:27], v[26:27], 1.0
; GFX9-NEXT:    v_add_f64 v[24:25], v[24:25], 1.0
; GFX9-NEXT:    v_add_f64 v[22:23], v[22:23], 1.0
; GFX9-NEXT:    v_add_f64 v[20:21], v[20:21], 1.0
; GFX9-NEXT:    v_add_f64 v[32:33], v[32:33], 1.0
; GFX9-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; GFX9-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX9-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX9-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX9-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX9-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  .LBB11_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v18, v32
; GFX9-NEXT:    v_mov_b32_e32 v19, v33
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB11_4:
; GFX9-NEXT:    s_branch .LBB11_2
;
; GFX11-LABEL: bitcast_v16f64_to_v32i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v14 :: v_dual_mov_b32 v31, v13
; GFX11-NEXT:    v_dual_mov_b32 v30, v12 :: v_dual_mov_b32 v29, v11
; GFX11-NEXT:    v_dual_mov_b32 v28, v10 :: v_dual_mov_b32 v27, v9
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v26, v8 :: v_dual_mov_b32 v25, v7
; GFX11-NEXT:    v_dual_mov_b32 v24, v6 :: v_dual_mov_b32 v23, v5
; GFX11-NEXT:    v_dual_mov_b32 v22, v4 :: v_dual_mov_b32 v21, v3
; GFX11-NEXT:    v_dual_mov_b32 v20, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB11_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB11_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB11_3:
; GFX11-NEXT:  .LBB11_4: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[30:31], v[30:31], 1.0
; GFX11-NEXT:    v_add_f64 v[28:29], v[28:29], 1.0
; GFX11-NEXT:    v_add_f64 v[26:27], v[26:27], 1.0
; GFX11-NEXT:    v_add_f64 v[24:25], v[24:25], 1.0
; GFX11-NEXT:    v_add_f64 v[22:23], v[22:23], 1.0
; GFX11-NEXT:    v_add_f64 v[20:21], v[20:21], 1.0
; GFX11-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; GFX11-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; GFX11-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX11-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX11-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX11-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX11-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <16 x double> %a1 to <32 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <16 x double> %a to <32 x i32>
  br label %end

end:
  %phi = phi <32 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <32 x i32> %phi
}

define <128 x i8> @bitcast_v32i32_to_v128i8(<32 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v32i32_to_v128i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:4
; SI-NEXT:    buffer_load_dword v33, off, s[0:3], s32 offset:8
; SI-NEXT:    buffer_load_dword v32, off, s[0:3], s32
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr45
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr63
; SI-NEXT:    ; implicit-def: $vgpr62
; SI-NEXT:    ; implicit-def: $vgpr61
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr60
; SI-NEXT:    ; implicit-def: $vgpr59
; SI-NEXT:    ; implicit-def: $vgpr58
; SI-NEXT:    ; implicit-def: $vgpr57
; SI-NEXT:    ; implicit-def: $vgpr56
; SI-NEXT:    ; implicit-def: $vgpr47
; SI-NEXT:    ; implicit-def: $vgpr46
; SI-NEXT:    ; implicit-def: $vgpr44
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr40
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; kill: killed $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v33
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB12_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v31, v32, 24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v31, v32, 16
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v31, v32, 8
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v30, v29, 24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v30, v29, 16
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v30, v29, 8
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v28, v27, 24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v28, v27, 16
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v28, v27, 8
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v26, v25, 24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v26, v25, 16
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v26, v25, 8
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v24, v23, 24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v24, v23, 16
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v24, v23, 8
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v22, v21, 24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v22, v21, 16
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v22, v21, 8
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v20, v19, 24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v20, v19, 16
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:160 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v20, v19, 8
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:168 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v18, v17, 24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:180 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v18, v17, 16
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:188 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v18, v17, 8
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:196 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v16, v15, 24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:212 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v16, v15, 16
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:216 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v16, v15, 8
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:224 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v14, v13, 24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:240 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v14, v13, 16
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:244 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v14, v13, 8
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:248 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v12, v11, 24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:264 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v12, v11, 16
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:268 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v12, v11, 8
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:272 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v10, v9, 24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:288 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v10, v9, 16
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:292 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v10, v9, 8
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:296 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v8, v7, 24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:312 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v8, v7, 16
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:316 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v8, v7, 8
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:324 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 24, v31
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 8, v31
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 24, v30
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:164 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 16, v30
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:172 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 8, v30
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:176 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 24, v28
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:184 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 16, v28
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:192 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 8, v28
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:200 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 24, v26
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:204 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 16, v26
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:208 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 8, v26
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:220 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 24, v24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:228 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 16, v24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:232 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 8, v24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:236 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 24, v22
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:252 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:256 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 8, v22
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:260 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 24, v20
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:276 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 16, v20
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:280 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 8, v20
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:284 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 24, v18
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:300 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 16, v18
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:304 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 8, v18
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:308 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 24, v16
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:320 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 16, v16
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:328 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 8, v16
; SI-NEXT:    v_alignbit_b32 v37, v6, v5, 24
; SI-NEXT:    v_alignbit_b32 v38, v6, v5, 16
; SI-NEXT:    v_alignbit_b32 v48, v6, v5, 8
; SI-NEXT:    v_alignbit_b32 v51, v4, v3, 24
; SI-NEXT:    v_alignbit_b32 v53, v4, v3, 16
; SI-NEXT:    v_alignbit_b32 v55, v4, v3, 8
; SI-NEXT:    v_alignbit_b32 v41, v2, v1, 24
; SI-NEXT:    v_alignbit_b32 v43, v2, v1, 16
; SI-NEXT:    v_alignbit_b32 v45, v2, v1, 8
; SI-NEXT:    v_lshrrev_b32_e32 v36, 16, v31
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:332 ; 4-byte Folded Spill
; SI-NEXT:    v_lshrrev_b32_e32 v39, 24, v14
; SI-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v50, 8, v14
; SI-NEXT:    v_lshrrev_b32_e32 v52, 24, v12
; SI-NEXT:    v_lshrrev_b32_e32 v54, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v40, 8, v12
; SI-NEXT:    v_lshrrev_b32_e32 v42, 24, v10
; SI-NEXT:    v_lshrrev_b32_e32 v44, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v46, 8, v10
; SI-NEXT:    v_lshrrev_b32_e32 v47, 24, v8
; SI-NEXT:    v_lshrrev_b32_e32 v56, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v57, 8, v8
; SI-NEXT:    v_lshrrev_b32_e32 v58, 24, v6
; SI-NEXT:    v_lshrrev_b32_e32 v59, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v60, 8, v6
; SI-NEXT:    v_lshrrev_b32_e32 v61, 24, v4
; SI-NEXT:    v_lshrrev_b32_e32 v62, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v63, 8, v4
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 24, v2
; SI-NEXT:    v_lshrrev_b32_e32 v34, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v35, 8, v2
; SI-NEXT:  .LBB12_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB12_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v31, vcc, 3, v31
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v32, vcc, 3, v32
; SI-NEXT:    v_alignbit_b32 v33, v31, v32, 24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v31, v32, 16
; SI-NEXT:    v_add_i32_e32 v30, vcc, 3, v30
; SI-NEXT:    v_add_i32_e32 v29, vcc, 3, v29
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v31, v32, 8
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v30, v29, 24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v30, v29, 16
; SI-NEXT:    v_add_i32_e32 v28, vcc, 3, v28
; SI-NEXT:    v_add_i32_e32 v27, vcc, 3, v27
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v30, v29, 8
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v28, v27, 24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v28, v27, 16
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v26
; SI-NEXT:    v_add_i32_e32 v25, vcc, 3, v25
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v28, v27, 8
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v26, v25, 24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v26, v25, 16
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    v_add_i32_e32 v23, vcc, 3, v23
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v26, v25, 8
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v24, v23, 24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v24, v23, 16
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v22
; SI-NEXT:    v_add_i32_e32 v21, vcc, 3, v21
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v24, v23, 8
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v22, v21, 24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v22, v21, 16
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v22, v21, 8
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v20, v19, 24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v20, v19, 16
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:160 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v20, v19, 8
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:168 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v18, v17, 24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:180 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v18, v17, 16
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:188 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v18, v17, 8
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:196 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v16, v15, 24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:212 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v16, v15, 16
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:216 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v16, v15, 8
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:224 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v14, v13, 24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:240 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v14, v13, 16
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:244 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v14, v13, 8
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:248 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v12, v11, 24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:264 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v12, v11, 16
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:268 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v12, v11, 8
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:272 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v10, v9, 24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:288 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v10, v9, 16
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:292 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v10, v9, 8
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:296 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v8, v7, 24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:312 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v8, v7, 16
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:316 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_alignbit_b32 v33, v8, v7, 8
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:324 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 24, v31
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 8, v31
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 24, v30
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:164 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 16, v30
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:172 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 8, v30
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:176 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 24, v28
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:184 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 16, v28
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:192 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 8, v28
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:200 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 24, v26
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:204 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 16, v26
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:208 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 8, v26
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:220 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 24, v24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:228 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 16, v24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:232 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 8, v24
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:236 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 24, v22
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:252 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:256 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 8, v22
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:260 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 24, v20
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:276 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 16, v20
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:280 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 8, v20
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:284 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 24, v18
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:300 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 16, v18
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:304 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 8, v18
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:308 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 24, v16
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:320 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 16, v16
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:328 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 8, v16
; SI-NEXT:    v_alignbit_b32 v37, v6, v5, 24
; SI-NEXT:    v_alignbit_b32 v38, v6, v5, 16
; SI-NEXT:    v_alignbit_b32 v48, v6, v5, 8
; SI-NEXT:    v_alignbit_b32 v51, v4, v3, 24
; SI-NEXT:    v_alignbit_b32 v53, v4, v3, 16
; SI-NEXT:    v_alignbit_b32 v55, v4, v3, 8
; SI-NEXT:    v_alignbit_b32 v41, v2, v1, 24
; SI-NEXT:    v_alignbit_b32 v43, v2, v1, 16
; SI-NEXT:    v_alignbit_b32 v45, v2, v1, 8
; SI-NEXT:    v_lshrrev_b32_e32 v36, 16, v31
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:332 ; 4-byte Folded Spill
; SI-NEXT:    v_lshrrev_b32_e32 v39, 24, v14
; SI-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v50, 8, v14
; SI-NEXT:    v_lshrrev_b32_e32 v52, 24, v12
; SI-NEXT:    v_lshrrev_b32_e32 v54, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v40, 8, v12
; SI-NEXT:    v_lshrrev_b32_e32 v42, 24, v10
; SI-NEXT:    v_lshrrev_b32_e32 v44, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v46, 8, v10
; SI-NEXT:    v_lshrrev_b32_e32 v47, 24, v8
; SI-NEXT:    v_lshrrev_b32_e32 v56, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v57, 8, v8
; SI-NEXT:    v_lshrrev_b32_e32 v58, 24, v6
; SI-NEXT:    v_lshrrev_b32_e32 v59, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v60, 8, v6
; SI-NEXT:    v_lshrrev_b32_e32 v61, 24, v4
; SI-NEXT:    v_lshrrev_b32_e32 v62, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v63, 8, v4
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v33, 24, v2
; SI-NEXT:    v_lshrrev_b32_e32 v34, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v35, 8, v2
; SI-NEXT:  .LBB12_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v45, 8, v45
; SI-NEXT:    v_and_b32_e32 v43, 0xff, v43
; SI-NEXT:    v_or_b32_e32 v1, v1, v45
; SI-NEXT:    v_lshlrev_b32_e32 v43, 16, v43
; SI-NEXT:    v_lshlrev_b32_e32 v41, 24, v41
; SI-NEXT:    v_or_b32_e32 v41, v41, v43
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v1, v1, v41
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v35
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v34
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v33, 24, v33
; SI-NEXT:    v_or_b32_e32 v2, v33, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 4, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v3
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v55
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v53
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v51
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 8, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v4
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v63
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v62
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v61
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 12, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v5
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v48
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v38
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v37
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 16, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v6
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v60
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v59
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v58
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 20, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:324 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v7
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:312 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:316 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 24, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v8
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v57
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v56
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v47
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 28, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:296 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v9
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:288 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:292 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 32, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v10
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v46
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v44
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v42
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 36, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:272 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v11
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:264 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:268 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 40, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v12
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v40
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v54
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v52
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 44, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:248 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v13
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:240 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:244 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 48, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v14
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v50
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v49
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v39
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 52, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:224 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v15
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:212 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:216 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 56, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:332 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v16
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:320 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:328 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 60, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:196 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v17
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:180 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:188 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 64, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:308 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v18
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:300 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:304 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x44, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:168 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v19
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:156 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:160 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x48, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:284 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v20
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:276 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:280 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x4c, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v21
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x50, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:260 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v22
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:252 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:256 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x54, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v23
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x58, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:236 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v24
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:228 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:232 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x5c, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v25
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x60, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:220 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v26
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:204 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:208 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x64, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v27
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x68, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:200 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v28
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:184 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:192 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x6c, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v29
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x70, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:176 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v30
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:164 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:172 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x74, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v32
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x78, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v31
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x7c, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v36
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v32i32_to_v128i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:4
; VI-NEXT:    buffer_load_dword v33, off, s[0:3], s32 offset:8
; VI-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr59
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr58
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:164 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:168 ; 4-byte Folded Spill
; VI-NEXT:    ; implicit-def: $vgpr58
; VI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:160 ; 4-byte Folded Spill
; VI-NEXT:    ; implicit-def: $vgpr58
; VI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; VI-NEXT:    ; implicit-def: $vgpr58
; VI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; VI-NEXT:    ; implicit-def: $vgpr58
; VI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; VI-NEXT:    ; implicit-def: $vgpr58
; VI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; VI-NEXT:    ; implicit-def: $vgpr58
; VI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; VI-NEXT:    ; implicit-def: $vgpr58
; VI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; VI-NEXT:    ; implicit-def: $vgpr58
; VI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; VI-NEXT:    ; implicit-def: $vgpr58
; VI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; VI-NEXT:    ; implicit-def: $vgpr58
; VI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; VI-NEXT:    ; implicit-def: $vgpr58
; VI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; VI-NEXT:    ; implicit-def: $vgpr48
; VI-NEXT:    ; implicit-def: $vgpr53
; VI-NEXT:    ; implicit-def: $vgpr57
; VI-NEXT:    ; implicit-def: $vgpr56
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr52
; VI-NEXT:    ; implicit-def: $vgpr47
; VI-NEXT:    ; implicit-def: $vgpr46
; VI-NEXT:    ; implicit-def: $vgpr45
; VI-NEXT:    ; implicit-def: $vgpr44
; VI-NEXT:    ; implicit-def: $vgpr51
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr43
; VI-NEXT:    ; implicit-def: $vgpr50
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr62
; VI-NEXT:    ; implicit-def: $vgpr61
; VI-NEXT:    ; implicit-def: $vgpr49
; VI-NEXT:    ; implicit-def: $vgpr60
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; kill: killed $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr42
; VI-NEXT:    ; implicit-def: $vgpr55
; VI-NEXT:    ; implicit-def: $vgpr41
; VI-NEXT:    ; implicit-def: $vgpr40
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr54
; VI-NEXT:    ; implicit-def: $vgpr58
; VI-NEXT:    s_waitcnt vmcnt(14)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB12_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v32
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:172 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v31
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:176 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v31
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:180 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 24, v30
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:184 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v30
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:188 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v30
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:192 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v29
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:196 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v29
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:200 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 24, v28
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:204 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v28
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:208 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v28
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:212 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v27
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:216 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 24, v26
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:220 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v26
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:224 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v26
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:228 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v25
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:232 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v25
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:236 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 24, v24
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:240 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v24
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:244 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v24
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:248 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v23
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:252 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v23
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:256 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 24, v22
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:260 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:264 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v22
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:268 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v21
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:272 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v21
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:276 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 24, v20
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:280 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v20
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:284 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v20
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:288 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v19
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:292 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v19
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:296 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 24, v18
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:300 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v18
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:304 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v18
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:308 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v17
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:312 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v17
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:316 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 24, v16
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:320 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v16
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:324 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v16
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:328 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v15
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:332 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v15
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:336 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 24, v14
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:340 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v14
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:344 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v14
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:348 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v13
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:352 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v13
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:356 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 24, v12
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:360 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v12
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:364 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v12
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:368 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v11
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:372 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v11
; VI-NEXT:    v_lshrrev_b64 v[54:55], 24, v[31:32]
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:376 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v10
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:380 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v54, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v55, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b64 v[54:55], 24, v[29:30]
; VI-NEXT:    buffer_store_dword v54, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v55, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b64 v[54:55], 24, v[27:28]
; VI-NEXT:    buffer_store_dword v54, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v55, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b64 v[54:55], 24, v[25:26]
; VI-NEXT:    buffer_store_dword v54, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v55, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b64 v[54:55], 24, v[23:24]
; VI-NEXT:    buffer_store_dword v54, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v55, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b64 v[54:55], 24, v[21:22]
; VI-NEXT:    buffer_store_dword v54, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v55, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b64 v[54:55], 24, v[19:20]
; VI-NEXT:    buffer_store_dword v54, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v55, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b64 v[54:55], 24, v[17:18]
; VI-NEXT:    buffer_store_dword v54, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v55, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b64 v[54:55], 24, v[15:16]
; VI-NEXT:    buffer_store_dword v54, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v55, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b64 v[54:55], 24, v[13:14]
; VI-NEXT:    buffer_store_dword v54, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v55, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b64 v[54:55], 24, v[11:12]
; VI-NEXT:    buffer_store_dword v54, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v55, off, s[0:3], s32 offset:160 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b64 v[54:55], 24, v[9:10]
; VI-NEXT:    buffer_store_dword v54, off, s[0:3], s32 offset:164 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v55, off, s[0:3], s32 offset:168 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v39, 24, v32
; VI-NEXT:    v_lshrrev_b64 v[54:55], 24, v[7:8]
; VI-NEXT:    v_mov_b32_e32 v55, v39
; VI-NEXT:    v_lshrrev_b64 v[39:40], 24, v[5:6]
; VI-NEXT:    v_lshrrev_b64 v[40:41], 24, v[3:4]
; VI-NEXT:    v_lshrrev_b64 v[41:42], 24, v[1:2]
; VI-NEXT:    v_lshrrev_b32_e32 v58, 8, v27
; VI-NEXT:    v_lshrrev_b32_e32 v59, 24, v10
; VI-NEXT:    v_lshrrev_b32_e32 v35, 8, v10
; VI-NEXT:    v_lshrrev_b32_e32 v60, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v49, 8, v9
; VI-NEXT:    v_lshrrev_b32_e32 v61, 24, v8
; VI-NEXT:    v_lshrrev_b32_e32 v62, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v36, 8, v8
; VI-NEXT:    v_lshrrev_b32_e32 v63, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v50, 8, v7
; VI-NEXT:    v_lshrrev_b32_e32 v43, 24, v6
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v37, 8, v6
; VI-NEXT:    v_lshrrev_b32_e32 v51, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v44, 8, v5
; VI-NEXT:    v_lshrrev_b32_e32 v45, 24, v4
; VI-NEXT:    v_lshrrev_b32_e32 v46, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v47, 8, v4
; VI-NEXT:    v_lshrrev_b32_e32 v52, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v38, 8, v3
; VI-NEXT:    v_lshrrev_b32_e32 v34, 24, v2
; VI-NEXT:    v_lshrrev_b32_e32 v56, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v57, 8, v2
; VI-NEXT:    v_lshrrev_b32_e32 v53, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v48, 8, v1
; VI-NEXT:    v_lshrrev_b32_e32 v42, 16, v32
; VI-NEXT:  .LBB12_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB12_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v32, vcc, 3, v32
; VI-NEXT:    v_add_u32_e32 v31, vcc, 3, v31
; VI-NEXT:    v_lshrrev_b64 v[33:34], 24, v[31:32]
; VI-NEXT:    v_add_u32_e32 v30, vcc, 3, v30
; VI-NEXT:    v_add_u32_e32 v29, vcc, 3, v29
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b64 v[33:34], 24, v[29:30]
; VI-NEXT:    v_add_u32_e32 v28, vcc, 3, v28
; VI-NEXT:    v_add_u32_e32 v27, vcc, 3, v27
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b64 v[33:34], 24, v[27:28]
; VI-NEXT:    v_add_u32_e32 v26, vcc, 3, v26
; VI-NEXT:    v_add_u32_e32 v25, vcc, 3, v25
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b64 v[33:34], 24, v[25:26]
; VI-NEXT:    v_add_u32_e32 v24, vcc, 3, v24
; VI-NEXT:    v_add_u32_e32 v23, vcc, 3, v23
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b64 v[33:34], 24, v[23:24]
; VI-NEXT:    v_add_u32_e32 v22, vcc, 3, v22
; VI-NEXT:    v_add_u32_e32 v21, vcc, 3, v21
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b64 v[33:34], 24, v[21:22]
; VI-NEXT:    v_add_u32_e32 v20, vcc, 3, v20
; VI-NEXT:    v_add_u32_e32 v19, vcc, 3, v19
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b64 v[33:34], 24, v[19:20]
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_add_u32_e32 v17, vcc, 3, v17
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b64 v[33:34], 24, v[17:18]
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b64 v[33:34], 24, v[15:16]
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b64 v[33:34], 24, v[13:14]
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b64 v[33:34], 24, v[11:12]
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:160 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b64 v[33:34], 24, v[9:10]
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:164 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:168 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v32
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:172 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v31
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:176 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v31
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:180 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 24, v30
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:184 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v30
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:188 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v30
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:192 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v29
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:196 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v29
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:200 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 24, v28
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:204 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v28
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:208 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v28
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:212 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v27
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:216 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 24, v26
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:220 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v26
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:224 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v26
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:228 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v25
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:232 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v25
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:236 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 24, v24
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:240 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v24
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:244 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v24
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:248 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v23
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:252 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v23
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:256 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 24, v22
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:260 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:264 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v22
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:268 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v21
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:272 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v21
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:276 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 24, v20
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:280 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v20
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:284 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v20
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:288 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v19
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:292 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v19
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:296 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 24, v18
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:300 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v18
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:304 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v18
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:308 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v17
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:312 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v17
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:316 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 24, v16
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:320 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v16
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:324 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v16
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:328 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v15
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:332 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v15
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:336 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 24, v14
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:340 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v14
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:344 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v14
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:348 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v13
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:352 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v13
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:356 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 24, v12
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:360 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v12
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:364 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v12
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_lshrrev_b64 v[39:40], 24, v[5:6]
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:368 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v11
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_lshrrev_b64 v[40:41], 24, v[3:4]
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:372 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v11
; VI-NEXT:    v_lshrrev_b64 v[54:55], 24, v[7:8]
; VI-NEXT:    v_lshrrev_b64 v[41:42], 24, v[1:2]
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:376 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v55, 24, v32
; VI-NEXT:    v_lshrrev_b32_e32 v42, 16, v32
; VI-NEXT:    v_lshrrev_b32_e32 v58, 8, v27
; VI-NEXT:    v_lshrrev_b32_e32 v59, 24, v10
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:380 ; 4-byte Folded Spill
; VI-NEXT:    v_lshrrev_b32_e32 v35, 8, v10
; VI-NEXT:    v_lshrrev_b32_e32 v60, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v49, 8, v9
; VI-NEXT:    v_lshrrev_b32_e32 v61, 24, v8
; VI-NEXT:    v_lshrrev_b32_e32 v62, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v36, 8, v8
; VI-NEXT:    v_lshrrev_b32_e32 v63, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v50, 8, v7
; VI-NEXT:    v_lshrrev_b32_e32 v43, 24, v6
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v37, 8, v6
; VI-NEXT:    v_lshrrev_b32_e32 v51, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v44, 8, v5
; VI-NEXT:    v_lshrrev_b32_e32 v45, 24, v4
; VI-NEXT:    v_lshrrev_b32_e32 v46, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v47, 8, v4
; VI-NEXT:    v_lshrrev_b32_e32 v52, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v38, 8, v3
; VI-NEXT:    v_lshrrev_b32_e32 v34, 24, v2
; VI-NEXT:    v_lshrrev_b32_e32 v56, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v57, 8, v2
; VI-NEXT:    v_lshrrev_b32_e32 v53, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v48, 8, v1
; VI-NEXT:  .LBB12_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_lshlrev_b16_e32 v48, 8, v48
; VI-NEXT:    v_or_b32_sdwa v1, v1, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b16_e32 v48, 8, v57
; VI-NEXT:    v_or_b32_sdwa v2, v2, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b16_e32 v48, 8, v41
; VI-NEXT:    v_or_b32_sdwa v48, v53, v48 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v34
; VI-NEXT:    v_or_b32_sdwa v1, v56, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 4, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v40
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v38
; VI-NEXT:    v_or_b32_sdwa v1, v52, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 8, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v47
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v45
; VI-NEXT:    v_or_b32_sdwa v1, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v46, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 12, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v39
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v44
; VI-NEXT:    v_or_b32_sdwa v1, v51, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 16, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v37
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v43
; VI-NEXT:    v_or_b32_sdwa v1, v6, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v33, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 20, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v54
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v50
; VI-NEXT:    v_or_b32_sdwa v1, v63, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v7, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 24, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v36
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v61
; VI-NEXT:    v_or_b32_sdwa v1, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v62, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 28, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:164 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:168 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v49
; VI-NEXT:    v_or_b32_sdwa v2, v9, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; VI-NEXT:    v_or_b32_sdwa v1, v60, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 32, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:380 ; 4-byte Folded Reload
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v35
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v59
; VI-NEXT:    v_or_b32_sdwa v1, v10, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 36, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:156 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:160 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:372 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:376 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; VI-NEXT:    v_or_b32_sdwa v2, v11, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 40, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:368 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:360 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:364 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; VI-NEXT:    v_or_b32_sdwa v1, v12, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 44, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:352 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:356 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; VI-NEXT:    v_or_b32_sdwa v2, v13, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 48, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:348 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:340 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:344 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; VI-NEXT:    v_or_b32_sdwa v1, v14, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 52, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:332 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:336 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; VI-NEXT:    v_or_b32_sdwa v2, v15, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 56, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:328 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:320 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:324 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; VI-NEXT:    v_or_b32_sdwa v1, v16, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 60, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:312 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:316 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; VI-NEXT:    v_or_b32_sdwa v2, v17, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 64, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:308 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:300 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:304 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; VI-NEXT:    v_or_b32_sdwa v1, v18, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x44, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:292 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:296 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; VI-NEXT:    v_or_b32_sdwa v2, v19, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x48, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:288 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:280 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:284 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; VI-NEXT:    v_or_b32_sdwa v1, v20, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x4c, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:276 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:272 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; VI-NEXT:    v_or_b32_sdwa v1, v21, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x50, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:268 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:260 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:264 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; VI-NEXT:    v_or_b32_sdwa v1, v22, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x54, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:256 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:252 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(3)
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; VI-NEXT:    v_or_b32_sdwa v1, v23, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x58, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:248 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:240 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:244 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; VI-NEXT:    v_or_b32_sdwa v1, v24, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x5c, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:236 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:232 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(3)
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; VI-NEXT:    v_or_b32_sdwa v1, v25, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x60, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:228 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:220 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:224 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; VI-NEXT:    v_or_b32_sdwa v1, v26, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x64, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:216 ; 4-byte Folded Reload
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v58
; VI-NEXT:    v_or_b32_sdwa v1, v27, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x68, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:212 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:204 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:208 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; VI-NEXT:    v_or_b32_sdwa v1, v28, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x6c, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:200 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:196 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(3)
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; VI-NEXT:    v_or_b32_sdwa v1, v29, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x70, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:192 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:184 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:188 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; VI-NEXT:    v_or_b32_sdwa v1, v30, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x74, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:180 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:176 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(3)
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; VI-NEXT:    v_or_b32_sdwa v1, v31, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x78, v0
; VI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:172 ; 4-byte Folded Reload
; VI-NEXT:    v_lshlrev_b16_e32 v2, 8, v55
; VI-NEXT:    v_or_b32_sdwa v2, v42, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x7c, v0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; VI-NEXT:    v_or_b32_sdwa v1, v32, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; VI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v32i32_to_v128i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:4
; GFX9-NEXT:    buffer_load_dword v33, off, s[0:3], s32 offset:8
; GFX9-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; kill: killed $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr50
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr43
; GFX9-NEXT:    ; kill: killed $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; kill: killed $vgpr50
; GFX9-NEXT:    ; implicit-def: $vgpr50
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    ; implicit-def: $vgpr56
; GFX9-NEXT:    ; implicit-def: $vgpr44
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr53
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr47
; GFX9-NEXT:    ; implicit-def: $vgpr51
; GFX9-NEXT:    ; implicit-def: $vgpr62
; GFX9-NEXT:    ; implicit-def: $vgpr46
; GFX9-NEXT:    ; implicit-def: $vgpr61
; GFX9-NEXT:    ; implicit-def: $vgpr45
; GFX9-NEXT:    ; implicit-def: $vgpr49
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr55
; GFX9-NEXT:    ; implicit-def: $vgpr58
; GFX9-NEXT:    ; implicit-def: $vgpr54
; GFX9-NEXT:    ; implicit-def: $vgpr48
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr52
; GFX9-NEXT:    ; kill: killed $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; kill: killed $vgpr50
; GFX9-NEXT:    ; implicit-def: $vgpr50
; GFX9-NEXT:    ; implicit-def: $vgpr60
; GFX9-NEXT:    ; implicit-def: $vgpr59
; GFX9-NEXT:    ; implicit-def: $vgpr57
; GFX9-NEXT:    ; kill: killed $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr41
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:180 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:184 ; 4-byte Folded Spill
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:172 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:176 ; 4-byte Folded Spill
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:164 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:168 ; 4-byte Folded Spill
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:160 ; 4-byte Folded Spill
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(29)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB12_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 24, v32
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:188 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v32
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:192 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v32
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:196 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(31)
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v31
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:200 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v31
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:204 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 24, v30
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:208 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v30
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:212 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v30
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:216 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v29
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:220 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v29
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:224 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 24, v28
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:228 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v28
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:232 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v28
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:236 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v27
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:240 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v27
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:244 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 24, v26
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:248 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v26
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:252 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v26
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:256 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v25
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:260 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v25
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:264 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 24, v24
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:268 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v24
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:272 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v24
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:276 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v23
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:280 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v23
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:284 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 24, v22
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:288 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:292 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v22
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:296 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v21
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:300 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v21
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:304 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 24, v20
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:308 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v20
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:312 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v20
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:316 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v19
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:324 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v19
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:320 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 24, v18
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:328 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v18
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:332 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v18
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:376 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v17
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:336 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v17
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:388 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 24, v16
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:340 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v16
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:344 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v15
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:348 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 24, v14
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:352 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v14
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:356 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v13
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:360 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 24, v12
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:364 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v12
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:368 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v11
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:372 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 24, v10
; GFX9-NEXT:    v_lshrrev_b64 v[40:41], 24, v[31:32]
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:380 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v9
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:384 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:392 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[40:41], 24, v[29:30]
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[40:41], 24, v[27:28]
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[40:41], 24, v[25:26]
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[40:41], 24, v[23:24]
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[40:41], 24, v[21:22]
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[40:41], 24, v[19:20]
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[40:41], 24, v[17:18]
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[40:41], 24, v[15:16]
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[40:41], 24, v[13:14]
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[40:41], 24, v[11:12]
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:160 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[40:41], 24, v[9:10]
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:164 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:168 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[40:41], 24, v[7:8]
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:172 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:176 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[40:41], 24, v[5:6]
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:180 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:184 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[40:41], 24, v[3:4]
; GFX9-NEXT:    v_lshrrev_b32_e32 v57, 8, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v59, 8, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v60, 8, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v50, 8, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 8, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v52, 8, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 8, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 24, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v48, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v54, 8, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v58, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v55, 8, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 24, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v49, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v45, 8, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v61, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v46, 8, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v62, 24, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v51, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v47, 8, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v63, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 8, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v43, 24, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v53, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 8, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v44, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v56, 8, v1
; GFX9-NEXT:    v_lshrrev_b64 v[41:42], 24, v[1:2]
; GFX9-NEXT:  .LBB12_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB12_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v32, 3, v32
; GFX9-NEXT:    s_waitcnt vmcnt(28)
; GFX9-NEXT:    v_add_u32_e32 v31, 3, v31
; GFX9-NEXT:    v_lshrrev_b64 v[33:34], 24, v[31:32]
; GFX9-NEXT:    v_add_u32_e32 v30, 3, v30
; GFX9-NEXT:    v_add_u32_e32 v29, 3, v29
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[33:34], 24, v[29:30]
; GFX9-NEXT:    v_add_u32_e32 v28, 3, v28
; GFX9-NEXT:    v_add_u32_e32 v27, 3, v27
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[33:34], 24, v[27:28]
; GFX9-NEXT:    v_add_u32_e32 v26, 3, v26
; GFX9-NEXT:    v_add_u32_e32 v25, 3, v25
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[33:34], 24, v[25:26]
; GFX9-NEXT:    v_add_u32_e32 v24, 3, v24
; GFX9-NEXT:    v_add_u32_e32 v23, 3, v23
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[33:34], 24, v[23:24]
; GFX9-NEXT:    v_add_u32_e32 v22, 3, v22
; GFX9-NEXT:    v_add_u32_e32 v21, 3, v21
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[33:34], 24, v[21:22]
; GFX9-NEXT:    v_add_u32_e32 v20, 3, v20
; GFX9-NEXT:    v_add_u32_e32 v19, 3, v19
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[33:34], 24, v[19:20]
; GFX9-NEXT:    v_add_u32_e32 v18, 3, v18
; GFX9-NEXT:    v_add_u32_e32 v17, 3, v17
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[33:34], 24, v[17:18]
; GFX9-NEXT:    v_add_u32_e32 v16, 3, v16
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[33:34], 24, v[15:16]
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[33:34], 24, v[13:14]
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[33:34], 24, v[11:12]
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:160 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[33:34], 24, v[9:10]
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:164 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:168 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[33:34], 24, v[7:8]
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:172 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:176 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b64 v[33:34], 24, v[5:6]
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:180 ; 4-byte Folded Spill
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:184 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 24, v32
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:188 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v32
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:192 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v32
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:196 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v31
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:200 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v31
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:204 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 24, v30
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:208 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v30
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:212 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v30
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:216 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v29
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:220 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v29
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:224 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 24, v28
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:228 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v28
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:232 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v28
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:236 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v27
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:240 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v27
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:244 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 24, v26
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:248 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v26
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:252 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v26
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:256 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v25
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:260 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v25
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:264 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 24, v24
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:268 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v24
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:272 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v24
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:276 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v23
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:280 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v23
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:284 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 24, v22
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:288 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:292 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v22
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:296 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v21
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:300 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v21
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:304 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 24, v20
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:308 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v20
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:312 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v20
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:316 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v19
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:324 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v19
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:320 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 24, v18
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:328 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v18
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:332 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v18
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:376 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v17
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:336 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v17
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:388 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 24, v16
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:340 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v16
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:344 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v15
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:348 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 24, v14
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:352 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v14
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:356 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v13
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:360 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 24, v12
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:364 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v12
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:368 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v11
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_lshrrev_b64 v[40:41], 24, v[3:4]
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:372 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 24, v10
; GFX9-NEXT:    v_lshrrev_b64 v[41:42], 24, v[1:2]
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:380 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v57, 8, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v59, 8, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v60, 8, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v50, 8, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 8, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v52, 8, v11
; GFX9-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:384 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v10
; GFX9-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:392 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 8, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 24, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v48, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v54, 8, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v58, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v55, 8, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 24, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v49, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v45, 8, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v61, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v46, 8, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v62, 24, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v51, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v47, 8, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v63, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 8, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v43, 24, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v53, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 8, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v44, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v56, 8, v1
; GFX9-NEXT:  .LBB12_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_lshlrev_b16_e32 v33, 8, v33
; GFX9-NEXT:    v_or_b32_sdwa v10, v10, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b16_e32 v33, 8, v52
; GFX9-NEXT:    v_or_b32_sdwa v11, v11, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b16_e32 v33, 8, v36
; GFX9-NEXT:    v_or_b32_sdwa v12, v12, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b16_e32 v33, 8, v50
; GFX9-NEXT:    v_or_b32_sdwa v13, v13, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b16_e32 v33, 8, v60
; GFX9-NEXT:    v_or_b32_sdwa v14, v14, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b16_e32 v33, 8, v59
; GFX9-NEXT:    v_or_b32_sdwa v15, v15, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b16_e32 v33, 8, v57
; GFX9-NEXT:    v_or_b32_sdwa v16, v16, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v33, off, s[0:3], s32 offset:388 ; 4-byte Folded Reload
; GFX9-NEXT:    v_lshlrev_b16_e32 v42, 8, v56
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v42 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b16_e32 v38, 8, v38
; GFX9-NEXT:    v_or_b32_sdwa v2, v2, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b16_e32 v38, 8, v39
; GFX9-NEXT:    v_or_b32_sdwa v3, v3, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b16_e32 v38, 8, v47
; GFX9-NEXT:    v_or_b32_sdwa v4, v4, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b16_e32 v38, 8, v46
; GFX9-NEXT:    v_or_b32_sdwa v5, v5, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b16_e32 v38, 8, v45
; GFX9-NEXT:    v_or_b32_sdwa v6, v6, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b16_e32 v38, 8, v55
; GFX9-NEXT:    v_or_b32_sdwa v7, v7, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b16_e32 v38, 8, v54
; GFX9-NEXT:    v_or_b32_sdwa v8, v8, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b16_e32 v37, 8, v37
; GFX9-NEXT:    v_or_b32_sdwa v9, v9, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshlrev_b16_e32 v33, 8, v33
; GFX9-NEXT:    v_or_b32_sdwa v17, v17, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v33, off, s[0:3], s32 offset:376 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshlrev_b16_e32 v33, 8, v33
; GFX9-NEXT:    v_or_b32_sdwa v18, v18, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b16_e32 v33, 8, v41
; GFX9-NEXT:    v_or_b32_sdwa v33, v44, v33 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v43
; GFX9-NEXT:    v_or_b32_sdwa v1, v53, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:4
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v40
; GFX9-NEXT:    v_or_b32_sdwa v1, v63, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:8
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v62
; GFX9-NEXT:    v_or_b32_sdwa v1, v51, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:12
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:180 ; 4-byte Folded Reload
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:184 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    v_or_b32_sdwa v1, v61, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:16
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v35
; GFX9-NEXT:    v_or_b32_sdwa v1, v49, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v6, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:20
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:172 ; 4-byte Folded Reload
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:176 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    v_or_b32_sdwa v1, v58, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v7, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:24
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v34
; GFX9-NEXT:    v_or_b32_sdwa v1, v48, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:28
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:164 ; 4-byte Folded Reload
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:168 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:392 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v9, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:32
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:380 ; 4-byte Folded Reload
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:384 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v10, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:36
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:156 ; 4-byte Folded Reload
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:160 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:372 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v11, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:40
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:364 ; 4-byte Folded Reload
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:368 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v12, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:44
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:360 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v13, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:48
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:352 ; 4-byte Folded Reload
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:356 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v14, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:52
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:348 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v15, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:56
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:340 ; 4-byte Folded Reload
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:344 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v16, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:60
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:336 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v17, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:64
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:328 ; 4-byte Folded Reload
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:332 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v18, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:68
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:324 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:320 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; GFX9-NEXT:    v_or_b32_sdwa v2, v19, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:72
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:316 ; 4-byte Folded Reload
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:308 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:312 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    v_or_b32_sdwa v1, v20, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:76
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:304 ; 4-byte Folded Reload
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:300 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    v_or_b32_sdwa v1, v21, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:80
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:296 ; 4-byte Folded Reload
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:288 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:292 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    v_or_b32_sdwa v1, v22, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:84
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:284 ; 4-byte Folded Reload
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:280 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    v_or_b32_sdwa v1, v23, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:88
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:276 ; 4-byte Folded Reload
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:268 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:272 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    v_or_b32_sdwa v1, v24, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:92
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:264 ; 4-byte Folded Reload
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:260 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    v_or_b32_sdwa v1, v25, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:96
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:256 ; 4-byte Folded Reload
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:248 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:252 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    v_or_b32_sdwa v1, v26, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:100
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:244 ; 4-byte Folded Reload
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:240 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    v_or_b32_sdwa v1, v27, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:104
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:236 ; 4-byte Folded Reload
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:228 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:232 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    v_or_b32_sdwa v1, v28, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:108
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:224 ; 4-byte Folded Reload
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:220 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    v_or_b32_sdwa v1, v29, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:112
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:216 ; 4-byte Folded Reload
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:208 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:212 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    v_or_b32_sdwa v1, v30, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:116
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:204 ; 4-byte Folded Reload
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:200 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    v_or_b32_sdwa v1, v31, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:120
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:196 ; 4-byte Folded Reload
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:188 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:192 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    v_or_b32_sdwa v1, v32, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:124
; GFX9-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v32i32_to_v128i8:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_clause 0x2
; GFX11-TRUE16-NEXT:    scratch_load_b32 v33, off, s32 offset:8
; GFX11-TRUE16-NEXT:    scratch_load_b32 v32, off, s32 offset:4
; GFX11-TRUE16-NEXT:    scratch_load_b32 v31, off, s32
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr39_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr66_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr162_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr161_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr160_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr65_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr151_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr150_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr149_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr64_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr148_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr147_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr146_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr54_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr145_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr144_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr135_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr53_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr134_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr133_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr132_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr52_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr131_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr130_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr129_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr51_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr128_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr119_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr118_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr50_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr117_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr116_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr115_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr49_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr114_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr113_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr112_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr48_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr103_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr102_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr101_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr38_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr100_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr99_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr98_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr37_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr97_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr96_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr87_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr36_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr86_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr85_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr84_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr35_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr83_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr82_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr81_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr34_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr80_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr71_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr70_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr69_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr68_lo16
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(2)
; GFX11-TRUE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v33
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr33_lo16
; GFX11-TRUE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB12_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[33:34], 24, v[31:32]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[48:49], 24, v[19:20]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[34:35], 24, v[29:30]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[49:50], 24, v[17:18]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[35:36], 24, v[27:28]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[50:51], 24, v[15:16]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[36:37], 24, v[25:26]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[51:52], 24, v[13:14]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[37:38], 24, v[23:24]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[52:53], 24, v[11:12]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[64:65], 24, v[5:6]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[38:39], 24, v[21:22]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[53:54], 24, v[9:10]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[65:66], 24, v[3:4]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v68, 24, v32
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v69, 8, v32
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v70, 8, v31
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v71, 24, v30
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v80, 8, v30
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v81, 8, v29
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v82, 24, v28
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v83, 8, v28
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v84, 8, v27
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v85, 24, v26
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v86, 8, v26
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v87, 8, v25
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v96, 24, v24
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v97, 8, v24
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v98, 8, v23
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v99, 24, v22
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v100, 8, v22
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v101, 8, v21
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v102, 24, v20
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v103, 8, v20
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v112, 8, v19
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v113, 24, v18
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v114, 8, v18
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v115, 8, v17
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v116, 24, v16
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v117, 8, v16
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v118, 8, v15
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v119, 24, v14
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v128, 8, v14
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v129, 8, v13
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v130, 24, v12
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v131, 8, v12
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v132, 8, v11
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v133, 24, v10
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v134, 8, v10
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v135, 8, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v144, 24, v8
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v145, 8, v8
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v146, 8, v7
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v147, 24, v6
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v148, 8, v6
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v149, 8, v5
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v150, 24, v4
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v151, 8, v4
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v160, 8, v3
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v161, 24, v2
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v162, 8, v2
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[54:55], 24, v[7:8]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[66:67], 24, v[1:2]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v39, 8, v1
; GFX11-TRUE16-NEXT:  .LBB12_2: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB12_4
; GFX11-TRUE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v20, 3, v20
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(1)
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v32, 3, v32
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v31, 3, v31
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v30, 3, v30
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v29, 3, v29
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v28, 3, v28
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v27, 3, v27
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v26, 3, v26
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v25, 3, v25
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v24, 3, v24
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v23, 3, v23
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[48:49], 24, v[19:20]
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v22, 3, v22
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v21, 3, v21
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[33:34], 24, v[31:32]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[49:50], 24, v[17:18]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[34:35], 24, v[29:30]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[50:51], 24, v[15:16]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[35:36], 24, v[27:28]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[51:52], 24, v[13:14]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[36:37], 24, v[25:26]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[52:53], 24, v[11:12]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[64:65], 24, v[5:6]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[37:38], 24, v[23:24]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[53:54], 24, v[9:10]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[65:66], 24, v[3:4]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[38:39], 24, v[21:22]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[54:55], 24, v[7:8]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[66:67], 24, v[1:2]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v68, 24, v32
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v69, 8, v32
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v70, 8, v31
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v71, 24, v30
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v80, 8, v30
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v81, 8, v29
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v82, 24, v28
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v83, 8, v28
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v84, 8, v27
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v85, 24, v26
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v86, 8, v26
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v87, 8, v25
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v96, 24, v24
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v97, 8, v24
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v98, 8, v23
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v99, 24, v22
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v100, 8, v22
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v101, 8, v21
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v102, 24, v20
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v103, 8, v20
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v112, 8, v19
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v113, 24, v18
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v114, 8, v18
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v115, 8, v17
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v116, 24, v16
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v117, 8, v16
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v118, 8, v15
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v119, 24, v14
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v128, 8, v14
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v129, 8, v13
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v130, 24, v12
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v131, 8, v12
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v132, 8, v11
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v133, 24, v10
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v134, 8, v10
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v135, 8, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v144, 24, v8
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v145, 8, v8
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v146, 8, v7
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v147, 24, v6
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v148, 8, v6
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v149, 8, v5
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v150, 24, v4
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v151, 8, v4
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v160, 8, v3
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v161, 24, v2
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v162, 8, v2
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v39, 8, v1
; GFX11-TRUE16-NEXT:  .LBB12_4: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v1.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v33.h, 8, v39.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v1.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v34.h, 8, v66.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, 0xff, v2.h
; GFX11-TRUE16-NEXT:    v_and_b16 v4.h, 0xff, v4.h
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v1.l, v33.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v33.h, 8, v161.l
; GFX11-TRUE16-NEXT:    v_or_b16 v39.l, v1.h, v34.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v2.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v2.l, 8, v162.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v55.l, v1.l
; GFX11-TRUE16-NEXT:    v_and_b16 v6.h, 0xff, v6.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v39, 16, v39
; GFX11-TRUE16-NEXT:    v_and_b16 v10.l, 0xff, v10.l
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v1.h, v2.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v2.h, v33.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v55, 0xffff, v55
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v2.h, 8, v160.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v33.h, 8, v150.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v66.l, v1.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v67.l, v2.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.l, 0xff, v3.l
; GFX11-TRUE16-NEXT:    v_and_b16 v3.l, 0xff, v3.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v3.h, 8, v65.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v55, v39
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v55, 0xffff, v66
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v65, 16, v67
; GFX11-TRUE16-NEXT:    v_or_b16 v39.l, v2.l, v2.h
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v3.l, v3.h
; GFX11-TRUE16-NEXT:    v_and_b16 v3.h, 0xff, v4.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v4.l, 8, v151.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v55, v65
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v39, 0xffff, v39
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v55.l, v3.l
; GFX11-TRUE16-NEXT:    v_and_b16 v12.l, 0xff, v12.l
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v3.h, v4.l
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v4.h, v33.h
; GFX11-TRUE16-NEXT:    v_and_b16 v3.h, 0xff, v5.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v4.h, 8, v149.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v55, 16, v55
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v65.l, v3.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v66.l, v4.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v5.l, 8, v64.l
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v3.h, v4.h
; GFX11-TRUE16-NEXT:    v_and_b16 v4.h, 0xff, v5.h
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v3, v39, v55
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v39, 0xffff, v65
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v55, 16, v66
; GFX11-TRUE16-NEXT:    v_and_b16 v5.h, 0xff, v6.l
; GFX11-TRUE16-NEXT:    v_or_b16 v5.l, v4.h, v5.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v6.l, 8, v148.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v33.h, 8, v147.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v64.l, v4.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v4, v39, v55
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v55.l, v5.l
; GFX11-TRUE16-NEXT:    v_or_b16 v5.l, v5.h, v6.l
; GFX11-TRUE16-NEXT:    v_or_b16 v6.l, v6.h, v33.h
; GFX11-TRUE16-NEXT:    v_and_b16 v5.h, 0xff, v7.l
; GFX11-TRUE16-NEXT:    v_and_b16 v7.l, 0xff, v7.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v7.h, 8, v54.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v39, 0xffff, v64
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v6.h, 8, v146.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v54, 16, v55
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v64.l, v6.l
; GFX11-TRUE16-NEXT:    v_or_b16 v7.l, v7.l, v7.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v55.l, v5.l
; GFX11-TRUE16-NEXT:    v_or_b16 v6.l, v5.h, v6.h
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v5, v39, v54
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v54, 16, v64
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v64.l, v7.l
; GFX11-TRUE16-NEXT:    v_and_b16 v7.l, 0xff, v8.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v7.h, 8, v145.l
; GFX11-TRUE16-NEXT:    v_and_b16 v8.l, 0xff, v8.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v8.h, 8, v144.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v39, 0xffff, v55
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v55.l, v6.l
; GFX11-TRUE16-NEXT:    v_or_b16 v7.l, v7.l, v7.h
; GFX11-TRUE16-NEXT:    v_and_b16 v7.h, 0xff, v9.l
; GFX11-TRUE16-NEXT:    v_or_b16 v8.l, v8.l, v8.h
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v6, v39, v54
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v39, 0xffff, v55
; GFX11-TRUE16-NEXT:    v_and_b16 v9.l, 0xff, v9.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v9.h, 8, v53.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v33.h, 8, v134.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v53.l, v7.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v55.l, v8.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v8.h, 8, v135.l
; GFX11-TRUE16-NEXT:    v_or_b16 v8.l, v9.l, v9.h
; GFX11-TRUE16-NEXT:    v_or_b16 v9.l, v10.l, v33.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v53, 0xffff, v53
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v55, 16, v55
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v54, 16, v64
; GFX11-TRUE16-NEXT:    v_or_b16 v7.l, v7.h, v8.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v65.l, v8.l
; GFX11-TRUE16-NEXT:    v_and_b16 v10.l, 0xff, v11.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v8, v53, v55
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v55, 0xffff, v9
; GFX11-TRUE16-NEXT:    v_and_b16 v9.l, 0xff, v10.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v10.h, 8, v132.l
; GFX11-TRUE16-NEXT:    v_and_b16 v11.l, 0xff, v11.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v11.h, 8, v52.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v64.l, v7.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v7, v39, v54
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v9.h, 8, v133.l
; GFX11-TRUE16-NEXT:    v_or_b16 v10.l, v10.l, v10.h
; GFX11-TRUE16-NEXT:    v_or_b16 v11.l, v11.l, v11.h
; GFX11-TRUE16-NEXT:    s_clause 0x1
; GFX11-TRUE16-NEXT:    scratch_store_b128 v0, v[1:4], off
; GFX11-TRUE16-NEXT:    scratch_store_b128 v0, v[5:8], off offset:16
; GFX11-TRUE16-NEXT:    v_and_b16 v5.l, 0xff, v13.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v5.h, 8, v129.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v33.h, 8, v131.l
; GFX11-TRUE16-NEXT:    v_and_b16 v12.h, 0xff, v12.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v34.h, 8, v130.l
; GFX11-TRUE16-NEXT:    v_or_b16 v9.l, v9.l, v9.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX11-TRUE16-NEXT:    v_and_b16 v6.l, 0xff, v13.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v6.h, 8, v51.l
; GFX11-TRUE16-NEXT:    v_or_b16 v5.l, v5.l, v5.h
; GFX11-TRUE16-NEXT:    v_or_b16 v12.l, v12.l, v33.h
; GFX11-TRUE16-NEXT:    v_or_b16 v39.l, v12.h, v34.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v3, v10, v11
; GFX11-TRUE16-NEXT:    v_and_b16 v7.l, 0xff, v14.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v7.h, 8, v128.l
; GFX11-TRUE16-NEXT:    v_or_b16 v6.l, v6.l, v6.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v10, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_and_b16 v5.l, 0xff, v15.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v5.h, 8, v50.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v39, 16, v39
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v55, v9
; GFX11-TRUE16-NEXT:    v_and_b16 v8.l, 0xff, v14.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v8.h, 8, v119.l
; GFX11-TRUE16-NEXT:    v_and_b16 v9.l, 0xff, v15.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v9.h, 8, v118.l
; GFX11-TRUE16-NEXT:    v_or_b16 v7.l, v7.l, v7.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v6
; GFX11-TRUE16-NEXT:    v_or_b16 v5.l, v5.l, v5.h
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v4, v12, v39
; GFX11-TRUE16-NEXT:    v_or_b16 v8.l, v8.l, v8.h
; GFX11-TRUE16-NEXT:    v_or_b16 v9.l, v9.l, v9.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v12, 0xffff, v7
; GFX11-TRUE16-NEXT:    v_and_b16 v6.l, 0xff, v16.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v6.h, 8, v117.l
; GFX11-TRUE16-NEXT:    v_and_b16 v7.l, 0xff, v16.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v7.h, 8, v116.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v5
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v5, v10, v11
; GFX11-TRUE16-NEXT:    v_and_b16 v10.l, 0xff, v18.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v10.h, 8, v114.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v8
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v14, 0xffff, v9
; GFX11-TRUE16-NEXT:    v_and_b16 v8.l, 0xff, v17.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v8.h, 8, v115.l
; GFX11-TRUE16-NEXT:    v_or_b16 v6.l, v6.l, v6.h
; GFX11-TRUE16-NEXT:    v_or_b16 v7.l, v7.l, v7.h
; GFX11-TRUE16-NEXT:    v_and_b16 v11.l, 0xff, v18.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v11.h, 8, v113.l
; GFX11-TRUE16-NEXT:    v_or_b16 v10.l, v10.l, v10.h
; GFX11-TRUE16-NEXT:    v_and_b16 v9.l, 0xff, v17.h
; GFX11-TRUE16-NEXT:    v_or_b16 v8.l, v8.l, v8.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v16, 0xffff, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v7
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v6, v12, v13
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v7, v14, v15
; GFX11-TRUE16-NEXT:    v_and_b16 v12.l, 0xff, v19.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v12.h, 8, v112.l
; GFX11-TRUE16-NEXT:    v_and_b16 v13.l, 0xff, v19.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v13.h, 8, v48.l
; GFX11-TRUE16-NEXT:    v_or_b16 v11.l, v11.l, v11.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v15, 0xffff, v10
; GFX11-TRUE16-NEXT:    v_and_b16 v10.l, 0xff, v20.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v10.h, 8, v102.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v39, 0xffff, v8
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v8, v16, v17
; GFX11-TRUE16-NEXT:    v_and_b16 v14.l, 0xff, v20.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v14.h, 8, v103.l
; GFX11-TRUE16-NEXT:    v_or_b16 v12.l, v12.l, v12.h
; GFX11-TRUE16-NEXT:    v_or_b16 v13.l, v13.l, v13.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v16, 16, v11
; GFX11-TRUE16-NEXT:    v_and_b16 v11.l, 0xff, v21.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v11.h, 8, v101.l
; GFX11-TRUE16-NEXT:    v_or_b16 v10.l, v10.l, v10.h
; GFX11-TRUE16-NEXT:    v_or_b16 v14.l, v14.l, v14.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v17, 0xffff, v12
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v13
; GFX11-TRUE16-NEXT:    v_and_b16 v12.l, 0xff, v21.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v12.h, 8, v38.l
; GFX11-TRUE16-NEXT:    v_or_b16 v11.l, v11.l, v11.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v20, 16, v10
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v10, v15, v16
; GFX11-TRUE16-NEXT:    v_and_b16 v15.l, 0xff, v23.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v15.h, 8, v98.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v19, 0xffff, v14
; GFX11-TRUE16-NEXT:    v_and_b16 v13.l, 0xff, v22.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v13.h, 8, v100.l
; GFX11-TRUE16-NEXT:    v_or_b16 v12.l, v12.l, v12.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v21, 0xffff, v11
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v11, v17, v18
; GFX11-TRUE16-NEXT:    v_and_b16 v16.l, 0xff, v23.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v16.h, 8, v37.l
; GFX11-TRUE16-NEXT:    v_and_b16 v17.l, 0xff, v24.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v17.h, 8, v97.l
; GFX11-TRUE16-NEXT:    v_or_b16 v15.l, v15.l, v15.h
; GFX11-TRUE16-NEXT:    v_and_b16 v14.l, 0xff, v22.h
; GFX11-TRUE16-NEXT:    v_or_b16 v13.l, v13.l, v13.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v12
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v12, v19, v20
; GFX11-TRUE16-NEXT:    v_and_b16 v18.l, 0xff, v24.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v18.h, 8, v96.l
; GFX11-TRUE16-NEXT:    v_and_b16 v19.l, 0xff, v25.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v19.h, 8, v87.l
; GFX11-TRUE16-NEXT:    v_or_b16 v16.l, v16.l, v16.h
; GFX11-TRUE16-NEXT:    v_or_b16 v17.l, v17.l, v17.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v20, 0xffff, v15
; GFX11-TRUE16-NEXT:    v_and_b16 v15.l, 0xff, v25.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v15.h, 8, v36.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v38, 0xffff, v13
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v13, v21, v22
; GFX11-TRUE16-NEXT:    v_or_b16 v18.l, v18.l, v18.h
; GFX11-TRUE16-NEXT:    v_or_b16 v19.l, v19.l, v19.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v16
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v22, 0xffff, v17
; GFX11-TRUE16-NEXT:    v_and_b16 v16.l, 0xff, v26.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v16.h, 8, v86.l
; GFX11-TRUE16-NEXT:    v_and_b16 v17.l, 0xff, v26.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v17.h, 8, v85.l
; GFX11-TRUE16-NEXT:    v_or_b16 v15.l, v15.l, v15.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v18
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v24, 0xffff, v19
; GFX11-TRUE16-NEXT:    v_or_b16 v16.l, v16.l, v16.h
; GFX11-TRUE16-NEXT:    v_or_b16 v17.l, v17.l, v17.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v15
; GFX11-TRUE16-NEXT:    v_and_b16 v18.l, 0xff, v27.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v18.h, 8, v84.l
; GFX11-TRUE16-NEXT:    v_and_b16 v19.l, 0xff, v27.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v26, 0xffff, v16
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v27, 16, v17
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v15, v20, v21
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v16, v22, v23
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v17, v24, v25
; GFX11-TRUE16-NEXT:    v_and_b16 v20.l, 0xff, v28.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v20.h, 8, v83.l
; GFX11-TRUE16-NEXT:    v_and_b16 v21.l, 0xff, v28.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v21.h, 8, v82.l
; GFX11-TRUE16-NEXT:    v_and_b16 v22.l, 0xff, v29.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v22.h, 8, v81.l
; GFX11-TRUE16-NEXT:    v_and_b16 v23.l, 0xff, v29.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v23.h, 8, v34.l
; GFX11-TRUE16-NEXT:    v_and_b16 v24.l, 0xff, v30.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v24.h, 8, v80.l
; GFX11-TRUE16-NEXT:    v_or_b16 v18.l, v18.l, v18.h
; GFX11-TRUE16-NEXT:    v_or_b16 v20.l, v20.l, v20.h
; GFX11-TRUE16-NEXT:    v_or_b16 v21.l, v21.l, v21.h
; GFX11-TRUE16-NEXT:    v_or_b16 v22.l, v22.l, v22.h
; GFX11-TRUE16-NEXT:    v_or_b16 v23.l, v23.l, v23.h
; GFX11-TRUE16-NEXT:    v_or_b16 v24.l, v24.l, v24.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v9.h, 8, v49.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v14.h, 8, v99.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v19.h, 8, v35.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v35, 0xffff, v18
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v18, v26, v27
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v25, 0xffff, v20
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v26, 16, v21
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v27, 0xffff, v22
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v28, 16, v23
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v29, 0xffff, v24
; GFX11-TRUE16-NEXT:    v_and_b16 v20.l, 0xff, v30.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v20.h, 8, v71.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-TRUE16-NEXT:    v_and_b16 v21.l, 0xff, v31.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v21.h, 8, v70.l
; GFX11-TRUE16-NEXT:    v_and_b16 v22.l, 0xff, v31.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v22.h, 8, v33.l
; GFX11-TRUE16-NEXT:    v_and_b16 v23.l, 0xff, v32.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v23.h, 8, v69.l
; GFX11-TRUE16-NEXT:    v_and_b16 v24.l, 0xff, v32.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v24.h, 8, v68.l
; GFX11-TRUE16-NEXT:    v_or_b16 v9.l, v9.l, v9.h
; GFX11-TRUE16-NEXT:    v_or_b16 v14.l, v14.l, v14.h
; GFX11-TRUE16-NEXT:    v_or_b16 v19.l, v19.l, v19.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v53, 0xffff, v64
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v54, 16, v65
; GFX11-TRUE16-NEXT:    v_or_b16 v20.l, v20.l, v20.h
; GFX11-TRUE16-NEXT:    v_or_b16 v21.l, v21.l, v21.h
; GFX11-TRUE16-NEXT:    v_or_b16 v22.l, v22.l, v22.h
; GFX11-TRUE16-NEXT:    v_or_b16 v23.l, v23.l, v23.h
; GFX11-TRUE16-NEXT:    v_or_b16 v24.l, v24.l, v24.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v19, 16, v19
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v53, v54
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v30, 16, v20
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v31, 0xffff, v21
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v32, 16, v22
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v33, 0xffff, v23
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v9, v39, v9
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v14, v38, v14
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v19, v35, v19
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v20, v25, v26
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v21, v27, v28
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v22, v29, v30
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v23, v31, v32
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v24, v33, v24
; GFX11-TRUE16-NEXT:    s_clause 0x5
; GFX11-TRUE16-NEXT:    scratch_store_b128 v0, v[1:4], off offset:32
; GFX11-TRUE16-NEXT:    scratch_store_b128 v0, v[5:8], off offset:48
; GFX11-TRUE16-NEXT:    scratch_store_b128 v0, v[9:12], off offset:64
; GFX11-TRUE16-NEXT:    scratch_store_b128 v0, v[13:16], off offset:80
; GFX11-TRUE16-NEXT:    scratch_store_b128 v0, v[17:20], off offset:96
; GFX11-TRUE16-NEXT:    scratch_store_b128 v0, v[21:24], off offset:112
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v32i32_to_v128i8:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_clause 0x13
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v40, s32 offset:88
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v41, s32 offset:84
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v42, s32 offset:80
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v43, s32 offset:76
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v44, s32 offset:72
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v45, s32 offset:68
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v46, s32 offset:64
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v47, s32 offset:60
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v56, s32 offset:56
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v57, s32 offset:52
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v58, s32 offset:48
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v59, s32 offset:44
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v60, s32 offset:40
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v61, s32 offset:36
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v62, s32 offset:32
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v63, s32 offset:28
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v72, s32 offset:24
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v73, s32 offset:20
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v74, s32 offset:16
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v75, s32 offset:12
; GFX11-FAKE16-NEXT:    s_clause 0x2
; GFX11-FAKE16-NEXT:    scratch_load_b32 v33, off, s32 offset:8
; GFX11-FAKE16-NEXT:    scratch_load_b32 v32, off, s32 offset:4
; GFX11-FAKE16-NEXT:    scratch_load_b32 v31, off, s32
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr75
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr74
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr66
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr73
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr72
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr63
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr62
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr61
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr65
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr60
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr59
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr58
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr57
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr56
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr64
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr47
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr46
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr45
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr44
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr43
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr54
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr42
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr41
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr40
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr183
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr182
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr53
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr181
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr180
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr179
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr178
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr177
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr52
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr176
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr167
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr166
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr165
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr164
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr51
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr163
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr162
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr161
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr160
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr151
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr50
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr150
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr149
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr148
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr147
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr146
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr49
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr145
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr144
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr135
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr134
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr133
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr48
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr132
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr131
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr130
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr129
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr128
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr38
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr119
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr118
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr117
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr116
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr115
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr37
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr114
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr113
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr112
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr103
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr102
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr36
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr101
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr100
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr99
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr98
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr97
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr35
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr96
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr87
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr86
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr85
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr84
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr83
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr82
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr81
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr80
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr71
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr70
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr69
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr68
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr34
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(2)
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v33
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr33
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB12_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[48:49], 24, v[19:20]
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[33:34], 24, v[31:32]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[49:50], 24, v[17:18]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[34:35], 24, v[29:30]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[50:51], 24, v[15:16]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[35:36], 24, v[27:28]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[51:52], 24, v[13:14]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[36:37], 24, v[25:26]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[52:53], 24, v[11:12]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[64:65], 24, v[5:6]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[37:38], 24, v[23:24]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[53:54], 24, v[9:10]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[65:66], 24, v[3:4]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v68, 24, v32
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v69, 16, v32
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v70, 8, v32
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v71, 16, v31
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v80, 8, v31
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v81, 24, v30
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v82, 16, v30
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v83, 8, v30
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v84, 16, v29
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v85, 8, v29
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v86, 24, v28
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v87, 16, v28
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v96, 8, v28
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v97, 16, v27
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v98, 8, v27
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v99, 24, v26
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v100, 16, v26
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v101, 8, v26
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v102, 16, v25
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v103, 8, v25
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v112, 24, v24
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v113, 16, v24
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v114, 8, v24
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v115, 16, v23
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v116, 8, v23
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v117, 24, v22
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v118, 16, v22
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v119, 8, v22
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v128, 16, v21
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v129, 8, v21
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v130, 24, v20
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v131, 16, v20
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v132, 8, v20
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v133, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v134, 8, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v135, 24, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v144, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v145, 8, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v146, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v147, 8, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v148, 24, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v149, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v150, 8, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v151, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v160, 8, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v161, 24, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v162, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v163, 8, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v164, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v165, 8, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v166, 24, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v167, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v176, 8, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v177, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v178, 8, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v179, 24, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v180, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v181, 8, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v182, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v183, 8, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v40, 24, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v41, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v42, 8, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v43, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v44, 8, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v45, 24, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v46, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v47, 8, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v56, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v57, 8, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v58, 24, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v59, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v60, 8, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v61, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v62, 8, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v63, 24, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v72, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v73, 8, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v74, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v75, 8, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[38:39], 24, v[21:22]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[54:55], 24, v[7:8]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[66:67], 24, v[1:2]
; GFX11-FAKE16-NEXT:  .LBB12_2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB12_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v20, 3, v20
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(1)
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v32, 3, v32
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v31, 3, v31
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v30, 3, v30
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v29, 3, v29
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v28, 3, v28
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v27, 3, v27
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v26, 3, v26
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v25, 3, v25
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v24, 3, v24
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v23, 3, v23
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[48:49], 24, v[19:20]
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v22, 3, v22
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v21, 3, v21
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[33:34], 24, v[31:32]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[49:50], 24, v[17:18]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[34:35], 24, v[29:30]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[50:51], 24, v[15:16]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[35:36], 24, v[27:28]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[51:52], 24, v[13:14]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[36:37], 24, v[25:26]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[52:53], 24, v[11:12]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[64:65], 24, v[5:6]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[37:38], 24, v[23:24]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[53:54], 24, v[9:10]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[65:66], 24, v[3:4]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[38:39], 24, v[21:22]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[54:55], 24, v[7:8]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[66:67], 24, v[1:2]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v68, 24, v32
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v69, 16, v32
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v70, 8, v32
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v71, 16, v31
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v80, 8, v31
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v81, 24, v30
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v82, 16, v30
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v83, 8, v30
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v84, 16, v29
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v85, 8, v29
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v86, 24, v28
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v87, 16, v28
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v96, 8, v28
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v97, 16, v27
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v98, 8, v27
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v99, 24, v26
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v100, 16, v26
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v101, 8, v26
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v102, 16, v25
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v103, 8, v25
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v112, 24, v24
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v113, 16, v24
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v114, 8, v24
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v115, 16, v23
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v116, 8, v23
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v117, 24, v22
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v118, 16, v22
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v119, 8, v22
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v128, 16, v21
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v129, 8, v21
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v130, 24, v20
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v131, 16, v20
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v132, 8, v20
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v133, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v134, 8, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v135, 24, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v144, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v145, 8, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v146, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v147, 8, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v148, 24, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v149, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v150, 8, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v151, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v160, 8, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v161, 24, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v162, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v163, 8, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v164, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v165, 8, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v166, 24, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v167, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v176, 8, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v177, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v178, 8, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v179, 24, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v180, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v181, 8, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v182, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v183, 8, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v40, 24, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v41, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v42, 8, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v43, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v44, 8, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v45, 24, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v46, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v47, 8, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v56, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v57, 8, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v58, 24, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v59, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v60, 8, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v61, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v62, 8, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v63, 24, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v72, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v73, 8, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v74, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v75, 8, v1
; GFX11-FAKE16-NEXT:  .LBB12_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v55, 8, v75
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v39, 8, v66
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v66, 8, v63
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v65, 8, v65
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v55
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v55, 0xff, v74
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v67, 0xff, v61
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v39, v55, v39
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v55, 8, v73
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v65, v67, v65
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v67, 8, v58
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xff, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v39, 16, v39
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v2, v55
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v55, 0xff, v72
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v64, 8, v64
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v39
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v55, v55, v66
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v66, 8, v62
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xff, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v54, 8, v54
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xff, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v39, 16, v55
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v3, v66
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v55, 8, v60
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v66, 0xff, v59
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v53, 8, v53
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v2, v39
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v39, 16, v65
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v4, v55
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v55, v66, v67
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v65, 8, v57
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v66, 0xff, v56
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v3, v39
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v39, 16, v55
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v5, v65
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v55, v66, v64
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v64, 8, v47
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v65, 0xff, v46
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v66, 8, v45
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v4, v39
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v39, 16, v55
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v6, v64
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v55, v65, v66
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v64, 8, v44
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v65, 0xff, v43
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v5, v39
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v39, 16, v55
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v7, v64
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v54, v65, v54
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v55, 8, v42
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v64, 0xff, v41
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v65, 8, v40
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v6, v39
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v39, 16, v54
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v8, v55
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v54, v64, v65
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v64, 0xff, v182
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xff, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v55, 8, v183
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xff, v10
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v65, 8, v181
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v54, 16, v54
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v53, v64, v53
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v9, v55
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v10, v65
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v7, v39
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v8, v54
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v39, 16, v53
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v53, 0xff, v180
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v54, 8, v179
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xff, v11
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v55, 8, v178
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v64, 0xff, v177
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v52, 8, v52
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xff, v12
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v65, 8, v176
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v66, 0xff, v167
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v67, 8, v166
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v53, v53, v54
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v11, v55
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v52, v64, v52
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v12, v65
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v54, v66, v67
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v53, 16, v53
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v52, 16, v52
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v54, 16, v54
; GFX11-FAKE16-NEXT:    s_clause 0x1
; GFX11-FAKE16-NEXT:    scratch_store_b128 v0, v[1:4], off
; GFX11-FAKE16-NEXT:    scratch_store_b128 v0, v[5:8], off offset:16
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v9, v39
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v10, v53
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v11, v52
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v12, v54
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xff, v13
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v6, 8, v165
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xff, v164
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v8, 8, v51
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xff, v14
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v10, 8, v163
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xff, v162
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v12, 8, v161
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v13, 0xff, v15
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v14, 8, v160
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v5, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v7, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v9, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v11, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v13, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xff, v151
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v11, 8, v50
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xff, v16
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v13, 8, v150
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xff, v149
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v15, 8, v148
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v16, 0xff, v17
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v17, 8, v147
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v39, 0xff, v146
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v49, 8, v49
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v10, v11
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v12, v13
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v14, v15
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, v16, v17
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, v39, v49
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v5, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v7, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v9, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v11, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v13, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xff, v18
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v11, 8, v145
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xff, v144
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v13, 8, v135
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xff, v19
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v15, 8, v134
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v16, 0xff, v133
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v17, 8, v48
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v18, 0xff, v20
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v19, 8, v132
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v10, v11
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v12, v13
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v14, v15
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, v16, v17
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, v18, v19
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v15, 0xff, v131
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v16, 8, v130
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v17, 0xff, v21
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v18, 8, v129
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v19, 0xff, v128
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v20, 8, v38
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v21, 0xff, v22
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v22, 8, v119
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v38, 0xff, v118
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v39, 8, v117
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v15, v15, v16
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v16, v17, v18
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v17, v19, v20
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v18, v21, v22
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v19, v38, v39
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v15
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v16, 0xffff, v16
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v18, 0xffff, v18
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v19, 16, v19
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v10, v11
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v12, v13
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v14, v15
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, v16, v17
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, v18, v19
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v15, 0xff, v23
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v16, 8, v116
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v17, 0xff, v115
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v18, 8, v37
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v19, 0xff, v24
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v20, 8, v114
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v21, 0xff, v113
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v22, 8, v112
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v23, 0xff, v25
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v24, 8, v103
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v15, v15, v16
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v16, v17, v18
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v17, v19, v20
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v18, v21, v22
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v19, v23, v24
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v20, 0xff, v102
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v21, 8, v36
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v22, 0xff, v26
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v23, 8, v101
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v24, 0xff, v100
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v25, 8, v99
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v26, 0xff, v27
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v27, 8, v98
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v36, 0xff, v97
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v35, 8, v35
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, v20, v21
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v21, v22, v23
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v22, v24, v25
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v23, v26, v27
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v24, v36, v35
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v16, 16, v16
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v19, 0xffff, v19
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v20, 16, v20
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v21, 0xffff, v21
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v22
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v23, 0xffff, v23
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v15, v15, v16
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v16, v17, v18
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v17, v19, v20
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v18, v21, v22
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v19, v23, v24
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v20, 0xff, v28
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v21, 8, v96
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v22, 0xff, v87
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v23, 8, v86
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v24, 0xff, v29
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v25, 8, v85
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v26, 0xff, v84
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v27, 8, v34
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v28, 0xff, v30
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v29, 8, v83
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, v20, v21
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v21, v22, v23
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v22, v24, v25
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v23, v26, v27
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v24, v28, v29
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v25, 0xff, v82
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v26, 8, v81
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v27, 0xff, v31
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v28, 8, v80
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v29, 0xff, v71
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v30, 8, v33
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v31, 0xff, v32
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v32, 8, v70
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v33, 0xff, v69
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v34, 8, v68
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v25, v25, v26
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v26, v27, v28
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v27, v29, v30
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v28, v31, v32
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v29, v33, v34
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v20, 0xffff, v20
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v22, 0xffff, v22
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v24, 0xffff, v24
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v25
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v26, 0xffff, v26
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v27, 16, v27
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v28, 0xffff, v28
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v29, 16, v29
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, v20, v21
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v21, v22, v23
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v22, v24, v25
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v23, v26, v27
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v24, v28, v29
; GFX11-FAKE16-NEXT:    s_clause 0x5
; GFX11-FAKE16-NEXT:    scratch_store_b128 v0, v[1:4], off offset:32
; GFX11-FAKE16-NEXT:    scratch_store_b128 v0, v[5:8], off offset:48
; GFX11-FAKE16-NEXT:    scratch_store_b128 v0, v[9:12], off offset:64
; GFX11-FAKE16-NEXT:    scratch_store_b128 v0, v[13:16], off offset:80
; GFX11-FAKE16-NEXT:    scratch_store_b128 v0, v[17:20], off offset:96
; GFX11-FAKE16-NEXT:    scratch_store_b128 v0, v[21:24], off offset:112
; GFX11-FAKE16-NEXT:    s_clause 0x13
; GFX11-FAKE16-NEXT:    scratch_load_b32 v75, off, s32 offset:12
; GFX11-FAKE16-NEXT:    scratch_load_b32 v74, off, s32 offset:16
; GFX11-FAKE16-NEXT:    scratch_load_b32 v73, off, s32 offset:20
; GFX11-FAKE16-NEXT:    scratch_load_b32 v72, off, s32 offset:24
; GFX11-FAKE16-NEXT:    scratch_load_b32 v63, off, s32 offset:28
; GFX11-FAKE16-NEXT:    scratch_load_b32 v62, off, s32 offset:32
; GFX11-FAKE16-NEXT:    scratch_load_b32 v61, off, s32 offset:36
; GFX11-FAKE16-NEXT:    scratch_load_b32 v60, off, s32 offset:40
; GFX11-FAKE16-NEXT:    scratch_load_b32 v59, off, s32 offset:44
; GFX11-FAKE16-NEXT:    scratch_load_b32 v58, off, s32 offset:48
; GFX11-FAKE16-NEXT:    scratch_load_b32 v57, off, s32 offset:52
; GFX11-FAKE16-NEXT:    scratch_load_b32 v56, off, s32 offset:56
; GFX11-FAKE16-NEXT:    scratch_load_b32 v47, off, s32 offset:60
; GFX11-FAKE16-NEXT:    scratch_load_b32 v46, off, s32 offset:64
; GFX11-FAKE16-NEXT:    scratch_load_b32 v45, off, s32 offset:68
; GFX11-FAKE16-NEXT:    scratch_load_b32 v44, off, s32 offset:72
; GFX11-FAKE16-NEXT:    scratch_load_b32 v43, off, s32 offset:76
; GFX11-FAKE16-NEXT:    scratch_load_b32 v42, off, s32 offset:80
; GFX11-FAKE16-NEXT:    scratch_load_b32 v41, off, s32 offset:84
; GFX11-FAKE16-NEXT:    scratch_load_b32 v40, off, s32 offset:88
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <32 x i32> %a, splat (i32 3)
  %a2 = bitcast <32 x i32> %a1 to <128 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <32 x i32> %a to <128 x i8>
  br label %end

end:
  %phi = phi <128 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <128 x i8> %phi
}

define inreg <128 x i8> @bitcast_v32i32_to_v128i8_scalar(<32 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v32i32_to_v128i8_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_or_saveexec_b64 s[4:5], -1
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; SI-NEXT:    s_mov_b64 exec, s[4:5]
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_writelane_b32 v41, s30, 0
; SI-NEXT:    v_writelane_b32 v41, s31, 1
; SI-NEXT:    v_writelane_b32 v41, s34, 2
; SI-NEXT:    v_writelane_b32 v41, s35, 3
; SI-NEXT:    v_writelane_b32 v41, s36, 4
; SI-NEXT:    v_writelane_b32 v41, s37, 5
; SI-NEXT:    v_writelane_b32 v41, s38, 6
; SI-NEXT:    v_writelane_b32 v41, s39, 7
; SI-NEXT:    v_writelane_b32 v41, s48, 8
; SI-NEXT:    v_writelane_b32 v41, s49, 9
; SI-NEXT:    v_writelane_b32 v41, s50, 10
; SI-NEXT:    v_writelane_b32 v41, s51, 11
; SI-NEXT:    v_writelane_b32 v41, s52, 12
; SI-NEXT:    v_writelane_b32 v41, s53, 13
; SI-NEXT:    v_writelane_b32 v41, s54, 14
; SI-NEXT:    v_writelane_b32 v41, s55, 15
; SI-NEXT:    v_writelane_b32 v41, s64, 16
; SI-NEXT:    v_writelane_b32 v41, s65, 17
; SI-NEXT:    v_writelane_b32 v41, s66, 18
; SI-NEXT:    v_writelane_b32 v41, s67, 19
; SI-NEXT:    v_writelane_b32 v41, s68, 20
; SI-NEXT:    v_writelane_b32 v41, s69, 21
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v19
; SI-NEXT:    v_writelane_b32 v41, s70, 22
; SI-NEXT:    v_readfirstlane_b32 s47, v1
; SI-NEXT:    v_readfirstlane_b32 s46, v2
; SI-NEXT:    v_readfirstlane_b32 s45, v3
; SI-NEXT:    v_readfirstlane_b32 s44, v4
; SI-NEXT:    v_readfirstlane_b32 s43, v5
; SI-NEXT:    v_readfirstlane_b32 s42, v6
; SI-NEXT:    v_readfirstlane_b32 s41, v7
; SI-NEXT:    v_readfirstlane_b32 s40, v8
; SI-NEXT:    v_readfirstlane_b32 s15, v9
; SI-NEXT:    v_readfirstlane_b32 s14, v10
; SI-NEXT:    v_readfirstlane_b32 s13, v11
; SI-NEXT:    v_readfirstlane_b32 s12, v12
; SI-NEXT:    v_readfirstlane_b32 s11, v13
; SI-NEXT:    v_readfirstlane_b32 s10, v14
; SI-NEXT:    v_readfirstlane_b32 s9, v15
; SI-NEXT:    v_readfirstlane_b32 s8, v16
; SI-NEXT:    v_readfirstlane_b32 s7, v17
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_readfirstlane_b32 s6, v18
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    v_writelane_b32 v41, s71, 23
; SI-NEXT:    s_cbranch_scc0 .LBB13_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v22, s45
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v6, s9
; SI-NEXT:    v_mov_b32_e32 v9, s11
; SI-NEXT:    v_mov_b32_e32 v12, s13
; SI-NEXT:    v_mov_b32_e32 v15, s15
; SI-NEXT:    v_mov_b32_e32 v18, s41
; SI-NEXT:    v_mov_b32_e32 v21, s43
; SI-NEXT:    v_alignbit_b32 v24, s44, v22, 24
; SI-NEXT:    v_alignbit_b32 v25, s44, v22, 16
; SI-NEXT:    v_alignbit_b32 v26, s44, v22, 8
; SI-NEXT:    v_mov_b32_e32 v22, s47
; SI-NEXT:    v_mov_b32_e32 v23, s28
; SI-NEXT:    v_mov_b32_e32 v29, s26
; SI-NEXT:    v_mov_b32_e32 v35, s24
; SI-NEXT:    v_mov_b32_e32 v39, s22
; SI-NEXT:    v_mov_b32_e32 v50, s20
; SI-NEXT:    v_mov_b32_e32 v53, s18
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v40, s16
; SI-NEXT:    v_alignbit_b32 v1, s6, v3, 24
; SI-NEXT:    v_alignbit_b32 v2, s6, v3, 16
; SI-NEXT:    v_alignbit_b32 v3, s6, v3, 8
; SI-NEXT:    v_alignbit_b32 v4, s8, v6, 24
; SI-NEXT:    v_alignbit_b32 v5, s8, v6, 16
; SI-NEXT:    v_alignbit_b32 v6, s8, v6, 8
; SI-NEXT:    v_alignbit_b32 v7, s10, v9, 24
; SI-NEXT:    v_alignbit_b32 v8, s10, v9, 16
; SI-NEXT:    v_alignbit_b32 v9, s10, v9, 8
; SI-NEXT:    v_alignbit_b32 v10, s12, v12, 24
; SI-NEXT:    v_alignbit_b32 v11, s12, v12, 16
; SI-NEXT:    v_alignbit_b32 v12, s12, v12, 8
; SI-NEXT:    v_alignbit_b32 v13, s14, v15, 24
; SI-NEXT:    v_alignbit_b32 v14, s14, v15, 16
; SI-NEXT:    v_alignbit_b32 v15, s14, v15, 8
; SI-NEXT:    v_alignbit_b32 v16, s40, v18, 24
; SI-NEXT:    v_alignbit_b32 v17, s40, v18, 16
; SI-NEXT:    v_alignbit_b32 v18, s40, v18, 8
; SI-NEXT:    v_alignbit_b32 v19, s42, v21, 24
; SI-NEXT:    v_alignbit_b32 v20, s42, v21, 16
; SI-NEXT:    v_alignbit_b32 v21, s42, v21, 8
; SI-NEXT:    v_alignbit_b32 v30, s46, v22, 24
; SI-NEXT:    v_alignbit_b32 v31, s46, v22, 16
; SI-NEXT:    v_alignbit_b32 v32, s46, v22, 8
; SI-NEXT:    v_alignbit_b32 v36, s29, v23, 24
; SI-NEXT:    v_alignbit_b32 v22, s29, v23, 16
; SI-NEXT:    v_alignbit_b32 v23, s29, v23, 8
; SI-NEXT:    v_alignbit_b32 v27, s27, v29, 24
; SI-NEXT:    v_alignbit_b32 v28, s27, v29, 16
; SI-NEXT:    v_alignbit_b32 v29, s27, v29, 8
; SI-NEXT:    v_alignbit_b32 v33, s25, v35, 24
; SI-NEXT:    v_alignbit_b32 v34, s25, v35, 16
; SI-NEXT:    v_alignbit_b32 v35, s25, v35, 8
; SI-NEXT:    v_alignbit_b32 v37, s23, v39, 24
; SI-NEXT:    v_alignbit_b32 v38, s23, v39, 16
; SI-NEXT:    v_alignbit_b32 v39, s23, v39, 8
; SI-NEXT:    v_alignbit_b32 v48, s21, v50, 24
; SI-NEXT:    v_alignbit_b32 v49, s21, v50, 16
; SI-NEXT:    v_alignbit_b32 v50, s21, v50, 8
; SI-NEXT:    v_alignbit_b32 v51, s19, v53, 24
; SI-NEXT:    v_alignbit_b32 v52, s19, v53, 16
; SI-NEXT:    v_alignbit_b32 v53, s19, v53, 8
; SI-NEXT:    v_alignbit_b32 v54, s17, v40, 24
; SI-NEXT:    v_alignbit_b32 v55, s17, v40, 16
; SI-NEXT:    v_alignbit_b32 v40, s17, v40, 8
; SI-NEXT:    s_lshr_b32 s56, s6, 24
; SI-NEXT:    s_lshr_b32 s57, s6, 16
; SI-NEXT:    s_lshr_b32 s58, s6, 8
; SI-NEXT:    s_lshr_b32 s59, s8, 24
; SI-NEXT:    s_lshr_b32 s60, s8, 16
; SI-NEXT:    s_lshr_b32 s61, s8, 8
; SI-NEXT:    s_lshr_b32 s62, s10, 24
; SI-NEXT:    s_lshr_b32 s63, s10, 16
; SI-NEXT:    s_lshr_b32 s72, s10, 8
; SI-NEXT:    s_lshr_b32 s73, s12, 24
; SI-NEXT:    s_lshr_b32 s74, s12, 16
; SI-NEXT:    s_lshr_b32 s75, s12, 8
; SI-NEXT:    s_lshr_b32 s76, s14, 24
; SI-NEXT:    s_lshr_b32 s77, s14, 16
; SI-NEXT:    s_lshr_b32 s78, s14, 8
; SI-NEXT:    s_lshr_b32 s79, s40, 24
; SI-NEXT:    s_lshr_b32 s88, s40, 16
; SI-NEXT:    s_lshr_b32 s89, s40, 8
; SI-NEXT:    s_lshr_b32 s90, s42, 24
; SI-NEXT:    s_lshr_b32 s91, s42, 16
; SI-NEXT:    s_lshr_b32 s92, s42, 8
; SI-NEXT:    s_lshr_b32 s93, s44, 24
; SI-NEXT:    s_lshr_b32 s94, s44, 16
; SI-NEXT:    s_lshr_b32 s95, s44, 8
; SI-NEXT:    s_lshr_b32 s30, s46, 24
; SI-NEXT:    s_lshr_b32 s31, s46, 16
; SI-NEXT:    s_lshr_b32 s34, s46, 8
; SI-NEXT:    s_lshr_b32 s35, s29, 24
; SI-NEXT:    s_lshr_b32 s36, s29, 16
; SI-NEXT:    s_lshr_b32 s37, s29, 8
; SI-NEXT:    s_lshr_b32 s38, s27, 24
; SI-NEXT:    s_lshr_b32 s39, s27, 16
; SI-NEXT:    s_lshr_b32 s48, s27, 8
; SI-NEXT:    s_lshr_b32 s49, s25, 24
; SI-NEXT:    s_lshr_b32 s50, s25, 16
; SI-NEXT:    s_lshr_b32 s51, s25, 8
; SI-NEXT:    s_lshr_b32 s52, s23, 24
; SI-NEXT:    s_lshr_b32 s53, s23, 16
; SI-NEXT:    s_lshr_b32 s54, s23, 8
; SI-NEXT:    s_lshr_b32 s55, s21, 24
; SI-NEXT:    s_lshr_b32 s64, s21, 16
; SI-NEXT:    s_lshr_b32 s65, s21, 8
; SI-NEXT:    s_lshr_b32 s66, s19, 24
; SI-NEXT:    s_lshr_b32 s67, s19, 16
; SI-NEXT:    s_lshr_b32 s68, s19, 8
; SI-NEXT:    s_lshr_b32 s69, s17, 24
; SI-NEXT:    s_lshr_b32 s70, s17, 16
; SI-NEXT:    s_lshr_b32 s71, s17, 8
; SI-NEXT:    s_cbranch_execnz .LBB13_3
; SI-NEXT:  .LBB13_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s45, s45, 3
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_add_i32 s28, s28, 3
; SI-NEXT:    s_add_i32 s47, s47, 3
; SI-NEXT:    s_add_i32 s44, s44, 3
; SI-NEXT:    s_add_i32 s43, s43, 3
; SI-NEXT:    s_add_i32 s41, s41, 3
; SI-NEXT:    s_add_i32 s15, s15, 3
; SI-NEXT:    s_add_i32 s13, s13, 3
; SI-NEXT:    s_add_i32 s11, s11, 3
; SI-NEXT:    s_add_i32 s9, s9, 3
; SI-NEXT:    s_add_i32 s7, s7, 3
; SI-NEXT:    v_mov_b32_e32 v22, s45
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    s_add_i32 s19, s19, 3
; SI-NEXT:    s_add_i32 s21, s21, 3
; SI-NEXT:    s_add_i32 s23, s23, 3
; SI-NEXT:    s_add_i32 s25, s25, 3
; SI-NEXT:    s_add_i32 s27, s27, 3
; SI-NEXT:    s_add_i32 s29, s29, 3
; SI-NEXT:    s_add_i32 s46, s46, 3
; SI-NEXT:    s_add_i32 s42, s42, 3
; SI-NEXT:    s_add_i32 s40, s40, 3
; SI-NEXT:    s_add_i32 s14, s14, 3
; SI-NEXT:    s_add_i32 s12, s12, 3
; SI-NEXT:    s_add_i32 s10, s10, 3
; SI-NEXT:    s_add_i32 s8, s8, 3
; SI-NEXT:    s_add_i32 s6, s6, 3
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v6, s9
; SI-NEXT:    v_mov_b32_e32 v9, s11
; SI-NEXT:    v_mov_b32_e32 v12, s13
; SI-NEXT:    v_mov_b32_e32 v15, s15
; SI-NEXT:    v_mov_b32_e32 v18, s41
; SI-NEXT:    v_mov_b32_e32 v21, s43
; SI-NEXT:    v_alignbit_b32 v24, s44, v22, 24
; SI-NEXT:    v_alignbit_b32 v25, s44, v22, 16
; SI-NEXT:    v_alignbit_b32 v26, s44, v22, 8
; SI-NEXT:    v_mov_b32_e32 v22, s47
; SI-NEXT:    v_mov_b32_e32 v23, s28
; SI-NEXT:    v_mov_b32_e32 v29, s26
; SI-NEXT:    v_mov_b32_e32 v35, s24
; SI-NEXT:    v_mov_b32_e32 v39, s22
; SI-NEXT:    v_mov_b32_e32 v50, s20
; SI-NEXT:    v_mov_b32_e32 v53, s18
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v40, s16
; SI-NEXT:    v_alignbit_b32 v1, s6, v3, 24
; SI-NEXT:    v_alignbit_b32 v2, s6, v3, 16
; SI-NEXT:    v_alignbit_b32 v3, s6, v3, 8
; SI-NEXT:    v_alignbit_b32 v4, s8, v6, 24
; SI-NEXT:    v_alignbit_b32 v5, s8, v6, 16
; SI-NEXT:    v_alignbit_b32 v6, s8, v6, 8
; SI-NEXT:    v_alignbit_b32 v7, s10, v9, 24
; SI-NEXT:    v_alignbit_b32 v8, s10, v9, 16
; SI-NEXT:    v_alignbit_b32 v9, s10, v9, 8
; SI-NEXT:    v_alignbit_b32 v10, s12, v12, 24
; SI-NEXT:    v_alignbit_b32 v11, s12, v12, 16
; SI-NEXT:    v_alignbit_b32 v12, s12, v12, 8
; SI-NEXT:    v_alignbit_b32 v13, s14, v15, 24
; SI-NEXT:    v_alignbit_b32 v14, s14, v15, 16
; SI-NEXT:    v_alignbit_b32 v15, s14, v15, 8
; SI-NEXT:    v_alignbit_b32 v16, s40, v18, 24
; SI-NEXT:    v_alignbit_b32 v17, s40, v18, 16
; SI-NEXT:    v_alignbit_b32 v18, s40, v18, 8
; SI-NEXT:    v_alignbit_b32 v19, s42, v21, 24
; SI-NEXT:    v_alignbit_b32 v20, s42, v21, 16
; SI-NEXT:    v_alignbit_b32 v21, s42, v21, 8
; SI-NEXT:    v_alignbit_b32 v30, s46, v22, 24
; SI-NEXT:    v_alignbit_b32 v31, s46, v22, 16
; SI-NEXT:    v_alignbit_b32 v32, s46, v22, 8
; SI-NEXT:    v_alignbit_b32 v36, s29, v23, 24
; SI-NEXT:    v_alignbit_b32 v22, s29, v23, 16
; SI-NEXT:    v_alignbit_b32 v23, s29, v23, 8
; SI-NEXT:    v_alignbit_b32 v27, s27, v29, 24
; SI-NEXT:    v_alignbit_b32 v28, s27, v29, 16
; SI-NEXT:    v_alignbit_b32 v29, s27, v29, 8
; SI-NEXT:    v_alignbit_b32 v33, s25, v35, 24
; SI-NEXT:    v_alignbit_b32 v34, s25, v35, 16
; SI-NEXT:    v_alignbit_b32 v35, s25, v35, 8
; SI-NEXT:    v_alignbit_b32 v37, s23, v39, 24
; SI-NEXT:    v_alignbit_b32 v38, s23, v39, 16
; SI-NEXT:    v_alignbit_b32 v39, s23, v39, 8
; SI-NEXT:    v_alignbit_b32 v48, s21, v50, 24
; SI-NEXT:    v_alignbit_b32 v49, s21, v50, 16
; SI-NEXT:    v_alignbit_b32 v50, s21, v50, 8
; SI-NEXT:    v_alignbit_b32 v51, s19, v53, 24
; SI-NEXT:    v_alignbit_b32 v52, s19, v53, 16
; SI-NEXT:    v_alignbit_b32 v53, s19, v53, 8
; SI-NEXT:    v_alignbit_b32 v54, s17, v40, 24
; SI-NEXT:    v_alignbit_b32 v55, s17, v40, 16
; SI-NEXT:    v_alignbit_b32 v40, s17, v40, 8
; SI-NEXT:    s_lshr_b32 s56, s6, 24
; SI-NEXT:    s_lshr_b32 s57, s6, 16
; SI-NEXT:    s_lshr_b32 s58, s6, 8
; SI-NEXT:    s_lshr_b32 s59, s8, 24
; SI-NEXT:    s_lshr_b32 s60, s8, 16
; SI-NEXT:    s_lshr_b32 s61, s8, 8
; SI-NEXT:    s_lshr_b32 s62, s10, 24
; SI-NEXT:    s_lshr_b32 s63, s10, 16
; SI-NEXT:    s_lshr_b32 s72, s10, 8
; SI-NEXT:    s_lshr_b32 s73, s12, 24
; SI-NEXT:    s_lshr_b32 s74, s12, 16
; SI-NEXT:    s_lshr_b32 s75, s12, 8
; SI-NEXT:    s_lshr_b32 s76, s14, 24
; SI-NEXT:    s_lshr_b32 s77, s14, 16
; SI-NEXT:    s_lshr_b32 s78, s14, 8
; SI-NEXT:    s_lshr_b32 s79, s40, 24
; SI-NEXT:    s_lshr_b32 s88, s40, 16
; SI-NEXT:    s_lshr_b32 s89, s40, 8
; SI-NEXT:    s_lshr_b32 s90, s42, 24
; SI-NEXT:    s_lshr_b32 s91, s42, 16
; SI-NEXT:    s_lshr_b32 s92, s42, 8
; SI-NEXT:    s_lshr_b32 s93, s44, 24
; SI-NEXT:    s_lshr_b32 s94, s44, 16
; SI-NEXT:    s_lshr_b32 s95, s44, 8
; SI-NEXT:    s_lshr_b32 s30, s46, 24
; SI-NEXT:    s_lshr_b32 s31, s46, 16
; SI-NEXT:    s_lshr_b32 s34, s46, 8
; SI-NEXT:    s_lshr_b32 s35, s29, 24
; SI-NEXT:    s_lshr_b32 s36, s29, 16
; SI-NEXT:    s_lshr_b32 s37, s29, 8
; SI-NEXT:    s_lshr_b32 s38, s27, 24
; SI-NEXT:    s_lshr_b32 s39, s27, 16
; SI-NEXT:    s_lshr_b32 s48, s27, 8
; SI-NEXT:    s_lshr_b32 s49, s25, 24
; SI-NEXT:    s_lshr_b32 s50, s25, 16
; SI-NEXT:    s_lshr_b32 s51, s25, 8
; SI-NEXT:    s_lshr_b32 s52, s23, 24
; SI-NEXT:    s_lshr_b32 s53, s23, 16
; SI-NEXT:    s_lshr_b32 s54, s23, 8
; SI-NEXT:    s_lshr_b32 s55, s21, 24
; SI-NEXT:    s_lshr_b32 s64, s21, 16
; SI-NEXT:    s_lshr_b32 s65, s21, 8
; SI-NEXT:    s_lshr_b32 s66, s19, 24
; SI-NEXT:    s_lshr_b32 s67, s19, 16
; SI-NEXT:    s_lshr_b32 s68, s19, 8
; SI-NEXT:    s_lshr_b32 s69, s17, 24
; SI-NEXT:    s_lshr_b32 s70, s17, 16
; SI-NEXT:    s_lshr_b32 s71, s17, 8
; SI-NEXT:  .LBB13_3: ; %end
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v40, 8, v40
; SI-NEXT:    v_or_b32_e32 v40, s4, v40
; SI-NEXT:    s_and_b32 s4, s17, 0xff
; SI-NEXT:    s_lshl_b32 s5, s71, 8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s70, 0xff
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s16, s69, 24
; SI-NEXT:    v_and_b32_e32 v55, 0xff, v55
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s16, s5
; SI-NEXT:    v_lshlrev_b32_e32 v55, 16, v55
; SI-NEXT:    v_lshlrev_b32_e32 v54, 24, v54
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    v_or_b32_e32 v54, v54, v55
; SI-NEXT:    v_mov_b32_e32 v55, s4
; SI-NEXT:    s_and_b32 s4, s18, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v53, 8, v53
; SI-NEXT:    v_or_b32_e32 v53, s4, v53
; SI-NEXT:    s_and_b32 s4, s19, 0xff
; SI-NEXT:    s_lshl_b32 s5, s68, 8
; SI-NEXT:    v_and_b32_e32 v52, 0xff, v52
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s67, 0xff
; SI-NEXT:    v_and_b32_e32 v40, 0xffff, v40
; SI-NEXT:    v_lshlrev_b32_e32 v52, 16, v52
; SI-NEXT:    v_lshlrev_b32_e32 v51, 24, v51
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s16, s66, 24
; SI-NEXT:    v_or_b32_e32 v54, v40, v54
; SI-NEXT:    v_and_b32_e32 v53, 0xffff, v53
; SI-NEXT:    v_or_b32_e32 v51, v51, v52
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s16, s5
; SI-NEXT:    buffer_store_dword v54, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v54, vcc, 4, v0
; SI-NEXT:    v_or_b32_e32 v51, v53, v51
; SI-NEXT:    v_add_i32_e32 v52, vcc, 8, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v55, v54, s[0:3], 0 offen
; SI-NEXT:    buffer_store_dword v51, v52, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v52, s4
; SI-NEXT:    s_and_b32 s4, s20, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v50, 8, v50
; SI-NEXT:    v_or_b32_e32 v50, s4, v50
; SI-NEXT:    s_and_b32 s4, s21, 0xff
; SI-NEXT:    s_lshl_b32 s5, s65, 8
; SI-NEXT:    v_and_b32_e32 v49, 0xff, v49
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s64, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v49, 16, v49
; SI-NEXT:    v_lshlrev_b32_e32 v48, 24, v48
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s16, s55, 24
; SI-NEXT:    v_and_b32_e32 v50, 0xffff, v50
; SI-NEXT:    v_or_b32_e32 v48, v48, v49
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s16, s5
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v51, vcc, 12, v0
; SI-NEXT:    v_or_b32_e32 v48, v50, v48
; SI-NEXT:    v_add_i32_e32 v49, vcc, 16, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v52, v51, s[0:3], 0 offen
; SI-NEXT:    buffer_store_dword v48, v49, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v49, s4
; SI-NEXT:    s_and_b32 s4, s22, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v39, 8, v39
; SI-NEXT:    v_or_b32_e32 v39, s4, v39
; SI-NEXT:    s_and_b32 s4, s23, 0xff
; SI-NEXT:    s_lshl_b32 s5, s54, 8
; SI-NEXT:    v_and_b32_e32 v38, 0xff, v38
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s53, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v38, 16, v38
; SI-NEXT:    v_lshlrev_b32_e32 v37, 24, v37
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s16, s52, 24
; SI-NEXT:    v_and_b32_e32 v39, 0xffff, v39
; SI-NEXT:    v_or_b32_e32 v37, v37, v38
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s16, s5
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v48, vcc, 20, v0
; SI-NEXT:    v_or_b32_e32 v37, v39, v37
; SI-NEXT:    v_add_i32_e32 v38, vcc, 24, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v49, v48, s[0:3], 0 offen
; SI-NEXT:    buffer_store_dword v37, v38, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v38, s4
; SI-NEXT:    s_and_b32 s4, s24, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v35, 8, v35
; SI-NEXT:    v_or_b32_e32 v35, s4, v35
; SI-NEXT:    s_and_b32 s4, s25, 0xff
; SI-NEXT:    s_lshl_b32 s5, s51, 8
; SI-NEXT:    v_and_b32_e32 v34, 0xff, v34
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s50, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v34, 16, v34
; SI-NEXT:    v_lshlrev_b32_e32 v33, 24, v33
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s16, s49, 24
; SI-NEXT:    v_and_b32_e32 v35, 0xffff, v35
; SI-NEXT:    v_or_b32_e32 v33, v33, v34
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s16, s5
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v37, vcc, 28, v0
; SI-NEXT:    v_or_b32_e32 v33, v35, v33
; SI-NEXT:    v_add_i32_e32 v34, vcc, 32, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v38, v37, s[0:3], 0 offen
; SI-NEXT:    buffer_store_dword v33, v34, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v34, s4
; SI-NEXT:    s_and_b32 s4, s26, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v29, 8, v29
; SI-NEXT:    v_or_b32_e32 v29, s4, v29
; SI-NEXT:    s_and_b32 s4, s27, 0xff
; SI-NEXT:    s_lshl_b32 s5, s48, 8
; SI-NEXT:    v_and_b32_e32 v28, 0xff, v28
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s39, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v28, 16, v28
; SI-NEXT:    v_lshlrev_b32_e32 v27, 24, v27
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s16, s38, 24
; SI-NEXT:    v_and_b32_e32 v29, 0xffff, v29
; SI-NEXT:    v_or_b32_e32 v27, v27, v28
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s16, s5
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v33, vcc, 36, v0
; SI-NEXT:    v_or_b32_e32 v27, v29, v27
; SI-NEXT:    v_add_i32_e32 v28, vcc, 40, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v34, v33, s[0:3], 0 offen
; SI-NEXT:    buffer_store_dword v27, v28, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v28, s4
; SI-NEXT:    s_and_b32 s4, s28, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v23, 8, v23
; SI-NEXT:    v_or_b32_e32 v23, s4, v23
; SI-NEXT:    s_and_b32 s4, s29, 0xff
; SI-NEXT:    s_lshl_b32 s5, s37, 8
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v27, vcc, 44, v0
; SI-NEXT:    v_and_b32_e32 v22, 0xff, v22
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s36, 0xff
; SI-NEXT:    buffer_store_dword v28, v27, s[0:3], 0 offen
; SI-NEXT:    v_lshlrev_b32_e32 v22, 16, v22
; SI-NEXT:    v_lshlrev_b32_e32 v27, 24, v36
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s16, s35, 24
; SI-NEXT:    v_and_b32_e32 v23, 0xffff, v23
; SI-NEXT:    v_or_b32_e32 v22, v27, v22
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s16, s5
; SI-NEXT:    v_or_b32_e32 v22, v23, v22
; SI-NEXT:    v_add_i32_e32 v23, vcc, 48, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v22, v23, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v22, vcc, 52, v0
; SI-NEXT:    v_mov_b32_e32 v23, s4
; SI-NEXT:    buffer_store_dword v23, v22, s[0:3], 0 offen
; SI-NEXT:    s_and_b32 s4, s47, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v22, 8, v32
; SI-NEXT:    v_or_b32_e32 v22, s4, v22
; SI-NEXT:    s_and_b32 s4, s46, 0xff
; SI-NEXT:    s_lshl_b32 s5, s34, 8
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v23, 0xff, v31
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s31, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; SI-NEXT:    v_lshlrev_b32_e32 v27, 24, v30
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s16, s30, 24
; SI-NEXT:    v_and_b32_e32 v22, 0xffff, v22
; SI-NEXT:    v_or_b32_e32 v23, v27, v23
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s16, s5
; SI-NEXT:    v_or_b32_e32 v22, v22, v23
; SI-NEXT:    v_add_i32_e32 v23, vcc, 56, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v22, v23, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v22, vcc, 60, v0
; SI-NEXT:    v_mov_b32_e32 v23, s4
; SI-NEXT:    buffer_store_dword v23, v22, s[0:3], 0 offen
; SI-NEXT:    s_and_b32 s4, s45, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v22, 8, v26
; SI-NEXT:    v_or_b32_e32 v22, s4, v22
; SI-NEXT:    s_and_b32 s4, s44, 0xff
; SI-NEXT:    s_lshl_b32 s5, s95, 8
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v23, 0xff, v25
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s94, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; SI-NEXT:    v_lshlrev_b32_e32 v24, 24, v24
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s16, s93, 24
; SI-NEXT:    v_and_b32_e32 v22, 0xffff, v22
; SI-NEXT:    v_or_b32_e32 v23, v24, v23
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s16, s5
; SI-NEXT:    v_or_b32_e32 v22, v22, v23
; SI-NEXT:    v_add_i32_e32 v23, vcc, 64, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v22, v23, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v23, s4
; SI-NEXT:    s_and_b32 s4, s43, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v21, 8, v21
; SI-NEXT:    v_or_b32_e32 v21, s4, v21
; SI-NEXT:    s_and_b32 s4, s42, 0xff
; SI-NEXT:    s_lshl_b32 s5, s92, 8
; SI-NEXT:    v_and_b32_e32 v20, 0xff, v20
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s91, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v20, 16, v20
; SI-NEXT:    v_lshlrev_b32_e32 v19, 24, v19
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s16, s90, 24
; SI-NEXT:    v_and_b32_e32 v21, 0xffff, v21
; SI-NEXT:    v_or_b32_e32 v19, v19, v20
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s16, s5
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v22, vcc, 0x44, v0
; SI-NEXT:    v_or_b32_e32 v19, v21, v19
; SI-NEXT:    v_add_i32_e32 v20, vcc, 0x48, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v23, v22, s[0:3], 0 offen
; SI-NEXT:    buffer_store_dword v19, v20, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v20, s4
; SI-NEXT:    s_and_b32 s4, s41, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v18, 8, v18
; SI-NEXT:    v_or_b32_e32 v18, s4, v18
; SI-NEXT:    s_and_b32 s4, s40, 0xff
; SI-NEXT:    s_lshl_b32 s5, s89, 8
; SI-NEXT:    v_and_b32_e32 v17, 0xff, v17
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s88, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; SI-NEXT:    v_lshlrev_b32_e32 v16, 24, v16
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s16, s79, 24
; SI-NEXT:    v_and_b32_e32 v18, 0xffff, v18
; SI-NEXT:    v_or_b32_e32 v16, v16, v17
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s16, s5
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v19, vcc, 0x4c, v0
; SI-NEXT:    v_or_b32_e32 v16, v18, v16
; SI-NEXT:    v_add_i32_e32 v17, vcc, 0x50, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v20, v19, s[0:3], 0 offen
; SI-NEXT:    buffer_store_dword v16, v17, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v17, s4
; SI-NEXT:    s_and_b32 s4, s15, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v15, 8, v15
; SI-NEXT:    v_or_b32_e32 v15, s4, v15
; SI-NEXT:    s_and_b32 s4, s14, 0xff
; SI-NEXT:    s_lshl_b32 s5, s78, 8
; SI-NEXT:    v_and_b32_e32 v14, 0xff, v14
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s77, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; SI-NEXT:    v_lshlrev_b32_e32 v13, 24, v13
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s14, s76, 24
; SI-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; SI-NEXT:    v_or_b32_e32 v13, v13, v14
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s14, s5
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v16, vcc, 0x54, v0
; SI-NEXT:    v_or_b32_e32 v13, v15, v13
; SI-NEXT:    v_add_i32_e32 v14, vcc, 0x58, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v17, v16, s[0:3], 0 offen
; SI-NEXT:    buffer_store_dword v13, v14, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v14, s4
; SI-NEXT:    s_and_b32 s4, s13, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v12, 8, v12
; SI-NEXT:    v_or_b32_e32 v12, s4, v12
; SI-NEXT:    s_and_b32 s4, s12, 0xff
; SI-NEXT:    s_lshl_b32 s5, s75, 8
; SI-NEXT:    v_and_b32_e32 v11, 0xff, v11
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s74, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v10, 24, v10
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s12, s73, 24
; SI-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; SI-NEXT:    v_or_b32_e32 v10, v10, v11
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s12, s5
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v13, vcc, 0x5c, v0
; SI-NEXT:    v_or_b32_e32 v10, v12, v10
; SI-NEXT:    v_add_i32_e32 v11, vcc, 0x60, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v14, v13, s[0:3], 0 offen
; SI-NEXT:    buffer_store_dword v10, v11, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v11, s4
; SI-NEXT:    s_and_b32 s4, s11, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v9, 8, v9
; SI-NEXT:    v_or_b32_e32 v9, s4, v9
; SI-NEXT:    s_and_b32 s4, s10, 0xff
; SI-NEXT:    s_lshl_b32 s5, s72, 8
; SI-NEXT:    v_and_b32_e32 v8, 0xff, v8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s63, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s10, s62, 24
; SI-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; SI-NEXT:    v_or_b32_e32 v7, v7, v8
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s10, s5
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v10, vcc, 0x64, v0
; SI-NEXT:    v_or_b32_e32 v7, v9, v7
; SI-NEXT:    v_add_i32_e32 v8, vcc, 0x68, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v11, v10, s[0:3], 0 offen
; SI-NEXT:    buffer_store_dword v7, v8, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v8, s4
; SI-NEXT:    s_and_b32 s4, s9, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v6, 8, v6
; SI-NEXT:    v_or_b32_e32 v6, s4, v6
; SI-NEXT:    s_and_b32 s4, s8, 0xff
; SI-NEXT:    s_lshl_b32 s5, s61, 8
; SI-NEXT:    v_and_b32_e32 v5, 0xff, v5
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s60, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s8, s59, 24
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; SI-NEXT:    v_or_b32_e32 v4, v4, v5
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s8, s5
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x6c, v0
; SI-NEXT:    v_or_b32_e32 v4, v6, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, 0x70, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v8, v7, s[0:3], 0 offen
; SI-NEXT:    buffer_store_dword v4, v5, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v5, s4
; SI-NEXT:    s_and_b32 s4, s7, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; SI-NEXT:    v_or_b32_e32 v3, s4, v3
; SI-NEXT:    s_and_b32 s4, s6, 0xff
; SI-NEXT:    s_lshl_b32 s5, s58, 8
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s57, 0xff
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s6, s56, 24
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v4, vcc, 0x74, v0
; SI-NEXT:    v_or_b32_e32 v1, v3, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x78, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v5, v4, s[0:3], 0 offen
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x7c, v0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s4
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    v_readlane_b32 s71, v41, 23
; SI-NEXT:    v_readlane_b32 s70, v41, 22
; SI-NEXT:    v_readlane_b32 s69, v41, 21
; SI-NEXT:    v_readlane_b32 s68, v41, 20
; SI-NEXT:    v_readlane_b32 s67, v41, 19
; SI-NEXT:    v_readlane_b32 s66, v41, 18
; SI-NEXT:    v_readlane_b32 s65, v41, 17
; SI-NEXT:    v_readlane_b32 s64, v41, 16
; SI-NEXT:    v_readlane_b32 s55, v41, 15
; SI-NEXT:    v_readlane_b32 s54, v41, 14
; SI-NEXT:    v_readlane_b32 s53, v41, 13
; SI-NEXT:    v_readlane_b32 s52, v41, 12
; SI-NEXT:    v_readlane_b32 s51, v41, 11
; SI-NEXT:    v_readlane_b32 s50, v41, 10
; SI-NEXT:    v_readlane_b32 s49, v41, 9
; SI-NEXT:    v_readlane_b32 s48, v41, 8
; SI-NEXT:    v_readlane_b32 s39, v41, 7
; SI-NEXT:    v_readlane_b32 s38, v41, 6
; SI-NEXT:    v_readlane_b32 s37, v41, 5
; SI-NEXT:    v_readlane_b32 s36, v41, 4
; SI-NEXT:    v_readlane_b32 s35, v41, 3
; SI-NEXT:    v_readlane_b32 s34, v41, 2
; SI-NEXT:    v_readlane_b32 s31, v41, 1
; SI-NEXT:    v_readlane_b32 s30, v41, 0
; SI-NEXT:    s_or_saveexec_b64 s[4:5], -1
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b64 exec, s[4:5]
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB13_4:
; SI-NEXT:    ; implicit-def: $vgpr40
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $sgpr71
; SI-NEXT:    ; implicit-def: $sgpr70
; SI-NEXT:    ; implicit-def: $sgpr69
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $sgpr68
; SI-NEXT:    ; implicit-def: $sgpr67
; SI-NEXT:    ; implicit-def: $sgpr66
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $sgpr65
; SI-NEXT:    ; implicit-def: $sgpr64
; SI-NEXT:    ; implicit-def: $sgpr55
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $sgpr54
; SI-NEXT:    ; implicit-def: $sgpr53
; SI-NEXT:    ; implicit-def: $sgpr52
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $sgpr51
; SI-NEXT:    ; implicit-def: $sgpr50
; SI-NEXT:    ; implicit-def: $sgpr49
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $sgpr48
; SI-NEXT:    ; implicit-def: $sgpr39
; SI-NEXT:    ; implicit-def: $sgpr38
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $sgpr37
; SI-NEXT:    ; implicit-def: $sgpr36
; SI-NEXT:    ; implicit-def: $sgpr35
; SI-NEXT:    ; implicit-def: $sgpr34
; SI-NEXT:    ; implicit-def: $sgpr31
; SI-NEXT:    ; implicit-def: $sgpr30
; SI-NEXT:    ; implicit-def: $sgpr95
; SI-NEXT:    ; implicit-def: $sgpr94
; SI-NEXT:    ; implicit-def: $sgpr93
; SI-NEXT:    ; implicit-def: $sgpr92
; SI-NEXT:    ; implicit-def: $sgpr91
; SI-NEXT:    ; implicit-def: $sgpr90
; SI-NEXT:    ; implicit-def: $sgpr89
; SI-NEXT:    ; implicit-def: $sgpr88
; SI-NEXT:    ; implicit-def: $sgpr79
; SI-NEXT:    ; implicit-def: $sgpr78
; SI-NEXT:    ; implicit-def: $sgpr77
; SI-NEXT:    ; implicit-def: $sgpr76
; SI-NEXT:    ; implicit-def: $sgpr75
; SI-NEXT:    ; implicit-def: $sgpr74
; SI-NEXT:    ; implicit-def: $sgpr73
; SI-NEXT:    ; implicit-def: $sgpr72
; SI-NEXT:    ; implicit-def: $sgpr63
; SI-NEXT:    ; implicit-def: $sgpr62
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $sgpr61
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $sgpr60
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $sgpr59
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $sgpr58
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $sgpr57
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $sgpr56
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    s_branch .LBB13_2
;
; VI-LABEL: bitcast_v32i32_to_v128i8_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; VI-NEXT:    buffer_store_dword v20, off, s[0:3], s32 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v21, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; VI-NEXT:    s_mov_b64 exec, s[4:5]
; VI-NEXT:    v_writelane_b32 v20, s30, 0
; VI-NEXT:    v_writelane_b32 v20, s31, 1
; VI-NEXT:    v_writelane_b32 v20, s34, 2
; VI-NEXT:    v_writelane_b32 v20, s35, 3
; VI-NEXT:    v_writelane_b32 v20, s36, 4
; VI-NEXT:    v_writelane_b32 v20, s37, 5
; VI-NEXT:    v_writelane_b32 v20, s38, 6
; VI-NEXT:    v_writelane_b32 v20, s39, 7
; VI-NEXT:    v_writelane_b32 v20, s48, 8
; VI-NEXT:    v_writelane_b32 v20, s49, 9
; VI-NEXT:    v_writelane_b32 v20, s50, 10
; VI-NEXT:    v_writelane_b32 v20, s51, 11
; VI-NEXT:    v_writelane_b32 v20, s52, 12
; VI-NEXT:    v_writelane_b32 v20, s53, 13
; VI-NEXT:    v_writelane_b32 v20, s54, 14
; VI-NEXT:    v_writelane_b32 v20, s55, 15
; VI-NEXT:    v_writelane_b32 v20, s64, 16
; VI-NEXT:    v_writelane_b32 v20, s65, 17
; VI-NEXT:    v_writelane_b32 v20, s66, 18
; VI-NEXT:    v_writelane_b32 v20, s67, 19
; VI-NEXT:    v_writelane_b32 v20, s68, 20
; VI-NEXT:    v_writelane_b32 v20, s69, 21
; VI-NEXT:    v_writelane_b32 v20, s70, 22
; VI-NEXT:    v_writelane_b32 v20, s71, 23
; VI-NEXT:    v_writelane_b32 v20, s80, 24
; VI-NEXT:    v_writelane_b32 v20, s81, 25
; VI-NEXT:    v_writelane_b32 v20, s82, 26
; VI-NEXT:    v_writelane_b32 v20, s83, 27
; VI-NEXT:    v_writelane_b32 v20, s84, 28
; VI-NEXT:    v_writelane_b32 v20, s85, 29
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v19
; VI-NEXT:    v_writelane_b32 v20, s86, 30
; VI-NEXT:    v_readfirstlane_b32 s44, v1
; VI-NEXT:    v_readfirstlane_b32 s45, v2
; VI-NEXT:    v_readfirstlane_b32 s42, v3
; VI-NEXT:    v_readfirstlane_b32 s43, v4
; VI-NEXT:    v_readfirstlane_b32 s40, v5
; VI-NEXT:    v_readfirstlane_b32 s41, v6
; VI-NEXT:    v_readfirstlane_b32 s14, v7
; VI-NEXT:    v_readfirstlane_b32 s15, v8
; VI-NEXT:    v_readfirstlane_b32 s12, v9
; VI-NEXT:    v_readfirstlane_b32 s13, v10
; VI-NEXT:    v_readfirstlane_b32 s10, v11
; VI-NEXT:    v_readfirstlane_b32 s11, v12
; VI-NEXT:    v_readfirstlane_b32 s8, v13
; VI-NEXT:    v_readfirstlane_b32 s9, v14
; VI-NEXT:    v_readfirstlane_b32 s6, v15
; VI-NEXT:    v_readfirstlane_b32 s7, v16
; VI-NEXT:    v_readfirstlane_b32 s4, v17
; VI-NEXT:    s_and_b64 s[46:47], vcc, exec
; VI-NEXT:    v_readfirstlane_b32 s5, v18
; VI-NEXT:    v_writelane_b32 v20, s87, 31
; VI-NEXT:    ; implicit-def: $vgpr21 : SGPR spill to VGPR lane
; VI-NEXT:    s_cbranch_scc0 .LBB13_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_lshr_b32 s46, s5, 24
; VI-NEXT:    v_writelane_b32 v21, s46, 8
; VI-NEXT:    s_lshr_b32 s46, s5, 16
; VI-NEXT:    v_writelane_b32 v21, s46, 9
; VI-NEXT:    s_lshr_b32 s46, s5, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 10
; VI-NEXT:    s_lshr_b32 s46, s4, 16
; VI-NEXT:    v_writelane_b32 v21, s46, 11
; VI-NEXT:    s_lshr_b32 s46, s4, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 12
; VI-NEXT:    s_lshr_b32 s46, s7, 24
; VI-NEXT:    v_writelane_b32 v21, s46, 13
; VI-NEXT:    s_lshr_b32 s46, s7, 16
; VI-NEXT:    v_writelane_b32 v21, s46, 14
; VI-NEXT:    s_lshr_b32 s46, s7, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 15
; VI-NEXT:    s_lshr_b32 s46, s6, 16
; VI-NEXT:    v_writelane_b32 v21, s46, 16
; VI-NEXT:    s_lshr_b32 s46, s6, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 17
; VI-NEXT:    s_lshr_b32 s46, s9, 24
; VI-NEXT:    v_writelane_b32 v21, s46, 18
; VI-NEXT:    s_lshr_b32 s46, s9, 16
; VI-NEXT:    v_writelane_b32 v21, s46, 19
; VI-NEXT:    s_lshr_b32 s46, s9, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 20
; VI-NEXT:    s_lshr_b32 s46, s8, 16
; VI-NEXT:    v_writelane_b32 v21, s46, 21
; VI-NEXT:    s_lshr_b32 s46, s8, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 22
; VI-NEXT:    s_lshr_b32 s46, s11, 24
; VI-NEXT:    v_writelane_b32 v21, s46, 23
; VI-NEXT:    s_lshr_b32 s46, s11, 16
; VI-NEXT:    v_writelane_b32 v21, s46, 24
; VI-NEXT:    s_lshr_b32 s46, s11, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 25
; VI-NEXT:    s_lshr_b32 s46, s10, 16
; VI-NEXT:    v_writelane_b32 v21, s46, 26
; VI-NEXT:    s_lshr_b32 s46, s10, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 27
; VI-NEXT:    s_lshr_b32 s46, s13, 24
; VI-NEXT:    v_writelane_b32 v21, s46, 28
; VI-NEXT:    s_lshr_b32 s46, s13, 16
; VI-NEXT:    v_writelane_b32 v21, s46, 29
; VI-NEXT:    s_lshr_b32 s46, s13, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 30
; VI-NEXT:    s_lshr_b32 s46, s12, 16
; VI-NEXT:    v_writelane_b32 v21, s46, 31
; VI-NEXT:    s_lshr_b32 s46, s12, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 32
; VI-NEXT:    s_lshr_b32 s46, s15, 24
; VI-NEXT:    v_writelane_b32 v21, s46, 33
; VI-NEXT:    s_lshr_b32 s46, s15, 16
; VI-NEXT:    v_writelane_b32 v21, s46, 34
; VI-NEXT:    s_lshr_b32 s46, s15, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 35
; VI-NEXT:    s_lshr_b32 s46, s14, 16
; VI-NEXT:    v_writelane_b32 v21, s46, 36
; VI-NEXT:    s_lshr_b32 s46, s14, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 37
; VI-NEXT:    s_lshr_b32 s46, s41, 24
; VI-NEXT:    v_writelane_b32 v21, s46, 38
; VI-NEXT:    s_lshr_b32 s46, s41, 16
; VI-NEXT:    v_writelane_b32 v21, s46, 39
; VI-NEXT:    s_lshr_b32 s46, s41, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 40
; VI-NEXT:    s_lshr_b32 s46, s40, 16
; VI-NEXT:    v_writelane_b32 v21, s46, 41
; VI-NEXT:    s_lshr_b32 s46, s40, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 42
; VI-NEXT:    s_lshr_b32 s46, s43, 24
; VI-NEXT:    v_writelane_b32 v21, s46, 43
; VI-NEXT:    s_lshr_b32 s46, s43, 16
; VI-NEXT:    v_writelane_b32 v21, s46, 44
; VI-NEXT:    s_lshr_b32 s46, s43, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 45
; VI-NEXT:    s_lshr_b32 s46, s42, 16
; VI-NEXT:    v_writelane_b32 v21, s46, 46
; VI-NEXT:    s_lshr_b32 s46, s42, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 47
; VI-NEXT:    s_lshr_b32 s46, s45, 24
; VI-NEXT:    v_writelane_b32 v21, s46, 48
; VI-NEXT:    s_lshr_b32 s46, s45, 16
; VI-NEXT:    v_writelane_b32 v21, s46, 49
; VI-NEXT:    s_lshr_b32 s46, s45, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 50
; VI-NEXT:    s_lshr_b32 s46, s44, 16
; VI-NEXT:    v_writelane_b32 v21, s46, 51
; VI-NEXT:    s_lshr_b32 s46, s44, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 52
; VI-NEXT:    s_lshr_b32 s46, s29, 24
; VI-NEXT:    v_writelane_b32 v21, s46, 53
; VI-NEXT:    s_lshr_b32 s46, s29, 16
; VI-NEXT:    v_writelane_b32 v21, s46, 54
; VI-NEXT:    s_lshr_b32 s46, s29, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 55
; VI-NEXT:    s_lshr_b32 s46, s28, 16
; VI-NEXT:    v_writelane_b32 v21, s46, 56
; VI-NEXT:    s_lshr_b32 s46, s28, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 57
; VI-NEXT:    s_lshr_b32 s46, s27, 24
; VI-NEXT:    v_writelane_b32 v21, s46, 58
; VI-NEXT:    s_lshr_b32 s46, s27, 16
; VI-NEXT:    v_writelane_b32 v21, s46, 59
; VI-NEXT:    s_lshr_b64 s[60:61], s[4:5], 24
; VI-NEXT:    v_writelane_b32 v21, s60, 6
; VI-NEXT:    v_writelane_b32 v21, s61, 7
; VI-NEXT:    s_lshr_b64 s[60:61], s[6:7], 24
; VI-NEXT:    v_writelane_b32 v21, s60, 4
; VI-NEXT:    v_writelane_b32 v21, s61, 5
; VI-NEXT:    s_lshr_b64 s[60:61], s[8:9], 24
; VI-NEXT:    v_writelane_b32 v21, s60, 2
; VI-NEXT:    v_writelane_b32 v21, s61, 3
; VI-NEXT:    s_lshr_b64 s[60:61], s[10:11], 24
; VI-NEXT:    v_writelane_b32 v21, s60, 0
; VI-NEXT:    s_lshr_b32 s66, s27, 8
; VI-NEXT:    s_lshr_b32 s67, s26, 16
; VI-NEXT:    s_lshr_b32 s68, s26, 8
; VI-NEXT:    s_lshr_b32 s69, s25, 24
; VI-NEXT:    s_lshr_b32 s70, s25, 16
; VI-NEXT:    s_lshr_b32 s71, s25, 8
; VI-NEXT:    s_lshr_b32 s80, s24, 16
; VI-NEXT:    s_lshr_b32 s81, s24, 8
; VI-NEXT:    s_lshr_b32 s82, s23, 24
; VI-NEXT:    s_lshr_b32 s83, s23, 16
; VI-NEXT:    s_lshr_b32 s84, s23, 8
; VI-NEXT:    s_lshr_b32 s85, s22, 16
; VI-NEXT:    s_lshr_b32 s86, s22, 8
; VI-NEXT:    s_lshr_b32 s87, s21, 24
; VI-NEXT:    s_lshr_b32 s50, s21, 16
; VI-NEXT:    s_lshr_b32 s46, s21, 8
; VI-NEXT:    s_lshr_b32 s47, s20, 16
; VI-NEXT:    s_lshr_b32 s56, s20, 8
; VI-NEXT:    s_lshr_b32 s57, s19, 24
; VI-NEXT:    s_lshr_b32 s51, s19, 16
; VI-NEXT:    s_lshr_b32 s52, s19, 8
; VI-NEXT:    s_lshr_b32 s53, s18, 16
; VI-NEXT:    s_lshr_b32 s54, s18, 8
; VI-NEXT:    s_lshr_b32 s58, s17, 24
; VI-NEXT:    s_lshr_b32 s59, s17, 16
; VI-NEXT:    s_lshr_b32 s55, s17, 8
; VI-NEXT:    s_lshr_b32 s64, s16, 16
; VI-NEXT:    s_lshr_b32 s65, s16, 8
; VI-NEXT:    v_writelane_b32 v21, s61, 1
; VI-NEXT:    s_lshr_b64 s[62:63], s[12:13], 24
; VI-NEXT:    s_lshr_b64 s[72:73], s[14:15], 24
; VI-NEXT:    s_lshr_b64 s[74:75], s[40:41], 24
; VI-NEXT:    s_lshr_b64 s[76:77], s[42:43], 24
; VI-NEXT:    s_lshr_b64 s[78:79], s[44:45], 24
; VI-NEXT:    s_lshr_b64 s[88:89], s[28:29], 24
; VI-NEXT:    s_lshr_b64 s[90:91], s[26:27], 24
; VI-NEXT:    s_lshr_b64 s[30:31], s[24:25], 24
; VI-NEXT:    s_lshr_b64 s[34:35], s[22:23], 24
; VI-NEXT:    s_lshr_b64 s[36:37], s[20:21], 24
; VI-NEXT:    s_lshr_b64 s[38:39], s[18:19], 24
; VI-NEXT:    s_lshr_b64 s[48:49], s[16:17], 24
; VI-NEXT:    s_cbranch_execnz .LBB13_3
; VI-NEXT:  .LBB13_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s5, s5, 3
; VI-NEXT:    s_lshr_b32 s46, s5, 24
; VI-NEXT:    v_writelane_b32 v21, s46, 8
; VI-NEXT:    s_lshr_b32 s46, s5, 16
; VI-NEXT:    s_add_i32 s4, s4, 3
; VI-NEXT:    v_writelane_b32 v21, s46, 9
; VI-NEXT:    s_lshr_b32 s46, s5, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 10
; VI-NEXT:    s_lshr_b32 s46, s4, 16
; VI-NEXT:    s_add_i32 s7, s7, 3
; VI-NEXT:    v_writelane_b32 v21, s46, 11
; VI-NEXT:    s_lshr_b32 s46, s4, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 12
; VI-NEXT:    s_lshr_b32 s46, s7, 24
; VI-NEXT:    v_writelane_b32 v21, s46, 13
; VI-NEXT:    s_lshr_b32 s46, s7, 16
; VI-NEXT:    s_add_i32 s6, s6, 3
; VI-NEXT:    v_writelane_b32 v21, s46, 14
; VI-NEXT:    s_lshr_b32 s46, s7, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 15
; VI-NEXT:    s_lshr_b32 s46, s6, 16
; VI-NEXT:    s_add_i32 s9, s9, 3
; VI-NEXT:    v_writelane_b32 v21, s46, 16
; VI-NEXT:    s_lshr_b32 s46, s6, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 17
; VI-NEXT:    s_lshr_b32 s46, s9, 24
; VI-NEXT:    v_writelane_b32 v21, s46, 18
; VI-NEXT:    s_lshr_b32 s46, s9, 16
; VI-NEXT:    s_add_i32 s8, s8, 3
; VI-NEXT:    v_writelane_b32 v21, s46, 19
; VI-NEXT:    s_lshr_b32 s46, s9, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 20
; VI-NEXT:    s_lshr_b32 s46, s8, 16
; VI-NEXT:    s_add_i32 s11, s11, 3
; VI-NEXT:    v_writelane_b32 v21, s46, 21
; VI-NEXT:    s_lshr_b32 s46, s8, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 22
; VI-NEXT:    s_lshr_b32 s46, s11, 24
; VI-NEXT:    v_writelane_b32 v21, s46, 23
; VI-NEXT:    s_lshr_b32 s46, s11, 16
; VI-NEXT:    s_add_i32 s10, s10, 3
; VI-NEXT:    v_writelane_b32 v21, s46, 24
; VI-NEXT:    s_lshr_b32 s46, s11, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 25
; VI-NEXT:    s_lshr_b32 s46, s10, 16
; VI-NEXT:    s_add_i32 s13, s13, 3
; VI-NEXT:    v_writelane_b32 v21, s46, 26
; VI-NEXT:    s_lshr_b32 s46, s10, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 27
; VI-NEXT:    s_lshr_b32 s46, s13, 24
; VI-NEXT:    v_writelane_b32 v21, s46, 28
; VI-NEXT:    s_lshr_b32 s46, s13, 16
; VI-NEXT:    s_add_i32 s12, s12, 3
; VI-NEXT:    v_writelane_b32 v21, s46, 29
; VI-NEXT:    s_lshr_b32 s46, s13, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 30
; VI-NEXT:    s_lshr_b32 s46, s12, 16
; VI-NEXT:    s_add_i32 s15, s15, 3
; VI-NEXT:    v_writelane_b32 v21, s46, 31
; VI-NEXT:    s_lshr_b32 s46, s12, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 32
; VI-NEXT:    s_lshr_b32 s46, s15, 24
; VI-NEXT:    v_writelane_b32 v21, s46, 33
; VI-NEXT:    s_lshr_b32 s46, s15, 16
; VI-NEXT:    s_add_i32 s14, s14, 3
; VI-NEXT:    v_writelane_b32 v21, s46, 34
; VI-NEXT:    s_lshr_b32 s46, s15, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 35
; VI-NEXT:    s_lshr_b32 s46, s14, 16
; VI-NEXT:    s_add_i32 s41, s41, 3
; VI-NEXT:    v_writelane_b32 v21, s46, 36
; VI-NEXT:    s_lshr_b32 s46, s14, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 37
; VI-NEXT:    s_lshr_b32 s46, s41, 24
; VI-NEXT:    v_writelane_b32 v21, s46, 38
; VI-NEXT:    s_lshr_b32 s46, s41, 16
; VI-NEXT:    s_add_i32 s40, s40, 3
; VI-NEXT:    v_writelane_b32 v21, s46, 39
; VI-NEXT:    s_lshr_b32 s46, s41, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 40
; VI-NEXT:    s_lshr_b32 s46, s40, 16
; VI-NEXT:    s_add_i32 s43, s43, 3
; VI-NEXT:    v_writelane_b32 v21, s46, 41
; VI-NEXT:    s_lshr_b32 s46, s40, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 42
; VI-NEXT:    s_lshr_b32 s46, s43, 24
; VI-NEXT:    v_writelane_b32 v21, s46, 43
; VI-NEXT:    s_lshr_b32 s46, s43, 16
; VI-NEXT:    s_add_i32 s42, s42, 3
; VI-NEXT:    v_writelane_b32 v21, s46, 44
; VI-NEXT:    s_lshr_b32 s46, s43, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 45
; VI-NEXT:    s_lshr_b32 s46, s42, 16
; VI-NEXT:    s_add_i32 s45, s45, 3
; VI-NEXT:    v_writelane_b32 v21, s46, 46
; VI-NEXT:    s_lshr_b32 s46, s42, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 47
; VI-NEXT:    s_lshr_b32 s46, s45, 24
; VI-NEXT:    v_writelane_b32 v21, s46, 48
; VI-NEXT:    s_lshr_b32 s46, s45, 16
; VI-NEXT:    s_add_i32 s44, s44, 3
; VI-NEXT:    v_writelane_b32 v21, s46, 49
; VI-NEXT:    s_lshr_b32 s46, s45, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 50
; VI-NEXT:    s_lshr_b32 s46, s44, 16
; VI-NEXT:    s_add_i32 s29, s29, 3
; VI-NEXT:    v_writelane_b32 v21, s46, 51
; VI-NEXT:    s_lshr_b32 s46, s44, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 52
; VI-NEXT:    s_lshr_b32 s46, s29, 24
; VI-NEXT:    v_writelane_b32 v21, s46, 53
; VI-NEXT:    s_lshr_b32 s46, s29, 16
; VI-NEXT:    s_add_i32 s28, s28, 3
; VI-NEXT:    v_writelane_b32 v21, s46, 54
; VI-NEXT:    s_lshr_b32 s46, s29, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 55
; VI-NEXT:    s_lshr_b32 s46, s28, 16
; VI-NEXT:    s_add_i32 s27, s27, 3
; VI-NEXT:    v_writelane_b32 v21, s46, 56
; VI-NEXT:    s_lshr_b32 s46, s28, 8
; VI-NEXT:    v_writelane_b32 v21, s46, 57
; VI-NEXT:    s_lshr_b32 s46, s27, 24
; VI-NEXT:    v_writelane_b32 v21, s46, 58
; VI-NEXT:    s_lshr_b32 s46, s27, 16
; VI-NEXT:    v_writelane_b32 v21, s46, 59
; VI-NEXT:    s_lshr_b64 s[60:61], s[4:5], 24
; VI-NEXT:    v_writelane_b32 v21, s60, 6
; VI-NEXT:    v_writelane_b32 v21, s61, 7
; VI-NEXT:    s_lshr_b64 s[60:61], s[6:7], 24
; VI-NEXT:    v_writelane_b32 v21, s60, 4
; VI-NEXT:    v_writelane_b32 v21, s61, 5
; VI-NEXT:    s_lshr_b64 s[60:61], s[8:9], 24
; VI-NEXT:    v_writelane_b32 v21, s60, 2
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_add_i32 s19, s19, 3
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_add_i32 s21, s21, 3
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_add_i32 s23, s23, 3
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_add_i32 s25, s25, 3
; VI-NEXT:    s_add_i32 s24, s24, 3
; VI-NEXT:    s_add_i32 s26, s26, 3
; VI-NEXT:    v_writelane_b32 v21, s61, 3
; VI-NEXT:    s_lshr_b64 s[60:61], s[10:11], 24
; VI-NEXT:    s_lshr_b32 s66, s27, 8
; VI-NEXT:    s_lshr_b32 s67, s26, 16
; VI-NEXT:    s_lshr_b32 s68, s26, 8
; VI-NEXT:    s_lshr_b32 s69, s25, 24
; VI-NEXT:    s_lshr_b32 s70, s25, 16
; VI-NEXT:    s_lshr_b32 s71, s25, 8
; VI-NEXT:    s_lshr_b32 s80, s24, 16
; VI-NEXT:    s_lshr_b32 s81, s24, 8
; VI-NEXT:    s_lshr_b32 s82, s23, 24
; VI-NEXT:    s_lshr_b32 s83, s23, 16
; VI-NEXT:    s_lshr_b32 s84, s23, 8
; VI-NEXT:    s_lshr_b32 s85, s22, 16
; VI-NEXT:    s_lshr_b32 s86, s22, 8
; VI-NEXT:    s_lshr_b32 s87, s21, 24
; VI-NEXT:    s_lshr_b32 s50, s21, 16
; VI-NEXT:    s_lshr_b32 s46, s21, 8
; VI-NEXT:    s_lshr_b32 s47, s20, 16
; VI-NEXT:    s_lshr_b32 s56, s20, 8
; VI-NEXT:    s_lshr_b32 s57, s19, 24
; VI-NEXT:    s_lshr_b32 s51, s19, 16
; VI-NEXT:    s_lshr_b32 s52, s19, 8
; VI-NEXT:    s_lshr_b32 s53, s18, 16
; VI-NEXT:    s_lshr_b32 s54, s18, 8
; VI-NEXT:    s_lshr_b32 s58, s17, 24
; VI-NEXT:    s_lshr_b32 s59, s17, 16
; VI-NEXT:    s_lshr_b32 s55, s17, 8
; VI-NEXT:    s_lshr_b32 s64, s16, 16
; VI-NEXT:    s_lshr_b32 s65, s16, 8
; VI-NEXT:    v_writelane_b32 v21, s60, 0
; VI-NEXT:    s_lshr_b64 s[62:63], s[12:13], 24
; VI-NEXT:    s_lshr_b64 s[72:73], s[14:15], 24
; VI-NEXT:    s_lshr_b64 s[74:75], s[40:41], 24
; VI-NEXT:    s_lshr_b64 s[76:77], s[42:43], 24
; VI-NEXT:    s_lshr_b64 s[78:79], s[44:45], 24
; VI-NEXT:    s_lshr_b64 s[88:89], s[28:29], 24
; VI-NEXT:    s_lshr_b64 s[90:91], s[26:27], 24
; VI-NEXT:    s_lshr_b64 s[30:31], s[24:25], 24
; VI-NEXT:    s_lshr_b64 s[34:35], s[22:23], 24
; VI-NEXT:    s_lshr_b64 s[36:37], s[20:21], 24
; VI-NEXT:    s_lshr_b64 s[38:39], s[18:19], 24
; VI-NEXT:    s_lshr_b64 s[48:49], s[16:17], 24
; VI-NEXT:    v_writelane_b32 v21, s61, 1
; VI-NEXT:  .LBB13_3: ; %end
; VI-NEXT:    s_lshl_b32 s61, s65, 8
; VI-NEXT:    s_and_b32 s16, s16, 0xff
; VI-NEXT:    s_or_b32 s16, s16, s61
; VI-NEXT:    s_lshl_b32 s61, s48, 8
; VI-NEXT:    s_and_b32 s63, s64, 0xff
; VI-NEXT:    s_or_b32 s61, s63, s61
; VI-NEXT:    s_and_b32 s16, s16, 0xffff
; VI-NEXT:    s_lshl_b32 s61, s61, 16
; VI-NEXT:    s_or_b32 s16, s16, s61
; VI-NEXT:    v_mov_b32_e32 v1, s16
; VI-NEXT:    s_and_b32 s16, s17, 0xff
; VI-NEXT:    s_lshl_b32 s17, s55, 8
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    s_and_b32 s17, s59, 0xff
; VI-NEXT:    s_lshl_b32 s58, s58, 8
; VI-NEXT:    s_or_b32 s17, s17, s58
; VI-NEXT:    s_and_b32 s16, s16, 0xffff
; VI-NEXT:    s_lshl_b32 s17, s17, 16
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    v_mov_b32_e32 v2, s16
; VI-NEXT:    s_lshl_b32 s16, s54, 8
; VI-NEXT:    s_and_b32 s17, s18, 0xff
; VI-NEXT:    s_or_b32 s16, s17, s16
; VI-NEXT:    s_lshl_b32 s17, s38, 8
; VI-NEXT:    s_and_b32 s18, s53, 0xff
; VI-NEXT:    s_or_b32 s17, s18, s17
; VI-NEXT:    s_and_b32 s16, s16, 0xffff
; VI-NEXT:    s_lshl_b32 s17, s17, 16
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    v_mov_b32_e32 v3, s16
; VI-NEXT:    s_and_b32 s16, s19, 0xff
; VI-NEXT:    s_lshl_b32 s17, s52, 8
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    s_and_b32 s17, s51, 0xff
; VI-NEXT:    s_lshl_b32 s18, s57, 8
; VI-NEXT:    s_or_b32 s17, s17, s18
; VI-NEXT:    s_and_b32 s16, s16, 0xffff
; VI-NEXT:    s_lshl_b32 s17, s17, 16
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    v_mov_b32_e32 v4, s16
; VI-NEXT:    s_lshl_b32 s16, s56, 8
; VI-NEXT:    s_and_b32 s17, s20, 0xff
; VI-NEXT:    s_or_b32 s16, s17, s16
; VI-NEXT:    s_lshl_b32 s17, s36, 8
; VI-NEXT:    s_and_b32 s18, s47, 0xff
; VI-NEXT:    s_or_b32 s17, s18, s17
; VI-NEXT:    s_and_b32 s16, s16, 0xffff
; VI-NEXT:    s_lshl_b32 s17, s17, 16
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    v_mov_b32_e32 v5, s16
; VI-NEXT:    s_and_b32 s16, s21, 0xff
; VI-NEXT:    s_lshl_b32 s17, s46, 8
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    s_and_b32 s17, s50, 0xff
; VI-NEXT:    s_lshl_b32 s18, s87, 8
; VI-NEXT:    s_or_b32 s17, s17, s18
; VI-NEXT:    s_and_b32 s16, s16, 0xffff
; VI-NEXT:    s_lshl_b32 s17, s17, 16
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    v_mov_b32_e32 v6, s16
; VI-NEXT:    s_lshl_b32 s16, s86, 8
; VI-NEXT:    s_and_b32 s17, s22, 0xff
; VI-NEXT:    s_or_b32 s16, s17, s16
; VI-NEXT:    s_lshl_b32 s17, s34, 8
; VI-NEXT:    s_and_b32 s18, s85, 0xff
; VI-NEXT:    s_or_b32 s17, s18, s17
; VI-NEXT:    s_and_b32 s16, s16, 0xffff
; VI-NEXT:    s_lshl_b32 s17, s17, 16
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    v_mov_b32_e32 v7, s16
; VI-NEXT:    s_and_b32 s16, s23, 0xff
; VI-NEXT:    s_lshl_b32 s17, s84, 8
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    s_and_b32 s17, s83, 0xff
; VI-NEXT:    s_lshl_b32 s18, s82, 8
; VI-NEXT:    s_or_b32 s17, s17, s18
; VI-NEXT:    s_and_b32 s16, s16, 0xffff
; VI-NEXT:    s_lshl_b32 s17, s17, 16
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    v_mov_b32_e32 v8, s16
; VI-NEXT:    s_lshl_b32 s16, s81, 8
; VI-NEXT:    s_and_b32 s17, s24, 0xff
; VI-NEXT:    s_or_b32 s16, s17, s16
; VI-NEXT:    s_lshl_b32 s17, s30, 8
; VI-NEXT:    s_and_b32 s18, s80, 0xff
; VI-NEXT:    s_or_b32 s17, s18, s17
; VI-NEXT:    s_and_b32 s16, s16, 0xffff
; VI-NEXT:    s_lshl_b32 s17, s17, 16
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    v_mov_b32_e32 v9, s16
; VI-NEXT:    s_and_b32 s16, s25, 0xff
; VI-NEXT:    s_lshl_b32 s17, s71, 8
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    s_and_b32 s17, s70, 0xff
; VI-NEXT:    s_lshl_b32 s18, s69, 8
; VI-NEXT:    s_or_b32 s17, s17, s18
; VI-NEXT:    s_and_b32 s16, s16, 0xffff
; VI-NEXT:    s_lshl_b32 s17, s17, 16
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    v_mov_b32_e32 v10, s16
; VI-NEXT:    s_lshl_b32 s16, s68, 8
; VI-NEXT:    s_and_b32 s17, s26, 0xff
; VI-NEXT:    s_or_b32 s16, s17, s16
; VI-NEXT:    s_lshl_b32 s17, s90, 8
; VI-NEXT:    s_and_b32 s18, s67, 0xff
; VI-NEXT:    s_or_b32 s17, s18, s17
; VI-NEXT:    s_and_b32 s16, s16, 0xffff
; VI-NEXT:    s_lshl_b32 s17, s17, 16
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    v_mov_b32_e32 v11, s16
; VI-NEXT:    s_and_b32 s16, s27, 0xff
; VI-NEXT:    s_lshl_b32 s17, s66, 8
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    v_readlane_b32 s17, v21, 59
; VI-NEXT:    v_readlane_b32 s18, v21, 58
; VI-NEXT:    s_and_b32 s17, s17, 0xff
; VI-NEXT:    s_lshl_b32 s18, s18, 8
; VI-NEXT:    s_or_b32 s17, s17, s18
; VI-NEXT:    s_and_b32 s16, s16, 0xffff
; VI-NEXT:    s_lshl_b32 s17, s17, 16
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    v_mov_b32_e32 v12, s16
; VI-NEXT:    v_readlane_b32 s16, v21, 57
; VI-NEXT:    s_lshl_b32 s16, s16, 8
; VI-NEXT:    s_and_b32 s17, s28, 0xff
; VI-NEXT:    v_readlane_b32 s18, v21, 56
; VI-NEXT:    s_or_b32 s16, s17, s16
; VI-NEXT:    s_lshl_b32 s17, s88, 8
; VI-NEXT:    s_and_b32 s18, s18, 0xff
; VI-NEXT:    s_or_b32 s17, s18, s17
; VI-NEXT:    s_and_b32 s16, s16, 0xffff
; VI-NEXT:    s_lshl_b32 s17, s17, 16
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    v_readlane_b32 s17, v21, 55
; VI-NEXT:    v_mov_b32_e32 v13, s16
; VI-NEXT:    s_and_b32 s16, s29, 0xff
; VI-NEXT:    s_lshl_b32 s17, s17, 8
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    v_readlane_b32 s17, v21, 54
; VI-NEXT:    v_readlane_b32 s18, v21, 53
; VI-NEXT:    s_and_b32 s17, s17, 0xff
; VI-NEXT:    s_lshl_b32 s18, s18, 8
; VI-NEXT:    s_or_b32 s17, s17, s18
; VI-NEXT:    s_and_b32 s16, s16, 0xffff
; VI-NEXT:    s_lshl_b32 s17, s17, 16
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    v_mov_b32_e32 v14, s16
; VI-NEXT:    v_readlane_b32 s16, v21, 52
; VI-NEXT:    s_lshl_b32 s16, s16, 8
; VI-NEXT:    s_and_b32 s17, s44, 0xff
; VI-NEXT:    v_readlane_b32 s18, v21, 51
; VI-NEXT:    s_or_b32 s16, s17, s16
; VI-NEXT:    s_lshl_b32 s17, s78, 8
; VI-NEXT:    s_and_b32 s18, s18, 0xff
; VI-NEXT:    s_or_b32 s17, s18, s17
; VI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; VI-NEXT:    v_add_u32_e32 v1, vcc, 4, v0
; VI-NEXT:    s_and_b32 s16, s16, 0xffff
; VI-NEXT:    s_lshl_b32 s17, s17, 16
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_add_u32_e32 v1, vcc, 8, v0
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    v_readlane_b32 s17, v21, 50
; VI-NEXT:    buffer_store_dword v3, v1, s[0:3], 0 offen
; VI-NEXT:    v_add_u32_e32 v1, vcc, 12, v0
; VI-NEXT:    v_mov_b32_e32 v15, s16
; VI-NEXT:    s_and_b32 s16, s45, 0xff
; VI-NEXT:    s_lshl_b32 s17, s17, 8
; VI-NEXT:    buffer_store_dword v4, v1, s[0:3], 0 offen
; VI-NEXT:    v_add_u32_e32 v1, vcc, 16, v0
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    buffer_store_dword v5, v1, s[0:3], 0 offen
; VI-NEXT:    v_add_u32_e32 v1, vcc, 20, v0
; VI-NEXT:    v_readlane_b32 s17, v21, 49
; VI-NEXT:    v_readlane_b32 s18, v21, 48
; VI-NEXT:    buffer_store_dword v6, v1, s[0:3], 0 offen
; VI-NEXT:    v_add_u32_e32 v1, vcc, 24, v0
; VI-NEXT:    s_and_b32 s17, s17, 0xff
; VI-NEXT:    s_lshl_b32 s18, s18, 8
; VI-NEXT:    buffer_store_dword v7, v1, s[0:3], 0 offen
; VI-NEXT:    v_add_u32_e32 v1, vcc, 28, v0
; VI-NEXT:    s_or_b32 s17, s17, s18
; VI-NEXT:    buffer_store_dword v8, v1, s[0:3], 0 offen
; VI-NEXT:    v_add_u32_e32 v1, vcc, 32, v0
; VI-NEXT:    s_and_b32 s16, s16, 0xffff
; VI-NEXT:    s_lshl_b32 s17, s17, 16
; VI-NEXT:    buffer_store_dword v9, v1, s[0:3], 0 offen
; VI-NEXT:    v_add_u32_e32 v1, vcc, 36, v0
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    v_readlane_b32 s17, v21, 47
; VI-NEXT:    buffer_store_dword v10, v1, s[0:3], 0 offen
; VI-NEXT:    v_add_u32_e32 v1, vcc, 40, v0
; VI-NEXT:    v_mov_b32_e32 v2, s16
; VI-NEXT:    s_and_b32 s16, s42, 0xff
; VI-NEXT:    s_lshl_b32 s17, s17, 8
; VI-NEXT:    buffer_store_dword v11, v1, s[0:3], 0 offen
; VI-NEXT:    v_add_u32_e32 v1, vcc, 44, v0
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    v_readlane_b32 s17, v21, 46
; VI-NEXT:    buffer_store_dword v12, v1, s[0:3], 0 offen
; VI-NEXT:    v_add_u32_e32 v1, vcc, 48, v0
; VI-NEXT:    s_and_b32 s17, s17, 0xff
; VI-NEXT:    s_lshl_b32 s18, s76, 8
; VI-NEXT:    buffer_store_dword v13, v1, s[0:3], 0 offen
; VI-NEXT:    v_add_u32_e32 v1, vcc, 52, v0
; VI-NEXT:    s_or_b32 s17, s17, s18
; VI-NEXT:    buffer_store_dword v14, v1, s[0:3], 0 offen
; VI-NEXT:    v_add_u32_e32 v1, vcc, 56, v0
; VI-NEXT:    s_and_b32 s16, s16, 0xffff
; VI-NEXT:    s_lshl_b32 s17, s17, 16
; VI-NEXT:    buffer_store_dword v15, v1, s[0:3], 0 offen
; VI-NEXT:    v_add_u32_e32 v1, vcc, 60, v0
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    v_readlane_b32 s17, v21, 45
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s16
; VI-NEXT:    s_and_b32 s16, s43, 0xff
; VI-NEXT:    s_lshl_b32 s17, s17, 8
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    v_readlane_b32 s17, v21, 44
; VI-NEXT:    v_readlane_b32 s18, v21, 43
; VI-NEXT:    s_and_b32 s17, s17, 0xff
; VI-NEXT:    s_lshl_b32 s18, s18, 8
; VI-NEXT:    s_or_b32 s17, s17, s18
; VI-NEXT:    s_and_b32 s16, s16, 0xffff
; VI-NEXT:    s_lshl_b32 s17, s17, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 64, v0
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    v_readlane_b32 s17, v21, 42
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s16
; VI-NEXT:    s_and_b32 s16, s40, 0xff
; VI-NEXT:    s_lshl_b32 s17, s17, 8
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    v_readlane_b32 s17, v21, 41
; VI-NEXT:    s_and_b32 s17, s17, 0xff
; VI-NEXT:    s_lshl_b32 s18, s74, 8
; VI-NEXT:    s_or_b32 s17, s17, s18
; VI-NEXT:    s_and_b32 s16, s16, 0xffff
; VI-NEXT:    s_lshl_b32 s17, s17, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x44, v0
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    v_readlane_b32 s17, v21, 40
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s16
; VI-NEXT:    s_and_b32 s16, s41, 0xff
; VI-NEXT:    s_lshl_b32 s17, s17, 8
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    v_readlane_b32 s17, v21, 39
; VI-NEXT:    v_readlane_b32 s18, v21, 38
; VI-NEXT:    s_and_b32 s17, s17, 0xff
; VI-NEXT:    s_lshl_b32 s18, s18, 8
; VI-NEXT:    s_or_b32 s17, s17, s18
; VI-NEXT:    s_and_b32 s16, s16, 0xffff
; VI-NEXT:    s_lshl_b32 s17, s17, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x48, v0
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s16
; VI-NEXT:    v_readlane_b32 s16, v21, 37
; VI-NEXT:    s_and_b32 s14, s14, 0xff
; VI-NEXT:    s_lshl_b32 s16, s16, 8
; VI-NEXT:    s_or_b32 s14, s14, s16
; VI-NEXT:    v_readlane_b32 s16, v21, 36
; VI-NEXT:    s_and_b32 s16, s16, 0xff
; VI-NEXT:    s_lshl_b32 s17, s72, 8
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    s_and_b32 s14, s14, 0xffff
; VI-NEXT:    s_lshl_b32 s16, s16, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x4c, v0
; VI-NEXT:    s_or_b32 s14, s14, s16
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s14
; VI-NEXT:    s_and_b32 s14, s15, 0xff
; VI-NEXT:    v_readlane_b32 s15, v21, 35
; VI-NEXT:    s_lshl_b32 s15, s15, 8
; VI-NEXT:    s_or_b32 s14, s14, s15
; VI-NEXT:    v_readlane_b32 s15, v21, 34
; VI-NEXT:    v_readlane_b32 s16, v21, 33
; VI-NEXT:    s_and_b32 s15, s15, 0xff
; VI-NEXT:    s_lshl_b32 s16, s16, 8
; VI-NEXT:    s_or_b32 s15, s15, s16
; VI-NEXT:    s_and_b32 s14, s14, 0xffff
; VI-NEXT:    s_lshl_b32 s15, s15, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x50, v0
; VI-NEXT:    s_or_b32 s14, s14, s15
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s14
; VI-NEXT:    v_readlane_b32 s14, v21, 32
; VI-NEXT:    s_and_b32 s12, s12, 0xff
; VI-NEXT:    s_lshl_b32 s14, s14, 8
; VI-NEXT:    s_or_b32 s12, s12, s14
; VI-NEXT:    v_readlane_b32 s14, v21, 31
; VI-NEXT:    s_and_b32 s14, s14, 0xff
; VI-NEXT:    s_lshl_b32 s15, s62, 8
; VI-NEXT:    s_or_b32 s14, s14, s15
; VI-NEXT:    s_and_b32 s12, s12, 0xffff
; VI-NEXT:    s_lshl_b32 s14, s14, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x54, v0
; VI-NEXT:    s_or_b32 s12, s12, s14
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s12
; VI-NEXT:    s_and_b32 s12, s13, 0xff
; VI-NEXT:    v_readlane_b32 s13, v21, 30
; VI-NEXT:    s_lshl_b32 s13, s13, 8
; VI-NEXT:    s_or_b32 s12, s12, s13
; VI-NEXT:    v_readlane_b32 s13, v21, 29
; VI-NEXT:    v_readlane_b32 s14, v21, 28
; VI-NEXT:    s_and_b32 s13, s13, 0xff
; VI-NEXT:    s_lshl_b32 s14, s14, 8
; VI-NEXT:    s_or_b32 s13, s13, s14
; VI-NEXT:    s_and_b32 s12, s12, 0xffff
; VI-NEXT:    s_lshl_b32 s13, s13, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x58, v0
; VI-NEXT:    s_or_b32 s12, s12, s13
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s12
; VI-NEXT:    v_readlane_b32 s12, v21, 27
; VI-NEXT:    s_and_b32 s10, s10, 0xff
; VI-NEXT:    s_lshl_b32 s12, s12, 8
; VI-NEXT:    s_or_b32 s10, s10, s12
; VI-NEXT:    v_readlane_b32 s12, v21, 26
; VI-NEXT:    v_readlane_b32 s14, v21, 0
; VI-NEXT:    s_and_b32 s12, s12, 0xff
; VI-NEXT:    s_lshl_b32 s13, s14, 8
; VI-NEXT:    s_or_b32 s12, s12, s13
; VI-NEXT:    s_and_b32 s10, s10, 0xffff
; VI-NEXT:    s_lshl_b32 s12, s12, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x5c, v0
; VI-NEXT:    s_or_b32 s10, s10, s12
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s10
; VI-NEXT:    s_and_b32 s10, s11, 0xff
; VI-NEXT:    v_readlane_b32 s11, v21, 25
; VI-NEXT:    s_lshl_b32 s11, s11, 8
; VI-NEXT:    s_or_b32 s10, s10, s11
; VI-NEXT:    v_readlane_b32 s11, v21, 24
; VI-NEXT:    v_readlane_b32 s12, v21, 23
; VI-NEXT:    s_and_b32 s11, s11, 0xff
; VI-NEXT:    s_lshl_b32 s12, s12, 8
; VI-NEXT:    s_or_b32 s11, s11, s12
; VI-NEXT:    s_and_b32 s10, s10, 0xffff
; VI-NEXT:    s_lshl_b32 s11, s11, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x60, v0
; VI-NEXT:    s_or_b32 s10, s10, s11
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s10
; VI-NEXT:    v_readlane_b32 s10, v21, 22
; VI-NEXT:    s_and_b32 s8, s8, 0xff
; VI-NEXT:    s_lshl_b32 s10, s10, 8
; VI-NEXT:    s_or_b32 s8, s8, s10
; VI-NEXT:    v_readlane_b32 s10, v21, 21
; VI-NEXT:    v_readlane_b32 s12, v21, 2
; VI-NEXT:    s_and_b32 s10, s10, 0xff
; VI-NEXT:    s_lshl_b32 s11, s12, 8
; VI-NEXT:    s_or_b32 s10, s10, s11
; VI-NEXT:    s_and_b32 s8, s8, 0xffff
; VI-NEXT:    s_lshl_b32 s10, s10, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x64, v0
; VI-NEXT:    s_or_b32 s8, s8, s10
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s8
; VI-NEXT:    s_and_b32 s8, s9, 0xff
; VI-NEXT:    v_readlane_b32 s9, v21, 20
; VI-NEXT:    s_lshl_b32 s9, s9, 8
; VI-NEXT:    s_or_b32 s8, s8, s9
; VI-NEXT:    v_readlane_b32 s9, v21, 19
; VI-NEXT:    v_readlane_b32 s10, v21, 18
; VI-NEXT:    s_and_b32 s9, s9, 0xff
; VI-NEXT:    s_lshl_b32 s10, s10, 8
; VI-NEXT:    s_or_b32 s9, s9, s10
; VI-NEXT:    s_and_b32 s8, s8, 0xffff
; VI-NEXT:    s_lshl_b32 s9, s9, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x68, v0
; VI-NEXT:    s_or_b32 s8, s8, s9
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s8
; VI-NEXT:    v_readlane_b32 s8, v21, 17
; VI-NEXT:    s_and_b32 s6, s6, 0xff
; VI-NEXT:    s_lshl_b32 s8, s8, 8
; VI-NEXT:    s_or_b32 s6, s6, s8
; VI-NEXT:    v_readlane_b32 s8, v21, 16
; VI-NEXT:    v_readlane_b32 s10, v21, 4
; VI-NEXT:    s_and_b32 s8, s8, 0xff
; VI-NEXT:    s_lshl_b32 s9, s10, 8
; VI-NEXT:    s_or_b32 s8, s8, s9
; VI-NEXT:    s_and_b32 s6, s6, 0xffff
; VI-NEXT:    s_lshl_b32 s8, s8, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x6c, v0
; VI-NEXT:    s_or_b32 s6, s6, s8
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    s_and_b32 s6, s7, 0xff
; VI-NEXT:    v_readlane_b32 s7, v21, 15
; VI-NEXT:    s_lshl_b32 s7, s7, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    v_readlane_b32 s7, v21, 14
; VI-NEXT:    v_readlane_b32 s8, v21, 13
; VI-NEXT:    s_and_b32 s7, s7, 0xff
; VI-NEXT:    s_lshl_b32 s8, s8, 8
; VI-NEXT:    s_or_b32 s7, s7, s8
; VI-NEXT:    s_and_b32 s6, s6, 0xffff
; VI-NEXT:    s_lshl_b32 s7, s7, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x70, v0
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    v_readlane_b32 s6, v21, 12
; VI-NEXT:    s_and_b32 s4, s4, 0xff
; VI-NEXT:    s_lshl_b32 s6, s6, 8
; VI-NEXT:    s_or_b32 s4, s4, s6
; VI-NEXT:    v_readlane_b32 s6, v21, 11
; VI-NEXT:    v_readlane_b32 s8, v21, 6
; VI-NEXT:    s_and_b32 s6, s6, 0xff
; VI-NEXT:    s_lshl_b32 s7, s8, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x74, v0
; VI-NEXT:    s_or_b32 s4, s4, s6
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_mov_b32_e32 v2, s4
; VI-NEXT:    s_and_b32 s4, s5, 0xff
; VI-NEXT:    v_readlane_b32 s5, v21, 10
; VI-NEXT:    s_lshl_b32 s5, s5, 8
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    v_readlane_b32 s5, v21, 9
; VI-NEXT:    v_readlane_b32 s6, v21, 8
; VI-NEXT:    s_and_b32 s5, s5, 0xff
; VI-NEXT:    s_lshl_b32 s6, s6, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x78, v0
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x7c, v0
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_readlane_b32 s15, v21, 1
; VI-NEXT:    v_readlane_b32 s13, v21, 3
; VI-NEXT:    v_readlane_b32 s11, v21, 5
; VI-NEXT:    v_readlane_b32 s9, v21, 7
; VI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; VI-NEXT:    v_readlane_b32 s87, v20, 31
; VI-NEXT:    v_readlane_b32 s86, v20, 30
; VI-NEXT:    v_readlane_b32 s85, v20, 29
; VI-NEXT:    v_readlane_b32 s84, v20, 28
; VI-NEXT:    v_readlane_b32 s83, v20, 27
; VI-NEXT:    v_readlane_b32 s82, v20, 26
; VI-NEXT:    v_readlane_b32 s81, v20, 25
; VI-NEXT:    v_readlane_b32 s80, v20, 24
; VI-NEXT:    v_readlane_b32 s71, v20, 23
; VI-NEXT:    v_readlane_b32 s70, v20, 22
; VI-NEXT:    v_readlane_b32 s69, v20, 21
; VI-NEXT:    v_readlane_b32 s68, v20, 20
; VI-NEXT:    v_readlane_b32 s67, v20, 19
; VI-NEXT:    v_readlane_b32 s66, v20, 18
; VI-NEXT:    v_readlane_b32 s65, v20, 17
; VI-NEXT:    v_readlane_b32 s64, v20, 16
; VI-NEXT:    v_readlane_b32 s55, v20, 15
; VI-NEXT:    v_readlane_b32 s54, v20, 14
; VI-NEXT:    v_readlane_b32 s53, v20, 13
; VI-NEXT:    v_readlane_b32 s52, v20, 12
; VI-NEXT:    v_readlane_b32 s51, v20, 11
; VI-NEXT:    v_readlane_b32 s50, v20, 10
; VI-NEXT:    v_readlane_b32 s49, v20, 9
; VI-NEXT:    v_readlane_b32 s48, v20, 8
; VI-NEXT:    v_readlane_b32 s39, v20, 7
; VI-NEXT:    v_readlane_b32 s38, v20, 6
; VI-NEXT:    v_readlane_b32 s37, v20, 5
; VI-NEXT:    v_readlane_b32 s36, v20, 4
; VI-NEXT:    v_readlane_b32 s35, v20, 3
; VI-NEXT:    v_readlane_b32 s34, v20, 2
; VI-NEXT:    v_readlane_b32 s31, v20, 1
; VI-NEXT:    v_readlane_b32 s30, v20, 0
; VI-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; VI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; VI-NEXT:    s_mov_b64 exec, s[4:5]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB13_4:
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr65
; VI-NEXT:    ; implicit-def: $sgpr64
; VI-NEXT:    ; implicit-def: $sgpr55
; VI-NEXT:    ; implicit-def: $sgpr59
; VI-NEXT:    ; implicit-def: $sgpr58
; VI-NEXT:    ; implicit-def: $sgpr54
; VI-NEXT:    ; implicit-def: $sgpr53
; VI-NEXT:    ; implicit-def: $sgpr52
; VI-NEXT:    ; implicit-def: $sgpr51
; VI-NEXT:    ; implicit-def: $sgpr57
; VI-NEXT:    ; implicit-def: $sgpr56
; VI-NEXT:    ; implicit-def: $sgpr47
; VI-NEXT:    ; implicit-def: $sgpr46
; VI-NEXT:    ; implicit-def: $sgpr50
; VI-NEXT:    ; implicit-def: $sgpr87
; VI-NEXT:    ; implicit-def: $sgpr86
; VI-NEXT:    ; implicit-def: $sgpr85
; VI-NEXT:    ; implicit-def: $sgpr84
; VI-NEXT:    ; implicit-def: $sgpr83
; VI-NEXT:    ; implicit-def: $sgpr82
; VI-NEXT:    ; implicit-def: $sgpr81
; VI-NEXT:    ; implicit-def: $sgpr80
; VI-NEXT:    ; implicit-def: $sgpr71
; VI-NEXT:    ; implicit-def: $sgpr70
; VI-NEXT:    ; implicit-def: $sgpr69
; VI-NEXT:    ; implicit-def: $sgpr68
; VI-NEXT:    ; implicit-def: $sgpr67
; VI-NEXT:    ; implicit-def: $sgpr66
; VI-NEXT:    ; implicit-def: $sgpr48
; VI-NEXT:    ; implicit-def: $sgpr38
; VI-NEXT:    ; implicit-def: $sgpr36
; VI-NEXT:    ; implicit-def: $sgpr34
; VI-NEXT:    ; implicit-def: $sgpr30
; VI-NEXT:    ; implicit-def: $sgpr90
; VI-NEXT:    ; implicit-def: $sgpr88
; VI-NEXT:    ; implicit-def: $sgpr78
; VI-NEXT:    ; implicit-def: $sgpr76
; VI-NEXT:    ; implicit-def: $sgpr74
; VI-NEXT:    ; implicit-def: $sgpr72
; VI-NEXT:    ; implicit-def: $sgpr62
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; kill: killed $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    v_writelane_b32 v21, s60, 0
; VI-NEXT:    v_writelane_b32 v21, s61, 1
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    v_writelane_b32 v21, s60, 2
; VI-NEXT:    v_writelane_b32 v21, s61, 3
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    v_writelane_b32 v21, s60, 4
; VI-NEXT:    v_writelane_b32 v21, s61, 5
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    v_writelane_b32 v21, s60, 6
; VI-NEXT:    v_writelane_b32 v21, s61, 7
; VI-NEXT:    s_branch .LBB13_2
;
; GFX9-LABEL: bitcast_v32i32_to_v128i8_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX9-NEXT:    buffer_store_dword v20, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v21, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9-NEXT:    v_writelane_b32 v20, s30, 0
; GFX9-NEXT:    v_writelane_b32 v20, s31, 1
; GFX9-NEXT:    v_writelane_b32 v20, s34, 2
; GFX9-NEXT:    v_writelane_b32 v20, s35, 3
; GFX9-NEXT:    v_writelane_b32 v20, s36, 4
; GFX9-NEXT:    v_writelane_b32 v20, s37, 5
; GFX9-NEXT:    v_writelane_b32 v20, s38, 6
; GFX9-NEXT:    v_writelane_b32 v20, s39, 7
; GFX9-NEXT:    v_writelane_b32 v20, s48, 8
; GFX9-NEXT:    v_writelane_b32 v20, s49, 9
; GFX9-NEXT:    v_writelane_b32 v20, s50, 10
; GFX9-NEXT:    v_writelane_b32 v20, s51, 11
; GFX9-NEXT:    v_writelane_b32 v20, s52, 12
; GFX9-NEXT:    v_writelane_b32 v20, s53, 13
; GFX9-NEXT:    v_writelane_b32 v20, s54, 14
; GFX9-NEXT:    v_writelane_b32 v20, s55, 15
; GFX9-NEXT:    v_writelane_b32 v20, s64, 16
; GFX9-NEXT:    v_writelane_b32 v20, s65, 17
; GFX9-NEXT:    v_writelane_b32 v20, s66, 18
; GFX9-NEXT:    v_writelane_b32 v20, s67, 19
; GFX9-NEXT:    v_writelane_b32 v20, s68, 20
; GFX9-NEXT:    v_writelane_b32 v20, s69, 21
; GFX9-NEXT:    v_writelane_b32 v20, s70, 22
; GFX9-NEXT:    v_writelane_b32 v20, s71, 23
; GFX9-NEXT:    v_writelane_b32 v20, s80, 24
; GFX9-NEXT:    v_writelane_b32 v20, s81, 25
; GFX9-NEXT:    v_writelane_b32 v20, s82, 26
; GFX9-NEXT:    v_writelane_b32 v20, s83, 27
; GFX9-NEXT:    v_writelane_b32 v20, s84, 28
; GFX9-NEXT:    v_writelane_b32 v20, s85, 29
; GFX9-NEXT:    v_writelane_b32 v20, s86, 30
; GFX9-NEXT:    v_writelane_b32 v20, s87, 31
; GFX9-NEXT:    v_writelane_b32 v20, s96, 32
; GFX9-NEXT:    v_writelane_b32 v20, s97, 33
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v19
; GFX9-NEXT:    v_writelane_b32 v20, s98, 34
; GFX9-NEXT:    v_readfirstlane_b32 s44, v1
; GFX9-NEXT:    v_readfirstlane_b32 s45, v2
; GFX9-NEXT:    v_readfirstlane_b32 s42, v3
; GFX9-NEXT:    v_readfirstlane_b32 s43, v4
; GFX9-NEXT:    v_readfirstlane_b32 s40, v5
; GFX9-NEXT:    v_readfirstlane_b32 s41, v6
; GFX9-NEXT:    v_readfirstlane_b32 s14, v7
; GFX9-NEXT:    v_readfirstlane_b32 s15, v8
; GFX9-NEXT:    v_readfirstlane_b32 s12, v9
; GFX9-NEXT:    v_readfirstlane_b32 s13, v10
; GFX9-NEXT:    v_readfirstlane_b32 s10, v11
; GFX9-NEXT:    v_readfirstlane_b32 s11, v12
; GFX9-NEXT:    v_readfirstlane_b32 s8, v13
; GFX9-NEXT:    v_readfirstlane_b32 s9, v14
; GFX9-NEXT:    v_readfirstlane_b32 s6, v15
; GFX9-NEXT:    v_readfirstlane_b32 s7, v16
; GFX9-NEXT:    v_readfirstlane_b32 s4, v17
; GFX9-NEXT:    s_and_b64 s[46:47], vcc, exec
; GFX9-NEXT:    v_readfirstlane_b32 s5, v18
; GFX9-NEXT:    v_writelane_b32 v20, s99, 35
; GFX9-NEXT:    ; implicit-def: $vgpr21 : SGPR spill to VGPR lane
; GFX9-NEXT:    s_cbranch_scc0 .LBB13_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_lshr_b32 s46, s5, 24
; GFX9-NEXT:    v_writelane_b32 v21, s46, 2
; GFX9-NEXT:    s_lshr_b32 s46, s5, 16
; GFX9-NEXT:    v_writelane_b32 v21, s46, 3
; GFX9-NEXT:    s_lshr_b32 s46, s5, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 4
; GFX9-NEXT:    s_lshr_b32 s46, s4, 16
; GFX9-NEXT:    v_writelane_b32 v21, s46, 5
; GFX9-NEXT:    s_lshr_b32 s46, s4, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 6
; GFX9-NEXT:    s_lshr_b32 s46, s7, 24
; GFX9-NEXT:    v_writelane_b32 v21, s46, 7
; GFX9-NEXT:    s_lshr_b32 s46, s7, 16
; GFX9-NEXT:    v_writelane_b32 v21, s46, 8
; GFX9-NEXT:    s_lshr_b32 s46, s7, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 9
; GFX9-NEXT:    s_lshr_b32 s46, s6, 16
; GFX9-NEXT:    v_writelane_b32 v21, s46, 10
; GFX9-NEXT:    s_lshr_b32 s46, s6, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 11
; GFX9-NEXT:    s_lshr_b32 s46, s9, 24
; GFX9-NEXT:    v_writelane_b32 v21, s46, 12
; GFX9-NEXT:    s_lshr_b32 s46, s9, 16
; GFX9-NEXT:    v_writelane_b32 v21, s46, 13
; GFX9-NEXT:    s_lshr_b32 s46, s9, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 14
; GFX9-NEXT:    s_lshr_b32 s46, s8, 16
; GFX9-NEXT:    v_writelane_b32 v21, s46, 15
; GFX9-NEXT:    s_lshr_b32 s46, s8, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 16
; GFX9-NEXT:    s_lshr_b32 s46, s11, 24
; GFX9-NEXT:    v_writelane_b32 v21, s46, 17
; GFX9-NEXT:    s_lshr_b32 s46, s11, 16
; GFX9-NEXT:    v_writelane_b32 v21, s46, 18
; GFX9-NEXT:    s_lshr_b32 s46, s11, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 19
; GFX9-NEXT:    s_lshr_b32 s46, s10, 16
; GFX9-NEXT:    v_writelane_b32 v21, s46, 20
; GFX9-NEXT:    s_lshr_b32 s46, s10, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 21
; GFX9-NEXT:    s_lshr_b32 s46, s13, 24
; GFX9-NEXT:    v_writelane_b32 v21, s46, 22
; GFX9-NEXT:    s_lshr_b32 s46, s13, 16
; GFX9-NEXT:    v_writelane_b32 v21, s46, 23
; GFX9-NEXT:    s_lshr_b32 s46, s13, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 24
; GFX9-NEXT:    s_lshr_b32 s46, s12, 16
; GFX9-NEXT:    v_writelane_b32 v21, s46, 25
; GFX9-NEXT:    s_lshr_b32 s46, s12, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 26
; GFX9-NEXT:    s_lshr_b32 s46, s15, 24
; GFX9-NEXT:    v_writelane_b32 v21, s46, 27
; GFX9-NEXT:    s_lshr_b32 s46, s15, 16
; GFX9-NEXT:    v_writelane_b32 v21, s46, 28
; GFX9-NEXT:    s_lshr_b32 s46, s15, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 29
; GFX9-NEXT:    s_lshr_b32 s46, s14, 16
; GFX9-NEXT:    v_writelane_b32 v21, s46, 30
; GFX9-NEXT:    s_lshr_b32 s46, s14, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 31
; GFX9-NEXT:    s_lshr_b32 s46, s41, 24
; GFX9-NEXT:    v_writelane_b32 v21, s46, 32
; GFX9-NEXT:    s_lshr_b32 s46, s41, 16
; GFX9-NEXT:    v_writelane_b32 v21, s46, 33
; GFX9-NEXT:    s_lshr_b32 s46, s41, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 34
; GFX9-NEXT:    s_lshr_b32 s46, s40, 16
; GFX9-NEXT:    v_writelane_b32 v21, s46, 35
; GFX9-NEXT:    s_lshr_b32 s46, s40, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 36
; GFX9-NEXT:    s_lshr_b32 s46, s43, 24
; GFX9-NEXT:    v_writelane_b32 v21, s46, 37
; GFX9-NEXT:    s_lshr_b32 s46, s43, 16
; GFX9-NEXT:    v_writelane_b32 v21, s46, 38
; GFX9-NEXT:    s_lshr_b32 s46, s43, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 39
; GFX9-NEXT:    s_lshr_b32 s46, s42, 16
; GFX9-NEXT:    v_writelane_b32 v21, s46, 40
; GFX9-NEXT:    s_lshr_b32 s46, s42, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 41
; GFX9-NEXT:    s_lshr_b32 s46, s45, 24
; GFX9-NEXT:    v_writelane_b32 v21, s46, 42
; GFX9-NEXT:    s_lshr_b32 s46, s45, 16
; GFX9-NEXT:    v_writelane_b32 v21, s46, 43
; GFX9-NEXT:    s_lshr_b32 s46, s45, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 44
; GFX9-NEXT:    s_lshr_b32 s46, s44, 16
; GFX9-NEXT:    v_writelane_b32 v21, s46, 45
; GFX9-NEXT:    s_lshr_b32 s46, s44, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 46
; GFX9-NEXT:    s_lshr_b32 s46, s29, 24
; GFX9-NEXT:    v_writelane_b32 v21, s46, 47
; GFX9-NEXT:    s_lshr_b32 s46, s29, 16
; GFX9-NEXT:    v_writelane_b32 v21, s46, 48
; GFX9-NEXT:    s_lshr_b32 s46, s29, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 49
; GFX9-NEXT:    s_lshr_b32 s46, s28, 16
; GFX9-NEXT:    v_writelane_b32 v21, s46, 50
; GFX9-NEXT:    s_lshr_b64 s[56:57], s[4:5], 24
; GFX9-NEXT:    v_writelane_b32 v21, s56, 0
; GFX9-NEXT:    s_lshr_b32 s82, s28, 8
; GFX9-NEXT:    s_lshr_b32 s83, s27, 24
; GFX9-NEXT:    s_lshr_b32 s81, s27, 16
; GFX9-NEXT:    s_lshr_b32 s84, s27, 8
; GFX9-NEXT:    s_lshr_b32 s85, s26, 16
; GFX9-NEXT:    s_lshr_b32 s86, s26, 8
; GFX9-NEXT:    s_lshr_b32 s87, s25, 24
; GFX9-NEXT:    s_lshr_b32 s96, s25, 16
; GFX9-NEXT:    s_lshr_b32 s97, s25, 8
; GFX9-NEXT:    s_lshr_b32 s98, s24, 16
; GFX9-NEXT:    s_lshr_b32 s99, s24, 8
; GFX9-NEXT:    s_lshr_b32 s38, s23, 24
; GFX9-NEXT:    s_lshr_b32 s39, s23, 16
; GFX9-NEXT:    s_lshr_b32 s48, s23, 8
; GFX9-NEXT:    s_lshr_b32 s49, s22, 16
; GFX9-NEXT:    s_lshr_b32 s50, s22, 8
; GFX9-NEXT:    s_lshr_b32 s51, s21, 24
; GFX9-NEXT:    s_lshr_b32 s52, s21, 16
; GFX9-NEXT:    s_lshr_b32 s53, s21, 8
; GFX9-NEXT:    s_lshr_b32 s54, s20, 16
; GFX9-NEXT:    s_lshr_b32 s55, s20, 8
; GFX9-NEXT:    s_lshr_b32 s64, s19, 24
; GFX9-NEXT:    s_lshr_b32 s65, s19, 16
; GFX9-NEXT:    s_lshr_b32 s66, s19, 8
; GFX9-NEXT:    s_lshr_b32 s67, s18, 16
; GFX9-NEXT:    s_lshr_b32 s68, s18, 8
; GFX9-NEXT:    s_lshr_b32 s69, s17, 24
; GFX9-NEXT:    s_lshr_b32 s70, s17, 16
; GFX9-NEXT:    s_lshr_b32 s71, s17, 8
; GFX9-NEXT:    s_lshr_b32 s80, s16, 16
; GFX9-NEXT:    s_lshr_b32 s46, s16, 8
; GFX9-NEXT:    v_writelane_b32 v21, s57, 1
; GFX9-NEXT:    s_lshr_b64 s[56:57], s[6:7], 24
; GFX9-NEXT:    s_lshr_b64 s[58:59], s[8:9], 24
; GFX9-NEXT:    s_lshr_b64 s[60:61], s[10:11], 24
; GFX9-NEXT:    s_lshr_b64 s[62:63], s[12:13], 24
; GFX9-NEXT:    s_lshr_b64 s[72:73], s[14:15], 24
; GFX9-NEXT:    s_lshr_b64 s[74:75], s[40:41], 24
; GFX9-NEXT:    s_lshr_b64 s[76:77], s[42:43], 24
; GFX9-NEXT:    s_lshr_b64 s[78:79], s[44:45], 24
; GFX9-NEXT:    s_lshr_b64 s[88:89], s[28:29], 24
; GFX9-NEXT:    s_lshr_b64 s[90:91], s[26:27], 24
; GFX9-NEXT:    s_lshr_b64 s[92:93], s[24:25], 24
; GFX9-NEXT:    s_lshr_b64 s[94:95], s[22:23], 24
; GFX9-NEXT:    s_lshr_b64 s[30:31], s[20:21], 24
; GFX9-NEXT:    s_lshr_b64 s[34:35], s[18:19], 24
; GFX9-NEXT:    s_lshr_b64 s[36:37], s[16:17], 24
; GFX9-NEXT:    s_cbranch_execnz .LBB13_3
; GFX9-NEXT:  .LBB13_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s5, s5, 3
; GFX9-NEXT:    s_lshr_b32 s46, s5, 24
; GFX9-NEXT:    v_writelane_b32 v21, s46, 2
; GFX9-NEXT:    s_lshr_b32 s46, s5, 16
; GFX9-NEXT:    s_add_i32 s4, s4, 3
; GFX9-NEXT:    v_writelane_b32 v21, s46, 3
; GFX9-NEXT:    s_lshr_b32 s46, s5, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 4
; GFX9-NEXT:    s_lshr_b32 s46, s4, 16
; GFX9-NEXT:    s_add_i32 s7, s7, 3
; GFX9-NEXT:    v_writelane_b32 v21, s46, 5
; GFX9-NEXT:    s_lshr_b32 s46, s4, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 6
; GFX9-NEXT:    s_lshr_b32 s46, s7, 24
; GFX9-NEXT:    v_writelane_b32 v21, s46, 7
; GFX9-NEXT:    s_lshr_b32 s46, s7, 16
; GFX9-NEXT:    s_add_i32 s6, s6, 3
; GFX9-NEXT:    v_writelane_b32 v21, s46, 8
; GFX9-NEXT:    s_lshr_b32 s46, s7, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 9
; GFX9-NEXT:    s_lshr_b32 s46, s6, 16
; GFX9-NEXT:    s_add_i32 s9, s9, 3
; GFX9-NEXT:    v_writelane_b32 v21, s46, 10
; GFX9-NEXT:    s_lshr_b32 s46, s6, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 11
; GFX9-NEXT:    s_lshr_b32 s46, s9, 24
; GFX9-NEXT:    v_writelane_b32 v21, s46, 12
; GFX9-NEXT:    s_lshr_b32 s46, s9, 16
; GFX9-NEXT:    s_add_i32 s8, s8, 3
; GFX9-NEXT:    v_writelane_b32 v21, s46, 13
; GFX9-NEXT:    s_lshr_b32 s46, s9, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 14
; GFX9-NEXT:    s_lshr_b32 s46, s8, 16
; GFX9-NEXT:    s_add_i32 s11, s11, 3
; GFX9-NEXT:    v_writelane_b32 v21, s46, 15
; GFX9-NEXT:    s_lshr_b32 s46, s8, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 16
; GFX9-NEXT:    s_lshr_b32 s46, s11, 24
; GFX9-NEXT:    v_writelane_b32 v21, s46, 17
; GFX9-NEXT:    s_lshr_b32 s46, s11, 16
; GFX9-NEXT:    s_add_i32 s10, s10, 3
; GFX9-NEXT:    v_writelane_b32 v21, s46, 18
; GFX9-NEXT:    s_lshr_b32 s46, s11, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 19
; GFX9-NEXT:    s_lshr_b32 s46, s10, 16
; GFX9-NEXT:    s_add_i32 s13, s13, 3
; GFX9-NEXT:    v_writelane_b32 v21, s46, 20
; GFX9-NEXT:    s_lshr_b32 s46, s10, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 21
; GFX9-NEXT:    s_lshr_b32 s46, s13, 24
; GFX9-NEXT:    v_writelane_b32 v21, s46, 22
; GFX9-NEXT:    s_lshr_b32 s46, s13, 16
; GFX9-NEXT:    s_add_i32 s12, s12, 3
; GFX9-NEXT:    v_writelane_b32 v21, s46, 23
; GFX9-NEXT:    s_lshr_b32 s46, s13, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 24
; GFX9-NEXT:    s_lshr_b32 s46, s12, 16
; GFX9-NEXT:    s_add_i32 s15, s15, 3
; GFX9-NEXT:    v_writelane_b32 v21, s46, 25
; GFX9-NEXT:    s_lshr_b32 s46, s12, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 26
; GFX9-NEXT:    s_lshr_b32 s46, s15, 24
; GFX9-NEXT:    v_writelane_b32 v21, s46, 27
; GFX9-NEXT:    s_lshr_b32 s46, s15, 16
; GFX9-NEXT:    s_add_i32 s14, s14, 3
; GFX9-NEXT:    v_writelane_b32 v21, s46, 28
; GFX9-NEXT:    s_lshr_b32 s46, s15, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 29
; GFX9-NEXT:    s_lshr_b32 s46, s14, 16
; GFX9-NEXT:    s_add_i32 s41, s41, 3
; GFX9-NEXT:    v_writelane_b32 v21, s46, 30
; GFX9-NEXT:    s_lshr_b32 s46, s14, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 31
; GFX9-NEXT:    s_lshr_b32 s46, s41, 24
; GFX9-NEXT:    v_writelane_b32 v21, s46, 32
; GFX9-NEXT:    s_lshr_b32 s46, s41, 16
; GFX9-NEXT:    s_add_i32 s40, s40, 3
; GFX9-NEXT:    v_writelane_b32 v21, s46, 33
; GFX9-NEXT:    s_lshr_b32 s46, s41, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 34
; GFX9-NEXT:    s_lshr_b32 s46, s40, 16
; GFX9-NEXT:    s_add_i32 s43, s43, 3
; GFX9-NEXT:    v_writelane_b32 v21, s46, 35
; GFX9-NEXT:    s_lshr_b32 s46, s40, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 36
; GFX9-NEXT:    s_lshr_b32 s46, s43, 24
; GFX9-NEXT:    v_writelane_b32 v21, s46, 37
; GFX9-NEXT:    s_lshr_b32 s46, s43, 16
; GFX9-NEXT:    s_add_i32 s42, s42, 3
; GFX9-NEXT:    v_writelane_b32 v21, s46, 38
; GFX9-NEXT:    s_lshr_b32 s46, s43, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 39
; GFX9-NEXT:    s_lshr_b32 s46, s42, 16
; GFX9-NEXT:    s_add_i32 s45, s45, 3
; GFX9-NEXT:    v_writelane_b32 v21, s46, 40
; GFX9-NEXT:    s_lshr_b32 s46, s42, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 41
; GFX9-NEXT:    s_lshr_b32 s46, s45, 24
; GFX9-NEXT:    v_writelane_b32 v21, s46, 42
; GFX9-NEXT:    s_lshr_b32 s46, s45, 16
; GFX9-NEXT:    s_add_i32 s44, s44, 3
; GFX9-NEXT:    v_writelane_b32 v21, s46, 43
; GFX9-NEXT:    s_lshr_b32 s46, s45, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 44
; GFX9-NEXT:    s_lshr_b32 s46, s44, 16
; GFX9-NEXT:    s_add_i32 s29, s29, 3
; GFX9-NEXT:    v_writelane_b32 v21, s46, 45
; GFX9-NEXT:    s_lshr_b32 s46, s44, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 46
; GFX9-NEXT:    s_lshr_b32 s46, s29, 24
; GFX9-NEXT:    v_writelane_b32 v21, s46, 47
; GFX9-NEXT:    s_lshr_b32 s46, s29, 16
; GFX9-NEXT:    s_add_i32 s28, s28, 3
; GFX9-NEXT:    v_writelane_b32 v21, s46, 48
; GFX9-NEXT:    s_lshr_b32 s46, s29, 8
; GFX9-NEXT:    v_writelane_b32 v21, s46, 49
; GFX9-NEXT:    s_lshr_b32 s46, s28, 16
; GFX9-NEXT:    v_writelane_b32 v21, s46, 50
; GFX9-NEXT:    s_lshr_b64 s[56:57], s[4:5], 24
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:    s_add_i32 s19, s19, 3
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_add_i32 s21, s21, 3
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_add_i32 s23, s23, 3
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_add_i32 s25, s25, 3
; GFX9-NEXT:    s_add_i32 s24, s24, 3
; GFX9-NEXT:    s_add_i32 s27, s27, 3
; GFX9-NEXT:    s_add_i32 s26, s26, 3
; GFX9-NEXT:    v_writelane_b32 v21, s56, 0
; GFX9-NEXT:    s_lshr_b32 s82, s28, 8
; GFX9-NEXT:    s_lshr_b32 s83, s27, 24
; GFX9-NEXT:    s_lshr_b32 s81, s27, 16
; GFX9-NEXT:    s_lshr_b32 s84, s27, 8
; GFX9-NEXT:    s_lshr_b32 s85, s26, 16
; GFX9-NEXT:    s_lshr_b32 s86, s26, 8
; GFX9-NEXT:    s_lshr_b32 s87, s25, 24
; GFX9-NEXT:    s_lshr_b32 s96, s25, 16
; GFX9-NEXT:    s_lshr_b32 s97, s25, 8
; GFX9-NEXT:    s_lshr_b32 s98, s24, 16
; GFX9-NEXT:    s_lshr_b32 s99, s24, 8
; GFX9-NEXT:    s_lshr_b32 s38, s23, 24
; GFX9-NEXT:    s_lshr_b32 s39, s23, 16
; GFX9-NEXT:    s_lshr_b32 s48, s23, 8
; GFX9-NEXT:    s_lshr_b32 s49, s22, 16
; GFX9-NEXT:    s_lshr_b32 s50, s22, 8
; GFX9-NEXT:    s_lshr_b32 s51, s21, 24
; GFX9-NEXT:    s_lshr_b32 s52, s21, 16
; GFX9-NEXT:    s_lshr_b32 s53, s21, 8
; GFX9-NEXT:    s_lshr_b32 s54, s20, 16
; GFX9-NEXT:    s_lshr_b32 s55, s20, 8
; GFX9-NEXT:    s_lshr_b32 s64, s19, 24
; GFX9-NEXT:    s_lshr_b32 s65, s19, 16
; GFX9-NEXT:    s_lshr_b32 s66, s19, 8
; GFX9-NEXT:    s_lshr_b32 s67, s18, 16
; GFX9-NEXT:    s_lshr_b32 s68, s18, 8
; GFX9-NEXT:    s_lshr_b32 s69, s17, 24
; GFX9-NEXT:    s_lshr_b32 s70, s17, 16
; GFX9-NEXT:    s_lshr_b32 s71, s17, 8
; GFX9-NEXT:    s_lshr_b32 s80, s16, 16
; GFX9-NEXT:    s_lshr_b32 s46, s16, 8
; GFX9-NEXT:    v_writelane_b32 v21, s57, 1
; GFX9-NEXT:    s_lshr_b64 s[56:57], s[6:7], 24
; GFX9-NEXT:    s_lshr_b64 s[58:59], s[8:9], 24
; GFX9-NEXT:    s_lshr_b64 s[60:61], s[10:11], 24
; GFX9-NEXT:    s_lshr_b64 s[62:63], s[12:13], 24
; GFX9-NEXT:    s_lshr_b64 s[72:73], s[14:15], 24
; GFX9-NEXT:    s_lshr_b64 s[74:75], s[40:41], 24
; GFX9-NEXT:    s_lshr_b64 s[76:77], s[42:43], 24
; GFX9-NEXT:    s_lshr_b64 s[78:79], s[44:45], 24
; GFX9-NEXT:    s_lshr_b64 s[88:89], s[28:29], 24
; GFX9-NEXT:    s_lshr_b64 s[90:91], s[26:27], 24
; GFX9-NEXT:    s_lshr_b64 s[92:93], s[24:25], 24
; GFX9-NEXT:    s_lshr_b64 s[94:95], s[22:23], 24
; GFX9-NEXT:    s_lshr_b64 s[30:31], s[20:21], 24
; GFX9-NEXT:    s_lshr_b64 s[34:35], s[18:19], 24
; GFX9-NEXT:    s_lshr_b64 s[36:37], s[16:17], 24
; GFX9-NEXT:  .LBB13_3: ; %end
; GFX9-NEXT:    s_lshl_b32 s46, s46, 8
; GFX9-NEXT:    s_and_b32 s16, s16, 0xff
; GFX9-NEXT:    s_or_b32 s16, s16, s46
; GFX9-NEXT:    s_lshl_b32 s46, s36, 8
; GFX9-NEXT:    s_and_b32 s47, s80, 0xff
; GFX9-NEXT:    s_or_b32 s46, s47, s46
; GFX9-NEXT:    s_and_b32 s16, s16, 0xffff
; GFX9-NEXT:    s_lshl_b32 s46, s46, 16
; GFX9-NEXT:    s_or_b32 s16, s16, s46
; GFX9-NEXT:    v_mov_b32_e32 v1, s16
; GFX9-NEXT:    s_and_b32 s16, s17, 0xff
; GFX9-NEXT:    s_lshl_b32 s17, s71, 8
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    s_and_b32 s17, s70, 0xff
; GFX9-NEXT:    s_lshl_b32 s46, s69, 8
; GFX9-NEXT:    s_or_b32 s17, s17, s46
; GFX9-NEXT:    s_and_b32 s16, s16, 0xffff
; GFX9-NEXT:    s_lshl_b32 s17, s17, 16
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s16
; GFX9-NEXT:    s_lshl_b32 s16, s68, 8
; GFX9-NEXT:    s_and_b32 s17, s18, 0xff
; GFX9-NEXT:    s_or_b32 s16, s17, s16
; GFX9-NEXT:    s_lshl_b32 s17, s34, 8
; GFX9-NEXT:    s_and_b32 s18, s67, 0xff
; GFX9-NEXT:    s_or_b32 s17, s18, s17
; GFX9-NEXT:    s_and_b32 s16, s16, 0xffff
; GFX9-NEXT:    s_lshl_b32 s17, s17, 16
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    v_mov_b32_e32 v3, s16
; GFX9-NEXT:    s_and_b32 s16, s19, 0xff
; GFX9-NEXT:    s_lshl_b32 s17, s66, 8
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    s_and_b32 s17, s65, 0xff
; GFX9-NEXT:    s_lshl_b32 s18, s64, 8
; GFX9-NEXT:    s_or_b32 s17, s17, s18
; GFX9-NEXT:    s_and_b32 s16, s16, 0xffff
; GFX9-NEXT:    s_lshl_b32 s17, s17, 16
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    v_mov_b32_e32 v4, s16
; GFX9-NEXT:    s_lshl_b32 s16, s55, 8
; GFX9-NEXT:    s_and_b32 s17, s20, 0xff
; GFX9-NEXT:    s_or_b32 s16, s17, s16
; GFX9-NEXT:    s_lshl_b32 s17, s30, 8
; GFX9-NEXT:    s_and_b32 s18, s54, 0xff
; GFX9-NEXT:    s_or_b32 s17, s18, s17
; GFX9-NEXT:    s_and_b32 s16, s16, 0xffff
; GFX9-NEXT:    s_lshl_b32 s17, s17, 16
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    v_mov_b32_e32 v5, s16
; GFX9-NEXT:    s_and_b32 s16, s21, 0xff
; GFX9-NEXT:    s_lshl_b32 s17, s53, 8
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    s_and_b32 s17, s52, 0xff
; GFX9-NEXT:    s_lshl_b32 s18, s51, 8
; GFX9-NEXT:    s_or_b32 s17, s17, s18
; GFX9-NEXT:    s_and_b32 s16, s16, 0xffff
; GFX9-NEXT:    s_lshl_b32 s17, s17, 16
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    v_mov_b32_e32 v6, s16
; GFX9-NEXT:    s_lshl_b32 s16, s50, 8
; GFX9-NEXT:    s_and_b32 s17, s22, 0xff
; GFX9-NEXT:    s_or_b32 s16, s17, s16
; GFX9-NEXT:    s_lshl_b32 s17, s94, 8
; GFX9-NEXT:    s_and_b32 s18, s49, 0xff
; GFX9-NEXT:    s_or_b32 s17, s18, s17
; GFX9-NEXT:    s_and_b32 s16, s16, 0xffff
; GFX9-NEXT:    s_lshl_b32 s17, s17, 16
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    v_mov_b32_e32 v7, s16
; GFX9-NEXT:    s_and_b32 s16, s23, 0xff
; GFX9-NEXT:    s_lshl_b32 s17, s48, 8
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    s_and_b32 s17, s39, 0xff
; GFX9-NEXT:    s_lshl_b32 s18, s38, 8
; GFX9-NEXT:    s_or_b32 s17, s17, s18
; GFX9-NEXT:    s_and_b32 s16, s16, 0xffff
; GFX9-NEXT:    s_lshl_b32 s17, s17, 16
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    v_mov_b32_e32 v8, s16
; GFX9-NEXT:    s_lshl_b32 s16, s99, 8
; GFX9-NEXT:    s_and_b32 s17, s24, 0xff
; GFX9-NEXT:    s_or_b32 s16, s17, s16
; GFX9-NEXT:    s_lshl_b32 s17, s92, 8
; GFX9-NEXT:    s_and_b32 s18, s98, 0xff
; GFX9-NEXT:    s_or_b32 s17, s18, s17
; GFX9-NEXT:    s_and_b32 s16, s16, 0xffff
; GFX9-NEXT:    s_lshl_b32 s17, s17, 16
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    v_mov_b32_e32 v9, s16
; GFX9-NEXT:    s_and_b32 s16, s25, 0xff
; GFX9-NEXT:    s_lshl_b32 s17, s97, 8
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    s_and_b32 s17, s96, 0xff
; GFX9-NEXT:    s_lshl_b32 s18, s87, 8
; GFX9-NEXT:    s_or_b32 s17, s17, s18
; GFX9-NEXT:    s_and_b32 s16, s16, 0xffff
; GFX9-NEXT:    s_lshl_b32 s17, s17, 16
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    v_mov_b32_e32 v10, s16
; GFX9-NEXT:    s_lshl_b32 s16, s86, 8
; GFX9-NEXT:    s_and_b32 s17, s26, 0xff
; GFX9-NEXT:    s_or_b32 s16, s17, s16
; GFX9-NEXT:    s_lshl_b32 s17, s90, 8
; GFX9-NEXT:    s_and_b32 s18, s85, 0xff
; GFX9-NEXT:    s_or_b32 s17, s18, s17
; GFX9-NEXT:    s_and_b32 s16, s16, 0xffff
; GFX9-NEXT:    s_lshl_b32 s17, s17, 16
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    v_mov_b32_e32 v11, s16
; GFX9-NEXT:    s_and_b32 s16, s27, 0xff
; GFX9-NEXT:    s_lshl_b32 s17, s84, 8
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    s_and_b32 s17, s81, 0xff
; GFX9-NEXT:    s_lshl_b32 s18, s83, 8
; GFX9-NEXT:    s_or_b32 s17, s17, s18
; GFX9-NEXT:    s_and_b32 s16, s16, 0xffff
; GFX9-NEXT:    s_lshl_b32 s17, s17, 16
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    v_mov_b32_e32 v12, s16
; GFX9-NEXT:    s_lshl_b32 s16, s82, 8
; GFX9-NEXT:    s_and_b32 s17, s28, 0xff
; GFX9-NEXT:    v_readlane_b32 s18, v21, 50
; GFX9-NEXT:    s_or_b32 s16, s17, s16
; GFX9-NEXT:    s_lshl_b32 s17, s88, 8
; GFX9-NEXT:    s_and_b32 s18, s18, 0xff
; GFX9-NEXT:    s_or_b32 s17, s18, s17
; GFX9-NEXT:    s_and_b32 s16, s16, 0xffff
; GFX9-NEXT:    s_lshl_b32 s17, s17, 16
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    v_readlane_b32 s17, v21, 49
; GFX9-NEXT:    v_mov_b32_e32 v13, s16
; GFX9-NEXT:    s_and_b32 s16, s29, 0xff
; GFX9-NEXT:    s_lshl_b32 s17, s17, 8
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    v_readlane_b32 s17, v21, 48
; GFX9-NEXT:    v_readlane_b32 s18, v21, 47
; GFX9-NEXT:    s_and_b32 s17, s17, 0xff
; GFX9-NEXT:    s_lshl_b32 s18, s18, 8
; GFX9-NEXT:    s_or_b32 s17, s17, s18
; GFX9-NEXT:    s_and_b32 s16, s16, 0xffff
; GFX9-NEXT:    s_lshl_b32 s17, s17, 16
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    v_readlane_b32 s17, v21, 46
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX9-NEXT:    buffer_store_dword v2, v0, s[0:3], 0 offen offset:4
; GFX9-NEXT:    buffer_store_dword v3, v0, s[0:3], 0 offen offset:8
; GFX9-NEXT:    buffer_store_dword v4, v0, s[0:3], 0 offen offset:12
; GFX9-NEXT:    buffer_store_dword v5, v0, s[0:3], 0 offen offset:16
; GFX9-NEXT:    buffer_store_dword v6, v0, s[0:3], 0 offen offset:20
; GFX9-NEXT:    buffer_store_dword v7, v0, s[0:3], 0 offen offset:24
; GFX9-NEXT:    buffer_store_dword v8, v0, s[0:3], 0 offen offset:28
; GFX9-NEXT:    buffer_store_dword v9, v0, s[0:3], 0 offen offset:32
; GFX9-NEXT:    buffer_store_dword v10, v0, s[0:3], 0 offen offset:36
; GFX9-NEXT:    buffer_store_dword v11, v0, s[0:3], 0 offen offset:40
; GFX9-NEXT:    buffer_store_dword v12, v0, s[0:3], 0 offen offset:44
; GFX9-NEXT:    buffer_store_dword v13, v0, s[0:3], 0 offen offset:48
; GFX9-NEXT:    v_mov_b32_e32 v1, s16
; GFX9-NEXT:    s_and_b32 s16, s44, 0xff
; GFX9-NEXT:    s_lshl_b32 s17, s17, 8
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    v_readlane_b32 s17, v21, 45
; GFX9-NEXT:    s_and_b32 s17, s17, 0xff
; GFX9-NEXT:    s_lshl_b32 s18, s78, 8
; GFX9-NEXT:    s_or_b32 s17, s17, s18
; GFX9-NEXT:    s_and_b32 s16, s16, 0xffff
; GFX9-NEXT:    s_lshl_b32 s17, s17, 16
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    v_readlane_b32 s17, v21, 44
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:52
; GFX9-NEXT:    v_mov_b32_e32 v1, s16
; GFX9-NEXT:    s_and_b32 s16, s45, 0xff
; GFX9-NEXT:    s_lshl_b32 s17, s17, 8
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    v_readlane_b32 s17, v21, 43
; GFX9-NEXT:    v_readlane_b32 s18, v21, 42
; GFX9-NEXT:    s_and_b32 s17, s17, 0xff
; GFX9-NEXT:    s_lshl_b32 s18, s18, 8
; GFX9-NEXT:    s_or_b32 s17, s17, s18
; GFX9-NEXT:    s_and_b32 s16, s16, 0xffff
; GFX9-NEXT:    s_lshl_b32 s17, s17, 16
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    v_readlane_b32 s17, v21, 41
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:56
; GFX9-NEXT:    v_mov_b32_e32 v1, s16
; GFX9-NEXT:    s_and_b32 s16, s42, 0xff
; GFX9-NEXT:    s_lshl_b32 s17, s17, 8
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    v_readlane_b32 s17, v21, 40
; GFX9-NEXT:    s_and_b32 s17, s17, 0xff
; GFX9-NEXT:    s_lshl_b32 s18, s76, 8
; GFX9-NEXT:    s_or_b32 s17, s17, s18
; GFX9-NEXT:    s_and_b32 s16, s16, 0xffff
; GFX9-NEXT:    s_lshl_b32 s17, s17, 16
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    v_readlane_b32 s17, v21, 39
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:60
; GFX9-NEXT:    v_mov_b32_e32 v1, s16
; GFX9-NEXT:    s_and_b32 s16, s43, 0xff
; GFX9-NEXT:    s_lshl_b32 s17, s17, 8
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    v_readlane_b32 s17, v21, 38
; GFX9-NEXT:    v_readlane_b32 s18, v21, 37
; GFX9-NEXT:    s_and_b32 s17, s17, 0xff
; GFX9-NEXT:    s_lshl_b32 s18, s18, 8
; GFX9-NEXT:    s_or_b32 s17, s17, s18
; GFX9-NEXT:    s_and_b32 s16, s16, 0xffff
; GFX9-NEXT:    s_lshl_b32 s17, s17, 16
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    v_readlane_b32 s17, v21, 36
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:64
; GFX9-NEXT:    v_mov_b32_e32 v1, s16
; GFX9-NEXT:    s_and_b32 s16, s40, 0xff
; GFX9-NEXT:    s_lshl_b32 s17, s17, 8
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    v_readlane_b32 s17, v21, 35
; GFX9-NEXT:    s_and_b32 s17, s17, 0xff
; GFX9-NEXT:    s_lshl_b32 s18, s74, 8
; GFX9-NEXT:    s_or_b32 s17, s17, s18
; GFX9-NEXT:    s_and_b32 s16, s16, 0xffff
; GFX9-NEXT:    s_lshl_b32 s17, s17, 16
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    v_readlane_b32 s17, v21, 34
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:68
; GFX9-NEXT:    v_mov_b32_e32 v1, s16
; GFX9-NEXT:    s_and_b32 s16, s41, 0xff
; GFX9-NEXT:    s_lshl_b32 s17, s17, 8
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    v_readlane_b32 s17, v21, 33
; GFX9-NEXT:    v_readlane_b32 s18, v21, 32
; GFX9-NEXT:    s_and_b32 s17, s17, 0xff
; GFX9-NEXT:    s_lshl_b32 s18, s18, 8
; GFX9-NEXT:    s_or_b32 s17, s17, s18
; GFX9-NEXT:    s_and_b32 s16, s16, 0xffff
; GFX9-NEXT:    s_lshl_b32 s17, s17, 16
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:72
; GFX9-NEXT:    v_mov_b32_e32 v1, s16
; GFX9-NEXT:    v_readlane_b32 s16, v21, 31
; GFX9-NEXT:    s_and_b32 s14, s14, 0xff
; GFX9-NEXT:    s_lshl_b32 s16, s16, 8
; GFX9-NEXT:    s_or_b32 s14, s14, s16
; GFX9-NEXT:    v_readlane_b32 s16, v21, 30
; GFX9-NEXT:    s_and_b32 s16, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s17, s72, 8
; GFX9-NEXT:    s_or_b32 s16, s16, s17
; GFX9-NEXT:    s_and_b32 s14, s14, 0xffff
; GFX9-NEXT:    s_lshl_b32 s16, s16, 16
; GFX9-NEXT:    s_or_b32 s14, s14, s16
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:76
; GFX9-NEXT:    v_mov_b32_e32 v1, s14
; GFX9-NEXT:    s_and_b32 s14, s15, 0xff
; GFX9-NEXT:    v_readlane_b32 s15, v21, 29
; GFX9-NEXT:    s_lshl_b32 s15, s15, 8
; GFX9-NEXT:    s_or_b32 s14, s14, s15
; GFX9-NEXT:    v_readlane_b32 s15, v21, 28
; GFX9-NEXT:    v_readlane_b32 s16, v21, 27
; GFX9-NEXT:    s_and_b32 s15, s15, 0xff
; GFX9-NEXT:    s_lshl_b32 s16, s16, 8
; GFX9-NEXT:    s_or_b32 s15, s15, s16
; GFX9-NEXT:    s_and_b32 s14, s14, 0xffff
; GFX9-NEXT:    s_lshl_b32 s15, s15, 16
; GFX9-NEXT:    s_or_b32 s14, s14, s15
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:80
; GFX9-NEXT:    v_mov_b32_e32 v1, s14
; GFX9-NEXT:    v_readlane_b32 s14, v21, 26
; GFX9-NEXT:    s_and_b32 s12, s12, 0xff
; GFX9-NEXT:    s_lshl_b32 s14, s14, 8
; GFX9-NEXT:    s_or_b32 s12, s12, s14
; GFX9-NEXT:    v_readlane_b32 s14, v21, 25
; GFX9-NEXT:    s_and_b32 s14, s14, 0xff
; GFX9-NEXT:    s_lshl_b32 s15, s62, 8
; GFX9-NEXT:    s_or_b32 s14, s14, s15
; GFX9-NEXT:    s_and_b32 s12, s12, 0xffff
; GFX9-NEXT:    s_lshl_b32 s14, s14, 16
; GFX9-NEXT:    s_or_b32 s12, s12, s14
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:84
; GFX9-NEXT:    v_mov_b32_e32 v1, s12
; GFX9-NEXT:    s_and_b32 s12, s13, 0xff
; GFX9-NEXT:    v_readlane_b32 s13, v21, 24
; GFX9-NEXT:    s_lshl_b32 s13, s13, 8
; GFX9-NEXT:    s_or_b32 s12, s12, s13
; GFX9-NEXT:    v_readlane_b32 s13, v21, 23
; GFX9-NEXT:    v_readlane_b32 s14, v21, 22
; GFX9-NEXT:    s_and_b32 s13, s13, 0xff
; GFX9-NEXT:    s_lshl_b32 s14, s14, 8
; GFX9-NEXT:    s_or_b32 s13, s13, s14
; GFX9-NEXT:    s_and_b32 s12, s12, 0xffff
; GFX9-NEXT:    s_lshl_b32 s13, s13, 16
; GFX9-NEXT:    s_or_b32 s12, s12, s13
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:88
; GFX9-NEXT:    v_mov_b32_e32 v1, s12
; GFX9-NEXT:    v_readlane_b32 s12, v21, 21
; GFX9-NEXT:    s_and_b32 s10, s10, 0xff
; GFX9-NEXT:    s_lshl_b32 s12, s12, 8
; GFX9-NEXT:    s_or_b32 s10, s10, s12
; GFX9-NEXT:    v_readlane_b32 s12, v21, 20
; GFX9-NEXT:    s_and_b32 s12, s12, 0xff
; GFX9-NEXT:    s_lshl_b32 s13, s60, 8
; GFX9-NEXT:    s_or_b32 s12, s12, s13
; GFX9-NEXT:    s_and_b32 s10, s10, 0xffff
; GFX9-NEXT:    s_lshl_b32 s12, s12, 16
; GFX9-NEXT:    s_or_b32 s10, s10, s12
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:92
; GFX9-NEXT:    v_mov_b32_e32 v1, s10
; GFX9-NEXT:    s_and_b32 s10, s11, 0xff
; GFX9-NEXT:    v_readlane_b32 s11, v21, 19
; GFX9-NEXT:    s_lshl_b32 s11, s11, 8
; GFX9-NEXT:    s_or_b32 s10, s10, s11
; GFX9-NEXT:    v_readlane_b32 s11, v21, 18
; GFX9-NEXT:    v_readlane_b32 s12, v21, 17
; GFX9-NEXT:    s_and_b32 s11, s11, 0xff
; GFX9-NEXT:    s_lshl_b32 s12, s12, 8
; GFX9-NEXT:    s_or_b32 s11, s11, s12
; GFX9-NEXT:    s_and_b32 s10, s10, 0xffff
; GFX9-NEXT:    s_lshl_b32 s11, s11, 16
; GFX9-NEXT:    s_or_b32 s10, s10, s11
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:96
; GFX9-NEXT:    v_mov_b32_e32 v1, s10
; GFX9-NEXT:    v_readlane_b32 s10, v21, 16
; GFX9-NEXT:    s_and_b32 s8, s8, 0xff
; GFX9-NEXT:    s_lshl_b32 s10, s10, 8
; GFX9-NEXT:    s_or_b32 s8, s8, s10
; GFX9-NEXT:    v_readlane_b32 s10, v21, 15
; GFX9-NEXT:    s_and_b32 s10, s10, 0xff
; GFX9-NEXT:    s_lshl_b32 s11, s58, 8
; GFX9-NEXT:    s_or_b32 s10, s10, s11
; GFX9-NEXT:    s_and_b32 s8, s8, 0xffff
; GFX9-NEXT:    s_lshl_b32 s10, s10, 16
; GFX9-NEXT:    s_or_b32 s8, s8, s10
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:100
; GFX9-NEXT:    v_mov_b32_e32 v1, s8
; GFX9-NEXT:    s_and_b32 s8, s9, 0xff
; GFX9-NEXT:    v_readlane_b32 s9, v21, 14
; GFX9-NEXT:    s_lshl_b32 s9, s9, 8
; GFX9-NEXT:    s_or_b32 s8, s8, s9
; GFX9-NEXT:    v_readlane_b32 s9, v21, 13
; GFX9-NEXT:    v_readlane_b32 s10, v21, 12
; GFX9-NEXT:    s_and_b32 s9, s9, 0xff
; GFX9-NEXT:    s_lshl_b32 s10, s10, 8
; GFX9-NEXT:    s_or_b32 s9, s9, s10
; GFX9-NEXT:    s_and_b32 s8, s8, 0xffff
; GFX9-NEXT:    s_lshl_b32 s9, s9, 16
; GFX9-NEXT:    s_or_b32 s8, s8, s9
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:104
; GFX9-NEXT:    v_mov_b32_e32 v1, s8
; GFX9-NEXT:    v_readlane_b32 s8, v21, 11
; GFX9-NEXT:    s_and_b32 s6, s6, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s8, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s8
; GFX9-NEXT:    v_readlane_b32 s8, v21, 10
; GFX9-NEXT:    s_and_b32 s8, s8, 0xff
; GFX9-NEXT:    s_lshl_b32 s9, s56, 8
; GFX9-NEXT:    s_or_b32 s8, s8, s9
; GFX9-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX9-NEXT:    s_lshl_b32 s8, s8, 16
; GFX9-NEXT:    s_or_b32 s6, s6, s8
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:108
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    s_and_b32 s6, s7, 0xff
; GFX9-NEXT:    v_readlane_b32 s7, v21, 9
; GFX9-NEXT:    s_lshl_b32 s7, s7, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    v_readlane_b32 s7, v21, 8
; GFX9-NEXT:    v_readlane_b32 s8, v21, 7
; GFX9-NEXT:    s_and_b32 s7, s7, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s8, 8
; GFX9-NEXT:    s_or_b32 s7, s7, s8
; GFX9-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX9-NEXT:    s_lshl_b32 s7, s7, 16
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:112
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    v_readlane_b32 s6, v21, 6
; GFX9-NEXT:    s_and_b32 s4, s4, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 8
; GFX9-NEXT:    s_or_b32 s4, s4, s6
; GFX9-NEXT:    v_readlane_b32 s6, v21, 5
; GFX9-NEXT:    v_readlane_b32 s8, v21, 0
; GFX9-NEXT:    s_and_b32 s6, s6, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s8, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s4, s4, s6
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:116
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    s_and_b32 s4, s5, 0xff
; GFX9-NEXT:    v_readlane_b32 s5, v21, 4
; GFX9-NEXT:    s_lshl_b32 s5, s5, 8
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    v_readlane_b32 s5, v21, 3
; GFX9-NEXT:    v_readlane_b32 s6, v21, 2
; GFX9-NEXT:    s_and_b32 s5, s5, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:120
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    v_readlane_b32 s9, v21, 1
; GFX9-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen offset:124
; GFX9-NEXT:    v_readlane_b32 s99, v20, 35
; GFX9-NEXT:    v_readlane_b32 s98, v20, 34
; GFX9-NEXT:    v_readlane_b32 s97, v20, 33
; GFX9-NEXT:    v_readlane_b32 s96, v20, 32
; GFX9-NEXT:    v_readlane_b32 s87, v20, 31
; GFX9-NEXT:    v_readlane_b32 s86, v20, 30
; GFX9-NEXT:    v_readlane_b32 s85, v20, 29
; GFX9-NEXT:    v_readlane_b32 s84, v20, 28
; GFX9-NEXT:    v_readlane_b32 s83, v20, 27
; GFX9-NEXT:    v_readlane_b32 s82, v20, 26
; GFX9-NEXT:    v_readlane_b32 s81, v20, 25
; GFX9-NEXT:    v_readlane_b32 s80, v20, 24
; GFX9-NEXT:    v_readlane_b32 s71, v20, 23
; GFX9-NEXT:    v_readlane_b32 s70, v20, 22
; GFX9-NEXT:    v_readlane_b32 s69, v20, 21
; GFX9-NEXT:    v_readlane_b32 s68, v20, 20
; GFX9-NEXT:    v_readlane_b32 s67, v20, 19
; GFX9-NEXT:    v_readlane_b32 s66, v20, 18
; GFX9-NEXT:    v_readlane_b32 s65, v20, 17
; GFX9-NEXT:    v_readlane_b32 s64, v20, 16
; GFX9-NEXT:    v_readlane_b32 s55, v20, 15
; GFX9-NEXT:    v_readlane_b32 s54, v20, 14
; GFX9-NEXT:    v_readlane_b32 s53, v20, 13
; GFX9-NEXT:    v_readlane_b32 s52, v20, 12
; GFX9-NEXT:    v_readlane_b32 s51, v20, 11
; GFX9-NEXT:    v_readlane_b32 s50, v20, 10
; GFX9-NEXT:    v_readlane_b32 s49, v20, 9
; GFX9-NEXT:    v_readlane_b32 s48, v20, 8
; GFX9-NEXT:    v_readlane_b32 s39, v20, 7
; GFX9-NEXT:    v_readlane_b32 s38, v20, 6
; GFX9-NEXT:    v_readlane_b32 s37, v20, 5
; GFX9-NEXT:    v_readlane_b32 s36, v20, 4
; GFX9-NEXT:    v_readlane_b32 s35, v20, 3
; GFX9-NEXT:    v_readlane_b32 s34, v20, 2
; GFX9-NEXT:    v_readlane_b32 s31, v20, 1
; GFX9-NEXT:    v_readlane_b32 s30, v20, 0
; GFX9-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX9-NEXT:    buffer_load_dword v20, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB13_4:
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr83
; GFX9-NEXT:    ; implicit-def: $sgpr82
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    v_writelane_b32 v21, s82, 0
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr46
; GFX9-NEXT:    ; implicit-def: $sgpr80
; GFX9-NEXT:    ; implicit-def: $sgpr71
; GFX9-NEXT:    ; implicit-def: $sgpr70
; GFX9-NEXT:    ; implicit-def: $sgpr69
; GFX9-NEXT:    ; implicit-def: $sgpr68
; GFX9-NEXT:    ; implicit-def: $sgpr67
; GFX9-NEXT:    ; implicit-def: $sgpr66
; GFX9-NEXT:    ; implicit-def: $sgpr65
; GFX9-NEXT:    ; implicit-def: $sgpr64
; GFX9-NEXT:    ; implicit-def: $sgpr55
; GFX9-NEXT:    ; implicit-def: $sgpr54
; GFX9-NEXT:    ; implicit-def: $sgpr53
; GFX9-NEXT:    ; implicit-def: $sgpr52
; GFX9-NEXT:    ; implicit-def: $sgpr51
; GFX9-NEXT:    ; implicit-def: $sgpr50
; GFX9-NEXT:    ; implicit-def: $sgpr49
; GFX9-NEXT:    ; implicit-def: $sgpr48
; GFX9-NEXT:    ; implicit-def: $sgpr39
; GFX9-NEXT:    ; implicit-def: $sgpr38
; GFX9-NEXT:    ; implicit-def: $sgpr99
; GFX9-NEXT:    ; implicit-def: $sgpr98
; GFX9-NEXT:    ; implicit-def: $sgpr97
; GFX9-NEXT:    ; implicit-def: $sgpr96
; GFX9-NEXT:    ; implicit-def: $sgpr87
; GFX9-NEXT:    ; implicit-def: $sgpr86
; GFX9-NEXT:    ; implicit-def: $sgpr85
; GFX9-NEXT:    ; implicit-def: $sgpr84
; GFX9-NEXT:    ; implicit-def: $sgpr81
; GFX9-NEXT:    ; implicit-def: $sgpr36
; GFX9-NEXT:    ; implicit-def: $sgpr34
; GFX9-NEXT:    ; implicit-def: $sgpr30
; GFX9-NEXT:    ; implicit-def: $sgpr94
; GFX9-NEXT:    ; implicit-def: $sgpr92
; GFX9-NEXT:    ; implicit-def: $sgpr90
; GFX9-NEXT:    ; implicit-def: $sgpr88
; GFX9-NEXT:    ; implicit-def: $sgpr78
; GFX9-NEXT:    ; implicit-def: $sgpr76
; GFX9-NEXT:    ; implicit-def: $sgpr74
; GFX9-NEXT:    ; implicit-def: $sgpr72
; GFX9-NEXT:    ; implicit-def: $sgpr62
; GFX9-NEXT:    ; implicit-def: $sgpr60
; GFX9-NEXT:    ; implicit-def: $sgpr58
; GFX9-NEXT:    ; implicit-def: $sgpr56
; GFX9-NEXT:    v_writelane_b32 v21, s83, 1
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr82
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; kill: killed $sgpr47
; GFX9-NEXT:    s_branch .LBB13_2
;
; GFX11-LABEL: bitcast_v32i32_to_v128i8_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_xor_saveexec_b32 s4, -1
; GFX11-NEXT:    s_clause 0x3
; GFX11-NEXT:    scratch_store_b32 off, v16, s32
; GFX11-NEXT:    scratch_store_b32 off, v17, s32 offset:4
; GFX11-NEXT:    scratch_store_b32 off, v18, s32 offset:8
; GFX11-NEXT:    scratch_store_b32 off, v19, s32 offset:12
; GFX11-NEXT:    s_mov_b32 exec_lo, s4
; GFX11-NEXT:    v_writelane_b32 v16, s30, 0
; GFX11-NEXT:    v_writelane_b32 v17, s96, 0
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v15
; GFX11-NEXT:    v_readfirstlane_b32 s40, v1
; GFX11-NEXT:    v_readfirstlane_b32 s41, v2
; GFX11-NEXT:    v_writelane_b32 v16, s31, 1
; GFX11-NEXT:    v_writelane_b32 v17, s97, 1
; GFX11-NEXT:    v_readfirstlane_b32 s14, v3
; GFX11-NEXT:    v_readfirstlane_b32 s15, v4
; GFX11-NEXT:    v_readfirstlane_b32 s12, v5
; GFX11-NEXT:    v_writelane_b32 v16, s34, 2
; GFX11-NEXT:    v_writelane_b32 v17, s98, 2
; GFX11-NEXT:    v_readfirstlane_b32 s13, v6
; GFX11-NEXT:    v_readfirstlane_b32 s10, v7
; GFX11-NEXT:    v_readfirstlane_b32 s11, v8
; GFX11-NEXT:    v_writelane_b32 v16, s35, 3
; GFX11-NEXT:    v_writelane_b32 v17, s99, 3
; GFX11-NEXT:    v_readfirstlane_b32 s8, v9
; GFX11-NEXT:    v_readfirstlane_b32 s9, v10
; GFX11-NEXT:    v_readfirstlane_b32 s6, v11
; GFX11-NEXT:    v_writelane_b32 v16, s36, 4
; GFX11-NEXT:    v_writelane_b32 v17, s100, 4
; GFX11-NEXT:    v_readfirstlane_b32 s7, v12
; GFX11-NEXT:    v_readfirstlane_b32 s4, v13
; GFX11-NEXT:    v_readfirstlane_b32 s5, v14
; GFX11-NEXT:    v_writelane_b32 v16, s37, 5
; GFX11-NEXT:    v_writelane_b32 v17, s101, 5
; GFX11-NEXT:    s_mov_b32 s101, 0
; GFX11-NEXT:    s_and_b32 s42, vcc_lo, exec_lo
; GFX11-NEXT:    ; implicit-def: $vgpr19 : SGPR spill to VGPR lane
; GFX11-NEXT:    ; implicit-def: $vgpr18 : SGPR spill to VGPR lane
; GFX11-NEXT:    v_writelane_b32 v16, s38, 6
; GFX11-NEXT:    v_writelane_b32 v17, s102, 6
; GFX11-NEXT:    v_writelane_b32 v16, s39, 7
; GFX11-NEXT:    v_writelane_b32 v17, s103, 7
; GFX11-NEXT:    v_writelane_b32 v16, s48, 8
; GFX11-NEXT:    v_writelane_b32 v17, s104, 8
; GFX11-NEXT:    v_writelane_b32 v16, s49, 9
; GFX11-NEXT:    v_writelane_b32 v16, s50, 10
; GFX11-NEXT:    v_writelane_b32 v16, s51, 11
; GFX11-NEXT:    v_writelane_b32 v16, s52, 12
; GFX11-NEXT:    v_writelane_b32 v16, s53, 13
; GFX11-NEXT:    v_writelane_b32 v16, s54, 14
; GFX11-NEXT:    v_writelane_b32 v16, s55, 15
; GFX11-NEXT:    v_writelane_b32 v16, s64, 16
; GFX11-NEXT:    v_writelane_b32 v16, s65, 17
; GFX11-NEXT:    v_writelane_b32 v16, s66, 18
; GFX11-NEXT:    v_writelane_b32 v16, s67, 19
; GFX11-NEXT:    v_writelane_b32 v16, s68, 20
; GFX11-NEXT:    v_writelane_b32 v16, s69, 21
; GFX11-NEXT:    v_writelane_b32 v16, s70, 22
; GFX11-NEXT:    v_writelane_b32 v16, s71, 23
; GFX11-NEXT:    v_writelane_b32 v16, s80, 24
; GFX11-NEXT:    v_writelane_b32 v16, s81, 25
; GFX11-NEXT:    v_writelane_b32 v16, s82, 26
; GFX11-NEXT:    v_writelane_b32 v16, s83, 27
; GFX11-NEXT:    v_writelane_b32 v16, s84, 28
; GFX11-NEXT:    v_writelane_b32 v16, s85, 29
; GFX11-NEXT:    v_writelane_b32 v16, s86, 30
; GFX11-NEXT:    v_writelane_b32 v16, s87, 31
; GFX11-NEXT:    s_cbranch_scc0 .LBB13_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_lshr_b32 s43, s25, 8
; GFX11-NEXT:    s_lshr_b64 s[62:63], s[4:5], 24
; GFX11-NEXT:    v_writelane_b32 v19, s43, 16
; GFX11-NEXT:    s_lshr_b32 s43, s24, 16
; GFX11-NEXT:    s_lshr_b32 s104, s5, 24
; GFX11-NEXT:    s_lshr_b32 s102, s5, 16
; GFX11-NEXT:    s_lshr_b32 s103, s5, 8
; GFX11-NEXT:    v_writelane_b32 v19, s43, 17
; GFX11-NEXT:    s_lshr_b32 s43, s24, 8
; GFX11-NEXT:    s_lshr_b32 s57, s4, 16
; GFX11-NEXT:    s_lshr_b32 s47, s4, 8
; GFX11-NEXT:    s_lshr_b32 s46, s7, 24
; GFX11-NEXT:    v_writelane_b32 v19, s43, 18
; GFX11-NEXT:    s_lshr_b32 s43, s23, 24
; GFX11-NEXT:    s_lshr_b32 vcc_hi, s7, 16
; GFX11-NEXT:    s_lshr_b32 s34, s7, 8
; GFX11-NEXT:    s_lshr_b32 s69, s6, 16
; GFX11-NEXT:    v_writelane_b32 v19, s43, 19
; GFX11-NEXT:    s_lshr_b32 s43, s23, 16
; GFX11-NEXT:    s_lshr_b32 s56, s6, 8
; GFX11-NEXT:    s_lshr_b32 s35, s9, 24
; GFX11-NEXT:    s_lshr_b32 s36, s9, 16
; GFX11-NEXT:    v_writelane_b32 v19, s43, 20
; GFX11-NEXT:    s_lshr_b32 s43, s23, 8
; GFX11-NEXT:    s_lshr_b32 s37, s9, 8
; GFX11-NEXT:    s_lshr_b32 s38, s8, 16
; GFX11-NEXT:    s_lshr_b32 s39, s8, 8
; GFX11-NEXT:    v_writelane_b32 v19, s43, 21
; GFX11-NEXT:    s_lshr_b32 s43, s22, 16
; GFX11-NEXT:    s_lshr_b32 s48, s11, 24
; GFX11-NEXT:    s_lshr_b32 s49, s11, 16
; GFX11-NEXT:    s_lshr_b32 s50, s11, 8
; GFX11-NEXT:    v_writelane_b32 v19, s43, 22
; GFX11-NEXT:    s_lshr_b32 s43, s22, 8
; GFX11-NEXT:    s_lshr_b32 s51, s10, 16
; GFX11-NEXT:    s_lshr_b32 s52, s10, 8
; GFX11-NEXT:    s_lshr_b32 s53, s13, 24
; GFX11-NEXT:    v_writelane_b32 v19, s43, 23
; GFX11-NEXT:    s_lshr_b32 s43, s21, 24
; GFX11-NEXT:    s_lshr_b32 s54, s13, 16
; GFX11-NEXT:    s_lshr_b32 s55, s13, 8
; GFX11-NEXT:    s_lshr_b32 s64, s12, 16
; GFX11-NEXT:    v_writelane_b32 v19, s43, 24
; GFX11-NEXT:    s_lshr_b32 s43, s21, 16
; GFX11-NEXT:    s_lshr_b32 s65, s12, 8
; GFX11-NEXT:    s_lshr_b32 s66, s15, 24
; GFX11-NEXT:    s_lshr_b32 s67, s15, 16
; GFX11-NEXT:    v_writelane_b32 v19, s43, 25
; GFX11-NEXT:    s_lshr_b32 s43, s21, 8
; GFX11-NEXT:    s_lshr_b32 s68, s15, 8
; GFX11-NEXT:    s_lshr_b32 s59, s14, 16
; GFX11-NEXT:    s_lshr_b32 s58, s14, 8
; GFX11-NEXT:    v_writelane_b32 v19, s43, 26
; GFX11-NEXT:    s_lshr_b32 s43, s20, 16
; GFX11-NEXT:    s_lshr_b32 s70, s41, 24
; GFX11-NEXT:    s_lshr_b32 s71, s41, 16
; GFX11-NEXT:    s_lshr_b32 s60, s41, 8
; GFX11-NEXT:    v_writelane_b32 v19, s43, 27
; GFX11-NEXT:    s_lshr_b32 s43, s20, 8
; GFX11-NEXT:    s_lshr_b32 s80, s40, 16
; GFX11-NEXT:    s_lshr_b32 s61, s40, 8
; GFX11-NEXT:    s_lshr_b32 s81, s29, 24
; GFX11-NEXT:    v_writelane_b32 v19, s43, 28
; GFX11-NEXT:    s_lshr_b32 s43, s19, 24
; GFX11-NEXT:    s_lshr_b32 s82, s29, 16
; GFX11-NEXT:    s_lshr_b32 s83, s29, 8
; GFX11-NEXT:    s_lshr_b32 s84, s28, 16
; GFX11-NEXT:    v_writelane_b32 v19, s43, 29
; GFX11-NEXT:    s_lshr_b32 s43, s19, 16
; GFX11-NEXT:    s_lshr_b32 s85, s28, 8
; GFX11-NEXT:    s_lshr_b32 s86, s27, 24
; GFX11-NEXT:    s_lshr_b32 s72, s27, 16
; GFX11-NEXT:    v_writelane_b32 v19, s43, 30
; GFX11-NEXT:    s_lshr_b32 s43, s19, 8
; GFX11-NEXT:    s_lshr_b32 s87, s27, 8
; GFX11-NEXT:    s_lshr_b32 s73, s26, 16
; GFX11-NEXT:    s_lshr_b32 s96, s26, 8
; GFX11-NEXT:    v_writelane_b32 v19, s43, 31
; GFX11-NEXT:    s_lshr_b32 s43, s18, 16
; GFX11-NEXT:    s_lshr_b32 s97, s25, 24
; GFX11-NEXT:    v_writelane_b32 v18, s43, 0
; GFX11-NEXT:    s_lshr_b32 s43, s18, 8
; GFX11-NEXT:    v_writelane_b32 v19, s62, 14
; GFX11-NEXT:    s_lshr_b32 s42, s25, 16
; GFX11-NEXT:    s_lshr_b32 s74, s2, 16
; GFX11-NEXT:    v_writelane_b32 v18, s43, 1
; GFX11-NEXT:    s_lshr_b32 s43, s17, 24
; GFX11-NEXT:    v_writelane_b32 v19, s63, 15
; GFX11-NEXT:    s_lshr_b64 s[62:63], s[6:7], 24
; GFX11-NEXT:    s_lshr_b32 s98, s1, 24
; GFX11-NEXT:    v_writelane_b32 v18, s43, 2
; GFX11-NEXT:    s_lshr_b32 s43, s17, 16
; GFX11-NEXT:    v_writelane_b32 v19, s62, 12
; GFX11-NEXT:    s_lshr_b32 s99, s1, 16
; GFX11-NEXT:    s_lshr_b32 s100, s1, 8
; GFX11-NEXT:    v_writelane_b32 v18, s43, 3
; GFX11-NEXT:    s_lshr_b32 s43, s17, 8
; GFX11-NEXT:    v_writelane_b32 v19, s63, 13
; GFX11-NEXT:    s_lshr_b64 s[62:63], s[8:9], 24
; GFX11-NEXT:    s_lshr_b32 s44, s0, 16
; GFX11-NEXT:    v_writelane_b32 v18, s43, 4
; GFX11-NEXT:    s_lshr_b32 s43, s16, 16
; GFX11-NEXT:    v_writelane_b32 v19, s62, 10
; GFX11-NEXT:    s_lshr_b32 s45, s0, 8
; GFX11-NEXT:    s_lshr_b64 s[76:77], s[26:27], 24
; GFX11-NEXT:    v_writelane_b32 v18, s43, 5
; GFX11-NEXT:    s_lshr_b32 s43, s16, 8
; GFX11-NEXT:    v_writelane_b32 v19, s63, 11
; GFX11-NEXT:    s_lshr_b64 s[62:63], s[10:11], 24
; GFX11-NEXT:    s_lshr_b64 s[88:89], s[24:25], 24
; GFX11-NEXT:    v_writelane_b32 v18, s43, 6
; GFX11-NEXT:    s_lshr_b32 s43, s3, 24
; GFX11-NEXT:    v_writelane_b32 v19, s62, 8
; GFX11-NEXT:    s_lshr_b64 s[78:79], s[20:21], 24
; GFX11-NEXT:    s_lshr_b64 s[90:91], s[18:19], 24
; GFX11-NEXT:    v_writelane_b32 v18, s43, 7
; GFX11-NEXT:    s_lshr_b32 s43, s3, 16
; GFX11-NEXT:    v_writelane_b32 v19, s63, 9
; GFX11-NEXT:    s_lshr_b64 s[62:63], s[12:13], 24
; GFX11-NEXT:    s_lshr_b64 s[92:93], s[16:17], 24
; GFX11-NEXT:    v_writelane_b32 v18, s43, 8
; GFX11-NEXT:    s_lshr_b32 s43, s3, 8
; GFX11-NEXT:    v_writelane_b32 v19, s62, 6
; GFX11-NEXT:    s_lshr_b64 s[94:95], s[2:3], 24
; GFX11-NEXT:    s_lshr_b64 s[30:31], s[0:1], 24
; GFX11-NEXT:    v_writelane_b32 v18, s43, 9
; GFX11-NEXT:    s_lshr_b32 s43, s2, 8
; GFX11-NEXT:    v_writelane_b32 v19, s63, 7
; GFX11-NEXT:    s_lshr_b64 s[62:63], s[14:15], 24
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_2) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    v_writelane_b32 v19, s62, 4
; GFX11-NEXT:    v_writelane_b32 v19, s63, 5
; GFX11-NEXT:    s_lshr_b64 s[62:63], s[40:41], 24
; GFX11-NEXT:    v_writelane_b32 v19, s62, 2
; GFX11-NEXT:    v_writelane_b32 v19, s63, 3
; GFX11-NEXT:    s_lshr_b64 s[62:63], s[28:29], 24
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_writelane_b32 v19, s62, 0
; GFX11-NEXT:    v_writelane_b32 v19, s63, 1
; GFX11-NEXT:    s_lshr_b64 s[62:63], s[22:23], 24
; GFX11-NEXT:    s_branch .LBB13_3
; GFX11-NEXT:  .LBB13_2:
; GFX11-NEXT:    ; implicit-def: $vcc_hi
; GFX11-NEXT:    ; implicit-def: $vcc_lo
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; kill: killed $sgpr42
; GFX11-NEXT:    s_mov_b32 s101, -1
; GFX11-NEXT:    v_writelane_b32 v19, vcc_lo, 0
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; kill: killed $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; kill: killed $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; kill: killed $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; kill: killed $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    v_writelane_b32 v19, vcc_hi, 1
; GFX11-NEXT:    ; implicit-def: $vcc_lo
; GFX11-NEXT:    ; kill: killed $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; kill: killed $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; kill: killed $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; kill: killed $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; kill: killed $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    v_writelane_b32 v19, vcc_lo, 2
; GFX11-NEXT:    ; kill: killed $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; kill: killed $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; kill: killed $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; kill: killed $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; kill: killed $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    v_writelane_b32 v19, vcc_hi, 3
; GFX11-NEXT:    ; implicit-def: $vcc_lo
; GFX11-NEXT:    ; kill: killed $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; kill: killed $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; kill: killed $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; kill: killed $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; kill: killed $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    v_writelane_b32 v19, vcc_lo, 4
; GFX11-NEXT:    ; kill: killed $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; kill: killed $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; kill: killed $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; kill: killed $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; kill: killed $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    v_writelane_b32 v19, vcc_hi, 5
; GFX11-NEXT:    ; implicit-def: $vcc_lo
; GFX11-NEXT:    ; implicit-def: $sgpr45
; GFX11-NEXT:    ; implicit-def: $sgpr44
; GFX11-NEXT:    ; implicit-def: $sgpr30
; GFX11-NEXT:    ; implicit-def: $sgpr100
; GFX11-NEXT:    ; implicit-def: $sgpr99
; GFX11-NEXT:    ; implicit-def: $sgpr98
; GFX11-NEXT:    ; implicit-def: $sgpr43
; GFX11-NEXT:    ; implicit-def: $sgpr74
; GFX11-NEXT:    ; implicit-def: $sgpr94
; GFX11-NEXT:    ; implicit-def: $sgpr92
; GFX11-NEXT:    ; implicit-def: $sgpr90
; GFX11-NEXT:    ; implicit-def: $sgpr78
; GFX11-NEXT:    ; implicit-def: $sgpr62
; GFX11-NEXT:    ; kill: killed $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr97
; GFX11-NEXT:    ; implicit-def: $sgpr96
; GFX11-NEXT:    ; implicit-def: $sgpr73
; GFX11-NEXT:    ; implicit-def: $sgpr87
; GFX11-NEXT:    ; implicit-def: $sgpr72
; GFX11-NEXT:    ; implicit-def: $sgpr86
; GFX11-NEXT:    ; implicit-def: $sgpr85
; GFX11-NEXT:    ; implicit-def: $sgpr84
; GFX11-NEXT:    ; implicit-def: $sgpr83
; GFX11-NEXT:    ; implicit-def: $sgpr82
; GFX11-NEXT:    ; implicit-def: $sgpr81
; GFX11-NEXT:    ; implicit-def: $sgpr61
; GFX11-NEXT:    ; implicit-def: $sgpr80
; GFX11-NEXT:    ; implicit-def: $sgpr60
; GFX11-NEXT:    ; implicit-def: $sgpr71
; GFX11-NEXT:    ; implicit-def: $sgpr70
; GFX11-NEXT:    ; implicit-def: $sgpr58
; GFX11-NEXT:    ; implicit-def: $sgpr59
; GFX11-NEXT:    ; implicit-def: $sgpr68
; GFX11-NEXT:    ; implicit-def: $sgpr67
; GFX11-NEXT:    ; implicit-def: $sgpr66
; GFX11-NEXT:    ; implicit-def: $sgpr65
; GFX11-NEXT:    ; implicit-def: $sgpr64
; GFX11-NEXT:    ; implicit-def: $sgpr55
; GFX11-NEXT:    ; implicit-def: $sgpr54
; GFX11-NEXT:    ; implicit-def: $sgpr53
; GFX11-NEXT:    ; implicit-def: $sgpr52
; GFX11-NEXT:    ; implicit-def: $sgpr51
; GFX11-NEXT:    ; implicit-def: $sgpr50
; GFX11-NEXT:    ; implicit-def: $sgpr49
; GFX11-NEXT:    ; implicit-def: $sgpr48
; GFX11-NEXT:    ; implicit-def: $sgpr39
; GFX11-NEXT:    ; implicit-def: $sgpr38
; GFX11-NEXT:    ; implicit-def: $sgpr37
; GFX11-NEXT:    ; implicit-def: $sgpr36
; GFX11-NEXT:    ; implicit-def: $sgpr35
; GFX11-NEXT:    ; implicit-def: $sgpr56
; GFX11-NEXT:    ; implicit-def: $sgpr69
; GFX11-NEXT:    ; implicit-def: $sgpr34
; GFX11-NEXT:    ; implicit-def: $sgpr46
; GFX11-NEXT:    ; implicit-def: $sgpr47
; GFX11-NEXT:    ; implicit-def: $sgpr57
; GFX11-NEXT:    ; implicit-def: $sgpr103
; GFX11-NEXT:    ; implicit-def: $sgpr102
; GFX11-NEXT:    ; implicit-def: $sgpr104
; GFX11-NEXT:    ; implicit-def: $sgpr88
; GFX11-NEXT:    ; implicit-def: $sgpr76
; GFX11-NEXT:    v_writelane_b32 v19, vcc_lo, 6
; GFX11-NEXT:    v_writelane_b32 v19, vcc_hi, 7
; GFX11-NEXT:    ; implicit-def: $vcc_lo
; GFX11-NEXT:    v_writelane_b32 v19, vcc_lo, 8
; GFX11-NEXT:    v_writelane_b32 v19, vcc_hi, 9
; GFX11-NEXT:    ; implicit-def: $vcc_lo
; GFX11-NEXT:    v_writelane_b32 v19, vcc_lo, 10
; GFX11-NEXT:    v_writelane_b32 v19, vcc_hi, 11
; GFX11-NEXT:    ; implicit-def: $vcc_lo
; GFX11-NEXT:    v_writelane_b32 v19, vcc_lo, 12
; GFX11-NEXT:    v_writelane_b32 v19, vcc_hi, 13
; GFX11-NEXT:    ; implicit-def: $vcc_lo
; GFX11-NEXT:    v_writelane_b32 v19, vcc_lo, 14
; GFX11-NEXT:    v_writelane_b32 v19, vcc_hi, 15
; GFX11-NEXT:  .LBB13_3: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s101
; GFX11-NEXT:    s_mov_b32 s101, s104
; GFX11-NEXT:    s_mov_b32 s104, s57
; GFX11-NEXT:    s_mov_b32 s57, s69
; GFX11-NEXT:    s_mov_b32 s69, s42
; GFX11-NEXT:    s_cbranch_vccnz .LBB13_5
; GFX11-NEXT:  ; %bb.4: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s25, s25, 3
; GFX11-NEXT:    s_add_i32 s24, s24, 3
; GFX11-NEXT:    s_lshr_b32 s42, s25, 8
; GFX11-NEXT:    s_add_i32 s23, s23, 3
; GFX11-NEXT:    v_writelane_b32 v19, s42, 16
; GFX11-NEXT:    s_lshr_b32 s42, s24, 16
; GFX11-NEXT:    s_add_i32 s22, s22, 3
; GFX11-NEXT:    s_add_i32 s21, s21, 3
; GFX11-NEXT:    s_add_i32 s20, s20, 3
; GFX11-NEXT:    v_writelane_b32 v19, s42, 17
; GFX11-NEXT:    s_lshr_b32 s42, s24, 8
; GFX11-NEXT:    s_add_i32 s19, s19, 3
; GFX11-NEXT:    s_add_i32 s5, s5, 3
; GFX11-NEXT:    s_add_i32 s4, s4, 3
; GFX11-NEXT:    v_writelane_b32 v19, s42, 18
; GFX11-NEXT:    s_lshr_b32 s42, s23, 24
; GFX11-NEXT:    s_lshr_b64 s[62:63], s[4:5], 24
; GFX11-NEXT:    s_add_i32 s7, s7, 3
; GFX11-NEXT:    s_add_i32 s6, s6, 3
; GFX11-NEXT:    v_writelane_b32 v19, s42, 19
; GFX11-NEXT:    s_lshr_b32 s42, s23, 16
; GFX11-NEXT:    s_add_i32 s9, s9, 3
; GFX11-NEXT:    s_add_i32 s8, s8, 3
; GFX11-NEXT:    s_add_i32 s11, s11, 3
; GFX11-NEXT:    v_writelane_b32 v19, s42, 20
; GFX11-NEXT:    s_lshr_b32 s42, s23, 8
; GFX11-NEXT:    s_add_i32 s10, s10, 3
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_add_i32 s13, s13, 3
; GFX11-NEXT:    v_writelane_b32 v19, s42, 21
; GFX11-NEXT:    s_lshr_b32 s42, s22, 16
; GFX11-NEXT:    s_add_i32 s12, s12, 3
; GFX11-NEXT:    s_add_i32 s17, s17, 3
; GFX11-NEXT:    s_add_i32 s15, s15, 3
; GFX11-NEXT:    v_writelane_b32 v19, s42, 22
; GFX11-NEXT:    s_lshr_b32 s42, s22, 8
; GFX11-NEXT:    s_add_i32 s14, s14, 3
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s41, s41, 3
; GFX11-NEXT:    v_writelane_b32 v19, s42, 23
; GFX11-NEXT:    s_lshr_b32 s42, s21, 24
; GFX11-NEXT:    s_add_i32 s40, s40, 3
; GFX11-NEXT:    s_add_i32 s3, s3, 3
; GFX11-NEXT:    s_add_i32 s29, s29, 3
; GFX11-NEXT:    v_writelane_b32 v19, s42, 24
; GFX11-NEXT:    s_lshr_b32 s42, s21, 16
; GFX11-NEXT:    s_add_i32 s28, s28, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:    v_writelane_b32 v19, s42, 25
; GFX11-NEXT:    s_lshr_b32 s42, s21, 8
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s27, s27, 3
; GFX11-NEXT:    s_add_i32 s26, s26, 3
; GFX11-NEXT:    v_writelane_b32 v19, s42, 26
; GFX11-NEXT:    s_lshr_b32 s42, s20, 16
; GFX11-NEXT:    s_lshr_b32 s101, s5, 24
; GFX11-NEXT:    s_lshr_b32 s102, s5, 16
; GFX11-NEXT:    s_lshr_b32 s103, s5, 8
; GFX11-NEXT:    v_writelane_b32 v19, s42, 27
; GFX11-NEXT:    s_lshr_b32 s42, s20, 8
; GFX11-NEXT:    s_lshr_b32 s104, s4, 16
; GFX11-NEXT:    s_lshr_b32 s47, s4, 8
; GFX11-NEXT:    s_lshr_b32 s46, s7, 24
; GFX11-NEXT:    v_writelane_b32 v19, s42, 28
; GFX11-NEXT:    s_lshr_b32 s42, s19, 24
; GFX11-NEXT:    s_lshr_b32 vcc_hi, s7, 16
; GFX11-NEXT:    s_lshr_b32 s34, s7, 8
; GFX11-NEXT:    s_lshr_b32 s57, s6, 16
; GFX11-NEXT:    v_writelane_b32 v19, s42, 29
; GFX11-NEXT:    s_lshr_b32 s42, s19, 16
; GFX11-NEXT:    s_lshr_b32 s56, s6, 8
; GFX11-NEXT:    s_lshr_b32 s35, s9, 24
; GFX11-NEXT:    s_lshr_b32 s36, s9, 16
; GFX11-NEXT:    v_writelane_b32 v19, s42, 30
; GFX11-NEXT:    s_lshr_b32 s42, s19, 8
; GFX11-NEXT:    s_lshr_b32 s37, s9, 8
; GFX11-NEXT:    s_lshr_b32 s38, s8, 16
; GFX11-NEXT:    s_lshr_b32 s39, s8, 8
; GFX11-NEXT:    v_writelane_b32 v19, s42, 31
; GFX11-NEXT:    s_lshr_b32 s42, s18, 16
; GFX11-NEXT:    s_lshr_b32 s48, s11, 24
; GFX11-NEXT:    v_writelane_b32 v18, s42, 0
; GFX11-NEXT:    s_lshr_b32 s42, s18, 8
; GFX11-NEXT:    v_writelane_b32 v19, s62, 14
; GFX11-NEXT:    s_lshr_b32 s49, s11, 16
; GFX11-NEXT:    s_lshr_b32 s50, s11, 8
; GFX11-NEXT:    v_writelane_b32 v18, s42, 1
; GFX11-NEXT:    s_lshr_b32 s42, s17, 24
; GFX11-NEXT:    v_writelane_b32 v19, s63, 15
; GFX11-NEXT:    s_lshr_b64 s[62:63], s[6:7], 24
; GFX11-NEXT:    s_lshr_b32 s51, s10, 16
; GFX11-NEXT:    v_writelane_b32 v18, s42, 2
; GFX11-NEXT:    s_lshr_b32 s42, s17, 16
; GFX11-NEXT:    v_writelane_b32 v19, s62, 12
; GFX11-NEXT:    s_lshr_b32 s52, s10, 8
; GFX11-NEXT:    s_lshr_b32 s53, s13, 24
; GFX11-NEXT:    v_writelane_b32 v18, s42, 3
; GFX11-NEXT:    s_lshr_b32 s42, s17, 8
; GFX11-NEXT:    v_writelane_b32 v19, s63, 13
; GFX11-NEXT:    s_lshr_b64 s[62:63], s[8:9], 24
; GFX11-NEXT:    s_lshr_b32 s54, s13, 16
; GFX11-NEXT:    v_writelane_b32 v18, s42, 4
; GFX11-NEXT:    s_lshr_b32 s42, s16, 16
; GFX11-NEXT:    v_writelane_b32 v19, s62, 10
; GFX11-NEXT:    s_lshr_b32 s55, s13, 8
; GFX11-NEXT:    s_lshr_b32 s64, s12, 16
; GFX11-NEXT:    v_writelane_b32 v18, s42, 5
; GFX11-NEXT:    s_lshr_b32 s42, s16, 8
; GFX11-NEXT:    v_writelane_b32 v19, s63, 11
; GFX11-NEXT:    s_lshr_b64 s[62:63], s[10:11], 24
; GFX11-NEXT:    s_lshr_b32 s65, s12, 8
; GFX11-NEXT:    v_writelane_b32 v18, s42, 6
; GFX11-NEXT:    s_lshr_b32 s42, s3, 24
; GFX11-NEXT:    v_writelane_b32 v19, s62, 8
; GFX11-NEXT:    s_lshr_b32 s66, s15, 24
; GFX11-NEXT:    s_lshr_b32 s67, s15, 16
; GFX11-NEXT:    v_writelane_b32 v18, s42, 7
; GFX11-NEXT:    s_lshr_b32 s42, s3, 16
; GFX11-NEXT:    v_writelane_b32 v19, s63, 9
; GFX11-NEXT:    s_lshr_b64 s[62:63], s[12:13], 24
; GFX11-NEXT:    s_lshr_b32 s68, s15, 8
; GFX11-NEXT:    v_writelane_b32 v18, s42, 8
; GFX11-NEXT:    s_lshr_b32 s59, s14, 16
; GFX11-NEXT:    v_writelane_b32 v19, s62, 6
; GFX11-NEXT:    s_lshr_b32 s58, s14, 8
; GFX11-NEXT:    s_lshr_b32 s70, s41, 24
; GFX11-NEXT:    s_lshr_b32 s71, s41, 16
; GFX11-NEXT:    s_lshr_b32 s60, s41, 8
; GFX11-NEXT:    v_writelane_b32 v19, s63, 7
; GFX11-NEXT:    s_lshr_b64 s[62:63], s[14:15], 24
; GFX11-NEXT:    s_lshr_b32 s80, s40, 16
; GFX11-NEXT:    s_lshr_b32 s61, s40, 8
; GFX11-NEXT:    s_lshr_b32 s81, s29, 24
; GFX11-NEXT:    v_writelane_b32 v19, s62, 4
; GFX11-NEXT:    s_lshr_b32 s82, s29, 16
; GFX11-NEXT:    s_lshr_b32 s83, s29, 8
; GFX11-NEXT:    s_lshr_b32 s84, s28, 16
; GFX11-NEXT:    s_lshr_b32 s85, s28, 8
; GFX11-NEXT:    v_writelane_b32 v19, s63, 5
; GFX11-NEXT:    s_lshr_b64 s[62:63], s[40:41], 24
; GFX11-NEXT:    s_lshr_b32 s86, s27, 24
; GFX11-NEXT:    s_lshr_b32 s72, s27, 16
; GFX11-NEXT:    s_lshr_b32 s87, s27, 8
; GFX11-NEXT:    v_writelane_b32 v19, s62, 2
; GFX11-NEXT:    s_lshr_b32 s73, s26, 16
; GFX11-NEXT:    s_lshr_b32 s96, s26, 8
; GFX11-NEXT:    s_lshr_b32 s97, s25, 24
; GFX11-NEXT:    s_lshr_b32 s69, s25, 16
; GFX11-NEXT:    v_writelane_b32 v19, s63, 3
; GFX11-NEXT:    s_lshr_b64 s[62:63], s[28:29], 24
; GFX11-NEXT:    s_lshr_b32 s42, s3, 8
; GFX11-NEXT:    s_lshr_b32 s74, s2, 16
; GFX11-NEXT:    s_lshr_b32 s43, s2, 8
; GFX11-NEXT:    v_writelane_b32 v19, s62, 0
; GFX11-NEXT:    s_lshr_b32 s98, s1, 24
; GFX11-NEXT:    s_lshr_b32 s99, s1, 16
; GFX11-NEXT:    s_lshr_b32 s100, s1, 8
; GFX11-NEXT:    s_lshr_b32 s44, s0, 16
; GFX11-NEXT:    s_lshr_b32 s45, s0, 8
; GFX11-NEXT:    v_writelane_b32 v19, s63, 1
; GFX11-NEXT:    s_lshr_b64 s[76:77], s[26:27], 24
; GFX11-NEXT:    s_lshr_b64 s[88:89], s[24:25], 24
; GFX11-NEXT:    s_lshr_b64 s[62:63], s[22:23], 24
; GFX11-NEXT:    s_lshr_b64 s[78:79], s[20:21], 24
; GFX11-NEXT:    s_lshr_b64 s[90:91], s[18:19], 24
; GFX11-NEXT:    s_lshr_b64 s[92:93], s[16:17], 24
; GFX11-NEXT:    s_lshr_b64 s[94:95], s[2:3], 24
; GFX11-NEXT:    s_lshr_b64 s[30:31], s[0:1], 24
; GFX11-NEXT:    v_writelane_b32 v18, s42, 9
; GFX11-NEXT:  .LBB13_5: ; %end
; GFX11-NEXT:    s_lshl_b32 s43, s43, 8
; GFX11-NEXT:    s_and_b32 s2, s2, 0xff
; GFX11-NEXT:    s_and_b32 s42, s74, 0xff
; GFX11-NEXT:    s_or_b32 s2, s2, s43
; GFX11-NEXT:    s_lshl_b32 s43, s94, 8
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_or_b32 s42, s42, s43
; GFX11-NEXT:    s_lshl_b32 s45, s45, 8
; GFX11-NEXT:    s_lshl_b32 s42, s42, 16
; GFX11-NEXT:    s_and_b32 s0, s0, 0xff
; GFX11-NEXT:    s_or_b32 s2, s2, s42
; GFX11-NEXT:    v_readlane_b32 s42, v18, 9
; GFX11-NEXT:    s_or_b32 s0, s0, s45
; GFX11-NEXT:    s_lshl_b32 s45, s30, 8
; GFX11-NEXT:    s_and_b32 s44, s44, 0xff
; GFX11-NEXT:    s_and_b32 s3, s3, 0xff
; GFX11-NEXT:    s_or_b32 s44, s44, s45
; GFX11-NEXT:    s_lshl_b32 s42, s42, 8
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s44, s44, 16
; GFX11-NEXT:    s_or_b32 s3, s3, s42
; GFX11-NEXT:    v_readlane_b32 s42, v18, 8
; GFX11-NEXT:    v_readlane_b32 s43, v18, 7
; GFX11-NEXT:    s_or_b32 s0, s0, s44
; GFX11-NEXT:    s_and_b32 s1, s1, 0xff
; GFX11-NEXT:    s_lshl_b32 s44, s100, 8
; GFX11-NEXT:    s_lshl_b32 s45, s98, 8
; GFX11-NEXT:    s_or_b32 s1, s1, s44
; GFX11-NEXT:    s_and_b32 s44, s99, 0xff
; GFX11-NEXT:    s_and_b32 s42, s42, 0xff
; GFX11-NEXT:    s_or_b32 s44, s44, s45
; GFX11-NEXT:    s_lshl_b32 s43, s43, 8
; GFX11-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX11-NEXT:    s_lshl_b32 s44, s44, 16
; GFX11-NEXT:    s_or_b32 s42, s42, s43
; GFX11-NEXT:    s_or_b32 s1, s1, s44
; GFX11-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX11-NEXT:    s_lshl_b32 s42, s42, 16
; GFX11-NEXT:    v_dual_mov_b32 v1, s0 :: v_dual_mov_b32 v2, s1
; GFX11-NEXT:    v_readlane_b32 s0, v18, 6
; GFX11-NEXT:    s_or_b32 s3, s3, s42
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v3, s2 :: v_dual_mov_b32 v4, s3
; GFX11-NEXT:    v_readlane_b32 s2, v18, 5
; GFX11-NEXT:    s_lshl_b32 s0, s0, 8
; GFX11-NEXT:    s_and_b32 s1, s16, 0xff
; GFX11-NEXT:    v_readlane_b32 s3, v18, 2
; GFX11-NEXT:    s_or_b32 s0, s1, s0
; GFX11-NEXT:    s_lshl_b32 s1, s92, 8
; GFX11-NEXT:    s_and_b32 s2, s2, 0xff
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_or_b32 s1, s2, s1
; GFX11-NEXT:    v_readlane_b32 s2, v18, 4
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_lshl_b32 s3, s3, 8
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_and_b32 s1, s17, 0xff
; GFX11-NEXT:    s_lshl_b32 s2, s2, 8
; GFX11-NEXT:    v_readlane_b32 s16, v18, 0
; GFX11-NEXT:    s_or_b32 s1, s1, s2
; GFX11-NEXT:    v_readlane_b32 s2, v18, 3
; GFX11-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX11-NEXT:    v_readlane_b32 s17, v19, 29
; GFX11-NEXT:    s_and_b32 s16, s16, 0xff
; GFX11-NEXT:    v_readlane_b32 s100, v17, 4
; GFX11-NEXT:    s_and_b32 s2, s2, 0xff
; GFX11-NEXT:    v_readlane_b32 s99, v17, 3
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_and_b32 s3, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s2, s2, 16
; GFX11-NEXT:    s_lshl_b32 s17, s17, 8
; GFX11-NEXT:    s_or_b32 s1, s1, s2
; GFX11-NEXT:    v_readlane_b32 s2, v18, 1
; GFX11-NEXT:    v_dual_mov_b32 v5, s0 :: v_dual_mov_b32 v6, s1
; GFX11-NEXT:    v_readlane_b32 s0, v19, 28
; GFX11-NEXT:    s_and_b32 s1, s20, 0xff
; GFX11-NEXT:    s_lshl_b32 s2, s2, 8
; GFX11-NEXT:    v_readlane_b32 s18, v19, 19
; GFX11-NEXT:    s_or_b32 s2, s3, s2
; GFX11-NEXT:    s_lshl_b32 s3, s90, 8
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_or_b32 s3, s16, s3
; GFX11-NEXT:    v_readlane_b32 s16, v19, 31
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_lshl_b32 s0, s0, 8
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_and_b32 s3, s19, 0xff
; GFX11-NEXT:    s_lshl_b32 s16, s16, 8
; GFX11-NEXT:    s_or_b32 s0, s1, s0
; GFX11-NEXT:    s_or_b32 s3, s3, s16
; GFX11-NEXT:    v_readlane_b32 s16, v19, 30
; GFX11-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s78, 8
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s18, s18, 8
; GFX11-NEXT:    s_and_b32 s16, s16, 0xff
; GFX11-NEXT:    s_lshl_b32 s19, s86, 8
; GFX11-NEXT:    s_or_b32 s16, s16, s17
; GFX11-NEXT:    v_readlane_b32 s17, v19, 21
; GFX11-NEXT:    s_lshl_b32 s16, s16, 16
; GFX11-NEXT:    v_readlane_b32 s98, v17, 2
; GFX11-NEXT:    s_or_b32 s3, s3, s16
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v7, s2 :: v_dual_mov_b32 v8, s3
; GFX11-NEXT:    v_readlane_b32 s2, v19, 27
; GFX11-NEXT:    v_readlane_b32 s3, v19, 24
; GFX11-NEXT:    v_readlane_b32 s16, v19, 22
; GFX11-NEXT:    s_lshl_b32 s17, s17, 8
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    scratch_store_b128 v0, v[1:4], off
; GFX11-NEXT:    scratch_store_b128 v0, v[5:8], off offset:16
; GFX11-NEXT:    s_and_b32 s2, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 8
; GFX11-NEXT:    s_or_b32 s1, s2, s1
; GFX11-NEXT:    v_readlane_b32 s2, v19, 26
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_and_b32 s16, s16, 0xff
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_and_b32 s1, s21, 0xff
; GFX11-NEXT:    s_lshl_b32 s2, s2, 8
; GFX11-NEXT:    v_readlane_b32 s86, v16, 30
; GFX11-NEXT:    s_or_b32 s1, s1, s2
; GFX11-NEXT:    v_readlane_b32 s2, v19, 25
; GFX11-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX11-NEXT:    v_readlane_b32 s31, v16, 1
; GFX11-NEXT:    v_readlane_b32 s30, v16, 0
; GFX11-NEXT:    s_and_b32 s2, s2, 0xff
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_2) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_and_b32 s3, s22, 0xff
; GFX11-NEXT:    s_lshl_b32 s2, s2, 16
; GFX11-NEXT:    s_or_b32 s1, s1, s2
; GFX11-NEXT:    v_readlane_b32 s2, v19, 23
; GFX11-NEXT:    v_dual_mov_b32 v9, s0 :: v_dual_mov_b32 v10, s1
; GFX11-NEXT:    v_readlane_b32 s1, v19, 18
; GFX11-NEXT:    s_and_b32 s0, s24, 0xff
; GFX11-NEXT:    s_lshl_b32 s2, s2, 8
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_or_b32 s2, s3, s2
; GFX11-NEXT:    s_lshl_b32 s3, s62, 8
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_or_b32 s3, s16, s3
; GFX11-NEXT:    s_and_b32 s16, s23, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_or_b32 s16, s16, s17
; GFX11-NEXT:    v_readlane_b32 s17, v19, 20
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_and_b32 s3, s16, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 8
; GFX11-NEXT:    s_and_b32 s17, s17, 0xff
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_or_b32 s17, s17, s18
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s16, s17, 16
; GFX11-NEXT:    s_lshl_b32 s17, s97, 8
; GFX11-NEXT:    s_or_b32 s3, s3, s16
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v11, s2 :: v_dual_mov_b32 v12, s3
; GFX11-NEXT:    v_readlane_b32 s2, v19, 17
; GFX11-NEXT:    s_lshl_b32 s3, s88, 8
; GFX11-NEXT:    s_and_b32 s16, s69, 0xff
; GFX11-NEXT:    s_and_b32 s18, s72, 0xff
; GFX11-NEXT:    v_readlane_b32 s97, v17, 1
; GFX11-NEXT:    s_and_b32 s2, s2, 0xff
; GFX11-NEXT:    v_readlane_b32 s69, v16, 21
; GFX11-NEXT:    s_or_b32 s1, s2, s3
; GFX11-NEXT:    v_readlane_b32 s3, v19, 16
; GFX11-NEXT:    s_and_b32 s2, s25, 0xff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_lshl_b32 s3, s3, 8
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_or_b32 s3, s16, s17
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_and_b32 s16, s73, 0xff
; GFX11-NEXT:    s_or_b32 s1, s2, s3
; GFX11-NEXT:    s_and_b32 s2, s26, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s96, 8
; GFX11-NEXT:    s_lshl_b32 s17, s76, 8
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_or_b32 s3, s16, s17
; GFX11-NEXT:    s_and_b32 s16, s27, 0xff
; GFX11-NEXT:    s_lshl_b32 s17, s87, 8
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_or_b32 s16, s16, s17
; GFX11-NEXT:    s_or_b32 s17, s18, s19
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_and_b32 s16, s16, 0xffff
; GFX11-NEXT:    s_lshl_b32 s17, s17, 16
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_or_b32 s3, s16, s17
; GFX11-NEXT:    v_readlane_b32 s16, v19, 0
; GFX11-NEXT:    v_dual_mov_b32 v1, s0 :: v_dual_mov_b32 v2, s1
; GFX11-NEXT:    v_dual_mov_b32 v3, s2 :: v_dual_mov_b32 v4, s3
; GFX11-NEXT:    s_and_b32 s0, s28, 0xff
; GFX11-NEXT:    s_lshl_b32 s1, s85, 8
; GFX11-NEXT:    s_and_b32 s2, s84, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s16, 8
; GFX11-NEXT:    v_readlane_b32 s17, v19, 1
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_or_b32 s1, s2, s3
; GFX11-NEXT:    s_and_b32 s2, s29, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s83, 8
; GFX11-NEXT:    s_and_b32 s16, s82, 0xff
; GFX11-NEXT:    s_lshl_b32 s17, s81, 8
; GFX11-NEXT:    v_readlane_b32 s18, v19, 2
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_or_b32 s3, s16, s17
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_or_b32 s1, s2, s3
; GFX11-NEXT:    s_and_b32 s2, s40, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s61, 8
; GFX11-NEXT:    s_and_b32 s16, s80, 0xff
; GFX11-NEXT:    s_lshl_b32 s17, s18, 8
; GFX11-NEXT:    v_readlane_b32 s19, v19, 3
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_or_b32 s3, s16, s17
; GFX11-NEXT:    s_and_b32 s16, s41, 0xff
; GFX11-NEXT:    s_lshl_b32 s17, s60, 8
; GFX11-NEXT:    s_and_b32 s18, s71, 0xff
; GFX11-NEXT:    s_lshl_b32 s19, s70, 8
; GFX11-NEXT:    s_or_b32 s16, s16, s17
; GFX11-NEXT:    s_or_b32 s17, s18, s19
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_and_b32 s16, s16, 0xffff
; GFX11-NEXT:    s_lshl_b32 s17, s17, 16
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_or_b32 s3, s16, s17
; GFX11-NEXT:    v_readlane_b32 s16, v19, 4
; GFX11-NEXT:    v_dual_mov_b32 v5, s0 :: v_dual_mov_b32 v6, s1
; GFX11-NEXT:    v_dual_mov_b32 v7, s2 :: v_dual_mov_b32 v8, s3
; GFX11-NEXT:    s_and_b32 s0, s14, 0xff
; GFX11-NEXT:    s_lshl_b32 s1, s58, 8
; GFX11-NEXT:    s_and_b32 s2, s59, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s16, 8
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_or_b32 s1, s2, s3
; GFX11-NEXT:    s_and_b32 s2, s15, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s68, 8
; GFX11-NEXT:    s_and_b32 s14, s67, 0xff
; GFX11-NEXT:    s_lshl_b32 s15, s66, 8
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_or_b32 s3, s14, s15
; GFX11-NEXT:    v_readlane_b32 s14, v19, 6
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_or_b32 s1, s2, s3
; GFX11-NEXT:    s_and_b32 s2, s12, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s65, 8
; GFX11-NEXT:    s_and_b32 s12, s64, 0xff
; GFX11-NEXT:    s_lshl_b32 s14, s14, 8
; GFX11-NEXT:    v_readlane_b32 s15, v19, 7
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_or_b32 s3, s12, s14
; GFX11-NEXT:    s_and_b32 s12, s13, 0xff
; GFX11-NEXT:    s_lshl_b32 s13, s55, 8
; GFX11-NEXT:    s_and_b32 s14, s54, 0xff
; GFX11-NEXT:    s_lshl_b32 s15, s53, 8
; GFX11-NEXT:    s_or_b32 s12, s12, s13
; GFX11-NEXT:    s_or_b32 s13, s14, s15
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_and_b32 s12, s12, 0xffff
; GFX11-NEXT:    s_lshl_b32 s13, s13, 16
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_or_b32 s3, s12, s13
; GFX11-NEXT:    v_readlane_b32 s12, v19, 8
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    scratch_store_b128 v0, v[9:12], off offset:32
; GFX11-NEXT:    scratch_store_b128 v0, v[1:4], off offset:48
; GFX11-NEXT:    v_dual_mov_b32 v9, s0 :: v_dual_mov_b32 v10, s1
; GFX11-NEXT:    v_dual_mov_b32 v11, s2 :: v_dual_mov_b32 v12, s3
; GFX11-NEXT:    s_and_b32 s0, s10, 0xff
; GFX11-NEXT:    s_lshl_b32 s1, s52, 8
; GFX11-NEXT:    s_and_b32 s2, s51, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s12, 8
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_or_b32 s1, s2, s3
; GFX11-NEXT:    s_and_b32 s2, s11, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s50, 8
; GFX11-NEXT:    s_and_b32 s10, s49, 0xff
; GFX11-NEXT:    s_lshl_b32 s11, s48, 8
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_or_b32 s3, s10, s11
; GFX11-NEXT:    v_readlane_b32 s10, v19, 10
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_or_b32 s1, s2, s3
; GFX11-NEXT:    s_and_b32 s2, s8, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s39, 8
; GFX11-NEXT:    s_and_b32 s8, s38, 0xff
; GFX11-NEXT:    s_lshl_b32 s10, s10, 8
; GFX11-NEXT:    v_readlane_b32 s11, v19, 11
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_or_b32 s3, s8, s10
; GFX11-NEXT:    s_and_b32 s8, s9, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s37, 8
; GFX11-NEXT:    s_and_b32 s10, s36, 0xff
; GFX11-NEXT:    s_lshl_b32 s11, s35, 8
; GFX11-NEXT:    s_or_b32 s8, s8, s9
; GFX11-NEXT:    s_or_b32 s9, s10, s11
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_and_b32 s8, s8, 0xffff
; GFX11-NEXT:    s_lshl_b32 s9, s9, 16
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_or_b32 s3, s8, s9
; GFX11-NEXT:    v_readlane_b32 s8, v19, 12
; GFX11-NEXT:    v_dual_mov_b32 v1, s0 :: v_dual_mov_b32 v2, s1
; GFX11-NEXT:    v_dual_mov_b32 v3, s2 :: v_dual_mov_b32 v4, s3
; GFX11-NEXT:    s_and_b32 s0, s6, 0xff
; GFX11-NEXT:    s_lshl_b32 s1, s56, 8
; GFX11-NEXT:    s_and_b32 s2, s57, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s8, 8
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_or_b32 s1, s2, s3
; GFX11-NEXT:    s_and_b32 s2, s7, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s34, 8
; GFX11-NEXT:    s_and_b32 s6, vcc_hi, 0xff
; GFX11-NEXT:    s_lshl_b32 s7, s46, 8
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_or_b32 s3, s6, s7
; GFX11-NEXT:    v_readlane_b32 s6, v19, 14
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_or_b32 s1, s2, s3
; GFX11-NEXT:    s_and_b32 s2, s4, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s47, 8
; GFX11-NEXT:    s_and_b32 s4, s104, 0xff
; GFX11-NEXT:    s_lshl_b32 s6, s6, 8
; GFX11-NEXT:    v_readlane_b32 s7, v19, 15
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_or_b32 s3, s4, s6
; GFX11-NEXT:    s_and_b32 s4, s5, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s103, 8
; GFX11-NEXT:    s_and_b32 s6, s102, 0xff
; GFX11-NEXT:    s_lshl_b32 s7, s101, 8
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_or_b32 s5, s6, s7
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX11-NEXT:    s_lshl_b32 s5, s5, 16
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_or_b32 s3, s4, s5
; GFX11-NEXT:    scratch_store_b128 v0, v[5:8], off offset:64
; GFX11-NEXT:    v_dual_mov_b32 v5, s0 :: v_dual_mov_b32 v6, s1
; GFX11-NEXT:    v_dual_mov_b32 v7, s2 :: v_dual_mov_b32 v8, s3
; GFX11-NEXT:    v_readlane_b32 s17, v19, 5
; GFX11-NEXT:    v_readlane_b32 s13, v19, 9
; GFX11-NEXT:    v_readlane_b32 s9, v19, 13
; GFX11-NEXT:    s_clause 0x2
; GFX11-NEXT:    scratch_store_b128 v0, v[9:12], off offset:80
; GFX11-NEXT:    scratch_store_b128 v0, v[1:4], off offset:96
; GFX11-NEXT:    scratch_store_b128 v0, v[5:8], off offset:112
; GFX11-NEXT:    v_readlane_b32 s104, v17, 8
; GFX11-NEXT:    v_readlane_b32 s103, v17, 7
; GFX11-NEXT:    v_readlane_b32 s102, v17, 6
; GFX11-NEXT:    v_readlane_b32 s101, v17, 5
; GFX11-NEXT:    v_readlane_b32 s96, v17, 0
; GFX11-NEXT:    v_readlane_b32 s87, v16, 31
; GFX11-NEXT:    v_readlane_b32 s85, v16, 29
; GFX11-NEXT:    v_readlane_b32 s84, v16, 28
; GFX11-NEXT:    v_readlane_b32 s83, v16, 27
; GFX11-NEXT:    v_readlane_b32 s82, v16, 26
; GFX11-NEXT:    v_readlane_b32 s81, v16, 25
; GFX11-NEXT:    v_readlane_b32 s80, v16, 24
; GFX11-NEXT:    v_readlane_b32 s71, v16, 23
; GFX11-NEXT:    v_readlane_b32 s70, v16, 22
; GFX11-NEXT:    v_readlane_b32 s68, v16, 20
; GFX11-NEXT:    v_readlane_b32 s67, v16, 19
; GFX11-NEXT:    v_readlane_b32 s66, v16, 18
; GFX11-NEXT:    v_readlane_b32 s65, v16, 17
; GFX11-NEXT:    v_readlane_b32 s64, v16, 16
; GFX11-NEXT:    v_readlane_b32 s55, v16, 15
; GFX11-NEXT:    v_readlane_b32 s54, v16, 14
; GFX11-NEXT:    v_readlane_b32 s53, v16, 13
; GFX11-NEXT:    v_readlane_b32 s52, v16, 12
; GFX11-NEXT:    v_readlane_b32 s51, v16, 11
; GFX11-NEXT:    v_readlane_b32 s50, v16, 10
; GFX11-NEXT:    v_readlane_b32 s49, v16, 9
; GFX11-NEXT:    v_readlane_b32 s48, v16, 8
; GFX11-NEXT:    v_readlane_b32 s39, v16, 7
; GFX11-NEXT:    v_readlane_b32 s38, v16, 6
; GFX11-NEXT:    v_readlane_b32 s37, v16, 5
; GFX11-NEXT:    v_readlane_b32 s36, v16, 4
; GFX11-NEXT:    v_readlane_b32 s35, v16, 3
; GFX11-NEXT:    v_readlane_b32 s34, v16, 2
; GFX11-NEXT:    s_xor_saveexec_b32 s0, -1
; GFX11-NEXT:    s_clause 0x3
; GFX11-NEXT:    scratch_load_b32 v16, off, s32
; GFX11-NEXT:    scratch_load_b32 v17, off, s32 offset:4
; GFX11-NEXT:    scratch_load_b32 v18, off, s32 offset:8
; GFX11-NEXT:    scratch_load_b32 v19, off, s32 offset:12
; GFX11-NEXT:    s_mov_b32 exec_lo, s0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <32 x i32> %a, splat (i32 3)
  %a2 = bitcast <32 x i32> %a1 to <128 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <32 x i32> %a to <128 x i8>
  br label %end

end:
  %phi = phi <128 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <128 x i8> %phi
}

define <32 x i32> @bitcast_v128i8_to_v32i32(<128 x i8> %a, i32 %b) {
; SI-LABEL: bitcast_v128i8_to_v32i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:452 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:448 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:444 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:440 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:436 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:432 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:428 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:424 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:420 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:416 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:412 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:408 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:404 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:400 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:396 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:392 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v30, off, s[0:3], s32 offset:456 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v28, off, s[0:3], s32 offset:460 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v26, off, s[0:3], s32 offset:464 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v24, off, s[0:3], s32 offset:468 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v22, off, s[0:3], s32 offset:480 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v20, off, s[0:3], s32 offset:492 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:516 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v16, off, s[0:3], s32 offset:528 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:540 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:552 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:580 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:600 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:644 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:668 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:688 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:708 ; 4-byte Folded Spill
; SI-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:388
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:8
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:16
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:24
; SI-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:32
; SI-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:40
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:48
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:56
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:64
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:72
; SI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:80
; SI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:88
; SI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:96
; SI-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:104
; SI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:112
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:120
; SI-NEXT:    buffer_load_dword v33, off, s[0:3], s32 offset:128
; SI-NEXT:    buffer_load_dword v35, off, s[0:3], s32 offset:136
; SI-NEXT:    buffer_load_dword v36, off, s[0:3], s32 offset:144
; SI-NEXT:    buffer_load_dword v39, off, s[0:3], s32 offset:152
; SI-NEXT:    buffer_load_dword v49, off, s[0:3], s32 offset:160
; SI-NEXT:    buffer_load_dword v50, off, s[0:3], s32 offset:168
; SI-NEXT:    buffer_load_dword v51, off, s[0:3], s32 offset:176
; SI-NEXT:    buffer_load_dword v52, off, s[0:3], s32 offset:184
; SI-NEXT:    v_lshlrev_b32_e32 v54, 8, v1
; SI-NEXT:    v_lshlrev_b32_e32 v42, 24, v3
; SI-NEXT:    v_lshlrev_b32_e32 v41, 8, v5
; SI-NEXT:    v_lshlrev_b32_e32 v40, 24, v7
; SI-NEXT:    v_lshlrev_b32_e32 v53, 8, v9
; SI-NEXT:    v_lshlrev_b32_e32 v34, 24, v11
; SI-NEXT:    v_lshlrev_b32_e32 v48, 8, v13
; SI-NEXT:    v_lshlrev_b32_e32 v32, 24, v15
; SI-NEXT:    v_lshlrev_b32_e32 v62, 8, v17
; SI-NEXT:    v_lshlrev_b32_e32 v60, 24, v19
; SI-NEXT:    v_lshlrev_b32_e32 v38, 8, v21
; SI-NEXT:    v_lshlrev_b32_e32 v58, 24, v23
; SI-NEXT:    v_lshlrev_b32_e32 v56, 8, v25
; SI-NEXT:    v_lshlrev_b32_e32 v37, 24, v27
; SI-NEXT:    v_lshlrev_b32_e32 v46, 8, v29
; SI-NEXT:    s_waitcnt vmcnt(14)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v30
; SI-NEXT:    v_lshlrev_b32_e32 v55, 24, v0
; SI-NEXT:    v_lshlrev_b32_e32 v44, 8, v2
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v4
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:836 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v6
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:832 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v8
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:828 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v10
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:824 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v12
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:820 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v14
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:816 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v16
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:812 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v18
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:808 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(14) expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v20
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:804 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v22
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:800 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v24
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:796 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v26
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:792 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v28
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:788 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:116
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:740 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v31
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:784 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:124
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:728 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:132
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:716 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:140
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:700 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:148
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:684 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v33
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:780 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v35
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:776 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v36
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:772 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v39
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:768 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:156
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:680 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:164
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:660 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:172
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:648 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:180
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:628 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v49
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:764 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v50
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:760 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v51
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:752 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v52
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:744 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:192
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:200
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:208
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:216
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:188
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:756 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(4) expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:748 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:652 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:196
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v2
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:732 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v3
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:720 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:632 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:204
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:608 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:212
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:584 ; 4-byte Folded Spill
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:224
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:232
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:240
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:248
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:220
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:736 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(4) expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:724 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:616 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:228
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v2
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:704 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v3
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:692 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:588 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:236
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:568 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:244
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:556 ; 4-byte Folded Spill
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:256
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:264
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:272
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:280
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:252
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:712 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(4) expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:696 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:572 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:260
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v2
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:676 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v3
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:664 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:560 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:268
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:548 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:276
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:536 ; 4-byte Folded Spill
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:288
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:296
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:304
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:312
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:284
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:672 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(4) expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:656 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:544 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:292
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v2
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:636 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v3
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:620 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:532 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:300
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:520 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:308
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:504 ; 4-byte Folded Spill
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:320
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:328
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:336
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:344
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:316
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:640 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(4) expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:624 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:524 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:324
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v2
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:604 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v3
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:592 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:512 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:332
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:500 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:340
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:488 ; 4-byte Folded Spill
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:352
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:360
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:368
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:376
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:348
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:612 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(4) expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:596 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:508 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:356
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v2
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:576 ; 4-byte Folded Spill
; SI-NEXT:    v_lshlrev_b32_e32 v43, 8, v3
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:496 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:364
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:484 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:372
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:472 ; 4-byte Folded Spill
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:384
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:380
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:476 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:564 ; 4-byte Folded Spill
; SI-NEXT:    buffer_load_dword v39, off, s[0:3], s32 offset:44
; SI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:36
; SI-NEXT:    buffer_load_dword v52, off, s[0:3], s32 offset:28
; SI-NEXT:    buffer_load_dword v33, off, s[0:3], s32 offset:20
; SI-NEXT:    buffer_load_dword v49, off, s[0:3], s32 offset:12
; SI-NEXT:    buffer_load_dword v35, off, s[0:3], s32 offset:4
; SI-NEXT:    buffer_load_dword v36, off, s[0:3], s32 offset:108
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:100
; SI-NEXT:    buffer_load_dword v50, off, s[0:3], s32 offset:92
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:84
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:76
; SI-NEXT:    buffer_load_dword v51, off, s[0:3], s32 offset:68
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:60
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:52
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB14_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:708 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:668 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:644 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:836 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:788 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:688 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:804 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:736 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(14)
; SI-NEXT:    v_and_b32_e32 v9, 0xff, v49
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:780 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:704 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:540 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:828 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:764 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:672 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:516 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:820 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:756 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:612 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:480 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:812 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:752 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:604 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:464 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:796 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:732 ; 4-byte Folded Reload
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:772 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:712 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:676 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:636 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:640 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(14)
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v3
; SI-NEXT:    v_or_b32_e32 v0, v0, v54
; SI-NEXT:    v_or_b32_e32 v2, v2, v41
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_or_b32_e32 v1, v42, v1
; SI-NEXT:    v_or_b32_e32 v3, v40, v3
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v3
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:600 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:580 ; 4-byte Folded Reload
; SI-NEXT:    v_or_b32_e32 v9, v10, v9
; SI-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:832 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v4
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_or_b32_e32 v4, v32, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xff, v5
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v5, v60, v5
; SI-NEXT:    s_waitcnt vmcnt(14)
; SI-NEXT:    v_and_b32_e32 v6, 0xff, v6
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v58, v6
; SI-NEXT:    s_waitcnt vmcnt(10)
; SI-NEXT:    v_and_b32_e32 v7, 0xff, v7
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_or_b32_e32 v7, v37, v7
; SI-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:576 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:456 ; 4-byte Folded Reload
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; implicit-def: $vgpr40
; SI-NEXT:    ; implicit-def: $vgpr60
; SI-NEXT:    ; implicit-def: $vgpr58
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v3
; SI-NEXT:    v_or_b32_e32 v2, v2, v53
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_or_b32_e32 v3, v34, v3
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:552 ; 4-byte Folded Reload
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_and_b32_e32 v8, 0xff, v8
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_or_b32_e32 v8, v55, v8
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v3
; SI-NEXT:    v_or_b32_e32 v3, v3, v48
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_or_b32_e32 v3, v3, v4
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:528 ; 4-byte Folded Reload
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v4
; SI-NEXT:    v_or_b32_e32 v4, v4, v62
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_or_b32_e32 v4, v4, v5
; SI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:492 ; 4-byte Folded Reload
; SI-NEXT:    ; implicit-def: $vgpr62
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v5, 0xff, v5
; SI-NEXT:    v_or_b32_e32 v5, v5, v38
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; SI-NEXT:    v_or_b32_e32 v5, v5, v6
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:468 ; 4-byte Folded Reload
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v6, 0xff, v6
; SI-NEXT:    v_or_b32_e32 v6, v6, v56
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; SI-NEXT:    v_or_b32_e32 v6, v6, v7
; SI-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:460 ; 4-byte Folded Reload
; SI-NEXT:    ; implicit-def: $vgpr56
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v7, 0xff, v7
; SI-NEXT:    v_or_b32_e32 v7, v7, v46
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; SI-NEXT:    v_or_b32_e32 v7, v7, v8
; SI-NEXT:    v_and_b32_e32 v8, 0xff, v35
; SI-NEXT:    v_or_b32_e32 v8, v8, v44
; SI-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; SI-NEXT:    v_or_b32_e32 v8, v8, v9
; SI-NEXT:    v_and_b32_e32 v9, 0xff, v33
; SI-NEXT:    v_or_b32_e32 v9, v9, v10
; SI-NEXT:    v_and_b32_e32 v10, 0xff, v52
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; SI-NEXT:    v_or_b32_e32 v10, v11, v10
; SI-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:824 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; SI-NEXT:    v_or_b32_e32 v9, v9, v10
; SI-NEXT:    v_and_b32_e32 v10, 0xff, v63
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr63
; SI-NEXT:    ; implicit-def: $vgpr46
; SI-NEXT:    ; implicit-def: $vgpr44
; SI-NEXT:    buffer_load_dword v33, off, s[0:3], s32 offset:564 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v10, v10, v11
; SI-NEXT:    v_and_b32_e32 v11, 0xff, v39
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; SI-NEXT:    v_or_b32_e32 v11, v12, v11
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:816 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; SI-NEXT:    v_or_b32_e32 v10, v10, v11
; SI-NEXT:    v_and_b32_e32 v11, 0xff, v61
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr61
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v11, v11, v12
; SI-NEXT:    v_and_b32_e32 v12, 0xff, v59
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; SI-NEXT:    v_or_b32_e32 v12, v13, v12
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:808 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; SI-NEXT:    v_or_b32_e32 v11, v11, v12
; SI-NEXT:    v_and_b32_e32 v12, 0xff, v51
; SI-NEXT:    ; implicit-def: $vgpr59
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v12, v12, v13
; SI-NEXT:    v_and_b32_e32 v13, 0xff, v57
; SI-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; SI-NEXT:    v_or_b32_e32 v13, v14, v13
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:800 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; SI-NEXT:    v_or_b32_e32 v12, v12, v13
; SI-NEXT:    v_and_b32_e32 v13, 0xff, v47
; SI-NEXT:    ; implicit-def: $vgpr57
; SI-NEXT:    ; implicit-def: $vgpr47
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v13, v13, v14
; SI-NEXT:    v_and_b32_e32 v14, 0xff, v50
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; SI-NEXT:    v_or_b32_e32 v14, v15, v14
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:792 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; SI-NEXT:    v_or_b32_e32 v13, v13, v14
; SI-NEXT:    v_and_b32_e32 v14, 0xff, v45
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr45
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v14, v14, v15
; SI-NEXT:    v_and_b32_e32 v15, 0xff, v36
; SI-NEXT:    v_lshlrev_b32_e32 v15, 16, v15
; SI-NEXT:    v_or_b32_e32 v15, v16, v15
; SI-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; SI-NEXT:    v_or_b32_e32 v14, v14, v15
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:740 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:784 ; 4-byte Folded Reload
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_and_b32_e32 v15, 0xff, v15
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v15, v15, v16
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:728 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v16, 0xff, v16
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v16
; SI-NEXT:    v_or_b32_e32 v16, v17, v16
; SI-NEXT:    v_or_b32_e32 v15, v15, v16
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:716 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:776 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_and_b32_e32 v16, 0xff, v16
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v16, v16, v17
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:700 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v16, 0xffff, v16
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v17, 0xff, v17
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; SI-NEXT:    v_or_b32_e32 v17, v18, v17
; SI-NEXT:    v_or_b32_e32 v16, v16, v17
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:684 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:768 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_and_b32_e32 v17, 0xff, v17
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v17, v17, v18
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:680 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v18, 0xff, v18
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; SI-NEXT:    v_or_b32_e32 v18, v19, v18
; SI-NEXT:    v_or_b32_e32 v17, v17, v18
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:660 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:760 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_and_b32_e32 v18, 0xff, v18
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v18, v18, v19
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:648 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v18, 0xffff, v18
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v19, 0xff, v19
; SI-NEXT:    v_lshlrev_b32_e32 v19, 16, v19
; SI-NEXT:    v_or_b32_e32 v19, v20, v19
; SI-NEXT:    v_or_b32_e32 v18, v18, v19
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:628 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:744 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_and_b32_e32 v19, 0xff, v19
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v19, v19, v20
; SI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:652 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v19, 0xffff, v19
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v20, 0xff, v20
; SI-NEXT:    v_lshlrev_b32_e32 v20, 16, v20
; SI-NEXT:    v_or_b32_e32 v20, v21, v20
; SI-NEXT:    v_or_b32_e32 v19, v19, v20
; SI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:632 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:748 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_and_b32_e32 v20, 0xff, v20
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v20, v20, v21
; SI-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:608 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v20, 0xffff, v20
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v21, 0xff, v21
; SI-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; SI-NEXT:    v_or_b32_e32 v21, v22, v21
; SI-NEXT:    v_or_b32_e32 v20, v20, v21
; SI-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:584 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:720 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_and_b32_e32 v21, 0xff, v21
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v21, v21, v22
; SI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:616 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v21, 0xffff, v21
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v22, 0xff, v22
; SI-NEXT:    v_lshlrev_b32_e32 v22, 16, v22
; SI-NEXT:    v_or_b32_e32 v22, v23, v22
; SI-NEXT:    v_or_b32_e32 v21, v21, v22
; SI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:588 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:724 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_and_b32_e32 v22, 0xff, v22
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v22, v22, v23
; SI-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:568 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v22, 0xffff, v22
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v23, 0xff, v23
; SI-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; SI-NEXT:    v_or_b32_e32 v23, v24, v23
; SI-NEXT:    v_or_b32_e32 v22, v22, v23
; SI-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:556 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:692 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_and_b32_e32 v23, 0xff, v23
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v23, v23, v24
; SI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:572 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v23, 0xffff, v23
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v24, 0xff, v24
; SI-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; SI-NEXT:    v_or_b32_e32 v24, v25, v24
; SI-NEXT:    v_or_b32_e32 v23, v23, v24
; SI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:560 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:696 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_and_b32_e32 v24, 0xff, v24
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v24, v24, v25
; SI-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:548 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v24, 0xffff, v24
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v25, 0xff, v25
; SI-NEXT:    v_lshlrev_b32_e32 v25, 16, v25
; SI-NEXT:    v_or_b32_e32 v25, v26, v25
; SI-NEXT:    v_or_b32_e32 v24, v24, v25
; SI-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:536 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:664 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_and_b32_e32 v25, 0xff, v25
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v25, v25, v26
; SI-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:544 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v25, 0xffff, v25
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v26, 0xff, v26
; SI-NEXT:    v_lshlrev_b32_e32 v26, 16, v26
; SI-NEXT:    v_or_b32_e32 v26, v27, v26
; SI-NEXT:    v_or_b32_e32 v25, v25, v26
; SI-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:532 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:656 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_and_b32_e32 v26, 0xff, v26
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v26, v26, v27
; SI-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:520 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v26, 0xffff, v26
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v27, 0xff, v27
; SI-NEXT:    v_lshlrev_b32_e32 v27, 16, v27
; SI-NEXT:    v_or_b32_e32 v27, v28, v27
; SI-NEXT:    v_or_b32_e32 v26, v26, v27
; SI-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:504 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:620 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_and_b32_e32 v27, 0xff, v27
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v27, v27, v28
; SI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:524 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v27, 0xffff, v27
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v28, 0xff, v28
; SI-NEXT:    v_lshlrev_b32_e32 v28, 16, v28
; SI-NEXT:    v_or_b32_e32 v28, v29, v28
; SI-NEXT:    v_or_b32_e32 v27, v27, v28
; SI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:512 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:624 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_and_b32_e32 v28, 0xff, v28
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v28, v28, v29
; SI-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:500 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v28, 0xffff, v28
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v29, 0xff, v29
; SI-NEXT:    v_lshlrev_b32_e32 v29, 16, v29
; SI-NEXT:    v_or_b32_e32 v29, v30, v29
; SI-NEXT:    v_or_b32_e32 v28, v28, v29
; SI-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:488 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:592 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_and_b32_e32 v29, 0xff, v29
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v29, v29, v30
; SI-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:508 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v29, 0xffff, v29
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v30, 0xff, v30
; SI-NEXT:    v_lshlrev_b32_e32 v30, 16, v30
; SI-NEXT:    v_or_b32_e32 v30, v31, v30
; SI-NEXT:    v_or_b32_e32 v29, v29, v30
; SI-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:496 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:596 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_and_b32_e32 v30, 0xff, v30
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v30, v30, v31
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:484 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v30, 0xffff, v30
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v31, 0xff, v31
; SI-NEXT:    v_lshlrev_b32_e32 v31, 16, v31
; SI-NEXT:    v_or_b32_e32 v31, v32, v31
; SI-NEXT:    v_or_b32_e32 v30, v30, v31
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:472 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:476 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_and_b32_e32 v31, 0xff, v31
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v32, 0xff, v32
; SI-NEXT:    v_or_b32_e32 v31, v31, v43
; SI-NEXT:    v_lshlrev_b32_e32 v32, 16, v32
; SI-NEXT:    v_and_b32_e32 v31, 0xffff, v31
; SI-NEXT:    v_or_b32_e32 v32, v33, v32
; SI-NEXT:    v_or_b32_e32 v31, v31, v32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; kill: killed $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; kill: killed $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:  .LBB14_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB14_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:708 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:788 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:688 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:828 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:764 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:644 ; 4-byte Folded Reload
; SI-NEXT:    s_movk_i32 s6, 0x300
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:804 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:736 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:580 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:836 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:780 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:704 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:540 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(14)
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v49
; SI-NEXT:    v_and_b32_e32 v9, 0xff, v9
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:772 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:672 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:516 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:820 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:756 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:612 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:480 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:812 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:752 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:604 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:464 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:796 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:732 ; 4-byte Folded Reload
; SI-NEXT:    s_mov_b32 s7, 0x3000000
; SI-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:712 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:676 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:636 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:640 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(14)
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_or_b32_e32 v0, v54, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_or_b32_e32 v1, v42, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:668 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v40, v2
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v3
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_or_b32_e32 v3, v34, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v4
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_or_b32_e32 v4, v32, v4
; SI-NEXT:    v_or_b32_e32 v9, v10, v9
; SI-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:832 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_and_b32_e32 v5, 0xff, v5
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v5, v60, v5
; SI-NEXT:    s_waitcnt vmcnt(12)
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_and_b32_e32 v6, 0xff, v6
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v58, v6
; SI-NEXT:    s_waitcnt vmcnt(8)
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_and_b32_e32 v7, 0xff, v7
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_or_b32_e32 v7, v37, v7
; SI-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:576 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:456 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v0, vcc, s7, v0
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_or_b32_e32 v1, v41, v1
; SI-NEXT:    v_add_i32_e32 v1, vcc, s6, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:600 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v1, vcc, s7, v1
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_and_b32_e32 v8, 0xff, v8
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_or_b32_e32 v8, v55, v8
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_or_b32_e32 v2, v53, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, s6, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:552 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v2, vcc, s7, v2
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v3
; SI-NEXT:    v_or_b32_e32 v3, v48, v3
; SI-NEXT:    v_add_i32_e32 v3, vcc, s6, v3
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_or_b32_e32 v3, v4, v3
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:528 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v3, vcc, s7, v3
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v4
; SI-NEXT:    v_or_b32_e32 v4, v62, v4
; SI-NEXT:    v_add_i32_e32 v4, vcc, s6, v4
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_or_b32_e32 v4, v5, v4
; SI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:492 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v4, vcc, s7, v4
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_and_b32_e32 v5, 0xff, v5
; SI-NEXT:    v_or_b32_e32 v5, v38, v5
; SI-NEXT:    v_add_i32_e32 v5, vcc, s6, v5
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:468 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v5, vcc, s7, v5
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_and_b32_e32 v6, 0xff, v6
; SI-NEXT:    v_or_b32_e32 v6, v56, v6
; SI-NEXT:    v_add_i32_e32 v6, vcc, s6, v6
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; SI-NEXT:    v_or_b32_e32 v6, v7, v6
; SI-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:460 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v6, vcc, s7, v6
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_and_b32_e32 v7, 0xff, v7
; SI-NEXT:    v_or_b32_e32 v7, v46, v7
; SI-NEXT:    v_add_i32_e32 v7, vcc, s6, v7
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; SI-NEXT:    v_or_b32_e32 v7, v8, v7
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v35
; SI-NEXT:    v_and_b32_e32 v8, 0xff, v8
; SI-NEXT:    v_or_b32_e32 v8, v44, v8
; SI-NEXT:    v_add_i32_e32 v8, vcc, s6, v8
; SI-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; SI-NEXT:    v_or_b32_e32 v8, v9, v8
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v33
; SI-NEXT:    v_and_b32_e32 v9, 0xff, v9
; SI-NEXT:    v_or_b32_e32 v9, v10, v9
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v52
; SI-NEXT:    v_and_b32_e32 v10, 0xff, v10
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; SI-NEXT:    v_or_b32_e32 v10, v11, v10
; SI-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:824 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v9, vcc, s6, v9
; SI-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; SI-NEXT:    v_or_b32_e32 v9, v10, v9
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v63
; SI-NEXT:    v_and_b32_e32 v10, 0xff, v10
; SI-NEXT:    v_add_i32_e32 v7, vcc, s7, v7
; SI-NEXT:    v_add_i32_e32 v8, vcc, s7, v8
; SI-NEXT:    v_add_i32_e32 v9, vcc, s7, v9
; SI-NEXT:    buffer_load_dword v33, off, s[0:3], s32 offset:564 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v10, v11, v10
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v39
; SI-NEXT:    v_and_b32_e32 v11, 0xff, v11
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; SI-NEXT:    v_or_b32_e32 v11, v12, v11
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:816 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v10, vcc, s6, v10
; SI-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; SI-NEXT:    v_or_b32_e32 v10, v11, v10
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v61
; SI-NEXT:    v_and_b32_e32 v11, 0xff, v11
; SI-NEXT:    v_add_i32_e32 v10, vcc, s7, v10
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v11, v12, v11
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v59
; SI-NEXT:    v_and_b32_e32 v12, 0xff, v12
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; SI-NEXT:    v_or_b32_e32 v12, v13, v12
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:808 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v11, vcc, s6, v11
; SI-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; SI-NEXT:    v_or_b32_e32 v11, v12, v11
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v51
; SI-NEXT:    v_and_b32_e32 v12, 0xff, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, s7, v11
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v12, v13, v12
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v57
; SI-NEXT:    v_and_b32_e32 v13, 0xff, v13
; SI-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; SI-NEXT:    v_or_b32_e32 v13, v14, v13
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:800 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v12, vcc, s6, v12
; SI-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; SI-NEXT:    v_or_b32_e32 v12, v13, v12
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v47
; SI-NEXT:    v_and_b32_e32 v13, 0xff, v13
; SI-NEXT:    v_add_i32_e32 v12, vcc, s7, v12
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v13, v14, v13
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v50
; SI-NEXT:    v_and_b32_e32 v14, 0xff, v14
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; SI-NEXT:    v_or_b32_e32 v14, v15, v14
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:792 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v13, vcc, s6, v13
; SI-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; SI-NEXT:    v_or_b32_e32 v13, v14, v13
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v45
; SI-NEXT:    v_and_b32_e32 v14, 0xff, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, s7, v13
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v14, v15, v14
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v36
; SI-NEXT:    v_and_b32_e32 v15, 0xff, v15
; SI-NEXT:    v_lshlrev_b32_e32 v15, 16, v15
; SI-NEXT:    v_add_i32_e32 v14, vcc, s6, v14
; SI-NEXT:    v_or_b32_e32 v15, v16, v15
; SI-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; SI-NEXT:    v_or_b32_e32 v14, v15, v14
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:740 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:784 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v14, vcc, s7, v14
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_and_b32_e32 v15, 0xff, v15
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v15, v16, v15
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:728 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v15, vcc, s6, v15
; SI-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_and_b32_e32 v16, 0xff, v16
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v16
; SI-NEXT:    v_or_b32_e32 v16, v17, v16
; SI-NEXT:    v_or_b32_e32 v15, v16, v15
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:716 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:776 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v15, vcc, s7, v15
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_and_b32_e32 v16, 0xff, v16
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v16, v17, v16
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:700 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v16, vcc, s6, v16
; SI-NEXT:    v_and_b32_e32 v16, 0xffff, v16
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_and_b32_e32 v17, 0xff, v17
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; SI-NEXT:    v_or_b32_e32 v17, v18, v17
; SI-NEXT:    v_or_b32_e32 v16, v17, v16
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:684 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:768 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v16, vcc, s7, v16
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_and_b32_e32 v17, 0xff, v17
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v17, v18, v17
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:680 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v17, vcc, s6, v17
; SI-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_and_b32_e32 v18, 0xff, v18
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; SI-NEXT:    v_or_b32_e32 v18, v19, v18
; SI-NEXT:    v_or_b32_e32 v17, v18, v17
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:660 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:760 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v17, vcc, s7, v17
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_and_b32_e32 v18, 0xff, v18
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v18, v19, v18
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:648 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v18, vcc, s6, v18
; SI-NEXT:    v_and_b32_e32 v18, 0xffff, v18
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_and_b32_e32 v19, 0xff, v19
; SI-NEXT:    v_lshlrev_b32_e32 v19, 16, v19
; SI-NEXT:    v_or_b32_e32 v19, v20, v19
; SI-NEXT:    v_or_b32_e32 v18, v19, v18
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:628 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:744 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v18, vcc, s7, v18
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_and_b32_e32 v19, 0xff, v19
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v19, v20, v19
; SI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:652 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v19, vcc, s6, v19
; SI-NEXT:    v_and_b32_e32 v19, 0xffff, v19
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_and_b32_e32 v20, 0xff, v20
; SI-NEXT:    v_lshlrev_b32_e32 v20, 16, v20
; SI-NEXT:    v_or_b32_e32 v20, v21, v20
; SI-NEXT:    v_or_b32_e32 v19, v20, v19
; SI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:632 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:748 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v19, vcc, s7, v19
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_and_b32_e32 v20, 0xff, v20
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v20, v21, v20
; SI-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:608 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v20, vcc, s6, v20
; SI-NEXT:    v_and_b32_e32 v20, 0xffff, v20
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v21, vcc, 3, v21
; SI-NEXT:    v_and_b32_e32 v21, 0xff, v21
; SI-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; SI-NEXT:    v_or_b32_e32 v21, v22, v21
; SI-NEXT:    v_or_b32_e32 v20, v21, v20
; SI-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:584 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:720 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v20, vcc, s7, v20
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v21, vcc, 3, v21
; SI-NEXT:    v_and_b32_e32 v21, 0xff, v21
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v21, v22, v21
; SI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:616 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v21, vcc, s6, v21
; SI-NEXT:    v_and_b32_e32 v21, 0xffff, v21
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v22
; SI-NEXT:    v_and_b32_e32 v22, 0xff, v22
; SI-NEXT:    v_lshlrev_b32_e32 v22, 16, v22
; SI-NEXT:    v_or_b32_e32 v22, v23, v22
; SI-NEXT:    v_or_b32_e32 v21, v22, v21
; SI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:588 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:724 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v21, vcc, s7, v21
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v22
; SI-NEXT:    v_and_b32_e32 v22, 0xff, v22
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v22, v23, v22
; SI-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:568 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v22, vcc, s6, v22
; SI-NEXT:    v_and_b32_e32 v22, 0xffff, v22
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v23, vcc, 3, v23
; SI-NEXT:    v_and_b32_e32 v23, 0xff, v23
; SI-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; SI-NEXT:    v_or_b32_e32 v23, v24, v23
; SI-NEXT:    v_or_b32_e32 v22, v23, v22
; SI-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:556 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:692 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v22, vcc, s7, v22
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v23, vcc, 3, v23
; SI-NEXT:    v_and_b32_e32 v23, 0xff, v23
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v23, v24, v23
; SI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:572 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v23, vcc, s6, v23
; SI-NEXT:    v_and_b32_e32 v23, 0xffff, v23
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    v_and_b32_e32 v24, 0xff, v24
; SI-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; SI-NEXT:    v_or_b32_e32 v24, v25, v24
; SI-NEXT:    v_or_b32_e32 v23, v24, v23
; SI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:560 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:696 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v23, vcc, s7, v23
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    v_and_b32_e32 v24, 0xff, v24
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v24, v25, v24
; SI-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:548 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v24, vcc, s6, v24
; SI-NEXT:    v_and_b32_e32 v24, 0xffff, v24
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v25, vcc, 3, v25
; SI-NEXT:    v_and_b32_e32 v25, 0xff, v25
; SI-NEXT:    v_lshlrev_b32_e32 v25, 16, v25
; SI-NEXT:    v_or_b32_e32 v25, v26, v25
; SI-NEXT:    v_or_b32_e32 v24, v25, v24
; SI-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:536 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:664 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v24, vcc, s7, v24
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v25, vcc, 3, v25
; SI-NEXT:    v_and_b32_e32 v25, 0xff, v25
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v25, v26, v25
; SI-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:544 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v25, vcc, s6, v25
; SI-NEXT:    v_and_b32_e32 v25, 0xffff, v25
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v26
; SI-NEXT:    v_and_b32_e32 v26, 0xff, v26
; SI-NEXT:    v_lshlrev_b32_e32 v26, 16, v26
; SI-NEXT:    v_or_b32_e32 v26, v27, v26
; SI-NEXT:    v_or_b32_e32 v25, v26, v25
; SI-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:532 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:656 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v25, vcc, s7, v25
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v26
; SI-NEXT:    v_and_b32_e32 v26, 0xff, v26
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v26, v27, v26
; SI-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:520 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v26, vcc, s6, v26
; SI-NEXT:    v_and_b32_e32 v26, 0xffff, v26
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v27, vcc, 3, v27
; SI-NEXT:    v_and_b32_e32 v27, 0xff, v27
; SI-NEXT:    v_lshlrev_b32_e32 v27, 16, v27
; SI-NEXT:    v_or_b32_e32 v27, v28, v27
; SI-NEXT:    v_or_b32_e32 v26, v27, v26
; SI-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:504 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:620 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v26, vcc, s7, v26
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v27, vcc, 3, v27
; SI-NEXT:    v_and_b32_e32 v27, 0xff, v27
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v27, v28, v27
; SI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:524 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v27, vcc, s6, v27
; SI-NEXT:    v_and_b32_e32 v27, 0xffff, v27
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v28, vcc, 3, v28
; SI-NEXT:    v_and_b32_e32 v28, 0xff, v28
; SI-NEXT:    v_lshlrev_b32_e32 v28, 16, v28
; SI-NEXT:    v_or_b32_e32 v28, v29, v28
; SI-NEXT:    v_or_b32_e32 v27, v28, v27
; SI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:512 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:624 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v27, vcc, s7, v27
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v28, vcc, 3, v28
; SI-NEXT:    v_and_b32_e32 v28, 0xff, v28
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v28, v29, v28
; SI-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:500 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v28, vcc, s6, v28
; SI-NEXT:    v_and_b32_e32 v28, 0xffff, v28
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v29, vcc, 3, v29
; SI-NEXT:    v_and_b32_e32 v29, 0xff, v29
; SI-NEXT:    v_lshlrev_b32_e32 v29, 16, v29
; SI-NEXT:    v_or_b32_e32 v29, v30, v29
; SI-NEXT:    v_or_b32_e32 v28, v29, v28
; SI-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:488 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:592 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v28, vcc, s7, v28
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v29, vcc, 3, v29
; SI-NEXT:    v_and_b32_e32 v29, 0xff, v29
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v29, v30, v29
; SI-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:508 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v29, vcc, s6, v29
; SI-NEXT:    v_and_b32_e32 v29, 0xffff, v29
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v30, vcc, 3, v30
; SI-NEXT:    v_and_b32_e32 v30, 0xff, v30
; SI-NEXT:    v_lshlrev_b32_e32 v30, 16, v30
; SI-NEXT:    v_or_b32_e32 v30, v31, v30
; SI-NEXT:    v_or_b32_e32 v29, v30, v29
; SI-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:496 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:596 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v29, vcc, s7, v29
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v30, vcc, 3, v30
; SI-NEXT:    v_and_b32_e32 v30, 0xff, v30
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v30, v31, v30
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:484 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v30, vcc, s6, v30
; SI-NEXT:    v_and_b32_e32 v30, 0xffff, v30
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v31, vcc, 3, v31
; SI-NEXT:    v_and_b32_e32 v31, 0xff, v31
; SI-NEXT:    v_lshlrev_b32_e32 v31, 16, v31
; SI-NEXT:    v_or_b32_e32 v31, v32, v31
; SI-NEXT:    v_or_b32_e32 v30, v31, v30
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:472 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:476 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v30, vcc, 0x3000000, v30
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v31, vcc, 3, v31
; SI-NEXT:    v_and_b32_e32 v31, 0xff, v31
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v32, vcc, 3, v32
; SI-NEXT:    v_or_b32_e32 v31, v43, v31
; SI-NEXT:    v_and_b32_e32 v32, 0xff, v32
; SI-NEXT:    v_add_i32_e32 v31, vcc, 0x300, v31
; SI-NEXT:    v_lshlrev_b32_e32 v32, 16, v32
; SI-NEXT:    v_and_b32_e32 v31, 0xffff, v31
; SI-NEXT:    v_or_b32_e32 v32, v33, v32
; SI-NEXT:    v_or_b32_e32 v31, v32, v31
; SI-NEXT:    v_add_i32_e32 v31, vcc, 0x3000000, v31
; SI-NEXT:  .LBB14_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:392 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:396 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:400 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:404 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:408 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:412 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:416 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:420 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:424 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:428 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:432 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:436 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:440 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:444 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:448 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:452 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v128i8_to_v32i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:452 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:448 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:444 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:440 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:436 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:432 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:428 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:424 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:420 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:416 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:412 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:408 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:404 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:400 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:396 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:392 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v30, off, s[0:3], s32 offset:456 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v28, off, s[0:3], s32 offset:460 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v26, off, s[0:3], s32 offset:464 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v24, off, s[0:3], s32 offset:468 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v22, off, s[0:3], s32 offset:472 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v20, off, s[0:3], s32 offset:476 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:480 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v16, off, s[0:3], s32 offset:484 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:488 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:492 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:496 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:500 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:504 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:508 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:512 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:516 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:388
; VI-NEXT:    buffer_load_ushort v0, off, s[0:3], s32
; VI-NEXT:    buffer_load_ushort v2, off, s[0:3], s32 offset:8
; VI-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:16
; VI-NEXT:    buffer_load_ushort v6, off, s[0:3], s32 offset:24
; VI-NEXT:    buffer_load_ushort v8, off, s[0:3], s32 offset:32
; VI-NEXT:    buffer_load_ushort v10, off, s[0:3], s32 offset:40
; VI-NEXT:    buffer_load_ushort v12, off, s[0:3], s32 offset:48
; VI-NEXT:    buffer_load_ushort v14, off, s[0:3], s32 offset:56
; VI-NEXT:    buffer_load_ushort v16, off, s[0:3], s32 offset:64
; VI-NEXT:    buffer_load_ushort v18, off, s[0:3], s32 offset:72
; VI-NEXT:    buffer_load_ushort v20, off, s[0:3], s32 offset:80
; VI-NEXT:    buffer_load_ushort v22, off, s[0:3], s32 offset:88
; VI-NEXT:    buffer_load_ushort v24, off, s[0:3], s32 offset:96
; VI-NEXT:    buffer_load_ushort v26, off, s[0:3], s32 offset:104
; VI-NEXT:    buffer_load_ushort v28, off, s[0:3], s32 offset:112
; VI-NEXT:    buffer_load_ushort v31, off, s[0:3], s32 offset:120
; VI-NEXT:    buffer_load_ushort v32, off, s[0:3], s32 offset:128
; VI-NEXT:    buffer_load_ushort v40, off, s[0:3], s32 offset:136
; VI-NEXT:    buffer_load_ushort v42, off, s[0:3], s32 offset:144
; VI-NEXT:    buffer_load_ushort v44, off, s[0:3], s32 offset:152
; VI-NEXT:    buffer_load_ushort v45, off, s[0:3], s32 offset:160
; VI-NEXT:    buffer_load_ushort v46, off, s[0:3], s32 offset:168
; VI-NEXT:    buffer_load_ushort v47, off, s[0:3], s32 offset:176
; VI-NEXT:    buffer_load_ushort v56, off, s[0:3], s32 offset:184
; VI-NEXT:    v_lshlrev_b16_e32 v43, 8, v1
; VI-NEXT:    v_lshlrev_b16_e32 v41, 8, v3
; VI-NEXT:    v_lshlrev_b16_e32 v55, 8, v5
; VI-NEXT:    v_lshlrev_b16_e32 v54, 8, v7
; VI-NEXT:    v_lshlrev_b16_e32 v53, 8, v9
; VI-NEXT:    v_lshlrev_b16_e32 v52, 8, v11
; VI-NEXT:    v_lshlrev_b16_e32 v51, 8, v13
; VI-NEXT:    v_lshlrev_b16_e32 v50, 8, v15
; VI-NEXT:    v_lshlrev_b16_e32 v49, 8, v17
; VI-NEXT:    v_lshlrev_b16_e32 v48, 8, v19
; VI-NEXT:    v_lshlrev_b16_e32 v39, 8, v21
; VI-NEXT:    v_lshlrev_b16_e32 v38, 8, v23
; VI-NEXT:    v_lshlrev_b16_e32 v37, 8, v25
; VI-NEXT:    v_lshlrev_b16_e32 v36, 8, v27
; VI-NEXT:    v_lshlrev_b16_e32 v35, 8, v29
; VI-NEXT:    s_waitcnt vmcnt(14)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v30
; VI-NEXT:    v_lshlrev_b16_e32 v34, 8, v0
; VI-NEXT:    v_lshlrev_b16_e32 v33, 8, v2
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v4
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:836 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v6
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:832 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v8
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:828 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v10
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:824 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v12
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:820 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v14
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:816 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v16
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:812 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v18
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:808 ; 4-byte Folded Spill
; VI-NEXT:    s_waitcnt vmcnt(14)
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v20
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:804 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v22
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:796 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v24
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:788 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v26
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:760 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v28
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:748 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:116
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:612 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v31
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:728 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:124
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:604 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:132
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:580 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:140
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:568 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:148
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:544 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v32
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:776 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v40
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:712 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v42
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:708 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v44
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:696 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:156
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:552 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:164
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:532 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:172
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:528 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:180
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:520 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v45
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:684 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v46
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:676 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v47
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:664 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v56
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:656 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:192
; VI-NEXT:    buffer_load_ushort v1, off, s[0:3], s32 offset:200
; VI-NEXT:    buffer_load_ushort v2, off, s[0:3], s32 offset:208
; VI-NEXT:    buffer_load_ushort v3, off, s[0:3], s32 offset:216
; VI-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:188
; VI-NEXT:    s_waitcnt vmcnt(4)
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:740 ; 4-byte Folded Spill
; VI-NEXT:    s_waitcnt vmcnt(4)
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v1
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:680 ; 4-byte Folded Spill
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:576 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:196
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v2
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:668 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v3
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:660 ; 4-byte Folded Spill
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:548 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:204
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:540 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:212
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:524 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:224
; VI-NEXT:    buffer_load_ushort v1, off, s[0:3], s32 offset:232
; VI-NEXT:    buffer_load_ushort v2, off, s[0:3], s32 offset:240
; VI-NEXT:    buffer_load_ushort v3, off, s[0:3], s32 offset:248
; VI-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:220
; VI-NEXT:    s_waitcnt vmcnt(4)
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:732 ; 4-byte Folded Spill
; VI-NEXT:    s_waitcnt vmcnt(4)
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v1
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:700 ; 4-byte Folded Spill
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:596 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:228
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v2
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:688 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v3
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:672 ; 4-byte Folded Spill
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:572 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:236
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:560 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:244
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:536 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:256
; VI-NEXT:    buffer_load_ushort v1, off, s[0:3], s32 offset:264
; VI-NEXT:    buffer_load_ushort v2, off, s[0:3], s32 offset:272
; VI-NEXT:    buffer_load_ushort v3, off, s[0:3], s32 offset:280
; VI-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:252
; VI-NEXT:    s_waitcnt vmcnt(4)
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:752 ; 4-byte Folded Spill
; VI-NEXT:    s_waitcnt vmcnt(4)
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v1
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:720 ; 4-byte Folded Spill
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:616 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:260
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v2
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:716 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v3
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:692 ; 4-byte Folded Spill
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:588 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:268
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:584 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:276
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:556 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:288
; VI-NEXT:    buffer_load_ushort v1, off, s[0:3], s32 offset:296
; VI-NEXT:    buffer_load_ushort v2, off, s[0:3], s32 offset:304
; VI-NEXT:    buffer_load_ushort v3, off, s[0:3], s32 offset:312
; VI-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:284
; VI-NEXT:    s_waitcnt vmcnt(4)
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:768 ; 4-byte Folded Spill
; VI-NEXT:    s_waitcnt vmcnt(4)
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v1
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:744 ; 4-byte Folded Spill
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:632 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:292
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v2
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:724 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v3
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:704 ; 4-byte Folded Spill
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:608 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:300
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:592 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:308
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:564 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:320
; VI-NEXT:    buffer_load_ushort v1, off, s[0:3], s32 offset:328
; VI-NEXT:    buffer_load_ushort v2, off, s[0:3], s32 offset:336
; VI-NEXT:    buffer_load_ushort v3, off, s[0:3], s32 offset:344
; VI-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:316
; VI-NEXT:    s_waitcnt vmcnt(4)
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:780 ; 4-byte Folded Spill
; VI-NEXT:    s_waitcnt vmcnt(4)
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v1
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:764 ; 4-byte Folded Spill
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:636 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:324
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v2
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:756 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v3
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:736 ; 4-byte Folded Spill
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:624 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:332
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:620 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:340
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:600 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:352
; VI-NEXT:    buffer_load_ushort v1, off, s[0:3], s32 offset:360
; VI-NEXT:    buffer_load_ushort v2, off, s[0:3], s32 offset:368
; VI-NEXT:    buffer_load_ushort v3, off, s[0:3], s32 offset:376
; VI-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:348
; VI-NEXT:    s_waitcnt vmcnt(4)
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:800 ; 4-byte Folded Spill
; VI-NEXT:    s_waitcnt vmcnt(4)
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v1
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:792 ; 4-byte Folded Spill
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:652 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:356
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v2
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:784 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v3
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:772 ; 4-byte Folded Spill
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:648 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:364
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:640 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:372
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:628 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:384
; VI-NEXT:    buffer_load_ushort v1, off, s[0:3], s32 offset:380
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_lshlrev_b16_e32 v63, 8, v0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:644 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v56, off, s[0:3], s32 offset:44
; VI-NEXT:    buffer_load_ushort v58, off, s[0:3], s32 offset:36
; VI-NEXT:    buffer_load_ushort v60, off, s[0:3], s32 offset:28
; VI-NEXT:    buffer_load_ushort v32, off, s[0:3], s32 offset:20
; VI-NEXT:    buffer_load_ushort v61, off, s[0:3], s32 offset:12
; VI-NEXT:    buffer_load_ushort v62, off, s[0:3], s32 offset:4
; VI-NEXT:    buffer_load_ushort v40, off, s[0:3], s32 offset:108
; VI-NEXT:    buffer_load_ushort v42, off, s[0:3], s32 offset:100
; VI-NEXT:    buffer_load_ushort v44, off, s[0:3], s32 offset:92
; VI-NEXT:    buffer_load_ushort v45, off, s[0:3], s32 offset:84
; VI-NEXT:    buffer_load_ushort v46, off, s[0:3], s32 offset:76
; VI-NEXT:    buffer_load_ushort v47, off, s[0:3], s32 offset:68
; VI-NEXT:    buffer_load_ushort v57, off, s[0:3], s32 offset:60
; VI-NEXT:    buffer_load_ushort v59, off, s[0:3], s32 offset:52
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB14_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:516 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:508 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:504 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:836 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:512 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:828 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:820 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:488 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:812 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:480 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:804 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:472 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:788 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:464 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:748 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:456 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(14)
; VI-NEXT:    v_or_b32_sdwa v0, v0, v43 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v2, v55 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(13)
; VI-NEXT:    v_or_b32_sdwa v3, v3, v54 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(12)
; VI-NEXT:    v_or_b32_sdwa v9, v61, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(11)
; VI-NEXT:    v_or_b32_sdwa v1, v1, v41 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:500 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:496 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(10)
; VI-NEXT:    v_or_b32_sdwa v4, v4, v50 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(8)
; VI-NEXT:    v_or_b32_sdwa v5, v5, v48 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(6)
; VI-NEXT:    v_or_b32_sdwa v6, v6, v38 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v10, v60, v10 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(4)
; VI-NEXT:    v_or_b32_sdwa v7, v7, v36 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v11, v56, v11 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v12, v57, v12 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v13, v46, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v14, v44, v14 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr61
; VI-NEXT:    ; implicit-def: $vgpr60
; VI-NEXT:    ; implicit-def: $vgpr56
; VI-NEXT:    ; implicit-def: $vgpr57
; VI-NEXT:    ; implicit-def: $vgpr46
; VI-NEXT:    ; implicit-def: $vgpr44
; VI-NEXT:    ; implicit-def: $vgpr43
; VI-NEXT:    ; implicit-def: $vgpr41
; VI-NEXT:    ; implicit-def: $vgpr55
; VI-NEXT:    ; implicit-def: $vgpr54
; VI-NEXT:    ; implicit-def: $vgpr50
; VI-NEXT:    ; implicit-def: $vgpr48
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_or_b32_sdwa v8, v8, v34 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v15, v40, v15 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr40
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_or_b32_sdwa v2, v2, v53 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v3, v3, v52 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:492 ; 4-byte Folded Reload
; VI-NEXT:    ; implicit-def: $vgpr53
; VI-NEXT:    ; implicit-def: $vgpr52
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v3, v3, v51 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:484 ; 4-byte Folded Reload
; VI-NEXT:    ; implicit-def: $vgpr51
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v4, v4, v49 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v4, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:476 ; 4-byte Folded Reload
; VI-NEXT:    ; implicit-def: $vgpr49
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v5, v5, v39 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v5, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:468 ; 4-byte Folded Reload
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v6, v6, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v6, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:460 ; 4-byte Folded Reload
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v7, v7, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v7, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v8, v62, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v8, v8, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:832 ; 4-byte Folded Reload
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr62
; VI-NEXT:    ; kill: killed $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v9, v32, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v9, v9, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:824 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v10, v58, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v10, v10, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:816 ; 4-byte Folded Reload
; VI-NEXT:    ; implicit-def: $vgpr58
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v11, v59, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v11, v11, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:808 ; 4-byte Folded Reload
; VI-NEXT:    ; implicit-def: $vgpr59
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v12, v47, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v12, v12, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:796 ; 4-byte Folded Reload
; VI-NEXT:    ; implicit-def: $vgpr47
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v13, v45, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v13, v13, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:760 ; 4-byte Folded Reload
; VI-NEXT:    ; implicit-def: $vgpr45
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v14, v42, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v14, v14, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:612 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:728 ; 4-byte Folded Reload
; VI-NEXT:    ; implicit-def: $vgpr42
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v15, v15, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:604 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:776 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v16, v16, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v15, v15, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:580 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:712 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v16, v16, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:568 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:708 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v17, v17, v18 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v16, v16, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:544 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:696 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v17, v17, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:552 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:684 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v18, v18, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v17, v17, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:532 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:676 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v18, v18, v19 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:528 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:664 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v19, v19, v20 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v18, v18, v19 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:520 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:656 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v19, v19, v20 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:576 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:740 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v20, v20, v21 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v19, v19, v20 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:548 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:680 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v20, v20, v21 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:540 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:668 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v21, v21, v22 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v20, v20, v21 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:524 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:660 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v21, v21, v22 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:596 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:732 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v22, v22, v23 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v21, v21, v22 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:572 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:700 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v22, v22, v23 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:560 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:688 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v23, v23, v24 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v22, v22, v23 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:536 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:672 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v23, v23, v24 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:616 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:752 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v24, v24, v25 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v23, v23, v24 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:588 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:720 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v24, v24, v25 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:584 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:716 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v25, v25, v26 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v24, v24, v25 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:556 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:692 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v25, v25, v26 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:632 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:768 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v26, v26, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v25, v25, v26 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:608 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:744 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v26, v26, v27 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:592 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:724 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v27, v27, v28 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v26, v26, v27 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:564 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:704 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v27, v27, v28 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:636 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:780 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v28, v28, v29 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v27, v27, v28 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:624 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:764 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v28, v28, v29 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:620 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:756 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v29, v29, v30 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v28, v28, v29 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:600 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:736 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v29, v29, v30 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:652 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:800 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v30, v30, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v29, v29, v30 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:648 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:792 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v30, v30, v31 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:640 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:784 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v31, v31, v32 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v30, v30, v31 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:628 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:772 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v31, v31, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:644 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v32, v32, v63 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    v_or_b32_sdwa v31, v31, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:    ; kill: killed $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; kill: killed $vgpr63
; VI-NEXT:    ; implicit-def: $vgpr63
; VI-NEXT:  .LBB14_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB14_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:836 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:748 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:664 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:456 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(13)
; VI-NEXT:    v_add_u16_e32 v9, 3, v61
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:516 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:508 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:504 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:724 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:512 ; 4-byte Folded Reload
; VI-NEXT:    v_mov_b32_e32 v31, 0x300
; VI-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:828 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:716 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:820 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:708 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:488 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:812 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:688 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:480 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:804 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:684 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:472 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:788 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:668 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:464 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:776 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:768 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:740 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:732 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:780 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:752 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:756 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(14)
; VI-NEXT:    v_or_b32_sdwa v9, v10, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:832 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u16_sdwa v9, v9, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_u16_e32 v8, 3, v8
; VI-NEXT:    v_or_b32_sdwa v8, v34, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v0, 3, v0
; VI-NEXT:    v_add_u16_e32 v2, 3, v2
; VI-NEXT:    v_add_u16_e32 v3, 3, v3
; VI-NEXT:    v_or_b32_sdwa v0, v43, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v1, 3, v1
; VI-NEXT:    v_or_b32_sdwa v1, v41, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v2, v55, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v3, v54, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v0, 0x300, v0
; VI-NEXT:    v_add_u16_sdwa v1, v1, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_u16_e32 v2, 0x300, v2
; VI-NEXT:    v_add_u16_sdwa v3, v3, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_or_b32_e32 v1, v2, v3
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:500 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:496 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u16_e32 v4, 3, v4
; VI-NEXT:    v_or_b32_sdwa v4, v50, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v4, v4, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(14)
; VI-NEXT:    v_add_u16_e32 v5, 3, v5
; VI-NEXT:    v_or_b32_sdwa v5, v48, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v5, v5, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(13)
; VI-NEXT:    v_add_u16_e32 v6, 3, v6
; VI-NEXT:    v_or_b32_sdwa v6, v38, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v6, v6, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(10)
; VI-NEXT:    v_add_u16_e32 v7, 3, v7
; VI-NEXT:    v_or_b32_sdwa v7, v36, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v7, v7, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_u16_sdwa v8, v8, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_add_u16_e32 v2, 3, v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v3, 3, v3
; VI-NEXT:    v_or_b32_sdwa v2, v53, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v3, v52, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v2, 0x300, v2
; VI-NEXT:    v_add_u16_sdwa v3, v3, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:492 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v3, 3, v3
; VI-NEXT:    v_or_b32_sdwa v3, v51, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v3, 0x300, v3
; VI-NEXT:    v_or_b32_e32 v3, v3, v4
; VI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:484 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v4, 3, v4
; VI-NEXT:    v_or_b32_sdwa v4, v49, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v4, 0x300, v4
; VI-NEXT:    v_or_b32_e32 v4, v4, v5
; VI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:476 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v5, 3, v5
; VI-NEXT:    v_or_b32_sdwa v5, v39, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v5, 0x300, v5
; VI-NEXT:    v_or_b32_e32 v5, v5, v6
; VI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:468 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v6, 3, v6
; VI-NEXT:    v_or_b32_sdwa v6, v37, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v6, 0x300, v6
; VI-NEXT:    v_or_b32_e32 v6, v6, v7
; VI-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:460 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v7, 3, v7
; VI-NEXT:    v_or_b32_sdwa v7, v35, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v7, 0x300, v7
; VI-NEXT:    v_or_b32_e32 v7, v7, v8
; VI-NEXT:    v_add_u16_e32 v8, 3, v62
; VI-NEXT:    v_or_b32_sdwa v8, v33, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v8, 0x300, v8
; VI-NEXT:    v_or_b32_e32 v8, v8, v9
; VI-NEXT:    v_add_u16_e32 v9, 3, v32
; VI-NEXT:    v_or_b32_sdwa v9, v10, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v10, 3, v60
; VI-NEXT:    v_or_b32_sdwa v10, v11, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:824 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u16_e32 v9, 0x300, v9
; VI-NEXT:    v_add_u16_sdwa v10, v10, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v9, v9, v10
; VI-NEXT:    v_add_u16_e32 v10, 3, v58
; VI-NEXT:    buffer_load_dword v33, off, s[0:3], s32 offset:784 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:800 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_or_b32_sdwa v10, v11, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v11, 3, v56
; VI-NEXT:    v_or_b32_sdwa v11, v12, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:816 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u16_e32 v10, 0x300, v10
; VI-NEXT:    v_add_u16_sdwa v11, v11, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v10, v10, v11
; VI-NEXT:    v_add_u16_e32 v11, 3, v59
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v11, v12, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v12, 3, v57
; VI-NEXT:    v_or_b32_sdwa v12, v13, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:808 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u16_e32 v11, 0x300, v11
; VI-NEXT:    v_add_u16_sdwa v12, v12, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v11, v11, v12
; VI-NEXT:    v_add_u16_e32 v12, 3, v47
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v12, v13, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v13, 3, v46
; VI-NEXT:    v_or_b32_sdwa v13, v14, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:796 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u16_e32 v12, 0x300, v12
; VI-NEXT:    v_add_u16_sdwa v13, v13, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v12, v12, v13
; VI-NEXT:    v_add_u16_e32 v13, 3, v45
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v13, v14, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v14, 3, v44
; VI-NEXT:    v_or_b32_sdwa v14, v15, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:760 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u16_e32 v13, 0x300, v13
; VI-NEXT:    v_add_u16_sdwa v14, v14, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v13, v13, v14
; VI-NEXT:    v_add_u16_e32 v14, 3, v42
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v14, v15, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v15, 3, v40
; VI-NEXT:    v_or_b32_sdwa v15, v16, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v14, 0x300, v14
; VI-NEXT:    v_add_u16_sdwa v15, v15, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v14, v14, v15
; VI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:612 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:728 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_add_u16_e32 v15, 3, v15
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v15, v16, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:604 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u16_e32 v15, 0x300, v15
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v16, 3, v16
; VI-NEXT:    v_or_b32_sdwa v16, v17, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v16, v16, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v15, v15, v16
; VI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:580 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:712 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_add_u16_e32 v16, 3, v16
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v16, v17, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:568 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u16_e32 v16, 0x300, v16
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v17, 3, v17
; VI-NEXT:    v_or_b32_sdwa v17, v18, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v17, v17, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v16, v16, v17
; VI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:544 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:696 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_add_u16_e32 v17, 3, v17
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v17, v18, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:552 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u16_e32 v17, 0x300, v17
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v18, 3, v18
; VI-NEXT:    v_or_b32_sdwa v18, v19, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v18, v18, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v17, v17, v18
; VI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:532 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:676 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_add_u16_e32 v18, 3, v18
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v18, v19, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:528 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u16_e32 v18, 0x300, v18
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v19, 3, v19
; VI-NEXT:    v_or_b32_sdwa v19, v20, v19 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v19, v19, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v18, v18, v19
; VI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:520 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:656 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_add_u16_e32 v19, 3, v19
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v19, v20, v19 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:576 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u16_e32 v19, 0x300, v19
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v20, 3, v20
; VI-NEXT:    v_or_b32_sdwa v20, v21, v20 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v20, v20, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v19, v19, v20
; VI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:548 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:680 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_add_u16_e32 v20, 3, v20
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v20, v21, v20 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:540 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u16_e32 v20, 0x300, v20
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v21, 3, v21
; VI-NEXT:    v_or_b32_sdwa v21, v22, v21 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v21, v21, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v20, v20, v21
; VI-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:524 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:660 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_add_u16_e32 v21, 3, v21
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v21, v22, v21 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:596 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u16_e32 v21, 0x300, v21
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v22, 3, v22
; VI-NEXT:    v_or_b32_sdwa v22, v23, v22 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v22, v22, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v21, v21, v22
; VI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:572 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:700 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_add_u16_e32 v22, 3, v22
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v22, v23, v22 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:560 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u16_e32 v22, 0x300, v22
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v23, 3, v23
; VI-NEXT:    v_or_b32_sdwa v23, v24, v23 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v23, v23, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v22, v22, v23
; VI-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:536 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:672 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_add_u16_e32 v23, 3, v23
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v23, v24, v23 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:616 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u16_e32 v23, 0x300, v23
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v24, 3, v24
; VI-NEXT:    v_or_b32_sdwa v24, v25, v24 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v24, v24, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v23, v23, v24
; VI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:588 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:720 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_add_u16_e32 v24, 3, v24
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v24, v25, v24 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:584 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u16_e32 v24, 0x300, v24
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v25, 3, v25
; VI-NEXT:    v_or_b32_sdwa v25, v26, v25 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v25, v25, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v24, v24, v25
; VI-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:556 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:692 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_add_u16_e32 v25, 3, v25
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v25, v26, v25 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:632 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u16_e32 v25, 0x300, v25
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v26, 3, v26
; VI-NEXT:    v_or_b32_sdwa v26, v27, v26 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v26, v26, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v25, v25, v26
; VI-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:608 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:744 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_add_u16_e32 v26, 3, v26
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v26, v27, v26 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:592 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u16_e32 v26, 0x300, v26
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v27, 3, v27
; VI-NEXT:    v_or_b32_sdwa v27, v28, v27 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v27, v27, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v26, v26, v27
; VI-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:564 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:704 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_add_u16_e32 v27, 3, v27
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v27, v28, v27 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:636 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u16_e32 v27, 0x300, v27
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v28, 3, v28
; VI-NEXT:    v_or_b32_sdwa v28, v29, v28 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v28, v28, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v27, v27, v28
; VI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:624 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:764 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_add_u16_e32 v28, 3, v28
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v28, v29, v28 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:620 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u16_e32 v28, 0x300, v28
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v29, 3, v29
; VI-NEXT:    v_or_b32_sdwa v29, v30, v29 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v29, v29, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v28, v28, v29
; VI-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:600 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:736 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_add_u16_e32 v29, 3, v29
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v29, v30, v29 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:652 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u16_e32 v29, 0x300, v29
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v30, 3, v30
; VI-NEXT:    v_or_b32_sdwa v30, v32, v30 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v30, v30, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v29, v29, v30
; VI-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:648 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:792 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_add_u16_e32 v30, 3, v30
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v30, v32, v30 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:640 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u16_e32 v30, 0x300, v30
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v32, 3, v32
; VI-NEXT:    v_or_b32_sdwa v32, v33, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v32, v32, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v30, v30, v32
; VI-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:628 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v33, off, s[0:3], s32 offset:772 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_add_u16_e32 v32, 3, v32
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v32, v33, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v33, off, s[0:3], s32 offset:644 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u16_e32 v32, 0x300, v32
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u16_e32 v33, 3, v33
; VI-NEXT:    v_or_b32_sdwa v33, v63, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v31, v33, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v31, v32, v31
; VI-NEXT:  .LBB14_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:392 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:396 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:400 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:404 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:408 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:412 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:416 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:420 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:424 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:428 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:432 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:436 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:440 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:444 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:448 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:452 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v128i8_to_v32i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:452 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:448 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:444 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:440 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:436 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:432 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:428 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:424 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:420 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:416 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:412 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:408 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:404 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:400 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:396 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:392 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v30, off, s[0:3], s32 offset:456 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v28, off, s[0:3], s32 offset:460 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v26, off, s[0:3], s32 offset:464 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v24, off, s[0:3], s32 offset:468 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v22, off, s[0:3], s32 offset:472 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v20, off, s[0:3], s32 offset:476 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:480 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v16, off, s[0:3], s32 offset:484 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:488 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:492 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:496 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:500 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:504 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:508 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:512 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:516 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:388
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_ushort v0, off, s[0:3], s32
; GFX9-NEXT:    buffer_load_ushort v2, off, s[0:3], s32 offset:8
; GFX9-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:16
; GFX9-NEXT:    buffer_load_ushort v6, off, s[0:3], s32 offset:24
; GFX9-NEXT:    buffer_load_ushort v8, off, s[0:3], s32 offset:32
; GFX9-NEXT:    buffer_load_ushort v10, off, s[0:3], s32 offset:40
; GFX9-NEXT:    buffer_load_ushort v12, off, s[0:3], s32 offset:48
; GFX9-NEXT:    buffer_load_ushort v14, off, s[0:3], s32 offset:56
; GFX9-NEXT:    buffer_load_ushort v16, off, s[0:3], s32 offset:64
; GFX9-NEXT:    buffer_load_ushort v18, off, s[0:3], s32 offset:72
; GFX9-NEXT:    buffer_load_ushort v20, off, s[0:3], s32 offset:80
; GFX9-NEXT:    buffer_load_ushort v22, off, s[0:3], s32 offset:88
; GFX9-NEXT:    buffer_load_ushort v24, off, s[0:3], s32 offset:96
; GFX9-NEXT:    buffer_load_ushort v26, off, s[0:3], s32 offset:104
; GFX9-NEXT:    buffer_load_ushort v28, off, s[0:3], s32 offset:112
; GFX9-NEXT:    buffer_load_ushort v31, off, s[0:3], s32 offset:120
; GFX9-NEXT:    buffer_load_ushort v32, off, s[0:3], s32 offset:128
; GFX9-NEXT:    buffer_load_ushort v40, off, s[0:3], s32 offset:136
; GFX9-NEXT:    buffer_load_ushort v42, off, s[0:3], s32 offset:144
; GFX9-NEXT:    buffer_load_ushort v44, off, s[0:3], s32 offset:152
; GFX9-NEXT:    buffer_load_ushort v45, off, s[0:3], s32 offset:160
; GFX9-NEXT:    buffer_load_ushort v46, off, s[0:3], s32 offset:168
; GFX9-NEXT:    buffer_load_ushort v47, off, s[0:3], s32 offset:176
; GFX9-NEXT:    buffer_load_ushort v56, off, s[0:3], s32 offset:184
; GFX9-NEXT:    v_lshlrev_b16_e32 v43, 8, v1
; GFX9-NEXT:    v_lshlrev_b16_e32 v41, 8, v3
; GFX9-NEXT:    v_lshlrev_b16_e32 v55, 8, v5
; GFX9-NEXT:    v_lshlrev_b16_e32 v54, 8, v7
; GFX9-NEXT:    v_lshlrev_b16_e32 v53, 8, v9
; GFX9-NEXT:    v_lshlrev_b16_e32 v52, 8, v11
; GFX9-NEXT:    v_lshlrev_b16_e32 v51, 8, v13
; GFX9-NEXT:    v_lshlrev_b16_e32 v50, 8, v15
; GFX9-NEXT:    v_lshlrev_b16_e32 v49, 8, v17
; GFX9-NEXT:    v_lshlrev_b16_e32 v48, 8, v19
; GFX9-NEXT:    v_lshlrev_b16_e32 v39, 8, v21
; GFX9-NEXT:    v_lshlrev_b16_e32 v38, 8, v23
; GFX9-NEXT:    v_lshlrev_b16_e32 v37, 8, v25
; GFX9-NEXT:    v_lshlrev_b16_e32 v36, 8, v27
; GFX9-NEXT:    v_lshlrev_b16_e32 v35, 8, v29
; GFX9-NEXT:    s_waitcnt vmcnt(24)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v30
; GFX9-NEXT:    s_waitcnt vmcnt(23)
; GFX9-NEXT:    v_lshlrev_b16_e32 v34, 8, v0
; GFX9-NEXT:    s_waitcnt vmcnt(22)
; GFX9-NEXT:    v_lshlrev_b16_e32 v33, 8, v2
; GFX9-NEXT:    s_waitcnt vmcnt(21)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v4
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:836 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(21)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v6
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:832 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(21)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v8
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:828 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(21)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v10
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:824 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(21)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v12
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:820 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(21)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v14
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:816 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(21)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v16
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:812 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(21)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v18
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:808 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(21)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v20
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:804 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(21)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v22
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:796 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(21)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v24
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:788 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(21)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v26
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:760 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(21)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v28
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:748 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:116
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:612 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v31
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:728 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:124
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:604 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:132
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:580 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:140
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:568 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:148
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:544 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v32
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:776 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v40
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:712 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v42
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:708 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v44
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:696 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:156
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:552 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:164
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:532 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:172
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:528 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:180
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:520 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v45
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:684 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v46
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:676 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v47
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:664 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v56
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:656 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:192
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_ushort v1, off, s[0:3], s32 offset:200
; GFX9-NEXT:    buffer_load_ushort v2, off, s[0:3], s32 offset:208
; GFX9-NEXT:    buffer_load_ushort v3, off, s[0:3], s32 offset:216
; GFX9-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:188
; GFX9-NEXT:    s_waitcnt vmcnt(4)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:740 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(4)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v1
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:680 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:576 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:196
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v2
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:668 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v3
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:660 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:548 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:204
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:540 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:212
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:524 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:224
; GFX9-NEXT:    buffer_load_ushort v1, off, s[0:3], s32 offset:232
; GFX9-NEXT:    buffer_load_ushort v2, off, s[0:3], s32 offset:240
; GFX9-NEXT:    buffer_load_ushort v3, off, s[0:3], s32 offset:248
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:220
; GFX9-NEXT:    s_waitcnt vmcnt(4)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:732 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(4)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v1
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:700 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:596 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:228
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v2
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:688 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v3
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:672 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:572 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:236
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:560 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:244
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:536 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:256
; GFX9-NEXT:    buffer_load_ushort v1, off, s[0:3], s32 offset:264
; GFX9-NEXT:    buffer_load_ushort v2, off, s[0:3], s32 offset:272
; GFX9-NEXT:    buffer_load_ushort v3, off, s[0:3], s32 offset:280
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:252
; GFX9-NEXT:    s_waitcnt vmcnt(4)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:752 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(4)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v1
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:720 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:616 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:260
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v2
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:716 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v3
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:692 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:588 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:268
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:584 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:276
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:556 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:288
; GFX9-NEXT:    buffer_load_ushort v1, off, s[0:3], s32 offset:296
; GFX9-NEXT:    buffer_load_ushort v2, off, s[0:3], s32 offset:304
; GFX9-NEXT:    buffer_load_ushort v3, off, s[0:3], s32 offset:312
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:284
; GFX9-NEXT:    s_waitcnt vmcnt(4)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:768 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(4)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v1
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:744 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:632 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:292
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v2
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:724 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v3
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:704 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:608 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:300
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:592 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:308
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:564 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:320
; GFX9-NEXT:    buffer_load_ushort v1, off, s[0:3], s32 offset:328
; GFX9-NEXT:    buffer_load_ushort v2, off, s[0:3], s32 offset:336
; GFX9-NEXT:    buffer_load_ushort v3, off, s[0:3], s32 offset:344
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:316
; GFX9-NEXT:    s_waitcnt vmcnt(4)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:780 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(4)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v1
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:764 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:636 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:324
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v2
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:756 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v3
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:736 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:624 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:332
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:620 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:340
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:600 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:352
; GFX9-NEXT:    buffer_load_ushort v1, off, s[0:3], s32 offset:360
; GFX9-NEXT:    buffer_load_ushort v2, off, s[0:3], s32 offset:368
; GFX9-NEXT:    buffer_load_ushort v3, off, s[0:3], s32 offset:376
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:348
; GFX9-NEXT:    s_waitcnt vmcnt(4)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:800 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(4)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v1
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:792 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:652 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:356
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v2
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:784 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v3
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:772 ; 4-byte Folded Spill
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:648 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:364
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:640 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v4, off, s[0:3], s32 offset:372
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:628 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:384
; GFX9-NEXT:    buffer_load_ushort v1, off, s[0:3], s32 offset:380
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshlrev_b16_e32 v63, 8, v0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:644 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_load_ushort v56, off, s[0:3], s32 offset:44
; GFX9-NEXT:    buffer_load_ushort v58, off, s[0:3], s32 offset:36
; GFX9-NEXT:    buffer_load_ushort v60, off, s[0:3], s32 offset:28
; GFX9-NEXT:    buffer_load_ushort v32, off, s[0:3], s32 offset:20
; GFX9-NEXT:    buffer_load_ushort v61, off, s[0:3], s32 offset:12
; GFX9-NEXT:    buffer_load_ushort v62, off, s[0:3], s32 offset:4
; GFX9-NEXT:    buffer_load_ushort v40, off, s[0:3], s32 offset:108
; GFX9-NEXT:    buffer_load_ushort v42, off, s[0:3], s32 offset:100
; GFX9-NEXT:    buffer_load_ushort v44, off, s[0:3], s32 offset:92
; GFX9-NEXT:    buffer_load_ushort v45, off, s[0:3], s32 offset:84
; GFX9-NEXT:    buffer_load_ushort v46, off, s[0:3], s32 offset:76
; GFX9-NEXT:    buffer_load_ushort v47, off, s[0:3], s32 offset:68
; GFX9-NEXT:    buffer_load_ushort v57, off, s[0:3], s32 offset:60
; GFX9-NEXT:    buffer_load_ushort v59, off, s[0:3], s32 offset:52
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB14_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:516 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:508 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:504 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:836 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:512 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:828 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:820 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:488 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:812 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:480 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:804 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:472 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:788 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:464 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:748 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:456 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(15)
; GFX9-NEXT:    v_or_b32_sdwa v0, v0, v43 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(14)
; GFX9-NEXT:    v_or_b32_sdwa v2, v2, v55 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(13)
; GFX9-NEXT:    v_or_b32_sdwa v3, v3, v54 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(12)
; GFX9-NEXT:    v_or_b32_sdwa v9, v61, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(11)
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v41 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:500 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:496 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(10)
; GFX9-NEXT:    v_or_b32_sdwa v4, v4, v50 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(8)
; GFX9-NEXT:    v_or_b32_sdwa v5, v5, v48 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(6)
; GFX9-NEXT:    v_or_b32_sdwa v6, v6, v38 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v10, v60, v10 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(4)
; GFX9-NEXT:    v_or_b32_sdwa v7, v7, v36 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v11, v56, v11 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v12, v57, v12 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v13, v46, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v14, v44, v14 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    ; implicit-def: $vgpr61
; GFX9-NEXT:    ; implicit-def: $vgpr60
; GFX9-NEXT:    ; implicit-def: $vgpr56
; GFX9-NEXT:    ; implicit-def: $vgpr57
; GFX9-NEXT:    ; implicit-def: $vgpr46
; GFX9-NEXT:    ; implicit-def: $vgpr44
; GFX9-NEXT:    ; implicit-def: $vgpr43
; GFX9-NEXT:    ; implicit-def: $vgpr41
; GFX9-NEXT:    ; implicit-def: $vgpr55
; GFX9-NEXT:    ; implicit-def: $vgpr54
; GFX9-NEXT:    ; implicit-def: $vgpr50
; GFX9-NEXT:    ; implicit-def: $vgpr48
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_or_b32_sdwa v8, v8, v34 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v15, v40, v15 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_or_b32_sdwa v2, v2, v53 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v3, v3, v52 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:492 ; 4-byte Folded Reload
; GFX9-NEXT:    ; implicit-def: $vgpr53
; GFX9-NEXT:    ; implicit-def: $vgpr52
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v3, v3, v51 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v3, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:484 ; 4-byte Folded Reload
; GFX9-NEXT:    ; implicit-def: $vgpr51
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v4, v4, v49 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v4, v4, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:476 ; 4-byte Folded Reload
; GFX9-NEXT:    ; implicit-def: $vgpr49
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v5, v5, v39 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v5, v5, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:468 ; 4-byte Folded Reload
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v6, v6, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v6, v6, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:460 ; 4-byte Folded Reload
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v7, v7, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v7, v7, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v8, v62, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v8, v8, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:832 ; 4-byte Folded Reload
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr62
; GFX9-NEXT:    ; kill: killed $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v9, v32, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v9, v9, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:824 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v10, v58, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v10, v10, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:816 ; 4-byte Folded Reload
; GFX9-NEXT:    ; implicit-def: $vgpr58
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v11, v59, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v11, v11, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:808 ; 4-byte Folded Reload
; GFX9-NEXT:    ; implicit-def: $vgpr59
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v12, v47, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v12, v12, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:796 ; 4-byte Folded Reload
; GFX9-NEXT:    ; implicit-def: $vgpr47
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v13, v45, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v13, v13, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:760 ; 4-byte Folded Reload
; GFX9-NEXT:    ; implicit-def: $vgpr45
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v14, v42, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v14, v14, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:612 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:728 ; 4-byte Folded Reload
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v15, v15, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:604 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:776 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v16, v16, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v15, v15, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:580 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:712 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v16, v16, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:568 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:708 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v17, v17, v18 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v16, v16, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:544 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:696 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v17, v17, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:552 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:684 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v18, v18, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v17, v17, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:532 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:676 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v18, v18, v19 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:528 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:664 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v19, v19, v20 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v18, v18, v19 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:520 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:656 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v19, v19, v20 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:576 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:740 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v20, v20, v21 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v19, v19, v20 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:548 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:680 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v20, v20, v21 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:540 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:668 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v21, v21, v22 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v20, v20, v21 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:524 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:660 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v21, v21, v22 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:596 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:732 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v22, v22, v23 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v21, v21, v22 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:572 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:700 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v22, v22, v23 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:560 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:688 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v23, v23, v24 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v22, v22, v23 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:536 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:672 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v23, v23, v24 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:616 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:752 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v24, v24, v25 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v23, v23, v24 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:588 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:720 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v24, v24, v25 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:584 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:716 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v25, v25, v26 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v24, v24, v25 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:556 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:692 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v25, v25, v26 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:632 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:768 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v26, v26, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v25, v25, v26 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:608 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:744 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v26, v26, v27 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:592 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:724 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v27, v27, v28 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v26, v26, v27 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:564 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:704 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v27, v27, v28 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:636 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:780 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v28, v28, v29 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v27, v27, v28 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:624 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:764 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v28, v28, v29 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:620 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:756 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v29, v29, v30 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v28, v28, v29 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:600 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:736 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v29, v29, v30 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:652 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:800 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v30, v30, v31 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v29, v29, v30 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:648 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:792 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v30, v30, v31 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:640 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:784 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v31, v31, v32 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v30, v30, v31 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:628 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:772 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v31, v31, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:644 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v32, v32, v63 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    v_or_b32_sdwa v31, v31, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; kill: killed $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; kill: killed $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:  .LBB14_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB14_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:836 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:748 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:664 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:456 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(13)
; GFX9-NEXT:    v_add_u16_e32 v9, 3, v61
; GFX9-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:516 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:508 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:504 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:724 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:512 ; 4-byte Folded Reload
; GFX9-NEXT:    s_movk_i32 s6, 0x300
; GFX9-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:828 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:716 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:820 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:708 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:488 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:812 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:688 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:480 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:804 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:684 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:472 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:788 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:668 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:464 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:776 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:768 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:740 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:732 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:780 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:752 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:756 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:800 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(30)
; GFX9-NEXT:    v_or_b32_sdwa v9, v10, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:832 ; 4-byte Folded Reload
; GFX9-NEXT:    v_add_u16_sdwa v9, v9, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(28)
; GFX9-NEXT:    v_add_u16_e32 v8, 3, v8
; GFX9-NEXT:    v_or_b32_sdwa v8, v34, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_waitcnt vmcnt(27)
; GFX9-NEXT:    v_add_u16_e32 v0, 3, v0
; GFX9-NEXT:    s_waitcnt vmcnt(26)
; GFX9-NEXT:    v_add_u16_e32 v2, 3, v2
; GFX9-NEXT:    s_waitcnt vmcnt(25)
; GFX9-NEXT:    v_add_u16_e32 v3, 3, v3
; GFX9-NEXT:    v_or_b32_sdwa v0, v43, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_waitcnt vmcnt(23)
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v1
; GFX9-NEXT:    v_or_b32_sdwa v1, v41, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v2, v55, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v3, v54, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u16_sdwa v1, v1, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_add_u16_e32 v2, 0x300, v2
; GFX9-NEXT:    v_add_u16_sdwa v3, v3, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX9-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX9-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:500 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:496 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(20)
; GFX9-NEXT:    v_add_u16_e32 v4, 3, v4
; GFX9-NEXT:    v_or_b32_sdwa v4, v50, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v4, v4, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(17)
; GFX9-NEXT:    v_add_u16_e32 v5, 3, v5
; GFX9-NEXT:    v_or_b32_sdwa v5, v48, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v5, v5, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(14)
; GFX9-NEXT:    v_add_u16_e32 v6, 3, v6
; GFX9-NEXT:    v_or_b32_sdwa v6, v38, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v6, v6, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(11)
; GFX9-NEXT:    v_add_u16_e32 v7, 3, v7
; GFX9-NEXT:    v_or_b32_sdwa v7, v36, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v7, v7, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_add_u16_sdwa v8, v8, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_add_u16_e32 v2, 3, v2
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v3, 3, v3
; GFX9-NEXT:    v_or_b32_sdwa v2, v53, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v3, v52, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v2, 0x300, v2
; GFX9-NEXT:    v_add_u16_sdwa v3, v3, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:492 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v3, 3, v3
; GFX9-NEXT:    v_or_b32_sdwa v3, v51, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v3, 0x300, v3
; GFX9-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX9-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:484 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v4, 3, v4
; GFX9-NEXT:    v_or_b32_sdwa v4, v49, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v4, 0x300, v4
; GFX9-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX9-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:476 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v5, 3, v5
; GFX9-NEXT:    v_or_b32_sdwa v5, v39, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v5, 0x300, v5
; GFX9-NEXT:    v_or_b32_e32 v5, v5, v6
; GFX9-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:468 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v6, 3, v6
; GFX9-NEXT:    v_or_b32_sdwa v6, v37, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v6, 0x300, v6
; GFX9-NEXT:    v_or_b32_e32 v6, v6, v7
; GFX9-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:460 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v7, 3, v7
; GFX9-NEXT:    v_or_b32_sdwa v7, v35, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v7, 0x300, v7
; GFX9-NEXT:    v_or_b32_e32 v7, v7, v8
; GFX9-NEXT:    v_add_u16_e32 v8, 3, v62
; GFX9-NEXT:    v_or_b32_sdwa v8, v33, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v8, 0x300, v8
; GFX9-NEXT:    v_or_b32_e32 v8, v8, v9
; GFX9-NEXT:    v_add_u16_e32 v9, 3, v32
; GFX9-NEXT:    v_or_b32_sdwa v9, v10, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v10, 3, v60
; GFX9-NEXT:    v_or_b32_sdwa v10, v11, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:824 ; 4-byte Folded Reload
; GFX9-NEXT:    v_add_u16_e32 v9, 0x300, v9
; GFX9-NEXT:    v_add_u16_sdwa v10, v10, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v9, v9, v10
; GFX9-NEXT:    v_add_u16_e32 v10, 3, v58
; GFX9-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:784 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_or_b32_sdwa v10, v11, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v11, 3, v56
; GFX9-NEXT:    v_or_b32_sdwa v11, v12, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:816 ; 4-byte Folded Reload
; GFX9-NEXT:    v_add_u16_e32 v10, 0x300, v10
; GFX9-NEXT:    v_add_u16_sdwa v11, v11, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v10, v10, v11
; GFX9-NEXT:    v_add_u16_e32 v11, 3, v59
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v11, v12, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v12, 3, v57
; GFX9-NEXT:    v_or_b32_sdwa v12, v13, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:808 ; 4-byte Folded Reload
; GFX9-NEXT:    v_add_u16_e32 v11, 0x300, v11
; GFX9-NEXT:    v_add_u16_sdwa v12, v12, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v11, v11, v12
; GFX9-NEXT:    v_add_u16_e32 v12, 3, v47
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v12, v13, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v13, 3, v46
; GFX9-NEXT:    v_or_b32_sdwa v13, v14, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:796 ; 4-byte Folded Reload
; GFX9-NEXT:    v_add_u16_e32 v12, 0x300, v12
; GFX9-NEXT:    v_add_u16_sdwa v13, v13, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v12, v12, v13
; GFX9-NEXT:    v_add_u16_e32 v13, 3, v45
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v13, v14, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v14, 3, v44
; GFX9-NEXT:    v_or_b32_sdwa v14, v15, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:760 ; 4-byte Folded Reload
; GFX9-NEXT:    v_add_u16_e32 v13, 0x300, v13
; GFX9-NEXT:    v_add_u16_sdwa v14, v14, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v13, v13, v14
; GFX9-NEXT:    v_add_u16_e32 v14, 3, v42
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v14, v15, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v15, 3, v40
; GFX9-NEXT:    v_or_b32_sdwa v15, v16, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v14, 0x300, v14
; GFX9-NEXT:    v_add_u16_sdwa v15, v15, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v14, v14, v15
; GFX9-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:612 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:728 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_add_u16_e32 v15, 3, v15
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v15, v16, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:604 ; 4-byte Folded Reload
; GFX9-NEXT:    v_add_u16_e32 v15, 0x300, v15
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v16, 3, v16
; GFX9-NEXT:    v_or_b32_sdwa v16, v17, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v16, v16, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v15, v15, v16
; GFX9-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:580 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:712 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_add_u16_e32 v16, 3, v16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v16, v17, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:568 ; 4-byte Folded Reload
; GFX9-NEXT:    v_add_u16_e32 v16, 0x300, v16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v17, 3, v17
; GFX9-NEXT:    v_or_b32_sdwa v17, v18, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v17, v17, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v16, v16, v17
; GFX9-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:544 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:696 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_add_u16_e32 v17, 3, v17
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v17, v18, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:552 ; 4-byte Folded Reload
; GFX9-NEXT:    v_add_u16_e32 v17, 0x300, v17
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v18, 3, v18
; GFX9-NEXT:    v_or_b32_sdwa v18, v19, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v18, v18, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v17, v17, v18
; GFX9-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:532 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:676 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_add_u16_e32 v18, 3, v18
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v18, v19, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:528 ; 4-byte Folded Reload
; GFX9-NEXT:    v_add_u16_e32 v18, 0x300, v18
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v19, 3, v19
; GFX9-NEXT:    v_or_b32_sdwa v19, v20, v19 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v19, v19, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v18, v18, v19
; GFX9-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:520 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:656 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_add_u16_e32 v19, 3, v19
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v19, v20, v19 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:576 ; 4-byte Folded Reload
; GFX9-NEXT:    v_add_u16_e32 v19, 0x300, v19
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v20, 3, v20
; GFX9-NEXT:    v_or_b32_sdwa v20, v21, v20 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v20, v20, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v19, v19, v20
; GFX9-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:548 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:680 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_add_u16_e32 v20, 3, v20
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v20, v21, v20 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:540 ; 4-byte Folded Reload
; GFX9-NEXT:    v_add_u16_e32 v20, 0x300, v20
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v21, 3, v21
; GFX9-NEXT:    v_or_b32_sdwa v21, v22, v21 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v21, v21, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v20, v20, v21
; GFX9-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:524 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:660 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_add_u16_e32 v21, 3, v21
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v21, v22, v21 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:596 ; 4-byte Folded Reload
; GFX9-NEXT:    v_add_u16_e32 v21, 0x300, v21
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v22, 3, v22
; GFX9-NEXT:    v_or_b32_sdwa v22, v23, v22 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v22, v22, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v21, v21, v22
; GFX9-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:572 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:700 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_add_u16_e32 v22, 3, v22
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v22, v23, v22 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:560 ; 4-byte Folded Reload
; GFX9-NEXT:    v_add_u16_e32 v22, 0x300, v22
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v23, 3, v23
; GFX9-NEXT:    v_or_b32_sdwa v23, v24, v23 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v23, v23, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v22, v22, v23
; GFX9-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:536 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:672 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_add_u16_e32 v23, 3, v23
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v23, v24, v23 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:616 ; 4-byte Folded Reload
; GFX9-NEXT:    v_add_u16_e32 v23, 0x300, v23
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v24, 3, v24
; GFX9-NEXT:    v_or_b32_sdwa v24, v25, v24 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v24, v24, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v23, v23, v24
; GFX9-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:588 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:720 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_add_u16_e32 v24, 3, v24
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v24, v25, v24 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:584 ; 4-byte Folded Reload
; GFX9-NEXT:    v_add_u16_e32 v24, 0x300, v24
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v25, 3, v25
; GFX9-NEXT:    v_or_b32_sdwa v25, v26, v25 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v25, v25, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v24, v24, v25
; GFX9-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:556 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:692 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_add_u16_e32 v25, 3, v25
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v25, v26, v25 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:632 ; 4-byte Folded Reload
; GFX9-NEXT:    v_add_u16_e32 v25, 0x300, v25
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v26, 3, v26
; GFX9-NEXT:    v_or_b32_sdwa v26, v27, v26 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v26, v26, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v25, v25, v26
; GFX9-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:608 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:744 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_add_u16_e32 v26, 3, v26
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v26, v27, v26 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:592 ; 4-byte Folded Reload
; GFX9-NEXT:    v_add_u16_e32 v26, 0x300, v26
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v27, 3, v27
; GFX9-NEXT:    v_or_b32_sdwa v27, v28, v27 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v27, v27, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v26, v26, v27
; GFX9-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:564 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:704 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_add_u16_e32 v27, 3, v27
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v27, v28, v27 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:636 ; 4-byte Folded Reload
; GFX9-NEXT:    v_add_u16_e32 v27, 0x300, v27
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v28, 3, v28
; GFX9-NEXT:    v_or_b32_sdwa v28, v29, v28 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v28, v28, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v27, v27, v28
; GFX9-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:624 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:764 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_add_u16_e32 v28, 3, v28
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v28, v29, v28 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:620 ; 4-byte Folded Reload
; GFX9-NEXT:    v_add_u16_e32 v28, 0x300, v28
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v29, 3, v29
; GFX9-NEXT:    v_or_b32_sdwa v29, v30, v29 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v29, v29, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v28, v28, v29
; GFX9-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:600 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:736 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_add_u16_e32 v29, 3, v29
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v29, v30, v29 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:652 ; 4-byte Folded Reload
; GFX9-NEXT:    v_add_u16_e32 v29, 0x300, v29
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v30, 3, v30
; GFX9-NEXT:    v_or_b32_sdwa v30, v31, v30 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v30, v30, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v29, v29, v30
; GFX9-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:648 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:792 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_add_u16_e32 v30, 3, v30
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v30, v31, v30 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:640 ; 4-byte Folded Reload
; GFX9-NEXT:    v_add_u16_e32 v30, 0x300, v30
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v31, 3, v31
; GFX9-NEXT:    v_or_b32_sdwa v31, v32, v31 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v31, v31, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v30, v30, v31
; GFX9-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:628 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:772 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_add_u16_e32 v31, 3, v31
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_or_b32_sdwa v31, v32, v31 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:644 ; 4-byte Folded Reload
; GFX9-NEXT:    v_add_u16_e32 v31, 0x300, v31
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v32, 3, v32
; GFX9-NEXT:    v_or_b32_sdwa v32, v63, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_sdwa v32, v32, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v31, v31, v32
; GFX9-NEXT:  .LBB14_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:392 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:396 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:400 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:404 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:408 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:412 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:416 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:420 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:424 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:428 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:432 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:436 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:440 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:444 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:448 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:452 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v128i8_to_v32i32:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_clause 0x1f
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v31, off, s32 offset:384
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v32, off, s32 offset:380
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v31, off, s32 offset:376
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v32, off, s32 offset:372
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v50, off, s32 offset:368
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v33, off, s32 offset:364
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v50, off, s32 offset:360
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v33, off, s32 offset:356
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v49, off, s32 offset:352
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v34, off, s32 offset:348
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v51, off, s32 offset:344
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v34, off, s32 offset:340
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v51, off, s32 offset:336
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v35, off, s32 offset:332
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v54, off, s32 offset:328
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v35, off, s32 offset:324
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v53, off, s32 offset:320
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v36, off, s32 offset:316
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v53, off, s32 offset:312
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v36, off, s32 offset:308
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v54, off, s32 offset:304
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v37, off, s32 offset:300
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v55, off, s32 offset:296
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v37, off, s32 offset:292
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v64, off, s32 offset:288
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v38, off, s32 offset:284
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v64, off, s32 offset:280
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v38, off, s32 offset:276
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v55, off, s32 offset:272
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v39, off, s32 offset:268
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v65, off, s32 offset:264
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v39, off, s32 offset:260
; GFX11-TRUE16-NEXT:    s_clause 0x1f
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v65, off, s32 offset:256
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v48, off, s32 offset:252
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v69, off, s32 offset:248
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v48, off, s32 offset:244
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v68, off, s32 offset:240
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v49, off, s32 offset:236
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v68, off, s32 offset:232
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v52, off, s32 offset:228
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v69, off, s32 offset:224
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v52, off, s32 offset:220
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v70, off, s32 offset:216
; GFX11-TRUE16-NEXT:    scratch_load_b32 v103, off, s32 offset:388
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v81, off, s32
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v81, off, s32 offset:8
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v82, off, s32 offset:16
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v82, off, s32 offset:24
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v83, off, s32 offset:32
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v86, off, s32 offset:40
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v86, off, s32 offset:48
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v87, off, s32 offset:56
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v87, off, s32 offset:64
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v96, off, s32 offset:72
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v99, off, s32 offset:80
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v99, off, s32 offset:88
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v100, off, s32 offset:96
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v100, off, s32 offset:104
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v101, off, s32 offset:112
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v160, off, s32 offset:120
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v160, off, s32 offset:128
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v161, off, s32 offset:136
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v161, off, s32 offset:144
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v162, off, s32 offset:152
; GFX11-TRUE16-NEXT:    s_clause 0x1f
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v162, off, s32 offset:160
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v163, off, s32 offset:168
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v163, off, s32 offset:176
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v164, off, s32 offset:184
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v164, off, s32 offset:192
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v165, off, s32 offset:200
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v165, off, s32 offset:208
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v66, off, s32 offset:212
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v66, off, s32 offset:204
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v67, off, s32 offset:196
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v67, off, s32 offset:188
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v70, off, s32 offset:180
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v71, off, s32 offset:172
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v71, off, s32 offset:164
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v80, off, s32 offset:156
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v80, off, s32 offset:148
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v83, off, s32 offset:140
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v84, off, s32 offset:132
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v84, off, s32 offset:124
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v85, off, s32 offset:116
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v85, off, s32 offset:108
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v96, off, s32 offset:100
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v97, off, s32 offset:92
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v97, off, s32 offset:84
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v98, off, s32 offset:76
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v98, off, s32 offset:68
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v101, off, s32 offset:60
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v102, off, s32 offset:52
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v102, off, s32 offset:44
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v113, off, s32 offset:36
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v114, off, s32 offset:28
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v114, off, s32 offset:20
; GFX11-TRUE16-NEXT:    s_clause 0x1
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v115, off, s32 offset:12
; GFX11-TRUE16-NEXT:    scratch_load_d16_hi_b16 v115, off, s32 offset:4
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v118.h, v30.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v119.l, v28.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v119.h, v26.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v130.h, v24.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v131.l, v22.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v131.h, v20.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v132.l, v18.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v135.l, v16.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v135.h, v14.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v144.l, v12.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v144.h, v10.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v145.l, v8.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v148.l, v6.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v148.h, v4.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v149.l, v2.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v149.h, v0.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v150.l, 8, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v150.h, 8, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v151.l, 8, v5.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v151.h, 8, v7.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v145.h, 8, v9.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v146.l, 8, v11.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v146.h, 8, v13.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v147.l, 8, v15.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v147.h, 8, v17.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v132.h, 8, v19.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v133.l, 8, v21.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v133.h, 8, v23.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v134.l, 8, v25.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v134.h, 8, v27.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v128.l, 8, v29.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(62)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v50.h, 8, v50.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v50.l, 8, v50.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v49.h, 8, v49.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v54.l, 8, v54.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v53.h, 8, v53.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v53.l, 8, v53.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v64.h, 8, v64.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v64.l, 8, v64.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v55.h, 8, v55.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v69.l, 8, v69.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(61)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v68.h, 8, v68.h
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(59)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v68.l, 8, v68.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(54)
; GFX11-TRUE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v103
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(53)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v128.h, 8, v81.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(52)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v129.l, 8, v81.h
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(51)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v129.h, 8, v82.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(50)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v130.l, 8, v82.h
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(49)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v116.l, 8, v83.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(48)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v116.h, 8, v86.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(47)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v117.l, 8, v86.h
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(46)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v117.h, 8, v87.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(45)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v118.l, 8, v87.h
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(44)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v103.l, 8, v96.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(43)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v103.h, 8, v99.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(42)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v112.l, 8, v99.h
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(41)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v112.h, 8, v100.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(40)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v113.l, 8, v100.h
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(39)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v99.l, 8, v101.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(38)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v99.h, 8, v160.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(37)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v100.l, 8, v160.h
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(36)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v100.h, 8, v161.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(35)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v101.l, 8, v161.h
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(34)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v86.l, 8, v162.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(33)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v86.h, 8, v162.h
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(32)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v87.l, 8, v163.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(31)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v87.h, 8, v163.h
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(30)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v96.l, 8, v164.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(29)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v81.l, 8, v164.h
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(28)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v81.h, 8, v165.l
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(27)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v82.l, 8, v165.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v82.h, 8, v70.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v83.l, 8, v69.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v69.h, 8, v65.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v70.l, 8, v65.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v65.l, 8, v55.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v65.h, 8, v54.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v54.h, 8, v51.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v55.l, 8, v51.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v51.l, 8, v31.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v51.h, 8, v31.l
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX11-TRUE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB14_3
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB14_4
; GFX11-TRUE16-NEXT:  .LBB14_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB14_3: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v149.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v149.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v148.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v148.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v0.h, v150.h
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v150.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v1.l, v151.l
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v1.h, v151.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX11-TRUE16-NEXT:    v_and_b16 v2.l, 0xff, v145.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v3
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, 0xff, v144.h
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v2.l, v145.h
; GFX11-TRUE16-NEXT:    v_and_b16 v3.l, 0xff, v144.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v5
; GFX11-TRUE16-NEXT:    v_and_b16 v4.l, 0xff, v135.l
; GFX11-TRUE16-NEXT:    v_or_b16 v5.l, v2.h, v146.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v7, 0xffff, v2
; GFX11-TRUE16-NEXT:    v_and_b16 v2.l, 0xff, v132.l
; GFX11-TRUE16-NEXT:    v_and_b16 v3.h, 0xff, v135.h
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v3.l, v146.h
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v4.l, v147.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v5
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, 0xff, v131.h
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v2.l, v132.h
; GFX11-TRUE16-NEXT:    v_or_b16 v6.l, v3.h, v147.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v9, 0xffff, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v11, 0xffff, v4
; GFX11-TRUE16-NEXT:    v_and_b16 v3.l, 0xff, v131.l
; GFX11-TRUE16-NEXT:    v_and_b16 v4.l, 0xff, v119.h
; GFX11-TRUE16-NEXT:    v_or_b16 v5.l, v2.h, v133.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v2
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v7, v8
; GFX11-TRUE16-NEXT:    v_and_b16 v7.l, 0xff, v119.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v6
; GFX11-TRUE16-NEXT:    v_and_b16 v3.h, 0xff, v130.h
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v3.l, v133.h
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v4.l, v134.h
; GFX11-TRUE16-NEXT:    v_and_b16 v7.h, 0xff, v118.h
; GFX11-TRUE16-NEXT:    v_or_b16 v7.l, v7.l, v128.l
; GFX11-TRUE16-NEXT:    v_or_b16 v6.l, v3.h, v134.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v3
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v4
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v3, v9, v10
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v4, v11, v12
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-TRUE16-NEXT:    v_and_b16 v8.l, 0xff, v115.h
; GFX11-TRUE16-NEXT:    v_and_b16 v9.l, 0xff, v114.h
; GFX11-TRUE16-NEXT:    v_or_b16 v10.l, v7.h, v128.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v12, 0xffff, v7
; GFX11-TRUE16-NEXT:    v_and_b16 v7.l, 0xff, v114.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v5, v5, v13
; GFX11-TRUE16-NEXT:    v_and_b16 v8.h, 0xff, v115.l
; GFX11-TRUE16-NEXT:    v_or_b16 v8.l, v8.l, v129.l
; GFX11-TRUE16-NEXT:    v_or_b16 v9.l, v9.l, v130.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v10
; GFX11-TRUE16-NEXT:    v_and_b16 v7.h, 0xff, v113.h
; GFX11-TRUE16-NEXT:    v_or_b16 v7.l, v7.l, v116.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v6, v6, v14
; GFX11-TRUE16-NEXT:    v_or_b16 v11.l, v8.h, v129.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v14, 0xffff, v8
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v16, 0xffff, v9
; GFX11-TRUE16-NEXT:    v_and_b16 v8.l, 0xff, v102.h
; GFX11-TRUE16-NEXT:    v_and_b16 v8.h, 0xff, v102.l
; GFX11-TRUE16-NEXT:    v_and_b16 v9.l, 0xff, v101.h
; GFX11-TRUE16-NEXT:    v_or_b16 v10.l, v7.h, v116.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v7
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v7, v12, v13
; GFX11-TRUE16-NEXT:    v_and_b16 v12.l, 0xff, v98.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v11
; GFX11-TRUE16-NEXT:    v_or_b16 v8.l, v8.l, v117.l
; GFX11-TRUE16-NEXT:    v_or_b16 v11.l, v8.h, v117.h
; GFX11-TRUE16-NEXT:    v_or_b16 v9.l, v9.l, v118.l
; GFX11-TRUE16-NEXT:    v_and_b16 v12.h, 0xff, v98.l
; GFX11-TRUE16-NEXT:    v_and_b16 v13.l, 0xff, v97.h
; GFX11-TRUE16-NEXT:    v_or_b16 v12.l, v12.l, v103.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v8
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v19, 16, v9
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v8, v14, v15
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v9, v16, v17
; GFX11-TRUE16-NEXT:    v_and_b16 v13.h, 0xff, v97.l
; GFX11-TRUE16-NEXT:    v_and_b16 v14.l, 0xff, v96.h
; GFX11-TRUE16-NEXT:    v_or_b16 v15.l, v12.h, v103.h
; GFX11-TRUE16-NEXT:    v_or_b16 v13.l, v13.l, v112.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v17, 0xffff, v12
; GFX11-TRUE16-NEXT:    v_and_b16 v12.l, 0xff, v85.h
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v10, v10, v18
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v11, v11, v19
; GFX11-TRUE16-NEXT:    v_or_b16 v16.l, v13.h, v112.h
; GFX11-TRUE16-NEXT:    v_or_b16 v14.l, v14.l, v113.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v15
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v19, 0xffff, v13
; GFX11-TRUE16-NEXT:    v_and_b16 v12.h, 0xff, v85.l
; GFX11-TRUE16-NEXT:    v_and_b16 v13.l, 0xff, v84.h
; GFX11-TRUE16-NEXT:    v_or_b16 v12.l, v12.l, v99.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v20, 16, v16
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v21, 0xffff, v14
; GFX11-TRUE16-NEXT:    v_and_b16 v13.h, 0xff, v84.l
; GFX11-TRUE16-NEXT:    v_and_b16 v14.l, 0xff, v83.h
; GFX11-TRUE16-NEXT:    v_or_b16 v15.l, v12.h, v99.h
; GFX11-TRUE16-NEXT:    v_or_b16 v13.l, v13.l, v100.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v12
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v12, v17, v18
; GFX11-TRUE16-NEXT:    v_and_b16 v17.l, 0xff, v80.h
; GFX11-TRUE16-NEXT:    v_or_b16 v16.l, v13.h, v100.h
; GFX11-TRUE16-NEXT:    v_or_b16 v14.l, v14.l, v101.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v13
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v13, v19, v20
; GFX11-TRUE16-NEXT:    v_and_b16 v17.h, 0xff, v80.l
; GFX11-TRUE16-NEXT:    v_and_b16 v18.l, 0xff, v71.h
; GFX11-TRUE16-NEXT:    v_and_b16 v19.l, 0xff, v70.h
; GFX11-TRUE16-NEXT:    v_or_b16 v17.l, v17.l, v86.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v16, 0xffff, v16
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v14
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v14, v21, v22
; GFX11-TRUE16-NEXT:    v_and_b16 v18.h, 0xff, v71.l
; GFX11-TRUE16-NEXT:    v_or_b16 v20.l, v17.h, v86.h
; GFX11-TRUE16-NEXT:    v_or_b16 v18.l, v18.l, v87.l
; GFX11-TRUE16-NEXT:    v_or_b16 v19.l, v19.l, v96.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v22, 0xffff, v17
; GFX11-TRUE16-NEXT:    v_and_b16 v17.l, 0xff, v67.h
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v15, v15, v23
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v16, v16, v24
; GFX11-TRUE16-NEXT:    v_or_b16 v21.l, v18.h, v87.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v20
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v24, 0xffff, v18
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v26, 0xffff, v19
; GFX11-TRUE16-NEXT:    v_and_b16 v17.h, 0xff, v67.l
; GFX11-TRUE16-NEXT:    v_and_b16 v18.l, 0xff, v66.h
; GFX11-TRUE16-NEXT:    v_and_b16 v18.h, 0xff, v66.l
; GFX11-TRUE16-NEXT:    v_and_b16 v19.l, 0xff, v52.h
; GFX11-TRUE16-NEXT:    v_or_b16 v17.l, v17.l, v81.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v21
; GFX11-TRUE16-NEXT:    v_or_b16 v20.l, v17.h, v81.h
; GFX11-TRUE16-NEXT:    v_or_b16 v18.l, v18.l, v82.l
; GFX11-TRUE16-NEXT:    v_or_b16 v21.l, v18.h, v82.h
; GFX11-TRUE16-NEXT:    v_or_b16 v19.l, v19.l, v83.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v27, 16, v17
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v17, v22, v23
; GFX11-TRUE16-NEXT:    v_and_b16 v22.l, 0xff, v52.l
; GFX11-TRUE16-NEXT:    v_and_b16 v23.l, 0xff, v48.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v28, 16, v18
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v21, 0xffff, v21
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v29, 16, v19
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v18, v24, v25
; GFX11-TRUE16-NEXT:    v_and_b16 v22.h, 0xff, v49.l
; GFX11-TRUE16-NEXT:    v_and_b16 v23.h, 0xff, v48.l
; GFX11-TRUE16-NEXT:    v_and_b16 v24.l, 0xff, v39.h
; GFX11-TRUE16-NEXT:    v_or_b16 v22.l, v22.l, v68.l
; GFX11-TRUE16-NEXT:    v_or_b16 v23.l, v23.l, v69.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v20, 0xffff, v20
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v19, v26, v27
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v21, v21, v29
; GFX11-TRUE16-NEXT:    v_or_b16 v25.l, v22.h, v68.h
; GFX11-TRUE16-NEXT:    v_or_b16 v26.l, v23.h, v69.h
; GFX11-TRUE16-NEXT:    v_or_b16 v24.l, v24.l, v70.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v27, 0xffff, v22
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v29, 0xffff, v23
; GFX11-TRUE16-NEXT:    v_and_b16 v22.l, 0xff, v39.l
; GFX11-TRUE16-NEXT:    v_and_b16 v23.l, 0xff, v38.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v20, v20, v28
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v28, 16, v25
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v30, 16, v26
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v31, 0xffff, v24
; GFX11-TRUE16-NEXT:    v_and_b16 v22.h, 0xff, v38.h
; GFX11-TRUE16-NEXT:    v_and_b16 v23.h, 0xff, v37.h
; GFX11-TRUE16-NEXT:    v_and_b16 v24.l, 0xff, v37.l
; GFX11-TRUE16-NEXT:    v_or_b16 v22.l, v22.l, v55.h
; GFX11-TRUE16-NEXT:    v_or_b16 v23.l, v23.l, v64.h
; GFX11-TRUE16-NEXT:    v_or_b16 v25.l, v22.h, v64.l
; GFX11-TRUE16-NEXT:    v_or_b16 v26.l, v23.h, v65.l
; GFX11-TRUE16-NEXT:    v_or_b16 v24.l, v24.l, v65.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v37, 16, v22
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v38, 16, v23
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v22, v27, v28
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v23, v29, v30
; GFX11-TRUE16-NEXT:    v_and_b16 v27.l, 0xff, v36.h
; GFX11-TRUE16-NEXT:    v_and_b16 v28.l, 0xff, v35.h
; GFX11-TRUE16-NEXT:    v_and_b16 v29.l, 0xff, v34.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v26, 0xffff, v26
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v39, 16, v24
; GFX11-TRUE16-NEXT:    v_and_b16 v27.h, 0xff, v36.l
; GFX11-TRUE16-NEXT:    v_and_b16 v28.h, 0xff, v35.l
; GFX11-TRUE16-NEXT:    v_or_b16 v27.l, v27.l, v53.l
; GFX11-TRUE16-NEXT:    v_or_b16 v28.l, v28.l, v54.l
; GFX11-TRUE16-NEXT:    v_or_b16 v29.l, v29.l, v55.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v25, 0xffff, v25
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v24, v31, v37
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v26, v26, v39
; GFX11-TRUE16-NEXT:    v_or_b16 v30.l, v27.h, v53.h
; GFX11-TRUE16-NEXT:    v_or_b16 v31.l, v28.h, v54.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v35, 0xffff, v27
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v37, 0xffff, v28
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v39, 0xffff, v29
; GFX11-TRUE16-NEXT:    v_and_b16 v27.l, 0xff, v34.l
; GFX11-TRUE16-NEXT:    v_and_b16 v27.h, 0xff, v33.h
; GFX11-TRUE16-NEXT:    v_and_b16 v28.l, 0xff, v33.l
; GFX11-TRUE16-NEXT:    v_and_b16 v28.h, 0xff, v32.h
; GFX11-TRUE16-NEXT:    v_and_b16 v29.l, 0xff, v32.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v25, v25, v38
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v36, 16, v30
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v38, 16, v31
; GFX11-TRUE16-NEXT:    v_or_b16 v27.l, v27.l, v49.h
; GFX11-TRUE16-NEXT:    v_or_b16 v30.l, v27.h, v50.l
; GFX11-TRUE16-NEXT:    v_or_b16 v28.l, v28.l, v50.h
; GFX11-TRUE16-NEXT:    v_or_b16 v31.l, v28.h, v51.l
; GFX11-TRUE16-NEXT:    v_or_b16 v29.l, v29.l, v51.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v32, 16, v27
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v30, 0xffff, v30
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v33, 16, v28
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v31, 0xffff, v31
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v34, 16, v29
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v27, v35, v36
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v28, v37, v38
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v29, v39, v32
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v30, v30, v33
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v31, v31, v34
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr149_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr149_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr148_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr148_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr145_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr144_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr144_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr135_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr135_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr132_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr131_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr131_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr130_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr119_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr119_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr118_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr115_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr115_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr114_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr114_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr113_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr102_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr102_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr101_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr98_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr98_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr97_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr97_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr96_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr85_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr85_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr84_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr84_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr83_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr80_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr80_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr71_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr71_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr70_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr67_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr67_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr66_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr66_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr52_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr52_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr49_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr48_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr48_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr39_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr39_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr38_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr38_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr37_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr37_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr36_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr36_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr35_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr35_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr34_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr34_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr33_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr33_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr32_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr32_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr150_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr150_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr151_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr151_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr145_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr146_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr146_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr147_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr147_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr132_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr133_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr133_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr134_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr134_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr128_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr128_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr129_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr129_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr130_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr116_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr116_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr117_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr117_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr118_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr103_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr103_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr112_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr112_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr113_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr99_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr99_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr100_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr100_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr101_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr86_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr86_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr87_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr87_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr96_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr81_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr81_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr82_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr82_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr83_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr68_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr68_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr69_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr69_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr70_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr55_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr64_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr64_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr65_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr65_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr53_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr53_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr54_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr54_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr55_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr49_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr50_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr50_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr51_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr51_hi16
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB14_2
; GFX11-TRUE16-NEXT:  .LBB14_4: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.h, v149.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, v149.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.h, v148.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.h, v145.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, v148.h, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v0.h
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v1.h
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, 0xff, v2.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v1.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.h, v150.h, v0.h
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v150.l, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v1.h, v151.h, v1.h
; GFX11-TRUE16-NEXT:    v_or_b16 v2.h, v145.h, v2.h
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v151.l, v1.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, 0x300, v0.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, 0x300, v0.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, 0x300, v1.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, 0x300, v1.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v2.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, v144.h, 3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, v144.l, 3
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v4
; GFX11-TRUE16-NEXT:    v_and_b16 v2.l, 0xff, v2.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.l, v135.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.h, v135.h, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v3.l, 0xff, v3.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v0, v5
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v146.l, v2.l
; GFX11-TRUE16-NEXT:    v_and_b16 v4.l, 0xff, v4.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v5.l, 0x300, v2.h
; GFX11-TRUE16-NEXT:    v_and_b16 v3.h, 0xff, v3.h
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v146.h, v3.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, 0x300, v2.l
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v147.h, v4.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v7, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_or_b16 v3.h, v147.l, v3.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, 0x300, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v2
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, v132.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.h, v131.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.l, 0x300, v4.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v9, 0xffff, v3
; GFX11-TRUE16-NEXT:    v_and_b16 v2.l, 0xff, v2.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, 0xff, v2.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v11, 0xffff, v4
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, v131.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.l, v119.h, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v132.h, v2.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.h, v133.l, v2.h
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v6
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v6.l, 0x300, v3.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.h, v130.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, 0x300, v2.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v5.l, 0x300, v2.h
; GFX11-TRUE16-NEXT:    v_and_b16 v3.l, 0xff, v3.l
; GFX11-TRUE16-NEXT:    v_and_b16 v4.l, 0xff, v4.l
; GFX11-TRUE16-NEXT:    v_and_b16 v3.h, 0xff, v3.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v2
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v7, v8
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v7.l, v119.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v7.h, v118.h, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v133.h, v3.l
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v134.h, v4.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v6
; GFX11-TRUE16-NEXT:    v_and_b16 v7.l, 0xff, v7.l
; GFX11-TRUE16-NEXT:    v_and_b16 v7.h, 0xff, v7.h
; GFX11-TRUE16-NEXT:    v_or_b16 v3.h, v134.l, v3.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, 0x300, v3.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.l, 0x300, v4.l
; GFX11-TRUE16-NEXT:    v_or_b16 v7.l, v128.l, v7.l
; GFX11-TRUE16-NEXT:    v_or_b16 v7.h, v128.h, v7.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v6.l, 0x300, v3.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v3
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v4
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v7.l, 0x300, v7.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v3, v9, v10
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v4, v11, v12
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v8.l, v115.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v9.l, v114.h, 3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v12, 0xffff, v7
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v7.l, v114.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v8.h, v115.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v8.l, 0xff, v8.l
; GFX11-TRUE16-NEXT:    v_and_b16 v9.l, 0xff, v9.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v10.l, 0x300, v7.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v7.h, v113.h, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v7.l, 0xff, v7.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_and_b16 v8.h, 0xff, v8.h
; GFX11-TRUE16-NEXT:    v_or_b16 v8.l, v129.l, v8.l
; GFX11-TRUE16-NEXT:    v_or_b16 v9.l, v130.l, v9.l
; GFX11-TRUE16-NEXT:    v_and_b16 v7.h, 0xff, v7.h
; GFX11-TRUE16-NEXT:    v_or_b16 v7.l, v116.l, v7.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v5, v5, v13
; GFX11-TRUE16-NEXT:    v_or_b16 v8.h, v129.h, v8.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v8.l, 0x300, v8.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v9.l, 0x300, v9.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v10
; GFX11-TRUE16-NEXT:    v_or_b16 v7.h, v116.h, v7.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v7.l, 0x300, v7.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v6, v6, v14
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v14, 0xffff, v8
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v16, 0xffff, v9
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v8.l, v102.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v9.l, v101.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v10.l, 0x300, v7.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v7
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v7, v12, v13
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v12.l, v98.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v11.l, 0x300, v8.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v8.h, v102.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v8.l, 0xff, v8.l
; GFX11-TRUE16-NEXT:    v_and_b16 v9.l, 0xff, v9.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v12.h, v98.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v12.l, 0xff, v12.l
; GFX11-TRUE16-NEXT:    v_and_b16 v8.h, 0xff, v8.h
; GFX11-TRUE16-NEXT:    v_or_b16 v8.l, v117.l, v8.l
; GFX11-TRUE16-NEXT:    v_or_b16 v9.l, v118.l, v9.l
; GFX11-TRUE16-NEXT:    v_and_b16 v12.h, 0xff, v12.h
; GFX11-TRUE16-NEXT:    v_or_b16 v12.l, v103.l, v12.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v11
; GFX11-TRUE16-NEXT:    v_or_b16 v8.h, v117.h, v8.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v8.l, 0x300, v8.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v9.l, 0x300, v9.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v13.l, v97.h, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v12.h, v103.h, v12.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v12.l, 0x300, v12.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v11.l, 0x300, v8.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v8
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v19, 16, v9
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v8, v14, v15
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v9, v16, v17
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v13.h, v97.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v14.l, v96.h, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v13.l, 0xff, v13.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v17, 0xffff, v12
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v12.l, v85.h, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v13.h, 0xff, v13.h
; GFX11-TRUE16-NEXT:    v_and_b16 v14.l, 0xff, v14.l
; GFX11-TRUE16-NEXT:    v_or_b16 v13.l, v112.l, v13.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v15.l, 0x300, v12.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v12.h, v85.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v12.l, 0xff, v12.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; GFX11-TRUE16-NEXT:    v_or_b16 v13.h, v112.h, v13.h
; GFX11-TRUE16-NEXT:    v_or_b16 v14.l, v113.l, v14.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v13.l, 0x300, v13.l
; GFX11-TRUE16-NEXT:    v_and_b16 v12.h, 0xff, v12.h
; GFX11-TRUE16-NEXT:    v_or_b16 v12.l, v99.l, v12.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v10, v10, v18
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v11, v11, v19
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v14.l, 0x300, v14.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v15
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v19, 0xffff, v13
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v13.l, v84.h, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v12.h, v99.h, v12.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v12.l, 0x300, v12.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v16.l, 0x300, v13.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v21, 0xffff, v14
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v13.h, v84.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v14.l, v83.h, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v13.l, 0xff, v13.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v15.l, 0x300, v12.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v12
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v12, v17, v18
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v17.l, v80.h, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v13.h, 0xff, v13.h
; GFX11-TRUE16-NEXT:    v_and_b16 v14.l, 0xff, v14.l
; GFX11-TRUE16-NEXT:    v_or_b16 v13.l, v100.l, v13.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v17.h, v80.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v17.l, 0xff, v17.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v20, 16, v16
; GFX11-TRUE16-NEXT:    v_or_b16 v13.h, v100.h, v13.h
; GFX11-TRUE16-NEXT:    v_or_b16 v14.l, v101.l, v14.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v13.l, 0x300, v13.l
; GFX11-TRUE16-NEXT:    v_and_b16 v17.h, 0xff, v17.h
; GFX11-TRUE16-NEXT:    v_or_b16 v17.l, v86.l, v17.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v16.l, 0x300, v13.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v14.l, 0x300, v14.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v13
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v13, v19, v20
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v18.l, v71.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v19.l, v70.h, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v17.h, v86.h, v17.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v17.l, 0x300, v17.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v14
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v14, v21, v22
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v18.h, v71.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v18.l, 0xff, v18.l
; GFX11-TRUE16-NEXT:    v_and_b16 v19.l, 0xff, v19.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v22, 0xffff, v17
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v17.l, v67.h, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v18.h, 0xff, v18.h
; GFX11-TRUE16-NEXT:    v_or_b16 v18.l, v87.l, v18.l
; GFX11-TRUE16-NEXT:    v_or_b16 v19.l, v96.l, v19.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v20.l, 0x300, v17.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v17.h, v67.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v17.l, 0xff, v17.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v16, 0xffff, v16
; GFX11-TRUE16-NEXT:    v_or_b16 v18.h, v87.h, v18.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v18.l, 0x300, v18.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v19.l, 0x300, v19.l
; GFX11-TRUE16-NEXT:    v_and_b16 v17.h, 0xff, v17.h
; GFX11-TRUE16-NEXT:    v_or_b16 v17.l, v81.l, v17.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v15, v15, v23
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v16, v16, v24
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v21.l, 0x300, v18.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v20
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v24, 0xffff, v18
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v26, 0xffff, v19
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v18.l, v66.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v18.h, v66.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v19.l, v52.h, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v17.h, v81.h, v17.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v17.l, 0x300, v17.l
; GFX11-TRUE16-NEXT:    v_and_b16 v18.l, 0xff, v18.l
; GFX11-TRUE16-NEXT:    v_and_b16 v18.h, 0xff, v18.h
; GFX11-TRUE16-NEXT:    v_and_b16 v19.l, 0xff, v19.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v20.l, 0x300, v17.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v27, 16, v17
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v17, v22, v23
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v22.l, v52.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v23.l, v48.h, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v18.l, v82.l, v18.l
; GFX11-TRUE16-NEXT:    v_or_b16 v18.h, v82.h, v18.h
; GFX11-TRUE16-NEXT:    v_or_b16 v19.l, v83.l, v19.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v22.h, v49.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v23.h, v48.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v22.l, 0xff, v22.l
; GFX11-TRUE16-NEXT:    v_and_b16 v23.l, 0xff, v23.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v21
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v18.l, 0x300, v18.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v21.l, 0x300, v18.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v19.l, 0x300, v19.l
; GFX11-TRUE16-NEXT:    v_and_b16 v22.h, 0xff, v22.h
; GFX11-TRUE16-NEXT:    v_and_b16 v23.h, 0xff, v23.h
; GFX11-TRUE16-NEXT:    v_or_b16 v22.l, v68.l, v22.l
; GFX11-TRUE16-NEXT:    v_or_b16 v23.l, v69.l, v23.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v28, 16, v18
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v21, 0xffff, v21
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v29, 16, v19
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v18, v24, v25
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v24.l, v39.h, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v22.h, v68.h, v22.h
; GFX11-TRUE16-NEXT:    v_or_b16 v23.h, v69.h, v23.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v22.l, 0x300, v22.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v23.l, 0x300, v23.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v19, v26, v27
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v21, v21, v29
; GFX11-TRUE16-NEXT:    v_and_b16 v24.l, 0xff, v24.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v27, 0xffff, v22
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v29, 0xffff, v23
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v22.l, v39.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v23.l, v38.l, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v24.l, v70.l, v24.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v25.l, 0x300, v22.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v26.l, 0x300, v23.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v22.h, v38.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v23.h, v37.h, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v22.l, 0xff, v22.l
; GFX11-TRUE16-NEXT:    v_and_b16 v23.l, 0xff, v23.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v20, 0xffff, v20
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v24.l, 0x300, v24.l
; GFX11-TRUE16-NEXT:    v_and_b16 v22.h, 0xff, v22.h
; GFX11-TRUE16-NEXT:    v_and_b16 v23.h, 0xff, v23.h
; GFX11-TRUE16-NEXT:    v_or_b16 v22.l, v55.h, v22.l
; GFX11-TRUE16-NEXT:    v_or_b16 v23.l, v64.h, v23.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v20, v20, v28
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v28, 16, v25
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v30, 16, v26
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v31, 0xffff, v24
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v24.l, v37.l, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v22.h, v64.l, v22.h
; GFX11-TRUE16-NEXT:    v_or_b16 v23.h, v65.l, v23.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v22.l, 0x300, v22.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v23.l, 0x300, v23.l
; GFX11-TRUE16-NEXT:    v_and_b16 v24.l, 0xff, v24.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v25.l, 0x300, v22.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v26.l, 0x300, v23.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v37, 16, v22
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v38, 16, v23
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v22, v27, v28
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v23, v29, v30
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v27.l, v36.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v28.l, v35.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v29.l, v34.h, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v24.l, v65.h, v24.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v27.h, v36.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v28.h, v35.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v27.l, 0xff, v27.l
; GFX11-TRUE16-NEXT:    v_and_b16 v28.l, 0xff, v28.l
; GFX11-TRUE16-NEXT:    v_and_b16 v29.l, 0xff, v29.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v24.l, 0x300, v24.l
; GFX11-TRUE16-NEXT:    v_and_b16 v27.h, 0xff, v27.h
; GFX11-TRUE16-NEXT:    v_and_b16 v28.h, 0xff, v28.h
; GFX11-TRUE16-NEXT:    v_or_b16 v27.l, v53.l, v27.l
; GFX11-TRUE16-NEXT:    v_or_b16 v28.l, v54.l, v28.l
; GFX11-TRUE16-NEXT:    v_or_b16 v29.l, v55.l, v29.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v26, 0xffff, v26
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v39, 16, v24
; GFX11-TRUE16-NEXT:    v_or_b16 v27.h, v53.h, v27.h
; GFX11-TRUE16-NEXT:    v_or_b16 v28.h, v54.h, v28.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v27.l, 0x300, v27.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v28.l, 0x300, v28.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v29.l, 0x300, v29.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v24, v31, v37
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v26, v26, v39
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v30.l, 0x300, v27.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v31.l, 0x300, v28.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v35, 0xffff, v27
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v37, 0xffff, v28
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v39, 0xffff, v29
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v27.l, v34.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v27.h, v33.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v28.l, v33.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v28.h, v32.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v29.l, v32.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v27.l, 0xff, v27.l
; GFX11-TRUE16-NEXT:    v_and_b16 v27.h, 0xff, v27.h
; GFX11-TRUE16-NEXT:    v_and_b16 v28.l, 0xff, v28.l
; GFX11-TRUE16-NEXT:    v_and_b16 v28.h, 0xff, v28.h
; GFX11-TRUE16-NEXT:    v_and_b16 v29.l, 0xff, v29.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v25, 0xffff, v25
; GFX11-TRUE16-NEXT:    v_or_b16 v27.l, v49.h, v27.l
; GFX11-TRUE16-NEXT:    v_or_b16 v27.h, v50.l, v27.h
; GFX11-TRUE16-NEXT:    v_or_b16 v28.l, v50.h, v28.l
; GFX11-TRUE16-NEXT:    v_or_b16 v28.h, v51.l, v28.h
; GFX11-TRUE16-NEXT:    v_or_b16 v29.l, v51.h, v29.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v25, v25, v38
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v36, 16, v30
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v38, 16, v31
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v27.l, 0x300, v27.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v30.l, 0x300, v27.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v28.l, 0x300, v28.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v31.l, 0x300, v28.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v29.l, 0x300, v29.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v32, 16, v27
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v30, 0xffff, v30
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v33, 16, v28
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v31, 0xffff, v31
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v34, 16, v29
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v27, v35, v36
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v28, v37, v38
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v29, v39, v32
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v30, v30, v33
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v31, v31, v34
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v128i8_to_v32i32:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_clause 0x1f
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v40, s32 offset:592
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v41, s32 offset:588
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v42, s32 offset:584
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v43, s32 offset:580
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v44, s32 offset:576
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v45, s32 offset:572
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v46, s32 offset:568
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v47, s32 offset:564
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v56, s32 offset:560
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v57, s32 offset:556
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v58, s32 offset:552
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v59, s32 offset:548
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v60, s32 offset:544
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v61, s32 offset:540
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v62, s32 offset:536
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v63, s32 offset:532
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v72, s32 offset:528
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v73, s32 offset:524
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v74, s32 offset:520
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v75, s32 offset:516
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v76, s32 offset:512
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v77, s32 offset:508
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v78, s32 offset:504
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v79, s32 offset:500
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v88, s32 offset:496
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v89, s32 offset:492
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v90, s32 offset:488
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v91, s32 offset:484
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v92, s32 offset:480
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v93, s32 offset:476
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v94, s32 offset:472
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v95, s32 offset:468
; GFX11-FAKE16-NEXT:    s_clause 0x12
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v104, s32 offset:464
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v105, s32 offset:460
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v106, s32 offset:456
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v107, s32 offset:452
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v108, s32 offset:448
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v109, s32 offset:444
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v110, s32 offset:440
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v111, s32 offset:436
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v120, s32 offset:432
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v121, s32 offset:428
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v122, s32 offset:424
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v123, s32 offset:420
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v124, s32 offset:416
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v125, s32 offset:412
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v126, s32 offset:408
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v127, s32 offset:404
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v136, s32 offset:400
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v137, s32 offset:396
; GFX11-FAKE16-NEXT:    scratch_store_b32 off, v138, s32 offset:392
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v32, v30 :: v_dual_mov_b32 v33, v28
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v34, v26 :: v_dual_mov_b32 v35, v24
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v36, v22 :: v_dual_mov_b32 v37, v20
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v38, v18 :: v_dual_mov_b32 v39, v16
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v48, v14 :: v_dual_mov_b32 v49, v12
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v50, v10 :: v_dual_mov_b32 v51, v8
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v52, v6 :: v_dual_mov_b32 v53, v4
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v54, v2 :: v_dual_mov_b32 v55, v0
; GFX11-FAKE16-NEXT:    s_clause 0x1f
; GFX11-FAKE16-NEXT:    scratch_load_u16 v0, off, s32 offset:384
; GFX11-FAKE16-NEXT:    scratch_load_u16 v64, off, s32 offset:380
; GFX11-FAKE16-NEXT:    scratch_load_u16 v2, off, s32 offset:376
; GFX11-FAKE16-NEXT:    scratch_load_u16 v65, off, s32 offset:372
; GFX11-FAKE16-NEXT:    scratch_load_u16 v4, off, s32 offset:368
; GFX11-FAKE16-NEXT:    scratch_load_u16 v66, off, s32 offset:364
; GFX11-FAKE16-NEXT:    scratch_load_u16 v6, off, s32 offset:360
; GFX11-FAKE16-NEXT:    scratch_load_u16 v67, off, s32 offset:356
; GFX11-FAKE16-NEXT:    scratch_load_u16 v8, off, s32 offset:352
; GFX11-FAKE16-NEXT:    scratch_load_u16 v68, off, s32 offset:348
; GFX11-FAKE16-NEXT:    scratch_load_u16 v10, off, s32 offset:344
; GFX11-FAKE16-NEXT:    scratch_load_u16 v69, off, s32 offset:340
; GFX11-FAKE16-NEXT:    scratch_load_u16 v12, off, s32 offset:336
; GFX11-FAKE16-NEXT:    scratch_load_u16 v70, off, s32 offset:332
; GFX11-FAKE16-NEXT:    scratch_load_u16 v14, off, s32 offset:328
; GFX11-FAKE16-NEXT:    scratch_load_u16 v71, off, s32 offset:324
; GFX11-FAKE16-NEXT:    scratch_load_u16 v16, off, s32 offset:320
; GFX11-FAKE16-NEXT:    scratch_load_u16 v80, off, s32 offset:316
; GFX11-FAKE16-NEXT:    scratch_load_u16 v18, off, s32 offset:312
; GFX11-FAKE16-NEXT:    scratch_load_u16 v81, off, s32 offset:308
; GFX11-FAKE16-NEXT:    scratch_load_u16 v20, off, s32 offset:304
; GFX11-FAKE16-NEXT:    scratch_load_u16 v82, off, s32 offset:300
; GFX11-FAKE16-NEXT:    scratch_load_u16 v22, off, s32 offset:296
; GFX11-FAKE16-NEXT:    scratch_load_u16 v83, off, s32 offset:292
; GFX11-FAKE16-NEXT:    scratch_load_u16 v24, off, s32 offset:288
; GFX11-FAKE16-NEXT:    scratch_load_u16 v84, off, s32 offset:284
; GFX11-FAKE16-NEXT:    scratch_load_u16 v26, off, s32 offset:280
; GFX11-FAKE16-NEXT:    scratch_load_u16 v85, off, s32 offset:276
; GFX11-FAKE16-NEXT:    scratch_load_u16 v28, off, s32 offset:272
; GFX11-FAKE16-NEXT:    scratch_load_u16 v86, off, s32 offset:268
; GFX11-FAKE16-NEXT:    scratch_load_u16 v30, off, s32 offset:264
; GFX11-FAKE16-NEXT:    scratch_load_u16 v87, off, s32 offset:260
; GFX11-FAKE16-NEXT:    s_clause 0x1f
; GFX11-FAKE16-NEXT:    scratch_load_u16 v31, off, s32 offset:256
; GFX11-FAKE16-NEXT:    scratch_load_u16 v96, off, s32 offset:252
; GFX11-FAKE16-NEXT:    scratch_load_u16 v99, off, s32 offset:248
; GFX11-FAKE16-NEXT:    scratch_load_u16 v97, off, s32 offset:244
; GFX11-FAKE16-NEXT:    scratch_load_u16 v100, off, s32 offset:240
; GFX11-FAKE16-NEXT:    scratch_load_u16 v98, off, s32 offset:236
; GFX11-FAKE16-NEXT:    scratch_load_u16 v101, off, s32 offset:232
; GFX11-FAKE16-NEXT:    scratch_load_u16 v112, off, s32 offset:228
; GFX11-FAKE16-NEXT:    scratch_load_u16 v102, off, s32 offset:224
; GFX11-FAKE16-NEXT:    scratch_load_u16 v113, off, s32 offset:220
; GFX11-FAKE16-NEXT:    scratch_load_u16 v103, off, s32 offset:216
; GFX11-FAKE16-NEXT:    scratch_load_b32 v114, off, s32 offset:388
; GFX11-FAKE16-NEXT:    scratch_load_u16 v115, off, s32
; GFX11-FAKE16-NEXT:    scratch_load_u16 v116, off, s32 offset:8
; GFX11-FAKE16-NEXT:    scratch_load_u16 v117, off, s32 offset:16
; GFX11-FAKE16-NEXT:    scratch_load_u16 v118, off, s32 offset:24
; GFX11-FAKE16-NEXT:    scratch_load_u16 v119, off, s32 offset:32
; GFX11-FAKE16-NEXT:    scratch_load_u16 v128, off, s32 offset:40
; GFX11-FAKE16-NEXT:    scratch_load_u16 v129, off, s32 offset:48
; GFX11-FAKE16-NEXT:    scratch_load_u16 v130, off, s32 offset:56
; GFX11-FAKE16-NEXT:    scratch_load_u16 v131, off, s32 offset:64
; GFX11-FAKE16-NEXT:    scratch_load_u16 v144, off, s32 offset:72
; GFX11-FAKE16-NEXT:    scratch_load_u16 v145, off, s32 offset:80
; GFX11-FAKE16-NEXT:    scratch_load_u16 v146, off, s32 offset:88
; GFX11-FAKE16-NEXT:    scratch_load_u16 v147, off, s32 offset:96
; GFX11-FAKE16-NEXT:    scratch_load_u16 v148, off, s32 offset:104
; GFX11-FAKE16-NEXT:    scratch_load_u16 v162, off, s32 offset:112
; GFX11-FAKE16-NEXT:    scratch_load_u16 v163, off, s32 offset:120
; GFX11-FAKE16-NEXT:    scratch_load_u16 v164, off, s32 offset:128
; GFX11-FAKE16-NEXT:    scratch_load_u16 v165, off, s32 offset:136
; GFX11-FAKE16-NEXT:    scratch_load_u16 v166, off, s32 offset:144
; GFX11-FAKE16-NEXT:    scratch_load_u16 v179, off, s32 offset:152
; GFX11-FAKE16-NEXT:    s_clause 0x1f
; GFX11-FAKE16-NEXT:    scratch_load_u16 v180, off, s32 offset:160
; GFX11-FAKE16-NEXT:    scratch_load_u16 v181, off, s32 offset:168
; GFX11-FAKE16-NEXT:    scratch_load_u16 v182, off, s32 offset:176
; GFX11-FAKE16-NEXT:    scratch_load_u16 v183, off, s32 offset:184
; GFX11-FAKE16-NEXT:    scratch_load_u16 v136, off, s32 offset:192
; GFX11-FAKE16-NEXT:    scratch_load_u16 v137, off, s32 offset:200
; GFX11-FAKE16-NEXT:    scratch_load_u16 v138, off, s32 offset:208
; GFX11-FAKE16-NEXT:    scratch_load_u16 v132, off, s32 offset:212
; GFX11-FAKE16-NEXT:    scratch_load_u16 v133, off, s32 offset:204
; GFX11-FAKE16-NEXT:    scratch_load_u16 v134, off, s32 offset:196
; GFX11-FAKE16-NEXT:    scratch_load_u16 v135, off, s32 offset:188
; GFX11-FAKE16-NEXT:    scratch_load_u16 v149, off, s32 offset:180
; GFX11-FAKE16-NEXT:    scratch_load_u16 v150, off, s32 offset:172
; GFX11-FAKE16-NEXT:    scratch_load_u16 v151, off, s32 offset:164
; GFX11-FAKE16-NEXT:    scratch_load_u16 v160, off, s32 offset:156
; GFX11-FAKE16-NEXT:    scratch_load_u16 v161, off, s32 offset:148
; GFX11-FAKE16-NEXT:    scratch_load_u16 v167, off, s32 offset:140
; GFX11-FAKE16-NEXT:    scratch_load_u16 v176, off, s32 offset:132
; GFX11-FAKE16-NEXT:    scratch_load_u16 v177, off, s32 offset:124
; GFX11-FAKE16-NEXT:    scratch_load_u16 v178, off, s32 offset:116
; GFX11-FAKE16-NEXT:    scratch_load_u16 v40, off, s32 offset:108
; GFX11-FAKE16-NEXT:    scratch_load_u16 v41, off, s32 offset:100
; GFX11-FAKE16-NEXT:    scratch_load_u16 v42, off, s32 offset:92
; GFX11-FAKE16-NEXT:    scratch_load_u16 v43, off, s32 offset:84
; GFX11-FAKE16-NEXT:    scratch_load_u16 v44, off, s32 offset:76
; GFX11-FAKE16-NEXT:    scratch_load_u16 v58, off, s32 offset:68
; GFX11-FAKE16-NEXT:    scratch_load_u16 v59, off, s32 offset:60
; GFX11-FAKE16-NEXT:    scratch_load_u16 v60, off, s32 offset:52
; GFX11-FAKE16-NEXT:    scratch_load_u16 v74, off, s32 offset:44
; GFX11-FAKE16-NEXT:    scratch_load_u16 v75, off, s32 offset:36
; GFX11-FAKE16-NEXT:    scratch_load_u16 v76, off, s32 offset:28
; GFX11-FAKE16-NEXT:    scratch_load_u16 v77, off, s32 offset:20
; GFX11-FAKE16-NEXT:    s_clause 0x1
; GFX11-FAKE16-NEXT:    scratch_load_u16 v78, off, s32 offset:12
; GFX11-FAKE16-NEXT:    scratch_load_u16 v92, off, s32 offset:4
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v124, 8, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v125, 8, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v126, 8, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v127, 8, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v111, 8, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v120, 8, v11
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v121, 8, v13
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v122, 8, v15
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v123, 8, v17
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v106, 8, v19
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v107, 8, v21
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v108, 8, v23
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v109, 8, v25
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v110, 8, v27
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v93, 8, v29
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(54)
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v114
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(53)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v94, 8, v115
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(52)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v95, 8, v116
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(51)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v104, 8, v117
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(50)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v105, 8, v118
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(49)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v79, 8, v119
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(48)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v88, 8, v128
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(47)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v89, 8, v129
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(46)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v90, 8, v130
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(45)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v91, 8, v131
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(44)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v61, 8, v144
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(43)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v62, 8, v145
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(42)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v63, 8, v146
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(41)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v72, 8, v147
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(40)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v73, 8, v148
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(39)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v45, 8, v162
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(38)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v46, 8, v163
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(37)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v47, 8, v164
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(36)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v56, 8, v165
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(35)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v57, 8, v166
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(34)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v179, 8, v179
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(33)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v180, 8, v180
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(32)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v181, 8, v181
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(31)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v182, 8, v182
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(30)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v183, 8, v183
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(29)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v162, 8, v136
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(28)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v163, 8, v137
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(27)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v164, 8, v138
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v165, 8, v103
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v166, 8, v102
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v144, 8, v101
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v145, 8, v100
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v146, 8, v99
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v147, 8, v31
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v148, 8, v30
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v119, 8, v28
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v128, 8, v26
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v129, 8, v24
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v130, 8, v22
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v131, 8, v20
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v114, 8, v18
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v115, 8, v16
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v116, 8, v14
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v117, 8, v12
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v118, 8, v10
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v99, 8, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v100, 8, v6
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v101, 8, v4
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v102, 8, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v103, 8, v0
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB14_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v55
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v54
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v53
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v52
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v51
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v124
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v125
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v2, v126
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v3, v127
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xff, v50
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v39
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xff, v37
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xff, v36
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v49
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v48
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xff, v35
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xff, v34
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v4, v111
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v2, v121
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v5, v120
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v3, v122
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v6, v123
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v8, v107
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v38
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v9, v108
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v10, v109
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v11, v110
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v2, v106
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v4, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v7, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v6, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v8, v9
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v10, v11
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xff, v33
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xff, v32
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xff, v92
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xff, v78
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xff, v77
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xff, v76
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v13, 0xff, v75
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xff, v74
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v15, 0xff, v60
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v16, 0xff, v59
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v7, v93
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v8, v94
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v9, v95
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v10, v104
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v11, v105
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v12, v79
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, v13, v88
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, v14, v89
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v15, v15, v90
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v16, v16, v91
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v16, 16, v16
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v7, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v9, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v11, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v13, v14
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v15, v16
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xff, v58
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v13, 0xff, v44
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xff, v43
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v15, 0xff, v42
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v16, 0xff, v41
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v17, 0xff, v40
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v18, 0xff, v178
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v19, 0xff, v177
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v20, 0xff, v176
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v21, 0xff, v167
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v12, v61
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, v13, v62
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, v14, v63
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v15, v15, v72
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v16, v16, v73
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v17, v17, v45
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v18, v18, v46
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v19, v19, v47
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, v20, v56
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v21, v21, v57
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v15
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v16, 0xffff, v16
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v18, 0xffff, v18
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v19, 16, v19
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v20, 0xffff, v20
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v12, v13
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, v14, v15
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, v16, v17
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v15, v18, v19
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v16, v20, v21
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v17, 0xff, v161
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v18, 0xff, v160
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v19, 0xff, v151
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v20, 0xff, v150
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v21, 0xff, v149
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v22, 0xff, v135
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v23, 0xff, v134
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v24, 0xff, v133
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v25, 0xff, v132
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v26, 0xff, v113
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v17, v17, v179
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v18, v18, v180
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v19, v19, v181
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, v20, v182
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v21, v21, v183
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v22, v22, v162
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v23, v23, v163
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v24, v24, v164
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v25, v25, v165
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v26, v26, v166
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v19, 0xffff, v19
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v20, 16, v20
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v21, 0xffff, v21
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v22
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v23, 0xffff, v23
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v25, 0xffff, v25
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v26, 16, v26
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v17, v17, v18
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v18, v19, v20
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v19, v21, v22
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, v23, v24
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v21, v25, v26
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v22, 0xff, v112
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v23, 0xff, v98
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v24, 0xff, v97
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v25, 0xff, v96
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v26, 0xff, v87
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v27, 0xff, v86
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v28, 0xff, v85
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v29, 0xff, v84
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v30, 0xff, v83
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v31, 0xff, v82
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v22, v22, v144
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v23, v23, v145
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v24, v24, v146
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v25, v25, v147
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v26, v26, v148
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v27, v27, v119
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v28, v28, v128
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v29, v29, v129
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v30, v30, v130
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v31, v31, v131
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v22, 0xffff, v22
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v24, 0xffff, v24
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v25
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v26, 0xffff, v26
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v27, 16, v27
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v28, 0xffff, v28
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v29, 16, v29
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v30, 0xffff, v30
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v31, 16, v31
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v22, v22, v23
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v23, v24, v25
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v24, v26, v27
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v25, v28, v29
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v26, v30, v31
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v27, 0xff, v81
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v28, 0xff, v80
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v29, 0xff, v71
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v30, 0xff, v70
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v31, 0xff, v69
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v32, 0xff, v68
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v33, 0xff, v67
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v34, 0xff, v66
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v35, 0xff, v65
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v36, 0xff, v64
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v27, v27, v114
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v28, v28, v115
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v29, v29, v116
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v30, v30, v117
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v31, v31, v118
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v32, v32, v99
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v33, v33, v100
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v34, v34, v101
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v35, v35, v102
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v36, v36, v103
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v27, 0xffff, v27
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v28, 16, v28
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v29, 0xffff, v29
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v30, 16, v30
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v31, 0xffff, v31
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v32, 16, v32
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v33, 0xffff, v33
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v34, 16, v34
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v35, 0xffff, v35
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v36, 16, v36
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v27, v27, v28
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v28, v29, v30
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v29, v31, v32
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v30, v33, v34
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v31, v35, v36
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr55
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr54
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr53
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr52
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr51
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr50
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr49
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr48
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr39
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr38
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr37
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr36
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr35
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr34
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr33
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr32
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr92
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr78
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr77
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr76
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr75
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr74
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr60
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr59
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr58
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr44
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr43
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr42
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr41
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr40
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr178
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr177
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr176
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr167
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr161
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr160
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr151
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr150
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr149
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr135
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr134
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr133
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr132
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr113
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr112
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr98
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr97
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr96
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr87
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr86
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr85
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr84
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr83
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr82
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr81
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr80
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr71
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr70
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr69
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr68
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr67
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr66
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr65
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr64
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr124
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr125
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr126
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr127
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr111
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr120
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr121
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr122
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr123
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr106
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr107
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr108
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr109
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr110
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr93
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr94
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr95
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr104
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr105
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr79
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr88
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr89
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr90
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr91
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr61
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr62
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr63
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr72
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr73
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr45
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr46
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr47
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr56
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr57
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr179
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr180
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr181
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr182
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr183
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr162
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr163
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr164
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr165
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr166
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr144
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr145
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr146
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr147
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr148
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr119
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr128
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr129
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr130
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr131
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr114
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr115
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr116
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr117
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr118
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr99
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr100
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr101
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr102
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr103
; GFX11-FAKE16-NEXT:  .LBB14_2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB14_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, v55, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, v54, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, v53, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, v52, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, v51, 3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v5, v50, 3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v124, v0
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v125, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v126, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v127, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v6, v49, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, 0x300, v0
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, 0x300, v1
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, 0x300, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, 0x300, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v7, v48, 3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v8, v37, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v9, v36, 3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v10, v35, 3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, v39, 3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xff, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v7
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v11, v34, 3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xff, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xff, v9
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xff, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v123, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xff, v11
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v111, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v120, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v121, v5
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, 0x300, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v122, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v107, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v108, v9
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v109, v10
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, v38, 3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v110, v11
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, 0x300, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, 0x300, v4
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v5, 0x300, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v6, 0x300, v6
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v8, 0x300, v8
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v9, 0x300, v9
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v10, 0x300, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v106, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v11, 0x300, v11
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, 0x300, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v3, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v5, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v8, v9
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v7, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v10, v11
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v7, v33, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v8, v32, 3
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v9, v92, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v10, v78, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v11, v77, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v12, v76, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v13, v75, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v14, v74, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v15, v60, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v16, v59, 3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xff, v7
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xff, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xff, v9
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xff, v10
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xff, v11
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xff, v12
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v13, 0xff, v13
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xff, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v15, 0xff, v15
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v16, 0xff, v16
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v93, v7
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v94, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v95, v9
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v104, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v105, v11
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v79, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, v88, v13
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, v89, v14
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v15, v90, v15
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v16, v91, v16
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v7, 0x300, v7
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v8, 0x300, v8
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v9, 0x300, v9
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v10, 0x300, v10
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v11, 0x300, v11
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v12, 0x300, v12
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v13, 0x300, v13
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v14, 0x300, v14
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v15, 0x300, v15
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v16, 0x300, v16
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v16, 16, v16
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v7, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v9, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v11, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v13, v14
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v15, v16
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v12, v58, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v13, v44, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v14, v43, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v15, v42, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v16, v41, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v17, v40, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v18, v178, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v19, v177, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v20, v176, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v21, v167, 3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xff, v12
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v13, 0xff, v13
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xff, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v15, 0xff, v15
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v16, 0xff, v16
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v17, 0xff, v17
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v18, 0xff, v18
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v19, 0xff, v19
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v20, 0xff, v20
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v21, 0xff, v21
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v61, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, v62, v13
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, v63, v14
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v15, v72, v15
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v16, v73, v16
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v17, v45, v17
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v18, v46, v18
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v19, v47, v19
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, v56, v20
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v21, v57, v21
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v12, 0x300, v12
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v13, 0x300, v13
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v14, 0x300, v14
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v15, 0x300, v15
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v16, 0x300, v16
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v17, 0x300, v17
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v18, 0x300, v18
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v19, 0x300, v19
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v20, 0x300, v20
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v21, 0x300, v21
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v15
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v16, 0xffff, v16
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v18, 0xffff, v18
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v19, 16, v19
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v20, 0xffff, v20
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v12, v13
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, v14, v15
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, v16, v17
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v15, v18, v19
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v16, v20, v21
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v17, v161, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v18, v160, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v19, v151, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v20, v150, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v21, v149, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v22, v135, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v23, v134, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v24, v133, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v25, v132, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v26, v113, 3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v17, 0xff, v17
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v18, 0xff, v18
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v19, 0xff, v19
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v20, 0xff, v20
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v21, 0xff, v21
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v22, 0xff, v22
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v23, 0xff, v23
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v24, 0xff, v24
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v25, 0xff, v25
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v26, 0xff, v26
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v17, v179, v17
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v18, v180, v18
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v19, v181, v19
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, v182, v20
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v21, v183, v21
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v22, v162, v22
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v23, v163, v23
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v24, v164, v24
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v25, v165, v25
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v26, v166, v26
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v17, 0x300, v17
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v18, 0x300, v18
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v19, 0x300, v19
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v20, 0x300, v20
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v21, 0x300, v21
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v22, 0x300, v22
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v23, 0x300, v23
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v24, 0x300, v24
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v25, 0x300, v25
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v26, 0x300, v26
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v19, 0xffff, v19
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v20, 16, v20
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v21, 0xffff, v21
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v22
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v23, 0xffff, v23
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v25, 0xffff, v25
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v26, 16, v26
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v17, v17, v18
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v18, v19, v20
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v19, v21, v22
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v20, v23, v24
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v21, v25, v26
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v22, v112, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v23, v98, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v24, v97, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v25, v96, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v26, v87, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v27, v86, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v28, v85, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v29, v84, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v30, v83, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v31, v82, 3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v22, 0xff, v22
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v23, 0xff, v23
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v24, 0xff, v24
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v25, 0xff, v25
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v26, 0xff, v26
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v27, 0xff, v27
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v28, 0xff, v28
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v29, 0xff, v29
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v30, 0xff, v30
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v31, 0xff, v31
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v22, v144, v22
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v23, v145, v23
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v24, v146, v24
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v25, v147, v25
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v26, v148, v26
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v27, v119, v27
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v28, v128, v28
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v29, v129, v29
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v30, v130, v30
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v31, v131, v31
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v22, 0x300, v22
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v23, 0x300, v23
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v24, 0x300, v24
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v25, 0x300, v25
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v26, 0x300, v26
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v27, 0x300, v27
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v28, 0x300, v28
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v29, 0x300, v29
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v30, 0x300, v30
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v31, 0x300, v31
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v22, 0xffff, v22
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v24, 0xffff, v24
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v25
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v26, 0xffff, v26
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v27, 16, v27
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v28, 0xffff, v28
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v29, 16, v29
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v30, 0xffff, v30
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v31, 16, v31
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v22, v22, v23
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v23, v24, v25
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v24, v26, v27
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v25, v28, v29
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v26, v30, v31
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v27, v81, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v28, v80, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v29, v71, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v30, v70, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v31, v69, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v32, v68, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v33, v67, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v34, v66, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v35, v65, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v36, v64, 3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v27, 0xff, v27
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v28, 0xff, v28
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v29, 0xff, v29
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v30, 0xff, v30
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v31, 0xff, v31
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v32, 0xff, v32
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v33, 0xff, v33
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v34, 0xff, v34
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v35, 0xff, v35
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v36, 0xff, v36
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v27, v114, v27
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v28, v115, v28
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v29, v116, v29
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v30, v117, v30
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v31, v118, v31
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v32, v99, v32
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v33, v100, v33
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v34, v101, v34
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v35, v102, v35
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v36, v103, v36
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v27, 0x300, v27
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v28, 0x300, v28
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v29, 0x300, v29
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v30, 0x300, v30
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v31, 0x300, v31
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v32, 0x300, v32
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v33, 0x300, v33
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v34, 0x300, v34
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v35, 0x300, v35
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v36, 0x300, v36
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v27, 0xffff, v27
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v28, 16, v28
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v29, 0xffff, v29
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v30, 16, v30
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v31, 0xffff, v31
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v32, 16, v32
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v33, 0xffff, v33
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v34, 16, v34
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v35, 0xffff, v35
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v36, 16, v36
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v27, v27, v28
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v28, v29, v30
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v29, v31, v32
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v30, v33, v34
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v31, v35, v36
; GFX11-FAKE16-NEXT:  .LBB14_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_clause 0x1f
; GFX11-FAKE16-NEXT:    scratch_load_b32 v138, off, s32 offset:392
; GFX11-FAKE16-NEXT:    scratch_load_b32 v137, off, s32 offset:396
; GFX11-FAKE16-NEXT:    scratch_load_b32 v136, off, s32 offset:400
; GFX11-FAKE16-NEXT:    scratch_load_b32 v127, off, s32 offset:404
; GFX11-FAKE16-NEXT:    scratch_load_b32 v126, off, s32 offset:408
; GFX11-FAKE16-NEXT:    scratch_load_b32 v125, off, s32 offset:412
; GFX11-FAKE16-NEXT:    scratch_load_b32 v124, off, s32 offset:416
; GFX11-FAKE16-NEXT:    scratch_load_b32 v123, off, s32 offset:420
; GFX11-FAKE16-NEXT:    scratch_load_b32 v122, off, s32 offset:424
; GFX11-FAKE16-NEXT:    scratch_load_b32 v121, off, s32 offset:428
; GFX11-FAKE16-NEXT:    scratch_load_b32 v120, off, s32 offset:432
; GFX11-FAKE16-NEXT:    scratch_load_b32 v111, off, s32 offset:436
; GFX11-FAKE16-NEXT:    scratch_load_b32 v110, off, s32 offset:440
; GFX11-FAKE16-NEXT:    scratch_load_b32 v109, off, s32 offset:444
; GFX11-FAKE16-NEXT:    scratch_load_b32 v108, off, s32 offset:448
; GFX11-FAKE16-NEXT:    scratch_load_b32 v107, off, s32 offset:452
; GFX11-FAKE16-NEXT:    scratch_load_b32 v106, off, s32 offset:456
; GFX11-FAKE16-NEXT:    scratch_load_b32 v105, off, s32 offset:460
; GFX11-FAKE16-NEXT:    scratch_load_b32 v104, off, s32 offset:464
; GFX11-FAKE16-NEXT:    scratch_load_b32 v95, off, s32 offset:468
; GFX11-FAKE16-NEXT:    scratch_load_b32 v94, off, s32 offset:472
; GFX11-FAKE16-NEXT:    scratch_load_b32 v93, off, s32 offset:476
; GFX11-FAKE16-NEXT:    scratch_load_b32 v92, off, s32 offset:480
; GFX11-FAKE16-NEXT:    scratch_load_b32 v91, off, s32 offset:484
; GFX11-FAKE16-NEXT:    scratch_load_b32 v90, off, s32 offset:488
; GFX11-FAKE16-NEXT:    scratch_load_b32 v89, off, s32 offset:492
; GFX11-FAKE16-NEXT:    scratch_load_b32 v88, off, s32 offset:496
; GFX11-FAKE16-NEXT:    scratch_load_b32 v79, off, s32 offset:500
; GFX11-FAKE16-NEXT:    scratch_load_b32 v78, off, s32 offset:504
; GFX11-FAKE16-NEXT:    scratch_load_b32 v77, off, s32 offset:508
; GFX11-FAKE16-NEXT:    scratch_load_b32 v76, off, s32 offset:512
; GFX11-FAKE16-NEXT:    scratch_load_b32 v75, off, s32 offset:516
; GFX11-FAKE16-NEXT:    s_clause 0x12
; GFX11-FAKE16-NEXT:    scratch_load_b32 v74, off, s32 offset:520
; GFX11-FAKE16-NEXT:    scratch_load_b32 v73, off, s32 offset:524
; GFX11-FAKE16-NEXT:    scratch_load_b32 v72, off, s32 offset:528
; GFX11-FAKE16-NEXT:    scratch_load_b32 v63, off, s32 offset:532
; GFX11-FAKE16-NEXT:    scratch_load_b32 v62, off, s32 offset:536
; GFX11-FAKE16-NEXT:    scratch_load_b32 v61, off, s32 offset:540
; GFX11-FAKE16-NEXT:    scratch_load_b32 v60, off, s32 offset:544
; GFX11-FAKE16-NEXT:    scratch_load_b32 v59, off, s32 offset:548
; GFX11-FAKE16-NEXT:    scratch_load_b32 v58, off, s32 offset:552
; GFX11-FAKE16-NEXT:    scratch_load_b32 v57, off, s32 offset:556
; GFX11-FAKE16-NEXT:    scratch_load_b32 v56, off, s32 offset:560
; GFX11-FAKE16-NEXT:    scratch_load_b32 v47, off, s32 offset:564
; GFX11-FAKE16-NEXT:    scratch_load_b32 v46, off, s32 offset:568
; GFX11-FAKE16-NEXT:    scratch_load_b32 v45, off, s32 offset:572
; GFX11-FAKE16-NEXT:    scratch_load_b32 v44, off, s32 offset:576
; GFX11-FAKE16-NEXT:    scratch_load_b32 v43, off, s32 offset:580
; GFX11-FAKE16-NEXT:    scratch_load_b32 v42, off, s32 offset:584
; GFX11-FAKE16-NEXT:    scratch_load_b32 v41, off, s32 offset:588
; GFX11-FAKE16-NEXT:    scratch_load_b32 v40, off, s32 offset:592
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <128 x i8> %a, splat (i8 3)
  %a2 = bitcast <128 x i8> %a1 to <32 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <128 x i8> %a to <32 x i32>
  br label %end

end:
  %phi = phi <32 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <32 x i32> %phi
}

define inreg <32 x i32> @bitcast_v128i8_to_v32i32_scalar(<128 x i8> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v128i8_to_v32i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:396 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:392 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:388 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:384 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:380 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:376 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:372 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:368 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:364 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:360 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:356 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:352 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:348 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:344 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:340 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:336 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v30, off, s[0:3], s32 offset:420 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:548 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:332
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:8
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:16
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:24
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:32
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:40
; SI-NEXT:    buffer_load_dword v55, off, s[0:3], s32 offset:48
; SI-NEXT:    buffer_load_dword v54, off, s[0:3], s32 offset:56
; SI-NEXT:    buffer_load_dword v53, off, s[0:3], s32 offset:64
; SI-NEXT:    buffer_load_dword v52, off, s[0:3], s32 offset:72
; SI-NEXT:    buffer_load_dword v51, off, s[0:3], s32 offset:80
; SI-NEXT:    buffer_load_dword v50, off, s[0:3], s32 offset:88
; SI-NEXT:    buffer_load_dword v49, off, s[0:3], s32 offset:96
; SI-NEXT:    buffer_load_dword v48, off, s[0:3], s32 offset:104
; SI-NEXT:    buffer_load_dword v39, off, s[0:3], s32 offset:112
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:120
; SI-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:128
; SI-NEXT:    buffer_load_dword v33, off, s[0:3], s32 offset:136
; SI-NEXT:    buffer_load_dword v34, off, s[0:3], s32 offset:144
; SI-NEXT:    buffer_load_dword v35, off, s[0:3], s32 offset:152
; SI-NEXT:    buffer_load_dword v36, off, s[0:3], s32 offset:160
; SI-NEXT:    buffer_load_dword v37, off, s[0:3], s32 offset:168
; SI-NEXT:    buffer_load_dword v38, off, s[0:3], s32 offset:176
; SI-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:560 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v1, 8, v7
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:540 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v1, 24, v9
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:536 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v1, 8, v11
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:532 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v1, 24, v13
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:528 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v1, 24, v17
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:524 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v1, 8, v19
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:520 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v1, 24, v21
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:516 ; 4-byte Folded Spill
; SI-NEXT:    v_lshlrev_b32_e32 v60, 8, v3
; SI-NEXT:    v_lshlrev_b32_e32 v30, 24, v5
; SI-NEXT:    v_lshlrev_b32_e32 v15, 8, v15
; SI-NEXT:    s_waitcnt vmcnt(14)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v23
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:512 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v25
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:508 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v27
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:504 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v29
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:500 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v45
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:496 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v44
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:492 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v43
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:488 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v42
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:484 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v41
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:480 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v40
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:476 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v55
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:608 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v54
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:472 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v53
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:604 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v52
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:468 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v51
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:464 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v50
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:600 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v49
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:460 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v48
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:456 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v39
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:596 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v31
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:452 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v32
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:588 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(14) expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v33
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:448 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v34
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:444 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v35
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:440 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v36
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:436 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v37
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:432 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v38
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:424 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:184
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:192
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:200
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:208
; SI-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:216
; SI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:224
; SI-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:232
; SI-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:240
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    s_waitcnt vmcnt(7)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:592 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(7) expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:584 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(7) expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v13
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:580 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(7) expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v3
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:428 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(7) expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v11
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:576 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(7) expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v5
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:568 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(7) expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v9
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:416 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(7) expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v7
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:412 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:248
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:256
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:264
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:272
; SI-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:280
; SI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:288
; SI-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:296
; SI-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:304
; SI-NEXT:    s_waitcnt vmcnt(7)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:552 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(7) expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:572 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(7) expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v13
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:408 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(7) expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v3
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:404 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(7) expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v11
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:400 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(7) expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v5
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:564 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:312
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:320
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:328
; SI-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:4
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:12
; SI-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:20
; SI-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:28
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:36
; SI-NEXT:    s_waitcnt vmcnt(14)
; SI-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; SI-NEXT:    v_lshlrev_b32_e32 v5, 8, v7
; SI-NEXT:    s_waitcnt vmcnt(7)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:544 ; 4-byte Folded Spill
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:44
; SI-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:52
; SI-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:60
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:68
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:76
; SI-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:84
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:92
; SI-NEXT:    buffer_load_dword v55, off, s[0:3], s32 offset:100
; SI-NEXT:    buffer_load_dword v51, off, s[0:3], s32 offset:108
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:116
; SI-NEXT:    buffer_load_dword v50, off, s[0:3], s32 offset:124
; SI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:132
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:140
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:148
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:156
; SI-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:164
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:172
; SI-NEXT:    buffer_load_dword v39, off, s[0:3], s32 offset:180
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:188
; SI-NEXT:    buffer_load_dword v49, off, s[0:3], s32 offset:196
; SI-NEXT:    buffer_load_dword v53, off, s[0:3], s32 offset:204
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:212
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:220
; SI-NEXT:    buffer_load_dword v52, off, s[0:3], s32 offset:228
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:236
; SI-NEXT:    s_waitcnt vmcnt(14)
; SI-NEXT:    v_lshlrev_b32_e32 v7, 8, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:556 ; 4-byte Folded Spill
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:244
; SI-NEXT:    buffer_load_dword v48, off, s[0:3], s32 offset:252
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:260
; SI-NEXT:    buffer_load_dword v38, off, s[0:3], s32 offset:268
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:276
; SI-NEXT:    buffer_load_dword v37, off, s[0:3], s32 offset:284
; SI-NEXT:    buffer_load_dword v54, off, s[0:3], s32 offset:292
; SI-NEXT:    buffer_load_dword v36, off, s[0:3], s32 offset:300
; SI-NEXT:    buffer_load_dword v35, off, s[0:3], s32 offset:308
; SI-NEXT:    buffer_load_dword v34, off, s[0:3], s32 offset:316
; SI-NEXT:    buffer_load_dword v33, off, s[0:3], s32 offset:324
; SI-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:612 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:616 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v9, off, s[0:3], s32 offset:620 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:624 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v28, off, s[0:3], s32 offset:628 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v26, off, s[0:3], s32 offset:632 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v24, off, s[0:3], s32 offset:636 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v22, off, s[0:3], s32 offset:640 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:644 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v20, off, s[0:3], s32 offset:648 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:652 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:656 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v16, off, s[0:3], s32 offset:660 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:664 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:668 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:672 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:676 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:680 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:684 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v39, off, s[0:3], s32 offset:688 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:692 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v32, off, s[0:3], s32 offset:696 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v31, off, s[0:3], s32 offset:700 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:704 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:708 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:712 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v50, off, s[0:3], s32 offset:716 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:720 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v51, off, s[0:3], s32 offset:724 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v55, off, s[0:3], s32 offset:728 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v19, off, s[0:3], s32 offset:732 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v21, off, s[0:3], s32 offset:736 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v15, off, s[0:3], s32 offset:740 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:744 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:748 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v27, off, s[0:3], s32 offset:752 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v29, off, s[0:3], s32 offset:756 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:760 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v13, off, s[0:3], s32 offset:764 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v25, off, s[0:3], s32 offset:768 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v23, off, s[0:3], s32 offset:772 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v30, off, s[0:3], s32 offset:776 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:780 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:784 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v11, off, s[0:3], s32 offset:788 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(14)
; SI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:792 ; 4-byte Folded Spill
; SI-NEXT:    s_cbranch_scc0 .LBB15_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:540 ; 4-byte Folded Reload
; SI-NEXT:    v_mov_b32_e32 v57, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v4
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:536 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v6
; SI-NEXT:    v_or_b32_e32 v0, v0, v60
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v30, v1
; SI-NEXT:    s_waitcnt expcnt(4)
; SI-NEXT:    v_mov_b32_e32 v30, v5
; SI-NEXT:    s_and_b32 s4, s28, 0xff
; SI-NEXT:    s_lshl_b32 s5, s29, 8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 8
; SI-NEXT:    s_lshl_b32 s6, s19, 24
; SI-NEXT:    s_lshl_b32 s7, s23, 24
; SI-NEXT:    s_lshl_b32 s8, s27, 24
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v8
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v3, v4, v3
; SI-NEXT:    v_or_b32_e32 v4, v0, v1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:532 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_or_b32_e32 v5, v2, v3
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:528 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v10
; SI-NEXT:    v_mov_b32_e32 v3, v7
; SI-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:500 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v12
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:524 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v6, v0, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v14
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v16
; SI-NEXT:    v_or_b32_e32 v0, v0, v15
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:484 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:472 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:468 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:600 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_or_b32_e32 v7, v0, v1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:520 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:516 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v18
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:452 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v20
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_or_b32_e32 v8, v0, v1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:512 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:508 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v22
; SI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:440 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:592 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v24
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_mov_b32_e32 v2, v9
; SI-NEXT:    v_or_b32_e32 v9, v0, v1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:504 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v26
; SI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:576 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v28
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v10, v1
; SI-NEXT:    v_or_b32_e32 v10, v0, v1
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:420 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:496 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v11
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:492 ; 4-byte Folded Reload
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v1, v11, v1
; SI-NEXT:    v_or_b32_e32 v11, v0, v1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:488 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v17
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:456 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v23
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v12, v1
; SI-NEXT:    v_or_b32_e32 v12, v0, v1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:480 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v25
; SI-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:580 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v13
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:476 ; 4-byte Folded Reload
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v1, v13, v1
; SI-NEXT:    v_or_b32_e32 v13, v0, v1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:608 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v58
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v58, v1
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v29
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v14, v1
; SI-NEXT:    v_or_b32_e32 v14, v0, v1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:604 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v27
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v60, v1
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v62
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v15, v1
; SI-NEXT:    v_or_b32_e32 v15, v0, v1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:464 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v43
; SI-NEXT:    v_mov_b32_e32 v43, v16
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v21
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v16, v1
; SI-NEXT:    v_or_b32_e32 v16, v0, v1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:460 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v19
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:448 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:432 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v55
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v17, v1
; SI-NEXT:    v_or_b32_e32 v17, v0, v1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:596 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v51
; SI-NEXT:    v_mov_b32_e32 v55, v22
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v51, v1
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v44
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v18, v1
; SI-NEXT:    v_or_b32_e32 v18, v0, v1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:588 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v50
; SI-NEXT:    v_mov_b32_e32 v44, v23
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v50, v1
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v63
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v19, v1
; SI-NEXT:    v_or_b32_e32 v19, v0, v1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:444 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v61
; SI-NEXT:    v_mov_b32_e32 v61, v45
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:556 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:416 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:552 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:408 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v40
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v20, v1
; SI-NEXT:    v_or_b32_e32 v20, v0, v1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:436 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v31
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:548 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:400 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v32
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v21, v1
; SI-NEXT:    v_or_b32_e32 v21, v0, v1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:424 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v59
; SI-NEXT:    v_mov_b32_e32 v59, v24
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v39
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v22, v1
; SI-NEXT:    v_or_b32_e32 v22, v0, v1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:584 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v61
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v39, v1
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v49
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v23, v1
; SI-NEXT:    v_or_b32_e32 v23, v0, v1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:428 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v53
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v47
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v24, v1
; SI-NEXT:    v_or_b32_e32 v24, v0, v1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:568 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v42
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v42, v1
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v52
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v25, v1
; SI-NEXT:    v_or_b32_e32 v25, v0, v1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:412 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v45
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v56
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v63, v1
; SI-NEXT:    v_or_b32_e32 v26, v0, v1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:572 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v48
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v32, v1
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v46
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v27, v1
; SI-NEXT:    v_or_b32_e32 v27, v0, v1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:404 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v38
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v41
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v28, v1
; SI-NEXT:    v_or_b32_e32 v28, v0, v1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:564 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v37
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v62, v1
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v54
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:544 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v29, v0, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v36
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v35
; SI-NEXT:    v_or_b32_e32 v0, v0, v30
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_or_b32_e32 v30, v0, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v34
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v33
; SI-NEXT:    v_or_b32_e32 v0, v0, v3
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v57, v1
; SI-NEXT:    v_or_b32_e32 v31, v0, v1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:560 ; 4-byte Folded Reload
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v40
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v33, v34
; SI-NEXT:    v_mov_b32_e32 v34, v35
; SI-NEXT:    v_mov_b32_e32 v35, v36
; SI-NEXT:    v_mov_b32_e32 v36, v54
; SI-NEXT:    v_mov_b32_e32 v54, v37
; SI-NEXT:    v_mov_b32_e32 v37, v41
; SI-NEXT:    v_mov_b32_e32 v41, v38
; SI-NEXT:    v_mov_b32_e32 v38, v63
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_or_b32_e32 v3, s4, v0
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xff
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s20, 0xff
; SI-NEXT:    s_lshl_b32 s6, s21, 8
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s22, 0xff
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_and_b32 s5, s5, 0xffff
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s24, 0xff
; SI-NEXT:    s_lshl_b32 s7, s25, 8
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_and_b32 s7, s26, 0xff
; SI-NEXT:    s_lshl_b32 s7, s7, 16
; SI-NEXT:    s_and_b32 s6, s6, 0xffff
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    v_mov_b32_e32 v57, v1
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    s_mov_b64 s[4:5], 0
; SI-NEXT:    s_branch .LBB15_3
; SI-NEXT:  .LBB15_2:
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:560 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:608 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(2)
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:604 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:600 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v51, off, s[0:3], s32 offset:596 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v50, off, s[0:3], s32 offset:588 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v55, off, s[0:3], s32 offset:592 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v39, off, s[0:3], s32 offset:584 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:580 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:576 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:568 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:572 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:564 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v33, off, s[0:3], s32 offset:556 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:548 ; 4-byte Folded Reload
; SI-NEXT:    v_mov_b32_e32 v61, v45
; SI-NEXT:    s_mov_b64 s[4:5], -1
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_mov_b32_e32 v45, v33
; SI-NEXT:    v_mov_b32_e32 v33, v34
; SI-NEXT:    v_mov_b32_e32 v34, v35
; SI-NEXT:    v_mov_b32_e32 v35, v36
; SI-NEXT:    v_mov_b32_e32 v36, v54
; SI-NEXT:    v_mov_b32_e32 v54, v37
; SI-NEXT:    v_mov_b32_e32 v37, v41
; SI-NEXT:    v_mov_b32_e32 v41, v38
; SI-NEXT:    buffer_load_dword v38, off, s[0:3], s32 offset:552 ; 4-byte Folded Reload
; SI-NEXT:  .LBB15_3: ; %Flow
; SI-NEXT:    v_mov_b32_e32 v63, v46
; SI-NEXT:    s_andn2_b64 vcc, exec, s[4:5]
; SI-NEXT:    s_cbranch_vccnz .LBB15_5
; SI-NEXT:  ; %bb.4: ; %cmp.true
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:644 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:784 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:776 ; 4-byte Folded Reload
; SI-NEXT:    s_add_i32 s28, s28, 3
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v40
; SI-NEXT:    s_and_b32 s4, s28, 0xff
; SI-NEXT:    s_lshl_b32 s5, s29, 8
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    s_addk_i32 s4, 0x300
; SI-NEXT:    v_or_b32_e32 v0, v57, v0
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    v_or_b32_e32 v0, s4, v0
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_lshl_b32 s5, s17, 8
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s6, s18, 0xff
; SI-NEXT:    s_addk_i32 s4, 0x300
; SI-NEXT:    s_lshl_b32 s5, s19, 24
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s20, 0xff
; SI-NEXT:    s_lshl_b32 s6, s21, 8
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s7, s22, 0xff
; SI-NEXT:    s_addk_i32 s5, 0x300
; SI-NEXT:    s_lshl_b32 s6, s23, 24
; SI-NEXT:    s_lshl_b32 s7, s7, 16
; SI-NEXT:    s_and_b32 s5, s5, 0xffff
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s24, 0xff
; SI-NEXT:    s_lshl_b32 s7, s25, 8
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s8, s26, 0xff
; SI-NEXT:    s_addk_i32 s6, 0x300
; SI-NEXT:    s_lshl_b32 s7, s27, 24
; SI-NEXT:    s_lshl_b32 s8, s8, 16
; SI-NEXT:    s_and_b32 s6, s6, 0xffff
; SI-NEXT:    s_or_b32 s7, s7, s8
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_add_i32 s4, s4, 0x3000000
; SI-NEXT:    s_add_i32 s5, s5, 0x3000000
; SI-NEXT:    s_add_i32 s6, s6, 0x3000000
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:684 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x300, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x3000000, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:680 ; 4-byte Folded Reload
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_add_i32_e32 v4, vcc, 0x3000000, v1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:540 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:536 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:676 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v5, vcc, 0x3000000, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:672 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:532 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:528 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:668 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v6, vcc, 0x3000000, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:664 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:740 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:524 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:660 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x3000000, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:656 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:520 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:516 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:648 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v8, vcc, 0x3000000, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:640 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:512 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:508 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:636 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v9, vcc, 0x3000000, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:632 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:504 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:500 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:628 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v10, vcc, 0x3000000, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:420 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:496 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:492 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:788 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v11, vcc, 0x3000000, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:780 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:488 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:484 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:772 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v12, vcc, 0x3000000, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:768 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:480 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:476 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:764 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v13, vcc, 0x3000000, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:760 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:756 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:472 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_or_b32_e32 v0, v58, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v14, vcc, 0x3000000, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:752 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:748 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:468 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_or_b32_e32 v0, v60, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v15, vcc, 0x3000000, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:744 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:464 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:456 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:736 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v43, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v16, vcc, 0x3000000, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:732 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:460 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:728 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v17, vcc, 0x3000000, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:724 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:720 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:452 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_or_b32_e32 v0, v51, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v18, vcc, 0x3000000, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:716 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:712 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:448 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_or_b32_e32 v0, v50, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v19, vcc, 0x3000000, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:708 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:444 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:440 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:704 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v20, vcc, 0x3000000, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:700 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:436 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:432 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:696 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v21, vcc, 0x3000000, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:692 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:424 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:416 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:688 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v55, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v22, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v61
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v49
; SI-NEXT:    v_or_b32_e32 v0, v39, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_or_b32_e32 v1, v44, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:428 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v23, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v53
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v47
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_or_b32_e32 v1, v59, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v24, vcc, 0x3000000, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:652 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v52
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:408 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_or_b32_e32 v0, v42, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:412 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v25, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v45
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v56
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v38, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v26, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v48
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v63
; SI-NEXT:    v_or_b32_e32 v0, v32, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:404 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:400 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v27, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v41
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v37
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:620 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v28, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v54
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v36
; SI-NEXT:    v_or_b32_e32 v0, v62, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:612 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:544 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v29, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v35
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v34
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:624 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:616 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v30, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v33
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:792 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v31, vcc, 0x3000000, v0
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:  .LBB15_5: ; %end
; SI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:336 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:340 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:344 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:348 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:352 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:356 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:360 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:364 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:368 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:372 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:376 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:380 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:384 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:388 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:392 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:396 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v128i8_to_v32i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:396 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:392 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:388 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:384 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:380 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:376 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:372 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:368 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:364 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:360 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:356 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:352 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:348 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:344 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:340 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:336 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v30, off, s[0:3], s32 offset:420 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v28, off, s[0:3], s32 offset:424 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v26, off, s[0:3], s32 offset:428 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v24, off, s[0:3], s32 offset:432 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v22, off, s[0:3], s32 offset:440 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v20, off, s[0:3], s32 offset:448 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:452 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v16, off, s[0:3], s32 offset:460 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:464 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:472 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:476 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:484 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:488 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:556 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:332
; VI-NEXT:    buffer_load_ushort v44, off, s[0:3], s32
; VI-NEXT:    buffer_load_ushort v43, off, s[0:3], s32 offset:8
; VI-NEXT:    buffer_load_ushort v42, off, s[0:3], s32 offset:16
; VI-NEXT:    buffer_load_ushort v41, off, s[0:3], s32 offset:24
; VI-NEXT:    buffer_load_ushort v40, off, s[0:3], s32 offset:32
; VI-NEXT:    buffer_load_ushort v55, off, s[0:3], s32 offset:40
; VI-NEXT:    buffer_load_ushort v54, off, s[0:3], s32 offset:48
; VI-NEXT:    buffer_load_ushort v53, off, s[0:3], s32 offset:56
; VI-NEXT:    buffer_load_ushort v52, off, s[0:3], s32 offset:64
; VI-NEXT:    buffer_load_ushort v51, off, s[0:3], s32 offset:72
; VI-NEXT:    buffer_load_ushort v50, off, s[0:3], s32 offset:80
; VI-NEXT:    buffer_load_ushort v49, off, s[0:3], s32 offset:88
; VI-NEXT:    buffer_load_ushort v48, off, s[0:3], s32 offset:96
; VI-NEXT:    buffer_load_ushort v39, off, s[0:3], s32 offset:104
; VI-NEXT:    buffer_load_ushort v22, off, s[0:3], s32 offset:112
; VI-NEXT:    buffer_load_ushort v31, off, s[0:3], s32 offset:120
; VI-NEXT:    buffer_load_ushort v32, off, s[0:3], s32 offset:128
; VI-NEXT:    buffer_load_ushort v33, off, s[0:3], s32 offset:136
; VI-NEXT:    buffer_load_ushort v34, off, s[0:3], s32 offset:144
; VI-NEXT:    buffer_load_ushort v35, off, s[0:3], s32 offset:152
; VI-NEXT:    buffer_load_ushort v36, off, s[0:3], s32 offset:160
; VI-NEXT:    buffer_load_ushort v37, off, s[0:3], s32 offset:168
; VI-NEXT:    buffer_load_ushort v38, off, s[0:3], s32 offset:176
; VI-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; VI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:560 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v1, 8, v15
; VI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:548 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v1, 8, v17
; VI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:544 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v1, 8, v19
; VI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:540 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v1, 8, v21
; VI-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:536 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v8, 8, v3
; VI-NEXT:    v_lshlrev_b32_e32 v59, 8, v5
; VI-NEXT:    v_lshlrev_b32_e32 v14, 8, v7
; VI-NEXT:    v_lshlrev_b32_e32 v10, 8, v9
; VI-NEXT:    v_lshlrev_b32_e32 v16, 8, v11
; VI-NEXT:    v_lshlrev_b32_e32 v6, 8, v13
; VI-NEXT:    s_waitcnt vmcnt(14)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v23
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:532 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v25
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:528 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v27
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:524 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v29
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:520 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v44
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:516 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v43
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:512 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v42
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:508 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v41
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:504 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v40
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:580 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v55
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:500 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v54
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:584 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v53
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:496 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v52
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:608 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v51
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:492 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v50
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:600 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v49
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:604 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v48
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:596 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v39
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:480 ; 4-byte Folded Spill
; VI-NEXT:    s_waitcnt vmcnt(14)
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v22
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:572 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v31
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:588 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v32
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:592 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v33
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:468 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v34
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:456 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v35
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:444 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v36
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:436 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:184
; VI-NEXT:    buffer_load_ushort v1, off, s[0:3], s32 offset:192
; VI-NEXT:    buffer_load_ushort v13, off, s[0:3], s32 offset:200
; VI-NEXT:    buffer_load_ushort v3, off, s[0:3], s32 offset:208
; VI-NEXT:    buffer_load_ushort v11, off, s[0:3], s32 offset:216
; VI-NEXT:    buffer_load_ushort v5, off, s[0:3], s32 offset:224
; VI-NEXT:    buffer_load_ushort v9, off, s[0:3], s32 offset:232
; VI-NEXT:    buffer_load_ushort v7, off, s[0:3], s32 offset:240
; VI-NEXT:    v_lshlrev_b32_e32 v52, 8, v37
; VI-NEXT:    v_lshlrev_b32_e32 v31, 8, v38
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    s_waitcnt vmcnt(7)
; VI-NEXT:    v_lshlrev_b32_e32 v26, 8, v0
; VI-NEXT:    s_waitcnt vmcnt(6)
; VI-NEXT:    v_lshlrev_b32_e32 v32, 8, v1
; VI-NEXT:    s_waitcnt vmcnt(5)
; VI-NEXT:    v_lshlrev_b32_e32 v54, 8, v13
; VI-NEXT:    s_waitcnt vmcnt(4)
; VI-NEXT:    v_lshlrev_b32_e32 v49, 8, v3
; VI-NEXT:    s_waitcnt vmcnt(3)
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v11
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:576 ; 4-byte Folded Spill
; VI-NEXT:    s_waitcnt vmcnt(3)
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v5
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:612 ; 4-byte Folded Spill
; VI-NEXT:    s_waitcnt vmcnt(3)
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v9
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:416 ; 4-byte Folded Spill
; VI-NEXT:    s_waitcnt vmcnt(3)
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v7
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:412 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:248
; VI-NEXT:    buffer_load_ushort v1, off, s[0:3], s32 offset:256
; VI-NEXT:    buffer_load_ushort v13, off, s[0:3], s32 offset:264
; VI-NEXT:    buffer_load_ushort v3, off, s[0:3], s32 offset:272
; VI-NEXT:    buffer_load_ushort v11, off, s[0:3], s32 offset:280
; VI-NEXT:    buffer_load_ushort v5, off, s[0:3], s32 offset:288
; VI-NEXT:    buffer_load_ushort v9, off, s[0:3], s32 offset:296
; VI-NEXT:    buffer_load_ushort v7, off, s[0:3], s32 offset:304
; VI-NEXT:    s_waitcnt vmcnt(7)
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:564 ; 4-byte Folded Spill
; VI-NEXT:    s_waitcnt vmcnt(7)
; VI-NEXT:    v_lshlrev_b32_e32 v48, 8, v1
; VI-NEXT:    s_waitcnt vmcnt(6)
; VI-NEXT:    v_lshlrev_b32_e32 v27, 8, v13
; VI-NEXT:    s_waitcnt vmcnt(4)
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v11
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:568 ; 4-byte Folded Spill
; VI-NEXT:    s_waitcnt vmcnt(4)
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v5
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:404 ; 4-byte Folded Spill
; VI-NEXT:    v_lshlrev_b32_e32 v29, 8, v3
; VI-NEXT:    buffer_load_ushort v0, off, s[0:3], s32 offset:312
; VI-NEXT:    buffer_load_ushort v1, off, s[0:3], s32 offset:320
; VI-NEXT:    buffer_load_ushort v3, off, s[0:3], s32 offset:328
; VI-NEXT:    buffer_load_ushort v11, off, s[0:3], s32 offset:4
; VI-NEXT:    buffer_load_ushort v12, off, s[0:3], s32 offset:12
; VI-NEXT:    buffer_load_ushort v50, off, s[0:3], s32 offset:20
; VI-NEXT:    buffer_load_ushort v56, off, s[0:3], s32 offset:28
; VI-NEXT:    buffer_load_ushort v13, off, s[0:3], s32 offset:36
; VI-NEXT:    s_waitcnt vmcnt(11)
; VI-NEXT:    v_lshlrev_b32_e32 v5, 8, v7
; VI-NEXT:    v_lshlrev_b32_e32 v9, 8, v9
; VI-NEXT:    s_waitcnt vmcnt(7)
; VI-NEXT:    v_lshlrev_b32_e32 v7, 8, v0
; VI-NEXT:    s_waitcnt vmcnt(6)
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v1
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:552 ; 4-byte Folded Spill
; VI-NEXT:    buffer_load_ushort v18, off, s[0:3], s32 offset:44
; VI-NEXT:    buffer_load_ushort v15, off, s[0:3], s32 offset:52
; VI-NEXT:    buffer_load_ushort v17, off, s[0:3], s32 offset:60
; VI-NEXT:    buffer_load_ushort v39, off, s[0:3], s32 offset:68
; VI-NEXT:    buffer_load_ushort v38, off, s[0:3], s32 offset:76
; VI-NEXT:    buffer_load_ushort v37, off, s[0:3], s32 offset:84
; VI-NEXT:    buffer_load_ushort v57, off, s[0:3], s32 offset:92
; VI-NEXT:    buffer_load_ushort v36, off, s[0:3], s32 offset:100
; VI-NEXT:    buffer_load_ushort v35, off, s[0:3], s32 offset:108
; VI-NEXT:    buffer_load_ushort v33, off, s[0:3], s32 offset:116
; VI-NEXT:    buffer_load_ushort v25, off, s[0:3], s32 offset:124
; VI-NEXT:    buffer_load_ushort v19, off, s[0:3], s32 offset:132
; VI-NEXT:    buffer_load_ushort v51, off, s[0:3], s32 offset:140
; VI-NEXT:    buffer_load_ushort v20, off, s[0:3], s32 offset:148
; VI-NEXT:    buffer_load_ushort v28, off, s[0:3], s32 offset:156
; VI-NEXT:    buffer_load_ushort v21, off, s[0:3], s32 offset:164
; VI-NEXT:    buffer_load_ushort v34, off, s[0:3], s32 offset:172
; VI-NEXT:    buffer_load_ushort v22, off, s[0:3], s32 offset:180
; VI-NEXT:    buffer_load_ushort v23, off, s[0:3], s32 offset:188
; VI-NEXT:    buffer_load_ushort v43, off, s[0:3], s32 offset:196
; VI-NEXT:    buffer_load_ushort v30, off, s[0:3], s32 offset:204
; VI-NEXT:    buffer_load_ushort v24, off, s[0:3], s32 offset:212
; VI-NEXT:    buffer_load_ushort v46, off, s[0:3], s32 offset:220
; VI-NEXT:    buffer_load_ushort v61, off, s[0:3], s32 offset:228
; VI-NEXT:    buffer_load_ushort v47, off, s[0:3], s32 offset:236
; VI-NEXT:    buffer_load_ushort v45, off, s[0:3], s32 offset:244
; VI-NEXT:    buffer_load_ushort v58, off, s[0:3], s32 offset:252
; VI-NEXT:    buffer_load_ushort v44, off, s[0:3], s32 offset:260
; VI-NEXT:    buffer_load_ushort v63, off, s[0:3], s32 offset:268
; VI-NEXT:    buffer_load_ushort v42, off, s[0:3], s32 offset:276
; VI-NEXT:    buffer_load_ushort v41, off, s[0:3], s32 offset:284
; VI-NEXT:    buffer_load_ushort v40, off, s[0:3], s32 offset:292
; VI-NEXT:    buffer_load_ushort v62, off, s[0:3], s32 offset:300
; VI-NEXT:    buffer_load_ushort v60, off, s[0:3], s32 offset:308
; VI-NEXT:    buffer_load_ushort v55, off, s[0:3], s32 offset:316
; VI-NEXT:    buffer_load_ushort v53, off, s[0:3], s32 offset:324
; VI-NEXT:    s_waitcnt vmcnt(14)
; VI-NEXT:    v_lshlrev_b32_e32 v0, 8, v3
; VI-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:400 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v9, off, s[0:3], s32 offset:616 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:408 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v27, off, s[0:3], s32 offset:620 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v48, off, s[0:3], s32 offset:624 ; 4-byte Folded Spill
; VI-NEXT:    s_waitcnt vmcnt(12)
; VI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:628 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:632 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:636 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v31, off, s[0:3], s32 offset:640 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:644 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v52, off, s[0:3], s32 offset:648 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:652 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v32, off, s[0:3], s32 offset:656 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:660 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v24, off, s[0:3], s32 offset:664 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v30, off, s[0:3], s32 offset:668 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:672 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v23, off, s[0:3], s32 offset:676 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:680 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v16, off, s[0:3], s32 offset:684 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v22, off, s[0:3], s32 offset:688 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:692 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:696 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:700 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v21, off, s[0:3], s32 offset:704 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v28, off, s[0:3], s32 offset:708 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v20, off, s[0:3], s32 offset:712 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v51, off, s[0:3], s32 offset:716 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:720 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v19, off, s[0:3], s32 offset:724 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:728 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v25, off, s[0:3], s32 offset:732 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:736 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v35, off, s[0:3], s32 offset:740 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v36, off, s[0:3], s32 offset:744 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:748 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v37, off, s[0:3], s32 offset:752 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v38, off, s[0:3], s32 offset:756 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v39, off, s[0:3], s32 offset:760 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:764 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v15, off, s[0:3], s32 offset:768 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:772 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v13, off, s[0:3], s32 offset:776 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:780 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v50, off, s[0:3], s32 offset:784 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:788 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v11, off, s[0:3], s32 offset:792 ; 4-byte Folded Spill
; VI-NEXT:    s_cbranch_scc0 .LBB15_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_or_b32_sdwa v0, v2, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v4, v59 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:488 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:484 ; 4-byte Folded Reload
; VI-NEXT:    v_or_b32_sdwa v4, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:476 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:472 ; 4-byte Folded Reload
; VI-NEXT:    s_and_b32 s4, s28, 0xff
; VI-NEXT:    s_lshl_b32 s5, s29, 8
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_lshl_b32 s8, s27, 8
; VI-NEXT:    s_waitcnt vmcnt(3)
; VI-NEXT:    v_or_b32_sdwa v2, v2, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_or_b32_sdwa v3, v3, v10 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_or_b32_sdwa v0, v0, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v1, v1, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:464 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:548 ; 4-byte Folded Reload
; VI-NEXT:    v_mov_b32_e32 v3, v7
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:460 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:544 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:452 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:540 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:448 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:536 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v8, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:440 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:532 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:432 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:528 ; 4-byte Folded Reload
; VI-NEXT:    buffer_store_dword v29, off, s[0:3], s32 offset:796 ; 4-byte Folded Spill
; VI-NEXT:    v_mov_b32_e32 v29, v9
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v9, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:428 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:524 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:424 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:520 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v10, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:420 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:516 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:512 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v1, v11, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v11, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:508 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:504 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_or_b32_sdwa v0, v12, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v1, v50, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v12, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:580 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:500 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_mov_b32_e32 v50, v0
; VI-NEXT:    v_or_b32_sdwa v0, v56, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v1, v13, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v13, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:584 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:496 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_mov_b32_e32 v59, v0
; VI-NEXT:    v_or_b32_sdwa v0, v18, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v1, v15, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v14, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:608 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:492 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_mov_b32_e32 v56, v0
; VI-NEXT:    v_or_b32_sdwa v0, v17, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v1, v39, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v15, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:600 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:604 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_mov_b32_e32 v39, v0
; VI-NEXT:    v_or_b32_sdwa v0, v38, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v38, v1
; VI-NEXT:    v_or_b32_sdwa v1, v37, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v16, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:596 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:480 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_mov_b32_e32 v37, v0
; VI-NEXT:    v_or_b32_sdwa v0, v57, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v1, v36, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v17, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:572 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:588 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_mov_b32_e32 v36, v0
; VI-NEXT:    v_or_b32_sdwa v0, v35, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v35, v1
; VI-NEXT:    v_or_b32_sdwa v1, v33, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v18, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:592 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:468 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_mov_b32_e32 v33, v0
; VI-NEXT:    v_or_b32_sdwa v0, v25, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v1, v19, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v19, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:456 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:444 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_or_b32_sdwa v0, v51, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v1, v20, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v20, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:436 ; 4-byte Folded Reload
; VI-NEXT:    v_or_b32_sdwa v1, v21, v52 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v51, v3
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v0, v28, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v21, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v34, v31 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v22, v26 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v22, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v23, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v43, v54 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v23, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:576 ; 4-byte Folded Reload
; VI-NEXT:    v_mov_b32_e32 v43, v49
; VI-NEXT:    v_or_b32_sdwa v0, v30, v49 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v32, v54
; VI-NEXT:    v_mov_b32_e32 v34, v26
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v49, v1
; VI-NEXT:    v_or_b32_sdwa v1, v24, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v24, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:612 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:416 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_mov_b32_e32 v54, v0
; VI-NEXT:    v_or_b32_sdwa v0, v46, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v1, v61, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v46, v61
; VI-NEXT:    v_or_b32_sdwa v25, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:412 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:564 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_or_b32_sdwa v0, v47, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v1, v45, v61 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v26, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v58, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v44, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v47, v45
; VI-NEXT:    v_or_b32_sdwa v27, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:796 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:568 ; 4-byte Folded Reload
; VI-NEXT:    v_mov_b32_e32 v58, v44
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_mov_b32_e32 v48, v0
; VI-NEXT:    v_or_b32_sdwa v0, v63, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v1, v42, v45 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v28, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:404 ; 4-byte Folded Reload
; VI-NEXT:    v_or_b32_sdwa v1, v40, v29 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v63, v42
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v0, v41, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v29, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:400 ; 4-byte Folded Reload
; VI-NEXT:    v_or_b32_sdwa v1, v60, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v0, v62, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v30, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:552 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:408 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_or_b32_sdwa v0, v55, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v1, v53, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v31, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v52, off, s[0:3], s32 offset:556 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:560 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v57, v0
; VI-NEXT:    v_or_b32_sdwa v0, v52, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v3, s4, v0
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s6, s24, 0xff
; VI-NEXT:    s_lshl_b32 s7, s25, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s7, s26, 0xff
; VI-NEXT:    s_or_b32 s7, s7, s8
; VI-NEXT:    s_and_b32 s6, s6, 0xffff
; VI-NEXT:    s_lshl_b32 s7, s7, 16
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:    s_branch .LBB15_3
; VI-NEXT:  .LBB15_2:
; VI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:560 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v50, off, s[0:3], s32 offset:580 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:584 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:608 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v39, off, s[0:3], s32 offset:600 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v38, off, s[0:3], s32 offset:604 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v37, off, s[0:3], s32 offset:596 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v36, off, s[0:3], s32 offset:572 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v35, off, s[0:3], s32 offset:588 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v33, off, s[0:3], s32 offset:592 ; 4-byte Folded Reload
; VI-NEXT:    v_mov_b32_e32 v32, v54
; VI-NEXT:    v_mov_b32_e32 v43, v49
; VI-NEXT:    v_mov_b32_e32 v46, v61
; VI-NEXT:    v_mov_b32_e32 v47, v45
; VI-NEXT:    buffer_load_dword v54, off, s[0:3], s32 offset:612 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v49, off, s[0:3], s32 offset:576 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:568 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v52, off, s[0:3], s32 offset:556 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:564 ; 4-byte Folded Reload
; VI-NEXT:    v_mov_b32_e32 v34, v26
; VI-NEXT:    v_mov_b32_e32 v58, v44
; VI-NEXT:    s_waitcnt vmcnt(14)
; VI-NEXT:    v_mov_b32_e32 v63, v42
; VI-NEXT:    v_mov_b32_e32 v51, v7
; VI-NEXT:    v_mov_b32_e32 v48, v29
; VI-NEXT:    s_mov_b64 s[4:5], -1
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; VI-NEXT:  .LBB15_3: ; %Flow
; VI-NEXT:    s_andn2_b64 vcc, exec, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v44, v47
; VI-NEXT:    v_mov_b32_e32 v47, v46
; VI-NEXT:    s_waitcnt vmcnt(3)
; VI-NEXT:    v_mov_b32_e32 v46, v49
; VI-NEXT:    s_cbranch_vccnz .LBB15_5
; VI-NEXT:  ; %bb.4: ; %cmp.true
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:652 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:728 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:720 ; 4-byte Folded Reload
; VI-NEXT:    s_add_i32 s28, s28, 3
; VI-NEXT:    s_and_b32 s4, s28, 0xff
; VI-NEXT:    s_lshl_b32 s5, s29, 8
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_waitcnt vmcnt(4)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v52
; VI-NEXT:    s_addk_i32 s4, 0x300
; VI-NEXT:    v_or_b32_sdwa v0, v57, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    v_or_b32_e32 v0, s4, v0
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_addk_i32 s4, 0x300
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_addk_i32 s5, 0x300
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_add_i32 s24, s24, 3
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s6, s24, 0xff
; VI-NEXT:    s_lshl_b32 s7, s25, 8
; VI-NEXT:    s_add_i32 s26, s26, 3
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s7, s26, 0xff
; VI-NEXT:    s_lshl_b32 s8, s27, 8
; VI-NEXT:    s_addk_i32 s6, 0x300
; VI-NEXT:    s_or_b32 s7, s8, s7
; VI-NEXT:    s_and_b32 s6, s6, 0xffff
; VI-NEXT:    s_lshl_b32 s7, s7, 16
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_add_i32 s4, s4, 0x3000000
; VI-NEXT:    s_add_i32 s5, s5, 0x3000000
; VI-NEXT:    s_add_i32 s6, s6, 0x3000000
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:660 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x300, v1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x3000000, v0
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:488 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u32_e32 v4, vcc, 0x3000000, v1
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:700 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:696 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:484 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v5, vcc, 0x3000000, v0
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:476 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:684 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:680 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:472 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v6, vcc, 0x3000000, v0
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:464 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:548 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:544 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:460 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v7, vcc, 0x3000000, v0
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:452 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:540 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:536 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:448 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v8, vcc, 0x3000000, v0
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:440 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:532 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:528 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:432 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v9, vcc, 0x3000000, v0
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:428 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:524 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:520 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:424 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v10, vcc, 0x3000000, v0
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:420 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:516 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:512 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:792 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v11, vcc, 0x3000000, v0
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:788 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:508 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:504 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:784 ; 4-byte Folded Reload
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v12, vcc, 0x3000000, v0
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:780 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:776 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:500 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_or_b3