; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve2 < %s | FileCheck %s
; RUN: llc -mattr=+sve,+sme < %s | FileCheck %s
; RUN: llc -mattr=+sme -force-streaming < %s | FileCheck %s

target triple = "aarch64-unknown-linux-gnu"

;
; WHILEGE
;

; Cannot invert the while predicate when %a is MAX_INT.
define <vscale x 16 x i1> @whilege_b_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilege_b_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilele p0.b, w1, w0
; CHECK-NEXT:    rev p0.b, p0.b
; CHECK-NEXT:    ret
  %while = call <vscale x 16 x i1> @llvm.aarch64.sve.whilele.nxv16i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 16 x i1> @llvm.vector.reverse.nxv16i1(<vscale x 16 x i1> %while)
  ret <vscale x 16 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MAX_INT.
define <vscale x 16 x i1> @whilege_b_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilege_b_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilele p0.b, x1, x0
; CHECK-NEXT:    rev p0.b, p0.b
; CHECK-NEXT:    ret
  %while = call <vscale x 16 x i1> @llvm.aarch64.sve.whilele.nxv16i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 16 x i1> @llvm.vector.reverse.nxv16i1(<vscale x 16 x i1> %while)
  ret <vscale x 16 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MAX_INT.
define <vscale x 8 x i1> @whilege_h_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilege_h_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilele p0.h, w1, w0
; CHECK-NEXT:    rev p0.h, p0.h
; CHECK-NEXT:    ret
  %while = call <vscale x 8 x i1> @llvm.aarch64.sve.whilele.nxv8i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 8 x i1> @llvm.vector.reverse.nxv8i1(<vscale x 8 x i1> %while)
  ret <vscale x 8 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MAX_INT.
define <vscale x 8 x i1> @whilege_h_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilege_h_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilele p0.h, x1, x0
; CHECK-NEXT:    rev p0.h, p0.h
; CHECK-NEXT:    ret
  %while = call <vscale x 8 x i1> @llvm.aarch64.sve.whilele.nxv8i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 8 x i1> @llvm.vector.reverse.nxv8i1(<vscale x 8 x i1> %while)
  ret <vscale x 8 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MAX_INT.
define <vscale x 4 x i1> @whilege_s_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilege_s_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilele p0.s, w1, w0
; CHECK-NEXT:    rev p0.s, p0.s
; CHECK-NEXT:    ret
  %while = call <vscale x 4 x i1> @llvm.aarch64.sve.whilele.nxv4i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 4 x i1> @llvm.vector.reverse.nxv4i1(<vscale x 4 x i1> %while)
  ret <vscale x 4 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MAX_INT.
define <vscale x 4 x i1> @whilege_s_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilege_s_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilele p0.s, x1, x0
; CHECK-NEXT:    rev p0.s, p0.s
; CHECK-NEXT:    ret
  %while = call <vscale x 4 x i1> @llvm.aarch64.sve.whilele.nxv4i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 4 x i1> @llvm.vector.reverse.nxv4i1(<vscale x 4 x i1> %while)
  ret <vscale x 4 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MAX_INT.
define <vscale x 2 x i1> @whilege_d_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilege_d_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilele p0.d, w1, w0
; CHECK-NEXT:    rev p0.d, p0.d
; CHECK-NEXT:    ret
  %while = call <vscale x 2 x i1> @llvm.aarch64.sve.whilele.nxv2i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 2 x i1> @llvm.vector.reverse.nxv2i1(<vscale x 2 x i1> %while)
  ret <vscale x 2 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MAX_INT.
define <vscale x 2 x i1> @whilege_d_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilege_d_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilele p0.d, x1, x0
; CHECK-NEXT:    rev p0.d, p0.d
; CHECK-NEXT:    ret
  %while = call <vscale x 2 x i1> @llvm.aarch64.sve.whilele.nxv2i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 2 x i1> @llvm.vector.reverse.nxv2i1(<vscale x 2 x i1> %while)
  ret <vscale x 2 x i1> %while.rev
}

;
; WHILEHS
;

; Cannot invert the while predicate when %a is MAX_UINT.
define <vscale x 16 x i1> @whilehs_b_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilehs_b_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilels p0.b, w1, w0
; CHECK-NEXT:    rev p0.b, p0.b
; CHECK-NEXT:    ret
  %while = call <vscale x 16 x i1> @llvm.aarch64.sve.whilels.nxv16i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 16 x i1> @llvm.vector.reverse.nxv16i1(<vscale x 16 x i1> %while)
  ret <vscale x 16 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MAX_UINT.
define <vscale x 16 x i1> @whilehs_b_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilehs_b_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilels p0.b, x1, x0
; CHECK-NEXT:    rev p0.b, p0.b
; CHECK-NEXT:    ret
  %while = call <vscale x 16 x i1> @llvm.aarch64.sve.whilels.nxv16i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 16 x i1> @llvm.vector.reverse.nxv16i1(<vscale x 16 x i1> %while)
  ret <vscale x 16 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MAX_UINT.
define <vscale x 8 x i1> @whilehs_h_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilehs_h_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilels p0.h, w1, w0
; CHECK-NEXT:    rev p0.h, p0.h
; CHECK-NEXT:    ret
  %while = call <vscale x 8 x i1> @llvm.aarch64.sve.whilels.nxv8i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 8 x i1> @llvm.vector.reverse.nxv8i1(<vscale x 8 x i1> %while)
  ret <vscale x 8 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MAX_UINT.
define <vscale x 8 x i1> @whilehs_h_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilehs_h_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilels p0.h, x1, x0
; CHECK-NEXT:    rev p0.h, p0.h
; CHECK-NEXT:    ret
  %while = call <vscale x 8 x i1> @llvm.aarch64.sve.whilels.nxv8i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 8 x i1> @llvm.vector.reverse.nxv8i1(<vscale x 8 x i1> %while)
  ret <vscale x 8 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MAX_UINT.
define <vscale x 4 x i1> @whilehs_s_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilehs_s_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilels p0.s, w1, w0
; CHECK-NEXT:    rev p0.s, p0.s
; CHECK-NEXT:    ret
  %while = call <vscale x 4 x i1> @llvm.aarch64.sve.whilels.nxv4i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 4 x i1> @llvm.vector.reverse.nxv4i1(<vscale x 4 x i1> %while)
  ret <vscale x 4 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MAX_UINT.
define <vscale x 4 x i1> @whilehs_s_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilehs_s_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilels p0.s, x1, x0
; CHECK-NEXT:    rev p0.s, p0.s
; CHECK-NEXT:    ret
  %while = call <vscale x 4 x i1> @llvm.aarch64.sve.whilels.nxv4i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 4 x i1> @llvm.vector.reverse.nxv4i1(<vscale x 4 x i1> %while)
  ret <vscale x 4 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MAX_UINT.
define <vscale x 2 x i1> @whilehs_d_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilehs_d_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilels p0.d, w1, w0
; CHECK-NEXT:    rev p0.d, p0.d
; CHECK-NEXT:    ret
  %while = call <vscale x 2 x i1> @llvm.aarch64.sve.whilels.nxv2i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 2 x i1> @llvm.vector.reverse.nxv2i1(<vscale x 2 x i1> %while)
  ret <vscale x 2 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MAX_UINT.
define <vscale x 2 x i1> @whilehs_d_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilehs_d_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilels p0.d, x1, x0
; CHECK-NEXT:    rev p0.d, p0.d
; CHECK-NEXT:    ret
  %while = call <vscale x 2 x i1> @llvm.aarch64.sve.whilels.nxv2i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 2 x i1> @llvm.vector.reverse.nxv2i1(<vscale x 2 x i1> %while)
  ret <vscale x 2 x i1> %while.rev
}

;
; WHILEGT
;

define <vscale x 16 x i1> @whilegt_b_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilegt_b_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilegt p0.b, w0, w1
; CHECK-NEXT:    ret
  %while = call <vscale x 16 x i1> @llvm.aarch64.sve.whilelt.nxv16i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 16 x i1> @llvm.vector.reverse.nxv16i1(<vscale x 16 x i1> %while)
  ret <vscale x 16 x i1> %while.rev
}

define <vscale x 16 x i1> @whilegt_b_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilegt_b_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilegt p0.b, x0, x1
; CHECK-NEXT:    ret
  %while = call <vscale x 16 x i1> @llvm.aarch64.sve.whilelt.nxv16i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 16 x i1> @llvm.vector.reverse.nxv16i1(<vscale x 16 x i1> %while)
  ret <vscale x 16 x i1> %while.rev
}

define <vscale x 8 x i1> @whilegt_h_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilegt_h_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilegt p0.h, w0, w1
; CHECK-NEXT:    ret
  %while = call <vscale x 8 x i1> @llvm.aarch64.sve.whilelt.nxv8i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 8 x i1> @llvm.vector.reverse.nxv8i1(<vscale x 8 x i1> %while)
  ret <vscale x 8 x i1> %while.rev
}

define <vscale x 8 x i1> @whilegt_h_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilegt_h_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilegt p0.h, x0, x1
; CHECK-NEXT:    ret
  %while = call <vscale x 8 x i1> @llvm.aarch64.sve.whilelt.nxv8i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 8 x i1> @llvm.vector.reverse.nxv8i1(<vscale x 8 x i1> %while)
  ret <vscale x 8 x i1> %while.rev
}

define <vscale x 4 x i1> @whilegt_s_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilegt_s_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilegt p0.s, w0, w1
; CHECK-NEXT:    ret
  %while = call <vscale x 4 x i1> @llvm.aarch64.sve.whilelt.nxv4i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 4 x i1> @llvm.vector.reverse.nxv4i1(<vscale x 4 x i1> %while)
  ret <vscale x 4 x i1> %while.rev
}

define <vscale x 4 x i1> @whilegt_s_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilegt_s_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilegt p0.s, x0, x1
; CHECK-NEXT:    ret
  %while = call <vscale x 4 x i1> @llvm.aarch64.sve.whilelt.nxv4i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 4 x i1> @llvm.vector.reverse.nxv4i1(<vscale x 4 x i1> %while)
  ret <vscale x 4 x i1> %while.rev
}

define <vscale x 2 x i1> @whilegt_d_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilegt_d_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilegt p0.d, w0, w1
; CHECK-NEXT:    ret
  %while = call <vscale x 2 x i1> @llvm.aarch64.sve.whilelt.nxv2i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 2 x i1> @llvm.vector.reverse.nxv2i1(<vscale x 2 x i1> %while)
  ret <vscale x 2 x i1> %while.rev
}

define <vscale x 2 x i1> @whilegt_d_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilegt_d_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilegt p0.d, x0, x1
; CHECK-NEXT:    ret
  %while = call <vscale x 2 x i1> @llvm.aarch64.sve.whilelt.nxv2i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 2 x i1> @llvm.vector.reverse.nxv2i1(<vscale x 2 x i1> %while)
  ret <vscale x 2 x i1> %while.rev
}

;
; WHILEHI
;

define <vscale x 16 x i1> @whilehi_b_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilehi_b_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilehi p0.b, w0, w1
; CHECK-NEXT:    ret
  %while = call <vscale x 16 x i1> @llvm.aarch64.sve.whilelo.nxv16i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 16 x i1> @llvm.vector.reverse.nxv16i1(<vscale x 16 x i1> %while)
  ret <vscale x 16 x i1> %while.rev
}

define <vscale x 16 x i1> @whilehi_b_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilehi_b_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilehi p0.b, x0, x1
; CHECK-NEXT:    ret
  %while = call <vscale x 16 x i1> @llvm.aarch64.sve.whilelo.nxv16i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 16 x i1> @llvm.vector.reverse.nxv16i1(<vscale x 16 x i1> %while)
  ret <vscale x 16 x i1> %while.rev
}

define <vscale x 8 x i1> @whilehi_h_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilehi_h_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilehi p0.h, w0, w1
; CHECK-NEXT:    ret
  %while = call <vscale x 8 x i1> @llvm.aarch64.sve.whilelo.nxv8i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 8 x i1> @llvm.vector.reverse.nxv8i1(<vscale x 8 x i1> %while)
  ret <vscale x 8 x i1> %while.rev
}

define <vscale x 8 x i1> @whilehi_h_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilehi_h_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilehi p0.h, x0, x1
; CHECK-NEXT:    ret
  %while = call <vscale x 8 x i1> @llvm.aarch64.sve.whilelo.nxv8i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 8 x i1> @llvm.vector.reverse.nxv8i1(<vscale x 8 x i1> %while)
  ret <vscale x 8 x i1> %while.rev
}

define <vscale x 4 x i1> @whilehi_s_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilehi_s_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilehi p0.s, w0, w1
; CHECK-NEXT:    ret
  %while = call <vscale x 4 x i1> @llvm.aarch64.sve.whilelo.nxv4i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 4 x i1> @llvm.vector.reverse.nxv4i1(<vscale x 4 x i1> %while)
  ret <vscale x 4 x i1> %while.rev
}

define <vscale x 4 x i1> @whilehi_s_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilehi_s_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilehi p0.s, x0, x1
; CHECK-NEXT:    ret
  %while = call <vscale x 4 x i1> @llvm.aarch64.sve.whilelo.nxv4i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 4 x i1> @llvm.vector.reverse.nxv4i1(<vscale x 4 x i1> %while)
  ret <vscale x 4 x i1> %while.rev
}

define <vscale x 2 x i1> @whilehi_d_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilehi_d_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilehi p0.d, w0, w1
; CHECK-NEXT:    ret
  %while = call <vscale x 2 x i1> @llvm.aarch64.sve.whilelo.nxv2i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 2 x i1> @llvm.vector.reverse.nxv2i1(<vscale x 2 x i1> %while)
  ret <vscale x 2 x i1> %while.rev
}

define <vscale x 2 x i1> @whilehi_d_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilehi_d_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilehi p0.d, x0, x1
; CHECK-NEXT:    ret
  %while = call <vscale x 2 x i1> @llvm.aarch64.sve.whilelo.nxv2i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 2 x i1> @llvm.vector.reverse.nxv2i1(<vscale x 2 x i1> %while)
  ret <vscale x 2 x i1> %while.rev
}

;
; WHILELE
;

; Cannot invert the while predicate when %a is MIN_INT.
define <vscale x 16 x i1> @whilele_b_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilele_b_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilege p0.b, w1, w0
; CHECK-NEXT:    rev p0.b, p0.b
; CHECK-NEXT:    ret
  %while = call <vscale x 16 x i1> @llvm.aarch64.sve.whilege.nxv16i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 16 x i1> @llvm.vector.reverse.nxv16i1(<vscale x 16 x i1> %while)
  ret <vscale x 16 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MIN_INT.
define <vscale x 16 x i1> @whilele_b_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilele_b_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilege p0.b, x1, x0
; CHECK-NEXT:    rev p0.b, p0.b
; CHECK-NEXT:    ret
  %while = call <vscale x 16 x i1> @llvm.aarch64.sve.whilege.nxv16i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 16 x i1> @llvm.vector.reverse.nxv16i1(<vscale x 16 x i1> %while)
  ret <vscale x 16 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MIN_INT.
define <vscale x 8 x i1> @whilele_h_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilele_h_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilege p0.h, w1, w0
; CHECK-NEXT:    rev p0.h, p0.h
; CHECK-NEXT:    ret
  %while = call <vscale x 8 x i1> @llvm.aarch64.sve.whilege.nxv8i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 8 x i1> @llvm.vector.reverse.nxv8i1(<vscale x 8 x i1> %while)
  ret <vscale x 8 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MIN_INT.
define <vscale x 8 x i1> @whilele_h_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilele_h_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilege p0.h, x1, x0
; CHECK-NEXT:    rev p0.h, p0.h
; CHECK-NEXT:    ret
  %while = call <vscale x 8 x i1> @llvm.aarch64.sve.whilege.nxv8i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 8 x i1> @llvm.vector.reverse.nxv8i1(<vscale x 8 x i1> %while)
  ret <vscale x 8 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MIN_INT.
define <vscale x 4 x i1> @whilele_s_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilele_s_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilege p0.s, w1, w0
; CHECK-NEXT:    rev p0.s, p0.s
; CHECK-NEXT:    ret
  %while = call <vscale x 4 x i1> @llvm.aarch64.sve.whilege.nxv4i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 4 x i1> @llvm.vector.reverse.nxv4i1(<vscale x 4 x i1> %while)
  ret <vscale x 4 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MIN_INT.
define <vscale x 4 x i1> @whilele_s_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilele_s_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilege p0.s, x1, x0
; CHECK-NEXT:    rev p0.s, p0.s
; CHECK-NEXT:    ret
  %while = call <vscale x 4 x i1> @llvm.aarch64.sve.whilege.nxv4i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 4 x i1> @llvm.vector.reverse.nxv4i1(<vscale x 4 x i1> %while)
  ret <vscale x 4 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MIN_INT.
define <vscale x 2 x i1> @whilele_d_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilele_d_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilege p0.d, w1, w0
; CHECK-NEXT:    rev p0.d, p0.d
; CHECK-NEXT:    ret
  %while = call <vscale x 2 x i1> @llvm.aarch64.sve.whilege.nxv2i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 2 x i1> @llvm.vector.reverse.nxv2i1(<vscale x 2 x i1> %while)
  ret <vscale x 2 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MIN_INT.
define <vscale x 2 x i1> @whilele_d_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilele_d_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilege p0.d, x1, x0
; CHECK-NEXT:    rev p0.d, p0.d
; CHECK-NEXT:    ret
  %while = call <vscale x 2 x i1> @llvm.aarch64.sve.whilege.nxv2i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 2 x i1> @llvm.vector.reverse.nxv2i1(<vscale x 2 x i1> %while)
  ret <vscale x 2 x i1> %while.rev
}

;
; WHILELO
;

define <vscale x 16 x i1> @whilelo_b_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilelo_b_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilelo p0.b, w0, w1
; CHECK-NEXT:    ret
  %while = call <vscale x 16 x i1> @llvm.aarch64.sve.whilehi.nxv16i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 16 x i1> @llvm.vector.reverse.nxv16i1(<vscale x 16 x i1> %while)
  ret <vscale x 16 x i1> %while.rev
}

define <vscale x 16 x i1> @whilelo_b_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilelo_b_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilelo p0.b, x0, x1
; CHECK-NEXT:    ret
  %while = call <vscale x 16 x i1> @llvm.aarch64.sve.whilehi.nxv16i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 16 x i1> @llvm.vector.reverse.nxv16i1(<vscale x 16 x i1> %while)
  ret <vscale x 16 x i1> %while.rev
}

define <vscale x 8 x i1> @whilelo_h_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilelo_h_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilelo p0.h, w0, w1
; CHECK-NEXT:    ret
  %while = call <vscale x 8 x i1> @llvm.aarch64.sve.whilehi.nxv8i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 8 x i1> @llvm.vector.reverse.nxv8i1(<vscale x 8 x i1> %while)
  ret <vscale x 8 x i1> %while.rev
}

define <vscale x 8 x i1> @whilelo_h_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilelo_h_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilelo p0.h, x0, x1
; CHECK-NEXT:    ret
  %while = call <vscale x 8 x i1> @llvm.aarch64.sve.whilehi.nxv8i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 8 x i1> @llvm.vector.reverse.nxv8i1(<vscale x 8 x i1> %while)
  ret <vscale x 8 x i1> %while.rev
}

define <vscale x 4 x i1> @whilelo_s_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilelo_s_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilelo p0.s, w0, w1
; CHECK-NEXT:    ret
  %while = call <vscale x 4 x i1> @llvm.aarch64.sve.whilehi.nxv4i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 4 x i1> @llvm.vector.reverse.nxv4i1(<vscale x 4 x i1> %while)
  ret <vscale x 4 x i1> %while.rev
}

define <vscale x 4 x i1> @whilelo_s_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilelo_s_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilelo p0.s, x0, x1
; CHECK-NEXT:    ret
  %while = call <vscale x 4 x i1> @llvm.aarch64.sve.whilehi.nxv4i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 4 x i1> @llvm.vector.reverse.nxv4i1(<vscale x 4 x i1> %while)
  ret <vscale x 4 x i1> %while.rev
}

define <vscale x 2 x i1> @whilelo_d_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilelo_d_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilelo p0.d, w0, w1
; CHECK-NEXT:    ret
  %while = call <vscale x 2 x i1> @llvm.aarch64.sve.whilehi.nxv2i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 2 x i1> @llvm.vector.reverse.nxv2i1(<vscale x 2 x i1> %while)
  ret <vscale x 2 x i1> %while.rev
}

define <vscale x 2 x i1> @whilelo_d_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilelo_d_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilelo p0.d, x0, x1
; CHECK-NEXT:    ret
  %while = call <vscale x 2 x i1> @llvm.aarch64.sve.whilehi.nxv2i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 2 x i1> @llvm.vector.reverse.nxv2i1(<vscale x 2 x i1> %while)
  ret <vscale x 2 x i1> %while.rev
}

;
; WHILELS
;

; Cannot invert the while predicate when %a is MIN_UINT.
define <vscale x 16 x i1> @whilels_b_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilels_b_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilehs p0.b, w1, w0
; CHECK-NEXT:    rev p0.b, p0.b
; CHECK-NEXT:    ret
  %while = call <vscale x 16 x i1> @llvm.aarch64.sve.whilehs.nxv16i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 16 x i1> @llvm.vector.reverse.nxv16i1(<vscale x 16 x i1> %while)
  ret <vscale x 16 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MIN_UINT.
define <vscale x 16 x i1> @whilels_b_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilels_b_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilehs p0.b, x1, x0
; CHECK-NEXT:    rev p0.b, p0.b
; CHECK-NEXT:    ret
  %while = call <vscale x 16 x i1> @llvm.aarch64.sve.whilehs.nxv16i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 16 x i1> @llvm.vector.reverse.nxv16i1(<vscale x 16 x i1> %while)
  ret <vscale x 16 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MIN_UINT.
define <vscale x 8 x i1> @whilels_h_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilels_h_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilehs p0.h, w1, w0
; CHECK-NEXT:    rev p0.h, p0.h
; CHECK-NEXT:    ret
  %while = call <vscale x 8 x i1> @llvm.aarch64.sve.whilehs.nxv8i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 8 x i1> @llvm.vector.reverse.nxv8i1(<vscale x 8 x i1> %while)
  ret <vscale x 8 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MIN_UINT.
define <vscale x 8 x i1> @whilels_h_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilels_h_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilehs p0.h, x1, x0
; CHECK-NEXT:    rev p0.h, p0.h
; CHECK-NEXT:    ret
  %while = call <vscale x 8 x i1> @llvm.aarch64.sve.whilehs.nxv8i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 8 x i1> @llvm.vector.reverse.nxv8i1(<vscale x 8 x i1> %while)
  ret <vscale x 8 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MIN_UINT.
define <vscale x 4 x i1> @whilels_s_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilels_s_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilehs p0.s, w1, w0
; CHECK-NEXT:    rev p0.s, p0.s
; CHECK-NEXT:    ret
  %while = call <vscale x 4 x i1> @llvm.aarch64.sve.whilehs.nxv4i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 4 x i1> @llvm.vector.reverse.nxv4i1(<vscale x 4 x i1> %while)
  ret <vscale x 4 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MIN_UINT.
define <vscale x 4 x i1> @whilels_s_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilels_s_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilehs p0.s, x1, x0
; CHECK-NEXT:    rev p0.s, p0.s
; CHECK-NEXT:    ret
  %while = call <vscale x 4 x i1> @llvm.aarch64.sve.whilehs.nxv4i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 4 x i1> @llvm.vector.reverse.nxv4i1(<vscale x 4 x i1> %while)
  ret <vscale x 4 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MIN_UINT.
define <vscale x 2 x i1> @whilels_d_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilels_d_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilehs p0.d, w1, w0
; CHECK-NEXT:    rev p0.d, p0.d
; CHECK-NEXT:    ret
  %while = call <vscale x 2 x i1> @llvm.aarch64.sve.whilehs.nxv2i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 2 x i1> @llvm.vector.reverse.nxv2i1(<vscale x 2 x i1> %while)
  ret <vscale x 2 x i1> %while.rev
}

; Cannot invert the while predicate when %a is MIN_UINT.
define <vscale x 2 x i1> @whilels_d_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilels_d_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilehs p0.d, x1, x0
; CHECK-NEXT:    rev p0.d, p0.d
; CHECK-NEXT:    ret
  %while = call <vscale x 2 x i1> @llvm.aarch64.sve.whilehs.nxv2i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 2 x i1> @llvm.vector.reverse.nxv2i1(<vscale x 2 x i1> %while)
  ret <vscale x 2 x i1> %while.rev
}

;
; WHILELT
;

define <vscale x 16 x i1> @whilelt_b_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilelt_b_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilelt p0.b, w0, w1
; CHECK-NEXT:    ret
  %while = call <vscale x 16 x i1> @llvm.aarch64.sve.whilegt.nxv16i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 16 x i1> @llvm.vector.reverse.nxv16i1(<vscale x 16 x i1> %while)
  ret <vscale x 16 x i1> %while.rev
}

define <vscale x 16 x i1> @whilelt_b_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilelt_b_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilelt p0.b, x0, x1
; CHECK-NEXT:    ret
  %while = call <vscale x 16 x i1> @llvm.aarch64.sve.whilegt.nxv16i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 16 x i1> @llvm.vector.reverse.nxv16i1(<vscale x 16 x i1> %while)
  ret <vscale x 16 x i1> %while.rev
}

define <vscale x 8 x i1> @whilelt_h_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilelt_h_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilelt p0.h, w0, w1
; CHECK-NEXT:    ret
  %while = call <vscale x 8 x i1> @llvm.aarch64.sve.whilegt.nxv8i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 8 x i1> @llvm.vector.reverse.nxv8i1(<vscale x 8 x i1> %while)
  ret <vscale x 8 x i1> %while.rev
}

define <vscale x 8 x i1> @whilelt_h_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilelt_h_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilelt p0.h, x0, x1
; CHECK-NEXT:    ret
  %while = call <vscale x 8 x i1> @llvm.aarch64.sve.whilegt.nxv8i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 8 x i1> @llvm.vector.reverse.nxv8i1(<vscale x 8 x i1> %while)
  ret <vscale x 8 x i1> %while.rev
}

define <vscale x 4 x i1> @whilelt_s_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilelt_s_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilelt p0.s, w0, w1
; CHECK-NEXT:    ret
  %while = call <vscale x 4 x i1> @llvm.aarch64.sve.whilegt.nxv4i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 4 x i1> @llvm.vector.reverse.nxv4i1(<vscale x 4 x i1> %while)
  ret <vscale x 4 x i1> %while.rev
}

define <vscale x 4 x i1> @whilelt_s_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilelt_s_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilelt p0.s, x0, x1
; CHECK-NEXT:    ret
  %while = call <vscale x 4 x i1> @llvm.aarch64.sve.whilegt.nxv4i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 4 x i1> @llvm.vector.reverse.nxv4i1(<vscale x 4 x i1> %while)
  ret <vscale x 4 x i1> %while.rev
}

define <vscale x 2 x i1> @whilelt_d_ww(i32 %a, i32 %b) {
; CHECK-LABEL: whilelt_d_ww:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilelt p0.d, w0, w1
; CHECK-NEXT:    ret
  %while = call <vscale x 2 x i1> @llvm.aarch64.sve.whilegt.nxv2i1.i32(i32 %b, i32 %a)
  %while.rev = call <vscale x 2 x i1> @llvm.vector.reverse.nxv2i1(<vscale x 2 x i1> %while)
  ret <vscale x 2 x i1> %while.rev
}

define <vscale x 2 x i1> @whilelt_d_xx(i64 %a, i64 %b) {
; CHECK-LABEL: whilelt_d_xx:
; CHECK:       // %bb.0:
; CHECK-NEXT:    whilelt p0.d, x0, x1
; CHECK-NEXT:    ret
  %while = call <vscale x 2 x i1> @llvm.aarch64.sve.whilegt.nxv2i1.i64(i64 %b, i64 %a)
  %while.rev = call <vscale x 2 x i1> @llvm.vector.reverse.nxv2i1(<vscale x 2 x i1> %while)
  ret <vscale x 2 x i1> %while.rev
}
