; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py UTC_ARGS: --version 5
; RUN: llc -O2 -mtriple powerpc64-ibm-aix-xcoff -mcpu=ppc -stop-after=machine-cp -verify-machineinstrs < %s | FileCheck %s

define i32 @int_va_arg(i32 %a, ...) local_unnamed_addr  {
  ; CHECK-LABEL: name: int_va_arg
  ; CHECK: bb.0.entry:
  ; CHECK-NEXT:   liveins: $x3, $x4, $x5, $x6, $x7, $x8, $x9, $x10
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   renamable $x11 = ADDI8 %fixed-stack.0, 0
  ; CHECK-NEXT:   STD killed renamable $x6, 16, %fixed-stack.0 :: (store (s64))
  ; CHECK-NEXT:   STD killed renamable $x7, 24, %fixed-stack.0 :: (store (s64))
  ; CHECK-NEXT:   STD killed renamable $x8, 32, %fixed-stack.0 :: (store (s64))
  ; CHECK-NEXT:   STD killed renamable $x9, 40, %fixed-stack.0 :: (store (s64))
  ; CHECK-NEXT:   STD killed renamable $x10, 48, %fixed-stack.0 :: (store (s64))
  ; CHECK-NEXT:   STD renamable $x11, 0, %stack.1.arg2 :: (store (s64) into %ir.arg2)
  ; CHECK-NEXT:   renamable $x6 = LD 0, %stack.1.arg2 :: (load (s64) from %ir.arg2)
  ; CHECK-NEXT:   renamable $x7 = disjoint ADDI8 %fixed-stack.0, 4
  ; CHECK-NEXT:   renamable $r8 = LWZ 0, %fixed-stack.0 :: (load (s32) from %fixed-stack.0, align 8)
  ; CHECK-NEXT:   renamable $x9 = ADDI8 renamable $x6, 4
  ; CHECK-NEXT:   STD killed renamable $x4, 0, %fixed-stack.0 :: (store (s64) into %fixed-stack.0)
  ; CHECK-NEXT:   STD killed renamable $x5, 8, %fixed-stack.0 :: (store (s64) into %fixed-stack.0 + 8)
  ; CHECK-NEXT:   STD killed renamable $x11, 0, %stack.0.arg1 :: (store (s64) into %ir.arg1)
  ; CHECK-NEXT:   STD killed renamable $x7, 0, %stack.0.arg1 :: (store (s64) into %ir.arg1)
  ; CHECK-NEXT:   STD killed renamable $x9, 0, %stack.1.arg2 :: (store (s64) into %ir.arg2)
  ; CHECK-NEXT:   renamable $r4 = LWZ 0, killed renamable $x6 :: (load (s32))
  ; CHECK-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r8, renamable $r3, implicit killed $x3
  ; CHECK-NEXT:   renamable $r4 = RLWINM killed renamable $r4, 1, 0, 30
  ; CHECK-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, killed renamable $r4, implicit-def $x3
  ; CHECK-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $x3
entry:
  %arg1 = alloca ptr, align 8
  %arg2 = alloca ptr, align 8
  call void @llvm.lifetime.start.p0(i64 8, ptr nonnull %arg1)
  call void @llvm.lifetime.start.p0(i64 8, ptr nonnull %arg2)
  call void @llvm.va_start(ptr nonnull %arg1)
  call void @llvm.va_copy(ptr nonnull %arg2, ptr nonnull %arg1)
  %0 = va_arg ptr %arg1, i32
  %add = add nsw i32 %0, %a
  %1 = va_arg ptr %arg2, i32
  %mul = shl i32 %1, 1
  %add3 = add nsw i32 %add, %mul
  call void @llvm.va_end(ptr nonnull %arg1)
  call void @llvm.va_end(ptr nonnull %arg2)
  call void @llvm.lifetime.end.p0(i64 8, ptr nonnull %arg2)
  call void @llvm.lifetime.end.p0(i64 8, ptr nonnull %arg1)
  ret i32 %add3
}

declare void @llvm.lifetime.start.p0(i64 immarg, ptr nocapture)
declare void @llvm.va_start(ptr)
declare void @llvm.va_copy(ptr, ptr)
declare void @llvm.va_end(ptr)
declare void @llvm.lifetime.end.p0(i64 immarg, ptr nocapture)

define i32 @int_stack_va_arg(i32 %one, i32 %two, i32 %three, i32 %four, i32 %five, i32 %six, i32 %seven, i32 %eight, ...) local_unnamed_addr {
  ; CHECK-LABEL: name: int_stack_va_arg
  ; CHECK: bb.0.entry:
  ; CHECK-NEXT:   liveins: $x3, $x4, $x5, $x6, $x7, $x8, $x9, $x10
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   renamable $r11 = LWZ 0, %fixed-stack.0 :: (load (s32) from %fixed-stack.0, align 16)
  ; CHECK-NEXT:   renamable $r3 = nsw ADD4 renamable $r4, renamable $r3, implicit killed $x3, implicit killed $x4
  ; CHECK-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, renamable $r5, implicit killed $x5
  ; CHECK-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, renamable $r6, implicit killed $x6
  ; CHECK-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, renamable $r7, implicit killed $x7
  ; CHECK-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, renamable $r8, implicit killed $x8
  ; CHECK-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, renamable $r9, implicit killed $x9
  ; CHECK-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, renamable $r10, implicit killed $x10
  ; CHECK-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, renamable $r11
  ; CHECK-NEXT:   renamable $r4 = RLWINM killed renamable $r11, 1, 0, 30
  ; CHECK-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, killed renamable $r4, implicit-def $x3
  ; CHECK-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $x3
entry:
  %arg1 = alloca ptr, align 8
  %arg2 = alloca ptr, align 8
  call void @llvm.lifetime.start.p0(i64 8, ptr nonnull %arg1)
  call void @llvm.lifetime.start.p0(i64 8, ptr nonnull %arg2)
  call void @llvm.va_start(ptr nonnull %arg1)
  call void @llvm.va_copy(ptr nonnull %arg2, ptr nonnull %arg1)
  %add = add nsw i32 %two, %one
  %add2 = add nsw i32 %add, %three
  %add3 = add nsw i32 %add2, %four
  %add4 = add nsw i32 %add3, %five
  %add5 = add nsw i32 %add4, %six
  %add6 = add nsw i32 %add5, %seven
  %add7 = add nsw i32 %add6, %eight
  %0 = va_arg ptr %arg1, i32
  %add8 = add nsw i32 %add7, %0
  %1 = va_arg ptr %arg2, i32
  %mul = shl i32 %1, 1
  %add10 = add nsw i32 %add8, %mul
  call void @llvm.va_end(ptr nonnull %arg1)
  call void @llvm.va_end(ptr nonnull %arg2)
  call void @llvm.lifetime.end.p0(i64 8, ptr nonnull %arg2)
  call void @llvm.lifetime.end.p0(i64 8, ptr nonnull %arg1)
  ret i32 %add10
}

define double @double_va_arg(double %a, ...) local_unnamed_addr  {
  ; CHECK-LABEL: name: double_va_arg
  ; CHECK: bb.0.entry:
  ; CHECK-NEXT:   liveins: $f1, $x4, $x5, $x6, $x7, $x8, $x9, $x10
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   renamable $x3 = ADDI8 %fixed-stack.0, 0
  ; CHECK-NEXT:   STD killed renamable $x6, 16, %fixed-stack.0 :: (store (s64))
  ; CHECK-NEXT:   STD killed renamable $x7, 24, %fixed-stack.0 :: (store (s64))
  ; CHECK-NEXT:   STD killed renamable $x8, 32, %fixed-stack.0 :: (store (s64))
  ; CHECK-NEXT:   STD killed renamable $x9, 40, %fixed-stack.0 :: (store (s64))
  ; CHECK-NEXT:   STD killed renamable $x10, 48, %fixed-stack.0 :: (store (s64))
  ; CHECK-NEXT:   STD renamable $x3, 0, %stack.1.arg2 :: (store (s64) into %ir.arg2)
  ; CHECK-NEXT:   renamable $x6 = LD 0, %stack.1.arg2 :: (load (s64) from %ir.arg2)
  ; CHECK-NEXT:   renamable $x7 = ADDI8 %fixed-stack.0, 8
  ; CHECK-NEXT:   STD killed renamable $x4, 0, %fixed-stack.0 :: (store (s64) into %fixed-stack.0)
  ; CHECK-NEXT:   STD killed renamable $x3, 0, %stack.0.arg1 :: (store (s64) into %ir.arg1)
  ; CHECK-NEXT:   STD killed renamable $x7, 0, %stack.0.arg1 :: (store (s64) into %ir.arg1)
  ; CHECK-NEXT:   renamable $f0 = LFD 0, %fixed-stack.0 :: (load (s64))
  ; CHECK-NEXT:   renamable $x3 = ADDI8 renamable $x6, 8
  ; CHECK-NEXT:   STD killed renamable $x5, 8, %fixed-stack.0 :: (store (s64) into %fixed-stack.0 + 8)
  ; CHECK-NEXT:   STD killed renamable $x3, 0, %stack.1.arg2 :: (store (s64) into %ir.arg2)
  ; CHECK-NEXT:   renamable $f2 = LFD 0, killed renamable $x6 :: (load (s64))
  ; CHECK-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f1, implicit $rm
  ; CHECK-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f2, renamable $f2, implicit $rm
  ; CHECK-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f0, killed renamable $f1, implicit $rm
  ; CHECK-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $f1
entry:
  %arg1 = alloca ptr, align 8
  %arg2 = alloca ptr, align 8
  call void @llvm.lifetime.start.p0(i64 8, ptr nonnull %arg1)
  call void @llvm.lifetime.start.p0(i64 8, ptr nonnull %arg2)
  call void @llvm.va_start(ptr nonnull %arg1)
  call void @llvm.va_copy(ptr nonnull %arg2, ptr nonnull %arg1)
  %0 = va_arg ptr %arg1, double
  %add = fadd double %0, %a
  %1 = va_arg ptr %arg2, double
  %mul = fmul double %1, 2.000000e+00
  %add3 = fadd double %add, %mul
  call void @llvm.va_end(ptr nonnull %arg1)
  call void @llvm.va_end(ptr nonnull %arg2)
  call void @llvm.lifetime.end.p0(i64 8, ptr nonnull %arg2)
  call void @llvm.lifetime.end.p0(i64 8, ptr nonnull %arg1)
  ret double %add3
}

define double @double_stack_va_arg(double %one, double %two, double %three, double %four, double %five, double %six, double %seven, double %eight, double %nine, double %ten, double %eleven, double %twelve, double %thirteen, ...) local_unnamed_addr  {
  ; CHECK-LABEL: name: double_stack_va_arg
  ; CHECK: bb.0.entry:
  ; CHECK-NEXT:   liveins: $f1, $f2, $f3, $f4, $f5, $f6, $f7, $f8, $f9, $f10, $f11, $f12, $f13
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   renamable $f0 = LFD 0, %fixed-stack.0 :: (load (s64))
  ; CHECK-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f2, implicit $rm
  ; CHECK-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f3, implicit $rm
  ; CHECK-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f4, implicit $rm
  ; CHECK-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f5, implicit $rm
  ; CHECK-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f6, implicit $rm
  ; CHECK-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f7, implicit $rm
  ; CHECK-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f8, implicit $rm
  ; CHECK-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f9, implicit $rm
  ; CHECK-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f10, implicit $rm
  ; CHECK-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f11, implicit $rm
  ; CHECK-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f12, implicit $rm
  ; CHECK-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f13, implicit $rm
  ; CHECK-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, renamable $f0, implicit $rm
  ; CHECK-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, renamable $f0, implicit $rm
  ; CHECK-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f0, implicit $rm
  ; CHECK-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $f1
entry:
  %arg1 = alloca ptr, align 8
  %arg2 = alloca ptr, align 8
  call void @llvm.lifetime.start.p0(i64 8, ptr nonnull %arg1)
  call void @llvm.lifetime.start.p0(i64 8, ptr nonnull %arg2)
  call void @llvm.va_start(ptr nonnull %arg1)
  call void @llvm.va_copy(ptr nonnull %arg2, ptr nonnull %arg1)
  %add = fadd double %one, %two
  %add2 = fadd double %add, %three
  %add3 = fadd double %add2, %four
  %add4 = fadd double %add3, %five
  %add5 = fadd double %add4, %six
  %add6 = fadd double %add5, %seven
  %add7 = fadd double %add6, %eight
  %add8 = fadd double %add7, %nine
  %add9 = fadd double %add8, %ten
  %add10 = fadd double %add9, %eleven
  %add11 = fadd double %add10, %twelve
  %add12 = fadd double %add11, %thirteen
  %0 = va_arg ptr %arg1, double
  %add13 = fadd double %add12, %0
  %1 = va_arg ptr %arg2, double
  %mul = fmul double %1, 2.000000e+00
  %add15 = fadd double %add13, %mul
  call void @llvm.lifetime.end.p0(i64 8, ptr nonnull %arg2)
  call void @llvm.lifetime.end.p0(i64 8, ptr nonnull %arg1)
  ret double %add15
}
