; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes="default<O2>" -aa-pipeline=default -S | FileCheck %s

define ptr @f(ptr %buffer, i32 %n) {
; CHECK-LABEL: @f(
; CHECK-NEXT:  coro.return:
; CHECK-NEXT:    [[TMP0:%.*]] = tail call ptr @allocate(i32 12)
; CHECK-NEXT:    store ptr [[TMP0]], ptr [[BUFFER:%.*]], align 8
; CHECK-NEXT:    store i32 [[N:%.*]], ptr [[TMP0]], align 4
; CHECK-NEXT:    ret ptr @f.resume.0
;
entry:
  %id = call token @llvm.coro.id.retcon(i32 8, i32 4, ptr %buffer, ptr @prototype, ptr @allocate, ptr @deallocate)
  %hdl = call ptr @llvm.coro.begin(token %id, ptr null)
  br label %loop

loop:
  %n.val = phi i32 [ %n, %entry ], [ %sum, %resume ]
  %values = call { i32, i1 } (...) @llvm.coro.suspend.retcon.sl_i32i1s()
  %finished = extractvalue { i32, i1 } %values, 1
  br i1 %finished, label %cleanup, label %resume

resume:
  %input = extractvalue { i32, i1 } %values, 0
  %sum = add i32 %n.val, %input
  br label %loop

cleanup:
  call void @print(i32 %n.val)
  call i1 @llvm.coro.end(ptr %hdl, i1 0, token none)
  unreachable
}



define i32 @main() {
; CHECK-LABEL: @main(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = tail call ptr @allocate(i32 12)
; CHECK-NEXT:    store i32 1, ptr [[TMP0]], align 4
; CHECK-NEXT:    [[N_VAL3_SPILL_ADDR_I:%.*]] = getelementptr inbounds nuw i8, ptr [[TMP0]], i64 4
; CHECK-NEXT:    store i32 1, ptr [[N_VAL3_SPILL_ADDR_I]], align 4, !noalias [[META0:![0-9]+]]
; CHECK-NEXT:    [[INPUT_SPILL_ADDR_I:%.*]] = getelementptr inbounds nuw i8, ptr [[TMP0]], i64 8
; CHECK-NEXT:    store i32 2, ptr [[INPUT_SPILL_ADDR_I]], align 4, !noalias [[META0]]
; CHECK-NEXT:    [[INPUT_RELOAD_ADDR13_I:%.*]] = getelementptr inbounds nuw i8, ptr [[TMP0]], i64 8
; CHECK-NEXT:    [[N_VAL3_RELOAD_ADDR11_I:%.*]] = getelementptr inbounds nuw i8, ptr [[TMP0]], i64 4
; CHECK-NEXT:    store i32 3, ptr [[N_VAL3_RELOAD_ADDR11_I]], align 4, !noalias [[META3:![0-9]+]]
; CHECK-NEXT:    store i32 4, ptr [[INPUT_RELOAD_ADDR13_I]], align 4, !noalias [[META3]]
; CHECK-NEXT:    tail call void @print(i32 7), !noalias [[META6:![0-9]+]]
; CHECK-NEXT:    tail call void @deallocate(ptr nonnull [[TMP0]]), !noalias [[META6]]
; CHECK-NEXT:    ret i32 0
;
entry:
  %0 = alloca [8 x i8], align 4
  %prepare = call ptr @llvm.coro.prepare.retcon(ptr @f)
  %cont0 = call ptr %prepare(ptr %0, i32 1)
  %cont1 = call ptr %cont0(ptr %0, i32 2, i1 zeroext false)
  %cont2 = call ptr %cont1(ptr %0, i32 4, i1 zeroext false)
  call ptr %cont2(ptr %0, i32 100, i1 zeroext true)
  ret i32 0
}

;   Unfortunately, we don't seem to fully optimize this right now due
;   to some sort of phase-ordering thing.

declare token @llvm.coro.id.retcon(i32, i32, ptr, ptr, ptr, ptr)
declare ptr @llvm.coro.begin(token, ptr)
declare { i32, i1 } @llvm.coro.suspend.retcon.sl_i32i1s(...)
declare i1 @llvm.coro.end(ptr, i1, token)
declare ptr @llvm.coro.prepare.retcon(ptr)

declare ptr @prototype(ptr, i32, i1 zeroext)

declare noalias ptr @allocate(i32 %size)
declare void @deallocate(ptr %ptr)

declare void @print(i32)

