; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible  < %s | FileCheck %s --check-prefixes=SVE
; RUN: llc -mattr=+sve2 -force-streaming-compatible  < %s | FileCheck %s --check-prefixes=SVE2
; RUN: llc -mattr=+sme -force-streaming  < %s | FileCheck %s --check-prefixes=SVE2
; RUN: llc -force-streaming-compatible < %s | FileCheck %s --check-prefix=NONEON-NOSVE

target datalayout = "e-m:o-i64:64-i128:128-n32:64-S128"

target triple = "aarch64-unknown-linux-gnu"

define void @test_copysign_f16(ptr %ap, ptr %bp) {
; SVE-LABEL: test_copysign_f16:
; SVE:       // %bb.0:
; SVE-NEXT:    ldr h0, [x1]
; SVE-NEXT:    ldr h1, [x0]
; SVE-NEXT:    and z0.h, z0.h, #0x8000
; SVE-NEXT:    and z1.h, z1.h, #0x7fff
; SVE-NEXT:    orr z0.d, z1.d, z0.d
; SVE-NEXT:    str h0, [x0]
; SVE-NEXT:    ret
;
; SVE2-LABEL: test_copysign_f16:
; SVE2:       // %bb.0:
; SVE2-NEXT:    mov z0.h, #32767 // =0x7fff
; SVE2-NEXT:    ldr h1, [x1]
; SVE2-NEXT:    ldr h2, [x0]
; SVE2-NEXT:    bsl z2.d, z2.d, z1.d, z0.d
; SVE2-NEXT:    str h2, [x0]
; SVE2-NEXT:    ret
;
; NONEON-NOSVE-LABEL: test_copysign_f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldr h0, [x0]
; NONEON-NOSVE-NEXT:    ldr h1, [x1]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    str h1, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %a = load half, ptr %ap
  %b = load half, ptr %bp
  %r = call half @llvm.copysign.f16(half %a, half %b)
  store half %r, ptr %ap
  ret void
}

define void @test_copysign_bf16(ptr %ap, ptr %bp) {
; SVE-LABEL: test_copysign_bf16:
; SVE:       // %bb.0:
; SVE-NEXT:    ldr h0, [x1]
; SVE-NEXT:    ldr h1, [x0]
; SVE-NEXT:    and z0.h, z0.h, #0x8000
; SVE-NEXT:    and z1.h, z1.h, #0x7fff
; SVE-NEXT:    orr z0.d, z1.d, z0.d
; SVE-NEXT:    str h0, [x0]
; SVE-NEXT:    ret
;
; SVE2-LABEL: test_copysign_bf16:
; SVE2:       // %bb.0:
; SVE2-NEXT:    mov z0.h, #32767 // =0x7fff
; SVE2-NEXT:    ldr h1, [x1]
; SVE2-NEXT:    ldr h2, [x0]
; SVE2-NEXT:    bsl z2.d, z2.d, z1.d, z0.d
; SVE2-NEXT:    str h2, [x0]
; SVE2-NEXT:    ret
;
; NONEON-NOSVE-LABEL: test_copysign_bf16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldr h0, [x0]
; NONEON-NOSVE-NEXT:    ldr h1, [x1]
; NONEON-NOSVE-NEXT:    fmov w8, s0
; NONEON-NOSVE-NEXT:    str h1, [sp, #12]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #16
; NONEON-NOSVE-NEXT:    fmov s0, w8
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    fmov w8, s0
; NONEON-NOSVE-NEXT:    lsr w8, w8, #16
; NONEON-NOSVE-NEXT:    fmov s0, w8
; NONEON-NOSVE-NEXT:    str h0, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %a = load bfloat, ptr %ap
  %b = load bfloat, ptr %bp
  %r = call bfloat @llvm.copysign.bf16(bfloat %a, bfloat %b)
  store bfloat %r, ptr %ap
  ret void
}

define void @test_copysign_f32(ptr %ap, ptr %bp) {
; SVE-LABEL: test_copysign_f32:
; SVE:       // %bb.0:
; SVE-NEXT:    ldr s0, [x1]
; SVE-NEXT:    ldr s1, [x0]
; SVE-NEXT:    and z0.s, z0.s, #0x80000000
; SVE-NEXT:    and z1.s, z1.s, #0x7fffffff
; SVE-NEXT:    orr z0.d, z1.d, z0.d
; SVE-NEXT:    str s0, [x0]
; SVE-NEXT:    ret
;
; SVE2-LABEL: test_copysign_f32:
; SVE2:       // %bb.0:
; SVE2-NEXT:    mov z0.s, #0x7fffffff
; SVE2-NEXT:    ldr s1, [x1]
; SVE2-NEXT:    ldr s2, [x0]
; SVE2-NEXT:    bsl z2.d, z2.d, z1.d, z0.d
; SVE2-NEXT:    str s2, [x0]
; SVE2-NEXT:    ret
;
; NONEON-NOSVE-LABEL: test_copysign_f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr s0, [x0]
; NONEON-NOSVE-NEXT:    ldr w8, [x1]
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    tst w8, #0x80000000
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    str s0, [x0]
; NONEON-NOSVE-NEXT:    ret
  %a = load float, ptr %ap
  %b = load float, ptr %bp
  %r = call float @llvm.copysign.f32(float %a, float %b)
  store float %r, ptr %ap
  ret void
}

define void @test_copysign_f64(ptr %ap, ptr %bp) {
; SVE-LABEL: test_copysign_f64:
; SVE:       // %bb.0:
; SVE-NEXT:    ldr d0, [x1]
; SVE-NEXT:    ldr d1, [x0]
; SVE-NEXT:    and z0.d, z0.d, #0x8000000000000000
; SVE-NEXT:    and z1.d, z1.d, #0x7fffffffffffffff
; SVE-NEXT:    orr z0.d, z1.d, z0.d
; SVE-NEXT:    str d0, [x0]
; SVE-NEXT:    ret
;
; SVE2-LABEL: test_copysign_f64:
; SVE2:       // %bb.0:
; SVE2-NEXT:    mov z0.d, #0x7fffffffffffffff
; SVE2-NEXT:    ldr d1, [x1]
; SVE2-NEXT:    ldr d2, [x0]
; SVE2-NEXT:    bsl z2.d, z2.d, z1.d, z0.d
; SVE2-NEXT:    str d2, [x0]
; SVE2-NEXT:    ret
;
; NONEON-NOSVE-LABEL: test_copysign_f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr d0, [x0]
; NONEON-NOSVE-NEXT:    ldr x8, [x1]
; NONEON-NOSVE-NEXT:    fabs d0, d0
; NONEON-NOSVE-NEXT:    tst x8, #0x8000000000000000
; NONEON-NOSVE-NEXT:    fneg d1, d0
; NONEON-NOSVE-NEXT:    fcsel d0, d1, d0, ne
; NONEON-NOSVE-NEXT:    str d0, [x0]
; NONEON-NOSVE-NEXT:    ret
  %a = load double, ptr %ap
  %b = load double, ptr %bp
  %r = call double @llvm.copysign.f64(double %a, double %b)
  store double %r, ptr %ap
  ret void
}

;============ f16

define void @test_copysign_v4f16_v4f16(ptr %ap, ptr %bp) {
; SVE-LABEL: test_copysign_v4f16_v4f16:
; SVE:       // %bb.0:
; SVE-NEXT:    ldr d0, [x0]
; SVE-NEXT:    ldr d1, [x1]
; SVE-NEXT:    and z1.h, z1.h, #0x8000
; SVE-NEXT:    and z0.h, z0.h, #0x7fff
; SVE-NEXT:    orr z0.d, z0.d, z1.d
; SVE-NEXT:    str d0, [x0]
; SVE-NEXT:    ret
;
; SVE2-LABEL: test_copysign_v4f16_v4f16:
; SVE2:       // %bb.0:
; SVE2-NEXT:    mov z0.h, #32767 // =0x7fff
; SVE2-NEXT:    ldr d1, [x0]
; SVE2-NEXT:    ldr d2, [x1]
; SVE2-NEXT:    bsl z1.d, z1.d, z2.d, z0.d
; SVE2-NEXT:    str d1, [x0]
; SVE2-NEXT:    ret
;
; NONEON-NOSVE-LABEL: test_copysign_v4f16_v4f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #48
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldr d0, [x1]
; NONEON-NOSVE-NEXT:    ldr d1, [x0]
; NONEON-NOSVE-NEXT:    stp d1, d0, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #38]
; NONEON-NOSVE-NEXT:    str h0, [sp, #20]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    str h0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #34]
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    str h0, [sp, #12]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #32]
; NONEON-NOSVE-NEXT:    str h0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #30]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #46]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #28]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #44]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #26]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #42]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #24]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #40]
; NONEON-NOSVE-NEXT:    str d0, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %a = load <4 x half>, ptr %ap
  %b = load <4 x half>, ptr %bp
  %r = call <4 x half> @llvm.copysign.v4f16(<4 x half> %a, <4 x half> %b)
  store <4 x half> %r, ptr %ap
  ret void
}

define void @test_copysign_v8f16_v8f16(ptr %ap, ptr %bp) {
; SVE-LABEL: test_copysign_v8f16_v8f16:
; SVE:       // %bb.0:
; SVE-NEXT:    ldr q0, [x0]
; SVE-NEXT:    ldr q1, [x1]
; SVE-NEXT:    and z1.h, z1.h, #0x8000
; SVE-NEXT:    and z0.h, z0.h, #0x7fff
; SVE-NEXT:    orr z0.d, z0.d, z1.d
; SVE-NEXT:    str q0, [x0]
; SVE-NEXT:    ret
;
; SVE2-LABEL: test_copysign_v8f16_v8f16:
; SVE2:       // %bb.0:
; SVE2-NEXT:    mov z0.h, #32767 // =0x7fff
; SVE2-NEXT:    ldr q1, [x0]
; SVE2-NEXT:    ldr q2, [x1]
; SVE2-NEXT:    bsl z1.d, z1.d, z2.d, z0.d
; SVE2-NEXT:    str q1, [x0]
; SVE2-NEXT:    ret
;
; NONEON-NOSVE-LABEL: test_copysign_v8f16_v8f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #80
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 80
; NONEON-NOSVE-NEXT:    ldr q0, [x1]
; NONEON-NOSVE-NEXT:    ldr q1, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #62]
; NONEON-NOSVE-NEXT:    str h0, [sp, #28]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    str h0, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #58]
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    str h0, [sp, #20]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #56]
; NONEON-NOSVE-NEXT:    str h0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #54]
; NONEON-NOSVE-NEXT:    str h0, [sp, #12]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #52]
; NONEON-NOSVE-NEXT:    str h0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #50]
; NONEON-NOSVE-NEXT:    str h0, [sp, #4]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #48]
; NONEON-NOSVE-NEXT:    str h0, [sp]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #46]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #78]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #44]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #76]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #42]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #74]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #40]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #72]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #38]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #70]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #36]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #68]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #34]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #66]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #32]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #64]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #64]
; NONEON-NOSVE-NEXT:    str q0, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #80
; NONEON-NOSVE-NEXT:    ret
  %a = load <8 x half>, ptr %ap
  %b = load <8 x half>, ptr %bp
  %r = call <8 x half> @llvm.copysign.v8f16(<8 x half> %a, <8 x half> %b)
  store <8 x half> %r, ptr %ap
  ret void
}

define void @test_copysign_v16f16_v16f16(ptr %ap, ptr %bp) {
; SVE-LABEL: test_copysign_v16f16_v16f16:
; SVE:       // %bb.0:
; SVE-NEXT:    ldp q0, q3, [x1]
; SVE-NEXT:    ldp q1, q2, [x0]
; SVE-NEXT:    and z0.h, z0.h, #0x8000
; SVE-NEXT:    and z3.h, z3.h, #0x8000
; SVE-NEXT:    and z1.h, z1.h, #0x7fff
; SVE-NEXT:    and z2.h, z2.h, #0x7fff
; SVE-NEXT:    orr z0.d, z1.d, z0.d
; SVE-NEXT:    orr z1.d, z2.d, z3.d
; SVE-NEXT:    stp q0, q1, [x0]
; SVE-NEXT:    ret
;
; SVE2-LABEL: test_copysign_v16f16_v16f16:
; SVE2:       // %bb.0:
; SVE2-NEXT:    mov z0.h, #32767 // =0x7fff
; SVE2-NEXT:    ldp q1, q4, [x1]
; SVE2-NEXT:    ldp q2, q3, [x0]
; SVE2-NEXT:    bsl z2.d, z2.d, z1.d, z0.d
; SVE2-NEXT:    bsl z3.d, z3.d, z4.d, z0.d
; SVE2-NEXT:    stp q2, q3, [x0]
; SVE2-NEXT:    ret
;
; NONEON-NOSVE-LABEL: test_copysign_v16f16_v16f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #160
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 160
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q3, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q3, q0, [sp, #96]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #126]
; NONEON-NOSVE-NEXT:    str h0, [sp, #28]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #124]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    str h0, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #122]
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    str h0, [sp, #20]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #120]
; NONEON-NOSVE-NEXT:    str h0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #118]
; NONEON-NOSVE-NEXT:    str h0, [sp, #12]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #116]
; NONEON-NOSVE-NEXT:    str h0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #114]
; NONEON-NOSVE-NEXT:    str h0, [sp, #4]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #112]
; NONEON-NOSVE-NEXT:    str h0, [sp]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #94]
; NONEON-NOSVE-NEXT:    str h0, [sp, #60]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #92]
; NONEON-NOSVE-NEXT:    str h0, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #90]
; NONEON-NOSVE-NEXT:    str h0, [sp, #52]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #88]
; NONEON-NOSVE-NEXT:    str h0, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #86]
; NONEON-NOSVE-NEXT:    str h0, [sp, #44]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #84]
; NONEON-NOSVE-NEXT:    str h0, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #82]
; NONEON-NOSVE-NEXT:    str h0, [sp, #36]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #80]
; NONEON-NOSVE-NEXT:    str h0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #110]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #158]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #108]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #156]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #106]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #154]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #104]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #152]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #102]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #150]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #100]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #148]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #98]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #61]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #146]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #96]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #57]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #144]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #78]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #53]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #142]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #76]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #49]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #140]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #74]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #45]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #138]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #72]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #41]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #136]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #70]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #37]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #134]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #68]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #33]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #132]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #66]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #130]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #64]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #128]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #128]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #160
; NONEON-NOSVE-NEXT:    ret
  %a = load <16 x half>, ptr %ap
  %b = load <16 x half>, ptr %bp
  %r = call <16 x half> @llvm.copysign.v16f16(<16 x half> %a, <16 x half> %b)
  store <16 x half> %r, ptr %ap
  ret void
}

;============ f32

define void @test_copysign_v2f32_v2f32(ptr %ap, ptr %bp) {
; SVE-LABEL: test_copysign_v2f32_v2f32:
; SVE:       // %bb.0:
; SVE-NEXT:    ldr d0, [x0]
; SVE-NEXT:    ldr d1, [x1]
; SVE-NEXT:    and z1.s, z1.s, #0x80000000
; SVE-NEXT:    and z0.s, z0.s, #0x7fffffff
; SVE-NEXT:    orr z0.d, z0.d, z1.d
; SVE-NEXT:    str d0, [x0]
; SVE-NEXT:    ret
;
; SVE2-LABEL: test_copysign_v2f32_v2f32:
; SVE2:       // %bb.0:
; SVE2-NEXT:    mov z0.s, #0x7fffffff
; SVE2-NEXT:    ldr d1, [x0]
; SVE2-NEXT:    ldr d2, [x1]
; SVE2-NEXT:    bsl z1.d, z1.d, z2.d, z0.d
; SVE2-NEXT:    str d1, [x0]
; SVE2-NEXT:    ret
;
; NONEON-NOSVE-LABEL: test_copysign_v2f32_v2f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldr d0, [x0]
; NONEON-NOSVE-NEXT:    ldr d1, [x1]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #12]
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #16]
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    tst w9, #0x80000000
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s2, s1, s0, ne
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #8]
; NONEON-NOSVE-NEXT:    tst w8, #0x80000000
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    stp s0, s2, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    str d0, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %a = load <2 x float>, ptr %ap
  %b = load <2 x float>, ptr %bp
  %r = call <2 x float> @llvm.copysign.v2f32(<2 x float> %a, <2 x float> %b)
  store <2 x float> %r, ptr %ap
  ret void
}

define void @test_copysign_v4f32_v4f32(ptr %ap, ptr %bp) {
; SVE-LABEL: test_copysign_v4f32_v4f32:
; SVE:       // %bb.0:
; SVE-NEXT:    ldr q0, [x0]
; SVE-NEXT:    ldr q1, [x1]
; SVE-NEXT:    and z1.s, z1.s, #0x80000000
; SVE-NEXT:    and z0.s, z0.s, #0x7fffffff
; SVE-NEXT:    orr z0.d, z0.d, z1.d
; SVE-NEXT:    str q0, [x0]
; SVE-NEXT:    ret
;
; SVE2-LABEL: test_copysign_v4f32_v4f32:
; SVE2:       // %bb.0:
; SVE2-NEXT:    mov z0.s, #0x7fffffff
; SVE2-NEXT:    ldr q1, [x0]
; SVE2-NEXT:    ldr q2, [x1]
; SVE2-NEXT:    bsl z1.d, z1.d, z2.d, z0.d
; SVE2-NEXT:    str q1, [x0]
; SVE2-NEXT:    ret
;
; NONEON-NOSVE-LABEL: test_copysign_v4f32_v4f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    ldr q1, [x1]
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #12]
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #24]
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    tst w9, #0x80000000
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s2, s1, s0, ne
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #8]
; NONEON-NOSVE-NEXT:    tst w8, #0x80000000
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #16]
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w9, #0x80000000
; NONEON-NOSVE-NEXT:    stp s0, s2, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #4]
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s2, s1, s0, ne
; NONEON-NOSVE-NEXT:    ldr s0, [sp]
; NONEON-NOSVE-NEXT:    tst w8, #0x80000000
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    stp s0, s2, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    str q0, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %a = load <4 x float>, ptr %ap
  %b = load <4 x float>, ptr %bp
  %r = call <4 x float> @llvm.copysign.v4f32(<4 x float> %a, <4 x float> %b)
  store <4 x float> %r, ptr %ap
  ret void
}

define void @test_copysign_v8f32_v8f32(ptr %ap, ptr %bp) {
; SVE-LABEL: test_copysign_v8f32_v8f32:
; SVE:       // %bb.0:
; SVE-NEXT:    ldp q0, q3, [x1]
; SVE-NEXT:    ldp q1, q2, [x0]
; SVE-NEXT:    and z0.s, z0.s, #0x80000000
; SVE-NEXT:    and z3.s, z3.s, #0x80000000
; SVE-NEXT:    and z1.s, z1.s, #0x7fffffff
; SVE-NEXT:    and z2.s, z2.s, #0x7fffffff
; SVE-NEXT:    orr z0.d, z1.d, z0.d
; SVE-NEXT:    orr z1.d, z2.d, z3.d
; SVE-NEXT:    stp q0, q1, [x0]
; SVE-NEXT:    ret
;
; SVE2-LABEL: test_copysign_v8f32_v8f32:
; SVE2:       // %bb.0:
; SVE2-NEXT:    mov z0.s, #0x7fffffff
; SVE2-NEXT:    ldp q1, q4, [x1]
; SVE2-NEXT:    ldp q2, q3, [x0]
; SVE2-NEXT:    bsl z2.d, z2.d, z1.d, z0.d
; SVE2-NEXT:    bsl z3.d, z3.d, z4.d, z0.d
; SVE2-NEXT:    stp q2, q3, [x0]
; SVE2-NEXT:    ret
;
; NONEON-NOSVE-LABEL: test_copysign_v8f32_v8f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q2, q0, [x0]
; NONEON-NOSVE-NEXT:    ldp q3, q1, [x1]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #44]
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #56]
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    tst w9, #0x80000000
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s2, s1, s0, ne
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #40]
; NONEON-NOSVE-NEXT:    tst w8, #0x80000000
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #48]
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w9, #0x80000000
; NONEON-NOSVE-NEXT:    stp s0, s2, [sp, #88]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #36]
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s2, s1, s0, ne
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #32]
; NONEON-NOSVE-NEXT:    tst w8, #0x80000000
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #24]
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w9, #0x80000000
; NONEON-NOSVE-NEXT:    stp s0, s2, [sp, #80]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #12]
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s2, s1, s0, ne
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #8]
; NONEON-NOSVE-NEXT:    tst w8, #0x80000000
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #16]
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w9, #0x80000000
; NONEON-NOSVE-NEXT:    stp s0, s2, [sp, #72]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #4]
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s2, s1, s0, ne
; NONEON-NOSVE-NEXT:    ldr s0, [sp]
; NONEON-NOSVE-NEXT:    tst w8, #0x80000000
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    stp s0, s2, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %a = load <8 x float>, ptr %ap
  %b = load <8 x float>, ptr %bp
  %r = call <8 x float> @llvm.copysign.v8f32(<8 x float> %a, <8 x float> %b)
  store <8 x float> %r, ptr %ap
  ret void
}

;============ f64

define void @test_copysign_v2f64_v2f64(ptr %ap, ptr %bp) {
; SVE-LABEL: test_copysign_v2f64_v2f64:
; SVE:       // %bb.0:
; SVE-NEXT:    ldr q0, [x0]
; SVE-NEXT:    ldr q1, [x1]
; SVE-NEXT:    and z1.d, z1.d, #0x8000000000000000
; SVE-NEXT:    and z0.d, z0.d, #0x7fffffffffffffff
; SVE-NEXT:    orr z0.d, z0.d, z1.d
; SVE-NEXT:    str q0, [x0]
; SVE-NEXT:    ret
;
; SVE2-LABEL: test_copysign_v2f64_v2f64:
; SVE2:       // %bb.0:
; SVE2-NEXT:    mov z0.d, #0x7fffffffffffffff
; SVE2-NEXT:    ldr q1, [x0]
; SVE2-NEXT:    ldr q2, [x1]
; SVE2-NEXT:    bsl z1.d, z1.d, z2.d, z0.d
; SVE2-NEXT:    str q1, [x0]
; SVE2-NEXT:    ret
;
; NONEON-NOSVE-LABEL: test_copysign_v2f64_v2f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    ldr q1, [x1]
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp, #16]
; NONEON-NOSVE-NEXT:    fabs d0, d0
; NONEON-NOSVE-NEXT:    tst x9, #0x8000000000000000
; NONEON-NOSVE-NEXT:    fneg d1, d0
; NONEON-NOSVE-NEXT:    fcsel d2, d1, d0, ne
; NONEON-NOSVE-NEXT:    ldr d0, [sp]
; NONEON-NOSVE-NEXT:    tst x8, #0x8000000000000000
; NONEON-NOSVE-NEXT:    fabs d0, d0
; NONEON-NOSVE-NEXT:    fneg d1, d0
; NONEON-NOSVE-NEXT:    fcsel d0, d1, d0, ne
; NONEON-NOSVE-NEXT:    stp d0, d2, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    str q0, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %a = load <2 x double>, ptr %ap
  %b = load <2 x double>, ptr %bp
  %r = call <2 x double> @llvm.copysign.v2f64(<2 x double> %a, <2 x double> %b)
  store <2 x double> %r, ptr %ap
  ret void
}

define void @test_copysign_v4f64_v4f64(ptr %ap, ptr %bp) {
; SVE-LABEL: test_copysign_v4f64_v4f64:
; SVE:       // %bb.0:
; SVE-NEXT:    ldp q0, q3, [x1]
; SVE-NEXT:    ldp q1, q2, [x0]
; SVE-NEXT:    and z0.d, z0.d, #0x8000000000000000
; SVE-NEXT:    and z3.d, z3.d, #0x8000000000000000
; SVE-NEXT:    and z1.d, z1.d, #0x7fffffffffffffff
; SVE-NEXT:    and z2.d, z2.d, #0x7fffffffffffffff
; SVE-NEXT:    orr z0.d, z1.d, z0.d
; SVE-NEXT:    orr z1.d, z2.d, z3.d
; SVE-NEXT:    stp q0, q1, [x0]
; SVE-NEXT:    ret
;
; SVE2-LABEL: test_copysign_v4f64_v4f64:
; SVE2:       // %bb.0:
; SVE2-NEXT:    mov z0.d, #0x7fffffffffffffff
; SVE2-NEXT:    ldp q1, q4, [x1]
; SVE2-NEXT:    ldp q2, q3, [x0]
; SVE2-NEXT:    bsl z2.d, z2.d, z1.d, z0.d
; SVE2-NEXT:    bsl z3.d, z3.d, z4.d, z0.d
; SVE2-NEXT:    stp q2, q3, [x0]
; SVE2-NEXT:    ret
;
; NONEON-NOSVE-LABEL: test_copysign_v4f64_v4f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q2, q0, [x0]
; NONEON-NOSVE-NEXT:    ldp q3, q1, [x1]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #40]
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp, #48]
; NONEON-NOSVE-NEXT:    fabs d0, d0
; NONEON-NOSVE-NEXT:    tst x9, #0x8000000000000000
; NONEON-NOSVE-NEXT:    fneg d1, d0
; NONEON-NOSVE-NEXT:    fcsel d2, d1, d0, ne
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #32]
; NONEON-NOSVE-NEXT:    tst x8, #0x8000000000000000
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp, #16]
; NONEON-NOSVE-NEXT:    fabs d0, d0
; NONEON-NOSVE-NEXT:    fneg d1, d0
; NONEON-NOSVE-NEXT:    fcsel d0, d1, d0, ne
; NONEON-NOSVE-NEXT:    tst x9, #0x8000000000000000
; NONEON-NOSVE-NEXT:    stp d0, d2, [sp, #80]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    fabs d0, d0
; NONEON-NOSVE-NEXT:    fneg d1, d0
; NONEON-NOSVE-NEXT:    fcsel d2, d1, d0, ne
; NONEON-NOSVE-NEXT:    ldr d0, [sp]
; NONEON-NOSVE-NEXT:    tst x8, #0x8000000000000000
; NONEON-NOSVE-NEXT:    fabs d0, d0
; NONEON-NOSVE-NEXT:    fneg d1, d0
; NONEON-NOSVE-NEXT:    fcsel d0, d1, d0, ne
; NONEON-NOSVE-NEXT:    stp d0, d2, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %a = load <4 x double>, ptr %ap
  %b = load <4 x double>, ptr %bp
  %r = call <4 x double> @llvm.copysign.v4f64(<4 x double> %a, <4 x double> %b)
  store <4 x double> %r, ptr %ap
  ret void
}

;============ v2f32

define void @test_copysign_v2f32_v2f64(ptr %ap, ptr %bp) {
; SVE-LABEL: test_copysign_v2f32_v2f64:
; SVE:       // %bb.0:
; SVE-NEXT:    ptrue p0.d
; SVE-NEXT:    ldr q0, [x1]
; SVE-NEXT:    ldr d1, [x0]
; SVE-NEXT:    fcvt z0.s, p0/m, z0.d
; SVE-NEXT:    and z1.s, z1.s, #0x7fffffff
; SVE-NEXT:    uzp1 z0.s, z0.s, z0.s
; SVE-NEXT:    and z0.s, z0.s, #0x80000000
; SVE-NEXT:    orr z0.d, z1.d, z0.d
; SVE-NEXT:    str d0, [x0]
; SVE-NEXT:    ret
;
; SVE2-LABEL: test_copysign_v2f32_v2f64:
; SVE2:       // %bb.0:
; SVE2-NEXT:    ptrue p0.d
; SVE2-NEXT:    ldr q0, [x1]
; SVE2-NEXT:    mov z1.s, #0x7fffffff
; SVE2-NEXT:    ldr d2, [x0]
; SVE2-NEXT:    fcvt z0.s, p0/m, z0.d
; SVE2-NEXT:    uzp1 z0.s, z0.s, z0.s
; SVE2-NEXT:    bsl z2.d, z2.d, z0.d, z1.d
; SVE2-NEXT:    str d2, [x0]
; SVE2-NEXT:    ret
;
; NONEON-NOSVE-LABEL: test_copysign_v2f32_v2f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #48
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldr d1, [x0]
; NONEON-NOSVE-NEXT:    ldr q0, [x1]
; NONEON-NOSVE-NEXT:    str d1, [sp, #8]
; NONEON-NOSVE-NEXT:    str q0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #12]
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp, #16]
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    tst x9, #0x8000000000000000
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s2, s1, s0, ne
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #8]
; NONEON-NOSVE-NEXT:    tst x8, #0x8000000000000000
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    stp s0, s2, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #40]
; NONEON-NOSVE-NEXT:    str d0, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %a = load <2 x float>, ptr %ap
  %b = load <2 x double>, ptr %bp
  %tmp0 = fptrunc <2 x double> %b to <2 x float>
  %r = call <2 x float> @llvm.copysign.v2f32(<2 x float> %a, <2 x float> %tmp0)
  store <2 x float> %r, ptr %ap
  ret void
}

;============ v4f32

; SplitVecOp #1
define void @test_copysign_v4f32_v4f64(ptr %ap, ptr %bp) {
; SVE-LABEL: test_copysign_v4f32_v4f64:
; SVE:       // %bb.0:
; SVE-NEXT:    ldp q0, q1, [x1]
; SVE-NEXT:    ptrue p0.d
; SVE-NEXT:    fcvt z1.s, p0/m, z1.d
; SVE-NEXT:    fcvt z0.s, p0/m, z0.d
; SVE-NEXT:    ptrue p0.s, vl2
; SVE-NEXT:    uzp1 z1.s, z1.s, z1.s
; SVE-NEXT:    uzp1 z0.s, z0.s, z0.s
; SVE-NEXT:    splice z0.s, p0, z0.s, z1.s
; SVE-NEXT:    ldr q1, [x0]
; SVE-NEXT:    and z1.s, z1.s, #0x7fffffff
; SVE-NEXT:    and z0.s, z0.s, #0x80000000
; SVE-NEXT:    orr z0.d, z1.d, z0.d
; SVE-NEXT:    str q0, [x0]
; SVE-NEXT:    ret
;
; SVE2-LABEL: test_copysign_v4f32_v4f64:
; SVE2:       // %bb.0:
; SVE2-NEXT:    ldp q1, q0, [x1]
; SVE2-NEXT:    ptrue p0.d
; SVE2-NEXT:    fcvt z0.s, p0/m, z0.d
; SVE2-NEXT:    fcvt z1.s, p0/m, z1.d
; SVE2-NEXT:    ptrue p0.s, vl2
; SVE2-NEXT:    uzp1 z3.s, z0.s, z0.s
; SVE2-NEXT:    uzp1 z2.s, z1.s, z1.s
; SVE2-NEXT:    mov z1.s, #0x7fffffff
; SVE2-NEXT:    splice z0.s, p0, { z2.s, z3.s }
; SVE2-NEXT:    ldr q2, [x0]
; SVE2-NEXT:    bsl z2.d, z2.d, z0.d, z1.d
; SVE2-NEXT:    str q2, [x0]
; SVE2-NEXT:    ret
;
; NONEON-NOSVE-LABEL: test_copysign_v4f32_v4f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x1]
; NONEON-NOSVE-NEXT:    ldr q2, [x0]
; NONEON-NOSVE-NEXT:    str q2, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #12]
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp, #32]
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    tst x9, #0x8000000000000000
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s2, s1, s0, ne
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #8]
; NONEON-NOSVE-NEXT:    tst x8, #0x8000000000000000
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp, #16]
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst x9, #0x8000000000000000
; NONEON-NOSVE-NEXT:    stp s0, s2, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #4]
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s2, s1, s0, ne
; NONEON-NOSVE-NEXT:    ldr s0, [sp]
; NONEON-NOSVE-NEXT:    tst x8, #0x8000000000000000
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    stp s0, s2, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    str q0, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %a = load <4 x float>, ptr %ap
  %b = load <4 x double>, ptr %bp
  %tmp0 = fptrunc <4 x double> %b to <4 x float>
  %r = call <4 x float> @llvm.copysign.v4f32(<4 x float> %a, <4 x float> %tmp0)
  store <4 x float> %r, ptr %ap
  ret void
}

;============ v2f64

define void @test_copysign_v2f64_v2f32(ptr %ap, ptr %bp) {
; SVE-LABEL: test_copysign_v2f64_v2f32:
; SVE:       // %bb.0:
; SVE-NEXT:    ptrue p0.d, vl2
; SVE-NEXT:    ldr q0, [x0]
; SVE-NEXT:    ld1w { z1.d }, p0/z, [x1]
; SVE-NEXT:    and z0.d, z0.d, #0x7fffffffffffffff
; SVE-NEXT:    fcvt z1.d, p0/m, z1.s
; SVE-NEXT:    and z1.d, z1.d, #0x8000000000000000
; SVE-NEXT:    orr z0.d, z0.d, z1.d
; SVE-NEXT:    str q0, [x0]
; SVE-NEXT:    ret
;
; SVE2-LABEL: test_copysign_v2f64_v2f32:
; SVE2:       // %bb.0:
; SVE2-NEXT:    ptrue p0.d, vl2
; SVE2-NEXT:    mov z1.d, #0x7fffffffffffffff
; SVE2-NEXT:    ldr q2, [x0]
; SVE2-NEXT:    ld1w { z0.d }, p0/z, [x1]
; SVE2-NEXT:    fcvt z0.d, p0/m, z0.s
; SVE2-NEXT:    bsl z2.d, z2.d, z0.d, z1.d
; SVE2-NEXT:    str q2, [x0]
; SVE2-NEXT:    ret
;
; NONEON-NOSVE-LABEL: test_copysign_v2f64_v2f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #48
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldr q1, [x0]
; NONEON-NOSVE-NEXT:    ldr d0, [x1]
; NONEON-NOSVE-NEXT:    str q1, [sp]
; NONEON-NOSVE-NEXT:    str d0, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #24]
; NONEON-NOSVE-NEXT:    fabs d0, d0
; NONEON-NOSVE-NEXT:    tst w9, #0x80000000
; NONEON-NOSVE-NEXT:    fneg d1, d0
; NONEON-NOSVE-NEXT:    fcsel d2, d1, d0, ne
; NONEON-NOSVE-NEXT:    ldr d0, [sp]
; NONEON-NOSVE-NEXT:    tst w8, #0x80000000
; NONEON-NOSVE-NEXT:    fabs d0, d0
; NONEON-NOSVE-NEXT:    fneg d1, d0
; NONEON-NOSVE-NEXT:    fcsel d0, d1, d0, ne
; NONEON-NOSVE-NEXT:    stp d0, d2, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    str q0, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %a = load <2 x double>, ptr %ap
  %b = load < 2 x float>, ptr %bp
  %tmp0 = fpext <2 x float> %b to <2 x double>
  %r = call <2 x double> @llvm.copysign.v2f64(<2 x double> %a, <2 x double> %tmp0)
  store <2 x double> %r, ptr %ap
  ret void
}

;============ v4f64

; SplitVecRes mismatched
define void @test_copysign_v4f64_v4f32(ptr %ap, ptr %bp) {
; SVE-LABEL: test_copysign_v4f64_v4f32:
; SVE:       // %bb.0:
; SVE-NEXT:    ptrue p0.d, vl2
; SVE-NEXT:    mov x8, #2 // =0x2
; SVE-NEXT:    ldp q2, q3, [x0]
; SVE-NEXT:    ld1w { z0.d }, p0/z, [x1]
; SVE-NEXT:    ld1w { z1.d }, p0/z, [x1, x8, lsl #2]
; SVE-NEXT:    and z2.d, z2.d, #0x7fffffffffffffff
; SVE-NEXT:    and z3.d, z3.d, #0x7fffffffffffffff
; SVE-NEXT:    fcvt z0.d, p0/m, z0.s
; SVE-NEXT:    fcvt z1.d, p0/m, z1.s
; SVE-NEXT:    and z0.d, z0.d, #0x8000000000000000
; SVE-NEXT:    and z1.d, z1.d, #0x8000000000000000
; SVE-NEXT:    orr z0.d, z2.d, z0.d
; SVE-NEXT:    orr z1.d, z3.d, z1.d
; SVE-NEXT:    stp q0, q1, [x0]
; SVE-NEXT:    ret
;
; SVE2-LABEL: test_copysign_v4f64_v4f32:
; SVE2:       // %bb.0:
; SVE2-NEXT:    ptrue p0.d, vl2
; SVE2-NEXT:    mov x8, #2 // =0x2
; SVE2-NEXT:    mov z2.d, #0x7fffffffffffffff
; SVE2-NEXT:    ldp q3, q4, [x0]
; SVE2-NEXT:    ld1w { z0.d }, p0/z, [x1]
; SVE2-NEXT:    ld1w { z1.d }, p0/z, [x1, x8, lsl #2]
; SVE2-NEXT:    fcvt z0.d, p0/m, z0.s
; SVE2-NEXT:    fcvt z1.d, p0/m, z1.s
; SVE2-NEXT:    bsl z3.d, z3.d, z0.d, z2.d
; SVE2-NEXT:    bsl z4.d, z4.d, z1.d, z2.d
; SVE2-NEXT:    stp q3, q4, [x0]
; SVE2-NEXT:    ret
;
; NONEON-NOSVE-LABEL: test_copysign_v4f64_v4f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q1, q2, [x0]
; NONEON-NOSVE-NEXT:    ldr q0, [x1]
; NONEON-NOSVE-NEXT:    stp q0, q2, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp d0, d2, [sp, #16]
; NONEON-NOSVE-NEXT:    str q1, [sp]
; NONEON-NOSVE-NEXT:    stp d2, d0, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #40]
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #48]
; NONEON-NOSVE-NEXT:    fabs d0, d0
; NONEON-NOSVE-NEXT:    tst w9, #0x80000000
; NONEON-NOSVE-NEXT:    fneg d1, d0
; NONEON-NOSVE-NEXT:    fcsel d2, d1, d0, ne
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #32]
; NONEON-NOSVE-NEXT:    tst w8, #0x80000000
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #56]
; NONEON-NOSVE-NEXT:    fabs d0, d0
; NONEON-NOSVE-NEXT:    fneg d1, d0
; NONEON-NOSVE-NEXT:    fcsel d0, d1, d0, ne
; NONEON-NOSVE-NEXT:    tst w9, #0x80000000
; NONEON-NOSVE-NEXT:    stp d0, d2, [sp, #64]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    fabs d0, d0
; NONEON-NOSVE-NEXT:    fneg d1, d0
; NONEON-NOSVE-NEXT:    fcsel d2, d1, d0, ne
; NONEON-NOSVE-NEXT:    ldr d0, [sp]
; NONEON-NOSVE-NEXT:    tst w8, #0x80000000
; NONEON-NOSVE-NEXT:    fabs d0, d0
; NONEON-NOSVE-NEXT:    fneg d1, d0
; NONEON-NOSVE-NEXT:    fcsel d0, d1, d0, ne
; NONEON-NOSVE-NEXT:    stp d0, d2, [sp, #80]
; NONEON-NOSVE-NEXT:    ldp q1, q0, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %a = load <4 x double>, ptr %ap
  %b = load <4 x float>, ptr %bp
  %tmp0 = fpext <4 x float> %b to <4 x double>
  %r = call <4 x double> @llvm.copysign.v4f64(<4 x double> %a, <4 x double> %tmp0)
  store <4 x double> %r, ptr %ap
  ret void
}

;============ v4f16

define void @test_copysign_v4f16_v4f32(ptr %ap, ptr %bp) {
; SVE-LABEL: test_copysign_v4f16_v4f32:
; SVE:       // %bb.0:
; SVE-NEXT:    ptrue p0.s
; SVE-NEXT:    ldr q0, [x1]
; SVE-NEXT:    ldr d1, [x0]
; SVE-NEXT:    fcvt z0.h, p0/m, z0.s
; SVE-NEXT:    and z1.h, z1.h, #0x7fff
; SVE-NEXT:    uzp1 z0.h, z0.h, z0.h
; SVE-NEXT:    and z0.h, z0.h, #0x8000
; SVE-NEXT:    orr z0.d, z1.d, z0.d
; SVE-NEXT:    str d0, [x0]
; SVE-NEXT:    ret
;
; SVE2-LABEL: test_copysign_v4f16_v4f32:
; SVE2:       // %bb.0:
; SVE2-NEXT:    ptrue p0.s
; SVE2-NEXT:    ldr q0, [x1]
; SVE2-NEXT:    mov z1.h, #32767 // =0x7fff
; SVE2-NEXT:    ldr d2, [x0]
; SVE2-NEXT:    fcvt z0.h, p0/m, z0.s
; SVE2-NEXT:    uzp1 z0.h, z0.h, z0.h
; SVE2-NEXT:    bsl z2.d, z2.d, z0.d, z1.d
; SVE2-NEXT:    str d2, [x0]
; SVE2-NEXT:    ret
;
; NONEON-NOSVE-LABEL: test_copysign_v4f16_v4f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #48
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldr d1, [x0]
; NONEON-NOSVE-NEXT:    ldr q0, [x1]
; NONEON-NOSVE-NEXT:    str d1, [sp, #8]
; NONEON-NOSVE-NEXT:    str q0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #14]
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #24]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    tst w9, #0x80000000
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80000000
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #16]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #46]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #12]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w9, #0x80000000
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #44]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #10]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80000000
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #42]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #8]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #40]
; NONEON-NOSVE-NEXT:    str d0, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %a = load <4 x half>, ptr %ap
  %b = load <4 x float>, ptr %bp
  %tmp0 = fptrunc <4 x float> %b to <4 x half>
  %r = call <4 x half> @llvm.copysign.v4f16(<4 x half> %a, <4 x half> %tmp0)
  store <4 x half> %r, ptr %ap
  ret void
}

define void @test_copysign_v4f16_v4f64(ptr %ap, ptr %bp) {
; SVE-LABEL: test_copysign_v4f16_v4f64:
; SVE:       // %bb.0:
; SVE-NEXT:    ldp q0, q1, [x1]
; SVE-NEXT:    mov z2.d, z1.d[1]
; SVE-NEXT:    mov z3.d, z0.d[1]
; SVE-NEXT:    fcvt h1, d1
; SVE-NEXT:    fcvt h0, d0
; SVE-NEXT:    fcvt h2, d2
; SVE-NEXT:    fcvt h3, d3
; SVE-NEXT:    zip1 z1.h, z1.h, z2.h
; SVE-NEXT:    zip1 z0.h, z0.h, z3.h
; SVE-NEXT:    zip1 z0.s, z0.s, z1.s
; SVE-NEXT:    ldr d1, [x0]
; SVE-NEXT:    and z1.h, z1.h, #0x7fff
; SVE-NEXT:    and z0.h, z0.h, #0x8000
; SVE-NEXT:    orr z0.d, z1.d, z0.d
; SVE-NEXT:    str d0, [x0]
; SVE-NEXT:    ret
;
; SVE2-LABEL: test_copysign_v4f16_v4f64:
; SVE2:       // %bb.0:
; SVE2-NEXT:    ldp q0, q1, [x1]
; SVE2-NEXT:    mov z2.d, z1.d[1]
; SVE2-NEXT:    mov z3.d, z0.d[1]
; SVE2-NEXT:    fcvt h1, d1
; SVE2-NEXT:    fcvt h0, d0
; SVE2-NEXT:    fcvt h2, d2
; SVE2-NEXT:    fcvt h3, d3
; SVE2-NEXT:    zip1 z1.h, z1.h, z2.h
; SVE2-NEXT:    zip1 z0.h, z0.h, z3.h
; SVE2-NEXT:    mov z2.h, #32767 // =0x7fff
; SVE2-NEXT:    zip1 z0.s, z0.s, z1.s
; SVE2-NEXT:    ldr d1, [x0]
; SVE2-NEXT:    bsl z1.d, z1.d, z0.d, z2.d
; SVE2-NEXT:    str d1, [x0]
; SVE2-NEXT:    ret
;
; NONEON-NOSVE-LABEL: test_copysign_v4f16_v4f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x1]
; NONEON-NOSVE-NEXT:    ldr d2, [x0]
; NONEON-NOSVE-NEXT:    str d2, [sp, #8]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #14]
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp, #32]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    tst x9, #0x8000000000000000
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst x8, #0x8000000000000000
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp, #16]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #62]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #12]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst x9, #0x8000000000000000
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #60]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #10]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst x8, #0x8000000000000000
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #58]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #8]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #56]
; NONEON-NOSVE-NEXT:    str d0, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %a = load <4 x half>, ptr %ap
  %b = load <4 x double>, ptr %bp
  %tmp0 = fptrunc <4 x double> %b to <4 x half>
  %r = call <4 x half> @llvm.copysign.v4f16(<4 x half> %a, <4 x half> %tmp0)
  store <4 x half> %r, ptr %ap
  ret void
}

;============ v8f16

define void @test_copysign_v8f16_v8f32(ptr %ap, ptr %bp) {
; SVE-LABEL: test_copysign_v8f16_v8f32:
; SVE:       // %bb.0:
; SVE-NEXT:    ldp q0, q1, [x1]
; SVE-NEXT:    ptrue p0.s
; SVE-NEXT:    fcvt z1.h, p0/m, z1.s
; SVE-NEXT:    fcvt z0.h, p0/m, z0.s
; SVE-NEXT:    ptrue p0.h, vl4
; SVE-NEXT:    uzp1 z1.h, z1.h, z1.h
; SVE-NEXT:    uzp1 z0.h, z0.h, z0.h
; SVE-NEXT:    splice z0.h, p0, z0.h, z1.h
; SVE-NEXT:    ldr q1, [x0]
; SVE-NEXT:    and z1.h, z1.h, #0x7fff
; SVE-NEXT:    and z0.h, z0.h, #0x8000
; SVE-NEXT:    orr z0.d, z1.d, z0.d
; SVE-NEXT:    str q0, [x0]
; SVE-NEXT:    ret
;
; SVE2-LABEL: test_copysign_v8f16_v8f32:
; SVE2:       // %bb.0:
; SVE2-NEXT:    ldp q1, q0, [x1]
; SVE2-NEXT:    ptrue p0.s
; SVE2-NEXT:    fcvt z0.h, p0/m, z0.s
; SVE2-NEXT:    fcvt z1.h, p0/m, z1.s
; SVE2-NEXT:    ptrue p0.h, vl4
; SVE2-NEXT:    uzp1 z3.h, z0.h, z0.h
; SVE2-NEXT:    uzp1 z2.h, z1.h, z1.h
; SVE2-NEXT:    mov z1.h, #32767 // =0x7fff
; SVE2-NEXT:    splice z0.h, p0, { z2.h, z3.h }
; SVE2-NEXT:    ldr q2, [x0]
; SVE2-NEXT:    bsl z2.d, z2.d, z0.d, z1.d
; SVE2-NEXT:    str q2, [x0]
; SVE2-NEXT:    ret
;
; NONEON-NOSVE-LABEL: test_copysign_v8f16_v8f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x1]
; NONEON-NOSVE-NEXT:    ldr q2, [x0]
; NONEON-NOSVE-NEXT:    str q2, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #14]
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #40]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    tst w9, #0x80000000
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80000000
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #32]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #62]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #12]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w9, #0x80000000
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #60]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #10]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80000000
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #24]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #58]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #8]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w9, #0x80000000
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #6]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80000000
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #16]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #54]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #4]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w9, #0x80000000
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #52]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #2]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    tst w8, #0x80000000
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #50]
; NONEON-NOSVE-NEXT:    ldr h0, [sp]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fabs s0, s0
; NONEON-NOSVE-NEXT:    fneg s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    str q0, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %a = load <8 x half>, ptr %ap
  %b = load <8 x float>, ptr %bp
  %tmp0 = fptrunc <8 x float> %b to <8 x half>
  %r = call <8 x half> @llvm.copysign.v8f16(<8 x half> %a, <8 x half> %tmp0)
  store <8 x half> %r, ptr %ap
  ret void
}

declare <4 x half> @llvm.copysign.v4f16(<4 x half> %a, <4 x half> %b) #0
declare <8 x half> @llvm.copysign.v8f16(<8 x half> %a, <8 x half> %b) #0
declare <16 x half> @llvm.copysign.v16f16(<16 x half> %a, <16 x half> %b) #0

declare <2 x float> @llvm.copysign.v2f32(<2 x float> %a, <2 x float> %b) #0
declare <4 x float> @llvm.copysign.v4f32(<4 x float> %a, <4 x float> %b) #0
declare <8 x float> @llvm.copysign.v8f32(<8 x float> %a, <8 x float> %b) #0

declare <2 x double> @llvm.copysign.v2f64(<2 x double> %a, <2 x double> %b) #0
declare <4 x double> @llvm.copysign.v4f64(<4 x double> %a, <4 x double> %b) #0
